' Freeware Copyright (C) 1999 by Philipp Lenssen
' http://start.at/the.court

DECLARE SUB handleBird (spr AS ANY, plr AS ANY, st AS ANY)
DECLARE SUB initBird (spr AS ANY, st AS ANY)
DECLARE SUB handleHeli (spr AS ANY, rock AS ANY, st AS ANY)
DECLARE SUB initRock (spr AS ANY, ref AS ANY, st AS ANY)
DECLARE SUB handleRock (spr AS ANY)
DECLARE SUB initHeli (spr AS ANY, st AS ANY)
DECLARE FUNCTION playAgain% ()
DECLARE SUB bgMusic (st AS ANY)
DECLARE SUB handleCloud (spr AS ANY, plr AS ANY, st AS ANY)
DECLARE SUB playSound (nameOf AS STRING, settings AS ANY)
DECLARE SUB handlePoints (st AS ANY)
DECLARE SUB initPal ()
DECLARE SUB initCloud (spr AS ANY)
DECLARE SUB initExpl (spr AS ANY, st AS ANY, sprRef AS ANY)
DECLARE SUB reInitDead (spr() AS ANY, st AS ANY, bodyType AS INTEGER)
DECLARE SUB initPlr (spr AS ANY)
DECLARE SUB handleExpl (spr AS ANY)
DECLARE SUB handleAll (spr() AS ANY, st AS ANY)
DECLARE SUB setPal (i AS INTEGER, r AS INTEGER, g AS INTEGER, b AS INTEGER)
DECLARE SUB handleExplode (n AS INTEGER)
DECLARE SUB handleCollision (spr() AS ANY, st AS ANY)
DECLARE FUNCTION collide% (rct1 AS ANY, rct2 AS ANY)
DECLARE SUB setRect (spr AS ANY, rct AS ANY, border AS INTEGER)
DECLARE SUB initAll (spr() AS ANY, st AS ANY)
DECLARE SUB setSettings (st AS ANY)
DECLARE FUNCTION getKey$ ()
DECLARE SUB action ()
DECLARE SUB handleKey (keyPressed AS STRING, settings AS ANY, plr AS ANY)
DECLARE SUB sprRedrawAll (spr() AS ANY)
DECLARE SUB initBall (spr AS ANY, st AS ANY)
DECLARE SUB handlePlr (spr AS ANY, st AS ANY)
DECLARE SUB handleBall (spr AS ANY, st AS ANY)
DECLARE SUB clearKeybuffer ()
DECLARE SUB drawBody (spr AS ANY, drawType AS INTEGER)
DECLARE SUB reInitDeadAll (spr() AS ANY, st AS ANY)
DECLARE SUB initBomb (spr AS ANY, st AS ANY)
DECLARE SUB handleBomb (spr AS ANY)

CONST false = 0, true = NOT false
CONST minX = 0, minY = 0, maxX = 319, maxY = 199, screenNum = 13, sprSize = 8, border = 20
CONST scoreLeft = 1, scoreTop = 1
CONST colBack = 9, colBorder = 16, colScore = 0, colPlr = 7, colCloud = 11, colBomb = 30, colHeli = 31, colRock = 32, colBird = 33
CONST sprMin = 0, sprMax = 11, sprPlr = 0, sprExpl = 1, sprCloud = 2, sprBomb = 3, sprHeli = 4, sprRock = 5, sprBird = 6
CONST bodyFace = 0, bodyBall = 1, bodyExpl = 2, bodyCloud = 3, bodyBomb = 4, bodyHeli = 5, bodyRock = 6, bodyBird = 7
CONST statusAlive = 1, statusDead = 0, statusDying = 2
CONST drawErase = 0, drawNew = 1
CONST pointsMax = 20000, sprSpeedOrig = 2
CONST exploInit = -2, exploStart = -1, exploHandle = 0
CONST bgMusicString = "cabgcccegcegcegegfegfcaegegcged"

TYPE tpeSprite
  x AS SINGLE
  y AS SINGLE
  oldX AS SINGLE
  oldY AS SINGLE
  spdX AS SINGLE
  spdY AS SINGLE
  spdOldX AS SINGLE
  spdOldY AS SINGLE
  spdLastX AS INTEGER
  spdLastY AS INTEGER
  body AS INTEGER
  col AS INTEGER
  size AS INTEGER
  status AS INTEGER
  energy AS INTEGER
  cell AS INTEGER
  cellMax AS INTEGER
  activity AS STRING * 8
END TYPE

TYPE tpeSettings
  music AS INTEGER
  level AS INTEGER
  points AS INTEGER
  oldPoints AS INTEGER
  showScore AS INTEGER
  gameOver AS INTEGER
  keySpeed AS SINGLE
  sprSpeed AS SINGLE
  explSpeed AS SINGLE
  winning AS INTEGER
  won AS INTEGER
END TYPE

TYPE rect
  x1 AS INTEGER
  y1 AS INTEGER
  x2 AS INTEGER
  y2 AS INTEGER
END TYPE

LOCATE 1: PRINT UCASE$("Luftballons '99 von Philipp fr Lauritz")
LOCATE 3: PRINT "Ziel: Luftballons zerplatzen lassen"
LOCATE 4: PRINT "Steuerung: Pfeiltasten"
LOCATE 5: PRINT "Einstellungen: [M]usik - [S]core - [ESC]ape"
SLEEP 10

DEFINT A-Z
SCREEN screenNum
CLS
RANDOMIZE TIMER

DO
  action
LOOP WHILE playAgain%

CLS
END

DEFSNG A-Z
SUB action

  DIM sprite(sprMin TO sprMax) AS tpeSprite
  DIM settings AS tpeSettings
  DIM keyPressed AS STRING
  DIM clock AS SINGLE
 
  CLS
  initPal
  PAINT (minX, minY), colBack
 
  handleExplode exploInit
 
  setSettings settings
  initAll sprite(), settings

  drawBody sprite(sprPlr), drawNew
  LOCATE scoreTop, scoreLeft: PRINT STRING$(6, " ")
  settings.oldPoints = -1
 
  DO
    clock = TIMER
   
    reInitDeadAll sprite(), settings
    handleKey getKey$, settings, sprite(sprPlr)
   
    handleAll sprite(), settings
    handleCollision sprite(), settings
   
    handlePoints settings
    handleExplode exploHandle
   
    bgMusic settings
    sprRedrawAll sprite()
   
    DO UNTIL clock + .05 - TIMER <= 0: LOOP
  LOOP UNTIL settings.gameOver

  IF settings.won THEN
    CLS : PAINT (minX, minY), colBack
    LOCATE 1, 1: PRINT UCASE$("Glckwunsch! Gewonnen!")
    SLEEP 10
  END IF

END SUB

SUB bgMusic (st AS tpeSettings)
 
  STATIC ctr AS INTEGER, nte AS INTEGER
  ctr = ctr + 1
  IF ctr = 4 THEN ctr = 0
  IF ctr = 0 THEN
    IF nte < LEN(bgMusicString) THEN
      nte = nte + 1
    ELSE
      nte = 1
    END IF
    playSound MID$(bgMusicString, nte, 1), st
  END IF
 
END SUB

SUB clearKeybuffer
  DIM dummy AS STRING
 
  FOR i = 1 TO 3
    dummy = INKEY$
  NEXT
END SUB

FUNCTION collide% (rct1 AS rect, rct2 AS rect)
  DIM leftIn AS INTEGER, rightIn AS INTEGER
  DIM topIn AS INTEGER, bottomIn AS INTEGER
 
  leftIn = rct1.x1 >= rct2.x1 AND rct1.x1 <= rct2.x2
  rightIn = rct1.x2 >= rct2.x1 AND rct1.x2 <= rct2.x2
  topIn = rct1.y1 >= rct2.y1 AND rct1.y1 <= rct2.y2
  bottomIn = rct1.y2 >= rct2.y1 AND rct1.y2 <= rct2.y2

  collide% = (leftIn OR rightIn) AND (topIn OR bottomIn)
END FUNCTION

SUB drawBody (spr AS tpeSprite, drawType AS INTEGER)
  DIM x AS INTEGER, y AS INTEGER, fCol AS INTEGER, bCol AS INTEGER, w AS INTEGER
  DIM spdX AS INTEGER, spdY AS INTEGER
  DIM aOff AS INTEGER
  DIM r AS INTEGER, r2  AS INTEGER
  r = spr.size \ 4
  r2 = spr.size \ 3

  IF drawType = drawNew THEN
    x = spr.x
    y = spr.y
    spdX = spr.spdLastX
    spdY = spr.spdLastY
    fCol = spr.col
    w = 15
    bCol = colBorder
    
    IF spr.energy > 0 THEN
      spr.cell = spr.cell + 1
      IF spr.cell = spr.cellMax THEN spr.cell = 0
    ELSE
      spr.cell = 0
    END IF
  ELSEIF drawType = drawErase THEN
    x = spr.oldX
    y = spr.oldY
    spdX = spr.spdOldX
    spdY = spr.spdOldY

    fCol = colBack
    w = colBack
    bCol = colBack
  END IF

  SELECT CASE spr.body
    CASE bodyFace
      ' head
      LINE (x - spr.size, y - spr.size)-(x + spr.size - r2 - 1, y + spr.size - r2), fCol, BF
      LINE (x - spr.size + r2, y - spr.size)-(x + spr.size - r2, y + spr.size), fCol, BF
      LINE (x + spr.size - r2 + 1, y - spr.size)-(x + spr.size, y + spr.size - r2), fCol, BF
      ' eyes
      IF spr.activity = "blinking" THEN aOff = 2
      IF spr.activity = "bird____" THEN
        LINE (x - spr.size \ 2 - 1 + spdX / 3, y - spr.size \ 2 - 1 + spdY / 3 + aOff + RND * 2 - 1)-STEP(2, 5 - aOff * 2 + RND * 2 - 1), bCol, BF
        LINE (x + spr.size \ 2 - 1 + spdX / 3, y - spr.size \ 2 - 1 + spdY / 3 + aOff + RND * 2 - 1)-STEP(2, 5 - aOff * 2 + RND * 2 - 1), bCol, BF
      ELSE
        LINE (x - spr.size \ 2 - 1 + spdX / 3, y - spr.size \ 2 - 1 + spdY / 3 + aOff)-STEP(2, 5 - aOff * 2), bCol, BF
        LINE (x + spr.size \ 2 - 1 + spdX / 3, y - spr.size \ 2 - 1 + spdY / 3 + aOff)-STEP(2, 5 - aOff * 2), bCol, BF
      END IF
      ' mouth
      IF spr.activity = "blowing_" OR spr.activity = "bird____" THEN
        aOff = 2
      ELSE
        aOff = 0
      END IF
      LINE (x - spr.size \ 2 + spdX / 3 + aOff, y + spr.size \ 2 - spr.cell + SGN(spdY) * 2 - (aOff - 1))-STEP(spr.size - aOff * 2, 1 + spr.cell * 2 + aOff), w, BF
   
    CASE bodyBall
      LINE (x - spr.size, y - spr.size + r2)-(x + spr.size, y + spr.size - r2), fCol, BF
     
      LINE (x - spr.size + r2, y - spr.size)-(x + spr.size - r2, y - spr.size + r2), fCol, BF
      LINE (x - spr.size + r2, y + spr.size - r2)-(x + spr.size - r2, y + spr.size), fCol, BF

      LINE (x - spr.size \ 2, y - spr.size \ 2)-STEP(spr.size \ 3, spr.size \ 3), w, BF
      LINE (x - 1, y + spr.size)-STEP(2, spr.size), bCol, BF

    CASE bodyExpl
      LINE (x - (spr.size + spr.cell * 3), y - (spr.size + spr.cell * 3))-STEP(r, r), fCol, BF
      LINE (x + (spr.size + spr.cell * 3), y - (spr.size + spr.cell * 3))-STEP(r, r), fCol, BF
      LINE (x - (spr.size + spr.cell * 3), y + (spr.size + spr.cell * 3))-STEP(r, r), fCol, BF
      LINE (x + (spr.size + spr.cell * 3), y + (spr.size + spr.cell * 3))-STEP(r, r), fCol, BF

    CASE bodyCloud
      LINE (x - (spr.size - r), y - r + spr.cell * 2)-(x, y + spr.cell * 2 - 1), fCol, BF
      LINE (x + r, y - r + spr.cell * 2)-(x + (spr.size - r), y + spr.cell * 2 - 1), fCol, BF
      LINE (x - spr.size, y + spr.cell * 2)-(x + spr.size, y + r + spr.cell * 2), fCol, BF
    
    CASE bodyBomb

      IF y > 0 THEN
        LINE (x - spr.size, y - spr.size + r2)-(x + spr.size, y + spr.size - r2), fCol, BF
      
        LINE (x - spr.size + r2, y - spr.size)-(x + spr.size - r2, y - spr.size + r2), fCol, BF
        LINE (x - spr.size + r2, y + spr.size - r2)-(x + spr.size - r2, y + spr.size), fCol, BF
   
        LINE (x - spr.size \ 2, y - spr.size \ 2)-STEP(spr.size \ 3, spr.size \ 3), w, BF
        LINE (x - 1, y - (spr.size * 2 - r2) + 1)-(x + 1, y - (spr.size + 1)), bCol, BF
        
        LINE (x - (1 + spr.cell), y - spr.size * 2)-(x + 1 + spr.cell, y - (spr.size * 2 - r2)), w, BF
      END IF
   
    CASE bodyHeli
      IF spr.x + spr.size >= minX AND spr.y + spr.size >= minY THEN
        'left
        LINE (x - (spr.size * 2 + 3), y - r2)-(x - (spr.size * 2 - 3), y), fCol, BF
        LINE (x - (spr.size * 2 - 4), y)-(x - spr.size - 1, y + r2), fCol, BF
        ' mid
        LINE (x - spr.size, y - spr.size \ 2)-(x + spr.size, y + spr.size - r2), fCol, BF
        LINE (x, y)-STEP(spr.size \ 2, -r), w, BF
        ' top
        IF spr.cell = 1 THEN
          LINE (x - spr.size, y - spr.size)-(x + spr.size, y - spr.size + 2), w, BF
        ELSE
          LINE (x - spr.size, y - spr.size)-(x + spr.size, y - spr.size + 2), bCol, BF
        END IF
     
      END IF
    CASE bodyRock
      ' rocket
      LINE (x - spr.size, y - r2)-(x + spr.size, y + r2), fCol, BF

    CASE bodyBird
      LINE (x - (spr.size + r), y - r + spr.cell * 2)-(x - (r + 1), y + spr.cell * 2), fCol, BF
      LINE (x - r, y)-(x + r, y + spr.size \ 2), bCol, BF
      LINE (x + r + 1, y - r + spr.cell * 2)-(x + spr.size + r, y + spr.cell * 2), fCol, BF
     
  END SELECT

END SUB

FUNCTION getKey$
  DIM i AS INTEGER, retVal AS STRING
 
  SELECT CASE INKEY$
    CASE CHR$(0) + "K": retVal = "left"
    CASE CHR$(0) + "H": retVal = "up"
    CASE CHR$(0) + "M": retVal = "right"
    CASE CHR$(0) + "P": retVal = "down"
    CASE "m": retVal = "music"
    CASE "p": retVal = "pause"
    CASE "s": retVal = "score"
    CASE "1": retVal = "delay down"
    CASE "2": retVal = "delay default"
    CASE "3": retVal = "delay up"
    CASE CHR$(27): retVal = "escape"
  END SELECT
  clearKeybuffer
  getKey$ = retVal

END FUNCTION

SUB handleAll (spr() AS tpeSprite, st AS tpeSettings)
  STATIC deadCtr AS INTEGER
  DIM i AS INTEGER
 
  FOR i = LBOUND(spr) TO UBOUND(spr)
    IF spr(i).status = statusAlive THEN
      SELECT CASE spr(i).body
        CASE bodyFace: handlePlr spr(i), st
        CASE bodyBall: handleBall spr(i), st
        CASE bodyExpl: handleExpl spr(i)
        CASE bodyCloud: handleCloud spr(i), spr(sprPlr), st
        CASE bodyBomb: handleBomb spr(i)
        CASE bodyHeli: handleHeli spr(i), spr(sprRock), st
        CASE bodyRock: handleRock spr(i)
        CASE bodyBird: handleBird spr(i), spr(sprPlr), st
      END SELECT
    ELSEIF i = sprPlr THEN
      deadCtr = deadCtr + 1
      IF deadCtr = 100 THEN st.gameOver = true
    END IF
  NEXT

END SUB

SUB handleBall (spr AS tpeSprite, st AS tpeSettings)
  DIM newX AS SINGLE, newY AS SINGLE
 
  spr.oldX = spr.x: spr.oldY = spr.y

  IF spr.x < minX OR spr.x > maxX THEN spr.spdX = spr.spdX * -1
  newX = spr.x + spr.spdX: newY = spr.y + spr.spdY
 
  IF spr.activity = "freezing" THEN
    newY = newY + INT(RND * st.sprSpeed)
  END IF
 
  IF (newY <= minY - spr.size * 2) THEN spr.status = statusDying

  spr.x = newX: spr.y = newY

END SUB

SUB handleBird (spr AS tpeSprite, plr AS tpeSprite, st AS tpeSettings)
  DIM newX AS SINGLE, newY AS SINGLE
  DIM bSpdup AS SINGLE
 
  spr.oldX = spr.x: spr.oldY = spr.y

  bSpdup = st.sprSpeed / 50
  IF spr.energy >= 2 THEN
    spr.energy = spr.energy - 1
    IF spr.x < plr.x AND spr.spdX < 3 THEN
      spr.spdX = spr.spdX + bSpdup
    ELSEIF spr.x > plr.x AND spr.spdX > -3 THEN
      spr.spdX = spr.spdX - bSpdup
    END IF
    IF spr.y < plr.y AND spr.spdY < 3 THEN
      spr.spdY = spr.spdY + bSpdup
    ELSEIF spr.y > plr.y AND spr.spdY > -3 THEN
      spr.spdY = spr.spdY - bSpdup
    END IF
  ELSE
    IF spr.x < maxX AND spr.spdX < 3 THEN
      spr.spdX = spr.spdX + bSpdup
    END IF
  END IF
 
  newX = spr.x + spr.spdX: newY = spr.y + spr.spdY

  IF spr.energy = 1 THEN
    IF newX <= minX - spr.size * 2 OR newX >= maxX + spr.size * 2 OR newY <= minY - spr.size * 2 OR newY >= maxY + spr.size * 2 THEN
      spr.status = statusDying
      spr.energy = 0
    END IF
  END IF

  spr.x = newX: spr.y = newY
 
END SUB

SUB handleBomb (spr AS tpeSprite)
  DIM newX AS SINGLE, newY AS SINGLE

  spr.oldX = spr.x: spr.oldY = spr.y

  newX = spr.x + spr.spdX: newY = spr.y + spr.spdY

  IF (newY >= maxY + spr.size * 2) THEN spr.status = statusDying
  spr.x = newX: spr.y = newY

END SUB

SUB handleCloud (spr AS tpeSprite, plr AS tpeSprite, st AS tpeSettings)
  DIM newX AS SINGLE, newY AS SINGLE

  spr.oldX = spr.x: spr.oldY = spr.y

  IF spr.energy > 0 THEN
    spr.energy = spr.energy - 1
    plr.activity = "blowing_"
    IF spr.energy = 0 THEN playSound "blowing", st
    IF plr.x < spr.x THEN
      plr.spdX = -1
    ELSEIF plr.x > spr.x THEN
      plr.spdX = 1
    END IF
    IF plr.y < spr.y THEN
      plr.spdY = -1
    ELSEIF plr.y > spr.y THEN
      plr.spdY = 1
    END IF
  END IF
  IF spr.x < minX - spr.size THEN spr.status = statusDying
  newX = spr.x + spr.spdX: newY = spr.y + spr.spdY
 
  spr.x = newX: spr.y = newY
 
END SUB

SUB handleCollision (spr() AS tpeSprite, st AS tpeSettings)
  DIM i AS INTEGER, n AS INTEGER
  DIM rectPlr AS rect, rectOtr AS rect, rectMe AS rect
 
  IF spr(sprPlr).status = statusAlive THEN

    FOR i = LBOUND(spr) TO UBOUND(spr)
     
      IF spr(i).status = statusAlive THEN

        IF spr(i).body = bodyBall THEN
          setRect spr(sprPlr), rectPlr, 0
          setRect spr(i), rectOtr, 0
          IF collide%(rectPlr, rectOtr) THEN
            playSound "collide", st
            handleExplode exploStart
            spr(i).status = statusDying
            IF st.points <= pointsMax THEN st.points = st.points + 10 * spr(i).size
            initExpl spr(sprExpl), st, spr(i)
            spr(sprPlr).energy = spr(i).size
          ELSE
            setRect spr(sprPlr), rectPlr, spr(sprPlr).size
            IF collide%(rectPlr, rectOtr) THEN
              spr(i).activity = "freezing"
            ELSE
              spr(i).activity = ""
            END IF
          END IF

        ELSEIF spr(i).body = bodyCloud THEN
          setRect spr(sprPlr), rectPlr, 0
          setRect spr(i), rectOtr, 0
          IF collide%(rectPlr, rectOtr) THEN
            IF spr(i).energy = 0 THEN spr(i).energy = 10
          END IF
       
        ELSEIF spr(i).body = bodyBomb OR spr(i).body = bodyRock THEN
          setRect spr(i), rectMe, 0
          FOR n = LBOUND(spr) TO UBOUND(spr)
            IF n <> i AND n <> sprExpl AND n <> sprCloud AND NOT (n = sprHeli AND i = sprRock) AND spr(n).status = statusAlive THEN
              setRect spr(n), rectOtr, 0
              IF collide%(rectMe, rectOtr) THEN
                spr(i).status = statusDying
                spr(n).status = statusDying
                initExpl spr(sprExpl), st, spr(i)
                playSound "bomb", st
                handleExplode exploStart
                EXIT FOR
              END IF
            END IF
          NEXT
         
        ELSEIF spr(i).body = bodyHeli THEN
          IF spr(i).x > minX + spr(i).size THEN
            IF spr(i).x + spr(i).size < spr(sprPlr).x - spr(sprPlr).size THEN
              IF spr(i).y >= spr(sprPlr).y - spr(sprPlr).size AND spr(i).y <= spr(sprPlr).y + spr(sprPlr).size THEN
                spr(i).activity = "shoot___"
              END IF
            END IF
          END IF

        ELSEIF spr(i).body = bodyBird THEN
          setRect spr(sprPlr), rectPlr, 0
          setRect spr(i), rectOtr, 0
          IF collide%(rectPlr, rectOtr) THEN
            spr(sprPlr).activity = "bird____"
            IF st.points > 10 THEN st.points = st.points - 10
            IF RND * 20 >= 18 THEN
              playSound "bird", st
            END IF
          ELSEIF spr(sprPlr).activity = "bird____" THEN
            spr(sprPlr).activity = ""
          END IF

          setRect spr(i), rectMe, 0
          FOR n = LBOUND(spr) TO UBOUND(spr)
            IF spr(n).body = bodyBall AND spr(n).status = statusAlive THEN
              setRect spr(n), rectOtr, 0
              IF collide%(rectMe, rectOtr) THEN
                playSound "collide", st
                handleExplode exploStart
                spr(n).status = statusDying
                initExpl spr(sprExpl), st, spr(i)
              END IF
            END IF
          NEXT

        END IF
      
      END IF
   
    NEXT

  END IF

END SUB

SUB handleExpl (spr AS tpeSprite)
 
  spr.energy = spr.energy - 1
  IF spr.energy = 0 THEN spr.status = statusDying
 
END SUB

SUB handleExplode (n AS INTEGER)
  STATIC cell AS INTEGER
 
  IF n = exploStart THEN cell = 1
  IF cell >= 1 AND cell <= 39 THEN cell = cell + 5
  IF cell >= 40 THEN
    cell = 0
    n = exploInit
  END IF
  IF n = exploInit THEN
    setPal colBack, 20, 20, 63
    setPal colScore, 20, 20, 63
  END IF
  IF cell > 0 THEN
    setPal colBack, 20 + cell, 20, 63
    setPal colScore, 20 + cell, 20, 63
  END IF
 
END SUB

SUB handleHeli (spr AS tpeSprite, rock AS tpeSprite, st AS tpeSettings)
  DIM newX AS SINGLE, newY AS SINGLE

  spr.oldX = spr.x: spr.oldY = spr.y

  newX = spr.x + spr.spdX: newY = spr.y + spr.spdY
 
  IF spr.activity = "shoot___" THEN
    spr.spdX = 0: spr.spdY = 0
    IF RND * 30 >= 26 THEN
      IF rock.status = statusDead THEN
        initRock rock, spr, st
        spr.activity = ""
        spr.energy = 2
      ELSE
        spr.activity = ""
        spr.spdX = 1
      END IF
    ELSE
      newY = newY + 1 - RND * 2
    END IF
  ELSEIF spr.energy > 2 THEN
    IF spr.x < minX + spr.size THEN
      IF spr.spdX = -1 THEN spr.energy = spr.energy - 1
      spr.spdX = 1
    ELSEIF spr.x > maxX - spr.size THEN
      IF spr.spdX = 1 THEN spr.energy = spr.energy - 1
      spr.spdX = -1
    END IF
    IF spr.y < minY + spr.size THEN
      IF spr.spdY = -1 THEN spr.energy = spr.energy - 1
      spr.spdY = 1
    ELSEIF spr.y > maxY - spr.size THEN
      IF spr.spdY = 1 THEN spr.energy = spr.energy - 1
      spr.spdY = -1
    END IF
  ELSEIF spr.energy = 2 THEN
    spr.spdX = 1
    spr.spdY = 0
    spr.energy = 1
  END IF
 
  IF (newX >= maxX + spr.size * 2) THEN spr.status = statusDying
 
  spr.x = newX: spr.y = newY

END SUB

SUB handleKey (keyPressed AS STRING, settings AS tpeSettings, plr AS tpeSprite)

  SELECT CASE keyPressed
   
    CASE "left": plr.spdX = plr.spdX - settings.keySpeed
    CASE "up": plr.spdY = plr.spdY - settings.keySpeed
    CASE "right": plr.spdX = plr.spdX + settings.keySpeed
    CASE "down": plr.spdY = plr.spdY + settings.keySpeed
   
    CASE "pause": DO: LOOP UNTIL INKEY$ <> ""
    CASE "music": settings.music = NOT settings.music
    CASE "score": settings.showScore = NOT settings.showScore
    CASE "escape": settings.gameOver = true

  END SELECT

END SUB

SUB handlePlr (spr AS tpeSprite, st AS tpeSettings)
  DIM newX AS SINGLE, newY AS SINGLE, changed AS INTEGER

  spr.oldX = spr.x: spr.oldY = spr.y
  spr.spdOldX = spr.spdLastX: spr.spdOldY = spr.spdLastY
 
  IF spr.energy > 0 THEN spr.energy = spr.energy - 1

  IF spr.activity <> "bird____" THEN
    IF RND * 100 < 98 THEN
      spr.activity = ""
    ELSE
      spr.activity = "blinking"
    END IF
  END IF
 
  IF st.winning THEN
    spr.size = spr.size + 1
   
    IF spr.x < maxX \ 2 THEN
      spr.spdX = 1
    ELSEIF spr.x > maxX \ 2 THEN
      spr.spdX = -1
    END IF
    IF spr.y < maxY \ 2 THEN
      spr.spdY = 1
    ELSEIF spr.y > maxY \ 2 THEN
      spr.spdY = -1
    END IF

    IF spr.size = sprSize * 8 THEN
      st.won = true
      st.gameOver = true
    END IF
  END IF

  newX = spr.x + spr.spdX: newY = spr.y + spr.spdY
  IF NOT (newX >= minX + border AND newX <= maxX - border) THEN newX = spr.oldX
  IF NOT (newY >= minY + border AND newY <= maxY - border) THEN newY = spr.oldY

  spr.x = newX: spr.y = newY

  spr.spdLastX = spr.spdX: spr.spdLastY = spr.spdY
  spr.spdX = 0: spr.spdY = 0

END SUB

SUB handlePoints (st AS tpeSettings)
  STATIC init AS INTEGER, ctr AS INTEGER
  IF NOT init THEN
    init = NOT init
    setPal colScore, 20, 20, 63
    COLOR colBorder
  END IF
  ctr = ctr + 1
  IF ctr = 10 THEN ctr = 0

  IF st.oldPoints <> st.points OR ctr = 0 THEN
    LOCATE scoreTop, scoreLeft
    IF st.showScore THEN
      PRINT st.points
    ELSE
      PRINT "      "
    END IF
    st.level = st.points \ 1000
    st.sprSpeed = sprSpeedOrig + st.level
    IF st.points >= pointsMax THEN st.winning = true
    st.oldPoints = st.points
  END IF

END SUB

SUB handleRock (spr AS tpeSprite)
  DIM newX AS SINGLE, newY AS SINGLE

  spr.oldX = spr.x: spr.oldY = spr.y

  IF spr.spdY <= spr.spdX THEN spr.spdY = spr.spdY + .005
  newX = spr.x + spr.spdX: newY = spr.y + spr.spdY

  IF (newX >= maxX + spr.size * 2) THEN spr.status = statusDying
  spr.x = newX: spr.y = newY

END SUB

SUB initAll (spr() AS tpeSprite, st AS tpeSettings)
  DIM i AS INTEGER

  FOR i = LBOUND(spr) TO UBOUND(spr)
    IF i = sprPlr THEN
      initPlr spr(i)
    ELSEIF i = sprExpl THEN
      spr(i).body = bodyExpl
      spr(i).status = statusDead
    ELSEIF i = sprCloud THEN
      spr(i).body = bodyCloud
      spr(i).status = statusDead
    ELSEIF i = sprBomb THEN
      spr(i).body = bodyBomb
      spr(i).status = statusDead
    ELSEIF i = sprHeli THEN
      spr(i).body = bodyHeli
      spr(i).status = statusDead
    ELSEIF i = sprRock THEN
      spr(i).body = bodyRock
      spr(i).status = statusDead
    ELSEIF i = sprBird THEN
      spr(i).body = bodyBird
      spr(i).status = statusDead
    ELSE
      initBall spr(i), st
    END IF
  NEXT

END SUB

SUB initBall (spr AS tpeSprite, st AS tpeSettings)
 
  spr.size = sprSize + RND * sprSize
  spr.x = spr.size * 2 + RND * (maxX - spr.size * 4)
  spr.y = maxY + 50 + RND * 500
  spr.spdX = RND * 2 - 1: spr.spdY = -(RND * st.sprSpeed)
  spr.body = bodyBall
  DO
    spr.col = 1 + INT(RND * 14)
  LOOP UNTIL spr.col <> colBorder AND spr.col <> colPlr AND spr.col <> colBack
  spr.status = statusAlive

END SUB

SUB initBird (spr AS tpeSprite, st AS tpeSettings)
 
  spr.spdX = 0
  spr.spdY = 0
  spr.body = bodyBird
  spr.col = colBird
  spr.size = sprSize * 1.5
  spr.status = statusAlive
  spr.cellMax = 2
  spr.energy = 400
  spr.activity = ""
  spr.x = maxX + spr.size * 2 + 100 + RND * 500
  spr.y = maxY \ 2 - RND * (maxY \ 2) + spr.size

END SUB

SUB initBomb (spr AS tpeSprite, st AS tpeSettings)

  spr.size = sprSize
  spr.x = spr.size * 2 + RND * (maxX - spr.size * 4)
  spr.y = -(50 + RND * 500)
  spr.spdX = 0
  spr.spdY = 1 + RND * (st.sprSpeed / 2)
  spr.body = bodyBomb
  spr.col = colBomb
  spr.energy = 1
  spr.status = statusAlive
  spr.cellMax = 2
 
END SUB

SUB initCloud (spr AS tpeSprite)
 
  spr.spdX = -(.5 + RND)
  spr.spdY = 0
  spr.body = bodyCloud
  spr.col = colCloud
  spr.size = sprSize * 4 + RND * sprSize
  spr.status = statusAlive
  spr.cellMax = 2
  spr.energy = 0
  spr.x = maxX + spr.size * 2 + RND * 100
  spr.y = maxY \ 2 - RND * (maxY \ 2) + spr.size

END SUB

SUB initExpl (spr AS tpeSprite, st AS tpeSettings, sprRef AS tpeSprite)
 
  IF spr.status = statusDead THEN
    spr.size = sprRef.size
    spr.x = sprRef.x
    spr.y = sprRef.y
    spr.oldX = spr.x
    spr.oldY = spr.y
    spr.spdX = 0: spr.spdY = 0
    spr.body = bodyExpl
    spr.col = sprRef.col
    spr.status = statusAlive
    spr.cell = 0
    spr.cellMax = 9
    spr.energy = spr.cellMax - 1
  END IF

END SUB

SUB initHeli (spr AS tpeSprite, st AS tpeSettings)
 
  spr.oldX = 0: spr.oldY = 0
  spr.size = sprSize * 2
  SELECT CASE INT(RND * 10)
    CASE IS >= 7 ' top
      spr.x = 100
      spr.y = -(spr.size * 2 + RND * 200)
      spr.spdX = 1
      spr.spdY = 1
    CASE IS >= 4 ' left
      spr.x = -(spr.size * 2 + RND * 200)
      spr.y = 50
      spr.spdX = 1
      spr.spdY = 0
    CASE ELSE ' bottom
      spr.x = 100
      spr.y = maxY + (spr.size * 2 + RND * 200)
      spr.spdX = 1
      spr.spdY = -1
  END SELECT
  spr.activity = ""
  spr.body = bodyHeli
  spr.col = colHeli
  spr.energy = 5 + INT(RND * 3)
  spr.status = statusAlive
  spr.cellMax = 2

END SUB

SUB initPal
 
  setPal colPlr, 44, 25, 20
  setPal colCloud, 20, 30, 63
  setPal colBomb, 10, 10, 12
  setPal colHeli, 30, 10, 12
  setPal colRock, 5, 5, 5
  setPal colBird, 1, 8, 7
 
END SUB

SUB initPlr (spr AS tpeSprite)
 
  spr.x = maxX \ 2: spr.y = maxY \ 2
  spr.spdX = 0: spr.spdY = 0
  spr.body = bodyFace
  spr.col = colPlr
  spr.size = sprSize + 2
  spr.status = statusAlive
  spr.cellMax = 3
 
END SUB

SUB initRock (spr AS tpeSprite, ref AS tpeSprite, st AS tpeSettings)

  spr.oldX = 0: spr.oldY = 0
  spr.size = sprSize
  spr.x = ref.x + ref.size \ 2
  spr.y = ref.y
  spr.spdX = 1 + RND * st.sprSpeed
  spr.spdY = 0
  spr.body = bodyRock
  spr.col = colRock
  spr.energy = 1
  spr.status = statusAlive
  spr.cellMax = 0
 
END SUB

FUNCTION playAgain%
  DIM rval AS STRING
 
  INPUT ; "Nochmal spielen? (n fr nein)", rval
 
  IF LCASE$(rval) = "n" THEN
    playAgain% = false
  ELSE
    playAgain% = true
  END IF
 
END FUNCTION

SUB playSound (nameOf AS STRING, settings AS tpeSettings)
  DIM i AS INTEGER, strng AS STRING

  STATIC init AS INTEGER
  IF NOT init THEN
    init = NOT init
    PLAY "MBT255L64O2"
  END IF
 
  IF settings.music THEN
    SELECT CASE nameOf
      CASE "blowing"
        PLAY "l12O0edl64"
      CASE "collide"
        FOR i = 1 TO 84 STEP 8
          strng = strng + "n" + STR$(i)
        NEXT
        PLAY strng
      CASE "bird"
        PLAY "l12O5edl64"
      CASE "bomb"
        FOR i = 84 TO 1 STEP -8
          strng = strng + "n" + STR$(i)
        NEXT
        PLAY strng
      CASE ELSE
        PLAY "l7O1" + nameOf + "l64"

    END SELECT
  END IF

END SUB

SUB reInitDead (spr() AS tpeSprite, st AS tpeSettings, bodyType AS INTEGER)
  DIM i AS INTEGER

  FOR i = LBOUND(spr) TO UBOUND(spr)
    IF spr(i).body = bodyType THEN
      IF spr(i).status = statusDead THEN
        SELECT CASE bodyType
          CASE bodyBall: initBall spr(i), st
          CASE bodyCloud: initCloud spr(i)
          CASE bodyBomb: initBomb spr(i), st
          CASE bodyHeli: initHeli spr(i), st
          CASE bodyBird: initBird spr(i), st
        END SELECT
      END IF
    END IF
  NEXT
END SUB

SUB reInitDeadAll (spr() AS tpeSprite, st AS tpeSettings)
 
  reInitDead spr(), st, bodyBall
  IF st.level >= 1 THEN reInitDead spr(), st, bodyCloud
  IF st.level >= 5 THEN reInitDead spr(), st, bodyBomb
  IF st.level >= 10 THEN reInitDead spr(), st, bodyHeli
  IF st.level >= 15 THEN reInitDead spr(), st, bodyBird
 
END SUB

SUB setPal (i AS INTEGER, r AS INTEGER, g AS INTEGER, b AS INTEGER)
 
  PALETTE i, (65536 * b) + (256 * g) + r

END SUB

SUB setRect (spr AS tpeSprite, rct AS rect, border AS INTEGER)
 
  rct.x1 = INT(spr.x - spr.size) - border
  rct.y1 = INT(spr.y - spr.size) - border
  rct.x2 = INT(spr.x + spr.size) + border
  rct.y2 = INT(spr.y + spr.size) + border

END SUB

SUB setSettings (st AS tpeSettings)

  st.music = true
  st.level = 0
  st.points = 0
  st.showScore = true
  st.gameOver = false
  st.keySpeed = 10
  st.sprSpeed = sprSpeedOrig
  st.explSpeed = 2
 
END SUB

SUB sprRedrawAll (spr() AS tpeSprite)
  DIM i AS INTEGER
 
  FOR i = UBOUND(spr) TO LBOUND(spr) STEP -1
    IF spr(i).status = statusAlive OR spr(i).status = statusDying THEN
      drawBody spr(i), drawErase
      IF spr(i).status = statusDying THEN spr(i).status = statusDead
    END IF
    IF spr(i).status = statusAlive THEN
      drawBody spr(i), drawNew
    END IF
  NEXT

END SUB

