'===========================================================================
' Subject: MEANDER                            Date: 05-11-99 (21:04)       
'  Author: Nigel Traves                       Code: QB, QBasic, PDS        
'  Origin: tarot@ihalliwell.freeserve.co.u  Packet: GAMES.ABC
'===========================================================================
REM MEANDER
REM Original Game and Algorithm written by Keith David of Sussex, England
REM Originally for Dragon32 (Tandy CoCo clone)
REM
REM (Incomplete!) Conversion By Nigel Traves (Graphics need re-scaling!)
REM
REM Public Domain - Use at own risk - No warranties etc.

REM INITIALISATION AND TITLES

DEFINT A-Z
DECLARE SUB CenterPRINT (ThisLine%, ThisText$)

CONST FALSE% = 0
CONST TRUE% = NOT FALSE%
CONST WinningX1 = 198
CONST WinningY1 = 162
CONST MyColour = 15

WordsNeeded = (4 + INT(((20 + 1) + 7) / 8) * 4 * (20 + 1)) \ 2

DIM EmptyCell(WordsNeeded), X(WordsNeeded), Y(WordsNeeded), Z(WordsNeeded), A(0 TO 9, 0 TO 9)
P1$ = "BM229,122;R2NR2U14G2"
P2$ = "BM227,122;NR8U5E2R4E2U3H2L"
SCREEN 12
CLS
COLOR MyColour
CenterPRINT 2, STRING$(11, "*")
CenterPRINT 3, "* MEANDER *"
CenterPRINT 4, STRING$(11, "*")
SLEEP 2
CenterPRINT 6, "DO YOU WANT INSTRUCTIONS? (Y/N)"
DO
    I$ = INPUT$(1)
    QI = INSTR("YyNn", I$)
LOOP WHILE QI = 0
IF QI < 3 THEN                       '| INSTRUCTIONS
    Q = 9
    CenterPRINT Q, "The object of 'MEANDER' is to complete a continuous line from"
    CenterPRINT Q + 1, "the top-left corner of the board to the bottom-right corner or"
    CenterPRINT Q + 2, "to force your opponent to carry the line off the edge of the board."
    CenterPRINT Q + 4, "Simply type in the letter of the piece that you wish to play to"
    CenterPRINT Q + 5, "continue the line."
    CenterPRINT Q + 7, "The first piece will be placed on the second square of the top line,"
    CenterPRINT Q + 8, "so placing piece 'Y' will automatically LOSE the game :-)."
    CenterPRINT 24, ">> PRESS ANY KEY TO PLAY. <<"
    I$ = INPUT$(1)
END IF

REM DRAW BOARD

DO
    CLS
    FOR Y = 12 TO 112 STEP 50
        LINE (8, Y)-(28, Y + 20), MyColour, B
    NEXT Y
    GET (8, 12)-(28, 32), EmptyCell
    DRAW "BM18,12;D10NL10NR10ND10"
    CIRCLE (28, 82), 10, MyColour, 1.570796327#, 3.141592654#
    CIRCLE (8, 62), 10, MyColour, 4.71238898#, 0
    CIRCLE (8, 132), 10, MyColour, 0, 1.570796327#
    CIRCLE (28, 112), 10, MyColour, 3.141592654#, 4.71238898#
    DRAW "BM14,36;M22,48;BM14,48;M22,36"
    DRAW "BM14,86;M18,92;ND6;M22,86"
    DRAW "BM14,136;R8;M14,148;R8"
    GET (8, 12)-(28, 32), X
    GET (8, 62)-(28, 82), Y
    GET (8, 112)-(28, 132), Z
    FOR X = 48 TO 208 STEP 20
        LINE (X, 12)-(X, 172), MyColour
    NEXT X
    LINE (46, 10)-(210, 174), MyColour, B
    FOR Y = 12 TO 172 STEP 20
        LINE (48, Y)-(208, Y), MyColour
    NEXT Y
    PUT (48, 12), X, PSET
    PUT (188, 152), X, PSET
    DRAW "BM228,22;U10R6D5L6"
    DRAW "BM228,36;NU10R6"
    DRAW "BM228,50;U5NR6U4E1R4F1D9"
    DRAW "BM231,64;U5NM228,54;M234,54"
    DRAW "BM228,78;NR6U5NR4U5R6"
    DRAW "BM228,92;U10R5F1D3G1NL5M234,92"
    LINE (221, 105)-(241, 125), MyColour, B

REM PLAY

    FOR X = 0 TO 9
        FOR Y = 0 TO 9
            A(X, Y) = 0
        NEXT Y
    NEXT X
    A(1, 1) = 1
    A(8, 8) = 1
    X = 58
    Y = 22
    x1 = 78
    Y1 = 22
    P = 1
    GameWon = FALSE%
    DO
        IF x1 > 208 OR x1 < 48 OR Y1 > 172 OR Y1 < 12 THEN
            EXIT DO
        END IF
        IF P = 1 THEN
            PUT (221, 105), EmptyCell, PSET
            DRAW "C15" + P1$
            P = 2
        ELSE
            PUT (221, 105), EmptyCell, PSET
            DRAW "C15" + P2$
            P = 1
        END IF
        DO
            I$ = INPUT$(1)
            QI = INSTR("XxYyZz", I$)
        LOOP WHILE QI = 0
        SELECT CASE (ASC(UCASE$(I$)) - 87)
            CASE 1
                PUT (x1 - 10, Y1 - 10), X, PSET
                A((Y1 - 2) / 20, (x1 - 38) / 20) = 1
            CASE 2
                PUT (x1 - 10, Y1 - 10), Y, PSET
                A((Y1 - 2) / 20, (x1 - 38) / 20) = 2
            CASE 3
                PUT (x1 - 10, Y1 - 10), Z, PSET
                A((Y1 - 2) / 20, (x1 - 38) / 20) = 3
            CASE DEFAULT
        END SELECT

REM SEARCH FOR END OF LINE

        DO
            SELECT CASE A((Y1 - 2) / 20, (x1 - 38) / 20)
                CASE 1
                    IF x1 = X + 20 THEN
                        X = x1
                        Y = Y1
                        x1 = X + 20
                    ELSEIF x1 = X - 20 THEN
                        X = x1
                        Y = Y1
                        x1 = X - 20
                    ELSEIF Y1 = Y - 20 THEN
                        X = x1
                        Y = Y1
                        Y1 = Y - 20
                    ELSEIF Y1 = Y + 20 THEN
                        X = x1
                        Y = Y1
                        Y1 = Y + 20
                    END IF
                CASE 2
                    IF x1 = X + 20 THEN
                        X = x1
                        Y = Y1
                        Y1 = Y - 20
                    ELSEIF x1 = X - 20 THEN
                        X = x1
                        Y = Y1
                        Y1 = Y + 20
                    ELSEIF Y1 = Y - 20 THEN
                        X = x1
                        Y = Y1
                        x1 = X + 20
                    ELSEIF Y1 = Y + 20 THEN
                        X = x1
                        Y = Y1
                        x1 = X - 20
                    END IF
                CASE 3
                    IF x1 = X + 20 THEN
                        X = x1
                        Y = Y1
                        Y1 = Y + 20
                    ELSEIF x1 = X - 20 THEN
                        X = x1
                        Y = Y1
                        Y1 = Y - 20
                    ELSEIF Y1 = Y - 20 THEN
                        X = x1
                        Y = Y1
                        x1 = X - 20
                    ELSEIF Y1 = Y + 20 THEN
                        X = x1
                        Y = Y1
                        x1 = X + 20
                    END IF
                CASE DEFAULT
            END SELECT

            IF x1 = WinningX1 AND Y1 = WinningY1 THEN
                GameWon = TRUE%
            END IF
        LOOP UNTIL ((A((Y1 - 2) / 20, (x1 - 38) / 20) = 0) OR GameWon)
    LOOP WHILE ((A((Y1 - 2) / 20, (x1 - 38) / 20) = 0) AND NOT GameWon)

REM END TITLES

    IF GameWon THEN
        FOR Index = 1 TO 20
            SOUND 100, 1
            SOUND 150, 1
        NEXT Index
        CLS
        IF P = 2 THEN
            CenterPRINT 5, "PLAYER 1 WINS!"
        ELSE
            CenterPRINT 5, "PLAYER 2 WINS!"
        END IF
    ELSE
        FOR Index = 1 TO 20
            SOUND 100, 1
            SOUND 150, 1
        NEXT Index
        CLS
        IF P = 2 THEN
            CenterPRINT 5, "PLAYER 1 LOSES BY GOING OFF THE EDGE!"
        ELSE
            CenterPRINT 5, "PLAYER 2 LOSES BY GOING OFF THE EDGE!"
        END IF
    END IF
    SLEEP 5
    CenterPRINT 24, ">> PRESS SPACEBAR FOR ANOTHER GAME <<"
    I$ = INPUT$(1)
LOOP WHILE I$ = " "
END

SUB CenterPRINT (ThisLine%, ThisText$)
    IF ThisText$ = "" THEN
        EXIT SUB
    END IF
    IF (ThisLine% < 1) OR (ThisLine% > 25) THEN
        EXIT SUB
    END IF
    ThisColumn% = ((80 - LEN(ThisText$)) \ 2)
    LOCATE ThisLine%, ThisColumn%
    PRINT ThisText$;
END SUB
