DECLARE SUB newland ()
DECLARE SUB playgame ()
DECLARE SUB exitgame ()
DECLARE SUB windicator ()
DECLARE SUB mprint (row%, message$, centre%, onebyone%)
DECLARE SUB cloudinit ()
DECLARE SUB wind ()
DECLARE SUB flag ()
DECLARE SUB explosion (ex%, ey%)
DECLARE SUB launcherinit ()
DECLARE SUB explodraw ()
DECLARE SUB endgame ()
DECLARE SUB intro ()
DECLARE SUB replacem (num%)
DECLARE SUB turnmissile (num%)
DECLARE SUB camfdraw ()
DECLARE SUB drawland ()
DECLARE SUB missiledata ()
DECLARE SUB setcolor ()
DECLARE SUB velocityinit (num%)
DECLARE SUB movemissile (num%)
DECLARE SUB display ()

DEFINT A-Z
'$DYNAMIC
SCREEN 9, , 0, 1

TYPE player
     x AS SINGLE
     y AS SINGLE
     sx AS INTEGER
     sy AS INTEGER
     xx  AS INTEGER
     yy AS INTEGER
     velocity AS INTEGER
     angl AS INTEGER
     vx AS SINGLE
     vy AS SINGLE
     cx AS SINGLE
     cy AS SINGLE
     status AS INTEGER
     n AS INTEGER
     t AS SINGLE
     sign AS INTEGER
     inkey AS STRING * 1
     score AS INTEGER
     shots AS INTEGER
END TYPE

'palette color names.
CONST sky% = 0, water% = 1, grass% = 2, land% = 3, cloud% = 4, dblue% = 5
CONST black% = 6, dbrown% = 7, camf% = 8, launch% = 9, explode% = 10
CONST indicator% = 11, fire% = 12, lbrown% = 13, yellow% = 14, white% = 15

'for status of missile.
CONST targethit% = 4, exploding% = 3, active% = 2, inactive% = 1

'change these values to suit your processor speed (default for 133MHz).
'interval determines the missile movement speed; decreasing it will slow missile.
'delay determines the explosion speed. increase it to slow down explosion.
CONST gravity! = -9.8, interval! = .1, delay% = 100

DIM SHARED missile$, exhl$, exhs$, launcher$
DIM SHARED arrlaun(201)  AS INTEGER, arrlaunmsk(201) AS INTEGER, arrcamf(4, 3) AS INTEGER
DIM SHARED arrexplod(91)  AS INTEGER, arrcloud(493) AS INTEGER
DIM SHARED colo(15)  AS INTEGER, clearind(1619) AS INTEGER, scoretarget AS INTEGER, maxshots AS INTEGER
DIM SHARED keyflags AS INTEGER, p(0 TO 1) AS player, vxr AS SINGLE, vyr AS SINGLE
DIM SHARED windvel AS SINGLE, windy AS INTEGER, clearwind(253) AS INTEGER

vyr = gravity * interval
windy = 50
'scoretarget is the target score to be reached first to win; change as you wish.
'maxshots is the number of shots allowed at a time.
scoretarget = 5
maxshots = 5

'sets up trapping of keys.
KEY 15, CHR$(&H0) + CHR$(&H11)
KEY 16, CHR$(&H0) + CHR$(&H1E)
KEY 17, CHR$(&H0) + CHR$(&H20)
KEY 18, CHR$(&H0) + CHR$(&H1F)
KEY 19, CHR$(&H80) + CHR$(&H48)
KEY 20, CHR$(&H80) + CHR$(&H4B)
KEY 21, CHR$(&H80) + CHR$(&H4D)
KEY 22, CHR$(&H80) + CHR$(&H50)
ON KEY(15) GOSUB p0up
ON KEY(16) GOSUB p0left
ON KEY(17) GOSUB p0right
ON KEY(18) GOSUB p0down
ON KEY(19) GOSUB p1up
ON KEY(20) GOSUB p1left
ON KEY(21) GOSUB p1right
ON KEY(22) GOSUB p1down
ON KEY(1) GOSUB newland
ON KEY(2) GOSUB newgame
ON KEY(3) GOSUB setwind
ON KEY(4) GOSUB endgame

'turns of caps and nums lock off.
'it is restored in the exitgame subprogram.
DEF SEG = 0
keyflags = PEEK(1047)
POKE 1047, (keyflags AND 16)
DEF SEG

setcolor            'sets the plaette.
missiledata         'stores the missle drawing in variable to be used in draw statement.
launcherinit        'stores the launcher drawing in variable to be used in draw statement.
explodraw           'stores the explosion picture in array.
cloudinit           'stores the cloud picture in array.

'introduction to game.
intro

RANDOMIZE TIMER

'draw new land and set up missiles and launchers.
newland

FOR i = 1 TO 4
     KEY(i) ON
NEXT i

'main game loop.
playgame

'key trapping calls following subroutines.
p0up:
p(0).inkey = "u"
RETURN

p0left:
IF p(0).inkey = "l" THEN p(0).inkey = " " ELSE p(0).inkey = "l"
RETURN

p0right:
IF p(0).inkey = "r" THEN p(0).inkey = " " ELSE p(0).inkey = "r"
RETURN

p0down:
IF p(0).inkey = "d" THEN
     p(0).inkey = "D"
ELSEIF p(0).inkey = "D" THEN
     p(0).status = exploding
ELSE
     IF p(0).shots < maxshots THEN
          p(0).inkey = "d"
          FOR k = 15 TO 17
               KEY(k) OFF
          NEXT k
     END IF
END IF
RETURN

p1up:
p(1).inkey = "u"
RETURN

p1left:
IF p(1).inkey = "l" THEN p(1).inkey = " " ELSE p(1).inkey = "l"
RETURN

p1right:
IF p(1).inkey = "r" THEN p(1).inkey = " " ELSE p(1).inkey = "r"
RETURN

p1down:
IF p(1).inkey = "d" THEN
     p(1).inkey = "D"
ELSEIF p(1).inkey = "D" THEN
     p(1).status = exploding
ELSE
     IF p(1).shots < maxshots THEN
          p(1).inkey = "d"
          FOR k = 19 TO 21
               KEY(k) OFF
          NEXT k
     END IF
END IF
RETURN

newgame:
p(0).score = 0
p(1).score = 0
RETURN

newland:
newland
RETURN

setwind:
'wind range is set according to user key press of F3.
windy = (windy + 25) MOD 75
PUT (319 - 55, 339), clearwind, PSET
windicator
wind
FOR i = 0 TO 1
     replacem i
NEXT i
RETURN

endgame:
exitgame

'color data.
'sky,water,grass,land,cloud,dblue,black,dbrown
'camf,launch,explode,indicator,fire,lbrown,yellow,white
'    0   1   2   3   4   5   6   7   8   9   10  11  12  13  14  15
DATA 11, 25, 50, 42, 27, 08, 00, 28, 06, 24, 04, 36, 52, 46, 54, 63

REM $STATIC
SUB camfdraw
'draws launcher with different camouflage every time landscape changes.
CLS
DRAW launcher$ + "p" + STR$(launch) + "," + STR$(launch)
FOR j = 0 TO 18 STEP 2
     FOR i = 0 TO 33 STEP 3
          IF RND * 10 < 4 THEN PUT (i, j), arrcamf, AND
     NEXT i
NEXT j
DRAW launcher$
GET (0, 0)-(32, 19), arrlaun
END SUB

SUB cloudinit
CIRCLE (50, 50), 20, cloud
PAINT (50, 50), white, cloud
GET (50 - 20, 50 - 20)-(50 + 20, 50 + 20), arrcloud
END SUB

SUB display
'displays refreshed screen image.
'impactx and impacty are the coordinates where the missile hits.
DIM missclear(845) AS INTEGER, impactx(1) AS INTEGER, impacty(1) AS INTEGER
DIM impactwho(1) AS INTEGER
FOR i = 0 TO 1
     p(i).xx = p(i).x
     p(i).yy = 350 - p(i).y
     IF p(i).xx < 23 THEN p(i).xx = 23
     IF p(i).yy < 17 THEN p(i).yy = 17
     IF p(i).xx > 616 THEN p(i).xx = 616
     IF p(i).yy > 332 THEN p(i).yy = 332
     GET (p(i).xx - 23, p(i).yy - 17)-(p(i).xx + 23, p(i).yy + 17), missclear(i * 423)
NEXT i
FOR i = 0 TO 1
     IF p(i).status = active OR p(i).status = exploding THEN
          x = p(i).x
          y = 350 - p(i).y
          n = p(i).n
          DRAW "bm=" + VARPTR$(x) + ",=" + VARPTR$(y) + "ta=" + VARPTR$(n) + "bu11"
          impactx(i) = POINT(0)
          impacty(i) = POINT(1)
          SELECT CASE POINT(impactx(i), impacty(i))
          CASE sky, cloud, white
          CASE land, grass, water
               KEY(18 + 4 * i) OFF
               p(i).status = exploding
          CASE launcher, camf
               p(i).status = targethit
               IF ABS(impactx(i) - p(0).sx) < ABS(impactx(i) - p(1).sx) THEN
                    impactx(i) = p(0).sx + 10
                    impactwho(i) = 0
                    p(1).score = p(1).score + 1
               ELSE
                    impactx(i) = p(1).sx - 10
                    impactwho(i) = 1
                    p(0).score = p(0).score + 1
               END IF
          END SELECT
     END IF
NEXT i

FOR i = 0 TO 1
     x = p(i).x
     y = 350 - p(i).y
     n = p(i).n
     IF p(i).status = active THEN
          IF RND * 10 < 5 THEN
               exh$ = exhs$
          ELSE
               exh$ = exhl$
          END IF
          pos$ = ""
          DRAW "bm=" + VARPTR$(x) + ",=" + VARPTR$(y) + "ta=" + VARPTR$(n) + missile$ + exh$
     ELSEIF p(i).status = inactive THEN
          DRAW "bm=" + VARPTR$(x) + ",=" + VARPTR$(y) + "ta=" + VARPTR$(n) + "bu6" + missile$
     END IF
NEXT i
COLOR dblue
LOCATE 1, 1
PRINT "PLAYER1 ";
PRINT USING "##"; p(0).score
LOCATE 1, 70
PRINT "PLAYER2 ";
PRINT USING "##"; p(1).score
PCOPY 0, 1
FOR i = 0 TO 1
     IF p(i).status = exploding THEN
          SCREEN , , 1, 1
          explosion impactx(i), impacty(i)
          SCREEN , , 0, 1
          replacem i
     ELSE
          PUT (p(i).xx - 23, p(i).yy - 17), missclear(i * 423), PSET
     END IF
NEXT i
FOR i = 0 TO 1
     IF p(i).status = targethit THEN
          SCREEN , , 1, 1
          FOR j = -5 TO 5
               PCOPY 0, 1
               explosion impactx(i) + jj, impacty(i) + jj
          NEXT j
          SCREEN , , 0, 1
          GET (p(impactwho(i)).sx - 6 - impactwho(i) * 20, p(impactwho(i)).sy + 5)-(p(impactwho(i)).sx + 26 - impactwho(i) * 20, p(impactwho(i)).sy + 24), arrlaun
          PUT (p(impactwho(i)).sx - 6 - impactwho(i) * 20, p(impactwho(i)).sy + 5), arrlaunmsk, PRESET
          PUT (p(impactwho(i)).sx - 6 - impactwho(i) * 20, p(impactwho(i)).sy + 5), arrlaun, XOR
          PCOPY 0, 1
     END IF
NEXT i
END SUB

SUB drawland
DIM amp(10) AS INTEGER, arrgrass(201) AS INTEGER
DIM minx(10)  AS INTEGER, miny(10)  AS INTEGER
DIM maxx(10)  AS INTEGER, maxy(10) AS INTEGER, msumy(3) AS SINGLE
DIM ly AS SINGLE, sumy1 AS SINGLE, sumy2 AS SINGLE

camfdraw
'get the grassy texture for the land into an array.
FOR i = 0 TO 31
     FOR j = 0 TO 24
          IF INT(RND * 10) > INT(RND * 10) THEN PSET (i, j), grass ELSE PSET (i, j), land
     NEXT j
NEXT i
GET (0, 0)-(31, 24), arrgrass

subamp:
'get the amplitudes for the sine values.
FOR i = 0 TO 10
     amp(i) = RND * (RND * 100)
NEXT i
CLS
'draw water.
watery = 250 + 50 * RND
LINE (0, watery)-(649, 349), water, BF
maxn = -1
minn = -1
slope = 0
sumy2 = 0
sumn = -1
'loop to draw land shape.
FOR lx = 0 TO 639
     ly = 128
     FOR lt = -5 TO 5
          ly = ly + SIN(lt * lx / 256) * amp(lt + 5)
     NEXT lt
     IF ly > 281 THEN GOSUB subamp
     ' the following code is to find the first and last positions of the land
     'where slope = 0 i.e. level land. this is where the launchers are placed.
     sumn = (sumn + 1) MOD 4
     IF sumn = 0 THEN
          sumy1 = sumy2
          sumy2 = 0
          FOR i = 0 TO 3
               sumy2 = sumy2 + msumy(i)
          NEXT i
          IF lx > 22 AND lx < 617 THEN
               IF sumy2 > sumy1 THEN
                    IF slope = 1 THEN minn = minn + 1: miny(minn) = sumy1 \ 4: minx(minn) = lx - 6
                    slope = -1
               ELSEIF sumy2 < sumy1 THEN
                    IF slope = -1 THEN maxn = maxn + 1: maxy(maxn) = sumy1 \ 4: maxx(maxn) = lx - 6
                    slope = 1
               END IF
          END IF
     END IF
     msumy(sumn) = ly
     LINE (lx, 350)-(lx, 360 - ly), land
NEXT lx
IF (minn + maxn) < 0 THEN GOSUB subamp

'put the grassy texture on the land.
FOR i = 0 TO 608 STEP 32
     FOR j = 25 TO 325 STEP 25
          PUT (i, j), arrgrass, AND
     NEXT j
NEXT i

' calculate the positions for the launchers such that both the launchers are
'maximum distance apart.
IF minx(0) < maxx(0) THEN
     p(0).sx = minx(0) - 10
     IF miny(0) > 355 - watery THEN
          p(0).sy = 338 - miny(0)
     ELSE
          p(0).sy = watery - 20
     END IF
ELSEIF minx(0) >= maxx(0) THEN
     p(0).sx = maxx(0) - 10
     IF maxy(0) > 355 - watery THEN
          p(0).sy = 338 - maxy(0)
     ELSE
          p(0).sy = watery - 20
     END IF
END IF
PUT (p(0).sx - 6, p(0).sy + 5), arrlaunmsk, AND
PUT (p(0).sx - 6, p(0).sy + 5), arrlaun, OR
IF minx(minn) > maxx(maxn) THEN
     p(1).sx = minx(minn) + 10
     IF miny(minn) > 355 - watery THEN
          p(1).sy = 338 - miny(minn)
     ELSE
          p(1).sy = watery - 20
     END IF
ELSEIF minx(minn) <= maxx(maxn) THEN
     p(1).sx = maxx(maxn) + 10
     IF maxy(maxn) > 355 - watery THEN
          p(1).sy = 338 - maxy(maxn)
     ELSE
          p(1).sy = watery - 20
     END IF
END IF
PUT (p(1).sx - 26, p(1).sy + 5), arrlaunmsk, AND
PUT (p(1).sx - 26, p(1).sy + 5), arrlaun, OR

'draw missile power indicator boxes.
LINE (8, 340)-(112, 347), indicator, B
LINE (527, 340)-(631, 347), indicator, B
GET (10, 342)-(110, 345), clearind(0)
GET (529, 342)-(629, 345), clearind(810)

'draw wind indicator box.
GET (319 - 55, 339)-(319 + 55, 347), clearwind
windicator

'draw cloud randomly.
cloudx = INT(RND * 100)
FOR i = 1 TO 7
     cloudx = cloudx + INT(RND * 30)
     cloudy = INT(RND * 11) + 17
     PUT (cloudx, cloudy), arrcloud, OR
NEXT i
cloudx = 300 + INT(RND * 100)
FOR i = 1 TO 7
     cloudx = cloudx + INT(RND * 30)
     cloudy = INT(RND * 11) + 17
     PUT (cloudx, cloudy), arrcloud, OR
NEXT i
END SUB

SUB endgame
'find the winner and display message and flag on the winning launcher.
IF p(0).score > p(1).score THEN
     message$ = ".PLAYER1"
     flagx = p(0).sx
     flagy = p(0).sy
ELSEIF p(1).score > p(0).score THEN
     message$ = ".PLAYER2"
     flagx = p(1).sx
     flagy = p(1).sy
ELSE
     message$ = ".NOBODY"
END IF
DIM arrmessage(2400) AS INTEGER
COLOR white
CLS
mprint 6, ".GOOD SHOOTING BOTH OF YOU.", 1, 0
mprint -1, (message$ + " WINS THE BATTLE."), 1, 0
mprint -1, "BUT THE WAR AIN'T OVER YET!", 1, 0
mprint -1, "PRESS ENTER TO CONTINUE", 1, 0
mprint 0, "ESCAPE TO EXIT", 1, 0
FOR i = 0 TO 7
     SCREEN , , 0, 1
     GET (208, 72 + 14 * i)-(421, 81 + 14 * i), arrmessage
     SCREEN , , 1, 1
     PUT (208, 72 + 14 * i), arrmessage, OR
NEXT i

'show waving flag.
IF message$ <> ".NOBODY" THEN
     flagcommon$ = "c" + STR$(white) + "a0bd4u11" + "c" + STR$(fire)
     flagpaint$ = "p" + STR$(fire) + "," + STR$(fire)
     IF windvel > 0 THEN
          flagdata$ = "r1f1r1e2f1d4h1g2l1h1u3bf1r1e1r3f1d4h1l3g1l1u3br1e1r1f2e1d4g1h2l1g1u3be1r1f1r3e1d4g1l3h1l1u3br1"
     ELSE
          flagdata$ = "l1g1l1h2g1d4e1f2r1e1u3bg1l1h1l3g1d4e1r3f1r1u3bl1h1l1g2h1d4f1e2r1f1u3bh1l1g1l3h1d4f1r3e1r1u3bl1"
     END IF
     DO
          FOR i = 0 TO 3
               LINE (flagx - 7, flagy - 8)-(flagx + 7, flagy - 2), 0, BF
               DRAW "bm=" + VARPTR$(flagx) + ",=" + VARPTR$(flagy) + flagcommon$ + MID$(flagdata$, 1, 2) + MID$(flagdata$, 23 * i + 3, 23) + flagpaint$
               FOR tp# = 1 TO delay * 2 STEP .01: NEXT tp#
          NEXT i
          in$ = INKEY$
     LOOP UNTIL in$ = CHR$(13) OR in$ = CHR$(27)
ELSE
     DO
          in$ = INKEY$
     LOOP UNTIL in$ = CHR$(13) OR in$ = CHR$(27)
END IF
SCREEN , , 0, 1
IF in$ = CHR$(13) THEN
     FOR i = 0 TO 1
          p(i).score = 0
     NEXT i
ELSEIF in$ = CHR$(27) THEN
     exitgame
END IF
END SUB

SUB exitgame
FOR i = 1 TO 4
     KEY(i) OFF
NEXT i
FOR i = 15 TO 22
     KEY(i) OFF
NEXT i
'restore the numslock and capslock status.
DEF SEG = 0
POKE 1047, keyflags
DEF SEG
SCREEN 0
END
END SUB

SUB explodraw
'draw explosion circle and get into array.
CLS
FOR i = 5 TO 0 STEP -1
     CIRCLE (50, 50), i * 2, 15 - i
     PAINT (50, 50), 15 - i
NEXT i
GET (50 - 10, 50 - 7)-(50 + 10, 50 + 7), arrexplod
CLS
END SUB

SUB explosion (ex, ey)
'put the explosion picture at the impact point randomly.
'ex, ey are the coordinates where missile hit.
ex = ex - 10   'subtract 10 since explosion image is 20 in width.
ey = ey - 7    'subtract  7 since explosion image is 14 in height.
FOR dex = -1 TO 1
     FOR dey = -1 TO 1
          FOR i = 0 TO 10
               em = INT(RND * (8 - i)) + 1
               exx = ex + dex * em
               eyy = ey + dey * em
               IF exx < 619 AND exx >= 0 AND eyy < 329 AND eyy >= 0 THEN EXIT FOR
          NEXT i
          IF i < 11 THEN PUT (exx, eyy), arrexplod, OR
          FOR tp# = 1 TO delay * 5 STEP .1: NEXT tp#
     NEXT dey
NEXT dex
END SUB

SUB intro
'game introduction messages.
CLS
PCOPY 0, 1
SCREEN , , 1, 1
COLOR dblue
mprint 1, "GET READY TO PLAY THE ULTIMATE BATTLE", 1, 1
mprint -2, "YOUR MISSION IS TO DESTROY YOUR OPPONENT USING YOUR MISSLES", 1, 1
mprint -2, (" PLAYER KEY CONTROLS" + SPACE$(35) + "Player1" + SPACE$(4) + "Player2"), 0, 1
mprint -2, (" START/STOP ANTI CLOCKWISE ROTATION OF MISSILE" + SPACE$(9) + "a" + SPACE$(10) + "LEFT"), 0, 1
mprint -1, (" START/STOP CLOCKWISE ROTATION OF MISSILE" + SPACE$(14) + "d" + SPACE$(10) + "RIGHT"), 0, 1
mprint -1, (" TURN MISSILE UPRIGHT OR HORIZONTAL" + SPACE$(20) + "w" + SPACE$(10) + "UP"), 0, 1
mprint -1, (" START MISSILE POWER UP" + SPACE$(32) + "s" + SPACE$(10) + "DOWN"), 0, 1
mprint -1, (" LAUNCH MISSLE AFTER POWER UP" + SPACE$(26) + "s" + SPACE$(10) + "DOWN"), 0, 1
mprint -1, (" SELF DESTRUCT MISSLE BEFORE IMPACT" + SPACE$(20) + "s" + SPACE$(10) + "DOWN"), 0, 1
mprint -2, "*[IF THE MISSILE IS TOO FAST, IT MAY NOT HIT THE TARGET BUT SHOOT RIGHT PAST!]", 1, 1
mprint -2, " OTHER CONTROLS", 0, 1
mprint -2, " F1      CHANGE LANDSCAPE", 0, 1
mprint -1, " F2      RESET SCORES TO ZERO", 0, 1
mprint -1, " F3      CHANGE WIND VELOCITY RANGE [ZERO, MEDIUM, HIGH]", 0, 1
mprint -1, " F4      END GAME", 0, 1
mprint -2, "LET THE WAR BEGIN!           PRESS ANY KEY", 1, 1
SCREEN , , 0, 1
DO: LOOP UNTIL INKEY$ <> ""
END SUB

SUB launcherinit
'launcher image data.
launcher$ = "bm0,0r32d3l1d17h3g3h3g3h3g3h3g3h3g3u17l1u3bf1"
LINE (0, 0)-(3, 2), camf, BF
GET (0, 0)-(3, 2), arrcamf
LINE (0, 0)-(32, 19), 15, BF
DRAW "c0" + launcher$ + "p0,0"
GET (0, 0)-(32, 19), arrlaunmsk
launcher$ = "c" + STR$(launch) + launcher$
END SUB

SUB missiledata
'missile$ contains missile image data.
'exhs$ contains small missile-exhaust data.
'exhl$ contains big missile-exhaust data.
missile$ = "c" + STR$(dbrown) + "bu10g2d14l1g2d2r3d1r4u1r3u2h2l1u14h2bd1"
fill$ = "p" + STR$(dbrown) + "," + STR$(dbrown)

missile$ = missile$ + "bd1" + fill$ + "bd1" + fill$ + "bd13" + fill$ + "bd1" + fill5$
FOR i = 1 TO 3
     missile$ = missile$ + "bl" + STR$(i) + fill$ + "br" + STR$(2 * i) + fill$ + "bl" + STR$(i) + "bd1" + fill$
NEXT i

exhl$ = "c" + STR$(fire) + "bd1l1g1d4f1r2e1u4h1l1"
fill$ = "p" + STR$(yellow) + "," + STR$(fire)
FOR i = 1 TO 4
     exhl$ = exhl$ + "bd1" + fill$ + "bl1" + fill$ + "br2" + fill$ + "bl1"
NEXT i
exhl$ = exhl$ + "bu27"
exhs$ = "c" + STR$(fire) + "bd1l1g1d2f1r2e1u2h1l1"
FOR i = 1 TO 3
     exhs$ = exhs$ + "bd1" + fill$ + "bl1" + fill$ + "br2" + fill$ + "bl1"
NEXT i
exhs$ = exhs$ + "bu26"
END SUB

SUB movemissile (num)
'moves the missile according to the two dimensional trajectory equation.
'.x,.y are the current position values of the centre of the missile.
'.cx,.cy are the constant position values calculated initially in subprogram velocityinit.
'vxr,vyr are the constant resistance velocities  calculated initially.
'.t is the time of flight in multiples of the time-interval constant.
p(num).x = p(num).x + p(num).cx + vxr * p(num).t
p(num).y = p(num).y + p(num).cy + vyr * p(num).t
IF p(num).y < -24 THEN
     replacem num
     EXIT SUB
END IF
IF p(num).vx = 0 THEN
     IF p(num).vy > 0 THEN p(num).n = 0 ELSE p(num).n = 180
ELSE
     p(num).n = INT(ATN(p(num).vy / p(num).vx) * 57.2958 - p(num).sign * 90)
END IF
p(num).t = p(num).t + interval
p(num).vx = p(num).vx + vxr
p(num).vy = p(num).vy + vyr
p(num).sign = SGN(p(num).vx)
END SUB

SUB mprint (row%, message$, centre%, onebyone%)
'print centered message character one by one at specified location.
IF row < 1 THEN row = CSRLIN + ABS(row)
IF centre = 1 THEN LOCATE row, (80 - LEN(message$)) \ 2 + 1 ELSE LOCATE row, 1
IF onebyone = 1 THEN
     FOR i = 1 TO LEN(message$)
          PRINT MID$(message$, i, 1);
          FOR tp# = 1 TO delay * 5 STEP .1: NEXT tp#
     NEXT i
ELSE
     PRINT message$
END IF
END SUB

SUB newland
'to draw new-land and initialize variables after every battle is over.
drawland
wind
FOR i = 0 TO 1
     KEY(18 + 4 * i) OFF
     p(i).angl = 180 * i
     p(i).shots = 0
     replacem i
NEXT i
END SUB

SUB playgame
DO
     FOR i = 1 TO 4
          KEY(i) STOP
     NEXT i
     FOR turn = 0 TO 1
          IF p(turn).status = active THEN
               movemissile turn
          ELSEIF p(turn).status = inactive THEN
               turnmissile turn
          END IF
     NEXT turn
     KEY(18) STOP
     KEY(22) STOP
     display
     IF p(0).score = scoretarget OR p(1).score = scoretarget THEN endgame
     IF p(0).shots + p(1).shots = 10 THEN p(0).shots = 0: p(1).shots = 0
     IF p(0).status = targethit OR p(1).status = targethit THEN newland
     KEY(18) ON
     KEY(22) ON
     FOR i = 1 TO 4
          KEY(i) ON
     NEXT i
LOOP
END SUB

SUB replacem (num)
'replaces missile onto the launcher after the missile has exploded.
p(num).status = inactive
p(num).velocity = 0
p(num).n = p(num).angl - 90
PUT (num * 519 + 10, 342), clearind(0 + 810 * num), PSET
p(num).x = p(num).sx
p(num).y = 350 - p(num).sy
p(num).inkey = ""
FOR i = 15 TO 17
     KEY(i + 4 * num) ON
NEXT i
END SUB

SUB setcolor
'sets the palette.
FOR i = 0 TO 15
READ colo(i)
NEXT i
PALETTE USING colo(0)
END SUB

SUB turnmissile (num)
'rotates and launches the missile on the launcher according to the user input.
SELECT CASE p(num).inkey
CASE " "
CASE "u"
     SELECT CASE ABS(180 * num - p(num).angl)
     CASE 0 TO 45
          p(num).angl = 90
     CASE 45 TO 90
          p(num).angl = 180 * num
     CASE 90 TO 135
          p(num).angl = 180 * (1 - num)
     CASE 135 TO 180
          p(num).angl = 90
     END SELECT
     p(num).inkey = " "
CASE "l"
     p(num).angl = p(num).angl + 1
     IF p(num).angl > 180 THEN p(num).angl = 180: p(num).inkey = " "
     IF p(num).angl = 90 THEN p(num).inkey = " "
CASE "r"
     p(num).angl = p(num).angl - 1
     IF p(num).angl < 0 THEN p(num).angl = 0: p(num).inkey = " "
     IF p(num).angl = 90 THEN p(num).inkey = " "
CASE "d"
     p(num).velocity = p(num).velocity + 2
     IF p(num).velocity > 200 THEN p(num).velocity = 200
     LINE (num * 519 + 10, 342)-(num * 519 + 10 + p(num).velocity / 2, 345), indicator, BF
     EXIT SUB
CASE "D"
     p(num).shots = p(num).shots + 1
     x = p(num).x
     y = 350 - p(num).y
     n = p(num).n
     DRAW "bm=" + VARPTR$(x) + ",=" + VARPTR$(y) + "ta=" + VARPTR$(n) + "bu6"
     p(num).x = POINT(0)
     p(num).y = 350 - POINT(1)
     velocityinit (num)
     p(num).status = active
     EXIT SUB
END SELECT
p(num).n = p(num).angl - 90
END SUB

SUB velocityinit (num)
'intializes the velocity and direction.
a# = 3.141592654# * p(num).angl / 180
p(num).vx = COS(a#) * p(num).velocity
p(num).vy = SIN(a#) * p(num).velocity
p(num).cx = (p(num).vx + vxr * interval / 2) * interval
p(num).cy = (p(num).vy + vyr * interval / 2) * interval
p(num).sign = SGN(p(num).vx)
p(num).t = 0
END SUB

SUB wind
'indicates the wind strength.
windvel = INT(RND * (windy * 2 + 1)) - windy
vxr = windvel * interval / 5
IF windy > 0 THEN
     PAINT (319, 343), dblue
     LINE (319, 340)-(319 + windvel, 346), indicator, BF
     LINE (319 - windy + 1, 341)-(319 + windy - 1, 341), white
     PSET (319, 342), white
END IF
END SUB

SUB windicator
'draws the wind indicator box according to the specified range (in variable windy).
IF windy > 0 THEN
     LINE (319 - windy, 339)-(319 + windy, 347), dblue, BF
     CIRCLE (319 - windy, 343), 5, dblue
     CIRCLE (319 + windy, 343), 5, dblue
     PAINT (319 - windy - 1, 343), dblue
     PAINT (319 + windy + 1, 343), dblue
END IF
END SUB

