REM *********************************************************************
REM *********************************************************************
REM *****                                                            ****
REM *****       LOW-RES GUI PROGRAM FRAMEWORK AND FONT SYSTEM        ****
REM *****                 BY ALAN YAP CHING FATT                     ****
REM *****                                                            ****
REM *********************************************************************
REM *********************************************************************

DECLARE SUB cmdbutton (cbx, cby, cbsx, ltext$, BCOL, fcol)
DECLARE SUB showscroll (stype$, x1, y1, slen, col)
DECLARE SUB showtextbox (tbx, tby, tbsx, textlen, BCOL)
DECLARE SUB hscroll (x1, y1, slen, barlen, col, min, max, value)
DECLARE SUB vscroll (x1, y1, slen, barlen, col, min, max, value)
DECLARE SUB LOADPIC (FLNAME$, PX, PY)
DECLARE SUB box3d (x1, y1, x2, Y2, col)
DECLARE SUB DBOX (title$, x1, y1, x2, Y2, boxcol, barcol, titlecol)
DECLARE FUNCTION selectcolor (dbx, dby)
DECLARE FUNCTION acttextbox$ (tbx!, tby!, tbsx!, textlen!, fcol!)
DECLARE FUNCTION inputg$ (x5, y5, textlen, fcol, BCOL)

REM **** SUPPORTING FONT SYSTEM ****
DECLARE SUB CLOCATE (tempx, tempy)
DECLARE SUB textcolor (tempcol)
DECLARE SUB LOADFONT (fontname$)
DECLARE SUB CPRINT (ltext$)
DECLARE SUB CENTERPRINT (ctx, cty, ltext$, ctsx)
DECLARE FUNCTION tlen (ltext$)
DECLARE FUNCTION clen (char$)

COMMON SHARED maxclen, charhigh, BOLD, textcol, currentx, currenty, vspace
COMMON SHARED menutotal, menuypos, MenuHOTKEY$, menucol$
COMMON SHARED keytrap$, pointer1, pointer2, TEXTBUFFER$

REM *** GLOBAL FONT-ATTRIBUTES ***
DIM SHARED fontdata$(95), starty(95), CHARLEN(95)


FUNCTION acttextbox$ (tbx, tby, tbsx, textlen, fcol)
REM ************************************************
REM **** ACTIVATE THE TEXT-BOX                 *****
REM ************************************************
IF textlen = -1 THEN textlen = CINT((tbsx - 9) / (1 + maxclen + BOLD))
IF tbsx = -1 THEN tbsx = textlen * (maxclen + BOLD + 1) + 9

BCOL = POINT(tbx + 2, tby + 2)
LINE (tbx + 1, tby + 1)-STEP(tbsx - 3, charhigh + 2), BCOL, BF
temp$ = inputg(tbx + 2, tby + 2, textlen, fcol, BCOL)
acttextbox$ = temp$

END FUNCTION

SUB box3d (x1, y1, x2, Y2, col)



LINE (x1 + 2, y1 + 2)-STEP(x2 - 4, Y2 - 4), col, BF
LINE (x1, y1)-STEP(x2, Y2), 8, B
LINE (x1 + 1, y1 + 1)-STEP(x2 - 2, Y2 - 2), 8, B


LINE (x1, y1)-STEP(x2, 0), 15
LINE -STEP(0, Y2), 15
LINE (x1 + 1, y1 + 1)-STEP(x2 - 2, 0), 15
LINE -STEP(0, Y2 - 2), 15



END SUB

SUB CENTERPRINT (ctx, cty, ltext$, ctsx)
REM *****************************************
REM **** Centers and print the font      ****
REM *****************************************
DIM tempx

tempx = CINT((ctsx - tlen(ltext$)) / 2)
currentx = ctx + tempx
currenty = cty
CPRINT ltext$

END SUB

FUNCTION clen (char$)
REM ****** RETURN THE LENGTH OF A CHARACTER ******
clen = CHARLEN(ASC(char$) - 32)

END FUNCTION

SUB CLOCATE (tempx, tempy)
currentx = tempx
currenty = tempy
END SUB

SUB cmdbutton (cbx, cby, cbsx, ltext$, BCOL, fcol)
REM ****************************************
REM *** DISPLAY A COMMAND BUTTON         ***
REM ****************************************
DIM cbsy, tempx$, tempy$

cbsy = charhigh + 5
REM *** AUTO ADJUST BUTTON ***
IF cbsx = -1 THEN cbsx = tlen(ltext$) + 20


REM *** DRAW OUTLINES OF COMMAND BUTTON ****
tempx$ = STR$(cbsx - 4)
tempy$ = STR$(cbsy - 4)
LINE (cbx + 1, cby + 1)-STEP(cbsx - 2, cbsy - 2), BCOL, BF
PSET (cbx, cby + 2), 0
DRAW "e2 r" + tempx$ + " f2 d" + tempy$
DRAW " g2 l" + tempx$ + " h2 u" + tempy$
PSET (cbx + 1, cby + 2), 0
DRAW "c15 ru r" + tempx$ + " dr d" + tempy$
DRAW "c8 ld l" + tempx$ + " ul u" + tempy$

textcol = fcol
CENTERPRINT cbx + 1, cby + 3, ltext$, cbsx


END SUB

SUB CPRINT (ltext$)

REM **************************************************
REM **** DISPLAY OUT THE TEXT USING LOADED FONTS  ****
REM **************************************************
GX = 0

FOR g1 = 1 TO LEN(ltext$)
    c$ = MID$(ltext$, g1, 1)
    G2 = ASC(c$) - 32
    IF c$ = "&" THEN
             c$ = MID$(ltext$, g1 + 1, 1)
             LINE (currentx + GX, currenty - 1 + charhigh)-STEP(CHARLEN(ASC(c$) - 32) - 1 + BOLD, 0), textcol
             G3 = -1
        ELSEIF c$ <> " " THEN
            G3 = CHARLEN(G2) + BOLD
            PSET (currentx + GX, currenty - 1 + starty(G2)), textcol: DRAW fontdata$(G2)
            IF BOLD > 0 THEN PSET (currentx + GX + 1, currenty - 1 + starty(G2)), textcol: DRAW fontdata$(G2)
          ELSE
            G3 = CHARLEN(0) + BOLD
    END IF
    GX = CINT(GX + G3 + 1)
NEXT

currenty = currenty + charhigh + vspace


END SUB

SUB DBOX (title$, x1, y1, x2, Y2, boxcol, barcol, titlecol)
REM ******************************************
REM ******** DRAWS A WIN99 DIALOG BOX ********
REM ******************************************
DIM barsy, x3

LINE (x1, y1)-STEP(x2 - 1, Y2 - 1), boxcol, BF
LINE (x1, y1)-STEP(x2 - 1, Y2 - 1), 8, B
LINE (x1, y1)-STEP(x2 - 1, 0), 15
LINE -STEP(0, Y2 - 1), 15

REM *** SHADED BOX AND BAR ***
FOR GX = 1 TO 4
    g11 = boxcol + GX
    LINE (x1 + 5 - GX, y1 + 1)-STEP(0, Y2 - 3), g11
    LINE (x1 + x2 - 6 + GX, y1 + 1)-STEP(0, Y2 - 3), g11
NEXT

FOR GX = 1 TO 3
    g11 = barcol - GX
    LINE (x1 + 3, y1 + 6 - GX)-STEP(x2 - 7, 0), g11
    LINE (x1 + 3, y1 + charhigh + GX)-STEP(x2 - 7, 0), g11
NEXT

barsy = charhigh + 2
x3 = x1 + x2

REM **** DISPLAY TITLE BAR ********
LINE (x1 + 3, y1 + 6)-STEP(x2 - 7, charhigh - 6), barcol, BF
temp$ = "c15 d" + STR$(barsy) + "r c8 u" + STR$(barsy)
LINE (x1 + 3, y1 + 2)-STEP(x2 - 7, barsy), 8, B
LINE (x1 + 3, y1 + 2)-STEP(x2 - 7, 0), 15
LINE -STEP(0, barsy), 15

 PSET (x1 + 5, y1 + 2): DRAW temp$
 PSET (x1 + 9, y1 + 2): DRAW temp$
 PSET (x3 - 11, y1 + 2): DRAW temp$
 PSET (x3 - 7, y1 + 2): DRAW temp$

textcol = titlecol
CLOCATE x1 + 12, y1 + 4: CPRINT title$

LINE (x1 + 1, y1 + barsy + 4)-STEP(x2 - 2, 0), 8
LINE (x1 + 1, y1 + barsy + 5)-STEP(x2 - 2, 0), 15

END SUB

SUB hscroll (x1, y1, slen, barlen, col, min, max, value)
REM ***********************************
REM ** UPDATES HORIZONTAL SCROLL    ***
REM ***********************************

REM ** UPDATE BAR SKELETON ***
LINE (x1 + 12, y1)-STEP(slen - 25, 11), 24, BF
LINE (x1 + 11, y1)-STEP(slen - 24, 11), 0, B
LINE (x1 + 12, y1 + 1)-STEP(slen - 25, 9), 15, B
LINE (x1 + 12, y1 + 1)-STEP(slen - 25, 0), 8
LINE -STEP(0, 9), 8

REM *** DRAW THE BAR POINTER ***
blen$ = STR$(barlen - 1)
aval = CINT((value - min) / (max - min) * (slen - 24 - barlen))
LINE (x1 + 12 + aval, y1 + 1)-STEP(barlen - 1, 9), 0, B
PSET (x1 + 12 + aval, y1 + 1):   DRAW "c15 R" + blen$ + "D9 c8 L" + blen$ + "U9"

REM ** SHADED BAR ***
FOR GY1 = 0 TO 3
    LINE (x1 + 13 + aval, y1 + 5 - GY1)-STEP(barlen - 3, 0), col - GY1
    LINE (x1 + 13 + aval, y1 + 5 + GY1)-STEP(barlen - 3, 0), col - GY1
NEXT

END SUB

FUNCTION inputg$ (x5, y5, textlen, fcol, BCOL)
REM *****************************************************
REM *** KINDA LIKE INPUT STATEMENT...JUST MORE FLEXIBLE!
REM *****************************************************
DIM text$, cpos, X6

text$ = TEXTBUFFER$: cpos = 1: X6 = 0
LINE (x5, y5)-STEP(textlen * (maxclen + BOLD + 1) + 5, charhigh), BCOL, BF
REM **** APPEND TO PREVIOUS INPUT ****
IF text$ <> "" THEN
    X6 = tlen(TEXTBUFFER$) + 1
    cpos = LEN(text$) + 1
    textcol = fcol
    CLOCATE x5 + 1, y5 + 1: CPRINT text$
END IF

LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), fcol, B


textcol = fcol
DO UNTIL F$ = CHR$(27) OR F$ = CHR$(13)
    TEXTBUFFER$ = text$
    F$ = INPUT$(1)
    IF F$ = "" OR F$ = "&" THEN F$ = CHR$(255)
   
    ' Enter the font
    IF ASC(F$) >= 32 AND ASC(F$) <= 127 AND cpos <= textlen THEN
        LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), BCOL, B
        text$ = text$ + F$
        cpos = cpos + 1
        IF F$ <> " " THEN
            CLOCATE x5 + X6 + 1, y5 + 1
            CPRINT F$
        END IF

        X6 = X6 + CHARLEN(ASC(F$) - 32) + 1 + BOLD
        LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), fcol, B
    END IF

    ' Backspace
    IF F$ = CHR$(8) AND cpos > 1 THEN
        LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), BCOL, B
        cpos = cpos - 1
        g22 = CHARLEN(ASC(RIGHT$(text$, 1)) - 32) + 1 + BOLD
        X6 = X6 - g22
        LINE (x5 + X6 + 1, y5)-STEP(g22 - 1, charhigh), BCOL, BF
        LINE (x5 + X6 + 1, y5)-STEP(0, charhigh), fcol, B
        text$ = LEFT$(text$, LEN(text$) - 1)
    END IF

    ' Trap user preferred keys
    IF INSTR(1, keytrap$, F$) THEN text$ = "": EXIT DO
LOOP

IF F$ = CHR$(27) THEN text$ = ""
IF text$ = "" THEN inputg$ = F$ ELSE inputg$ = RTRIM$(text$)

END FUNCTION

SUB LOADFONT (fontname$)

REM **************************************
REM *** START LOADING THE FILE!       ****
REM **************************************
DIM text$

OPEN "I", #1, fontname$ + ".FNT"

' Load dummy header
LINE INPUT #1, text$
LINE INPUT #1, text$

' Load Character height
LINE INPUT #1, text$
text$ = RTRIM$(text$)
charhigh = VAL(text$)

' Load Font-data
GY = 1
maxclen = 0
vspace = 2

LINE INPUT #1, text$
text$ = RTRIM$(text$)
DO UNTIL text$ = "[END]" OR EOF(1)
    fontdata$(GY) = RIGHT$(text$, LEN(text$) - 2)
    CHARLEN(GY) = ASC(LEFT$(text$, 1)) - 64
    IF CHARLEN(GY) > maxclen THEN maxclen = CHARLEN(GY)
    starty(GY) = ASC(MID$(text$, 2, 1)) - 64
    GY = GY + 1
    LINE INPUT #1, text$
    text$ = RTRIM$(text$)
LOOP
CLOSE #1
CHARLEN(0) = 4


END SUB

SUB LOADPIC (FLNAME$, PX, PY)
REM **** LOAD TXT IMAGE ***
OPEN "I", #1, FLNAME$ + ".TXT"
INPUT #1, F$
IF F$ = "<DTXT>" THEN INPUT #1, psizex, psizey ELSE psizex = 70: psizey = 70
GX = POINT(PX, PY)
PSET (PX, PY)
FOR gx1 = 1 TO psizex
     INPUT #1, g1$: DRAW g1$
NEXT
CLOSE #1
PSET (PX, PY), GX
END SUB

FUNCTION selectcolor (dbx, dby)
REM *******************************************************
REM **** LET USER PICK COLOR FROM COLOR PALETTE       *****
REM *******************************************************
REM **** RETURNS THE COLOR SELECTED - (0 TO 15)        ****
REM **** IF USER PRESS ESC, RETURNS -1                 ****
REM *******************************************************

DIM lr, ud
DIM background(2020)       'STORE BACKGROUND IMAGE

REM **** DISPLAY OUT COLOR PALETTE  *****
GET (dbx, dby)-STEP(109, 71), background
BOLD = 1
LINE (dbx, dby)-STEP(109, 71), 27, BF
PSET (dbx, dby): DRAW "c15 r109d71 c23 l109u71"
FOR GX23 = 0 TO 19
  FOR GY23 = 0 TO 9
    GX22 = dbx + 5 + (GX23 * 5)
    GY22 = dby + 18 + (GY23 * 5)
    g11 = (GX23 + (GY23 * 20))
    LINE (GX22, GY22)-STEP(3, 3), g11, BF
    IF g11 = pointer1 THEN GX21 = GX23: GY21 = GY23
  NEXT
NEXT

PSET (dbx + 6, dby + 4): DRAW "c15 r20 d10 c8 l20 u10"

31510
IF GX21 < 0 THEN GX21 = 19: GY21 = GY21 - 1
IF GX21 > 19 THEN GX21 = 0: GY21 = GY21 + 1
IF GY21 < 0 THEN GY21 = 9
IF GY21 > 9 THEN GY21 = 0

GX22 = dbx + 4 + (GX21 * 5)
GY22 = dby + 17 + (GY21 * 5)
PSET (GX22, GY22): DRAW "C15 R5 D5 C8 L5 U5"

g11 = POINT(GX22 + 1, GY22 + 1)
LINE (dbx + 7, dby + 5)-STEP(18, 8), g11, BF
LINE (dbx + 31, dby + 6)-STEP(30, 8), 27, BF
textcol = 1
CLOCATE dbx + 31, dby + 6: CPRINT LTRIM$(STR$(g11))
PSET (GX22, GY22): DRAW "c27"

31511
F$ = UCASE$(INKEY$)
IF MID$(F$, 2, 1) = "H" THEN DRAW "r5d5l5u5": GY21 = GY21 - 1: GOTO 31510
IF MID$(F$, 2, 1) = "P" THEN DRAW "r5d5l5u5": GY21 = GY21 + 1: GOTO 31510
IF MID$(F$, 2, 1) = "K" THEN DRAW "r5d5l5u5": GX21 = GX21 - 1: GOTO 31510
IF MID$(F$, 2, 1) = "M" THEN DRAW "r5d5l5u5": GX21 = GX21 + 1: GOTO 31510
IF F$ = CHR$(27) OR F$ = CHR$(13) THEN GOTO 31519
GOTO 31511


31519
REM *** RESTORE BACKGROUND *****
IF F$ = CHR$(13) THEN selectcolor = g11 ELSE selectcolor = -27
PUT (dbx, dby), background, PSET
BOLD = 0
END FUNCTION

SUB showscroll (stype$, x1, y1, slen, col)
REM *********************************************
REM *** DISPLAY THE SCROLL                   ****
REM *********************************************
DIM arrow$

text$ = "c15 r9d9 c8 l9u8"

IF stype$ = "^" THEN
    REM *** DRAW TOP,BOTTOM SCROLL BUTTON ***
    arrow$ = "c0 l5dr5g l3f r"
    LINE (x1, y1)-STEP(11, slen - 1), col, BF
    LINE (x1, y1)-STEP(11, 11), 0, B
    LINE (x1, y1 + slen - 12)-STEP(11, 11), 0, B
    PSET (x1 + 1, y1 + slen - 11): DRAW text$
    PSET (x1 + 1, y1 + 1): DRAW text$
    PSET (x1 + 8, y1 + slen - 8): DRAW "a0" + arrow$
    PSET (x1 + 3, y1 + 7): DRAW "a2" + arrow$
ELSE
    REM *** DRAW LEFT,RIGHT SCROLL BUTTON ***
    arrow$ = "c0 u5rd5 eu3f d"
    LINE (x1, y1)-STEP(slen - 1, 11), col, BF
    LINE (x1, y1)-STEP(11, 11), 0, B
    LINE (x1 + slen - 12, y1)-STEP(11, 11), 0, B
    PSET (x1 + 1, y1 + 1): DRAW text$
    PSET (x1 + slen - 11, y1 + 1): DRAW text$
    PSET (x1 + slen - 8, y1 + 8): DRAW "a0" + arrow$
    PSET (x1 + 7, y1 + 3): DRAW "a2" + arrow$
END IF
DRAW "a0"

END SUB

SUB showtextbox (tbx, tby, tbsx, textlen, BCOL)
REM **********************************
REM *** DISPLAY THE TEXTBOX        ***
REM **********************************
IF textlen = -1 THEN textlen = CINT((tbsx - 9) / (1 + maxclen + BOLD))
IF tbsx = -1 THEN tbsx = textlen * (maxclen + BOLD + 1) + 9
LINE (tbx, tby)-STEP(tbsx - 1, charhigh + 4), BCOL, BF
LINE (tbx, tby)-STEP(tbsx - 1, charhigh + 4), 15, B
LINE (tbx, tby)-STEP(tbsx - 1, 0), 8
LINE -STEP(0, charhigh + 4), 8

END SUB

SUB textcolor (tempcol)
textcol = tempcol

END SUB

FUNCTION tlen (ltext$)
REM *********************************************
REM *** CALCULATE LENGTH OF TEXT IN PIXELS   ****
REM *********************************************
g23 = LEN(ltext$) - 1

FOR g22 = 1 TO LEN(ltext$)
    c$ = MID$(ltext$, g22, 1)
    IF c$ = "&" THEN g23 = g23 - (CHARLEN(ASC(c$) - 32) + BOLD)
    g23 = g23 + CHARLEN(ASC(c$) - 32) + BOLD
NEXT
tlen = g23

END FUNCTION

SUB vscroll (x1, y1, slen, barlen, col, min, max, value)
REM ***********************************
REM ** UPDATES VERTICAL SCROLL      ***
REM ***********************************
DIM tempcol

REM ** UPDATE BAR SKELETON ***
LINE (x1, y1 + 12)-STEP(11, slen - 25), 24, BF
LINE (x1, y1 + 11)-STEP(10, slen - 24), 0, B
LINE (x1 + 1, y1 + 12)-STEP(10, slen - 25), 8, B
LINE (x1 + 1, y1 + 12)-STEP(0, slen - 25), 15
LINE -STEP(9, 0), 15

REM *** DRAW THE BAR POINTER ***
blen$ = STR$(barlen - 2)
aval = CINT((value - min) / (max - min) * (slen - 23 - barlen))
LINE (x1 + 1, y1 + 11 + aval)-STEP(9, barlen - 1), 0, B
PSET (x1 + 1, y1 + 11 + aval): DRAW "c15 r9 dd" + blen$ + " c8 l9 u" + blen$

REM ** SHADED BAR ***
FOR gx1 = 0 TO 3
    LINE (x1 + 5 - gx1, y1 + 12 + aval)-STEP(0, barlen - 3), col - gx1
    LINE (x1 + 6 + gx1, y1 + 12 + aval)-STEP(0, barlen - 3), col - gx1
NEXT


END SUB

