'----------------------------------------------------------------------------
' DIRECTQB.BI
'   Include file for the DirectQB library version 1.3
'
' This file contains constants and function declarations used by the library
' Always include this file into your own programs!
'
' Detailed informations on how to use the library can be found into the
' DIRECTQB.DOC file; read it carefully!
'----------------------------------------------------------------------------

'$DYNAMIC
DEFINT A-Z

' 103 routine declarations
DECLARE FUNCTION DQBinit (BYVAL NumLayers, BYVAL NumSounds)
DECLARE FUNCTION DQBver ()
DECLARE FUNCTION DQBemsSeg ()
DECLARE FUNCTION DQBsetBit (BYVAL Value, BYVAL Bit)
DECLARE FUNCTION DQBresetBit (BYVAL Value, BYVAL Bit)
DECLARE FUNCTION DQBreadBit (BYVAL Value, BYVAL Bit)
DECLARE FUNCTION DQBtoggleBit (BYVAL Value, BYVAL Bit)
DECLARE FUNCTION DQBshiftLeft (BYVAL Value, BYVAL nBits)
DECLARE FUNCTION DQBshiftRight (BYVAL Value, BYVAL nBits)
DECLARE FUNCTION DQBdir$ (Mask AS STRING, Attributes AS INTEGER)
DECLARE FUNCTION DQBdrive$ ()
DECLARE FUNCTION DQBpath$ ()
DECLARE FUNCTION DQBnumDrives ()
DECLARE FUNCTION DQBpoint (BYVAL Layer, BYVAL x, BYVAL y)
DECLARE FUNCTION DQBsize (BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2)
DECLARE FUNCTION DQBfindCol (BYVAL Red, BYVAL Green, BYVAL Blue)
DECLARE FUNCTION DQBlen (Text AS STRING)
DECLARE FUNCTION DQBcreateBMap ()
DECLARE FUNCTION DQBloadBMap (FileName AS STRING)
DECLARE FUNCTION DQBsaveBMap (FileName AS STRING)
DECLARE FUNCTION DQBgetBMap (BYVAL ForeCol, BYVAL BackCol)
DECLARE FUNCTION DQBloadLayer (Layer AS INTEGER, FileName AS STRING, Pal AS STRING)
DECLARE FUNCTION DQBsaveLayer (Layer AS INTEGER, FileName AS STRING, Pal AS STRING, Format AS INTEGER)
DECLARE FUNCTION DQBkey (BYVAL ScanCode)
DECLARE FUNCTION DQBreadKey ()
DECLARE FUNCTION DQBasc (BYVAL ScanCode, BYVAL ShiftFlag)
DECLARE FUNCTION DQBinkey$ ()
DECLARE FUNCTION DQBjoyDetected (BYVAL JoyNum)
DECLARE FUNCTION DQBjoyMove (BYVAL JoyNum, BYVAL Direction)
DECLARE FUNCTION DQBjoyFire (BYVAL JoyNum, BYVAL Button)
DECLARE FUNCTION DQBmouseDetected ()
DECLARE FUNCTION DQBmouseX ()
DECLARE FUNCTION DQBmouseY ()
DECLARE FUNCTION DQBmouseLB ()
DECLARE FUNCTION DQBmouseRB ()
DECLARE FUNCTION DQBinstallSB (Channels AS INTEGER, BaseAddr AS INTEGER, IRQ AS INTEGER, DMA AS INTEGER)
DECLARE FUNCTION DQBloadSound (Slot AS INTEGER, FileName AS STRING)
DECLARE FUNCTION DQBloadRawSound (Slot AS INTEGER, FileName AS STRING, Offset AS LONG, Length AS LONG)
DECLARE FUNCTION DQBinUse (BYVAL Voice)
DECLARE SUB DQBsort (BYVAL ArraySeg, BYVAL ArrayOff, BYVAL NumElems)
DECLARE SUB DQBsetDrive (Drive AS STRING)
DECLARE SUB DQBcopyLayer (BYVAL SourceLayer, BYVAL DestLayer)
DECLARE SUB DQBcopyTransLayer (BYVAL SourceLayer, BYVAL DestLayer)
DECLARE SUB DQBclearLayer (BYVAL Layer)
DECLARE SUB DQBpset (BYVAL Layer, BYVAL x, BYVAL y, BYVAL Col)
DECLARE SUB DQBline (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBellipse (BYVAL Layer, BYVAL x, BYVAL y, BYVAL rx, BYVAL ry, BYVAL Col)
DECLARE SUB DQBbox (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBboxf (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBfilterBox (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL Col)
DECLARE SUB DQBscroll (BYVAL Layer, BYVAL dx, BYVAL dy)
DECLARE SUB DQBwait (BYVAL Times)
DECLARE SUB DQBsetTransPut ()
DECLARE SUB DQBsetSolidPut ()
DECLARE SUB DQBsetClipBox (BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2)
DECLARE SUB DQBget (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBput (BYVAL Layer, BYVAL x, BYVAL y, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBfPut (BYVAL Layer, BYVAL x, BYVAL y, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBsPut (BYVAL Layer, BYVAL x, BYVAL y, BYVAL BufSeg, BYVAL BufOff, BYVAL NewWidth, BYVAL NewHeight)
DECLARE SUB DQBrPut (BYVAL Layer, BYVAL x, BYVAL y, BYVAL BufSeg, BYVAL BufOff, BYVAL Angle, BYVAL Zoom)
DECLARE SUB DQBbPut (BYVAL Layer, BYVAL x, BYVAL y, BYVAL BufSeg, BYVAL BufOff)
DECLARE SUB DQBxPut (BYVAL SourceLayer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL DestLayer, BYVAL x, BYVAL y)
DECLARE SUB DQBsetCol (BYVAL ColorIndex, BYVAL Red, BYVAL Green, BYVAL Blue)
DECLARE SUB DQBgetCol (BYVAL ColorIndex, Red, Green, Blue)
DECLARE SUB DQBsetPal (Pal AS STRING)
DECLARE SUB DQBgetPal (Pal AS STRING)
DECLARE SUB DQBfadeIn (Pal AS STRING)
DECLARE SUB DQBfadeStepIn (Pal AS STRING)
DECLARE SUB DQBfadeTo (BYVAL Red, BYVAL Green, BYVAL Blue)
DECLARE SUB DQBfadeStepTo (BYVAL Red, BYVAL Green, BYVAL Blue)
DECLARE SUB DQBpalOff ()
DECLARE SUB DQBsetBMap (BYVAL ForeCol, BYVAL BackCol, BYVAL NewCol)
DECLARE SUB DQBprint (Layer AS INTEGER, Text AS STRING, x AS INTEGER, y AS INTEGER, Col AS INTEGER)
DECLARE SUB DQBprints (Layer AS INTEGER, Text AS STRING, x AS INTEGER, y AS INTEGER, Col AS INTEGER, Style AS INTEGER)
DECLARE SUB DQBsetBIOSfont ()
DECLARE SUB DQBsetFont (Font AS STRING)
DECLARE SUB DQBsetTransText ()
DECLARE SUB DQBsetSolidText ()
DECLARE SUB DQBsetTextStyle (BYVAL Style)
DECLARE SUB DQBsetTextBackCol (BYVAL Col)
DECLARE SUB DQBinstallKeyboard ()
DECLARE SUB DQBwaitKey (BYVAL ScanCode)
DECLARE SUB DQBremoveKeyboard ()
DECLARE SUB DQBpollJoy (BYVAL JoyNum)
DECLARE SUB DQBresetJoy ()
DECLARE SUB DQBsetMousePos (BYVAL x, BYVAL y)
DECLARE SUB DQBmouseShow ()
DECLARE SUB DQBmouseHide ()
DECLARE SUB DQBsetMouseRange (BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2)
DECLARE SUB DQBsetMouseShape (hotX AS INTEGER, hotY AS INTEGER, Shape AS STRING)
DECLARE SUB DQBsetMouseSpeed (BYVAL Hor, BYVAL Ver)
DECLARE SUB DQBresetMouse ()
DECLARE SUB DQBclose ()
DECLARE SUB DQBplaySound (BYVAL SoundNum, BYVAL Voice, BYVAL LoopFlag)
DECLARE SUB DQBsetVoiceVol (BYVAL Voice, BYVAL NewVol)
DECLARE SUB DQBpauseSound ()
DECLARE SUB DQBresumeSound ()
DECLARE SUB DQBstopVoice (BYVAL Voice)
DECLARE SUB DQBsetSamplingRate (Rate AS INTEGER)
DECLARE SUB DQBremoveSB ()
DECLARE SUB DQBsetVolume (BYVAL Volume)
DECLARE SUB DQBtri (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL x2, BYVAL y2, BYVAL x3, BYVAL y3, BYVAL Col)
DECLARE SUB DQBgtri (BYVAL Layer, BYVAL x1, BYVAL y1, BYVAL c1, BYVAL x2, BYVAL y2, BYVAL c2, BYVAL x3, BYVAL y3, BYVAL c3)

' Library constants
CONST FALSE = 0, TRUE = NOT FALSE
CONST VIDEO = 0, BSV = 0, BMP = 1, PCX = 2
CONST NONE = 0, SOLID = 1, BOLD = 2, ITALIC = 4, UNDERLINED = 8
CONST KEYESC = 1, KEYENTER = 28, KEYSPACE = 57
CONST KEYUP = 72, KEYDOWN = 80, KEYLEFT = 75, KEYRIGHT = 77
CONST UP = 0, DOWN = 1, LEFT = 2, RIGHT = 3
CONST JOY1 = 0, JOY2 = 1, GAMEPAD = 2
CONST BUTA = 0, BUTB = 1, BUTC = 2, BUTD = 3
CONST AUTO = -1, ONCE = 0, LOOPED = 1
CONST ATTRIB.R = &H1, ATTRIB.H = &H2, ATTRIB.S = &H4
CONST ATTRIB.L = &H8, ATTRIB.D = &H10, ATTRIB.A = &H20

