'
'                              -----> OTHELLO <-----
'       BY: JASON SORENSEN
'
'       FEEL FREE TO USE SUBS AND FUNCTIONS IN MY PROGRAM
'       AS LONG AS YOU GIVE DUE CREDIT, AND DO NOT STEAL TOO
'       MUCH.
'
'       VERSION 2.0
'       FINISHED 4/23/99
'
'       FEATURING FUNCTIONS FROM DQB
'       MANY THANKS TO FIREBALL AND _THE_BRAIN_
'
'$INCLUDE: 'DIRECTQB.BI'
DECLARE SUB getboard ()
DECLARE SUB movespot ()
DECLARE SUB showmenu ()
DECLARE SUB startothello ()
DECLARE SUB drawbutton (x1!, y1!, Text$)
DECLARE SUB drawwindow (x1!, y1!, x2!, y2!, Title$, c!)
DECLARE SUB save (file$)
DECLARE SUB comper ()
DECLARE SUB load (file$)
DECLARE SUB checkeys ()
DECLARE SUB setboard ()
DECLARE SUB delay (Repetitions%)
DECLARE SUB DetectSettings (BasePort%, IRQ%, LoDMA%, HiDMA%, CardType%, MPU401%)
DECLARE SUB DriversLoaded (SBMIDI%, SBSIM%)
DECLARE SUB GetBass (LeftChannel%, RightChannel%)
DECLARE SUB GetTreble (LeftChannel%, RightChannel%)
DECLARE SUB getmaster (LeftChannel%, RightChannel%)
DECLARE SUB GetMIDI (LeftChannel%, RightChannel%)
DECLARE SUB GetVoice (LeftChannel%, RightChannel%)
DECLARE SUB LoopMIDI ()
DECLARE SUB PauseMIDI ()
DECLARE SUB ResumeMIDI ()
DECLARE SUB PlayMIDI (Handle%)
DECLARE SUB SetBass (LeftChannel%, RightChannel%)
DECLARE SUB SetTreble (LeftChannel%, RightChannel%)
DECLARE SUB setmaster (LeftChannel%, RightChannel%)
DECLARE SUB SetMIDI (LeftChannel%, RightChannel%)
DECLARE SUB SetVoice (LeftChannel%, RightChannel%)
DECLARE SUB SetCard (CardType%)
DECLARE SUB stopmidi ()
DECLARE SUB InternalBitSet (Variable%, BitNum%, onoff%)
DECLARE SUB InternalBitToggle (Variable%, BitNum%)
DECLARE SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
DECLARE SUB InternalSetIntVector (IntNum%, Segment&, Offset&)
DECLARE SUB InternalGetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalSetVol (LeftChannel%, RightChannel%, Index%)
DECLARE SUB InternalWriteMixer (Index%, Value%)
DECLARE SUB IntX (IntNum AS INTEGER, Regs AS ANY)
DECLARE SUB unloadmidi (Handle%)
DECLARE SUB CleanUpMIDI ()
DECLARE FUNCTION MIDIError$ ()
DECLARE FUNCTION MixerChip$ ()
DECLARE FUNCTION MusicDone% ()
DECLARE FUNCTION aimoveworth! (movex!, movey!, depth!)
DECLARE FUNCTION dirworth! (x!, y!, dirx!, diry!, domove!)
DECLARE FUNCTION moveworth! (x!, y!, domove!)
DECLARE FUNCTION GetSynth% ()
DECLARE FUNCTION LoadMIDI% (FileName$)
DECLARE FUNCTION SoundCard$ (CardType%)
DECLARE FUNCTION TimeMIDI! ()
DECLARE FUNCTION InternalBitRead% (Variable%, BitNum%)
DECLARE FUNCTION InternalReadMixer% (Index%)
DECLARE FUNCTION MemUsed& (Handle%)
CLEAR , , 6000
ON ERROR GOTO death
'$DYNAMIC
TYPE Registers
	 AX    AS INTEGER
	 BX    AS INTEGER
	 CX    AS INTEGER
	 dx    AS INTEGER
	 BP    AS INTEGER
	 SI    AS INTEGER
	 DI    AS INTEGER
	 FLAGS AS INTEGER
	 DS    AS INTEGER
	 ES    AS INTEGER
END TYPE
IntXCodeData:
DATA  &H55, &H8B, &HEC, &H83, &HEC, &H08, &H56, &H57, &H1E, &H55, &H8B, &H5E
DATA  &H06, &H8B, &H47, &H10, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H10, &H8B, &H47, &H12, &H3D, &HFF, &HFF, &H75, &H04, &H1E, &H8F, &H47
DATA  &H12, &H8B, &H47, &H08, &H89, &H46, &HF8, &H8B, &H07, &H8B, &H4F, &H04
DATA  &H8B, &H57, &H06, &H8B, &H77, &H0A, &H8B, &H7F, &H0C, &HFF, &H77, &H12
DATA  &H07, &HFF, &H77, &H02, &H1E, &H8F, &H46, &HFA, &HFF, &H77, &H10, &H1F
DATA  &H8B, &H6E, &HF8, &H5B, &HCD, &H21, &H55, &H8B, &HEC, &H8B, &H6E, &H02
DATA  &H89, &H5E, &HFC, &H8B, &H5E, &H06, &H1E, &H8F, &H46, &HFE, &HFF, &H76
DATA  &HFA, &H1F, &H89, &H07, &H8B, &H46, &HFC, &H89, &H47, &H02, &H89, &H4F
DATA  &H04, &H89, &H57, &H06, &H58, &H89, &H47, &H08, &H89, &H77, &H0A, &H89
DATA  &H7F, &H0C, &H9C, &H8F, &H47, &H0E, &H06, &H8F, &H47, &H12, &H8B, &H46
DATA  &HFE, &H89, &H47, &H10, &H5A, &H1F, &H5F, &H5E, &H8B, &HE5, &H5D, &HCA
DATA  &H02, &H00
DIM SHARED QMIDIRegs AS Registers, MEM.SEGMENT(0 TO 255) AS INTEGER
DIM SHARED MIDI.PLAYTIME AS SINGLE, MIDI.ERROR AS INTEGER, PAUSED AS SINGLE
DIM SHARED SBMIDI.INTERRUPT AS INTEGER, MEM.ALLOCATED(0 TO 255) AS LONG
DIM SHARED SBSIM.INTERRUPT AS INTEGER, MIXER.CHIP AS INTEGER
DIM SHARED SB.BASEPORT AS INTEGER, SB.IRQ AS INTEGER
DIM SHARED SB.LODMA AS INTEGER, SB.HIDMA AS INTEGER, SB.CARDTYPE AS INTEGER
DIM SHARED SB.MPU401 AS INTEGER, BIT.STORAGE(0 TO 7) AS INTEGER
DIM SHARED SENSITIVE AS INTEGER, REVERSE.STEREO AS INTEGER
DIM SHARED SOUND.DISABLED AS INTEGER, CURRENTHANDLE AS INTEGER
DIM SHARED midable
DriversLoaded SBMIDI.INTERRUPT, SBSIM.INTERRUPT
IF SBMIDI.INTERRUPT <> 0 THEN midable = 1
IF SBSIM.INTERRUPT <> 0 THEN midable = 1
DEFINT A-Z
DIM SHARED Font AS STRING * 2305
DIM SHARED Pal AS STRING * 768
DIM SHARED boardtoload$
DIM SHARED time!
DIM SHARED moves AS INTEGER
DIM SHARED peice(4000) AS INTEGER
DIM SHARED board(10, 10) AS INTEGER
DIM SHARED turn AS INTEGER
DIM SHARED difflev AS INTEGER
DIM SHARED endturn AS INTEGER
DIM SHARED slower AS INTEGER
DIM SHARED totals(0 TO 2) AS INTEGER
DIM SHARED aicolor AS INTEGER
DIM SHARED numplay AS INTEGER
DIM SHARED victor AS INTEGER
DIM SHARED usermenu AS INTEGER
DIM SHARED restarting AS INTEGER
DIM SHARED wavs AS INTEGER
DIM SHARED midis AS INTEGER
DIM SHARED restarting2 AS INTEGER
DIM SHARED fontnum AS INTEGER
DIM SHARED coloring AS INTEGER
DIM SHARED textcolor AS INTEGER
DIM SHARED gameover AS INTEGER
DIM SHARED menuon AS INTEGER
dummy& = SETMEM(-70000)
RANDOMIZE TIMER
SCREEN 13
wavs = 1
x = DQBinit(9, 4)
DQBinitVGA
OPEN "small.fnt" FOR BINARY AS #1: GET #1, , Font: CLOSE #1
DQBsetFont Font
boardtoload$ = "start.brd"
IF DQBinstallSB(2, 22050, &H220, AUTO, AUTO) THEN DQBclose: PRINT DQBerror$: END
IF DQBloadRawSound(1, "start.wav", 1, 22568) THEN DQBclose: PRINT DQBerror$: END
IF DQBloadSound(2, "piece.wav") THEN DQBclose: PRINT DQBerror$: END
IF DQBloadRawSound(3, "error.wav", 1, 3128) THEN DQBclose: PRINT DQBerror$: END
IF DQBloadRawSound(4, "end.wav", 1, 22398) THEN DQBclose: PRINT DQBerror$: END
x = DQBmouseDetected
DQBresetMouse
DQBpalOff
IF DQBloadLayer(1, "peices.bmp", Pal) THEN DQBclose
DQBget 1, 20, 40, 39, 59, VARSEG(peice(0)), VARPTR(peice(0))
DQBget 1, 20, 60, 39, 79, VARSEG(peice(1000)), VARPTR(peice(1000))
DQBget 1, 20, 80, 39, 99, VARSEG(peice(2000)), VARPTR(peice(2000))
DQBget 1, 20, 101, 30, 113, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBsetPal Pal
PALETTE 4, 63 * (1 + 256 + 65536)
DQBgetPal Pal
DQBplaySound 1, 2, 11055, ONCE

numplay = 1
midis = 1
wavs = 1
difflev = 1
aicolor = 2
fontnum = 1

start:
DQBsetFont Font
startothello

startstuff:
DQBfadeTo 0, 0, 0
DQBinstallKeyboard
IF TimeMIDI! < 1 AND midis THEN PlayMIDI MIDI%
DQBsetPal Pal
DQBclearLayer 1
DQBclearLayer 2
FOR x1 = 0 TO 7
FOR x2 = 0 TO 7
board(x1 + 1, x2 + 1) = 0
DQBput 1, 6 + 21 * x1, 6 + 21 * x2, VARSEG(peice(0)), VARPTR(peice(0))
NEXT x2
NEXT x1
load (boardtoload$)
FOR x1 = 0 TO 7
FOR x2 = 0 TO 7
a = board(x1 + 1, x2 + 1)
IF a <> 0 THEN DQBput 2, 6 + 21 * x1, 6 + 21 * x2, VARSEG(peice(a * 1000)), VARPTR(peice(a * 1000))
NEXT x2
NEXT x1
FOR x = 1 TO 2
FOR y = 1 TO 2
DQBellipse 1, 47, 47, x, y, 0
DQBellipse 1, 47, 131, x, y, 0
DQBellipse 1, 131, 47, x, y, 0
DQBellipse 1, 131, 131, x, y, 0
NEXT y
NEXT x
DQBcopyLayer 1, 0
DQBcopyTransLayer 2, 0
DQBfadeIn Pal
totals(1) = 0
totals(0) = 0
FOR x = 1 TO 8
FOR y = 1 TO 8
there = board(x, y)
IF there = 1 THEN totals(1) = totals(1) + 1
IF there = 2 THEN totals(0) = totals(0) + 1
NEXT y
NEXT x

turn = 0
IF total MOD 2 THEN turn = 1
gameover = 0
slower = 0
victor = -1
restarting = 0
restarting2 = 0
menuon = 0
usermenu = 0
DQBsetMouseRange 0, 0, 317, 197

IF turn THEN DQBprint 1, "Turn: White", 180, 10, textcolor ELSE DQBprint 1, "Turn: Black", 180, 10, textcolor
DQBprint 1, "White Pieces:" + STR$(whitetotal), 180, 30, textcolor
DQBprint 1, "Black Pieces:" + STR$(blacktotal), 180, 40, textcolor
IF DQBmouseLB THEN slower = 1
IF numplay = 0 THEN DQBprint 1, "White Wins:" + STR$(ww) + " Black Wins:" + STR$(bw) + " Ties:" + STR$(tw), 0, 190, textcolor
movespot
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
DO
IF DQBmouseLB = 0 THEN slower = 0
IF (DQBmouseLB AND slower = 0) AND (numplay > 0) AND (menuon = 0) THEN
slower = 1
IF squareX < 9 AND squareY < 9 THEN
IF moveworth((squareX), (squareY), 0) < 1 THEN
DQBboxf 1, 0, 190, 300, 200, 0
IF wavs THEN DQBplaySound 3, 2, 11025, ONCE
DQBprint 1, "INVALID MOVE!", 0, 190, textcolor
time! = TIMER
ELSE
x = moveworth((squareX), (squareY), 1)
turn = 1 - turn
totals(1) = 0
totals(0) = 0
FOR x = 1 TO 8
FOR y = 1 TO 8
a = board(x, y)
IF a <> 0 THEN DQBput 2, 6 + 21 * (x - 1), 6 + 21 * (y - 1), VARSEG(peice(a * 1000)), VARPTR(peice(a * 1000))
IF a = 1 THEN totals(1) = totals(1) + 1
IF a = 2 THEN totals(0) = totals(0) + 1
NEXT y
NEXT x
movespot
IF wavs THEN DQBplaySound 2, 2, 11025, ONCE
END IF
END IF
END IF

IF MusicDone% AND midis THEN
oldsong = song
WHILE song = oldsong: song = FIX(RND * 5 + 1): WEND
unloadmidi MIDI%
IF song = 1 THEN MIDI% = LoadMIDI("othello1.mid")
IF song = 2 THEN MIDI% = LoadMIDI("othello2.mid")
IF song = 3 THEN MIDI% = LoadMIDI("othello3.mid")
IF song = 4 THEN MIDI% = LoadMIDI("othello4.mid")
IF song = 5 THEN MIDI% = LoadMIDI("othello5.mid")
IF song = 6 THEN MIDI% = LoadMIDI("othello6.mid")
PlayMIDI MIDI%
END IF

IF (turn = aicolor AND slower = 0) OR numplay = 0 THEN comper
squareX = FIX((DQBmouseX - 5) / 21 + 1)
squareY = FIX((DQBmouseY - 5) / 21 + 1)
IF squareX > 10 OR DQBmouseY < 5 THEN squareX = 10
IF squareY > 10 OR DQBmouseX < 5 THEN squareY = 10

IF TIMER - time! > 4 THEN DQBboxf 1, 0, 190, 240, 200, 0
DQBboxf 1, 180, 10, 320, 75, 0
IF turn THEN DQBprint 1, "Turn: White", 180, 10, textcolor ELSE DQBprint 1, "Turn: Black", 180, 10, textcolor
DQBprint 1, "White Pieces:" + STR$(totals(1)), 180, 30, textcolor
DQBprint 1, "Black Pieces:" + STR$(totals(0)), 180, 40, textcolor
DQBprint 1, "Moves:" + STR$(moves), 180, 60, textcolor
IF numplay = 0 THEN DQBprint 1, "White Wins:" + STR$(ww) + " Black Wins:" + STR$(bw) + " Ties:" + STR$(tw), 0, 190, textcolor
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
IF DQBmouseY < 5 OR usermenu OR menuon THEN showmenu
DQBput 3, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBwait 1
DQBcopyLayer 3, 0
IF DQBkey(KEYESC) THEN gameover = 2
LOOP UNTIL gameover OR restarting OR restarting2
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
DQBprint 1, "The Victor Is:", 180, 120, textcolor
IF victor = 1 THEN DQBprint 1, "White", 180, 130, textcolor: ww = ww + 1
IF victor = 0 THEN DQBprint 1, "Black", 180, 130, textcolor: bw = bw + 1
IF victor = 2 THEN DQBprint 1, "T'Was A Tie!", 180, 130, textcolor: tw = tw + 1
IF victor = -1 THEN DQBprint 1, "No one!", 180, 130, textcolor
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBcopyLayer 3, 0
IF restarting OR (numplay = 0 AND gameover <> 2) THEN SLEEP 1: GOTO startstuff
IF restarting2 THEN GOTO start
DQBcopyTransLayer 2, 1
DQBsetBIOSfont
again = 1
DQBclearLayer 8
drawwindow 110, 75, 210, 110, "Play Again?", (textcolor)
drawbutton 120, 90, "Yes"
drawbutton 170, 90, "No"
DO
DQBclearLayer 5
DQBput 5, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBboxf 3, 110, 75, 210, 110, textcolor
DQBcopyTransLayer 8, 3
DQBcopyTransLayer 5, 3
DQBwait 1
DQBcopyLayer 3, 0
IF DQBmouseLB AND DQBmouseY > 90 AND DQBmouseY < 105 THEN
IF DQBmouseX > 120 AND DQBmouseX < 158 THEN again = 0: playagain = 1
IF DQBmouseX > 170 AND DQBmouseX < 200 THEN again = 0: playagain = 0
END IF
LOOP WHILE again

DQBremoveKeyboard
DQBfadeTo 0, 0, 0
DQBclearLayer 0
DQBfadeIn Pal
IF playagain THEN GOTO start
IF wavs THEN DQBplaySound 4, 2, 11025, ONCE
DQBcopyLayer 6, 0
FOR x = 1 TO 200
DQBwait 1
DQBscroll 0, 0, -1
DQBline 0, 0, 0, 320, 0, 0
IF INKEY$ <> "" AND x > 10 THEN EXIT FOR
NEXT x
CLS
DQBsetFont Font
IF fontnum = 2 THEN DQBsetBIOSfont
DQBprint 0, "Thanks for playing!", CENTERED, 95, textcolor
SLEEP 1
death:
IF ERR THEN DQBboxf 0, 50, 75, 270, 125, 0: DQBbox 0, 50, 75, 270, 125, 255: DQBbox 0, 51, 76, 269, 124, 255
IF ERR = 53 THEN DQBprint 0, "ERROR: BAD FILE NAME - QUITING", CENTERED, 95, 4: SLEEP 3
IF ERR AND ERR <> 53 THEN DQBprint 0, "ERROR: CODE " + STR$(ERR) + " - QUITTING", CENTERED, 95, 4: SLEEP 3: RESUME death2
death2:
DQBfadeTo 0, 0, 0
DQBremoveSB
DQBclose
stopmidi
unloadmidi MIDI%
dummy& = SETMEM(100000)
CleanUpMIDI

REM $STATIC
DEFSNG A-Z
FUNCTION aimoveworth (movex, movey, depth)
	depth = depth - 1
	IF depth THEN
		IF moveworth((movex), (movey), -1) THEN
			DIM safeboard(10, 10) AS INTEGER
			DEF SEG = VARSEG(board(0, 0))
			BSAVE "array" + STR$(depth) + ".ary", VARPTR(board(0, 0)), 11 * 11 * 2
			oldvalue = moveworth((movex), (movey), 1)
			tops = -50
			turn = 1 - turn
			FOR x = 1 TO 64
				DQBcopyLayer 9, 3
				IF menuon OR usermenu OR DQBmouseY < 5 THEN showmenu
				DQBput 3, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
				DQBcopyLayer 3, 0
				IF endturn THEN endturn = 1: EXIT FOR
				Value = aimoveworth(INT(x / 8), (x MOD 8) + 1, (depth))
				IF Value > tops THEN tops = Value
			NEXT x
			turn = 1 - turn
			older = oldvalue - tops
			DEF SEG = VARSEG(board(0, 0))
			BLOAD "array" + STR$(depth) + ".ary", VARPTR(board(0, 0))
			ELSE
			older = -100
		END IF
	ELSE
		older = moveworth((movex), (movey), 0)
		IF older = 0 THEN older = -100
	END IF
 
	aimoveworth = older
END FUNCTION

REM $DYNAMIC
DEFINT A-Z
SUB CleanUpMIDI
FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) THEN unloadmidi I%
NEXT I%
MIDI.ERROR = 0
END SUB

SUB comper
	moved = 0
	movespot
	DQBcopyLayer 1, 9
	DQBcopyTransLayer 2, 9
	DQBprint 9, "Thinking....", 180, 90, textcolor
	endturn = 0
	tops = -100
	FOR x = 1 TO 8
	FOR y = 1 TO 8
		IF endturn THEN x = 8: y = 8
		Value = aimoveworth((x), (y), (difflev))
		DQBboxf 9, 173, 100, 300, 110, 0
		IF Value <> -100 THEN moved = moved + 1
		IF moves <> 0 THEN percent$ = STR$(INT(moved / moves * 100)): DQBprint 9, percent$ + "%", 173, 100, textcolor
		IF (Value = tops AND 3 * RND > 2) OR (Value > tops) THEN
			tops = Value
			topsx = x
			topsy = y
		END IF
	NEXT y
	NEXT x
IF tops <> -100 AND wavs THEN DQBplaySound 2, 2, 11025, ONCE
x = moveworth((topsx), (topsy), 1)
turn = 1 - turn
totals(1) = 0
totals(0) = 0
FOR x = 1 TO 8
FOR y = 1 TO 8
a = board(x, y)
IF a <> 0 THEN DQBput 2, 6 + 21 * (x - 1), 6 + 21 * (y - 1), VARSEG(peice(a * 1000)), VARPTR(peice(a * 1000))
IF a = 1 THEN totals(1) = totals(1) + 1
IF a = 2 THEN totals(0) = totals(0) + 1
NEXT y
NEXT x
movespot
END SUB

REM $STATIC
DEFSNG A-Z
FUNCTION dirworth (x, y, dirx, diry, domove)
	continue = 0
	origx = x
	origy = y
	WHILE continue = 0
		x = x + dirx
		y = y + diry
		IF x < 1 OR x > 8 OR y < 1 OR y > 8 THEN
			continue = -1
		ELSE
			IF board(x, y) = 2 - turn THEN
				continue = 1
			ELSE IF board(x, y) = 0 THEN continue = -1 ELSE total = total + 1
			END IF
		END IF
	WEND

	IF continue = 1 AND total > 0 THEN
		total = -1
		WHILE (x <> origx OR y <> origy)
			x = x - dirx
			y = y - diry
			total = total + 1
			IF (x ^ 2 - 9 * x + 8) * (y ^ 2 - 9 * y + 8) = 0 THEN total = total + 3
			IF (x ^ 2 - 9 * x + 8) = 0 AND (y ^ 2 - 9 * y + 8) = 0 THEN total = total + 8
			IF domove = 1 THEN board(x, y) = 2 - turn:
	       WEND
	       dirworth = total
	       END IF
END FUNCTION

SUB drawbutton (x1, y1, Text$)

x2 = x1 + (LEN(Text$) * 8) + 15
DQBboxf 8, x1, y1, x2, (y1 + 15), 1
DQBline 8, x1, y1, x1, (y1 + 14), 2
DQBline 8, x1, y1, (x2 - 1), y1, 2
DQBline 8, (x1 + 1), (y1 + 15), x2, (y1 + 15), 2
DQBline 8, x2, (y1 + 1), x2, (y1 + 15), 2
DQBprint 8, (Text$), (x1 + 8), (y1 + 4), (textcolor)

END SUB

SUB drawwindow (x1, y1, x2, y2, Title$, c)
color1 = 10
color2 = 24
color3 = 26
color4 = textcolor

DQBboxf 8, x1 + 1, y1 + 1, x2 + 1, y2 + 1, 1
DQBboxf 8, x1, y1, x2, y2, color3
DQBline 8, x1, y1, x1, (y2 - 1), color1
DQBline 8, x1, y1, (x2 - 1), y1, color1
DQBline 8, (x1 + 1), y2, x2, y2, color2
DQBline 8, x2, (y1 + 1), x2, y2, color2
DQBboxf 8, (x1 + 1), (y1 + 1), (x2 - 1), (y1 + 9), 1
tx% = (((x2 - x1) - (LEN(Title$) * 8)) \ 2) + x1
DQBprint 8, Title$, tx%, (y1 + 2), color4%

END SUB

REM $DYNAMIC
DEFINT A-Z
'DriversLoaded - Attempt to detect if sound drivers are loaded
SUB DriversLoaded (SBMIDI%, SBSIM%)
'Open the data file.
FF% = FREEFILE
OPEN "DRIVERS.DAT" FOR BINARY AS #FF%
FileSize& = LOF(FF%)
NoExist% = 0
'If the file is empty, return an error.
IF FileSize& = 0 THEN
	CLOSE FF%
	KILL "DRIVERS.DAT"
	MIDI.ERROR = 1
	NoExist% = 1
'If the file is not exactly 1,024 bytes in size, return an error.
ELSEIF FileSize& <> 1024 THEN
	CLOSE FF%
	MIDI.ERROR = 9
	NoExist% = 1
END IF

'If DRIVERS.DAT exists, and is 1 kilobyte in size, read the driver
'data from it.
IF NoExist% = 0 THEN
REDIM DRIVERDATA$(1 TO 5)
FOR I% = 1 TO 4
	DRIVERDATA$(I%) = INPUT$(256, #FF%)
NEXT I%
END IF

'Close the data file.
CLOSE #FF%

'Check the interrupt handlers for int 80h-FFh, to see if they are occupied
'by either SBMIDI or SBSIM.
SBMIDI% = 0
SBSIM% = 0
FOR I% = &H80 TO &HFF
	'Get the address of the interrupt handler.
	InternalGetIntVector I%, Segment&, Offset&
	'If the segment returned is 0, that means that the current interrupt
	'is not in use.
	IF Segment& = 0 THEN GOTO Skip:

	'The following code checks for the drivers by looking for the text
	'"SBMIDI" and "SBSIM" at certain locations in the driver code.
	'If it doesn't work, a different method is used.
	IF SBMIDI% = 0 THEN
	  DEF SEG = Segment& - 17
	  TEMP$ = ""
	  FOR J% = 1 TO 6
		TEMP$ = TEMP$ + CHR$(PEEK(271 + J%))
	  NEXT
	  IF TEMP$ = "SBMIDI" THEN SBMIDI% = I%
	END IF
	IF SBSIM% = 0 AND Segment& <> 0 THEN
		DEF SEG = Segment& - 1
		TEMP$ = ""
		FOR J% = 1 TO 5
			TEMP$ = TEMP$ + CHR$(PEEK(274 + J%))
		NEXT
		IF TEMP$ = "SBSIM" THEN SBSIM% = I%
	END IF
 
	'This is the second detection method.  It's more complex than the first
	'method, but not really any more accurate.
	IF NoExist% = 0 THEN
	'Point to the segment of the interrupt handler.
	DEF SEG = Segment&
	'Read 256 bytes of code from the interrupt handler.
	DRIVERDATA$(5) = ""
	FOR J% = 0 TO 255
		Byte% = PEEK(Offset& + J%)
		DRIVERDATA$(5) = DRIVERDATA$(5) + CHR$(Byte%)
	NEXT J%
	'Check to see if the code matches any of the data from DRIVERS.DAT.
	FOR J% = 1 TO 4
		MATCH% = 1
		FOR k% = 0 TO 255
			IF MID$(DRIVERDATA$(J%), k% + 1, 1) <> MID$(DRIVERDATA$(5), k% + 1, 1) THEN
				SELECT CASE k%
					CASE IS = 14, 15, 113, 114, 235, 236
					CASE ELSE
						MATCH% = 0
						EXIT FOR
				END SELECT
			END IF
		NEXT k%
		'If there was a match, find out which driver is using the interrupt.
		IF MATCH% THEN
			IF J% = 1 THEN SBSIM% = I%
			IF J% <> 1 THEN SBMIDI% = I%
		END IF
		'If both SBMIDI and SBSIM have been found, exit the loop.
		IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	NEXT J%
   
	'If both SBMIDI and SBSIM have been found, exit the loop.
	IF SBSIM% <> 0 AND SBMIDI% <> 0 THEN EXIT FOR
	END IF
Skip:
NEXT I%
IF NoExist% = 0 THEN MIDI.ERROR = 0
END SUB

REM $STATIC
SUB getboard
DIM boards$(100)
avails = 0
startused = 0
boards$(0) = DQBdir$("*.brd", ATTRIB.A)
IF boards$(0) = "START.BRD" THEN startused = 1
IF boards$(0) <> "" THEN
DO
avails = avails + 1
boards$(avails) = DQBdir$("", ATTRIB.A)
IF boards$(avails) = "START.BRD" THEN startused = 1
LOOP WHILE boards$(avails) <> ""
END IF
IF startused = 0 THEN boards$(avails) = "START.BRD": avails = avails + 1
FOR x = 1 TO avails - 1
FOR x2 = 1 TO avails - 1
IF boards$(x2) < boards$(x2 - 1) THEN safe$ = boards$(x2): boards$(x2) = boards$(x2 - 1): boards$(x2 - 1) = safe$
NEXT x2
NEXT x

DQBsetFont Font
DQBboxf 1, 180, 10, 320, 200, 0
DQBbox 1, 175, 37, 315, 170, 255
DQBline 1, 175, 160, 315, 160, 255
DQBline 1, 305, 37, 305, 160, 255
DQBline 1, 200, 160, 200, 170, 255
DQBprint 1, "Load", 177, 163, 255
DQBtri 1, 310, 40, 306, 44, 314, 44, 255
DQBtri 1, 310, 155, 306, 151, 314, 151, 255
DQBprint 1, "Available Boards", 180, 20, textcolor
DQBboxf 1, 176, 38, 314, 169, 0
FOR x = 0 TO avails - 1
DQBprint 1, boards$(x), 180, x * 10 + 40, textcolor
IF x > 10 THEN EXIT FOR
NEXT x
tempb$ = "START.BRD"
FileName$ = ""
startbrd = 0
WHILE FileName$ = "" AND DQBkey(KEYESC) = 0
IF DQBmouseLB = 0 THEN slower = 0
IF DQBmouseLB AND slower = 0 THEN
slower = 1
IF DQBmouseX > 180 AND DQBmouseX < 300 AND DQBmouseY > 40 AND DQBmouseY < 160 THEN
vboard = INT(DQBmouseY / 10 - 4) + startbrd
IF boards$(vboard) <> "" THEN tempb$ = boards$(vboard)
END IF
IF DQBmouseX > 180 AND DQBmouseX < 200 AND DQBmouseY > 160 AND DQBmouseY < 170 THEN FileName$ = tempb$
IF DQBmouseX > 305 AND DQBmouseX < 315 AND DQBmouseY > 150 AND DQBmouseY < 155 AND startbrd < avails - 12 THEN startbrd = startbrd + 1
IF DQBmouseX > 305 AND DQBmouseX < 315 AND DQBmouseY > 40 AND DQBmouseY < 45 AND startbrd > 0 THEN startbrd = startbrd - 1
END IF
DQBboxf 1, 176, 38, 314, 169, 0
DQBline 1, 175, 160, 315, 160, 255
DQBline 1, 305, 37, 305, 160, 255
DQBline 1, 200, 160, 200, 170, 255
DQBprint 1, "Load", 177, 163, 255
DQBtri 1, 310, 40, 306, 44, 314, 44, 255
DQBtri 1, 310, 155, 306, 151, 314, 151, 255
FOR x = startbrd TO avails - 1
DQBprint 1, boards$(x), 180, (x - startbrd) * 10 + 40, textcolor
IF x > startbrd + 10 THEN EXIT FOR
NEXT x
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBprint 3, tempb$, 203, 163, textcolor
DQBput 3, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBcopyLayer 3, 0
WEND
boardtoload$ = FileName$
restarting2 = 1
endturn = 1
END SUB

FUNCTION GetSynth%
QMIDIRegs.BX = 10
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
GetSynth% = QMIDIRegs.AX
END FUNCTION

REM $DYNAMIC
SUB InternalGetIntVector (IntNum%, Segment&, Offset&)
QMIDIRegs.AX = IntNum% + 13568
CALL IntX(&H21, QMIDIRegs)
Segment& = QMIDIRegs.ES
Offset& = QMIDIRegs.BX
END SUB

REM $STATIC
SUB IntX (IntNum AS INTEGER, Regs AS Registers) STATIC

STATIC filenum AS INTEGER, IntOffset AS INTEGER, Loaded AS INTEGER
		   
	' use fixed-length string to fix its position in memory
	' and so we don't mess up string pool before routine
	' gets its pointers from caller

DIM IntCode AS STRING * 200
IF NOT Loaded THEN                     ' loaded will be 0 first time
	RESTORE IntXCodeData:
   
	FOR k% = 1 TO 145
		READ h%
		MID$(IntCode, k%, 1) = CHR$(h%)
	NEXT

	'  determine address of interrupt no. offset in IntCode
  
	IntOffset% = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1
	Loaded% = -1
END IF

SELECT CASE IntNum
  
	CASE &H25, &H26, IS > 255               ' ignore these interrupts
  
	CASE ELSE
		DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
		POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum     ' code block
		CALL ABSOLUTE(Regs, VARPTR(IntCode$))               ' call routine
END SELECT

END SUB

SUB load (file$)
IF file$ = "start.brd" THEN
OPEN file$ FOR OUTPUT AS #1
PRINT #1, "0 0 0 0 0 0 0 0"
PRINT #1, "0 0 0 0 0 0 0 0"
PRINT #1, "0 0 0 0 0 0 0 0"
PRINT #1, "0 0 0 1 2 0 0 0"
PRINT #1, "0 0 0 2 1 0 0 0"
PRINT #1, "0 0 0 0 0 0 0 0"
PRINT #1, "0 0 0 0 0 0 0 0"
PRINT #1, "0 0 0 0 0 0 0 0"
CLOSE #1
END IF
IF DQBdir$(file$, ATTRIB.A) <> "" THEN OPEN file$ FOR INPUT AS #1
FOR x = 1 TO 8
IF EOF(1) THEN EXIT FOR
INPUT #1, board(x, 1), board(x, 2), board(x, 3), board(x, 4), board(x, 5), board(x, 6), board(x, 7), board(x, 8)
NEXT x
CLOSE #1
gameover = 0
movespot
IF gameover = 1 THEN
DQBboxf 0, 50, 77, 270, 118, 0
DQBbox 0, 50, 77, 270, 118, coloring
DQBbox 0, 51, 78, 269, 117, coloring
DQBsetFont Font
DQBprint 0, "Error in " + boardtoload$ + "!", CENTERED, 85, textcolor
DQBprint 0, "BAD BOARD - NO ONE CAN MOVE!", CENTERED, 95, textcolor
DQBprint 0, "USING start.brd INSTEAD", CENTERED, 105, textcolor
IF fontnum = 2 THEN DQBsetBIOSfont
time! = TIMER
WHILE DQBinkey$ = "" AND INKEY$ = "" AND TIMER - time! < 30: WEND
boardtoload$ = "start.brd"
load ("start.brd")
END IF
END SUB

REM $DYNAMIC
'LoadMIDI - loads a MIDI file into memory
FUNCTION LoadMIDI% (FileName$)
LoadMIDI% = -1
'See if an extension was supplied, and if not, add one.
IF INSTR(FileName$, ".") = 0 THEN FileName$ = FileName$ + ".MID"
'Open the file
FF% = FREEFILE
OPEN FileName$ FOR BINARY AS #FF%
FileLen& = LOF(FF%)
CLOSE #FF%
'If the file is empty, delete it and exit now.
IF FileLen& = 0 THEN KILL FileName$: MIDI.ERROR = 1: EXIT FUNCTION
'Make the filename an ASCIIZ string.
FileName$ = FileName$ + CHR$(0)

'Find an empty MIDI handle
NewHandle% = -1
FOR I% = 0 TO 255
	IF MEM.SEGMENT(I%) = 0 THEN NewHandle% = I%: EXIT FOR
NEXT I%
'If there are no empty handles, return an error.
IF NewHandle% = -1 THEN MIDI.ERROR = 12: EXIT FUNCTION
'Attempt to allocate a block of conventional memory.
QMIDIRegs.AX = &H4800
QMIDIRegs.BX = (FileLen& \ 16) + 1
CALL IntX(&H21, QMIDIRegs)
'If the block couldn't be allocated, it means there's not enough free
'memory.  To fix this, we need to ask BASIC to release some of the memory
'it's using:
IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
	'Find out how much memory is available, in kilobytes.
	LargestBlock& = QMIDIRegs.BX
	LargestBlock& = LargestBlock& * 16
	'Calculate the amount of memory that BASIC needs to release for us.
	MEM.ALLOCATED(NewHandle%) = (FileLen& + 2048) - LargestBlock&
	'Attempt to release the memory.
	a& = SETMEM(-MEM.ALLOCATED(NewHandle%))
	'Try again to allocate a block of memory
	QMIDIRegs.AX = &H4800
	QMIDIRegs.BX = (FileLen& \ 16) + 1
	CALL IntX(&H21, QMIDIRegs)
	'If the second attempt was unsuccessful, then there just isn't
	'enough memory, and an error needs to be returned.
	IF QMIDIRegs.AX = 7 OR QMIDIRegs.AX = 8 THEN
		'Give any memory we took back to BASIC.
		a& = SETMEM(650000)
		'Return an error.
		MIDI.ERROR = 2
		MEM.SEGMENT(NewHandle%) = 0
		'Abort.
		EXIT FUNCTION
	END IF
END IF
'If the memory was allocated successfully, store the segment
'of the memory block.
MEM.SEGMENT(NewHandle%) = QMIDIRegs.AX
MIDISegment& = QMIDIRegs.AX

'Open the MIDI file using a DOS interrupt.
QMIDIRegs.AX = &H3D00
QMIDIRegs.dx = SADD(FileName$)
QMIDIRegs.DS = VARSEG(FileName$)
CALL IntX(&H21, QMIDIRegs)
'Store the file handle.
Handle% = QMIDIRegs.AX
'Read the data from the file in 16 kilobyte increments.
FOR I& = 1 TO FileLen& STEP 16384
	QMIDIRegs.AX = &H3F00
	QMIDIRegs.CX = 16384
	QMIDIRegs.dx = 0
	QMIDIRegs.DS = VAL("&H" + HEX$(MIDISegment&))
	QMIDIRegs.BX = Handle%
	CALL IntX(&H21, QMIDIRegs)
	MIDISegment& = MIDISegment& + 1024
NEXT I&

'Close the file
QMIDIRegs.AX = &H3E00
QMIDIRegs.BX = Handle%
CALL IntX(&H21, QMIDIRegs)

MIDI.ERROR = 0
LoadMIDI% = NewHandle%
END FUNCTION

REM $STATIC
SUB LoopMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN PlayMIDI CURRENTHANDLE
END SUB

FUNCTION MemUsed& (Handle%)
MemUsed& = MEM.ALLOCATED(Handle%)
MIDI.ERROR = 0
END FUNCTION

REM $DYNAMIC
'MIDIError - Translates a QMIDI error code into text
FUNCTION MIDIError$
SELECT CASE MIDI.ERROR
		CASE 0: MIDIError$ = "NO ERROR"
		CASE 1: MIDIError$ = "FILE DOES NOT EXIST"
		CASE 2: MIDIError$ = "OUT OF MEMORY"
		CASE 3: MIDIError$ = "NO MIDI FILE PLAYING"
		CASE 4: MIDIError$ = "INVALID SBMIDI INTERRUPT"
		CASE 5: MIDIError$ = "INVALID SBSIM INTERRUPT"
		CASE 6: MIDIError$ = "NO MIXER CHIP"
		CASE 7: MIDIError$ = "COULD NOT DETECT SOUND CARD"
		CASE 8: MIDIError$ = "FEATURE UNAVAILABLE"
		CASE 9: MIDIError$ = "FILE IS CORRUPT"
		CASE 10: MIDIError$ = "INVALID SOUND CARD TYPE"
		CASE 11: MIDIError$ = "COULD NOT PLAY MUSIC"
		CASE 12: MIDIError$ = "ALL HANDLES IN USE"
		CASE 13: MIDIError$ = "INVALID HANDLE NUMBER"
		CASE ELSE: MIDIError$ = "UNKNOWN ERROR"
END SELECT
END FUNCTION

REM $STATIC
SUB movespot
moves = 0
FOR x = 1 TO 8
FOR y = 1 TO 8
	IF moveworth((x), (y), -1) > 1 THEN moves = moves + 1
NEXT y
NEXT x
IF moves = 0 THEN
	turn = 1 - turn
	FOR x = 1 TO 8
	FOR y = 1 TO 8
		IF moveworth((x), (y), -1) > 1 THEN moves = moves + 1
	NEXT y
	NEXT x
IF moves = 0 THEN
gameover = 1
IF totals(0) > totals(1) THEN victor = 0 ELSE victor = 1
IF totals(0) = totals(1) THEN victor = 2
ELSE IF numplay <> 0 THEN DQBboxf 1, 0, 190, 300, 200, 0: DQBprint 1, "NO MOVES AVAILABLE - MOVE FORFEITED", 0, 190, textcolor: time! = TIMER
END IF
END IF
END SUB

DEFSNG A-Z
FUNCTION moveworth (x, y, domove)
	total = 0
	IF board(x, y) = 0 THEN
		total = total + dirworth((x), (y), 1, 0, domove)
		IF (domove = -1) AND total THEN GOTO ender
		total = total + dirworth((x), (y), 1, 1, domove)
		IF (domove = -1) AND total THEN GOTO ender
		total = total + dirworth((x), (y), 0, 1, domove)
		IF (domove = -1) AND total THEN GOTO ender
		total = total + dirworth((x), (y), -1, 0, domove)
		IF (domove = -1) AND total THEN GOTO ender
		total = total + dirworth((x), (y), -1, 1, domove)
		IF (domove = -1) AND total THEN GOTO ender
		total = total + dirworth((x), (y), -1, -1, domove)
		IF (domove = -1) AND total THEN GOTO ender
		total = total + dirworth((x), (y), 1, -1, domove)
		IF (domove = -1) AND total THEN GOTO ender
		total = total + dirworth((x), (y), 0, -1, domove)
ender:
		IF total THEN total = total + 1
	END IF
moveworth = total
END FUNCTION

REM $DYNAMIC
DEFINT A-Z
FUNCTION MusicDone%
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT FUNCTION
IF MIDI.PLAYTIME = 0 THEN MIDI.ERROR = 3: EXIT FUNCTION
QMIDIRegs.BX = 11
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
IF QMIDIRegs.AX = 0 THEN QMIDIRegs.AX = -1 ELSE QMIDIRegs.AX = 0
MusicDone% = QMIDIRegs.AX
MIDI.ERROR = 0
END FUNCTION

'PauseMIDI - Pauses a MIDI file that is currently playing
SUB PauseMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If no MIDI file is playing, exit now
IF MIDI.PLAYTIME = 0 THEN
	MIDI.ERROR = 3
	EXIT SUB
END IF
'Call the SBSIM driver to pause the music.
QMIDIRegs.BX = 7
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
'Save the number of seconds that the MIDI file has been playing.
PAUSED = TimeMIDI!
'If the music hasn't been playing long enough for TimeMIDI! to return
'a value greater than 0, change PAUSED to a tiny positive value.
IF PAUSED = 0! THEN PAUSED = .00001
'Indicate that the file has stopped playing.
MIDI.PLAYTIME = 0
MIDI.ERROR = 0
END SUB

'PlayMIDI - Begins playing a MIDI file in the background.
SUB PlayMIDI (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If sound is not disabled....
IF SOUND.DISABLED = 0 THEN
	'Call the SBMIDI driver to begin playing the MIDI file.
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	QMIDIRegs.BX = 5
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	'If the music could not be started, return an error.
	IF QMIDIRegs.AX <> 0 THEN MIDI.ERROR = 11: EXIT SUB
	'Start the MIDI timer.
	MIDI.PLAYTIME = TIMER
	'Set the current handle.
	CURRENTHANDLE = Handle%
END IF
MIDI.ERROR = 0
END SUB

'ResumeMIDI - Starts playing a MIDI file after it has been paused
SUB ResumeMIDI
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'If the MIDI file is not paused, exit now
IF PAUSED = 0! THEN EXIT SUB
'Call the SBSIM driver to resume playing.
QMIDIRegs.BX = 8
CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
'Update the MIDI timer.
MIDI.PLAYTIME = TIMER - PAUSED
PAUSED = 0!
MIDI.ERROR = 0
END SUB

REM $STATIC
SUB save (file$)
overwrite = 1
x = INSTR(file$, ".")
IF x = 0 THEN x3 = LEN(file$) ELSE x3 = x
x2$ = MID$(file$, 1, x3)
IF LEN(x2$) > 8 THEN x2$ = MID$(file$, 1, 8): file$ = x2$ + ".brd": x = LEN(file$) - 4:
IF x = 0 THEN
file$ = file$ + ".brd"
ELSE
IF MID$(file$, x, x + 4) <> ".brd" THEN file$ = MID$(file$, 1, x - 1) + ".brd"
END IF
IF DQBdir$(file$, ATTRIB.A) <> "" THEN
DQBsetBIOSfont
again = 1
DQBclearLayer 8
drawwindow 110, 75, 210, 110, "Overwrite?", (textcolor)
drawbutton 120, 90, "Yes"
drawbutton 170, 90, "No"
DO
DQBclearLayer 5
DQBput 5, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBboxf 3, 110, 75, 210, 110, textcolor
DQBcopyTransLayer 8, 3
DQBcopyTransLayer 5, 3
DQBwait 1
DQBcopyLayer 3, 0
IF DQBmouseLB AND DQBmouseY > 90 AND DQBmouseY < 105 THEN
IF DQBmouseX > 120 AND DQBmouseX < 158 THEN again = 0: overwrite = 1
IF DQBmouseX > 170 AND DQBmouseX < 200 THEN again = 0: overwrite = 0
END IF
LOOP WHILE again
slower = 1
END IF
IF overwrite THEN
OPEN file$ FOR OUTPUT AS #1
FOR x = 1 TO 8
PRINT #1, board(x, 1), board(x, 2), board(x, 3), board(x, 4), board(x, 5), board(x, 6), board(x, 7), board(x, 8)
NEXT x
CLOSE #1
END IF
END SUB

REM $DYNAMIC
SUB setboard
DQBclearLayer 1
DQBclearLayer 2
again = 1
DQBsetFont Font
DQBbox 1, 290, 190, 319, 199, coloring
DQBprint 1, "Done", 295, 192, coloring
IF fontnum = 2 THEN DQBsetBIOSfont
FOR x1 = 0 TO 7
FOR x2 = 0 TO 7
board(x1 + 1, x2 + 1) = 0
DQBput 1, 6 + 21 * x1, 6 + 21 * x2, VARSEG(peice(0)), VARPTR(peice(0))
NEXT x2
NEXT x1
DQBput 1, 195, 6, VARSEG(peice(1000)), VARPTR(peice(1000))
DQBput 1, 195, 27, VARSEG(peice(2000)), VARPTR(peice(2000))
DQBbox 1, 195, 48, 214, 67, 255
DQBbox 1, 237, 6, 256, 25, 255
FOR x = 1 TO 2
FOR y = 1 TO 2
DQBellipse 1, 47, 47, x, y, 0
DQBellipse 1, 47, 131, x, y, 0
DQBellipse 1, 131, 47, x, y, 0
DQBellipse 1, 131, 131, x, y, 0
NEXT y
NEXT x
DQBcopyLayer 1, 0
DQBsetMouseRange 5, 5, 317, 197

DO
onX = FIX((DQBmouseX - 5) / 21 + 1)
onY = FIX((DQBmouseY - 5) / 21 + 1)
IF onX > 10 THEN onX = 10
IF onY > 10 THEN onY = 10
DQBput 2, 237, 6, VARSEG(peice(board(onX, onY) * 1000)), VARPTR(peice(board(onX, onY) * 1000))
IF board(onX, onY) = 0 THEN DQBboxf 2, 237, 6, 256, 25, 0
FOR x1 = 0 TO 7
FOR x2 = 0 TO 7
a = board(x1 + 1, x2 + 1)
IF a > 0 THEN DQBput 2, 6 + x1 * 21, 6 + 21 * x2, VARSEG(peice(a * 1000)), VARPTR(peice(a * 1000))
NEXT x2
NEXT x1

IF DQBmouseLB THEN
IF onX = 10 AND onY < 4 THEN
setcolor = onY
IF onY = 3 THEN setcolor = 0
END IF
IF onX < 9 AND onY < 9 THEN
board(onX, onY) = setcolor
IF setcolor = 0 THEN
board(onX, onY) = 0
DQBput 2, 6 + 21 * onX - 21, 6 + 21 * onY - 21, VARSEG(peice(0)), VARPTR(peice(0))
END IF
END IF
END IF

DQBclearLayer 5
DQBput 5, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBcopyTransLayer 5, 3
DQBwait 3
DQBcopyLayer 3, 0
IF (DQBmouseLB AND DQBmouseX > 290 AND DQBmouseY > 190) THEN again = 0
LOOP WHILE DQBkey(KEYESC) = 0 AND again
dqbmosueX = 6
save ("custom.brd")
boardtoload$ = "custom.brd"
END SUB

REM $STATIC
SUB showmenu
DQBsetFont Font
song = FIX(RND * 6 + 1)
menuon = 1
DQBclearLayer 4
white = DQBfindCol(63, 63, 63)
DQBboxf 4, 0, 0, 320, 10, white
DQBline 4, 0, 11, 320, 11, 0
blackish = DQBfindCol(5, 5, 5)
grey = DQBfindCol(50, 50, 50)
DQBprint 4, "File", 3, 3, blackish
DQBprint 4, "Wavs", 33, 3, blackish
IF midable THEN DQBprint 4, "Midis", 70, 3, blackish ELSE DQBprint 4, "Midis", 70, 3, DQBfindCol(50, 50, 50)
DQBprint 4, "Help", 110, 3, blackish
DQBboxf 4, 307, 0, 318, 10, grey
DQBline 4, 309, 2, 316, 8, blackish
DQBline 4, 309, 8, 316, 2, blackish

IF DQBmouseLB THEN
IF DQBmouseY <= 10 THEN usermenu = 0
IF DQBmouseY >= 2 AND DQBmouseY <= 10 THEN
IF DQBmouseX >= 3 AND DQBmouseX <= 20 THEN usermenu = 1
IF DQBmouseX >= 32 AND DQBmouseX <= 53 THEN usermenu = 2
IF DQBmouseX >= 69 AND DQBmouseX <= 93 THEN IF midable THEN usermenu = 3 ELSE usermenu = 0
IF DQBmouseX >= 307 AND DQBmouseX <= 318 THEN usermenu = 0: gameover = 2: endturn = 1
IF DQBmouseX >= 110 AND DQBmouseX <= 130 THEN
usermenu = 0
DQBfadeTo 0, 0, 0
DQBcopyLayer 7, 0
DQBfadeIn Pal
WHILE (DQBmouseLB = 0 OR DQBmouseX < 290 OR DQBmouseY < 190)
DQBcopyLayer 7, 3
DQBclearLayer 5
DQBput 5, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBcopyTransLayer 5, 3
DQBwait 3
DQBcopyLayer 3, 0
WEND
DQBfadeTo 0, 0, 0
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBcopyLayer 3, 0
DQBfadeIn Pal
END IF
END IF
END IF

IF usermenu = 1 THEN
usermenu = 0
DQBboxf 4, 1, 10, 40, 60, white
DQBprint 4, "Restart", 3, 12, blackish
DQBprint 4, "Save", 3, 22, blackish
DQBprint 4, "Load", 3, 32, blackish
DQBprint 4, "Custom", 3, 43, blackish
DQBprint 4, "Quit", 3, 53, blackish
IF DQBmouseLB THEN
IF DQBmouseX >= 3 AND DQBmouseX <= 35 AND DQBmouseY >= 12 AND DQBmouseY <= 20 THEN
DQBsetBIOSfont
again = 1
DQBclearLayer 8
drawwindow 110, 75, 210, 110, "Restart?", (textcolor)
drawbutton 120, 90, "Yes"
drawbutton 170, 90, "No"
DO
DQBclearLayer 5
DQBput 5, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBboxf 3, 110, 75, 210, 110, textcolor
DQBcopyTransLayer 8, 3
DQBcopyTransLayer 5, 3
DQBwait 1
DQBcopyLayer 3, 0
IF DQBmouseLB AND DQBmouseY > 90 AND DQBmouseY < 105 THEN
IF DQBmouseX > 120 AND DQBmouseX < 158 THEN again = 0: gameover = 1: endturn = 1
IF DQBmouseX > 170 AND DQBmouseX < 200 THEN again = 0
END IF
LOOP WHILE again
IF fontnum = 1 THEN DQBsetFont Font
END IF
IF DQBmouseX >= 3 AND DQBmouseX <= 23 AND DQBmouseY >= 22 AND DQBmouseY <= 30 THEN LOCATE 23, 1: DQBremoveKeyboard: INPUT "File Name: ", FileName$: save (FileName$): DQBinstallKeyboard
IF DQBmouseX >= 3 AND DQBmouseX <= 23 AND DQBmouseY >= 32 AND DQBmouseY <= 40 THEN getboard
IF DQBmouseX >= 3 AND DQBmouseX <= 35 AND DQBmouseY >= 42 AND DQBmouseY <= 50 THEN setboard: restarting2 = 1: endturn = 1
IF DQBmouseX >= 3 AND DQBmouseX <= 30 AND DQBmouseY >= 52 AND DQBmouseY <= 60 THEN gameover = 2: endturn = 1
END IF
IF DQBmouseY <= 10 OR (DQBmouseX >= 1 AND DQBmouseX <= 40 AND DQBmouseY >= 10 AND DQBmouseY <= 60) THEN usermenu = 1
END IF

IF usermenu = 2 THEN
usermenu = 0
DQBboxf 4, 30, 10, 60, 30, white
DQBprint 4, "On", 32, 12, blackish
DQBprint 4, "Off", 32, 22, blackish
IF DQBmouseLB THEN
IF DQBmouseX >= 32 AND DQBmouseX <= 60 AND DQBmouseY >= 12 AND DQBmouseY <= 20 THEN wavs = 1
IF DQBmouseX >= 32 AND DQBmouseX <= 60 AND DQBmouseY >= 22 AND DQBmouseY <= 30 THEN wavs = 0
END IF
IF DQBmouseY <= 10 OR (DQBmouseX >= 30 AND DQBmouseX <= 60 AND DQBmouseY >= 10 AND DQBmouseY <= 30) THEN usermenu = 2
END IF

IF usermenu = 3 THEN
usermenu = 0
DQBboxf 4, 70, 10, 112, 90, white
DQBprint 4, "Random", 71, 12, blackish
DQBprint 4, "Midi #1", 71, 22, blackish
DQBprint 4, "Midi #2", 71, 32, blackish
DQBprint 4, "Midi #3", 71, 42, blackish
DQBprint 4, "Midi #4", 71, 52, blackish
DQBprint 4, "Midi #5", 71, 62, blackish
DQBprint 4, "Midi #6", 71, 72, blackish
DQBprint 4, "Off", 71, 82, blackish
IF DQBmouseLB THEN
IF DQBmouseX <= 112 AND DQBmouseX >= 70 THEN
oldsong = song
IF DQBmouseY >= 12 AND DQBmouseY <= 20 THEN song = -1
IF DQBmouseY >= 22 AND DQBmouseY <= 30 THEN song = 1
IF DQBmouseY >= 32 AND DQBmouseY <= 40 THEN song = 2
IF DQBmouseY >= 42 AND DQBmouseY <= 50 THEN song = 3
IF DQBmouseY >= 52 AND DQBmouseY <= 60 THEN song = 4
IF DQBmouseY >= 62 AND DQBmouseY <= 70 THEN song = 5
IF DQBmouseY >= 72 AND DQBmouseY <= 80 THEN song = 6
IF song <> oldsong THEN
IF song = -1 THEN song = oldsong: WHILE song = olgsong: song = INT(RND * 6 + 1): WEND
midis = 1
unloadmidi MIDI%
IF song = 1 THEN MIDI% = LoadMIDI("othello1.mid")
IF song = 2 THEN MIDI% = LoadMIDI("othello2.mid")
IF song = 3 THEN MIDI% = LoadMIDI("othello3.mid")
IF song = 4 THEN MIDI% = LoadMIDI("othello4.mid")
IF song = 5 THEN MIDI% = LoadMIDI("othello5.mid")
IF song = 6 THEN MIDI% = LoadMIDI("othello6.mid")
PlayMIDI MIDI%
END IF
IF DQBmouseY >= 82 AND DQBmouseY <= 90 THEN stopmidi: midis = 0
END IF
END IF
IF DQBmouseY <= 10 OR (DQBmouseX >= 70 AND DQBmouseX <= 112 AND DQBmouseY >= 10 AND DQBmouseY <= 90) THEN usermenu = 3
END IF
DQBcopyTransLayer 4, 3
IF fontnum = 2 THEN DQBsetBIOSfont
IF DQBmouseY > 10 THEN menuon = 0
END SUB

SUB startothello
DIM onoff$(2)
DIM aicol$(3)
DIM fontsize$(2)
onoff$(1) = "On"
onoff$(2) = "Off"
aicol$(1) = "Black"
aicol$(2) = "White"
aicol$(3) = "Random"
fontsize$(1) = "Default"
fontsize$(2) = "Large"
DQBclearLayer 0
DQBclearLayer 1
DQBclearLayer 2
DQBclearLayer 8
DQBclearLayer 5
slow = 0
IF DQBmouseLB THEN slow = 1
IF aicolor = -1 THEN aicolor = 2

whiter = 4
dcoloring = 255
coloring = DQBfindCol(37, 0, 0)
textcolor = DQBfindCol(37, 0, 0)
DQBline 1, 0, 68, 320, 68, coloring
DQBline 1, 0, 2 * 68, 320, 2 * 68, coloring
DQBline 1, 160, 0, 160, 200, coloring
DQBbox 1, 0, 0, 319, 199, coloring
DQBprint 1, "Number of Players", 2, 2, coloring
DQBprint 1, "Midis", 163, 2, coloring
DQBprint 1, "AI Thinking Depth", 2, 70, coloring
DQBprint 1, "Wav Files", 163, 70, coloring
DQBprint 1, "AI Color", 2, 138, coloring
DQBprint 1, "Font Size", 163, 138, coloring
FOR x = 1 TO 3
DQBprint 1, STR$(x - 1), 8 + 20 * (x - 1), 30, coloring
DQBbox 1, 4 + 20 * (x - 1), 30, 9 + 20 * (x - 1), 35, coloring
NEXT x
FOR x = 1 TO 6
DQBprint 1, STR$(x), 8 + 20 * (x - 1), 98, coloring
DQBbox 1, 4 + 20 * (x - 1), 98, 9 + 20 * (x - 1), 103, coloring
NEXT x
FOR x = 1 TO 2
DQBprint 1, onoff$(x), 173 + 26 * (x - 1), 30, coloring
DQBbox 1, 164 + 26 * (x - 1), 30, 169 + 26 * (x - 1), 35, coloring
NEXT x
FOR x = 1 TO 2
DQBprint 1, onoff$(x), 173 + 26 * (x - 1), 98, coloring
DQBbox 1, 164 + 26 * (x - 1), 98, 169 + 26 * (x - 1), 103, coloring
NEXT x
FOR x = 1 TO 3
DQBprint 1, aicol$(x), 13 + 37 * (x - 1), 98 + 68, coloring
DQBbox 1, 4 + 37 * (x - 1), 98 + 68, 9 + 37 * (x - 1), 103 + 68, coloring
NEXT x
FOR x = 1 TO 2
DQBprint 1, fontsize$(x), 173 + 47 * (x - 1), 98 + 68, coloring
DQBbox 1, 164 + 47 * (x - 1), 98 + 68, 169 + 47 * (x - 1), 103 + 68, coloring
NEXT x

DQBbox 1, 290, 190, 319, 199, coloring
DQBprint 1, "Done", 295, 192, coloring
DQBcopyLayer 1, 0

DQBsetMouseRange 0, 0, 317, 197

IF midable = 0 THEN DQBprint 1, "No Midi Support Detected", 164, 45, coloring: DQBprint 1, "Try Running othello.bat", 164, 55, coloring
song = FIX(RND * 6 + 1)
IF midable AND TimeMIDI = 0 THEN
IF song = 1 THEN MIDI% = LoadMIDI("othello1.mid")
IF song = 2 THEN MIDI% = LoadMIDI("othello2.mid")
IF song = 3 THEN MIDI% = LoadMIDI("othello3.mid")
IF song = 4 THEN MIDI% = LoadMIDI("othello4.mid")
IF song = 5 THEN MIDI% = LoadMIDI("othello5.mid")
IF song = 6 THEN MIDI% = LoadMIDI("othello6.mid")
END IF
looping = 1
WHILE looping
IF DQBmouseLB = 0 THEN slow = 0
IF DQBmouseLB THEN
IF DQBmouseX > 290 AND DQBmouseY > 190 AND slow = 0 THEN looping = 0

IF DQBmouseY > 30 AND DQBmouseY < 35 THEN
IF DQBmouseX > 4 AND DQBmouseX < 9 THEN numplay = 0
IF DQBmouseX > 24 AND DQBmouseX < 29 THEN numplay = 1
IF DQBmouseX > 44 AND DQBmouseX < 49 THEN numplay = 2
IF DQBmouseX > 164 AND DQBmouseX < 169 THEN midis = 1
IF DQBmouseX > 190 AND DQBmouseX < 195 THEN midis = 0
END IF

IF DQBmouseY > 98 AND DQBmouseY < 103 THEN
IF DQBmouseX > 4 AND DQBmouseX < 9 THEN difflev = 1
IF DQBmouseX > 24 AND DQBmouseX < 29 THEN difflev = 2
IF DQBmouseX > 44 AND DQBmouseX < 49 THEN difflev = 3
IF DQBmouseX > 64 AND DQBmouseX < 69 THEN difflev = 4
IF DQBmouseX > 84 AND DQBmouseX < 89 THEN difflev = 5
IF DQBmouseX > 104 AND DQBmouseX < 109 THEN difflev = 6
IF DQBmouseX > 164 AND DQBmouseX < 169 THEN wavs = 1
IF DQBmouseX > 190 AND DQBmouseX < 195 THEN wavs = 0
END IF

IF DQBmouseY > 166 AND DQBmouseY < 171 THEN
IF DQBmouseX > 4 AND DQBmouseX < 9 THEN aicolor = 0
IF DQBmouseX > 4 + 37 AND DQBmouseX < 9 + 37 THEN aicolor = 1
IF DQBmouseX > 4 + 2 * 37 AND DQBmouseX < 9 + 2 * 37 THEN aicolor = 2
IF DQBmouseX > 164 AND DQBmouseX < 169 THEN fontnum = 1
IF DQBmouseX > 211 AND DQBmouseX < 216 THEN fontnum = 2
END IF

END IF
DQBclearLayer 2
IF midis = 1 AND midable = 0 THEN midis = 0
IF numplay = 0 THEN DQBbox 2, 6, 32, 7, 33, dcoloring
IF numplay = 1 THEN DQBbox 2, 26, 32, 27, 33, dcoloring
IF numplay = 2 THEN DQBbox 2, 46, 32, 47, 33, dcoloring
IF midis = 1 THEN DQBbox 2, 166, 32, 167, 33, dcoloring
IF midis = 0 THEN DQBbox 2, 192, 32, 193, 33, dcoloring
IF difflev = 1 THEN DQBbox 2, 6, 100, 7, 101, dcoloring
IF difflev = 2 THEN DQBbox 2, 26, 100, 27, 101, dcoloring
IF difflev = 3 THEN DQBbox 2, 46, 100, 47, 101, dcoloring
IF difflev = 4 THEN DQBbox 2, 66, 100, 67, 101, dcoloring
IF difflev = 5 THEN DQBbox 2, 86, 100, 87, 101, dcoloring
IF difflev = 6 THEN DQBbox 2, 106, 100, 107, 101, dcoloring
IF wavs = 1 THEN DQBbox 2, 166, 100, 167, 101, dcoloring
IF wavs = 0 THEN DQBbox 2, 192, 100, 193, 101, dcoloring
IF aicolor = 0 THEN DQBbox 2, 6, 168, 7, 169, dcoloring
IF aicolor = 1 THEN DQBbox 2, 43, 168, 44, 169, dcoloring
IF aicolor = 2 THEN DQBbox 2, 80, 168, 81, 169, dcoloring
IF fontnum = 1 THEN DQBbox 2, 166, 168, 167, 169, dcoloring
IF fontnum = 2 THEN DQBbox 2, 213, 168, 214, 169, dcoloring

IF midable AND midis AND TimeMIDI! = 0 THEN PlayMIDI MIDI%
IF midis = 0 THEN stopmidi

DQBcopyLayer 1, 3
DQBcopyTransLayer 2, 3
DQBclearLayer 5
DQBput 5, DQBmouseX, DQBmouseY, VARSEG(peice(3000)), VARPTR(peice(3000))
DQBcopyTransLayer 5, 3
DQBcopyLayer 3, 0
WEND

IF fontnum = 2 THEN DQBsetBIOSfont
IF aicolor = 2 THEN aicolor = INT(RND * 2)
IF midis = 1 AND midable = 0 THEN midis = 0
IF numplay = 2 THEN aicolor = -1

DQBclearLayer 6
DQBprint 6, "Music from various classical artists", CENTERED, 90, textcolor
DQBprint 6, "Sounds are from Quake 1,", CENTERED, 110, textcolor
DQBprint 6, "C&C: Red Alert and Chessmaster", CENTERED, 120, textcolor
DQBprint 6, "Visit my website for the recent", CENTERED, 140, textcolor
DQBprint 6, "Version At http://qbasic.tsx.org", CENTERED, 150, textcolor
DQBprint 6, "Input is appreciated.", CENTERED, 170, textcolor
DQBprint 6, "Game by: Jason Sorensen", CENTERED, 180, textcolor
DQBprint 6, "My E-Mail is raven@vortexQ.com", CENTERED, 190, textcolor
DQBclearLayer 7
DQBsetFont Font
DQBprint 7, "Controlls:", CENTERED, 10, textcolor
DQBprint 7, "Left Click: Place Piece", CENTERED, 20, textcolor
DQBprint 7, "Rules:", CENTERED, 50, textcolor
DQBprint 7, "You start off the game with 4 'dics' in the center of an 8x8", CENTERED, 70, textcolor
DQBprint 7, "board. Black starts off the game, and places a disc, so that", CENTERED, 80, textcolor
DQBprint 7, "a white disc is between it, and another black disc. Then both", CENTERED, 90, textcolor
DQBprint 7, "sides take turns in placing discs the same way. The disc", CENTERED, 100, textcolor
DQBprint 7, "flipping is stopped at the first disc of you own color", CENTERED, 110, textcolor
DQBprint 7, "you come across. All of these rules will become very clear", CENTERED, 120, textcolor
DQBprint 7, "once you play the game. The game is over when no one can move.", CENTERED, 130, textcolor
DQBprint 7, "The winner is the person with the most discs on the board", CENTERED, 140, textcolor
DQBprint 7, "at the end of the game.", CENTERED, 150, textcolor
DQBbox 7, 290, 190, 319, 199, coloring
DQBprint 7, "Done", 295, 192, coloring
IF fontnum = 2 THEN DQBsetBIOSfont

END SUB

REM $DYNAMIC
'StopMIDI - Stops playing MIDI file
SUB stopmidi
IF SBMIDI.INTERRUPT < &H80 AND SENSITIVE <> 0 THEN MIDI.ERROR = 4: EXIT SUB
'Call the SBMIDI driver to stop the music.
IF MIDI.PLAYTIME THEN
	QMIDIRegs.BX = 4
	QMIDIRegs.dx = MEM.SEGMENT(CURRENTHANDLE)
	QMIDIRegs.AX = 0
	CALL IntX(SBMIDI.INTERRUPT, QMIDIRegs)
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
MIDI.PLAYTIME = 0
END SUB

FUNCTION TimeMIDI!
'If a MIDI file is paused, lock the current playing time
IF PAUSED > 0! THEN
	TimeMIDI! = PAUSED
	MIDI.ERROR = 0
'If a MIDI file is playing, carry out the timing routine
ELSEIF MIDI.PLAYTIME THEN
	'Get the current time
	CurrentTime! = TIMER
	'If midnight has come since the MIDI file started playing, change
	'CurrentTime! accordingly
	IF CurrentTime! - MIDI.PLAYTIME < 0 THEN
		CurrentTime! = 86400 + CurrentTime!
	END IF
	'Get the final result
	TimeMIDI! = CurrentTime! - MIDI.PLAYTIME
	MIDI.ERROR = 0
ELSE
	MIDI.ERROR = 3
END IF
END FUNCTION

REM $STATIC
SUB unloadmidi (Handle%)
IF Handle% < 0 OR Handle% > 255 THEN MIDI.ERROR = 13: EXIT SUB
'If a block of memory was allocated to hold the MIDI file....
IF MEM.SEGMENT(Handle%) THEN
	'Release the block of memory.
	QMIDIRegs.ES = MEM.SEGMENT(Handle%)
	QMIDIRegs.AX = &H4900
	CALL IntX(&H21, QMIDIRegs)
	'Give back all the memory we took from BASIC.
	a& = SETMEM(650000)
END IF
MEM.SEGMENT(Handle%) = 0
MEM.ALLOCATED(Handle%) = 0
MIDI.ERROR = 0
END SUB

