
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''''           Pac-Classic: "The Definitive BASIC Pac-Man"                ''''
''''         Beta Version 0.2  Written by Phillip Jay Cohen               ''''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
				
DEFINT A-Z                ' Declares and set-up
'$DYNAMIC

CONST False = 0           ' Logical, no?
CONST True = NOT False

CONST SoundLength = 266    ' for sound support/mixing
CONST ForeGround = 0
CONST BackGround = 1
CONST Silent = 0

CONST BackNorm = 1         ' more for sounds...
CONST BackEner = 2
CONST BackEyes = 3

CONST Eat1 = 1             ' even more for sounds
CONST Eat2 = 2
CONST EatBonus = 3
CONST EatGhost = 4
CONST PacDying = 5

CONST None = 0              ' Keyboard support, and directions
CONST Up = 1
CONST Right = 2
CONST Down = 3
CONST Left = 4
CONST UpKey = 72
CONST RightKey = 77
CONST DownKey = 80
CONST LeftKey = 75
			    ' Screen offsets for centering maze
CONST ScrX = 47
CONST ScrY = 23

CONST Normal = 0            ' Determine Ghost-monsters actions
CONST Scared = 1
CONST Eyes = 2
CONST Eyes2 = 3
CONST InBox = 4
CONST Wander = 5

TYPE SoundType
  Effect AS INTEGER
  LastEffect AS INTEGER
  Counter AS INTEGER
  MaxCount AS INTEGER
END TYPE

TYPE PacType                ' Determine Pac-Classics actions
 X AS INTEGER
 Y AS INTEGER
 Dir AS INTEGER
 NewDir AS INTEGER
END TYPE

TYPE GhostType              ' more for Ghost-monsters
 X AS INTEGER
 Y AS INTEGER
 StartX AS INTEGER
 Dir AS INTEGER
 StartDir AS INTEGER
 BoxCount AS INTEGER
 NewDir1 AS INTEGER
 NewDir2 AS INTEGER
 Culler AS INTEGER
 State AS INTEGER
 Counter AS INTEGER
 Speed AS INTEGER
 Wandered AS INTEGER
END TYPE

TYPE EnerType
  HCoord AS INTEGER
  VCoord AS INTEGER
END TYPE

TYPE PanMaskType
 Pan1 AS LONG
 Pan2 AS LONG
END TYPE

TYPE PlayerType
  Level AS INTEGER
  Lives AS INTEGER
  Score AS LONG
  DotsEaten AS INTEGER
  EnersEaten AS INTEGER
  FirstTime AS INTEGER
END TYPE

COMMON SHARED DMA%, Baseport%, PgPort%, AddPort%, LenPort%, ModeReg%
COMMON SHARED SoundEnabled, SoundWanted       ' Variables for sound routines

COMMON SHARED JoyEnabled, JoySensX, JoySensY  ' Needed for joystick support
COMMON SHARED JoyXMin, JoyXMax, JoyXMid
COMMON SHARED JoyYMin, JoyYMax, JoyYMid

COMMON SHARED PlayerUp
COMMON SHARED TwoPlayer
COMMON SHARED AdvanceLevel
COMMON SHARED Pac AS PacType
COMMON SHARED PacDead
COMMON SHARED CurDir
COMMON SHARED NumGhosts
COMMON SHARED GhostsEaten
COMMON SHARED PacAnim
COMMON SHARED GhostAnim
COMMON SHARED BonusCount
COMMON SHARED PointsCount
COMMON SHARED FlashOn
COMMON SHARED FlashCounter
COMMON SHARED HighScore&
COMMON SHARED GhostTimer
COMMON SHARED NoSound

COMMON SHARED Apage
COMMON SHARED Top

COMMON SHARED ScrWidth, ScrHeight 'remove

DECLARE SUB SoundMix ()            ' These routines modified from DMAPLAY
DECLARE SUB SoundPlay ()           ' By Mike Huff and Toshi Horie
DECLARE FUNCTION SoundDone% ()
DECLARE FUNCTION DSPReset% ()
DECLARE SUB DSPWrite (Byte%)
DECLARE SUB SoundSpeaker (OnOff%)
DECLARE SUB SoundDMA ()
DECLARE SUB SoundBLASTER ()
DECLARE SUB SoundInit ()

DECLARE FUNCTION TestWall (X, Y)   ' All other routines are my own
DECLARE FUNCTION TestWall2 (X, Y)
DECLARE FUNCTION TestDot (X, Y)
DECLARE FUNCTION TestEner (X, Y)
DECLARE SUB MenuSetup ()
DECLARE SUB PacPrint (X, Y, Text$, Culler)
DECLARE SUB PacCenter (Y, Text$, Culler)
DECLARE SUB FastJoy (JoyX%, JoyY%, JoyNum%)
DECLARE SUB Pal (Clr, Red, Grn, Blu)
DECLARE SUB PacPal ()
DECLARE SUB EgaPixel (X, Y, Culler)
DECLARE SUB EgaLine (X1, Y1, X2, Y2, Culler)
DECLARE SUB EgaPan (Y)
DECLARE SUB EgaScreen ()
DECLARE SUB LevelInit ()
DECLARE SUB MazePlot (X, Y)
DECLARE SUB MazeBorder ()
DECLARE SUB GhostHouse ()
DECLARE SUB FrameInit ()
DECLARE SUB FrameDisp ()
DECLARE SUB SpritePut (X, Y, Sprite())
DECLARE SUB SpriteErase (X, Y)
DECLARE SUB MovePac ()
DECLARE SUB MoveGhost (I)
DECLARE SUB MoveGhosts ()
DECLARE SUB DrawPac ()
DECLARE SUB DrawGhosts ()
DECLARE SUB DrawMisc (H, V, Draw$)
DECLARE SUB PutGhost (I)
DECLARE SUB MainLoop ()
DECLARE SUB LoadIt ()
DECLARE SUB FinishIt ()
DECLARE SUB GetInputs ()
DECLARE SUB MenuMain ()
DECLARE SUB MenuCredits ()
DECLARE SUB Delay (P!)
DECLARE SUB BlankFrame ()
DECLARE SUB ScorePrint ()

DIM SHARED Font(5120)
DIM SHARED BitMask(0 TO 7)
DIM SHARED XMask(0 TO 319)
DIM SHARED PanMask(0 TO 1139) AS PanMaskType

DIM SHARED YOffset(0 TO 288)

DIM SHARED Maze(2, -2 TO 31, -2 TO 34) AS INTEGER
DIM SHARED Ghost(1 TO 4) AS GhostType
DIM SHARED Player(1 TO 2) AS PlayerType
DIM SHARED Energizers(1 TO 4) AS EnerType

DIM SHARED GhostPats(1 TO 3, 1 TO 9, 1 TO 3) AS INTEGER

DIM SHARED EatSound1(0 TO 5) AS STRING * SoundLength    ' Store sounds in
DIM SHARED EatSound2(0 TO 5) AS STRING * SoundLength    ' extened memory
DIM SHARED BonusSound(0 TO 22) AS STRING * SoundLength
DIM SHARED GhostSound(0 TO 48) AS STRING * SoundLength
DIM SHARED DeathSound(0 TO 90) AS STRING * SoundLength

DIM SHARED BackSound1(0 TO 23) AS STRING * SoundLength
DIM SHARED BackSound2(0 TO 22) AS STRING * SoundLength
DIM SHARED BackSound3(0 TO 19) AS STRING * SoundLength
DIM SHARED BackSound4(0 TO 17) AS STRING * SoundLength
DIM SHARED BackSound5(0 TO 16) AS STRING * SoundLength
DIM SHARED EnerSound(0 TO 16) AS STRING * SoundLength
DIM SHARED EyesSound(0 TO 15) AS STRING * SoundLength

DIM SHARED Sounds(0 TO 1) AS STRING * SoundLength  ' 0 is fore, 1 is back
DIM SHARED SoundVars(0 TO 1) AS SoundType          ' for sound mixing

DIM SHARED PacSprite1(0 TO 15, 0 TO 15)       ' sprites
DIM SHARED PacSprite2(0 TO 15, 0 TO 15)
DIM SHARED PacSprite3(0 TO 15, 0 TO 15)

DIM SHARED Deathsprite1(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite2(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite3(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite4(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite5(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite6(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite7(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite8(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite9(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite10(0 TO 15, 0 TO 15)
DIM SHARED Deathsprite11(0 TO 15, 0 TO 15)

DIM SHARED Ghost4Left(0 TO 15, 0 TO 15)
DIM SHARED Ghost3Left(0 TO 15, 0 TO 15)
DIM SHARED Ghost4Right(0 TO 15, 0 TO 15)
DIM SHARED Ghost3Right(0 TO 15, 0 TO 15)
DIM SHARED Ghost4Up(0 TO 15, 0 TO 15)
DIM SHARED Ghost3Up(0 TO 15, 0 TO 15)
DIM SHARED Ghost4Down(0 TO 15, 0 TO 15)
DIM SHARED Ghost3Down(0 TO 15, 0 TO 15)
DIM SHARED Ghost4Scared(0 TO 15, 0 TO 15)
DIM SHARED Ghost3Scared(0 TO 15, 0 TO 15)

DIM SHARED GhostScore1(0 TO 15, 0 TO 15)
DIM SHARED GhostScore2(0 TO 15, 0 TO 15)
DIM SHARED GhostScore3(0 TO 15, 0 TO 15)
DIM SHARED GhostScore4(0 TO 15, 0 TO 15)

DIM SHARED Bonus1(0 TO 15, 0 TO 15)
DIM SHARED Bonus2(0 TO 15, 0 TO 15)
DIM SHARED Bonus3(0 TO 15, 0 TO 15)
DIM SHARED Bonus4(0 TO 15, 0 TO 15)
DIM SHARED Bonus5(0 TO 15, 0 TO 15)
DIM SHARED Bonus6(0 TO 15, 0 TO 15)
DIM SHARED Bonus7(0 TO 15, 0 TO 15)
DIM SHARED Bonus8(0 TO 15, 0 TO 15)

DIM SHARED LivesSprite(0 TO 15, 0 TO 15)

'ON ERROR GOTO Finished

RANDOMIZE TIMER '256

LoadIt
SCREEN 7, , 0, 0
EgaScreen
PacPal
MenuMain

Finished: FinishIt
'Finished: PCOPY 0, 1: SLEEP

MazeDats: ' Image mapping data for maze rendering
	  ' Each character represents an 8x8 pixel square
'     0123456789012345678901234567
DATA "2------------12------------1"
DATA "|............||............|"
DATA "|.2--1.2---1.||.2---1.2--1.|"
DATA "|o|  |.|   |.||.|   |.|  |o|"
DATA "|.3--4.3---4.34.3---4.3--4.|"
DATA "|..........................|"
DATA "|.2--1.21.2------1.21.2--1.|"
DATA "|.3--4.||.3--12--4.||.3--4.|"
DATA "|......||....||....||......|"
DATA "3----1.|3--1 || 2--4|.2----4"
DATA "     |.|2--4G34G3--1|.|     "
DATA "     |.||          ||.|     "
DATA "     |.|| 6-LCCR-5 ||.|     "
DATA "-----4.34 |      | 34.3-----"
DATA "      .   |      |   .      "
DATA "-----1.21 |      | 21.2-----"
DATA "     |.|| 7------8 ||.|     "
DATA "     |.||          ||.|     "
DATA "     |.|| 2------1 ||.|     "
DATA "2----4.34 3--12--4 34.3----1"
DATA "|............||............|"
DATA "|.2--1.2---1.||.2---1.2--1.|"
DATA "|.3-1|.3---4.34.3---4.|2-4.|"
DATA "|o..||.......  .......||..o|"
DATA "3-1.||.21.2------1.21.||.2-4"
DATA "2-4.34.||.3--12--4.||.34.3-1"
DATA "|......||....||....||......|"
DATA "|.2----43--1.||.2--43----1.|"
DATA "|.3--------4.34.3--------4.|"
DATA "|..........................|"
DATA "3--------------------------4"

BlinkyPattern:
DATA 4, 9, 11
DATA 3, 9, 14
DATA 4, 6, 14
DATA 1, 6, 5
DATA 2, 21, 5
DATA 1, 21, 1
DATA 2, 26, 1
DATA 3, 26, 5
DATA 4, 25, 5
PinkyPattern:
DATA 4, 9, 11
DATA 3, 9, 14
DATA 4, 6, 14
DATA 1, 6, 1
DATA 4, 1, 1
DATA 3, 1, 5
DATA 2, 6, 5
DATA 1, 6, 1
DATA 4, 1, 1
InkyPattern:
DATA 4, 9, 11
DATA 3, 9, 20
DATA 0, 0, 0
DATA 0, 0, 0
DATA 0, 0, 0
DATA 0, 0, 0
DATA 0, 0, 0
DATA 0, 0, 0
DATA 0, 0, 0

REM $STATIC
SUB BlankFrame
Apage = NOT Apage
SELECT CASE Apage
 CASE 0: DEF SEG = &HA000
 CASE -1: DEF SEG = &HAA00
END SELECT
PanTop = Top
IF Apage = 0 THEN PanTop = PanTop + 1024
WAIT &H3DA, 8, 8
EgaPan PanTop
WAIT &H3DA, 8
WAIT &H3DA, 8, 8
END SUB

SUB Delay (P!)
T! = TIMER + P!
DO
GetInputs
BlankFrame
LOOP UNTIL TIMER >= T!
END SUB

REM $DYNAMIC
SUB DrawGhosts
FOR I = NumGhosts TO 1 STEP -1
PutGhost I
NEXT I
END SUB

REM $STATIC
SUB DrawMisc (H, V, Draw$)
SELECT CASE Draw$
CASE "o"
IF FlashOn THEN
FOR C = 2 TO 5
EgaLine C + H + ScrX, V + ScrY, H + ScrX + C, V + ScrY + 7, 5
EgaLine H + ScrX, V + ScrY + C, H + ScrX + 7, V + ScrY + C, 5
NEXT C
EgaPixel H + 48, V + 24, 5
EgaPixel H + 53, V + 24, 5
EgaPixel H + 48, V + 29, 5
EgaPixel H + 53, V + 29, 5
END IF
CASE "Pts"
EgaLine H, V, H, V + 4, 15
EgaLine H + 1, V, H + 3, V, 15
EgaLine H + 1, V + 2, H + 3, V + 2, 15
EgaPixel H + 4, V + 1, 15
EgaLine H + 6, V, H + 10, V, 15
EgaLine H + 8, V + 1, H + 8, V + 4, 15
EgaLine H + 13, V, H + 16, V, 15
EgaPixel H + 12, V + 1, 15
EgaLine H + 13, V + 2, H + 15, V + 2, 15
EgaPixel H + 16, V + 3, 15
EgaLine H + 12, V + 4, H + 15, V + 4, 15
CASE ELSE
FOR Digit = 1 TO LEN(Draw$)
SELECT CASE MID$(Draw$, Digit, 1)
CASE "0"
EgaLine H + 2 + (5 * (Digit - 1)), V, H + 3 + (5 * (Digit - 1)), V, 3
EgaLine H + 2 + (5 * (Digit - 1)), V + 6, H + 3 + (5 * (Digit - 1)), V + 6, 3
EgaLine H + 1 + (5 * (Digit - 1)), V + 1, H + 1 + (5 * (Digit - 1)), V + 5, 3
EgaLine H + 4 + (5 * (Digit - 1)), V + 1, H + 4 + (5 * (Digit - 1)), V + 5, 3
CASE "1"
EgaLine H + 2 + (5 * (Digit - 1)), V, H + 2 + (5 * (Digit - 1)), V + 6, 3
EgaPixel H + 1 + (5 * (Digit - 1)), V + 1, 3
EgaPixel H + 1 + (5 * (Digit - 1)), V + 6, 3
EgaPixel H + 3 + (5 * (Digit - 1)), V + 6, 3
CASE "2"
EgaLine H + 1 + (5 * (Digit - 1)), V, H + 3 + (5 * (Digit - 1)), V, 3
EgaLine H + (5 * (Digit - 1)), V + 6, H + 4 + (5 * (Digit - 1)), V + 6, 3
EgaLine H + (5 * (Digit - 1)), V + 1, H + (5 * (Digit - 1)), V + 2, 3
EgaLine H + 4 + (5 * (Digit - 1)), V + 1, H + 4 + (5 * (Digit - 1)), V + 2, 3
EgaPixel H + 3 + (5 * (Digit - 1)), V + 3, 3
EgaPixel H + 2 + (5 * (Digit - 1)), V + 4, 3
EgaPixel H + 1 + (5 * (Digit - 1)), V + 5, 3
CASE "3"
EgaLine H + (5 * (Digit - 1)), V, H + 4 + (5 * (Digit - 1)), V, 3
EgaPixel H + 3 + (5 * (Digit - 1)), V + 1, 3
EgaPixel H + 2 + (5 * (Digit - 1)), V + 2, 3
EgaPixel H + 3 + (5 * (Digit - 1)), V + 3, 3
EgaLine H + 4 + (5 * (Digit - 1)), V + 4, H + 4 + (5 * (Digit - 1)), V + 5, 3
EgaLine H + 1 + (5 * (Digit - 1)), V + 6, H + 3 + (5 * (Digit - 1)), V + 6, 3
EgaPixel H + (5 * (Digit - 1)), V + 5, 3
CASE "5"
EgaLine H + (5 * (Digit - 1)), V, H + 4 + (5 * (Digit - 1)), V, 3
EgaPixel H + (5 * (Digit - 1)), V + 1, 3
EgaLine H + (5 * (Digit - 1)), V + 2, H + 3 + (5 * (Digit - 1)), V + 2, 3
EgaLine H + 1 + (5 * (Digit - 1)), V + 6, H + 3 + (5 * (Digit - 1)), V + 6, 3
EgaLine H + 4 + (5 * (Digit - 1)), V + 3, H + 4 + (5 * (Digit - 1)), V + 5, 3
EgaPixel H + (5 * (Digit - 1)), V + 5, 3
CASE "7"
EgaLine H + (5 * (Digit - 1)), V, H + 4 + (5 * (Digit - 1)), V, 3
EgaPixel H + (5 * (Digit - 1)), V + 1, 3
EgaPixel H + 4 + (5 * (Digit - 1)), V + 1, 3
EgaLine H + 3 + (5 * (Digit - 1)), V + 2, H + 3 + (5 * (Digit - 1)), V + 3, 3
EgaLine H + 2 + (5 * (Digit - 1)), V + 4, H + 2 + (5 * (Digit - 1)), V + 6, 3
END SELECT
NEXT
END SELECT
END SUB

REM $DYNAMIC
SUB DrawPac

FOR V = 0 TO 15
FOR H = 0 TO 15
SELECT CASE PacAnim
CASE 1, 2, 5, 6
Pixl = PacSprite1(H, V)
CASE 3, 4
Pixl = PacSprite2(H, V)
CASE 7, 8
Pixl = PacSprite3(H, V)
END SELECT
IF Pixl THEN
SELECT CASE CurDir
CASE Right
EgaPixel Pac.X + H - 5, Pac.Y + V - 5, 14
CASE Left
EgaPixel Pac.X + (11 - H), Pac.Y + V - 5, 14
CASE Down
EgaPixel Pac.X + V - 5, Pac.Y + H - 5, 14
CASE Up
EgaPixel Pac.X + V - 5, Pac.Y + (11 - H), 14
END SELECT
END IF
NEXT H: NEXT V
END SUB

FUNCTION DSPReset%
ct = 0: stat = 0: ready = &HAA
OUT Baseport% + &H6, 1
DO
OUT Baseport% + &H6, 0
stat = INP(Baseport% + &HE)
stat = INP(Baseport% + &HA)
IF stat = ready THEN EXIT DO
ct = ct + 1
LOOP WHILE ct < 100 'wait about 100 ms
IF stat = ready THEN DSPReset% = 1 ELSE DSPReset% = 0
END FUNCTION

SUB DSPWrite (Byte%)
' Writes a byte to the DSP
DO: LOOP WHILE INP(Baseport% + 12) AND &H80
OUT Baseport% + 12, Byte%
END SUB

SUB EgaLine (X1, Y1, X2, Y2, Culler)
IF X1 = X2 THEN
 Mask = XMask(X1)
 OUT &H3CE, 8: OUT &H3CF, Mask
FOR P = Y1 TO Y2
 Offset = YOffset(P) + (X1 \ 8)
 Byte = PEEK(Offset)
 POKE Offset, Culler
 NEXT P
ELSE
 FOR P = X1 TO X2
  EgaPixel P, Y1, Culler
 NEXT P
END IF
END SUB

SUB EgaPan (Y)

OUT &H3D4, 13: OUT &H3D5, PanMask(Y).Pan1
OUT &H3D4, 12: OUT &H3D5, PanMask(Y).Pan2

END SUB

 SUB EgaPixel (X, Y, Culler)
 Offset = YOffset(Y) + (X \ 8)
 Mask = XMask(X)
 OUT &H3CE, 8: OUT &H3CF, Mask
 Byte = PEEK(Offset)
 POKE Offset, Culler
 END SUB

SUB EgaScreen
OUT &H3CE, 5: OUT &H3CF, 2
END SUB

SUB FastJoy (JoyX%, JoyY%, JoyNum%)
' Fast joystick routines by Phillip Jay Cohen

' JoyX% returns vertical postion of specified joystick
' JoyY% returns horizontal postion of specified joystick
' JoyNum% specifies whether joystick number one or two is to be read

SELECT CASE JoyNum% ' Choose appropriate bitmasks
CASE 1
XMask% = 1
YMask% = 2
CASE 2
XMask% = 4
YMask% = 8
CASE ELSE
EXIT SUB
END SELECT
JoyX% = 1: JoyY% = 1
OUT &H201, 0 ' Reset joystick port
DO
  Joy% = INP(&H201) ' Poll joystick port
  IF Joy% AND XMask% THEN JoyX% = JoyX% + 1
  IF Joy% AND YMask% THEN JoyY% = JoyY% + 1
LOOP UNTIL (Joy% AND XMask%) = 0 AND (Joy% AND YMask%) = 0
END SUB

SUB FinishIt

IF SoundWanted THEN
Bug = DSPReset%
SoundSpeaker 0
END IF

DEF SEG
PacPal
EgaPan 0
SCREEN 7, , 0, 0
CLS : PALETTE
SCREEN 0: WIDTH 80
COLOR 14
PRINT "Pac Classic Beta Version 0.2"
COLOR 15
PRINT "Coded by Phillip Jay Cohen"
COLOR 7

OPEN "PACLASSC.SCR" FOR BINARY AS #1
PUT #1, 1, HighScore&
CLOSE

ERASE Font
ERASE BitMask
ERASE XMask
ERASE PanMask

ERASE YOffset

ERASE Maze
ERASE Ghost
ERASE Energizers

ERASE PacSprite1
ERASE PacSprite2
ERASE PacSprite3

ERASE Deathsprite1
ERASE Deathsprite2
ERASE Deathsprite3
ERASE Deathsprite4
ERASE Deathsprite5
ERASE Deathsprite6
ERASE Deathsprite7
ERASE Deathsprite8
ERASE Deathsprite9
ERASE Deathsprite10
ERASE Deathsprite11

ERASE Ghost4Left
ERASE Ghost3Left
ERASE Ghost4Right
ERASE Ghost3Right
ERASE Ghost4Up
ERASE Ghost3Up
ERASE Ghost4Down
ERASE Ghost3Down
ERASE Ghost4Scared
ERASE Ghost3Scared

ERASE GhostScore1
ERASE GhostScore2
ERASE GhostScore3
ERASE GhostScore4

ERASE Bonus1
ERASE Bonus2
ERASE Bonus3
ERASE Bonus4
ERASE Bonus5
ERASE Bonus6
ERASE Bonus7
ERASE Bonus8

ERASE LivesSprite

E = ERR
SELECT CASE E
CASE 0
CASE 53
PRINT
PRINT "Data file missing..."
PRINT "Check my homepage at http://members.xoom.com/pjcohen"
PRINT "or email me at p.j.cohen@usa.net for a new copy."
CASE ELSE
PRINT
PRINT "I messed up, but hey that's what betas are for!"
PRINT "Check my homepage at http://members.xoom.com/pjcohen"
PRINT "or email me at p.j.cohen@usa.net to see if I've released a new version."
END SELECT
END

END SUB

SUB FrameDisp

'IF SoundWanted THEN SoundPlay ' AND NoSound = False

FOR MazeWidth = 30 TO 46
EgaLine MazeWidth, 130, MazeWidth, 146, 0
EgaLine MazeWidth + 242, 130, MazeWidth + 242, 146, 0
NEXT MazeWidth

'SWAP Apage, VPage
Apage = NOT Apage
SELECT CASE Apage
 CASE False: DEF SEG = &HA000
 CASE True: DEF SEG = &HAA00     '(512 per page
END SELECT

PanTop = Top
'IF VPage = 1 THEN PanTop = PanTop + 1024
IF Apage = 0 THEN PanTop = PanTop + 1024

'IF SoundWanted THEN SoundPlay

WAIT &H3DA, 8, 8
EgaPan PanTop
WAIT &H3DA, 8

SpriteErase Pac.X, Pac.Y
FOR I = 1 TO NumGhosts
SpriteErase Ghost(I).X, Ghost(I).Y
NEXT I
FOR V = 8 TO 15
EgaLine 47, V, 271, V, 0
NEXT V

WAIT &H3DA, 8, 8

'IF SoundWanted THEN 'AND NoSound = False THEN
'DO: LOOP UNTIL SoundDone
'END IF

FlashCounter = FlashCounter + 1       ' Flash Power Pills
IF FlashCounter = 15 THEN
 FlashOn = NOT FlashOn
 FlashCounter = 0
END IF

IF Pac.X < 37 AND Pac.Dir = Left THEN
Pac.X = 276
ELSEIF Pac.X > 276 AND Pac.Dir = Right THEN
Pac.X = 37
END IF

FOR I = 1 TO NumGhosts
IF Ghost(I).X < 37 AND Ghost(I).Dir = Left THEN
Ghost(I).X = 276
ELSEIF Ghost(I).X > 277 AND Ghost(I).Dir = Right THEN
Ghost(I).X = 37
END IF
NEXT I
GhostAnim = GhostAnim + 1: IF GhostAnim = 9 THEN GhostAnim = 0
END SUB

SUB FrameInit

GhostHouse

FOR Ener = 1 TO 4
'EnerH = Energizers(Ener, 1): EnerV = Energizers(Ener, 2)
IF Maze(PlayerUp, Energizers(Ener).HCoord, Energizers(Ener).VCoord) = 111 AND FlashOn THEN
FOR C = 2 TO 5
EgaLine C + (Energizers(Ener).HCoord * 8 + ScrX), (Energizers(Ener).VCoord * 8 + ScrY), (Energizers(Ener).HCoord * 8 + ScrX) + C, (Energizers(Ener).VCoord * 8 + ScrY) + 7, 5
EgaLine (Energizers(Ener).HCoord * 8 + ScrX), (Energizers(Ener).VCoord * 8 + ScrY) + C, (Energizers(Ener).HCoord * 8 + ScrX) + 7, (Energizers(Ener).VCoord * 8 + ScrY) + C, 5
NEXT C
EgaPixel Energizers(Ener).HCoord * 8 + 48, Energizers(Ener).VCoord * 8 + 24, 5
EgaPixel Energizers(Ener).HCoord * 8 + 53, Energizers(Ener).VCoord * 8 + 24, 5
EgaPixel Energizers(Ener).HCoord * 8 + 48, Energizers(Ener).VCoord * 8 + 29, 5
EgaPixel Energizers(Ener).HCoord * 8 + 53, Energizers(Ener).VCoord * 8 + 29, 5
ELSE
FOR C = 0 TO 7
EgaLine C + (Energizers(Ener).HCoord * 8 + ScrX), (Energizers(Ener).VCoord * 8) + 23, C + (Energizers(Ener).HCoord * 8 + ScrX), (Energizers(Ener).VCoord * 8) + 30, 0
NEXT C
END IF
NEXT Ener
END SUB

SUB GetInputs
Kbd$ = UCASE$(INKEY$)
IF Kbd$ = CHR$(27) THEN MenuMain
IF LEN(Kbd$) = 2 THEN
Kbd = ASC(RIGHT$(Kbd$, 1))
SELECT CASE Kbd
CASE LeftKey: Pac.NewDir = Left
CASE UpKey: Pac.NewDir = Up
CASE RightKey: Pac.NewDir = Right
CASE DownKey: Pac.NewDir = Down
END SELECT
END IF
IF JoyEnabled THEN
FastJoy JoyX, JoyY, 1
JoyMinTestX = ABS(JoyX - JoyXMin)
JoyMaxTestX = ABS(JoyX - JoyXMax)
JoyMidTestX = ABS(JoyX - JoyXMid)
JoyMinTestY = ABS(JoyY - JoyYMin)
JoyMaxTestY = ABS(JoyY - JoyYMax)
JoyMidTestY = ABS(JoyY - JoyYMid)
IF (JoyMinTestX < JoySensX) AND (JoyCenTestY < JoySensY) THEN Pac.NewDir = Left
IF (JoyMinTestY < JoySensY) AND (JoyCenTestX < JoySensX) THEN Pac.NewDir = Up
IF (JoyMaxTestX < JoySensX) AND (JoyCenTestY < JoySensY) THEN Pac.NewDir = Right
IF (JoyMaxTestY < JoySensY) AND (JoyCenTestX < JoySensX) THEN Pac.NewDir = Down
END IF
END SUB

SUB GhostHouse
EgaLine 133, 125, 146, 125, 1     'Draw Interior Border
EgaLine 171, 125, 183, 125, 1     ' of Ghost House
EgaLine 133, 126, 133, 150, 1
EgaLine 183, 126, 183, 150, 1
EgaLine 133, 151, 183, 151, 1
EgaLine 148, 125, 169, 125, 0
END SUB

SUB LevelInit
NoSound = True
PacDead = False
Pac.X = 156: Pac.Y = 207
Pac.Dir = Left: Pac.NewDir = None
FOR I = 1 TO NumGhosts
Ghost(I).X = Ghost(I).StartX
Ghost(I).Y = 135
Ghost(I).Dir = Ghost(I).StartDir
Ghost(I).State = InBox
Ghost(I).Counter = 0
Ghost(I).Speed = 1
Ghost(I).Wandered = False
NEXT I
Ghost(1).Y = 111: Ghost(1).State = Wander
GhostTimer = 0
CurDir = Left
PacAnim = 1
GhostAnim = 0
BonusCount = 0
PointsCount = 0

IF Player(PlayerUp).FirstTime = True OR AdvanceLevel = True THEN
EnerCount = 0
FOR MazeHeight = -2 TO 34
FOR MazeWidth = -2 TO 31
IF MazeHeight <> 14 THEN Maze(PlayerUp, MazeWidth, MazeHeight) = 127 ELSE Maze(PlayerUp, MazeWidth, MazeHeight) = 32
NEXT MazeWidth
NEXT MazeHeight
RESTORE MazeDats              ' Read Maze Mapping Data
FOR MazeHeight = 0 TO 30
CurChar$ = SPACE$(28)
READ CurChar$
FOR MazeWidth = 0 TO 27
MidChar = ASC(MID$(CurChar$, MazeWidth + 1, 1))
IF MidChar = 111 THEN
EnerCount = EnerCount + 1
Energizers(EnerCount).HCoord = MazeWidth
Energizers(EnerCount).VCoord = MazeHeight
END IF
Maze(PlayerUp, MazeWidth, MazeHeight) = MidChar
NEXT MazeWidth, MazeHeight
AdvanceLevel = False
END IF

Top = 91: EgaPan Top '91
FOR I = 0 TO 1
GetInputs
FrameInit
FOR ScrHeight = ScrY TO 272 STEP 16
FOR ScrWidth = ScrX TO ScrX + 224 STEP 16
SpriteErase ScrWidth, ScrHeight
NEXT: NEXT
GhostHouse
MazeBorder
PacCenter 0, "HIGH SCORE", 15
PacCenter 111, SPACE$(10), 0
FOR H = 58 TO 262
EgaLine H, 270, H, 288, 0
NEXT H
FOR L = 1 TO Player(PlayerUp).Lives - 1
SpritePut L * 16 + 47, 275, LivesSprite()
NEXT L
IF Player(PlayerUp).Level > 5 THEN D = Player(PlayerUp).Level - 4 ELSE D = 1
B = 0
FOR F = D TO Player(PlayerUp).Level
B = B + 1
SELECT CASE F
CASE 3, 4: SpritePut 255 - (B * 16), 275, Bonus3()
CASE 5, 6: SpritePut 255 - (B * 16), 275, Bonus5()
CASE 7, 8: SpritePut 255 - (B * 16), 275, Bonus6()
CASE 9, 10: SpritePut 255 - (B * 16), 275, Bonus7()
CASE 11, 12: SpritePut 255 - (B * 16), 275, Bonus4()
CASE 1: SpritePut 255 - (B * 16), 275, Bonus1()
CASE 2: SpritePut 255 - (B * 16), 275, Bonus2()
CASE ELSE: SpritePut 255 - (B * 16), 275, Bonus1()
END SELECT
NEXT F
FlashOn = True
ScorePrint
FrameDisp
FlashCounter = 0
NEXT I

FOR Top = 91 TO 0 STEP -1
GetInputs
FrameInit
IF Player(PlayerUp).FirstTime = True THEN
IF PlayerUp = 1 THEN PlayerUp$ = "PLAYER ONE" ELSE PlayerUp$ = "PLAYER TWO"
IF TwoPlayer = True THEN PacCenter 111, PlayerUp$, 11
PacCenter 159, "READY!", 14
END IF
FlashOn = True
ScorePrint
FrameDisp
FlashCounter = 0
NEXT Top

Top = 0: EgaPan Top
IF Player(1).Lives = 0 AND Player(2).Lives = 0 THEN 'EXIT SUB
NoSound = False
EXIT SUB 'IF Player(PlayerUp).Lives = 0 THEN EXIT SUB
END IF

FOR I = 1 TO 2
GetInputs
FrameInit
PacCenter 111, SPACE$(10), 0
DrawGhosts
GhostAnim = 0
DrawPac
ScorePrint
FrameDisp
FlashCounter = 0
NEXT


FOR Top = 0 TO 91
GetInputs
Pac.NewDir = None
FrameInit
GetInputs
FlashOn = True
DrawGhosts
GhostAnim = 0
IF Player(PlayerUp).FirstTime = True THEN PacCenter 159, "READY!", 14
DrawPac
ScorePrint
FrameDisp
FlashCounter = 0
NEXT Top

FOR I = 1 TO 2
GetInputs
FrameInit
PacCenter 159, SPACE$(9), 0
DrawGhosts
GhostAnim = 0
DrawPac
ScorePrint
FrameDisp
FlashCounter = 0
NEXT

Player(PlayerUp).FirstTime = False
NoSound = False
END SUB

SUB LoadIt

SCREEN 0: WIDTH 80: CLS
COLOR 15: PRINT "Loading..."

NumGhosts = 4
Ghost(1).StartX = 155: Ghost(1).Culler = 4
Ghost(1).StartDir = Left: Ghost(1).BoxCount = 0
Ghost(2).StartX = 155: Ghost(2).Culler = 3
Ghost(2).StartDir = Down: Ghost(2).BoxCount = 0
Ghost(3).StartX = 139: Ghost(3).Culler = 11
Ghost(3).StartDir = Up: Ghost(3).BoxCount = 298'300
Ghost(4).StartX = 171: Ghost(4).Culler = 7
Ghost(4).StartDir = Up: Ghost(4).BoxCount = 620'444

FOR Mask = 0 TO 7
BitMask(Mask) = 2 ^ (7 - Mask)
NEXT Mask

FOR X = 0 TO 319
XMask(X) = BitMask(X AND 7)
NEXT X
ERASE BitMask

FOR Y = 0 TO 288
YOffset(Y) = Y * 40&
NEXT Y

FOR Pan = 0 TO 1139
PanMask(Pan).Pan1 = (40& * Pan) MOD 256
PanMask(Pan).Pan2 = (40& * Pan) \ 256
NEXT Pan

RESTORE BlinkyPattern
FOR I = 1 TO 3
FOR J = 1 TO 9
FOR K = 1 TO 3
READ GhostPats(I, J, K)
NEXT K, J, I

FOR I = 0 TO 3
OPEN "PACLASSC" + ".GR" + CHR$(49 + I) FOR INPUT AS #1
CLOSE
NEXT I

OPEN "PACLASSC.SFX" FOR INPUT AS #1
CLOSE

OPEN "PACLASSC.SFX" FOR BINARY AS #1
FOR Times = 0 TO 5
GET #1, , EatSound1(Times)
NEXT
FOR Times = 0 TO 5
GET #1, , EatSound2(Times)
NEXT
FOR Times = 0 TO 22
GET #1, , BonusSound(Times)
NEXT
FOR Times = 0 TO 48
GET #1, , GhostSound(Times)
NEXT
FOR Times = 0 TO 23
GET #1, , BackSound1(Times)
NEXT
FOR Times = 0 TO 22
GET #1, , BackSound2(Times)
NEXT
FOR Times = 0 TO 19
GET #1, , BackSound3(Times)
NEXT
FOR Times = 0 TO 17
GET #1, , BackSound4(Times)
NEXT
FOR Times = 0 TO 16
GET #1, , BackSound5(Times)
NEXT
FOR Times = 0 TO 90
GET #1, , DeathSound(Times)
NEXT
FOR Times = 0 TO 16
GET #1, , EnerSound(Times)
NEXT
FOR Times = 0 TO 15
GET #1, , EyesSound(Times)
NEXT
CLOSE
SoundVars(0).Effect = 0
SoundVars(0).LastEffect = 2
SoundInit

OPEN "PACLASSC.SCR" FOR BINARY AS #1
GET #1, 1, HighScore&
CLOSE

SCREEN 13
FOR I = 0 TO 25: Pal I, 0, 0, 0: NEXT I
P$ = SPACE$(16000)
OPEN "PACLASSC.GR5" FOR BINARY AS #1
DEF SEG = &HA000
GET #1, 8, P$
FOR P = 0 TO 15999
POKE P, ASC(MID$(P$, P + 1, 1))
NEXT P
FOR I = 1 TO 3
GET #1, , P$
FOR P = 0 TO 15999
POKE P + (I * 16000&), ASC(MID$(P$, P + 1, 1))
NEXT P
NEXT I
DEF SEG
CLOSE
P$ = ""


Count = 0
FOR V = 0 TO 7
FOR H = 0 TO 319
Font(Count) = POINT(H, V)
Count = Count + 1
NEXT H
NEXT V
FOR I = 0 TO 13
FOR V = 0 TO 15
FOR H = 0 TO 15
P = POINT(I * 16 + H, V + 8)
SELECT CASE I
CASE 0: PacSprite1(H, V) = P
CASE 1: PacSprite2(H, V) = P
CASE 2: PacSprite3(H, V) = P
CASE 3: Deathsprite1(H, V) = P
CASE 4: Deathsprite2(H, V) = P
CASE 5: Deathsprite3(H, V) = P
CASE 6: Deathsprite4(H, V) = P
CASE 7: Deathsprite5(H, V) = P
CASE 8: Deathsprite6(H, V) = P
CASE 9: Deathsprite7(H, V) = P
CASE 10: Deathsprite8(H, V) = P
CASE 11: Deathsprite9(H, V) = P
CASE 12: Deathsprite10(H, V) = P
CASE 13: Deathsprite11(H, V) = P
END SELECT
NEXT H
NEXT V
NEXT I
FOR I = 0 TO 9
FOR V = 0 TO 15
FOR H = 0 TO 15
P = POINT(I * 16 + H, V + 24)
SELECT CASE I
CASE 0: Ghost4Right(H, V) = P
CASE 1: Ghost3Right(H, V) = P
CASE 2: Ghost4Down(H, V) = P
CASE 3: Ghost3Down(H, V) = P
CASE 4: Ghost4Left(H, V) = P
CASE 5: Ghost3Left(H, V) = P
CASE 6: Ghost4Up(H, V) = P
CASE 7: Ghost3Up(H, V) = P
CASE 8: Ghost4Scared(H, V) = P
CASE 9: Ghost3Scared(H, V) = P
END SELECT
NEXT H
NEXT V
NEXT I
FOR I = 0 TO 7
FOR V = 0 TO 15
FOR H = 0 TO 15
P = POINT(I * 16 + H, V + 40)
SELECT CASE I
CASE 0: Bonus1(H, V) = P
CASE 1: Bonus2(H, V) = P
CASE 2: Bonus3(H, V) = P
CASE 3: Bonus4(H, V) = P
CASE 4: Bonus5(H, V) = P
CASE 5: Bonus6(H, V) = P
CASE 6: Bonus7(H, V) = P
CASE 7: Bonus8(H, V) = P
END SELECT
NEXT H
NEXT V
NEXT I
FOR I = 0 TO 2
FOR V = 0 TO 15
FOR H = 0 TO 15
P = POINT(I * 16 + H + 191, V + 24)
SELECT CASE I
CASE 0: GhostScore1(H, V) = P
CASE 1: GhostScore2(H, V) = P
CASE 2: GhostScore3(H, V) = P
END SELECT
NEXT H
NEXT V
NEXT I
FOR V = 0 TO 15
FOR H = 0 TO 15
GhostScore4(H, V) = POINT(H + 240, V + 24)
NEXT H
NEXT V
FOR V = 0 TO 15
FOR H = 0 TO 15
LivesSprite(H, V) = POINT(H + 192, V + 40)
NEXT H
NEXT V
LINE (0, 0)-(319, 60), 0, BF
PacPal
Pal 0, 17, 0, 17
SLEEP 2
Kbd$ = INKEY$: IF Kbd$ = CHR$(27) THEN FinishIt
END SUB

SUB MainLoop

DO
NoSound = False

OldLives = Player(PlayerUp).Lives
IF Player(1).Lives = 0 AND Player(2).Lives = 0 THEN
FOR I = 0 TO 15
PALETTE I, 0
NEXT I
DEF SEG = &HA000
FOR I = 1 TO 2
FOR H = 46 TO 272
EgaLine H, 0, H, 287, 0
NEXT H
DEF SEG = &HAA00
NEXT I
SELECT CASE Apage
 CASE 0: DEF SEG = &HA000
 CASE -1: DEF SEG = &HAA00    '(512 per page
END SELECT
EXIT DO
END IF
MovePac
MoveGhosts
IF PacDead = True THEN
DEF SEG = &HA000: SpriteErase 155, 159
DEF SEG = &HAA00: SpriteErase 155, 159
SELECT CASE Apage
 CASE 0: DEF SEG = &HA000
 CASE -1: DEF SEG = &HAA00    '(512 per page
END SELECT
BonusCount = 0
'IF SoundWanted THEN
'DO UNTIL SoundDone%: LOOP
'END IF
FOR F = 1 TO 64
SoundVars(0).Effect = Silent
SoundVars(1).Effect = Silent
'GetInputs
FrameInit
DrawPac
DrawGhosts
ScorePrint
IF SoundWanted THEN SoundPlay
FrameDisp
IF SoundWanted THEN
DO UNTIL SoundDone%: LOOP
END IF
NEXT F
SoundVars(0).Counter = 0: SoundVars(0).Effect = PacDying
SoundVars(1).Counter = 0: SoundVars(1).Effect = Silent
FOR D = 1 TO 89
'SoundVars(0).Effect = PacDying
GetInputs
'IF SoundWanted THEN SoundPlay
FrameInit
F = (D \ 6) + 1
SELECT CASE F
CASE 11 TO 16: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite11()
CASE 1: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite1()
CASE 2: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite2()
CASE 3: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite3()
CASE 4: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite4()
CASE 5: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite5()
CASE 6: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite6()
CASE 7: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite7()
CASE 8: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite8()
CASE 9: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite9()
CASE 10: SpritePut Pac.X + 1, Pac.Y - 2, Deathsprite10()
END SELECT
ScorePrint
IF SoundWanted THEN SoundPlay
FrameDisp
IF SoundWanted THEN
DO UNTIL SoundDone%: LOOP
END IF

NEXT D
FrameDisp
Player(PlayerUp).Lives = Player(PlayerUp).Lives - 1
IF Player(PlayerUp).Lives = 0 THEN
NoSound = True
FOR F = 1 TO 64
FrameInit
PacCenter 159, "GAME OVER", 4 'new
ScorePrint
IF SoundWanted THEN SoundPlay
FrameDisp
IF SoundWanted THEN
DO UNTIL SoundDone%: LOOP
END IF
NEXT
NoSound = False
END IF

IF TwoPlayer = True THEN
IF PlayerUp = 1 THEN
IF Player(2).Lives > 0 THEN PlayerUp = 2   'AND Player(2).Lives > 0
ELSEIF PlayerUp = 2 THEN
IF Player(1).Lives > 0 THEN PlayerUp = 1   'AND Player(1).Lives > 0
END IF
END IF

PacDead = False

IF Player(1).Lives > 0 OR Player(2).Lives > 0 THEN LevelInit
'NoSound = True
'LevelInit
'NoSound = False
'END IF

ELSE

IF BonusCount > 0 THEN
SELECT CASE Player(PlayerUp).Level
CASE 3, 4: SpritePut 155, 159, Bonus3(): BonusScore = 500
CASE 5, 6: SpritePut 155, 159, Bonus5(): BonusScore = 700
CASE 7, 8: SpritePut 155, 159, Bonus6(): BonusScore = 1000
CASE 9, 10: SpritePut 155, 159, Bonus7(): BonusScore = 2000
CASE 11, 12: SpritePut 155, 159, Bonus4(): BonusScore = 3000
CASE 1: SpritePut 155, 159, Bonus1(): BonusScore = 100
CASE 2: SpritePut 155, 159, Bonus2(): BonusScore = 300
CASE ELSE: SpritePut 155, 159, Bonus1(): BonusScore = 5000
END SELECT
IF ABS(155 - Pac.X) < 5 AND ABS(159 - Pac.Y) < 5 THEN
SoundVars(0).Effect = EatBonus
OldScore& = Player(PlayerUp).Score&
Player(PlayerUp).Score& = Player(PlayerUp).Score& + BonusScore
NewScore& = Player(PlayerUp).Score& \ 10000
IF (OldScore& = 0 OR OldScore& = 2 OR OldScore& = 4 OR OldScore& = 7 OR (OldScore& > 8 AND ((OldScore& - 7) MOD 3) = 0)) AND (NewScore& = OldScore& + 1) THEN Player(PlayerUp).Lives = Player(PlayerUp).Lives + 1
PointsCount = 160
BonusCount = 0
END IF
BonusCount = BonusCount - 1
IF BonusCount = 0 THEN
DEF SEG = &HA000: SpriteErase 155, 159
DEF SEG = &HAA00: SpriteErase 155, 159
SELECT CASE Apage
 CASE 0: DEF SEG = &HA000
 CASE -1: DEF SEG = &HAA00    '(512 per page
END SELECT
END IF
END IF
IF PointsCount > 0 THEN
SELECT CASE Player(PlayerUp).Level
CASE 3, 4: DrawMisc 151, 159, "500"
CASE 5, 6: DrawMisc 151, 159, "700"
CASE 7, 8: DrawMisc 148, 159, "1000"
CASE 9, 10: DrawMisc 148, 159, "2000"
CASE 11, 12: DrawMisc 148, 159, "3000"
CASE 1: DrawMisc 151, 159, "100"
CASE 2: DrawMisc 151, 159, "300"
CASE ELSE: DrawMisc 148, 159, "5000"
END SELECT
PointsCount = PointsCount - 1
IF PointsCount = 0 THEN
DEF SEG = &HA000
FOR V = 0 TO 7
EgaLine 148, 159 + V, 168, 159 + V, 0
NEXT
DEF SEG = &HAA00:
FOR V = 0 TO 7
EgaLine 148, 159 + V, 168, 159 + V, 0
NEXT
SELECT CASE Apage
 CASE 0: DEF SEG = &HA000
 CASE -1: DEF SEG = &HAA00    '(512 per page
END SELECT
END IF
END IF
IF Player(PlayerUp).Lives > OldLives THEN
DEF SEG = &HA000
FOR F = 1 TO 2
FOR L = 1 TO Player(PlayerUp).Lives - 1
SpritePut L * 16 + 47, 275, LivesSprite()
NEXT L
DEF SEG = &HAA00
NEXT F
SELECT CASE Apage
 CASE 0: DEF SEG = &HA000
 CASE -1: DEF SEG = &HAA00    '(512 per page
END SELECT

END IF

FrameInit
DrawPac
DrawGhosts
ScorePrint
IF SoundWanted THEN SoundPlay

FrameDisp
'here
'IF SoundWanted THEN
'DO: LOOP UNTIL SoundDone
'END IF

END IF
IF AdvanceLevel = True THEN
'IF SoundWanted THEN
'DO UNTIL SoundDone%: LOOP
'END IF
FOR I = 1 TO 4
FOR F = 0 TO 31
FrameInit
FlashOn = True
ScorePrint
FrameDisp
IF F < 16 THEN Pal 1, 63, 63, 63 ELSE Pal 1, 8, 8, 55
FlashCounter = 0
NEXT F
NEXT I
Player(PlayerUp).Level = Player(PlayerUp).Level + 1
Player(PlayerUp).DotsEaten = 0
Player(PlayerUp).EnersEaten = 0
LevelInit

END IF
IF SoundWanted THEN
DO UNTIL SoundDone%: LOOP
END IF        'new for paclasscj

LOOP
END SUB

SUB MazeBorder
EgaLine 51, 23, 265, 23, 1      'Draw Exterior Border of Maze
EgaLine 49, 24, 50, 24, 1
EgaLine 266, 24, 267, 24, 1
EgaLine 48, 25, 48, 26, 1
EgaLine 268, 25, 268, 26, 1
EgaLine 47, 27, 47, 97, 1
EgaLine 269, 27, 269, 97, 1
EgaLine 48, 98, 48, 99, 1
EgaLine 268, 98, 268, 99, 1
EgaLine 49, 100, 50, 100, 1
EgaLine 266, 100, 267, 100, 1
EgaLine 51, 101, 86, 101, 1
EgaLine 230, 101, 265, 101, 1
EgaLine 87, 102, 87, 126, 1
EgaLine 229, 102, 229, 126, 1
EgaLine 47, 127, 86, 127, 1
EgaLine 230, 127, 270, 127, 1
EgaLine 47, 149, 86, 149, 1
EgaLine 230, 149, 270, 149, 1
EgaLine 87, 150, 87, 174, 1
EgaLine 229, 150, 229, 174, 1
EgaLine 51, 175, 86, 175, 1
EgaLine 230, 175, 265, 175, 1
EgaLine 49, 176, 50, 176, 1
EgaLine 266, 176, 267, 176, 1
EgaLine 48, 177, 48, 178, 1
EgaLine 268, 177, 268, 178, 1
EgaLine 47, 179, 47, 265, 1
EgaLine 269, 179, 269, 265, 1
EgaLine 48, 266, 48, 267, 1
EgaLine 268, 266, 268, 267, 1
EgaLine 49, 268, 50, 268, 1
EgaLine 266, 268, 267, 268, 1
EgaLine 51, 269, 265, 269, 1
END SUB

SUB MazePlot (X, Y)
CurChar = Maze(PlayerUp, X, Y)
StartX = (X * 8) + ScrX
StartY = (Y * 8) + ScrY
SELECT CASE CurChar
  CASE 46
   EgaPixel StartX + 3, StartY + 3, 5
   EgaPixel StartX + 4, StartY + 3, 5
   EgaPixel StartX + 3, StartY + 4, 5
   EgaPixel StartX + 4, StartY + 4, 5
CASE 49
   EgaLine StartX, StartY + 3, StartX + 1, StartY + 3, 1
   EgaLine StartX + 3, StartY + 5, StartX + 3, StartY + 7, 1
   EgaPixel StartX + 2, StartY + 4, 1
CASE 50
   EgaLine StartX + 5, StartY + 3, StartX + 7, StartY + 3, 1
   EgaLine StartX + 3, StartY + 5, StartX + 3, StartY + 7, 1
   EgaPixel StartX + 4, StartY + 4, 1
CASE 51
   EgaLine StartX + 3, StartY, StartX + 3, StartY + 1, 1
   EgaLine StartX + 5, StartY + 3, StartX + 7, StartY + 3, 1
   EgaPixel StartX + 4, StartY + 2, 1
CASE 52
   EgaLine StartX, StartY + 3, StartX + 1, StartY + 3, 1
   EgaLine StartX + 3, StartY, StartX + 3, StartY + 1, 1
   EgaPixel StartX + 2, StartY + 2, 1
CASE 53
   EgaLine StartX, StartY + 3, StartX + 3, StartY + 3, 1
   EgaLine StartX + 3, StartY + 3, StartX + 3, StartY + 7, 1
CASE 54
   EgaLine StartX + 3, StartY + 3, StartX + 7, StartY + 3, 1
   EgaLine StartX + 3, StartY + 3, StartX + 3, StartY + 7, 1
CASE 55
   EgaLine StartX + 3, StartY + 3, StartX + 7, StartY + 3, 1
   EgaLine StartX + 3, StartY, StartX + 3, StartY + 3, 1
CASE 56
   EgaLine StartX, StartY + 3, StartX + 3, StartY + 3, 1
   EgaLine StartX + 3, StartY, StartX + 3, StartY + 3, 1
CASE 45
   EgaLine StartX, StartY + 3, StartX + 7, StartY + 3, 1
CASE 124
   EgaLine StartX + 3, StartY, StartX + 3, StartY + 7, 1
CASE 76
   EgaLine StartX, StartY + 3, StartX + 4, StartY + 3, 1
   EgaLine StartX + 4, StartY + 3, StartX + 4, StartY + 6, 1
   EgaLine StartX + 5, StartY + 4, StartX + 7, StartY + 4, 3
   EgaLine StartX + 5, StartY + 5, StartX + 7, StartY + 5, 3
CASE 82
   EgaLine StartX + 4, StartY + 3, StartX + 7, StartY + 3, 1
   EgaLine StartX + 3, StartY + 3, StartX + 3, StartY + 6, 1
   EgaLine StartX, StartY + 4, StartX + 2, StartY + 4, 3
   EgaLine StartX, StartY + 5, StartX + 2, StartY + 5, 3
CASE 67
   EgaLine StartX, StartY + 4, StartX + 7, StartY + 4, 3
   EgaLine StartX, StartY + 5, StartX + 7, StartY + 5, 3
CASE 32
   FOR E = 0 TO 7
   EgaLine StartX + E, StartY, StartX + E, StartY + 7, 0
   NEXT
CASE ELSE
END SELECT
END SUB

SUB MenuCredits

FOR I = 0 TO 15
PALETTE I, 0
NEXT
CLS

P$ = SPACE$(8000)
FOR I = 0 TO 3
OUT &H3C4, 2
OUT &H3C5, 2 ^ I
OPEN "PACLASSC" + ".GR" + CHR$(49 + I) FOR BINARY AS #1
GET #1, 8, P$
FOR P = 0 TO 7999
POKE P, ASC(MID$(P$, P + 1, 1))
NEXT P
CLOSE
NEXT I
P$ = ""

EgaScreen
PacPal
OUT &H3C4, 2
OUT &H3C5, 15
EgaScreen
PacPrint 118, 152, "BETA VERSION 0.2", 7
PacPrint 102, 160, "COPYRIGHT 1999 PJC", 7
SLEEP: Kbd$ = INKEY$: IF Kbd$ = CHR$(27) THEN EXIT SUB
LINE (66, 43)-(253, 158), 0, BF
LINE (90, 158)-(253, 171), 0, BF
EgaScreen
PacCenter 54, "CREDITS", 4
PacCenter 70, "SOURCE AND ASSISTANCE", 14
PacCenter 82, "CADWRIGHT  KURT KUZBA", 15
PacCenter 90, "DOUGLAS H LUSHER", 15
PacCenter 98, "JONATHAN LEGER", 15
PacCenter 106, "MIKE HUFF  TOSHI HORIE", 15
PacCenter 114, "JESS A.K.A. MNEKI NEKO", 15
PacCenter 126, "AND ARUNDEL SENIOR", 15
PacCenter 134, "HIGH SCHOOL COMPUTER", 15
PacCenter 142, "TEACHER   MR RIKER", 15
SLEEP: Kbd$ = INKEY$: IF Kbd$ = CHR$(27) THEN EXIT SUB
LINE (66, 43)-(253, 158), 0, BF
LINE (90, 158)-(253, 171), 0, BF
EgaScreen
PacCenter 54, "CREDITS", 4
PacCenter 70, "LOYAL PAC FANS", 14
PacCenter 82, "REVEREND SHOEBOX", 15
PacCenter 90, "TIM A.K.A. MEDRAGON", 15
PacCenter 98, "DUSTIN A.K.A. PACN 99", 15
PacCenter 106, "PAC MANIC", 15
PacCenter 114, "MR. SPARKLE", 15
PacCenter 122, "STOOGE BOY", 15
PacCenter 130, "YAMCHA Q. HIBIKI", 15
PacCenter 138, "PETER A.K.A. PAC FAY", 15
PacCenter 146, "CARY WOODHAM", 15
PacCenter 154, "SCOTT", 15
'PacCenter 98, "MARSHALL STOWE", 15
SLEEP: Kbd$ = INKEY$: IF Kbd$ = CHR$(27) THEN EXIT SUB
LINE (66, 43)-(253, 158), 0, BF
LINE (90, 158)-(253, 171), 0, BF
EgaScreen
PacCenter 54, "CREDITS", 4

PacCenter 70, "FRIENDS OF PJC", 14
PacCenter 82, "DERICK JONES", 15
PacCenter 90, "PAULA WHITE", 15
PacCenter 98, "RICARDO FIGUEROA", 15
PacCenter 106, "FIONA MCCONVILLE", 15
PacCenter 114, "RICHARD CALLAHAN", 15
PacCenter 122, "TOMMY DIFENBAUGH", 15
PacCenter 134, "MORE FRIENDS OF PJC", 14
PacCenter 146, "TANZA COURSEY", 15
PacCenter 154, "AMANDA WILHELM", 15
PacCenter 162, "STEVE CUPIT", 15

SLEEP: Kbd$ = INKEY$: IF Kbd$ = CHR$(27) THEN EXIT SUB
LINE (66, 43)-(253, 158), 0, BF
LINE (90, 158)-(253, 171), 0, BF
EgaScreen
PacCenter 70, "CREDITS", 4
PacCenter 82, "FAMILY OF PJC", 14
PacCenter 94, "STEVE AND DAVRIA COHEN", 15
PacCenter 102, "AMBER COHEN", 15
PacCenter 114, "THE LOVE OF MY LIFE", 14
PacCenter 126, "KATIE MARIE HEBB", 15
PacCenter 138, "AND THANK YOU!", 4
PacCenter 146, "FOR PLAYING PAC CLASSIC", 4
SLEEP: Kbd$ = INKEY$
LINE (66, 43)-(253, 158), 0, BF
LINE (90, 158)-(253, 171), 0, BF
EgaScreen
END SUB

SUB MenuMain
DO
FOR P = 1 TO 2
Player(P).Score& = 0
Player(P).Lives = 3
Player(P).Level = 1
Player(P).DotsEaten = 0
Player(P).EnersEaten = 0
Player(P).FirstTime = True
NEXT
'PointsCount = 0
PlayerUp = 1
SCREEN 7, , 0, 0
FOR I = 0 TO 15
PALETTE I, 0
NEXT I
CLS
EgaPan 0

DEF SEG = &HA000
P$ = SPACE$(8000)
FOR I = 0 TO 3
OUT &H3C4, 2
OUT &H3C5, 2 ^ I
OPEN "PACLASSC" + ".GR" + CHR$(49 + I) FOR BINARY AS #1
GET #1, 8, P$
FOR P = 0 TO 7999
POKE P, ASC(MID$(P$, P + 1, 1))
NEXT P
CLOSE
NEXT I
P$ = ""
PacPal
OUT &H3C4, 2
OUT &H3C5, 15
EgaScreen

LINE (66, 43)-(253, 158), 0, BF
LINE (90, 158)-(253, 171), 0, BF
EgaScreen

PacCenter 54, "MAIN MENU", 4
PacCenter 74, CHR$(34) + "C" + CHR$(34) + " TO VIEW CREDITS", 14
PacCenter 90, CHR$(34) + "S" + CHR$(34) + " FOR SETUP OPTIONS", 14
PacCenter 106, CHR$(34) + "1" + CHR$(34) + " FOR 1 PLAYER GAME", 14
PacCenter 122, CHR$(34) + "2" + CHR$(34) + " FOR 2 PLAYER GAME", 14
PacCenter 138, CHR$(34) + "X" + CHR$(34) + " TO EXIT PROGRAM", 14
Kbd$ = ""
WHILE INSTR(CHR$(1) + "XSC12", Kbd$) < 2
Kbd$ = UCASE$(INKEY$)
WEND

SELECT CASE Kbd$
CASE "X": FinishIt
CASE "S": MenuSetup
CASE "C": MenuCredits
CASE "1", "2"
IF Kbd$ = "2" THEN TwoPlayer = True ELSE TwoPlayer = False
IF TwoPlayer = False THEN Player(2).Lives = 0
LINE (0, 0)-(319, 199), 0, BF
SCREEN 7, , 0, 0
CLS
EgaScreen
PacPal
Apage = 0 ': VPage = 1
Top = 0
LevelInit
MainLoop
END SELECT
LOOP
END SUB

SUB MenuSetup

LINE (66, 43)-(253, 158), 0, BF
LINE (90, 158)-(253, 171), 0, BF
EgaScreen
PacCenter 54, "PAC-CLASSIC SETUP", 4
PacCenter 138, CHR$(34) + "X" + CHR$(34) + " FOR MAIN MENU", 15
PCOPY 0, 3
SCREEN 7, , 2, 2

Apage = 0

DO
PCOPY 3, 0
EgaScreen
IF SoundEnabled = True THEN
PacCenter 68, "SOUNDCARD DETECTED", 15
SoundStatus$ = "SOUND IS "
IF SoundWanted THEN
SoundStatus$ = SoundStatus$ + "ON"
ELSE
SoundStatus$ = SoundStatus$ + "OFF"
END IF
PacCenter 76, SoundStatus$, 14
PacCenter 84, CHR$(34) + "S" + CHR$(34) + "TO CHANGE", 14
ELSE
PacCenter 68, "NO SOUNDCARD DETECTED", 15
PacCenter 76, "SOUND IS OFF", 14
END IF
PacCenter 100, "INPUT METHOD", 15
IF JoyEnabled THEN
PacCenter 108, "USING JOYSTICK", 14
PacCenter 116, CHR$(34) + "K" + CHR$(34) + " FOR KEYBOARD", 14
ELSE
PacCenter 108, "USING KEYBOARD", 14
  JoyX = STICK(0)
  IF JoyX > 1 THEN
    PacCenter 116, CHR$(34) + "J" + CHR$(34) + " FOR JOYSTICK", 14
  ELSE
    PacCenter 116, "NO JOYSTICK FOUND", 14
  END IF
END IF
Kbd$ = UCASE$(INKEY$)
SELECT CASE Kbd$
CASE "X": EXIT DO
CASE "S"
IF SoundEnabled THEN
SoundWanted = NOT SoundWanted
END IF
CASE "K"
IF JoyEnabled = True THEN JoyEnabled = False
CASE "J"
IF JoyEnabled = False AND JoyX > 1 AND JoyY > 1 THEN
PacCenter 132, "MOVE JOYSTICK TO", 8
PacCenter 140, "UPPER LEFT CORNER", 8
PacCenter 148, "AND PRESS BUTTON", 8
PCOPY 0, 2
EgaScreen
DO
FastJoy JoyXMin, JoyYMin, 1
LOOP UNTIL STRIG(1) OR STRIG(6)
DO: LOOP UNTIL NOT STRIG(1) AND NOT STRIG(6)
PacCenter 140, "UPPER LEFT CORNER", 0
PacCenter 140, "LOWER RIGHT CORNER", 8
PCOPY 0, 2
EgaScreen
DO
FastJoy JoyXMax, JoyYMax, 1
LOOP UNTIL STRIG(1) OR STRIG(6)
DO: LOOP UNTIL NOT STRIG(1) AND NOT STRIG(6)
JoySensX = (JoyXMax - JoyXMin) \ 10
JoySensY = (JoyYMax - JoyYMin) \ 10
PacCenter 132, "MOVE JOYSTICK TO", 0
PacCenter 140, "LOWER RIGHT CORNER", 0
PacCenter 148, "AND PRESS BUTTON", 0
PacCenter 132, "CENTER JOYSTICK", 8
PacCenter 140, "AND PRESS BUTTON", 8
PCOPY 0, 2
EgaScreen
DO
FastJoy JoyXMid, JoyYMid, 1
LOOP UNTIL STRIG(1) OR STRIG(6)
JoyEnabled = True
END IF
END SELECT
PCOPY 0, 2
EgaScreen
LOOP

END SUB

SUB MoveGhost (I)
IF Ghost(I).State = Wander THEN
'IF I = 4 THEN
'Ghost(I).State = Normal
'Ghost(I).Wandered = True
'Ghost(I).Counter = 0
'ELSE

IF Ghost(I).Counter = 0 THEN Ghost(I).Counter = 1
X = GhostPats(I, Ghost(I).Counter, 2) * 8 + ScrX
Y = GhostPats(I, Ghost(I).Counter, 3) * 8 + ScrY
IF Ghost(I).X = X AND Ghost(I).Y = Y THEN Ghost(I).Counter = Ghost(I).Counter + 1
IF Ghost(1).Counter = 10 THEN
FOR J = 1 TO NumGhosts
Ghost(J).Wandered = True
IF Ghost(I).State = Wander THEN
Ghost(J).State = Normal
Ghost(J).Wandered = True
SELECT CASE Ghost(J).Dir
CASE Up: Ghost(J).Dir = Down
CASE Right: Ghost(J).Dir = Left
CASE Down: Ghost(J).Dir = Up
CASE Left: Ghost(J).Dir = Right
CASE ELSE
END SELECT
END IF
NEXT
END IF
END IF

IF Ghost(I).State = Scared THEN
Ghost(I).Speed = Ghost(I).Speed + 1
IF Ghost(I).Speed = 2 THEN Ghost(I).Speed = 0
END IF

IF Ghost(I).State <> Eyes AND Ghost(I).State <> Scared AND (Ghost(I).X < 47 OR Ghost(I).X > 255) THEN
Ghost(I).Speed = Ghost(I).Speed + 1
IF Ghost(I).Speed = 2 THEN Ghost(I).Speed = 0
END IF

IF Ghost(I).State = Eyes THEN Ghost(I).Speed = 2

SELECT CASE Ghost(I).State
CASE Normal, Scared, Eyes, Wander
  IF Ghost(I).State = Eyes THEN
    X = Ghost(I).X - 155
    Y = Ghost(I).Y - 111'135
  ELSEIF Ghost(I).State = Normal THEN
    X = Ghost(I).X - Pac.X
    Y = Ghost(I).Y - Pac.Y
  ELSE
     IF Pac.X > 155 THEN X = (Ghost(I).X - ScrX) ELSE X = (Ghost(I).X - (224 + ScrX))
     IF Pac.Y > 135 THEN Y = (Ghost(I).Y - ScrY) ELSE Y = (Ghost(I).Y - (288 + ScrY))
  END IF
 
  IF Ghost(I).State = Eyes AND X = 0 AND Ghost(I).Y > 110 AND Ghost(I).Y < 136 THEN
    Ghost(I).Dir = Down
    IF Ghost(I).Y = 135 THEN
      Ghost(I).State = Eyes2
      Ghost(I).Speed = 1
    END IF
  ELSE
  SELECT CASE Ghost(I).Dir
    CASE Left, Right
      Ghost(I).NewDir1 = Up
      Ghost(I).NewDir2 = Down
      IF Y < 0 THEN SWAP Ghost(I).NewDir1, Ghost(I).NewDir2
    CASE Up, Down
      Ghost(I).NewDir1 = Left
      Ghost(I).NewDir2 = Right
      IF X < 0 THEN SWAP Ghost(I).NewDir1, Ghost(I).NewDir2
  END SELECT
   
    IF Ghost(I).State <> Eyes THEN
    SELECT CASE I
    CASE 3
    IF ((Ghost(I).X - ScrX) MOD 8) = 0 AND ((Ghost(I).Y - ScrY) MOD 8) = 0 AND RND > .6 THEN SWAP Ghost(I).NewDir1, Ghost(I).NewDir2
    CASE 4
    IF (X = 0 OR Y = 0) AND RND > .5 THEN SWAP Ghost(I).NewDir1, Ghost(I).NewDir2
    CASE ELSE
    END SELECT
    END IF

    Move1 = False
    SELECT CASE Ghost(I).NewDir1
      CASE Left
	IF ((Ghost(I).Y - ScrY) MOD 8) = 0 THEN
	  Move1 = NOT TestWall(Ghost(I).X - 8, Ghost(I).Y)
	END IF
      CASE Right
	IF ((Ghost(I).Y - ScrY) MOD 8) = 0 THEN
	  Move1 = NOT TestWall(Ghost(I).X + 8, Ghost(I).Y)
	END IF
      CASE Up
	IF ((Ghost(I).X - ScrX) MOD 8) = 0 THEN
	   Move1 = NOT TestWall2(Ghost(I).X, Ghost(I).Y - 8)
	END IF
      CASE Down
	IF ((Ghost(I).X - ScrX) MOD 8) = 0 THEN
	  IF NOT TestWall(Ghost(I).X, Ghost(I).Y + 8) THEN Move1 = True
	END IF
    END SELECT
  END IF
 
  IF Move1 = True THEN ' OR Ghost(I).State = Eyes THEN
  SELECT CASE Ghost(I).NewDir1
  CASE Left, Right
  IF Y = 0 OR I = 2 THEN Ghost(I).Dir = Ghost(I).NewDir1
  CASE Up, Down
  IF X = 0 OR I = 2 THEN Ghost(I).Dir = Ghost(I).NewDir1
  END SELECT
  END IF
  'END IF
 
  IF Move1 = True AND Ghost(I).State = Eyes THEN Ghost(I).Dir = Ghost(I).NewDir1

  SELECT CASE Ghost(I).Dir
   CASE Left: Move2 = NOT TestWall(Ghost(I).X - 1, Ghost(I).Y)
   CASE Right: Move2 = NOT TestWall(Ghost(I).X + 8, Ghost(I).Y)
   CASE Up: Move2 = NOT TestWall2(Ghost(I).X, Ghost(I).Y - 1)
   CASE Down: Move2 = NOT TestWall(Ghost(I).X, Ghost(I).Y + 8)
  END SELECT

  IF Move2 = False THEN
  IF Move1 = True THEN
  Ghost(I).Dir = Ghost(I).NewDir1
  ELSE
  Ghost(I).Dir = Ghost(I).NewDir2
  END IF
  END IF


IF Ghost(I).State = Wander THEN Ghost(I).Dir = GhostPats(I, Ghost(I).Counter, 1)
IF Ghost(I).State = Scared THEN Ghost(I).Counter = Ghost(I).Counter - 1
IF Ghost(I).State = Scared AND Ghost(I).Counter = 0 THEN
Ghost(I).State = Normal
Ghost(I).Speed = 1
END IF
CASE InBox
Ghost(I).Speed = Ghost(I).Speed + 1
IF Ghost(I).Speed > 1 THEN Ghost(I).Speed = 0

IF Ghost(I).Counter <= Ghost(I).BoxCount THEN
  IF Ghost(I).Y = 129 OR Ghost(I).Y = 141 THEN
    IF Ghost(I).Speed = 0 THEN Ghost(I).Speed = 1
    SELECT CASE Ghost(I).Dir
      CASE Up: Ghost(I).Dir = Down
      CASE Down: Ghost(I).Dir = Up
    END SELECT
  END IF
  Ghost(I).Counter = Ghost(I).Counter + 1
ELSE
  X = Ghost(I).X - 155
  SELECT CASE X
    CASE 0
      Ghost(I).Dir = Up
      IF Ghost(I).Y = 112 THEN
      IF Ghost(I).Wandered = False THEN
      Ghost(I).State = Wander
      Ghost(I).Wandered = True
      ELSE
      Ghost(I).State = Normal'Wander
      END IF
      Ghost(I).Counter = 0
      'END IF
      Ghost(I).Speed = 1
      X = Ghost(I).X - Pac.X
      Y = Ghost(I).Y - Pac.Y
      END IF
    CASE IS < 0: Ghost(I).Dir = Right
    CASE IS > 0: Ghost(I).Dir = Left
  END SELECT
END IF
  CASE Eyes2
  X = Ghost(I).X - Ghost(I).StartX
  SELECT CASE X
    CASE 0
      Ghost(I).State = InBox
      Ghost(I).Counter = 0
      Ghost(I).Dir = Ghost(I).StartDir
      IF I = 1 THEN Ghost(I).Dir = Up
    CASE IS > 0: Ghost(I).Dir = Left
    CASE IS < 0: Ghost(I).Dir = Right
  END SELECT
END SELECT
SELECT CASE Ghost(I).Dir
  CASE Left: Ghost(I).X = Ghost(I).X - Ghost(I).Speed
  CASE Right: Ghost(I).X = Ghost(I).X + Ghost(I).Speed
  CASE Up: Ghost(I).Y = Ghost(I).Y - Ghost(I).Speed
  CASE Down: Ghost(I).Y = Ghost(I).Y + Ghost(I).Speed
END SELECT
IF (ABS(Pac.X - Ghost(I).X) < 5) AND (ABS(Pac.Y - Ghost(I).Y) < 5) THEN
IF Ghost(I).State = Normal OR Ghost(I).State = Wander THEN PacDead = True
IF Ghost(I).State = Scared THEN
  GhostsEaten = GhostsEaten + 1
  OldScore& = Player(PlayerUp).Score& \ 10000
  Player(PlayerUp).Score& = Player(PlayerUp).Score& + ((2 ^ GhostsEaten) * 100)
  NewScore& = Player(PlayerUp).Score& \ 10000
  IF (OldScore& = 0 OR OldScore& = 2 OR OldScore& = 4 OR OldScore& = 7 OR (OldScore& > 8 AND ((OldScore& - 7) MOD 3) = 0)) AND (NewScore& = OldScore& + 1) THEN Player(PlayerUp).Lives = Player(PlayerUp).Lives + 1
  SoundVars(0).Effect = EatGhost: SoundVars(0).Counter = 0
  IF SoundWanted THEN
   DO UNTIL SoundDone%: LOOP
  END IF
  SpriteErase Ghost(I).X, Ghost(I).Y
  Ghost(I).Speed = 0 ' here
  IF Ghost(I).X MOD 2 = 0 THEN Ghost(I).X = Ghost(I).X - 1
  IF Ghost(I).Y MOD 2 = 0 THEN Ghost(I).Y = Ghost(I).Y - 1
  FOR F = 1 TO 47
  GetInputs
  'IF SoundWanted THEN SoundPlay
  FrameInit
  FOR E = 1 TO NumGhosts
  IF Ghost(E).State = Eyes OR Ghost(E).State = Eyes2 THEN MoveGhost E
  NEXT E
  DrawGhosts
  SpriteErase Ghost(I).X, Ghost(I).Y
  SELECT CASE GhostsEaten
    CASE 1: SpritePut Pac.X, Pac.Y, GhostScore1()
    CASE 2: SpritePut Pac.X, Pac.Y, GhostScore2()
    CASE 3: SpritePut Pac.X, Pac.Y, GhostScore3()
    CASE 4: SpritePut Pac.X, Pac.Y, GhostScore4()
  END SELECT
  ScorePrint
  IF SoundWanted THEN SoundPlay
  FrameDisp
  IF SoundWanted THEN
   DO UNTIL SoundDone%: LOOP
  END IF
  NEXT F
  IF GhostEaten = NumGhosts THEN GhostsEaten = 0
  Ghost(I).State = Eyes
  Ghost(I).Counter = 64 * (I - 1)
  SoundVars(1).Effect = 0
  SoundVars(0).Effect = Silent
  SoundVars(0).Counter = 0
END IF
END IF
END SUB

SUB MoveGhosts
FOR I = 1 TO NumGhosts
MoveGhost I
NEXT I
IF Ghost(1).Wandered = True THEN GhostTimer = GhostTimer + 1
IF GhostTimer = 432 THEN '582 '388
FOR I = 1 TO NumGhosts
 IF Ghost(I).State = Normal THEN
  SELECT CASE Ghost(I).Dir
    CASE Up: Ghost(I).Dir = Down
    CASE Down: Ghost(I).Dir = Up
    CASE Right: Ghost(I).Dir = Left
    CASE Left: Ghost(I).Dir = Right
  END SELECT
 END IF
NEXT
GhostTimer = 0
END IF
END SUB

SUB MovePac

Top = Pac.Y - 91
IF Top < 0 THEN Top = 0
IF Top > 91 THEN Top = 91

IF Pac.Dir > 0 THEN
CurDir = Pac.Dir
PacAnim = PacAnim + 1
IF PacAnim = 9 THEN PacAnim = 1
END IF

SELECT CASE Pac.Dir
CASE Left
  Move = NOT TestWall(Pac.X - 1, Pac.Y)
  IF Move THEN Pac.X = Pac.X - 1 ELSE Pac.Dir = None
CASE Right
  Move = NOT TestWall(Pac.X + 8, Pac.Y)
  IF Move THEN Pac.X = Pac.X + 1 ELSE Pac.Dir = None
CASE Up
  Move = NOT TestWall(Pac.X, Pac.Y - 1)
  IF Move THEN Pac.Y = Pac.Y - 1 ELSE Pac.Dir = None
CASE Down
  Move = NOT TestWall(Pac.X, Pac.Y + 8)
  IF Move THEN Pac.Y = Pac.Y + 1 ELSE Pac.Dir = None
END SELECT

GetInputs

Move = False
SELECT CASE Pac.NewDir
CASE Left
  IF ((Pac.Y - ScrY) MOD 8) = 0 THEN
     Move = NOT TestWall(Pac.X - 8, Pac.Y)
  END IF
  IF Move THEN
   Pac.Dir = Pac.NewDir
   Pac.NewDir = None
  END IF
CASE Right
  IF ((Pac.Y - ScrY) MOD 8) = 0 THEN
     Move = NOT TestWall(Pac.X + 8, Pac.Y)
  END IF
  IF Move THEN
   Pac.Dir = Pac.NewDir
   Pac.NewDir = None
  END IF
CASE Up
  IF ((Pac.X - ScrX) MOD 8) = 0 THEN
     Move = NOT TestWall(Pac.X, Pac.Y - 8)
  END IF
  IF Move THEN
   Pac.Dir = Pac.NewDir
   Pac.NewDir = None
  END IF
CASE Down
  IF ((Pac.X - ScrX) MOD 8) = 0 THEN
     IF NOT TestWall(Pac.X, Pac.Y + 8) THEN Move = True
  END IF
  IF Move THEN
   Pac.Dir = Pac.NewDir
   Pac.NewDir = None
  END IF
END SELECT

AteDot = TestDot(Pac.X + 4, Pac.Y + 4)
IF AteDot THEN
IF SoundVars(0).LastEffect = 1 THEN
SoundVars(0).Effect = 2
SoundVars(0).LastEffect = 2
ELSE
SoundVars(0).Effect = 1
SoundVars(0).LastEffect = 1
END IF
SoundVars(0).Counter = 0
IF (DotsEaten MOD 48) = 0 AND DotsEaten <> 0 THEN SoundVars(1).Counter = 0

  Maze(PlayerUp, (Pac.X - 43) \ 8, (Pac.Y - 19) \ 8) = 32
  SELECT CASE Pac.Dir
   CASE Left: Pac.X = Pac.X + 1
   CASE Right: Pac.X = Pac.X - 1
   CASE Up: Pac.Y = Pac.Y + 1
   CASE Down: Pac.Y = Pac.Y - 1
  END SELECT
OldScore& = Player(PlayerUp).Score& \ 10000
Player(PlayerUp).Score& = Player(PlayerUp).Score& + 10
NewScore& = Player(PlayerUp).Score& \ 10000
IF (OldScore& = 0 OR OldScore& = 2 OR OldScore& = 4 OR OldScore& = 7 OR (OldScore& > 8 AND ((OldScore& - 7) MOD 3) = 0)) AND (NewScore& = OldScore& + 1) THEN Player(PlayerUp).Lives = Player(PlayerUp).Lives + 1
Player(PlayerUp).DotsEaten = Player(PlayerUp).DotsEaten + 1
IF Player(PlayerUp).DotsEaten = 80 OR Player(PlayerUp).DotsEaten = 160 THEN BonusCount = 582 '336
END IF

AteEnergizer = TestEner(Pac.X + 4, Pac.Y + 4)
IF AteEnergizer THEN
Maze(PlayerUp, (Pac.X - 43) \ 8, (Pac.Y - 19) \ 8) = 32
OldScore& = Player(PlayerUp).Score& \ 10000
Player(PlayerUp).Score& = Player(PlayerUp).Score& + 50
NewScore& = Player(PlayerUp).Score& \ 10000
IF (OldScore& = 0 OR OldScore& = 2 OR OldScore& = 4 OR OldScore& = 7 OR (OldScore& > 8 AND ((OldScore& - 7) MOD 3) = 0)) AND (NewScore& = OldScore& + 1) THEN Player(PlayerUp).Lives = Player(PlayerUp).Lives + 1
Player(PlayerUp).EnersEaten = Player(PlayerUp).EnersEaten + 1
GhostsEaten = 0
FOR I = 1 TO NumGhosts
Ghost(I).Wandered = True
IF Ghost(I).State = Normal OR Ghost(I).State = Scared OR Ghost(I).State = Wander THEN
  Ghost(I).State = Scared
  Ghost(I).Counter = 512 - (Player(PlayerUp).Level * 24)
  IF Level > 21 THEN
  Ghost(I).Counter = 0
  Ghost(I).State = Normal
  ELSE
  SELECT CASE Ghost(I).Dir
    CASE Up: Ghost(I).Dir = Down
    CASE Down: Ghost(I).Dir = Up
    CASE Right: Ghost(I).Dir = Left
    CASE Left: Ghost(I).Dir = Right
  END SELECT
  END IF
END IF
IF SoundVars(1).Effect <> BackEner AND SoundVars(1).Effect <> BackEyes THEN SoundVars(1).Counter = 0
NEXT I
END IF

IF Player(PlayerUp).DotsEaten + Player(PlayerUp).EnersEaten = 244 THEN AdvanceLevel = True
END SUB

SUB PacCenter (Y, Text$, Culler)
PacPrint 160 - (4 * LEN(Text$)), Y, Text$, Culler
END SUB

SUB PacPal
OUT &H3C4, 2
OUT &H3C5, 15
PALETTE
Pal 1, 8, 8, 55
Pal 2, 16, 45, 55
Pal 3, 63, 45, 63
Pal 4, 63, 0, 0
Pal 5, 63, 45, 40
Pal 6, 55, 37, 16
Pal 7, 63, 45, 16
END SUB

SUB PacPrint (X, Y, Text$, Culler)
FOR T = 1 TO LEN(Text$)
Asky = ASC(MID$(Text$, T, 1))
SELECT CASE Asky
CASE 48 TO 57
Start = (Asky - 47) * 8: C = Culler
CASE 65 TO 90
Start = (Asky - 54) * 8: C = Culler
CASE 33
Start = 296: C = Culler
CASE 46
Start = 304: C = Culler
CASE 34
Start = 312: C = Culler '304
CASE ELSE
Start = 0: C = 0
END SELECT
FOR P = Start TO Start + 7
H = (T - 1) * 8 + X + P - Start
 Mask = XMask(H)
 OUT &H3CE, 8: OUT &H3CF, Mask
FOR V = 0 TO 7
IF Font(V * 320 + P) OR Asky = 32 THEN
 Offset = YOffset(V + Y) + (H \ 8)
 Byte = PEEK(Offset)
 POKE Offset, C
END IF
NEXT V
NEXT P
NEXT T
END SUB

SUB Pal (Clr, Red, Grn, Blu)
OUT &H3C8, Clr
OUT &H3C9, Red
OUT &H3C9, Grn
OUT &H3C9, Blu
END SUB

SUB PutGhost (I)
FOR H = 0 TO 15
 Mask = XMask(H + Ghost(I).X - 5)
 OUT &H3CE, 8: OUT &H3CF, Mask
FOR V = 0 TO 15
IF Ghost(I).State = Scared THEN
  IF GhostAnim < 5 THEN P = Ghost4Scared(H, V) ELSE P = Ghost3Scared(H, V)
ELSE
SELECT CASE Ghost(I).Dir
CASE Left: IF GhostAnim < 5 THEN P = Ghost4Left(H, V) ELSE P = Ghost3Left(H, V)
CASE Right: IF GhostAnim < 5 THEN P = Ghost4Right(H, V) ELSE P = Ghost3Right(H, V)
CASE Up: IF GhostAnim < 5 THEN P = Ghost4Up(H, V) ELSE P = Ghost3Up(H, V)
CASE Down: IF GhostAnim < 5 THEN P = Ghost4Down(H, V) ELSE P = Ghost3Down(H, V)
END SELECT
END IF
Pixl = 0
SELECT CASE P
CASE 2
IF (Ghost(I).State = Eyes) OR (Ghost(I).State = Eyes2) THEN Pixl = 0 ELSE Pixl = Ghost(I).Culler
CASE 1
Pixl = 1
IF Ghost(I).State = Scared AND Ghost(I).Counter < 128 AND FlashOn THEN Pixl = 15
CASE 5
Pixl = 5
IF Ghost(I).State = Scared AND Ghost(I).Counter < 128 AND FlashOn THEN Pixl = 4
CASE ELSE: Pixl = P
END SELECT
IF Pixl THEN
 Offset = YOffset(Ghost(I).Y + V - 5) + ((Ghost(I).X + H - 5) \ 8)
 Byte = PEEK(Offset)
 POKE Offset, Pixl
END IF
NEXT V
NEXT H
END SUB

REM $STATIC
SUB ScorePrint
IF Player(PlayerUp).Score& > HighScore& THEN HighScore& = Player(PlayerUp).Score&
IF HighScore& = 0 THEN HighScore$ = "00" ELSE HighScore$ = STR$(HighScore&)
IF Player(1).Score& = 0 THEN OneUpScore$ = "00" ELSE OneUpScore$ = STR$(Player(1).Score&)
IF Player(2).Score& = 0 THEN TwoUpScore$ = "00" ELSE TwoUpScore$ = STR$(Player(2).Score&)
OneUpPrint = 15: TwoUpPrint = 15
IF NOT (FlashOn) THEN
IF PlayerUp = 1 THEN OneUpPrint = 0 ELSE TwoUpPrint = 0
END IF
PacCenter 8, HighScore$, 15
PacPrint 64, 0, "1UP", OneUpPrint
PacPrint 215, 0, "2UP", TwoUpPrint
PacPrint 88 - 8 * (LEN(OneUpScore$)), 8, OneUpScore$, 15
PacPrint 239 - 8 * (LEN(TwoUpScore$)), 8, TwoUpScore$, 15
END SUB

REM $DYNAMIC
SUB SoundBLASTER
' This subroutine parses the BLASTER environment string
' and returns the sound card settings
' implicitly using COMMON variables Baseport%, DMA%, DMA16%

Blaster$ = ENVIRON$("BLASTER")
IF LEN(Blaster$) > 0 THEN
	FOR index% = 1 TO LEN(Blaster$)
		SELECT CASE MID$(UCASE$(Blaster$), index%, 1)
		  CASE "A"
			Baseport% = VAL("&H" + MID$(Blaster$, index% + 1, 3))
		  CASE "I"
			IRQ% = VAL(MID$(Blaster$, index% + 1, 1))
		  CASE "D"
			DMA% = VAL(MID$(Blaster$, index% + 1, 1))
		END SELECT
	NEXT
END IF
END SUB

SUB SoundDMA
' Transfers and plays the contents of the buffer.
'Length% = SoundLength
page% = 0
Addr& = VARSEG(Sounds(ForeGround)) * 16& + VARPTR(Sounds(ForeGround))
OUT &HA, &H4 + DMA%: 'DMA channel to use (DRQ#)
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, Addr& AND &HFF:  'buffer address of sound data low byte
OUT AddPort%, (Addr& AND &HFF00) \ &H100: 'high byte
IF (Addr& AND 65536) THEN page% = page% + 1: '64K pages for 8-bit DMA
IF (Addr& AND 131072) THEN page% = page% + 2
IF (Addr& AND 262144) THEN page% = page% + 4
IF (Addr& AND 524288) THEN page% = page% + 8
OUT PgPort%, page%: 'output page of phys. addr of sample block
OUT LenPort%, 10: 'size of block to DMA controller -Low
OUT LenPort%, 1: 'high byte
OUT &HA, DMA%: 'release DMA channel
DSPWrite &H40
DSPWrite 194  'Freq '197
DSPWrite &H14:                      '8 bit output over DMA
DSPWrite 10
DSPWrite 1' ((Length% AND &HFFFF) \ &H100)
END SUB

FUNCTION SoundDone%
countlo% = INP(LenPort%)
counthi% = INP(LenPort%)
IF counthi% = 255 AND countlo% = 255 THEN
Bug% = INP(Baseport% + &HE)
SoundDone% = -1
END IF
SoundDone = True
END FUNCTION

SUB SoundInit
Baseport% = &H220: IRQ% = 5: DMA% = 1: 'default
Blaster$ = ENVIRON$("BLASTER")
IF LEN(Blaster$) < 1 THEN
SoundWanted = False
SoundEnabled = False
ELSE
SoundBLASTER ' Parses BLASTER environment
SELECT CASE DMA%
	CASE 0
	   PgPort% = &H87
	   AddPort% = &H0
	   LenPort% = &H1
	   ModeReg% = &H48
	CASE 1
	   PgPort% = &H83
	   AddPort% = &H2
	   LenPort% = &H3
	   ModeReg% = &H49
	CASE 2
	   PgPort% = &H81
	   AddPort% = &H4
	   LenPort% = &H5
	   ModeReg% = &H4A
	CASE 3
	   PgPort% = &H82
	   AddPort% = &H6
	   LenPort% = &H7
	   ModeReg% = &H4B
END SELECT

SoundWanted = False
IF DSPReset% = 0 THEN 'resets DSP (returns true if sucessful)
SoundEnabled = False
ELSE
   SoundSpeaker 1
   SoundEnabled = True
END IF
END IF
END SUB

SUB SoundMix
BufferOffset = VARPTR(Sounds(BackGround))
DEF SEG = VARSEG(Sounds(ForeGround))
    FOR Byte = 0 TO 265  'SoundLength - 1 'STEP 2
       Byte2 = PEEK(BufferOffset + Byte)
       Byte1 = PEEK(Byte)
       Samp = (Byte1 + Byte2) \ 2 'For loud files, this sounds better
       IF Byte1 = 0 THEN Samp = Byte2
       IF Byte2 = 0 THEN Samp = Byte1
       'Samp = Samp \ 2
       POKE Byte, Samp
    NEXT
SELECT CASE Apage
 CASE 0: DEF SEG = &HA000
 CASE 1: DEF SEG = &HAA00    '(512 per page
END SELECT
END SUB

SUB SoundPlay
Sounds(ForeGround) = STRING$(SoundLength, 127) '127
Sounds(BackGround) = STRING$(SoundLength, 127) '127
SELECT CASE SoundVars(0).Effect
CASE Silent: SoundVars(0).MaxCount = 1
CASE Eat1: Sounds(ForeGround) = EatSound1(SoundVars(0).Counter): SoundVars(0).MaxCount = 5
CASE Eat2: Sounds(ForeGround) = EatSound2(SoundVars(0).Counter): SoundVars(0).MaxCount = 5
CASE EatBonus: Sounds(ForeGround) = BonusSound(SoundVars(0).Counter): SoundVars(0).MaxCount = 22
CASE EatGhost: Sounds(ForeGroud) = GhostSound(SoundVars(0).Counter): SoundVars(0).MaxCount = 30
CASE PacDying: Sounds(ForeGround) = DeathSound(SoundVars(0).Counter): SoundVars(0).MaxCount = 90
CASE ELSE: SoundVars(0).MaxCount = 1: SoundVars(0).Effect = Silent
END SELECT

SoundVars(1).Effect = BackNorm
IF SoundVars(0).Effect = EatGhost THEN SoundVars(1).Effect = Silent
FOR G = 1 TO 4
IF Ghost(G).State = Scared AND SoundVars(1).Effect <> BackEyes THEN SoundVars(1).Effect = BackEner
IF Ghost(G).State = Eyes THEN SoundVars(1).Effect = BackEyes
NEXT
IF SoundVars(0).Effect = PacDying THEN
SoundVars(1).Effect = Silent
SoundVars(1).Counter = 0
END IF
'IF SoundVars(0).Effect = PacDying THEN SoundVars(1).Effect = PacDying
SELECT CASE SoundVars(1).Effect
CASE Silent: Sounds(BackGround) = STRING$(SoundLength, 127): SoundVars(1).MaxCount = 1
CASE BackNorm:
  SELECT CASE DotsEaten \ 48
    CASE 0: Sounds(BackGround) = BackSound1(SoundVars(1).Counter): SoundVars(1).MaxCount = 23
    CASE 1: Sounds(BackGround) = BackSound2(SoundVars(1).Counter): SoundVars(1).MaxCount = 22
    CASE 2: Sounds(BackGround) = BackSound3(SoundVars(1).Counter): SoundVars(1).MaxCount = 19
    CASE 3: Sounds(BackGround) = BackSound4(SoundVars(1).Counter): SoundVars(1).MaxCount = 17
    CASE 4, 5: Sounds(BackGround) = BackSound5(SoundVars(1).Counter): SoundVars(1).MaxCount = 16
    CASE ELSE: SoundVars(1).MaxCount = 1
  END SELECT
CASE BackEner: Sounds(BackGround) = EnerSound(SoundVars(1).Counter): SoundVars(1).MaxCount = 16
CASE BackEyes: Sounds(BackGround) = EyesSound(SoundVars(1).Counter): SoundVars(1).MaxCount = 15
'CASE PacDying: Sounds(BackGround) = DeathSound(SoundVars(1).Counter): SoundVars(1).MaxCount = 90
END SELECT
SoundVars(0).Counter = SoundVars(0).Counter + 1
IF SoundVars(0).Counter = SoundVars(0).MaxCount THEN
SoundVars(0).Effect = Silent
SoundVars(0).Counter = 0
END IF
SoundVars(1).Counter = SoundVars(1).Counter + 1
IF SoundVars(1).Counter >= SoundVars(1).MaxCount THEN
SoundVars(1).Effect = 1
SoundVars(1).Counter = 0
END IF
SoundMix
SoundDMA
END SUB

SUB SoundSpeaker (OnOff%)
' Turns speaker on or off.
IF OnOff% THEN DSPWrite &HD1 ELSE DSPWrite &HD3
END SUB

SUB SpriteErase (X, Y)

FOR MazeWidth = X - 5 TO X + 11
 Mask = XMask(MazeWidth)
 OUT &H3CE, 8: OUT &H3CF, Mask
 FOR MazeHeight = Y - 5 TO Y + 11
 Offset = YOffset(MazeHeight) + (MazeWidth \ 8)
 Byte = PEEK(Offset)
 POKE Offset, 0
NEXT MazeHeight
NEXT MazeWidth
FOR MazeHeight = Y - 5 TO Y + 11 STEP 8
FOR MazeWidth = X - 5 TO X + 11 STEP 8
MazePlot ((MazeWidth - ScrX) \ 8), ((MazeHeight - ScrY) \ 8)
NEXT MazeWidth
NEXT MazeHeight
END SUB

SUB SpritePut (X, Y, Sprite())
FOR H = 0 TO 15
 Mask = XMask(H + X - 5)
 OUT &H3CE, 8: OUT &H3CF, Mask
FOR V = 0 TO 15
Pixl = Sprite(H, V)
IF Pixl THEN
 Offset = YOffset(Y + V - 5) + ((X + H - 5) \ 8)
 Byte = PEEK(Offset)
 POKE Offset, Pixl
END IF
NEXT V
NEXT H
END SUB

FUNCTION TestDot (X, Y)
TestDot = False
Char = Maze(PlayerUp, (X - ScrX) \ 8, (Y - ScrY) \ 8)
IF Char = 46 THEN TestDot = True
END FUNCTION

FUNCTION TestEner (X, Y)
TestEner = False
Char = Maze(PlayerUp, (X - ScrX) \ 8, (Y - ScrY) \ 8)
IF Char = 111 THEN TestEner = True
END FUNCTION

FUNCTION TestWall (X, Y)
 TestWall = True
 Char = Maze(PlayerUp, (X - ScrX) \ 8, (Y - ScrY) \ 8)
 IF (Char = 46) OR (Char = 111) OR (Char = 32) OR (Char = 71) THEN TestWall = False
END FUNCTION

FUNCTION TestWall2 (X, Y)
 TestWall2 = True
 Char = Maze(PlayerUp, (X - ScrX) \ 8, (Y - ScrY) \ 8)
 IF (Char = 46) OR (Char = 111) OR (Char = 32) THEN TestWall2 = False
END FUNCTION

