#include <cmvga.h>
#include <conio.h>
#include <stdio.h>

#define BLOCKFILE 	"blocks.dat"
#define PALFILE     "palette.pal"
#define NBLOCKS		10
#define	BSIZE		380

void SetStart(int cx, int cy);
void SaveFile(void);
void LoadFile(void);
void DrawMap(void);
void DrawBlock(int x, int y, int number);
void DrawCursor(int x, int y, int number);
int LoadGraphics(void);

char Block[NBLOCKS][BSIZE];
char Map[160];
int PsX, PsY;
int GsX[3], GsY[3];

void main(void)
{
	int cx = 0, cy = 0;
	char keyhit, quit = 0;
	int bnumber = 0;

	if (LoadGraphics())
	{
		cprintf("Unable to load graphics...\r\n");
		return;
	}

	setmode(0x13);
	loadpal(PALFILE);

	DrawCursor(cx, cy, 9);
	gotoxy(1, 25);
	printf("%d, %d, %d    ", cx / 20, cy / 20, bnumber);
	while (!quit)
	{
		keyhit = getch();
		if (keyhit == 27)
			quit = 1;
		else
		if ( (keyhit == 75) && (cx >= 20) )
			cx -= 20;
		else
		if ( (keyhit == 77) && (cx <= 299) )
			cx += 20;
		else
		if ( (keyhit == 80) && (cy <= 161) )
			cy += 19;
		else
		if ( (keyhit == 72) && (cy >= 19) )
			cy -= 19;
		else
		if (keyhit == 'a')
			Map[(cx / 20) + (cy / 19) * 16] = bnumber;
		else
		if (keyhit == 32)
			Map[(cx / 20) + (cy / 19) * 16] = 0;
		else
		if ( (keyhit == 73) && (bnumber < NBLOCKS - 2) )
			bnumber++;
		else
		if ( (keyhit == 81) && (bnumber > 0) )
			bnumber--;
		else
		if (keyhit == 60)
			SaveFile();
		else
		if (keyhit == 61)
			LoadFile();
		else
		if (keyhit == 59)
			SetStart(cx, cy);

		DrawMap();
		DrawCursor(cx, cy, 9);
		gotoxy(1, 25);
		printf("%d, %d, %d    ", cx / 20, cy / 20, bnumber);
	}

	setmode(0x03);
}

void SetStart(int cx, int cy)
{
	char input;

	gotoxy(1, 25);
	printf("P)acman, Ghost 0), Ghost 1), Ghost 2) ?");
	input = getch();
	gotoxy(1, 25);
	printf("                                          ");
	gotoxy(1, 25);
	if (input == 'p')
	{
		PsX = cx;
		PsY = cy;
	}
	else
	if (input == '0')
	{
		GsX[0] = cx;
		GsY[0] = cy;
	}
	else
	if (input == '1')
	{
		GsX[1] = cx;
		GsY[1] = cy;
	}
	else
	if (input == '2')
	{
		GsX[2] = cx;
		GsY[2] = cy;
	}
}

void SaveFile(void)
{
	FILE *fp;
	char FileName[80];

	gotoxy(1, 25);
	printf("Save filename: ");
	scanf("%s", FileName);
	gotoxy(1, 25);
	printf("Saving...");

	fp = fopen(FileName, "wb");
	if (fp == NULL)
		return;
	fwrite(Map, 1, 160, fp);
	fputc(PsX, fp);
	fputc(PsY, fp);
	for (int t = 0; t < 3; t++)
	{
		fputc(GsX[t], fp);
		fputc(GsY[t], fp);
	}
	fclose(fp);
	cls(0);
}

void LoadFile(void)
{
	FILE *fp;
	char FileName[80];

	gotoxy(1, 25);
	printf("Load filename: ");
	scanf("%s", FileName);
	gotoxy(1, 25);
	printf("Saving...");

	fp = fopen(FileName, "rb");
	if (fp == NULL)
		return;
	fread(Map, 1, 160, fp);
	PsX = fgetc(fp);
	PsY = fgetc(fp);
	for (int t = 0; t < 3; t++)
	{
		GsX[t] = fgetc(fp);
		GsY[t] = fgetc(fp);
	}
	fclose(fp);
	cls(0);
}

void DrawMap(void)
{
	int h, v;

	for (v = 0; v < 10; v++)
		for (h = 0; h < 16; h++)
			DrawBlock(h * 20, v * 19, Map[h + v * 16]);
}

void DrawBlock(int x, int y, int number)
{
	int h, v;

	for (v = 0; v < 19; v++)
		for (h = 0; h < 20; h++)
				vga[(h + x) + (v + y) * 320] = Block[number][h + v * 20];
}

void DrawCursor(int x, int y, int number)
{
	int h, v;

	for (v = 0; v < 19; v++)
		for (h = 0; h < 20; h++)
			if (Block[number][h + v * 20])
				vga[(h + x) + (v + y) * 320] = Block[number][h + v * 20];
}

int LoadGraphics(void)
{
	FILE *fp;
	int t;

	fp = fopen(BLOCKFILE, "rb");
	if (fp == NULL)
		return 1;

	for (t = 0; t < NBLOCKS; t++)
		if (fread(Block[t], 1, BSIZE, fp) != BSIZE)
		{
			fclose(fp);
			return 1;
		}

	fclose(fp);
	return 0;
}