#include <stdlib.h>
#include <cmvga.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <cmkey.h>

#define BLOCKFILE 	"blocks.dat"
#define PMFILE		"pacman.dat"
#define GHOSTFILE	"ghost.dat"
#define PALFILE     "palette.pal"
#define NBLOCKS		9
#define	BSIZE		380
#define WEST		0
#define	EAST		1
#define NORTH		2
#define SOUTH		3
#define SPRWIDTH	20
#define SPRHEIGHT	19
#define BLUE		0
#define YELLOW		1
#define GREEN		2
#define	FRMCHANGE	8
#define GSLOW		5
#define GHOST		69
#define PACMAN		50

int  WalkGhost(int number);
void DrawGhost(int number);
void DrawPacMan(void);
void DrawMap(void);
void DrawBlock(int x, int y, int number);
int  LoadGraphics(void);
int	 LoadPacMan(void);
int  LoadMap(char *FileName);

char Block[NBLOCKS][BSIZE];
char Map[160];
char LevelName[1][20] = {"level1.lvl"};
int PmsX, PmsY;
int GsX[3], GsY[3];

struct {
	char *Data[4];
	int Level;
	int x, y;
	int MapX, MapY;
	int Direction;
	int Hyper;
	int Points;
} PacMan;

struct {
	int x, y;
	int MapX, MapY;
	char *Data[2];
	int Direction;
	int Frame;
	int FrameChange;
	int GhostSlow;
} Ghost[3];

void main(void)
{
	int quit = 0;
	char keyhit;
	int t;

	// INIT

	if (LoadGraphics() + LoadMap(LevelName[PacMan.Level]) + LoadPacMan())
	{
		cprintf("Unable to load game...\r\n");
		return;
	}

	setmode(0x13);
	loadpal(PALFILE);
	DrawMap();

	installkeyhandler();
	while (!quit)
	{
		// Check keys

		if (keys[ESCAPE])
			quit = 1;

		if (ekeys[LEFT])
		{
			DrawBlock(PacMan.x, PacMan.y, 0);
			PacMan.x -= 20;
			PacMan.MapX--;
			PacMan.Direction = WEST;
		}
		else
		if (ekeys[RIGHT])
		{
			DrawBlock(PacMan.x, PacMan.y, 0);
			PacMan.x += 20;
			PacMan.MapX++;
			PacMan.Direction = EAST;
		}
		else
		if (ekeys[UP])
		{
			DrawBlock(PacMan.x, PacMan.y, 0);
			PacMan.y -= 19;
			PacMan.MapY--;
			PacMan.Direction = NORTH;
		}
		else
		if (ekeys[DOWN])
		{
			DrawBlock(PacMan.x, PacMan.y, 0);
			PacMan.y += 19;
			PacMan.MapY++;
			PacMan.Direction = SOUTH;
		}

		if (Map[PacMan.MapX + PacMan.MapY * 16] > 2)
		{
			switch (PacMan.Direction)
			{
				case WEST:
					PacMan.x += 20;
					PacMan.MapX++;
					break;
				case EAST:
					PacMan.x -= 20;
					PacMan.MapX--;
					break;
				case NORTH:
					PacMan.y += 19;
					PacMan.MapY++;
					break;
				case SOUTH:
					PacMan.y -= 19;
					PacMan.MapY--;
				break;
			}
		}
		else
		if (Map[PacMan.MapX + PacMan.MapY * 16] == 2)
		{
			Map[PacMan.MapX + PacMan.MapY * 16] = 0;
			PacMan.Points++;
		}
		else
		if (Map[PacMan.MapX + PacMan.MapY * 16] == 1)
		{
			Map[PacMan.MapX + PacMan.MapY * 16] = 0;
			PacMan.Hyper = 1;
		}

		DrawPacMan();
		for (t = 0; t < 3; t++)
			DrawGhost(t);

		gotoxy(1, 25);
		printf("%d %d, %d %d, %d  ", PacMan.MapX, PacMan.MapY,
		PacMan.x, PacMan.y, PacMan.Points);
		delay(120);
		for (t = 0; t < 3; t++)
		{
			if (Ghost[t].GhostSlow == GSLOW)
			{
				if (WalkGhost(t))
					quit = 1;
				Ghost[t].GhostSlow = 0;
			}
			Ghost[t].GhostSlow++;
			Ghost[t].FrameChange++;
			if (Ghost[t].FrameChange == FRMCHANGE)
			{
				Ghost[t].FrameChange = 0;
				if (Ghost[t].Frame == 0)
					Ghost[t].Frame = 1;
				else
				if (Ghost[t].Frame == 1)
					Ghost[t].Frame = 0;
			}
		}
	}
	uninstallkeyhandler();
	setmode(0x03);
}

int WalkGhost(int t)
{
	int PlrXDist, PlrYDist;
	int PlrInvisible = 0;
	int NewDirection;

	PlrXDist = PacMan.MapX - Ghost[t].MapX;
	PlrYDist = PacMan.MapY - Ghost[t].MapY;

	Ghost[t].MapX = Ghost[t].x / 20;
	Ghost[t].MapY = Ghost[t].y / 19;

	DrawBlock(Ghost[t].x, Ghost[t].y, Map[Ghost[t].MapX + Ghost[t].MapY * 16]);

	if (abs(PlrXDist) > abs(PlrYDist))
	{
		if (PlrXDist > 0)
		{
			if (Map[(Ghost[t].MapX + 1) + Ghost[t].MapY * 16] < 3)
			{
				Ghost[t].x += 20;
				Ghost[t].MapX ++;
			}
			else
				PlrInvisible = 1;
		}
		else
		{
			if (Map[(Ghost[t].MapX - 1) + Ghost[t].MapY * 16] < 3)
			{
				Ghost[t].x -= 20;
				Ghost[t].MapX --;
			}
			else
				PlrInvisible = 1;
		}
	}
	else
	{
		if (PlrYDist > 0)
		{
			if (Map[Ghost[t].MapX + (Ghost[t].MapY + 1) * 16] < 3)
			{
				Ghost[t].y += 19;
				Ghost[t].MapY ++;
			}
			else
				PlrInvisible = 1;
		}
		else
		{
			if (Map[Ghost[t].MapX + (Ghost[t].MapY - 1) * 16] < 3)
			{
				Ghost[t].y -= 19;
				Ghost[t].MapY --;
			}
			else
				PlrInvisible = 1;
		}
	}

	if (PlrInvisible)
	{
		NewDirection = rand() % 4;

		switch (NewDirection)
		{
			case WEST:
				if (Map[(Ghost[t].MapX - 1) + Ghost[t].MapY * 16] < 3)
				{
					Ghost[t].x -= 20;
					Ghost[t].MapX --;
				}
				break;
			case EAST:
				if (Map[(Ghost[t].MapX + 1) + Ghost[t].MapY * 16] < 3)
				{
					Ghost[t].x += 20;
					Ghost[t].MapX ++;
				}
				break;
			case NORTH:
				if (Map[Ghost[t].MapX + (Ghost[t].MapY - 1) * 16] < 3)
				{
					Ghost[t].y -= 19;
					Ghost[t].MapY --;
				}
				break;
			case SOUTH:
				if (Map[Ghost[t].MapX + (Ghost[t].MapY + 1) * 16] < 3)
				{
					Ghost[t].y += 19;
					Ghost[t].MapY ++;
				}
				break;
		}
	}

	if ((Ghost[t].MapX == PacMan.MapX) &&
		(Ghost[t].MapY == PacMan.MapY))
		return 1;
	return 0;
}

void DrawGhost(int number)
{
	int h, v;

	for (v = 0; v < 19; v++)
		for (h = 0; h < 20; h++)
			vga[(h + Ghost[number].x) + (v + Ghost[number].y) * 320] =
				Ghost[number].Data[Ghost[number].Frame][h + v * 20];
}

void DrawPacMan(void)
{
	int h, v;

	for (v = 0; v < 19; v++)
		for (h = 0; h < 20; h++)
			vga[(h + PacMan.x) + (v + PacMan.y) * 320] =
				PacMan.Data[PacMan.Direction][h + v * 20];
}

void DrawMap(void)
{
	int h, v;

	for (v = 0; v < 10; v++)
		for (h = 0; h < 16; h++)
			DrawBlock(h * 20, v * 19, Map[h + v * 16]);
}

void DrawBlock(int x, int y, int number)
{
	int h, v;

	for (v = 0; v < 19; v++)
		for (h = 0; h < 20; h++)
				vga[(h + x) + (v + y) * 320] = Block[number][h + v * 20];
}

int LoadGraphics(void)
{
	FILE *fp;
	int t;

	fp = fopen(BLOCKFILE, "rb");
	if (fp == NULL)
		return 1;

	for (t = 0; t < NBLOCKS; t++)
		if (fread(Block[t], 1, BSIZE, fp) != BSIZE)
		{
			fclose(fp);
			return 1;
		}

	fclose(fp);
	return 0;
}

int LoadPacMan(void)
{
	FILE *fp;

	PacMan.Level = 0;
	PacMan.x = PmsX;
	PacMan.y = PmsY;
	PacMan.Direction = WEST;
	PacMan.MapX = PacMan.x / 20;
	PacMan.MapY = PacMan.y / 19;
	fp = fopen(PMFILE, "rb");
	if (fp == NULL)
		return 1;
	for (int t = 0; t < 4; t++)
	{
		PacMan.Data[t] = (char*)malloc(380);
		if (PacMan.Data[t] == NULL)
		{
			fclose(fp);
			return 1;
		}

		fread(PacMan.Data[t], 380, 1, fp);
	}

	fclose(fp);

	fp = fopen(GHOSTFILE, "rb");
	if (fp == NULL)
		return 1;

	for (t = 0; t < 3; t++)
	{
		for (int a = 0; a < 2; a++)
		{
			Ghost[t].x = GsX[t];
			Ghost[t].y = GsY[t];
			Ghost[t].Direction = SOUTH;
			Ghost[t].Frame = 0;
			Ghost[t].Data[a] = (char*)malloc(380);

			if (Ghost[t].Data[a] == NULL)
			{
				fclose(fp);
				return 1;
			}
			fread(Ghost[t].Data[a], 380, 1, fp);
		}
	}

	fclose(fp);
	return 0;
}

int LoadMap(char *FileName)
{
	FILE *fp;

	fp = fopen(FileName, "rb");
	if (fp == NULL)
		return 1;
	fread(Map, 1, 160, fp);
	PmsX = fgetc(fp);
	PmsY = fgetc(fp);
	for (int t = 0; t < 3; t++)
	{
		GsX[t] = fgetc(fp);
		GsY[t] = fgetc(fp);
	}
	fclose(fp);

	return 0;
}
