'- downloaded from the RibbonSoft Homepage (ribbonsoft@hotmail.com)
'- http://bounce.to/ribbonsoft
'- RibbonSoft are: Duncan Scott & Alan O'Hagan

'===========================================================================
' PLEBS                                                    Duncan Scott 1999
'===========================================================================
'  Aim of the game: Bounce the plebs accross safely!
'  Mouse driver required
'  Adjust speed constants if required (0:fast,  >0:slower)
'  Tip: try to back-spin the plebs using a slice!

' Control:
'  Use escape to show the menu
'  Use right button to fire more plebs if needed in the game
'  Use Left and right buttons in the menu to take values up & down

' Note: If you use a slower machine, it's possible the game will occasionally
' glitch. This is caused by the SOUND statements.


CONST gamespeed% = 1                ' Set to zero for max speed.

DECLARE SUB NewPleb (x%, y%, typ%, xv!, yv!, rotspd%)
DECLARE SUB DrawPlebs ()
DECLARE SUB MovePlebs ()
DECLARE SUB StartParticle (x!, y!, xv!, yv!, xa!, ya!, colour%, timelimit%)
DECLARE SUB MoveParticles ()
DECLARE SUB StartDistraction (newdis%)
DECLARE SUB MoveNDrawDis ()
DECLARE SUB FadeFromToPalette (from$, to$, times%, thres%)
DECLARE FUNCTION DoMenu% (py%, but%, a$)
DECLARE SUB OpenMenu (file$)
DECLARE SUB CircleFade (x%, y%, maxrad%)
DECLARE SUB LoadBack (back%)
DECLARE SUB Loadaims (w%)
DECLARE FUNCTION WaitInput! (ky%, mse%, ret%)
DECLARE FUNCTION FramesCounter% ()
DECLARE SUB AddScore (a%)
DECLARE SUB SetMenuValue (men%, item%, vl%)
DECLARE FUNCTION GetMenuValue% (men%, item%)
DECLARE FUNCTION CompareCodes% (d1%, d2%, d3%, d4%)
DECLARE SUB Highscores ()
DECLARE FUNCTION GetInput$ (tx%, ty%, maxc%)
DECLARE SUB LoadScores ()
DECLARE SUB LoadGfx (merge$, file$)
DECLARE SUB WriteFont (toseg%, dummy1%, x%, y%, a$, col%, dummy2%)

COMMON SHARED maxplebs%, trolx%, troly%, maxparts%, trolyv%, permy%, wind, maxdistractions%, fps%, maxfloats%, maxpass%, pn%, lifeaction%, trolspd%
COMMON SHARED saved%, created%, maxpeople%, ending%, gamestate%, nextx%, gravity, mouset, mouseok%, peopleaim%, timelimit%, jumprate, score&

'Menu ones
COMMON SHARED currmenu%, curritem%, maxmenu%, maxitems%

'$INCLUDE: 'adlib.bi'

TYPE TH
  MAN AS STRING * 1
  VER AS STRING * 1
  ENC AS STRING * 1
  BIT AS STRING * 1
  XLS AS INTEGER
  YLS AS INTEGER
  XMS AS INTEGER
  YMS AS INTEGER
  HRE AS INTEGER
  VRE AS INTEGER
  col AS STRING * 48
  RES AS STRING * 1
  PLA AS STRING * 1
  BYT AS INTEGER
  pal AS INTEGER
  FIL AS STRING * 58
END TYPE

TYPE pleb
x AS SINGLE '  Inorder of 'NewPleb' parameters
y AS SINGLE
plebtype AS INTEGER
xv AS SINGLE
yv AS SINGLE
rotspd AS INTEGER
angle AS INTEGER
state AS INTEGER
END TYPE

TYPE header
 Filename AS STRING * 13
 length AS LONG
END TYPE

TYPE distraction
x AS INTEGER
y AS INTEGER
xv AS INTEGER
yv AS INTEGER
frame AS INTEGER
END TYPE

TYPE particle
x AS SINGLE
y AS SINGLE
xv AS SINGLE
yv AS SINGLE
colour AS INTEGER
xa AS SINGLE
ya AS SINGLE
timelimit AS INTEGER
tmer AS INTEGER
END TYPE

RANDOMIZE TIMER
ON ERROR GOTO handler

maxplebs% = 10: mpt% = 8: maxparts% = 100: maxdistractions% = 14' on screen at once.
maxfloats% = 6: maxpass% = 5
gamestate% = 1' gamestate% meanings:
' 1 = Menu
' 2 = Practise
' 3 = Aim to the game

saved% = 0: created% = 0: ending% = 0: score& = 0

DIM SHARED floatings%(1 TO maxfloats%, 1 TO 4) ' x,y,type,float_timer (for bobbing)
DIM SHARED parts(1 TO maxparts%) AS particle
DIM SHARED plebs(1 TO maxplebs%) AS pleb
DIM SHARED trolley(0 TO 54, 1 TO 4)
DIM SHARED distract(0 TO 70, 1 TO 8)
DIM SHARED plebgfx(0 TO 64, 1 TO mpt% + 1)
DIM SHARED distractions(1 TO maxdistractions%) AS distraction
DIM SHARED onboard%(1 TO maxpass%)
DIM SHARED array2%(0 TO 255, 1 TO 3)

DIM SHARED pcxh AS TH
DIM SHARED dat AS STRING * 1

maxmenus% = 11
maxitems% = 10

jumprate = 3.5
gravity = .1

DIM SHARED menu$(1 TO maxmenus%, 0 TO maxitems%)
DIM SHARED menucol%(1 TO maxmenus%, 0 TO maxitems%, 1 TO 2)

OpenMenu "menu.plb"

REDIM SHARED buffer1%(31999)
REDIM SHARED buffer2%(31999)

mouseok% = AdMouseDetect%

IF mouseok% = 0 THEN PRINT "Mouse Driver needed for plebs!": BEEP: SYSTEM

AdMouseSetBounds 0, 0, 640, 200


SCREEN 13

ADSetPalTo 0, 0, 0

LoadGfx "graphics.Gfx", "mapmerv.pcx"

'Grab people
FOR I% = 1 TO mpt% + 1
xo% = 0
yo% = (I% - 1) * 17
GET (1 + xo%, 1 + yo%)-(16 + xo%, 16 + yo%), plebgfx(0, I%)
NEXT I%

'Get trolley frames...
FOR I% = 1 TO 4
yo% = (I% - 1) * 7
GET (18, 1 + yo%)-(18 + 35, 6 + yo%), trolley(0, I%)
NEXT I%

'Distractions....
FOR I% = 1 TO 8
xo% = (I% - 1) * 29
GET (18 + xo%, 29)-(18 + 27 + xo%, 38), distract(0, I%)
NEXT I%

LoadBack (1)
LoadScores

CLS
ADPaletteF "plebs"

LoadGfx "graphics.gfx", "plebs.pcx"

SLEEP

CLS
distractions(maxdistractions%).x% = -32
distractions(maxdistractions%).y% = 170
distractions(maxdistractions%).xv% = 0
distractions(maxdistractions%).yv% = 0
distractions(maxdistractions%).frame% = 6
wind = -.04
permy% = 151
troly% = permy%
welldone% = -1

DO
ADPcopy VARSEG(buffer2%(0)), VARSEG(buffer1%(0))

AdMouseInfo mousex%, mousey%, button%

'IF gamestate% <> 1 AND button% > 1 AND troly% > -100 THEN trolyv% = -6

IF gamestate% <> 1 THEN ' If not in menu then must be playing...
trgx% = mousex% ' end player in control
ELSE
IF oldstate% <> 3 THEN
IF trolx% < nextx% - 8 THEN trgx% = trolx% + 8'Computer in control
IF trolx% > nextx% + 8 THEN trgx% = trolx% - 8'Computer in control
END IF
END IF

IF trolx% > trgx% THEN
trolf% = trolf% + 1
CALL StartParticle(trolx% + 4, troly% + 6, RND, -.2, 0, 0, 15 + 5 * RND, 10)
CALL StartParticle(trolx% + 31, troly% + 6, RND, -.2, 0, 0, 15 + 5 * RND, 10)
END IF
IF trolx% < trgx% THEN
trolf% = trolf% - 1
CALL StartParticle(trolx% + 4, troly% + 6, RND, -.2, 0, 0, 15 + 5 * RND, 10)
CALL StartParticle(trolx% + 31, troly% + 6, RND, -.2, 0, 0, 15 + 5 * RND, 10)
END IF

trolx% = trgx%
temp% = oldtrolx% - trolx%
IF temp% <> 0 THEN trolspd% = trolx% - oldtrolx%

oldtrolx% = trolx%

IF trolf% > 4 THEN trolf% = 1
IF trolf% < 1 THEN trolf% = 4

IF NOT (gamestate% = 1 AND (oldstate% >= 3)) OR (gamestate% = 1 AND oldstate% = 5 AND welldone% <> -1) THEN MovePlebs

MoveParticles 'what ever
ADSprite VARSEG(trolley(0, trolf%)), VARPTR(trolley(0, trolf%)), trolx%, troly%, VARSEG(buffer1%(0))

MoveNDrawDis ' what ever happens

'Handle impulse effects on trolley , i.e. jump it in air.
troly% = troly% + trolyv%
trolyv% = trolyv% + 1
IF troly% > permy% THEN troly% = permy%: trolyv% = 0


IF INT(RND * fps% * 8) = 1 THEN
dis% = 1 + INT(RND * 4)
StartDistraction (dis%)
END IF


'New pleb!
IF NOT (gamestate% = 1 AND (oldstate% >= 3)) OR (gamestate% = 1 AND oldstate% = 5 AND welldone% <> -1) THEN
IF (button% = 1 OR button% = 3) AND TIMER - mt > 1 THEN
xv = -(.5 + .5 * RND)
typ% = 1 + INT(RND * mpt%)
rotspd% = 1 + INT(RND * 4)
CALL NewPleb(300, 23, typ%, xv, -1.3, rotspd%)
mt = TIMER
END IF

IF INT(RND * fps% * jumprate) = 1 THEN
xv = -(.5 + .5 * RND)
typ% = 1 + INT(RND * mpt%)
rotspd% = 1 + INT(RND * 4)
CALL NewPleb(300, 23, typ%, xv, -1.3, rotspd%)
END IF

END IF

DrawPlebs

'Successes:
IF gamestate% = 5 AND peopleaim% <> 0 AND saved% >= peopleaim% AND maxpeople% = 0 AND timelimit% = 0 THEN
oldstate% = 5
gamestate% = 1: currmenu% = 8: curritem% = 1
menu$(8, 0) = "Wave completed"
menu$(8, 1) = "All present and correct"
menu$(8, 2) = "sir, all plebs accounted"
menu$(8, 3) = "for!"
menu$(8, 4) = ""
welldone% = 1
mouseok% = 0: mouset = TIMER + 2
END IF

IF gamestate% = 5 AND timelimit% <> 0 THEN timeleft = TIMER - timet

IF gamestate% = 5 AND timelimit% <> 0 AND timeleft >= timelimit% THEN
oldstate% = 5
gamestate% = 1: currmenu% = 8: curritem% = 1
menu$(8, 0) = "Unlucky"
menu$(8, 1) = "You ran out of time."
menu$(8, 2) = "You had" + STR$(peopleaim% - saved%) + " people left to "
menu$(8, 3) = "get home."
menu$(8, 4) = "You needed to get" + STR$(peopleaim%) + " home"
welldone% = 0
'menu$(8, 6) = ""
mouseok% = 0: mouset = TIMER + 2
END IF

IF gamestate% = 5 AND timelimit% <> 0 AND saved% >= peopleaim% THEN
oldstate% = 5
gamestate% = 1: currmenu% = 8: curritem% = 1
menu$(8, 0) = "Well done!"
menu$(8, 1) = "You raced inside that time!"
menu$(8, 2) = "Time left:" + STR$(INT(timelimit% - timeleft))
menu$(8, 3) = ""
menu$(8, 4) = ""
welldone% = 1
mouseok% = 0: mouset = TIMER + 2
END IF

IF gamestate% = 4 THEN timeleft = TIMER - timet
IF gamestate% = 4 AND saved% >= peopleaim% THEN

WriteFont &HA000, 0, 50, 90, "Well done! Time Trial completed", 144, 0

SOUND 500, 1
SOUND 1000, 1
gamestate% = 1: oldstate% = 0
currmenu% = 1: curritem% = 1
menucol%(1, 3, 1) = 0
menucol%(1, 3, 2) = 15
'SLEEP
dm% = WaitInput(1, 0, 0)
AdMouseInfo mousex%, mousey%, button%

END IF

IF gamestate% = 4 AND timeleft >= timelimit% THEN
WriteFont &HA000, 0, 88, 90, "Bad luck. Try again", 43, 60

SOUND 500, 1
SOUND 100, 2
gamestate% = 1: oldstate% = 0
currmenu% = 1: curritem% = 1
menucol%(1, 3, 1) = 0
menucol%(1, 3, 2) = 15
'SLEEP
dm% = WaitInput(1, 0, 0)
AdMouseInfo mousex%, mousey%, button%
END IF

IF ending% = 1 THEN
srt = TIMER: ending% = 2: b% = 0
IF gamestate% = 5 THEN      'Then all people have been used up.
oldstate% = 5
gamestate% = 1: currmenu% = 8: curritem% = 1
IF saved% >= peopleaim% THEN
welldone% = 1
mouseok% = 0: mouset = TIMER + 2
menu$(8, 0) = "Success!"
menu$(8, 1) = "You got" + STR$(saved%) + " plebs home"
menu$(8, 2) = "out of" + STR$(maxpeople%)
menu$(8, 3) = "You only needed" + STR$(peopleaim%) + " plebs!"
ELSE
welldone% = 0
mouseok% = 0: mouset = TIMER + 2
menu$(8, 0) = "Bad luck"
menu$(8, 1) = "You got" + STR$(saved%) + " plebs home"
menu$(8, 2) = "out of" + STR$(maxpeople%)
menu$(8, 3) = "You actually needed" + STR$(peopleaim%) + " plebs"
menu$(8, 4) = "Never mind."
END IF
ending% = 0
END IF

END IF
'END IF

IF ending% = 2 AND NOT (gamestate% = 1 AND (oldstate% >= 3)) THEN
diff = TIMER - srt
ni% = 6 * diff '6=25/4
IF ni% <> li% THEN li% = ni%: ADFadeTo 0, 0, 0, 1, 0

IF diff > 4 THEN 'quit% = 2
IF maxpeople% <> 0 THEN per% = 100 * (saved% / maxpeople%)

RESTORE
DO
READ l1%, l2%, r$
IF per% >= l1% AND per% <= l2% THEN comment$ = r$
LOOP UNTIL r$ = "END"

ADPcopy VARSEG(buffer2%(0)), &HA000

WriteFont &HA000, 0, 1, 70, "Could have saved:", 15, 30
WriteFont &HA000, 0, 128, 70, STR$(maxpeople%), 48, 60
WriteFont &HA000, 0, 1, 80, "You saved:", 15, 30
WriteFont &HA000, 0, 72, 80, STR$(saved%), 48, 60
WriteFont &HA000, 0, 1, 100, "Survival rate:", 15, 30
WriteFont &HA000, 0, 104, 100, STR$(per%) + "%", 48, 60

WriteFont &HA000, 0, 1, 110, "The plebs say:", 15, 30
com2$ = ""
IF LEN(comment$) > 25 THEN com2$ = MID$(comment$, 26): comment$ = MID$(comment$, 1, 25)
WriteFont &HA000, 0, 112, 110, comment$, 48, 60
WriteFont &HA000, 0, 1, 120, com2$, 48, 60

FOR I% = 1 TO 50
FadeFromToPalette "This can be anything!", "plebs", I%, 50
ADWait (1)
NEXT I%

gamestate% = 1: currmenu% = 1: curritem% = 1
oldstate% = 0: ending% = 0
menucol%(1, 3, 1) = 0
menucol%(1, 3, 2) = 15

'DO
'LOOP UNTIL INKEY$ <> ""
dm% = WaitInput(1, 0, 0)

END IF ' Stop displaying message

END IF

fps% = FramesCounter%

'text goes infront fo everything else
'Scores:
IF gamestate% > 2 THEN
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 1, 189, "Score:" + STR$(score&), 208, 223
END IF

IF gamestate% = 5 AND peopleaim% <> 0 AND timelimit% = 0 AND maxpeople% = 0 THEN 'save people
xo% = 1
mes$ = STR$(saved%) + " /" + STR$(peopleaim%)
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 1, 1, mes$, 240, 254
END IF

IF gamestate% = 4 OR (gamestate% = 5 AND timelimit% <> 0) THEN  'Time trial
xo% = 1
mes$ = STR$(saved%)
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 1, 1, mes$, 240, 254

xo% = xo% + 8 * LEN(mes$)
mes$ = " plebs saved of"
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 1, mes$, 15, 30

xo% = xo% + 8 * LEN(mes$)
mes$ = STR$(peopleaim%)
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 1, mes$, 240, 254

xo% = xo% + 8 * LEN(mes$)
mes$ = " : Time left ="
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 1, mes$, 15, 30

xo% = xo% + 8 * LEN(mes$)
mes$ = STR$(INT(timelimit% - timeleft))
nn% = VAL(mes$)
IF nn% < 10 THEN c% = 40 ELSE c% = 240
IF oldn% <> nn% AND nn% < 10 THEN SOUND 1000, 1
oldn% = nn%
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 1, mes$, c%, c% + 14
IF gamestate% = 5 AND maxpeople% <> 0 THEN
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 1, 10, "Plebs jumped:", 16, 31
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 96, 10, STR$(created%) + " /" + STR$(maxpeople%), 240, 254
END IF
END IF

IF gamestate% = 3 OR (gamestate% = 5 AND maxpeople% <> 0 AND timelimit% = 0) THEN ' Pleb challenge
xo% = 1
mes$ = STR$(created%)
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 1, mes$, 240, 254

xo% = xo% + 8 * LEN(mes$)
mes$ = " plebs jumped of"
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 1, mes$, 15, 29

xo% = xo% + 8 * LEN(mes$)
mes$ = STR$(maxpeople%)
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 1, mes$, 240, 254
'Plebs saved=

mes$ = "Plebs saved="
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 1, 10, mes$, 15, 29
xo% = 8 * LEN(mes$)
mes$ = STR$(saved%)
WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), xo%, 10, mes$, 240, 254

END IF

IF gamestate% = 2 THEN WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 1, 1, "Practise mode", 15, 30

'WAIT &H3DA, 8

a$ = INKEY$
IF gamestate% = 1 THEN
'Overlay menu.

act% = DoMenu%(mousey%, button%, a$)

IF currmenu% = 3 AND act% = 1 THEN ' Are you sure? -> yes.
IF oldstate% = 5 AND score& <> 0 THEN currmenu% = 11: curritem% = 1: Highscores
quit% = 2
END IF

IF quit% = 2 AND currmenu% <> 11 THEN quit% = 1

IF currmenu% = 10 AND act% = 5 THEN 'Check codes!
w% = CompareCodes%(GetMenuValue%(currmenu%, 1), GetMenuValue%(currmenu%, 2), GetMenuValue%(currmenu%, 3), GetMenuValue%(currmenu%, 4))
IF w% <> 0 THEN
wave% = w%
Loadaims (wave%)
score& = 0
menu$(9, 0) = "This is wave" + STR$(wave%)
mouseok% = 0: mouset = TIMER + .5
welldone% = -1
ELSE
SOUND 2000, 2.5
END IF
END IF

IF currmenu% = 7 AND act% = 1 THEN  'Normal game
'Aim is to play with through different aims per wave:
'i.e. wave1 = get 10 people saved.
' wave2= save 15 people of 25.
' wave3= Time limit one.
' etc.
wave% = 1
score& = 0
Loadaims (wave%)
menu$(9, 0) = "Ok. Here's what you do"
mouseok% = 0: mouset = TIMER + .5
welldone% = -1
END IF

IF currmenu% = 9 AND act% = 6 THEN ' Next wave
IF wave% = 1 THEN score& = 0
saved% = 0: created% = 0
FOR I% = 1 TO maxplebs%
plebs(I%).state% = 0
NEXT I%
gamestate% = 5
IF timelimit% <> 0 THEN timet = TIMER
mouseok% = 0: mouset = TIMER + .5
welldone% = -1
END IF

IF currmenu% = 8 AND act% = 5 THEN '[OK]
'don't Clear all plebs
'FOR I% = 1 TO maxplebs%
'plebs(I%).state% = 0
'NEXT I%

IF welldone% = 0 THEN
Loadaims (wave%):
menu$(9, 0) = "This old level again"
score& = oldscore&
 mouseok% = 0: mouset = TIMER + .5
ELSE 'next
menu$(9, 0) = "Next Wave"
wave% = wave% + 1
Loadaims (wave%)
oldscore& = score&
IF maxpeople% = -1 THEN
currmenu% = 1: curritem% = 1
gamestate% = 1
oldstate% = 0: ending% = 0
menucol%(1, 3, 1) = 0
menucol%(1, 3, 2) = 15
'Finished game so
currmenu% = 11: curritem% = 1
ADPcopy &HA000, VARSEG(buffer1%(0))
CircleFade 160, 100, 200
ADPcopy VARSEG(buffer1%(0)), &HA000
ADPaletteF "plebs"
Highscores
score& = 0: oldscore& = 0
END IF
 mouseok% = 0: mouset = TIMER + .5
END IF
END IF

IF currmenu% = 1 AND act% = 1 THEN 'Practise game
gamestate% = 2
END IF

IF currmenu% = 1 AND act% = 3 AND menucol%(1, 3, 1) = 15 THEN gamestate% = oldstate%

IF currmenu% = 2 AND act% <> 0 THEN
gamestate% = 3
saved% = 0: created% = 0
IF act% = 1 THEN maxpeople% = 15
IF act% = 2 THEN maxpeople% = 30
IF act% = 3 THEN maxpeople% = 50
IF act% = 4 THEN maxpeople% = newmaxpeople%

IF maxpeople% = 0 THEN ' Extract custom total
        colon% = INSTR(menu$(5, 1), ":")
        cv% = VAL(MID$(menu$(5, 1), colon% + 1))
        maxpeople% = cv%
END IF

END IF

IF currmenu% = 5 AND act% <> 0 THEN
IF act% = 5 THEN  'Default settings
SetMenuValue currmenu%, 1, 25
SetMenuValue currmenu%, 2, 7
SetMenuValue currmenu%, 3, 10
END IF

IF act% = 6 THEN 'OK
IF oldstate% <> 5 THEN
newmaxpeople% = GetMenuValue%(currmenu%, 1)
jumprate = (15 - GetMenuValue%(currmenu%, 2)) / 2
gravity = GetMenuValue%(currmenu%, 3) / 100
'currmenu% = 1
'mouseok% = 0: mouset = TIMER
ELSE
SOUND 2000, 2
END IF
END IF
END IF

IF currmenu% = 6 AND act% <> 0 THEN
IF act% = 4 THEN  'Suggest time

peopleaim% = GetMenuValue%(currmenu%, 1)
diff% = GetMenuValue%(currmenu%, 2)
IF diff% = 1 THEN tm% = 6
IF diff% = 2 THEN tm% = 4
IF diff% = 3 THEN tm% = 3

SetMenuValue currmenu%, 3, peopleaim% * tm%
END IF

IF act% = 5 THEN 'START time trial game
peopleaim% = GetMenuValue(currmenu%, 1)
timelimit% = GetMenuValue(currmenu%, 3)
gamestate% = 4
END IF
END IF 'End time trial menu

IF gamestate% <> 1 THEN ' New game started
menucol%(1, 3, 1) = 15
menucol%(1, 3, 2) = 30
IF oldstate% = 4 OR oldstate% = 5 THEN timet = TIMER - savet

'if a new game
IF gamestate% = 4 AND NOT (currmenu% = 1 AND act% = 3) THEN

saved% = 0
score& = 0
'Display message.
mes$ = "Press any key to start the Time Trials!"
c% = 32
DO
c% = c% + 1
IF c% > 63 THEN c% = 32
SOUND c% * 10, .1
WriteFont &HA000, 0, 160 - 4 * LEN(mes$), 20, mes$, c%, c%
ADWait (1)
LOOP UNTIL WaitInput(1, 0, 1)'INKEY$ <> ""
timet = TIMER
END IF

'if a new game
IF gamestate% = 3 AND NOT (currmenu% = 1 AND act% = 3) THEN
score& = 0
'Clear all plebs
created% = 0
FOR I% = 1 TO maxplebs%
plebs(I%).state% = 0
NEXT I%
'Display message.
mes$ = "Press any key for The Pleb Challenge!"
c% = 32
DO
c% = c% + 1
IF c% > 63 THEN c% = 32
SOUND c% * 10, .1
WriteFont &HA000, 0, 160 - 4 * LEN(mes$), 20, mes$, c%, c%
ADWait (1)
LOOP UNTIL WaitInput(1, 0, 1)'INKEY$ <> ""
END IF
END IF
ADSprite VARSEG(plebgfx(0, mpt% + 1)), VARPTR(plebgfx(0, mpt% + 1)), mousex%, mousey%, VARSEG(buffer1%(0))
END IF

ADPcopy VARSEG(buffer1%(0)), &HA000
IF gamespeed% THEN ADWait gamespeed%
IF a$ = CHR$(27) THEN
IF gamestate% = 1 AND currmenu% <> 8 AND currmenu% <> 9 THEN curritem% = 1: currmenu% = 3
IF gamestate% = 4 OR (gamestate% = 5 AND timelimit% <> 0) THEN savet = timeleft
IF gamestate% <> 1 AND ending% = 0 THEN oldstate% = gamestate%: currmenu% = 1: gamestate% = 1: curritem% = 1
END IF
LOOP UNTIL quit% = 1

CircleFade 160, 100, 200
CLS : PALETTE

REDIM SHARED buffer1%(0)
REDIM SHARED buffer2%(0)

CLOSE
OPEN "plebs.hsc" FOR INPUT AS #1: IF LOF(1) = 0 THEN CLOSE #1: KILL "plebs.hsc" ELSE CLOSE #1

CLS
SYSTEM
END
                                            'Cut-off point
DATA 0,0,       "You really are bad"
DATA 1,20,      "Nice try, but take more  lessons"
DATA 21,30,     "Spend more time in the   practise zone"
DATA 31,50,     "Getting better"
DATA 51,60,     "Yeah not bad"
DATA 61,70,     "Certainly quite adequate!"
DATA 71,85,     "Superb. Very good"
DATA 86,94,     "You are unbelievably     good!"
DATA 95,99,     "Wow! That was excellent!"
DATA 100,100,   "You have the skill of a  master!"
DATA 101,101,"END"

handler:

SCREEN 0: WIDTH 80
COLOR 15: PRINT "An error has occured in PLEBS.EXE! "
COLOR 7: PRINT : PRINT "Please would you be so kind as to email us and tell"
PRINT "of the nasty error. Please tell us the error code and how"
PRINT "you got the error. Thanks."
PRINT "Oh and, sorry about the error."
COLOR 2: PRINT "Error code:"; ERR
COLOR 7
BEEP
SYSTEM

SUB AddScore (a%)
'You may be reading this and thinking hmmmm. why did he do this, it seems
'like a waste of time. Well you'd be correct to think this but I was going
'to do more stuff in this sub that made it better to use a sub but I decided
'against it. (who's going to get a score above 2,147,483,647 any way?!)

IF gamestate% > 2 THEN score& = score& + a%

END SUB

SUB CircleFade (x%, y%, maxrad%)
' fade down by 20 in maxrad%
rt% = maxrad% / 20
FOR t% = maxrad% TO 1 STEP -1
CIRCLE (x%, y%), t%, 0
CIRCLE (x% + 1, y%), t%, 0
IF t% MOD rt% = 0 THEN ADFadeTo 0, 0, 0, 2, 32
'ADWait (1)
NEXT t%
END SUB

FUNCTION CompareCodes% (d1%, d2%, d3%, d4%)
OPEN "AIMS.PLB" FOR INPUT AS #1

rw% = 0
DO
INPUT #1, l$

'FOR I% = 1 TO LEN(l$)      '' Alan: Silly! You left the decoder in!
'c$ = MID$(l$, I%, 1)
'MID$(l$, I%, 1) = CHR$(255 - ASC(c$))
'NEXT I%

IF UCASE$(MID$(l$, 1, 5)) = "WAVE:" THEN
w% = VAL(MID$(l$, 6))
END IF

IF UCASE$(MID$(l$, 1, 5)) = "CODE:" THEN
rd1% = VAL(MID$(l$, 6, 1))
rd2% = VAL(MID$(l$, 7, 1))
rd3% = VAL(MID$(l$, 8, 1))
rd4% = VAL(MID$(l$, 9, 1))

IF rd1% = d1% AND rd2% = d2% AND rd3% = d3% AND rd4% = d4% THEN rw% = w%
END IF
LOOP UNTIL EOF(1)
CLOSE #1

CompareCodes% = rw%
END FUNCTION

FUNCTION DoMenu% (py%, but%, a$)
STATIC nitems%, a%, lastitem%, lastmenu%

IF nitems% = 0 OR lastmenu% <> currmenu% THEN 'Count up items
FOR I% = 1 TO maxitems%
IF menu$(currmenu%, I%) <> "" THEN nitems% = nitems% + 1: lastitem% = I%
NEXT I%
lastmenu% = currmenu%
END IF

ret% = 0
FOR I% = 0 TO maxitems%
m$ = menu$(currmenu%, I%)

gt% = INSTR(m$, ">")
IF gt% <> 0 THEN m$ = MID$(m$, 1, gt% - 1)

arrows% = INSTR(m$, "/\")
IF arrows% <> 0 THEN m$ = MID$(m$, 1, arrows% - 1)

col1% = menucol%(currmenu%, I%, 1)
col2% = menucol%(currmenu%, I%, 2)
ty% = (I% * 10) + (100 - (lastitem% + 1) * 5)
d% = LEN(m$) * 4
tx% = 160 - d%

IF py% >= ty% AND py% < ty% + 10 AND I% <> 0 AND (m$ <> "" OR (m$ = "" AND arrows% <> 0)) THEN curritem% = I%

IF curritem% = I% THEN
        IF but% = 1 AND mouseok% THEN
                IF gt% <> 0 THEN 'Find which menu.
                currmenu% = VAL(MID$(menu$(currmenu%, curritem%), gt% + 5))
                curritem% = 1: nitems% = 0
                mouset = TIMER: mouseok% = 0
                ELSE
                ret% = curritem%
                END IF
        END IF

IF arrows% <> 0 AND (a$ = CHR$(0) + CHR$(77) OR (but% = 2 AND mouseok%)) THEN  'Right
wstr$ = menu$(currmenu%, curritem%)
colon% = INSTR(wstr$, ":")
minus% = INSTR(wstr$, "-") 'ITEM4=Custom /\5-15:10
cv% = VAL(MID$(wstr$, colon% + 1))
ub% = VAL(MID$(wstr$, minus% + 1, colon% - minus% - 1))
cv% = cv% + 1
IF cv% > ub% THEN cv% = ub%
SetMenuValue currmenu%, curritem%, cv%
mouset = TIMER: mouseok% = 0
END IF

IF arrows% <> 0 AND (a$ = CHR$(0) + CHR$(75) OR (but% = 1 AND mouseok%)) THEN  'Left
wstr$ = menu$(currmenu%, curritem%)
colon% = INSTR(wstr$, ":")
minus% = INSTR(wstr$, "-")
cv% = VAL(MID$(wstr$, colon% + 1))
lb% = VAL(MID$(wstr$, arrows% + 2, minus% - arrows% - 2))
cv% = cv% - 1
IF cv% < lb% THEN cv% = lb%
SetMenuValue currmenu%, curritem%, cv%
mouset = TIMER: mouseok% = 0
END IF
END IF

IF arrows% <> 0 THEN
colon% = INSTR(menu$(currmenu%, I%), ":")
cv% = VAL(MID$(menu$(currmenu%, I%), colon% + 1))
m$ = m$ + " <" + STR$(cv%) + " >"
d% = LEN(m$) * 4
tx% = 160 - d%
END IF


WriteFont VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), tx%, ty%, m$, col1%, col2%

IF curritem% = I% THEN
a% = a% + 4
IF a% > 360 THEN a% = a% - 360
t% = 8

IF a% >= 0 AND a% < 360 THEN
ADRotate VARSEG(plebgfx(0, t%)), VARPTR(plebgfx(0, t%)), tx% - 10, ty% + 5, a%, VARSEG(buffer1%(0))
END IF

b% = 360 - a%

IF b% >= 0 AND b% < 360 THEN
 ADRotate VARSEG(plebgfx(0, t%)), VARPTR(plebgfx(0, t%)), 160 + d% + 10, ty% + 5, b%, VARSEG(buffer1%(0))
END IF

END IF

NEXT I%
IF mouseok% = 0 THEN IF TIMER - mouset > .2 THEN mouseok% = 1
DoMenu = ret%
END FUNCTION

SUB DrawPlebs
FOR I% = 1 TO maxplebs%
IF plebs(I%).state% <> 0 THEN
t% = plebs(I%).plebtype%
x% = plebs(I%).x
y% = plebs(I%).y
a% = plebs(I%).angle%

IF a% >= 0 AND a% < 360 THEN
ADRotate VARSEG(plebgfx(0, t%)), VARPTR(plebgfx(0, t%)), x%, y%, a%, VARSEG(buffer1%(0))
END IF

END IF
NEXT I%
END SUB

SUB FadeFromToPalette (from$, to$, times%, thres%)
STATIC lfrom$, lto$

IF lfrom$ <> from$ OR to$ <> lto$ THEN
ADLoadPal to$ + ".RGB", array2%()
'Load data into arrays
'p2% = FREEFILE
'OPEN to$ + ".RGB" FOR INPUT AS #p2%
'FOR I% = 0 TO 255
'INPUT #p2%, red2%
'INPUT #p2%, green2%
'INPUT #p2%, blue2%
'array2%(I%, 1) = red2%
'array2%(I%, 2) = green2%
'array2%(I%, 3) = blue2%
'NEXT I%
'CLOSE #p2%
END IF

FOR I% = 0 TO 255
OUT &H3C6, &HFF
OUT &H3C8, I%

red2% = array2%(I%, 1)
green2% = array2%(I%, 2)
blue2% = array2%(I%, 3)

r% = (red2%) * times% / thres%
g% = (green2%) * times% / thres%
b% = (blue2%) * times% / thres%

OUT &H3C9, r%
OUT &H3C9, g%
OUT &H3C9, b%
NEXT I%

lto$ = to$
lfrom$ = from$

END SUB

FUNCTION FramesCounter%
STATIC count%, fps%, ct, init%

IF init% = 0 THEN
ct = TIMER
init% = 1
END IF

count% = count% + 1 ' Frame per second things.
IF TIMER - ct >= 1 THEN ct = TIMER: fps% = count%: count% = 0
FramesCounter% = fps%
END FUNCTION

FUNCTION GetInput$ (tx%, ty%, maxc%)
DIM behind%(0 TO 600)
GET (tx%, ty%)-(tx% + (maxc% * 10), ty% + 8), behind%(0)

dn% = 0: ln% = 0: b$ = ""
DO
a$ = INKEY$

IF a$ <> "" THEN

IF ASC(a$) >= 32 AND ASC(a$) <= 122 THEN
IF ln% < maxc% THEN
b$ = b$ + a$
ln% = ln% + 1
END IF
END IF
                                                        
IF a$ = CHR$(8) THEN
PUT (tx%, ty%), behind%(0), PSET
IF ln% > 0 THEN b$ = MID$(b$, 1, ln% - 1): ln% = ln% - 1
END IF
END IF

WriteFont &HA000, 0, tx%, ty%, b$, 240, 254

IF a$ = CHR$(13) THEN dn% = 1
dummy% = FramesCounter
LOOP UNTIL dn% = 1
GetInput$ = b$
END FUNCTION

FUNCTION GetMenuValue% (men%, item%)
colon% = INSTR(menu$(men%, item%), ":")
cv% = VAL(MID$(menu$(men%, item%), colon% + 1))
GetMenuValue% = cv%
END FUNCTION

SUB Highscores
DIM nme(1 TO 9) AS STRING * 12, sc&(1 TO 9)
'Generates scores...

OPEN "plebs.hsc" FOR BINARY AS #1
FOR I% = 1 TO 9
GET #1, , nme$(I%)
GET #1, , sc&(I%)
menu$(11, I%) = nme$(I%) + STR$(sc&(I%))
NEXT I%
CLOSE #1

IF sc&(9) < score& THEN
WriteFont &HA000, 0, 1, 1, "You have made it into the high scores!", 240, 254
WriteFont &HA000, 0, 1, 30, "Enter your name:", 16, 31
a$ = GetInput$(136, 30, 12)

notset% = 0
FOR I% = 1 TO 9
IF score& > sc&(I%) AND notset% = 0 THEN notset% = I%
NEXT I%

FOR I% = 8 TO notset% STEP -1
sc&(I% + 1) = sc&(I%)
nme$(I% + 1) = nme$(I%)
NEXT I%
a$ = a$ + SPACE$(12 - LEN(a$))
sc&(notset%) = score&: nme$(notset%) = a$

'Save
OPEN "plebs.hsc" FOR BINARY AS #1
FOR I% = 1 TO 9
n$ = nme$(I%)
PUT #1, , n$
sc& = sc&(I%)
PUT #1, , sc&
menu$(11, I%) = nme$(I%) + STR$(sc&(I%))
NEXT I%
CLOSE #1

END IF
END SUB

SUB Loadaims (w%)
set% = 0
OPEN "aims.plb" FOR INPUT AS #1
DO
INPUT #1, l$

'De-crypt text
'FOR I% = 1 TO LEN(l$)
'c$ = MID$(l$, I%, 1)
'MID$(l$, I%, 1) = CHR$(255 - ASC(c$))
'NEXT I%

us% = 0' Not understood - yet
IF UCASE$(MID$(l$, 1, 5)) = "WAVE:" THEN
us% = 1
currw% = VAL(MID$(l$, 6))
'PRINT currw%: SLEEP
IF currw% = w% THEN set% = 1: timelimit% = 0: peopleaim% = 0: maxpeople% = 0: gravity = 10 / 100: jumprate = 3.5'by default
END IF

IF UCASE$(MID$(l$, 1, 5)) = "HOME:" THEN
us% = 1
h% = VAL(MID$(l$, 6))
IF currw% = w% THEN peopleaim% = h%
END IF

IF UCASE$(MID$(l$, 1, 8)) = "GRAVITY:" THEN
us% = 1
h% = VAL(MID$(l$, 9))
IF currw% = w% THEN gravity = h% / 100
END IF

IF UCASE$(MID$(l$, 1, 9)) = "JUMPRATE:" THEN
us% = 1
h% = VAL(MID$(l$, 10))
IF currw% = w% THEN
        IF h% <> 0 THEN jumprate = (15 - h%) / 2 ELSE jumprate = 0
END IF
END IF

IF UCASE$(MID$(l$, 1, 11)) = "TIME LIMIT:" THEN
us% = 1
h% = VAL(MID$(l$, 12))
IF currw% = w% THEN timelimit% = h%
END IF

IF UCASE$(MID$(l$, 1, 5)) = "CODE:" THEN
us% = 1
code$ = MID$(l$, 6)
IF currw% = w% THEN menu$(9, 5) = "CODE=" + code$
END IF


IF UCASE$(MID$(l$, 1, 10)) = "PLEBLIMIT:" THEN
us% = 1
pl% = VAL(MID$(l$, 11))
IF currw% = w% THEN maxpeople% = pl%
END IF

IF UCASE$(MID$(l$, 1, 5)) = "BACK:" THEN
us% = 1
IF currw% = w% THEN
b% = VAL(MID$(l$, 6))
LoadBack (b%)
END IF
END IF

IF UCASE$(MID$(l$, 1, 5)) = "TEXT:" THEN
us% = 1
l% = VAL(MID$(l$, 6))
IF currw% = w% THEN
currmenu% = 9: curritem% = 1
FOR I% = 1 TO 4
menu$(currmenu%, I%) = ""
NEXT I%
menu$(currmenu%, 0) = "Next wave..."
menu$(currmenu%, 6) = "[WAVE" + STR$(w%) + "]"
END IF

FOR I% = 1 TO l%
INPUT #1, m$

'De-crypt text : removed
'FOR k% = 1 TO LEN(m$)
'c$ = MID$(m$, k%, 1)
'MID$(m$, k%, 1) = CHR$(255 - ASC(c$))
'NEXT k%

IF currw% = w% THEN menu$(currmenu%, I%) = m$
NEXT I%

END IF

'IF LEFT$(l$, 1) <> "'" AND us% = 0 AND l$ <> "" THEN BEEP: LOCATE 1, 1: PRINT "Script error:"; l$: SLEEP

LOOP UNTIL EOF(1)
CLOSE #1
IF set% = 0 THEN maxpeople% = -1
END SUB

SUB LoadBack (back%)

IF back% = 1 THEN
LoadGfx "graphics.gfx", "plebback.pcx"
END IF

IF back% = 2 THEN
LoadGfx "graphics.gfx", "plebbck2.pcx"
END IF

IF back% = 3 THEN
LoadGfx "graphics.gfx", "plebbck3.pcx"
END IF

ADPcopy &HA000, VARSEG(buffer2%(0))
END SUB

SUB LoadGfx (merge$, file$)

m% = FREEFILE

OPEN merge$ FOR BINARY AS #m%
GET #m%, , I%

DIM headerinfo(1 TO I%) AS header

FOR t% = 1 TO I%
    GET #m%, , headerinfo(t%)
NEXT t%

hpos& = LOC(m%)
CLOSE #m%

ok% = 0

FOR t% = 1 TO I%
s1$ = RTRIM$(LTRIM$(UCASE$(headerinfo(t%).Filename$)))
s2$ = UCASE$(file$)
IF s1$ = s2$ THEN ok% = t%
NEXT t%

IF ok% = 0 THEN END

fp& = hpos&
FOR t% = 1 TO ok% - 1
fp& = fp& + headerinfo(t%).length
NEXT t%


OPEN merge$ FOR BINARY AS #m%

SEEK #m%, fp& + 1

GET #m%, , pcxh

y% = 0: x% = 0
DEF SEG = &HA000
ptr& = 0

DO

 GET #m%, , dat
 value% = ASC(dat)

IF value% > 192 THEN
   lps% = ASC(dat) - 192
   GET #m%, , dat
   value% = ASC(dat)
   WHILE lps% > 0
       POKE (ptr&), value%
       lps% = lps% - 1
       ptr& = ptr& + 1
   WEND

  ELSE
     POKE (ptr&), value%
     ptr& = ptr& + 1
  END IF

LOOP UNTIL ptr& = 64000

CLOSE #m%

END SUB

SUB LoadScores
DIM nme(1 TO 9) AS STRING * 12, sc&(1 TO 9)

OPEN "plebs.hsc" FOR BINARY AS #1
FOR I% = 1 TO 9
GET #1, , nme$(I%)
GET #1, , sc&(I%)
menu$(11, I%) = nme$(I%) + STR$(sc&(I%))
NEXT I%
CLOSE #1

END SUB

SUB MoveNDrawDis
STATIC lifegoto%, lifecount%, lifetimer%
'Also do floating people!
FOR j% = 1 TO maxfloats%
IF floatings%(j%, 3) <> 0 THEN
floatings%(j%, 4) = floatings%(j%, 4) + 3
IF floatings%(j%, 4) >= 360 THEN floatings%(j%, 4) = floatings%(j%, 4) - 360

py% = floatings%(j%, 2) + 5 * GetSin%(floatings%(j%, 4)) / 128
t% = floatings%(j%, 3)
ADSprite VARSEG(plebgfx(0, t%)), VARPTR(plebgfx(0, t%)), floatings%(j%, 1), py%, VARSEG(buffer1%(0))

'floatings%(j%, 1) = 162
FOR l% = floatings%(j%, 2) + 8 TO 190

'VSXLine VARSEG(buffer1%(0)), VARPTR(buffer1%(0)), 0, 319, l%, 32

bufoff& = (l% * 160&) + (floatings%(j%, 1) / 2)
ADCopydword VARSEG(buffer2%(0)), VARPTR(buffer2%(bufoff&)), VARSEG(buffer1%(0)), VARPTR(buffer1%(bufoff&)), 16
NEXT l%
END IF
NEXT j%

'Life boat logic:
IF lifeaction% = 0 THEN
'Not doing anything?
s% = 0: dist% = 9999
FOR k% = 1 TO maxfloats%
d% = floatings%(k%, 1) - distractions(maxdistractions%).x%
IF d% < 0 THEN d% = -d%
IF floatings%(k%, 3) <> 0 AND d% < dist% THEN s% = k%: dist% = d%
NEXT k%

IF s% = 0 THEN 'No one to pick up.
IF distractions(maxdistractions%).x% <> -40 THEN lifeaction% = 1:  distractions(maxdistractions%).xv% = -1
ELSE
lifegoto% = s%
lifeaction% = 1 'Move to
END IF
END IF


IF lifeaction% = 1 THEN 'going somewhere?
IF lifegoto% <> 0 THEN ' Got there?
ch% = 0
IF floatings%(lifegoto%, 1) < distractions(maxdistractions%).x% + 14 - 2 THEN distractions(maxdistractions%).xv% = -2: ch% = 1
IF floatings%(lifegoto%, 1) > distractions(maxdistractions%).x% + 14 + 2 THEN distractions(maxdistractions%).xv% = 2: ch% = 1
IF ch% = 0 THEN distractions(maxdistractions%).xv% = 0

IF floatings%(lifegoto%, 1) >= distractions(maxdistractions%).x% + 8 AND floatings%(lifegoto%, 1) <= distractions(maxdistractions%).x% + 18 THEN
lifeaction% = 2 ' Waiting
lifecount% = 0
distractions(maxdistractions%).xv% = 0
END IF
ELSE
IF distractions(maxdistractions%).x% < -40 THEN
lifeaction% = 0: distractions(maxdistractions%).xv% = 0
distractions(maxdistractions%).x% = -40
END IF

FOR k% = 1 TO maxfloats%
IF floatings%(k%, 3) <> 0 THEN lifeaction% = 0
NEXT k%
END IF
END IF

IF lifeaction% = 2 THEN ' make lifeboat wait
lifecount% = lifecount% + 1
IF lifecount% >= fps% THEN
pn% = pn% + 1
IF pn% <= maxpass% THEN onboard%(pn%) = floatings%(lifegoto%, 3)

floatings%(lifegoto%, 3) = 0
lifeaction% = 3
IF pn% >= maxpass% THEN lifeaction% = 3
lifegoto% = 0
END IF
END IF

IF lifeaction% = 3 THEN 'race off to the right!
distractions(maxdistractions%).xv% = 1
IF distractions(maxdistractions%).x% > 360 THEN
lifeaction% = 0
distractions(maxdistractions%).xv% = 0
FOR I% = 1 TO maxpass%
onboard%(I%) = 0
NEXT I%
pn% = 0
END IF

'Check water for bodies.(only if boat is not full)
IF pn% < maxpass% THEN
FOR k% = 1 TO maxfloats%
IF floatings%(k%, 3) <> 0 THEN lifeaction% = 0
NEXT k%
END IF
END IF

FOR I% = 1 TO pn%
t% = onboard%(I%)
px% = distractions(maxdistractions%).x% - 3 + (I% - 1) * 6
py% = distractions(maxdistractions%).y% - 13
ADSprite VARSEG(plebgfx(0, t%)), VARPTR(plebgfx(0, t%)), px%, py%, VARSEG(buffer1%(0))
NEXT I%

FOR I% = 1 TO maxdistractions%
IF distractions(I%).frame% <> 0 THEN
distractions(I%).x% = distractions(I%).xv% + distractions(I%).x%
distractions(I%).y% = distractions(I%).yv% + distractions(I%).y%
F% = distractions(I%).frame%

IF F% = 1 AND distractions(I%).x% < -40 THEN distractions(I%).frame% = 0
                                '248
IF F% = 2 AND distractions(I%).x% > 248 THEN distractions(I%).frame% = 0
IF F% = 3 AND distractions(I%).x% < -40 THEN distractions(I%).frame% = 0
IF F% = 4 AND distractions(I%).x% > 360 THEN distractions(I%).frame% = 0
IF F% = 5 AND distractions(I%).x% < -40 AND distractions(I%).xv% < 0 THEN distractions(I%).frame% = 0
IF F% = 5 AND distractions(I%).x% > 360 AND distractions(I%).xv% > 0 THEN distractions(I%).frame% = 0

IF F% = 5 THEN distractions(I%).y% = 5 * SIN(distractions(I%).x% / 160 * 2 * 3.14) + 10
IF F% = 6 THEN
lifetimer% = lifetimer% + 4
IF lifetimer% > 360 THEN lifetimer% = lifetimer% - 360
distractions(I%).y% = GetSin%(lifetimer%) / 32 + 170
END IF
IF F% = 7 AND distractions(I%).x% < -40 THEN distractions(I%).frame% = 0
IF F% = 8 AND distractions(I%).x% > 360 THEN distractions(I%).frame% = 0

ADSprite VARSEG(distract(0, F%)), VARPTR(distract(0, F%)), distractions(I%).x%, distractions(I%).y%, VARSEG(buffer1%(0))
END IF
NEXT I%
END SUB

SUB MoveParticles

FOR I% = 1 TO maxparts%
IF parts(I%).colour% <> 0 THEN
c% = parts(I%).colour%

parts(I%).xv = parts(I%).xv + parts(I%).xa
parts(I%).yv = parts(I%).yv + parts(I%).ya

parts(I%).x = parts(I%).x + parts(I%).xv
parts(I%).y = parts(I%).y + parts(I%).yv

IF parts(I%).x < 0 THEN parts(I%).x = 0: parts(I%).colour% = 0
IF parts(I%).x > 319 THEN parts(I%).x = 319: parts(I%).colour% = 0

IF parts(I%).timelimit% <> 0 THEN
parts(I%).tmer% = parts(I%).tmer% + 1
IF parts(I%).tmer% >= parts(I%).timelimit% THEN parts(I%).colour% = 0
END IF
IF INT(parts(I%).y) > 199 THEN parts(I%).colour% = 0
IF parts(I%).colour% <> 0 AND INT(parts(I%).y) >= 0 THEN ADPset VARSEG(buffer1%(0)), INT(parts(I%).x), INT(parts(I%).y), c%

END IF
NEXT I%

END SUB

SUB MovePlebs
a% = 0
FOR I% = 1 TO maxplebs%
IF plebs(I%).state% <> 0 THEN
a% = 1
plebs(I%).x = plebs(I%).x + plebs(I%).xv
plebs(I%).y = plebs(I%).y + plebs(I%).yv

'plebs(i%).xv = plebs(i%).xv + wind
plebs(I%).yv = plebs(I%).yv + gravity

plebs(I%).angle% = plebs(I%).angle% + plebs(I%).rotspd%
IF plebs(I%).angle% > 360 THEN plebs(I%).angle% = plebs(I%).angle% - 360
IF plebs(I%).angle% < 0 THEN plebs(I%).angle% = plebs(I%).angle% + 360

IF plebs(I%).x >= distractions(maxdistractions%).x% - 8 AND plebs(I%).x <= distractions(maxdistractions%).x% + 28 AND plebs(I%).y <= distractions(maxdistractions%).y% AND plebs(I%).y >= distractions(maxdistractions%).y% - plebs(I%).yv THEN
s% = 0
FOR k% = 1 TO maxpass%
IF s% = 0 AND onboard%(k%) = 0 THEN s% = k%
NEXT k%
IF s% <> 0 THEN
plebs(I%).state% = 0
onboard%(s%) = plebs(I%).plebtype%
pn% = s%
lifeaction% = 3
END IF

END IF

IF gamestate% = 1 AND plebs(I%).y - plebs(I%).yv > 60 THEN nextx% = plebs(I%).x - 15

'IF plebs(I%).x >= trolx% - 8 AND plebs(I%).x <= trolx% + 36 AND plebs(I%).y <= permy% AND plebs(I%).y >= permy% - plebs(I%).yv THEN
IF plebs(I%).x >= trolx% - 8 AND plebs(I%).x <= trolx% + 36 AND plebs(I%).y <= troly% AND plebs(I%).y >= troly% - 2 * plebs(I%).yv THEN
AddScore (50)
plebs(I%).yv = -plebs(I%).yv
ts% = trolspd%
dir% = 2
IF ts% < 0 THEN ts% = -ts%: dir% = 1
npd% = plebs(I%).rotspd%
IF ts% >= 3 THEN npd% = 5
IF ts% >= 6 THEN npd% = 10
IF ts% >= 9 THEN npd% = 15
IF ts% >= 12 THEN npd% = 20
IF ts% >= 15 THEN npd% = 25
IF dir% = 2 THEN plebs(I%).rotspd% = npd%
IF dir% = 1 THEN plebs(I%).rotspd% = -npd%
SOUND 200, .5
SOUND 400, .5
trolyv% = -3
END IF

IF plebs(I%).y >= 180 THEN

plebs(I%).state% = 0
SOUND 50, 1
colbase% = INT(RND * 32) * 8
FOR k% = 1 TO 50
StartParticle plebs(I%).x, plebs(I%).y, (4 * RND) - 2, -((3 * RND) + 1), wind, .01, colbase% + 15 * RND, 0
NEXT k%
s% = 0
FOR j% = 1 TO maxfloats%
IF s% = 0 AND floatings%(j%, 3) = 0 THEN s% = j%
NEXT j%
IF s% = 0 THEN
'Air bubbles
'FOR k% = 1 TO 40
'StartParticle plebs(I%).x, plebs(I%).y, (2 * RND) - 1, -((3 * RND) + 1), 0, 0, 176 + 15 * RND, fps% / 2
'NEXT k%
ELSE
floatings%(s%, 1) = plebs(I%).x
floatings%(s%, 2) = 170'plebs(i%).y
floatings%(s%, 3) = plebs(I%).plebtype%
floatings%(s%, 4) = 0
END IF
END IF

IF plebs(I%).x <= 0 THEN
AddScore (250)
plebs(I%).state% = 0: SOUND 200, .2: SOUND 300, .2: SOUND 400, .2
saved% = saved% + 1
END IF
END IF
NEXT I%
IF gamestate% = 3 AND a% = 0 AND created% = maxpeople% AND ending% = 0 THEN ending% = 1
IF gamestate% = 5 AND a% = 0 AND ending% = 0 AND maxpeople% <> 0 AND created% = maxpeople% THEN ending% = 1'Succeeded!
IF gamestate% = 1 AND a% = 0 THEN nextx% = 270
END SUB

SUB NewPleb (x%, y%, typ%, xv, yv, rotspd%)
cp% = 0
FOR I% = 1 TO maxplebs%
IF cp% = 0 AND plebs(I%).state% = 0 THEN cp% = I%
NEXT I%
IF gamestate% = 5 AND maxpeople% <> 0 AND created% >= maxpeople% THEN cp% = 0
IF cp% <> 0 THEN
IF (gamestate% = 3 AND created% < maxpeople%) OR gamestate% <> 3 THEN
IF gamestate% = 3 OR (gamestate% = 5 AND maxpeople% <> 0) THEN created% = created% + 1
plebs(cp%).x = x%
plebs(cp%).y = y%
plebs(cp%).plebtype% = typ%
plebs(cp%).xv = xv
plebs(cp%).yv = yv
plebs(cp%).rotspd% = rotspd%
plebs(cp%).angle% = 0
plebs(cp%).state% = 1
END IF
END IF
END SUB

SUB OpenMenu (file$)
currmenu% = 1: curritem% = 1
FOR m% = 1 TO maxmenus%
FOR I% = 1 TO maxitems%
menu$(m%, I%) = ""
NEXT I%, m%
OPEN file$ FOR INPUT AS #1
col1% = 15: col2% = 32
DO
INPUT #1, m$

'De-crypt text : De-crpytion taken out to allow user to make own levels.
'FOR I% = 1 TO LEN(m$)
'c$ = MID$(m$, I%, 1)
'MID$(m$, I%, 1) = CHR$(255 - ASC(c$))
'NEXT I%

IF UCASE$(LEFT$(m$, 9)) = "STARTMENU" THEN
currmenu% = VAL(MID$(m$, 10))
END IF

IF UCASE$(LEFT$(m$, 6)) = "COLOR " THEN
colon% = INSTR(m$, ":")' COLOR 15:32
col1% = VAL(MID$(m$, 7, colon% - 1))
col2% = VAL(MID$(m$, colon% + 1))
END IF

IF UCASE$(LEFT$(m$, 9)) = "STARTITEM" THEN
curritem% = VAL(MID$(m$, 10))
END IF

IF UCASE$(LEFT$(m$, 4)) = "MENU" THEN
cm% = VAL(MID$(m$, 5))
END IF

IF UCASE$(LEFT$(m$, 6)) = "TITLE=" THEN
menu$(cm%, 0) = MID$(m$, 7)
menucol%(cm%, 0, 1) = col1%
menucol%(cm%, 0, 2) = col2%
END IF

IF UCASE$(LEFT$(m$, 4)) = "ITEM" THEN
equ% = INSTR(m$, "=")
im% = VAL(MID$(m$, 5, equ% - 5))'ITEM3=Quit>MENU3
mn$ = MID$(m$, equ% + 1) 'ITEM4=Number of plebs /\5:15

arrows% = INSTR(mn$, "/\")
IF arrows% <> 0 THEN
wstr$ = mn$
colon% = INSTR(wstr$, ":")
minus% = INSTR(wstr$, "-") 'ITEM4=Custom /\5-15:10
cv% = VAL(MID$(wstr$, colon% + 1))
ub% = VAL(MID$(wstr$, minus% + 1, colon% - minus% - 1))
mn$ = mn$ + SPACE$((LEN(STR$(ub%)) - 1) - (LEN(STR$(cv%)) - 1))
END IF

menu$(cm%, im%) = mn$

menucol%(cm%, im%, 1) = col1%
menucol%(cm%, im%, 2) = col2%
END IF
LOOP UNTIL EOF(1)
CLOSE #1
END SUB

SUB SetMenuValue (men%, item%, vl%)
colon% = INSTR(menu$(men%, item%), ":")
MID$(menu$(men%, item%), colon%) = STR$(vl%) + SPACE$(5)
MID$(menu$(men%, item%), colon%) = ":"
END SUB

SUB StartDistraction (newdis%)
s% = 0
FOR I% = 1 TO maxdistractions% - 1'  Last slot for life boat
IF distractions(I%).frame% = 0 AND s% = 0 THEN s% = I%
NEXT I%

IF s% <> 0 THEN
IF newdis% = 1 THEN
distractions(s%).y% = 66 + 14 * RND
dir% = 1 + INT(RND * 2)
IF dir% = 1 THEN distractions(s%).x% = 248: distractions(s%).xv% = -4: distractions(s%).frame% = 1
IF dir% = 2 THEN distractions(s%).x% = -37: distractions(s%).xv% = 4: distractions(s%).frame% = 2
END IF

IF newdis% = 2 THEN
distractions(s%).y% = 10
dir% = 1 + INT(RND * 2)

distractions(s%).frame% = 3 + dir% - 1
IF dir% = 1 THEN distractions(s%).x% = 320 + 40: distractions(s%).xv% = -4
IF dir% = 2 THEN distractions(s%).x% = -40: distractions(s%).xv% = 4
END IF

IF newdis% = 3 THEN
distractions(s%).y% = 10
dir% = 1 + INT(RND * 2)
distractions(s%).frame% = 5
IF dir% = 1 THEN distractions(s%).x% = 320 + 40: distractions(s%).xv% = -4
IF dir% = 2 THEN distractions(s%).x% = -40: distractions(s%).xv% = 4
END IF

IF newdis% = 4 THEN
distractions(s%).y% = 170 + 14 * RND
dir% = 1 + INT(RND * 2)
IF dir% = 1 THEN distractions(s%).x% = 330: distractions(s%).xv% = -1: distractions(s%).frame% = 7
IF dir% = 2 THEN distractions(s%).x% = -37: distractions(s%).xv% = 1: distractions(s%).frame% = 8
END IF

END IF
END SUB

SUB StartParticle (x, y, xv, yv, xa, ya, colour%, timelimit%)
STATIC init%
IF init% = 0 THEN
FOR I% = 1 TO maxparts%
parts(I%).colour% = 0
NEXT I%
init% = 1
END IF
s% = 0
FOR I% = 1 TO maxparts%
IF parts(I%).colour% = 0 AND s% = 0 THEN
s% = I%
parts(I%).x = x
parts(I%).y = y
parts(I%).xv = xv
parts(I%).yv = yv
parts(I%).xa = xa
parts(I%).ya = ya
parts(I%).colour% = colour%
parts(I%).timelimit% = timelimit%
parts(I%).tmer% = 0
END IF
NEXT I%

IF s% = 0 THEN
'pick slot at random.
I% = 1 + INT(RND * maxparts%)
parts(I%).x = x
parts(I%).y = y
parts(I%).xv = xv
parts(I%).yv = yv
parts(I%).xa = xa
parts(I%).ya = ya
parts(I%).colour% = colour%
parts(I%).timelimit% = timelimit%
parts(I%).tmer% = 0
END IF

END SUB

FUNCTION WaitInput (ky%, mse%, ret%)
d% = 0
IF ret% = 0 THEN
DO
IF mse% THEN
AdMouseInfo mx%, my%, button%
IF button% THEN d% = 1
END IF
IF INKEY$ <> "" AND ky% THEN d% = 1
dm% = FramesCounter
LOOP UNTIL d% = 1
ELSE
'RETURN A VALUE
rt% = 0
IF INKEY$ <> "" AND ky% THEN rt% = 1
IF mse% THEN
AdMouseInfo mx%, my%, button%
IF button% THEN rt% = 1
END IF
WaitInput = rt%
END IF

END FUNCTION

SUB WriteFont (toseg%, dummy1%, x%, y%, a$, col%, dummy2%)

FOR t% = 1 TO LEN(a$)
IF ASC(MID$(a$, t%, 1)) = 0 THEN MID$(a$, t%, 1) = CHR$(32)
NEXT t%


IF LEN(a$) = 0 THEN EXIT SUB

ADFont toseg%, CGASEG, CGAOFF, VARSEG(a$), SADD(a$), LEN(a$), x%, y%, col%

END SUB

