'---- -  
'                   ** THE POWER **
'       Amiga to PC conversion by Davey W Taylor
'
'                      Thanks to
'            TOMI LMS for the sound fix!     *****
'        CHAD BECK for some of the sprite code ***
'
'                    Hello's go to
'           PASCO, POWERLINE n' WILLIAM YU
'---     
' ** If you have any comments / suggestions / questions, my email is: **
' ** audio.squad@mailbox.swipnet.se                                   **
'---- -  
' ATTENTION! ATTENTION! ATTENTION! ATTENTION! ATTENTION!
'
'  QBASIC USERS: The Power is no longer compatible with
' QBasic!!! It can be run on QuickBasic 4.5 which is now
' totally free. Download it now!! And once again, QBasic
'   is NOT the same thing as QuickBasic... For example
'      you can compile your programs in QuickBasic!
'
'   QUICKBASIC USERS: If you have problems running the
'   game, try compiling it. It uses massive amounts of
'     string space for sound which can result in an
'    "Out of string space" error... By compiling, you
'          should get around this problem...
'---     

DECLARE FUNCTION ResetDSP% ()                   'Declare functions
DECLARE FUNCTION PlayTL% ()
DECLARE FUNCTION PMove% (bx%, by%, d%)
DECLARE FUNCTION SMoved% ()
DECLARE SUB GetBlaster (DMA%, BasePort%, IRQ%)  'Declare subs
DECLARE SUB WriteDSP (byte%)
DECLARE SUB LoadSounds (n%)
DECLARE SUB LoadSoundSet (set$)
DECLARE SUB DMAPlay (sndnum%)
DECLARE SUB PCS (sndnum%)
DECLARE SUB DeInitDSP ()
DECLARE SUB Menu ()
DECLARE SUB Wipe ()
DECLARE SUB New ()
DECLARE SUB ReadTL (l%)
DECLARE SUB DrawTL ()
DECLARE SUB Instruct ()
DECLARE SUB Save ()
DECLARE SUB Load ()
DECLARE SUB About ()
DECLARE SUB Check ()
DECLARE SUB Move (t%, s%, xp%, yp%, m%, l%)

'$DYNAMIC

ON ERROR GOTO shit
WIDTH 80, 25
CLS
COLOR 0, 3
PRINT STRING$(80, 32);
LOCATE , 29
PRINT "The Power Startup v1.0"
COLOR 7, 0
PRINT
RANDOMIZE TIMER                                 'Use random numbers based on TIMER

PRINT "Allocating memory..."
DIM SHARED sprt%(660)                           'Allocate memory for images
DIM SHARED mask%(660)                           'level and global variables
DIM SHARED under%(3000)
DIM SHARED heart%(3000)
DIM SHARED store%(60)
DIM SHARED love%(420)
DIM SHARED level(1 TO 32, 1 TO 20) AS STRING * 3
DIM SHARED xdim%, ydim%, beginx%, beginy%, nowxp%, nowyp%
DIM SHARED score%, maxscore%, clevel%, audio%
DIM SHARED Channel%, BasePort%, IRQ%
DIM SHARED PgPort%, AddPort%, LenPort%
DIM SHARED noWave%

PRINT "Checking for SoundBlaster..."
GetBlaster Channel%, BasePort%, IRQ%            'Check for an SB compat. card

IF ENVIRON$("BLASTER") = "" THEN noWave% = -1
IF Channel% > 7 THEN
 noWave% = -1
 PRINT "Only DMA channels 0-7 are supported!"
 PRINT "Press any key..."
 WHILE INKEY$ = "": WEND
END IF

IF INSTR(COMMAND$, "-NOWAVE") > 0 THEN noWave% = -1

IF noWave% = 0 THEN
 PRINT "Selecting SoundBlaster ports..."
 SELECT CASE Channel%                           'Choose channels based on DMA
  CASE 0
   PgPort% = &H87
   AddPort% = &H0
   LenPort% = &H1
  CASE 1
   PgPort% = &H83
   AddPort% = &H2
   LenPort% = &H3
  CASE 2
   PgPort% = &H81
   AddPort% = &H4
   LenPort% = &H5
  CASE 3
   PgPort% = &H82
   AddPort% = &H6
   LenPort% = &H7
  CASE 4
   PgPort% = &H8F
   AddPort% = &HC0
   LenPort% = &HC2
  CASE 5
   PgPort% = &H8B
   AddPort% = &HC4
   LenPort% = &HC6
  CASE 6
   PgPort% = &H89
   AddPort% = &HC8
   LenPort% = &HCA
  CASE 7
   PgPort% = &H8A
   AddPort% = &HCC
   LenPort% = &HCE
 END SELECT
END IF

PRINT "Loading sprites..."
DEF SEG = VARSEG(sprt%(0))                      'Load sprites and masks
BLOAD "sprites.dat", VARPTR(sprt%(0))
DEF SEG = VARSEG(mask%(0))
BLOAD "sprtmask.dat", VARPTR(mask%(0))
DEF SEG = VARSEG(love%(0))
BLOAD "love.dat", VARPTR(love%(0))
DEF SEG

PRINT "Checking saved.dat..."
OPEN "saved.dat" FOR BINARY ACCESS READ WRITE AS #1
 IF LOF(1) = 0 THEN
  x$ = STRING$(220, 0)
  PUT #1, , x$
 END IF
CLOSE #1

PRINT "Entering mode 13h..."
'FOR n% = 1 TO 10
 'WAIT &H3DA, 8
 'WAIT &H3DA, 16
'NEXT n%

SCREEN 13
COLOR 255: PRINT "Mode 13h active..."

PRINT "Loading palette..."
pal$ = STRING$(768, 0)                          'read palette
OPEN "palette.dat" FOR BINARY ACCESS READ AS #1
GET #1, , pal$
CLOSE #1
WAIT &H3DA, 8
FOR n% = 0 TO 255
 OUT &H3C7, n%
 OUT &H3C8, n%
 OUT &H3C9, INT(ASC(MID$(pal$, (n% * 3) + 1, 1)) / 4)
 OUT &H3C9, INT(ASC(MID$(pal$, (n% * 3) + 2, 1)) / 4)
 OUT &H3C9, INT(ASC(MID$(pal$, (n% * 3) + 3, 1)) / 4)
NEXT n%

PRINT "Initializing audio..."
DIM SHARED SndLen(0) AS INTEGER
DIM SHARED SndDat(0) AS STRING

x% = ResetDSP%
IF x% = 0 THEN noWave% = -1

PRINT "All Done!"
'FOR n% = 1 TO 10
 'WAIT &H3DA, 8
 'WAIT &H3DA, 16
'NEXT n%

CLS
Menu                                            'Display the main menu

shit:                                           'In case of program error
WIDTH 80, 25
PRINT "Program error!"
END

REM $STATIC
SUB About
 CLS                                                   'Display border
 FOR n% = 0 TO 31
  PUT (10 * n%, 0), sprt%(0), OR
  PUT (10 * n%, 190), sprt%(0), OR
 NEXT n%
 FOR n% = 1 TO 18
  PUT (0, 10 * n%), sprt%(0), OR
 NEXT n%

 LOCATE 7, 1                                           'Display text
 LOCATE , 5: PRINT "          ** THE POWER **"
 LOCATE , 5: PRINT "     Amiga to PC conversion by"
 LOCATE , 5: PRINT "          Davey W Taylor"
 LOCATE , 5: PRINT
 LOCATE , 5: PRINT "            Thanks to"
 LOCATE , 5: PRINT "   TOMI LMS for the sound fix!!"
 LOCATE , 5: PRINT "  CHAD BECK for some of the sprite"
 LOCATE , 5: PRINT "              code"
 LOCATE , 5: PRINT
 LOCATE , 5: PRINT "          Hello's go to"
 LOCATE , 5: PRINT " PASCO, POWERLINE n' WILLIAM YU!"
 SELECT CASE INT(RND * 10) + 1
  CASE 10
   n$ = "BASIC IS THE ANSWER!"
  CASE 9
   n$ = "TRUST DAVEY!"
  CASE 8
   n$ = "BASIC ROCKS!"
  CASE 7
   n$ = "BASIC RULES!"
  CASE 6
   n$ = "THE GOOD OLD AMIGA..."
  CASE 5
   n$ = "* HEJ ALLA SVENSKAR *"
  CASE 4
   n$ = "GET QB45 TODAY!"
  CASE 3
   n$ = "SEND ME MONEY!"
  CASE 2
   n$ = "QBASIC SUX QB45 RULEZ!"
  CASE 1
   n$ = "PASCO PASCO POWERLINE!"
 END SELECT
 LOCATE 23, 40 - LEN(n$)
 PRINT n$

 WHILE INKEY$ = "": WEND                               'Wait for key
END SUB

SUB Check
 Wipe
 LoadSounds 1
                                                              
 OPEN "offset.dat" FOR INPUT AS #1
 lff& = LOF(1)
 CLOSE #1
 IF clevel% + 1 = lff& / 4 THEN                               'If last level completed
  LoadSounds 3
  FOR n% = 0 TO 31
   PUT (10 * n%, 0), sprt%(60 * (INT(RND * 3) + 1)), OR
   PUT (10 * n%, 190), sprt%(60 * (INT(RND * 3) + 1)), OR
  NEXT n%
  LOCATE 12, 2: PRINT "Congratulations!!! "
  LOCATE 13, 2: PRINT "You have completed all of the levels!"
  clevel% = 0
 ELSE                                                         'Otherwise...
  DMAPlay 2
  FOR n% = 0 TO 31
   PUT (10 * n%, 0), sprt%(0), OR
   PUT (10 * n%, 190), sprt%(0), OR
  NEXT n%
  LOCATE 12, 2: PRINT "Congratulations!!! "
  LOCATE 13, 2: PRINT "On to the next level..."
 END IF

 s! = TIMER                                                   'Display MAX & TINA
 PUT (140, 151), love%(0)                                     'and create the little rotating heart
 WHILE INKEY$ = "" OR ABS(TIMER - s!) < 2
  WAIT &H3DA, 8
  n! = n! + .1
  IF n! > 6.28 THEN n! = 0 + (n! - 6.28)
  LINE (155 + no!, 140)-(155 + no! + 10, 150), 0, BF
  p! = COS(n!) * 40
  PUT (155 + p!, 140), sprt%(60 * 4)
  no! = p!
  IF clevel% = 0 AND ABS(TIMER - w!) >= .8 THEN
   DO
    num% = INT(RND * 4) + 1
   LOOP UNTIL num% <> las%
   las% = num%
   DMAPlay num%
   w! = TIMER
  END IF
 WEND

 IF clevel% = 0 THEN
  WIDTH 80, 25
  PRINT "Thank you for playing The Power by Davey W Taylor!!"
  END
 END IF
END SUB

SUB DeInitDSP
 WriteDSP &HD3    'Speaker OFF
 OUT &H20, &H20   'Reset Normal Interrupt Service
END SUB

SUB DMAPlay (sndnum%)
 IF audio% THEN EXIT SUB

 IF noWave% THEN                                  'If no SB, play PC Speaker
  PCS sndnum%
  EXIT SUB
 END IF
 Length& = SndLen(sndnum%) - 1                    'Get length, segment and offset
 Segment& = VARSEG(SndDat(sndnum%))
 Offset& = SADD(SndDat(sndnum%))

 IF Segment& < 0 THEN Segment& = Segment& + 65536 'Without this alot of the sounds
 IF Offset& < 0 THEN Offset& = Offset& + 65536    'doesn't work.... Thanks TOMI LMS :) - I love you man!

 MemLoc& = Segment& * 16 + Offset&                'Calculate memory location

 OUT &HA, &H4 + Channel%                          'Output some stuff to SB
 OUT &HC, &H0
 OUT &HB, &H0

 OUT AddPort%, MemLoc& AND &HFF
 OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
 
 Page% = (MemLoc& AND &HF0000) / &H10000          'Calculate me page

 OUT PgPort%, Page%                               'Output MORE stuff to SB
 OUT LenPort%, Length& AND &HFF
 OUT LenPort%, (Length& AND &HFFFF&) \ &H100
 OUT &HA, Channel%

 WriteDSP &H40                                    'Play the sound
 WriteDSP 211
 WriteDSP &H14
 WriteDSP Length& AND &HFF
 WriteDSP ((Length& AND &HFFFF&) \ &H100)
END SUB

SUB DrawTL
 Wipe

 PUT (INT(RND * 310), INT(RND * 190)), sprt%(60 * 9)      'Put one polar star

 FOR n% = 1 TO 3                                          'Put 3 big stars
  x% = INT(RND * 310): y% = INT(RND * 190)
  PUT (x%, y%), mask%(60 * 8), AND
  PUT (x%, y%), sprt%(60 * 8), OR
 NEXT n%

 FOR n% = 1 TO 6                                          'Put 6 small stars
  x% = INT(RND * 310): y% = INT(RND * 190)
  PUT (x%, y%), mask%(60 * 7), AND
  PUT (x%, y%), sprt%(60 * 7), OR
 NEXT n%
                 
 FOR n% = 1 TO 12                                         'put 12 tiny stars
  x% = INT(RND * 310): y% = INT(RND * 190)
  PUT (x%, y%), mask%(60 * 6), AND
  PUT (x%, y%), sprt%(60 * 6), OR
 NEXT n%

 beginx% = 16 - INT(xdim% / 2)                            'Calc. size of level
 beginy% = 10 - INT(ydim% / 2)
 maxxp% = minxp% + xdim% - 2
 maxyp% = minyp% + ydim% - 2
 undern% = 0                                              'Reset some stuff
 heartn% = 0
 maxscore% = 0

 FOR x% = 1 TO xdim%
  FOR y% = 1 TO ydim%
   IF ASC(level(x%, y%)) <> 255 THEN
   
    SELECT CASE ASC(level(x%, y%))                        'Check what to put
     CASE 1, 2, 3, 5                                      'and put it!!!
      undern% = undern% + 1
      GET ((beginx% * 10) + 10 * (x% - 1), (beginy% * 10) + 10 * (y% - 1))-((beginx% * 10) + 10 * (x% - 1) + 9, (beginy% * 10) + 10 * (y% - 1) + 9), under%(60 * undern%)
      level(x%, y%) = LEFT$(level(x%, y%), 1) + CHR$(0) + CHR$(undern%)
      IF ASC(level(x%, y%)) = 5 THEN nowxp% = x% - 1: nowyp% = y% - 1
     CASE 4
      GET ((beginx% * 10) + 10 * (x% - 1), (beginy% * 10) + 10 * (y% - 1))-((beginx% * 10) + 10 * (x% - 1) + 9, (beginy% * 10) + 10 * (y% - 1) + 9), heart%(60 * heartn%)
      level(x%, y%) = LEFT$(level(x%, y%), 1) + CHR$(heartn%) + CHR$(0)
      heartn% = heartn% + 1
     CASE ELSE
      level(x%, y%) = LEFT$(level(x%, y%), 1) + CHR$(0) + CHR$(0)
    END SELECT
   
    PUT ((beginx% * 10) + 10 * (x% - 1), (beginy% * 10) + 10 * (y% - 1)), mask%(60 * ASC(level(x%, y%))), AND
    PUT ((beginx% * 10) + 10 * (x% - 1), (beginy% * 10) + 10 * (y% - 1)), sprt%(60 * ASC(level(x%, y%))), OR
    IF ASC(level(x%, y%)) = 4 THEN maxscore% = maxscore% + 1
   END IF
  NEXT y%
 NEXT x%
                                                          'Put MAX
 GET ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%)-((beginx% * 10) + 10 * nowxp% + 9, (beginy% * 10) + 10 * nowyp% + 9), under%(0)
 PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), mask%(60 * 10), AND
 PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), sprt%(60 * 10), OR
END SUB

SUB GetBlaster (DMA%, BasePort%, IRQ%)
 IF LEN(ENVIRON$("BLASTER")) = 0 THEN EXIT SUB

 FOR Length% = 1 TO LEN(ENVIRON$("BLASTER"))
  SELECT CASE MID$(ENVIRON$("BLASTER"), Length%, 1)
   CASE "A"                                                           'Get adress
    BasePort% = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length% + 1, 3))
   CASE "I"                                                           'Get IRQ
    IRQ% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
   CASE "D"                                                           'Get DMA
    DMA% = VAL(MID$(ENVIRON$("BLASTER"), Length% + 1, 1))
  END SELECT
 NEXT
END SUB

SUB Instruct
 CLS
 LoadSounds 2

 FOR n% = 0 TO 31                                              'Disp. border
  PUT (10 * n%, 0), sprt%(0), OR
  PUT (10 * n%, 190), sprt%(0), OR
 NEXT n%
 PUT (110, 40), sprt%(0)
 PUT (190, 40), sprt%(0)

 LOCATE 12, 2: PRINT "Use the cursor keys to move the cursor." 'Disp. text
 LOCATE 13, 2: PRINT "When the cursor is above an object,"
 LOCATE 14, 2: PRINT "press space to select it. Then move"
 LOCATE 15, 2: PRINT "the object using the cursor keys or"
 LOCATE 16, 2: PRINT "deselect it by pressing space again."
 WHILE INKEY$ = "": WEND

 LINE (0, 50)-(319, 188), 0, BF                                'Disp. sprites
 PUT (120, 40), sprt%(60 * 5)
 PUT (160, 40), sprt%(60 * 4)
 LOCATE 12, 2: PRINT "The goal is to collect all hearts on"    'Disp. text
 LOCATE 13, 2: PRINT "each level. To pick up a heart, just"
 LOCATE 14, 2: PRINT "move Max towards it."
 WHILE INKEY$ = "": WEND

 DMAPlay 2
 GET (0, 10)-(9, 19), under%(0)                                'Move sprites
 Move 5, 0, 12, 4, 2, 4
 DMAPlay 3

 GET (0, 10)-(9, 19), under%(0)
 Move 5, 0, 16, 4, 2, 2
 WHILE INKEY$ = "": WEND

 LINE (0, 50)-(319, 188), 0, BF                                'Disp. sprites
 LINE (120, 40)-(189, 50), 0, BF
 PUT (120, 40), sprt%(60 * 2)
 PUT (160, 40), sprt%(60 * 1)
 LOCATE 12, 2: PRINT "Moving a green box over a red one"       'Disp. text
 LOCATE 13, 2: PRINT "causes the red box to disappear."
 WHILE INKEY$ = "": WEND

 DMAPlay 4
 GET (0, 10)-(9, 19), under%(0)                                'Move sprites
 Move 2, 0, 12, 4, 2, 4
 DMAPlay 6
 GET (0, 10)-(9, 19), under%(0)
 Move 2, 0, 16, 4, 2, 2
 WHILE INKEY$ = "": WEND

 LINE (0, 50)-(319, 188), 0, BF                                'Disp. sprites
 LINE (120, 40)-(189, 50), 0, BF
 PUT (120, 40), sprt%(60 * 1)
 PUT (160, 40), sprt%(60 * 3)
 LOCATE 12, 2: PRINT "The same goes for a red box over"        'Disp. text
 LOCATE 13, 2: PRINT "a blue, and a blue over a green."
 WHILE INKEY$ = "": WEND

 DMAPlay 4
 GET (0, 10)-(9, 19), under%(0)                                'Move sprites
 Move 1, 0, 12, 4, 2, 4
 DMAPlay 6
 GET (0, 10)-(9, 19), under%(0)
 Move 1, 0, 16, 4, 2, 2
 WHILE INKEY$ = "": WEND

 LINE (120, 40)-(189, 50), 0, BF                               'Disp. sprites
 PUT (120, 40), sprt%(60 * 3)
 PUT (160, 40), sprt%(60 * 2)
 WHILE INKEY$ = "": WEND

 DMAPlay 4
 GET (0, 10)-(9, 19), under%(0)                                'Move sprites
 Move 3, 0, 12, 4, 2, 4
 DMAPlay 6
 GET (0, 10)-(9, 19), under%(0)
 Move 3, 0, 16, 4, 2, 2
 WHILE INKEY$ = "": WEND

 LINE (0, 50)-(319, 188), 0, BF                                'Disp. sprites
 LINE (120, 40)-(189, 50), 0, BF
 PUT (130, 40), sprt%(60 * 5)
 PUT (140, 40), sprt%(60 * 4)
 PUT (150, 40), sprt%(60 * 1)
 PUT (160, 40), sprt%(60 * 2)
 PUT (170, 40), sprt%(60 * 3)
 LOCATE 12, 2: PRINT "All types of boxes stops on"             'Disp. text
 LOCATE 13, 2: PRINT "hearts and if they hit Max."
 LOCATE 14, 2: PRINT "Max stops on all types of"
 LOCATE 15, 2: PRINT "boxes."
 WHILE INKEY$ = "": WEND
END SUB

SUB Load
 CLS
 FOR n% = 0 TO 31                                     'Disp. border
  PUT (10 * n%, 0), sprt%(0), OR
  PUT (10 * n%, 190), sprt%(0), OR
 NEXT n%

 LOCATE 8, 4: PRINT "1 - [                    ]"      'Disp. slots
 LOCATE 9, 4: PRINT "2 - [                    ]"
 LOCATE 10, 4: PRINT "3 - [                    ]"
 LOCATE 11, 4: PRINT "4 - [                    ]"
 LOCATE 12, 4: PRINT "5 - [                    ]"
 LOCATE 13, 4: PRINT "6 - [                    ]"
 LOCATE 14, 4: PRINT "7 - [                    ]"
 LOCATE 15, 4: PRINT "8 - [                    ]"
 LOCATE 16, 4: PRINT "9 - [                    ]"
 LOCATE 17, 4: PRINT "0 - [                    ]"

 n$ = STRING$(20, 0)                                  'Get saved names
 OPEN "saved.dat" FOR BINARY ACCESS READ AS #1
 FOR n% = 1 TO 10
  GET #1, , n$
  LOCATE 7 + n%, 9: PRINT n$;
 NEXT n%
 CLOSE #1

 DO                                                   'Get where to load
  in$ = INKEY$
  SELECT CASE in$
   CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
    IF in$ = "0" THEN in$ = "10"
    OPEN "saved.dat" FOR BINARY ACCESS READ AS #1
    GET #1, 201 + (VAL(in$) - 1) * 2, clevel%
    CLOSE #1
    EXIT SUB
   CASE CHR$(27): EXIT SUB
  END SELECT
noload:
 LOOP
END SUB

SUB LoadSounds (n%) STATIC
 IF ol% <> n% THEN
  PCS -n%
  SELECT CASE n%
   CASE 1
    set$ = CHR$(7) + CHR$(8) + CHR$(9) + CHR$(10) + CHR$(11) + CHR$(12) + CHR$(13)
   CASE 2
    set$ = CHR$(1) + CHR$(2) + CHR$(3) + CHR$(4) + CHR$(5) + CHR$(6)
   CASE 3
    set$ = CHR$(14) + CHR$(15) + CHR$(16) + CHR$(17)
  END SELECT
  ol% = n%
  LoadSoundSet set$
 END IF
END SUB

SUB LoadSoundSet (set$)
 REDIM SndLen(1 TO LEN(set$)) AS INTEGER
 REDIM SndDat(1 TO LEN(set$)) AS STRING

 OPEN "audio.dat" FOR BINARY ACCESS READ AS #1
  x$ = CHR$(0)
  GET #1, , x$
  DIM SndTemp(1 TO ASC(x$)) AS INTEGER
  FOR n% = 1 TO ASC(x$)
   GET #1, , SndTemp(n%)
  NEXT n%
 
  FOR n% = 1 TO LEN(set$)
   DO
    z% = z% + 1
    SndDat(n%) = STRING$(SndTemp(z%), 0)
    SndLen(n%) = SndTemp(z%)
    GET #1, , SndDat(n%)
   LOOP UNTIL z% = ASC(MID$(set$, n%, 1))
  NEXT n%
 CLOSE #1
END SUB

SUB Menu
remenu:
 LoadSounds 1
 CLS                                                       'Disp. border
 FOR n% = 0 TO 31
  PUT (10 * n%, 0), sprt%(0), OR
  PUT (10 * n%, 190), sprt%(0), OR
 NEXT n%

 LOCATE 10, 4: PRINT "N        - Start a new game"         'Disp. menu
 LOCATE 11, 4: PRINT "P        - Play next level (" + LTRIM$(STR$(clevel% + 1)) + ")"
 LOCATE 12, 4: PRINT "A        - Audio ";
 IF audio% THEN PRINT "OFF";  ELSE PRINT "ON ";
 IF noWave% THEN PRINT " [PC Speaker]" ELSE PRINT " [SoundBlaster]"
 LOCATE 13, 4: PRINT "I        - Instructions"
 LOCATE 14, 4: PRINT "S        - Save Game"
 LOCATE 15, 4: PRINT "L        - Load game"
 LOCATE 16, 4: PRINT "!        - About"
 LOCATE 17, 4: PRINT "Q / ESC  - Quit"

 DO                                                        'Get keys
  SELECT CASE INKEY$
   CASE "N", "n"
    DMAPlay 4
    New
    GOTO remenu
   CASE "P", "p"
    DMAPlay 5
levelize:
    ReadTL (clevel% + 1)
    DrawTL
    ol% = clevel%
    OK% = PlayTL
    IF ol% <> clevel% THEN GOTO levelize
    IF OK% = 1 THEN clevel% = clevel% + 1: Check
    GOTO remenu:
   CASE "A", "a"
    audio% = NOT audio%
    LOCATE 12, 21
    IF audio% THEN PRINT "OFF" ELSE PRINT "ON "
   CASE "I", "i": Instruct: GOTO remenu
   CASE "S", "s"
    DMAPlay 7
    Save
    GOTO remenu
   CASE "L", "l"
    DMAPlay 6
    Load
    GOTO remenu
   CASE "!": About: GOTO remenu
   CASE "Q", "q", CHR$(27)
    DMAPlay 1
    WIDTH 80
    PRINT "Goodbye!"
    s! = TIMER: WHILE ABS(TIMER - s!) < .6: WEND
    IF NOT noWave% THEN DeInitDSP
    END
  END SELECT
 LOOP
END SUB

SUB Move (t%, s%, xp%, yp%, m%, l%)
 cx% = xp% * 10: cy% = yp% * 10                     'Move MAX
 FOR n% = 1 TO 10 * l%
  WAIT &H3DA, 8
  PUT (cx%, cy%), under%(60 * s%), PSET
  SELECT CASE m%
   CASE 1: cx% = cx% - 1
   CASE 2: cx% = cx% + 1
   CASE 3: cy% = cy% - 1
   CASE 4: cy% = cy% + 1
  END SELECT
  GET (cx%, cy%)-(cx% + 9, cy% + 9), under%(60 * s%)
  PUT (cx%, cy%), mask%(60 * t%), AND
  PUT (cx%, cy%), sprt%(60 * t%), OR
 NEXT n%
END SUB

SUB New
 CLS
 FOR n% = 0 TO 31                                            'Display border
  PUT (10 * n%, 0), sprt%(0), OR
  PUT (10 * n%, 190), sprt%(0), OR
 NEXT n%

 LOCATE 12, 10: PRINT "Are you sure? [Y/N]"                  'Sure?

 DO: in$ = UCASE$(INKEY$): LOOP UNTIL in$ = "Y" OR in$ = "N"
 IF in$ = "Y" THEN
  clevel% = 0                                                'If so, quit
 END IF
END SUB

SUB PCS (sndnum%) STATIC                 'Play effects on PC Speaker
 IF sndnum% < 0 THEN
  group% = -sndnum%
 ELSE
  PLAY "mbo3l64"
  SELECT CASE sndnum% + group% * 100
   CASE 101                              'Quit game
    PLAY "bagfedc<l32bagfedc"
   CASE 102                              'Completed level
    PLAY "cccc>cdcdcd"
   CASE 103                              'Restarted level
    PLAY "cccc<cdcdcd"
   CASE 104 TO 107                       'Menu commands
    PLAY "cccfff"
  
   CASE 201                              'Cursor move
    PLAY "f"
   CASE 202                              'MAX move
    PLAY "cdefedc"
   CASE 203                              'Got heart
    PLAY "cfcf"
   CASE 204                              'Block move
    PLAY "<cccc"
   CASE 205                              'Into wall
    PLAY "<<c"
   CASE 206                              'Crushed block
    PLAY "c<c<c"
  
   CASE 301                              'Happy 1
    PLAY "bagfedcbagfedc"
   CASE 302                              'Happy 2
    PLAY "ccccdddeeffffccff"
   CASE 303                              'Happy 3
    PLAY "ccccffffcc"
   CASE 304                              'Happy 4
    PLAY "ccddccddddeeddeeffeeff"
  END SELECT
 END IF
END SUB

FUNCTION PlayTL%
 LoadSounds 2                                      'Load sounds

 score% = 0

 DO
  WAIT &H3DA, 8                                    'Wait for vertical retrace
  in$ = INKEY$                                     '(used as timer)
 
  SELECT CASE in$                                  'Get keys
   CASE CHR$(0) + "K"
    DMAPlay 1
    IF nowxp% > 1 THEN
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), under%(0), PSET
     nowxp% = nowxp% - 1
     GET ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%)-((beginx% * 10) + 10 * nowxp% + 9, (beginy% * 10) + 10 * nowyp% + 9), under%(0)
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), mask%(60 * 10), AND
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), sprt%(60 * 10), OR
    END IF
   CASE CHR$(0) + "M"
    DMAPlay 1
    IF nowxp% < xdim% - 2 THEN
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), under%(0), PSET
     nowxp% = nowxp% + 1
     GET ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%)-((beginx% * 10) + 10 * nowxp% + 9, (beginy% * 10) + 10 * nowyp% + 9), under%(0)
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), mask%(60 * 10), AND
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), sprt%(60 * 10), OR
    END IF
   CASE CHR$(0) + "H"
    DMAPlay 1
    IF nowyp% > 1 THEN
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), under%(0), PSET
     nowyp% = nowyp% - 1
     GET ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%)-((beginx% * 10) + 10 * nowxp% + 9, (beginy% * 10) + 10 * nowyp% + 9), under%(0)
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), mask%(60 * 10), AND
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), sprt%(60 * 10), OR
    END IF
   CASE CHR$(0) + "P"
    DMAPlay 1
    IF nowyp% < ydim% - 2 THEN
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), under%(0), PSET
     nowyp% = nowyp% + 1
     GET ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%)-((beginx% * 10) + 10 * nowxp% + 9, (beginy% * 10) + 10 * nowyp% + 9), under%(0)
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), mask%(60 * 10), AND
     PUT ((beginx% * 10) + 10 * nowxp%, (beginy% * 10) + 10 * nowyp%), sprt%(60 * 10), OR
    END IF
   CASE CHR$(32)
    IF RIGHT$(level(nowxp% + 1, nowyp% + 1), 1) > CHR$(0) THEN
     ol% = clevel%
     IF PMove%(nowxp%, nowyp%, SMoved%) = 1 THEN PlayTL% = 1: EXIT FUNCTION
     IF ol% <> clevel% THEN EXIT FUNCTION
    END IF
   CASE CHR$(27)
    
    LoadSounds 1                                  'Load sounds
   
    DMAPlay 3
    EXIT FUNCTION
  END SELECT

 LOOP
END FUNCTION

FUNCTION PMove% (bx%, by%, d%)
 IF d% = 0 THEN EXIT FUNCTION
 x% = bx% + 1: y% = by% + 1                       'Get new position
 srchx% = x%: srchy% = y%
 lastx% = srchx%: lasty% = srchy%
 moved% = ASC(level(srchx%, srchy%))
 SELECT CASE moved%                               'Play sound acordingly to what was moved
  CASE 1, 2, 3
   DMAPlay 4
  CASE 5
   SELECT CASE d%
    CASE 1: kay% = ASC(level(x% - 1, y%))
    CASE 2: kay% = ASC(level(x% + 1, y%))
    CASE 3: kay% = ASC(level(x%, y% - 1))
    CASE 4: kay% = ASC(level(x%, y% + 1))
   END SELECT

   IF kay% = 255 OR kay% = 4 THEN
    DMAPlay 2
   ELSE
    DMAPlay 5
   END IF
 END SELECT

 movedg% = ASC(RIGHT$(level(srchx%, srchy%), 1))
 FOR n% = 0 TO 59                                 'Move background
  store%(0 + n%) = under%(60 * movedg% + n%)
 NEXT n%

 DO                                               'Man, do I HAVE to comment all of this?!?
  SELECT CASE d%
   CASE 1: lastx% = srchx%: srchx% = srchx% - 1
   CASE 2: lastx% = srchx%: srchx% = srchx% + 1
   CASE 3: lasty% = srchy%: srchy% = srchy% - 1
   CASE 4: lasty% = srchy%: srchy% = srchy% + 1
  END SELECT
  SELECT CASE ASC(level(srchx%, srchy%))
   CASE 0: done% = 1
   CASE 1
    IF moved% <> 2 THEN
     done% = 1
    ELSE
     Move moved%, movedg%, x% + beginx% - 1, y% + beginy% - 1, d%, lmoved% + 1
     DMAPlay 6
     lmoved% = -1
     h% = ASC(RIGHT$(level(srchx%, srchy%), 1))
     FOR n% = 0 TO 59
      under%(60 * movedg% + n%) = under%(60 * h% + n%)
     NEXT n%
     WAIT &H3DA, 8
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), under%(60 * movedg%), PSET
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), mask%(60 * moved%), AND
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), sprt%(60 * moved%), OR
     FOR n% = 0 TO 59
      under%(0 + n%) = store%(0 + n%)
     NEXT n%
     level(srchx%, srchy%) = level(x%, y%)
     level(x%, y%) = CHR$(255) + CHR$(0) + CHR$(0)
     x% = srchx%
     y% = srchy%
    END IF
   CASE 2
    IF moved% <> 3 THEN
     done% = 1
    ELSE
     Move moved%, movedg%, x% + beginx% - 1, y% + beginy% - 1, d%, lmoved% + 1
     DMAPlay 6
     lmoved% = -1
     h% = ASC(RIGHT$(level(srchx%, srchy%), 1))
     FOR n% = 0 TO 59
      under%(60 * movedg% + n%) = under%(60 * h% + n%)
     NEXT n%
     WAIT &H3DA, 8
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), under%(60 * movedg%), PSET
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), mask%(60 * moved%), AND
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), sprt%(60 * moved%), OR
     FOR n% = 0 TO 59
      under%(0 + n%) = store%(0 + n%)
     NEXT n%
     level(srchx%, srchy%) = level(x%, y%)
     level(x%, y%) = CHR$(255) + CHR$(0) + CHR$(0)
     x% = srchx%
     y% = srchy%
    END IF
   CASE 3
    IF moved% <> 1 THEN
     done% = 1
    ELSE
     Move moved%, movedg%, x% + beginx% - 1, y% + beginy% - 1, d%, lmoved% + 1
     DMAPlay 6
     lmoved% = -1
     h% = ASC(RIGHT$(level(srchx%, srchy%), 1))
     FOR n% = 0 TO 59
      under%(60 * movedg% + n%) = under%(60 * h% + n%)
     NEXT n%
     WAIT &H3DA, 8
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), under%(60 * movedg%), PSET
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), mask%(60 * moved%), AND
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), sprt%(60 * moved%), OR
     FOR n% = 0 TO 59
      under%(0 + n%) = store%(0 + n%)
     NEXT n%
     level(srchx%, srchy%) = level(x%, y%)
     level(x%, y%) = CHR$(255) + CHR$(0) + CHR$(0)
     x% = srchx%
     y% = srchy%
    END IF
   CASE 4:
    IF moved% = 5 THEN
     score% = score% + 1
     Move moved%, movedg%, x% + beginx% - 1, y% + beginy% - 1, d%, lmoved% + 1
     DMAPlay 3
     lmoved% = -1
     h% = ASC(MID$(level(srchx%, srchy%), 2, 1))
     FOR n% = 0 TO 59
      under%(60 * movedg% + n%) = heart%(60 * h% + n%)
     NEXT n%
     WAIT &H3DA, 8
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), under%(60 * movedg%), PSET
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), mask%(60 * moved%), AND
     PUT ((beginx% * 10) + (srchx% - 1) * 10, (beginy% * 10) + (srchy% - 1) * 10), sprt%(60 * moved%), OR
     FOR n% = 0 TO 59
      under%(0 + n%) = store%(0 + n%)
     NEXT n%
     level(srchx%, srchy%) = level(x%, y%)
     level(x%, y%) = CHR$(255) + CHR$(0) + CHR$(0)
     x% = srchx%
     y% = srchy%
     IF score% = maxscore% THEN PMove% = 1: EXIT FUNCTION
    ELSE
     done% = 1
    END IF
   CASE 5: done% = 1
  END SELECT
 
  IF done% = 1 THEN
   IF lmoved% > 0 THEN
    Move moved%, movedg%, x% + beginx% - 1, y% + beginy% - 1, d%, lmoved%
    FOR n% = 0 TO 59
     under%(0 + n%) = store%(0 + n%)
    NEXT n%
    level(lastx%, lasty%) = level(x%, y%)
    level(x%, y%) = CHR$(255) + CHR$(0) + CHR$(0)
   END IF
   PUT ((beginx% * 10) + (lastx% - 1) * 10, (beginy% * 10) + (lasty% - 1) * 10), mask%(60 * moved%), AND
   PUT ((beginx% * 10) + (lastx% - 1) * 10, (beginy% * 10) + (lasty% - 1) * 10), sprt%(60 * moved%), OR
   PUT ((beginx% * 10) + bx% * 10, (beginy% * 10) + by% * 10), mask%(60 * 10), AND
   PUT ((beginx% * 10) + bx% * 10, (beginy% * 10) + by% * 10), sprt%(60 * 10), OR
   EXIT FUNCTION
  END IF
  lmoved% = lmoved% + 1
 LOOP
END FUNCTION

SUB ReadTL (l%)
 OPEN "offset.dat" FOR BINARY ACCESS READ AS #1
 FOR n% = 1 TO l%
  GET #1, , ofs&
 NEXT n%
 CLOSE #1

 OPEN "levels.dat" FOR BINARY ACCESS READ AS #1
 SEEK #1, ofs&

 x$ = CHR$(0)                                   'Get size of current level
 GET #1, , x$
 xdim% = ASC(x$)
 GET #1, , x$
 ydim% = ASC(x$)
 nib% = 0

 FOR y% = 1 TO ydim%                            'Read level
  FOR x% = 1 TO xdim%
   nib% = NOT nib%
   IF nib% THEN
    GET #1, , x$
    d% = ASC(x$) AND 15
    IF d% = 6 THEN d% = 255
    level(x%, y%) = CHR$(d%) + CHR$(0) + CHR$(0)
   ELSE
    d% = (ASC(x$) AND 240) / 16
    IF d% = 6 THEN d% = 255
    level(x%, y%) = CHR$(d%) + CHR$(0) + CHR$(0)
   END IF
  NEXT x%
 NEXT y%
 CLOSE #1
END SUB

FUNCTION ResetDSP%
 OUT BasePort% + &H6, 1                          'Reset the SB's DSP
 OUT BasePort% + &H6, 0
 FOR n% = 1 TO 100
  WAIT &H3DA, 8
  WAIT &H3DA, 12
  IF INP(BasePort% + &HE) AND 128 THEN GOTO OK
 NEXT n%
 EXIT FUNCTION
OK:
 IF INP(BasePort% + &HA) = &HAA THEN
  ResetDSP% = -1

  OUT BasePort% + 4, &H0                         'Reset mixer
  OUT BasePort% + 5, 0
  OUT BasePort% + 4, &H22                        'Set maximum volume
  OUT BasePort% + 5, 255

  SELECT CASE Channel%                           'Get ports
   CASE 0 TO 3
    MskPort% = &HA
    ModPort% = &HB
    ClrPort% = &HC
   CASE 4 TO 7
    MskPort% = &HD4
    ModPort% = &HD6
    ClrPort% = &HD8
  END SELECT

  OUT MskPort%, Channel% + 4                     'enable channel
  OUT ClrPort%, &H0
  OUT ModPort%, 72 + Channel%
  OUT MskPort%, Channel%

  WriteDSP &HD1                                  'DAC speaker on
 
 END IF
END FUNCTION

SUB Save
 CLS
 FOR n% = 0 TO 31                                   'Disp. border
  PUT (10 * n%, 0), sprt%(0), OR
  PUT (10 * n%, 190), sprt%(0), OR
 NEXT n%

 LOCATE 8, 4: PRINT "1 - [                    ]"    'Disp. slots
 LOCATE 9, 4: PRINT "2 - [                    ]"
 LOCATE 10, 4: PRINT "3 - [                    ]"
 LOCATE 11, 4: PRINT "4 - [                    ]"
 LOCATE 12, 4: PRINT "5 - [                    ]"
 LOCATE 13, 4: PRINT "6 - [                    ]"
 LOCATE 14, 4: PRINT "7 - [                    ]"
 LOCATE 15, 4: PRINT "8 - [                    ]"
 LOCATE 16, 4: PRINT "9 - [                    ]"
 LOCATE 17, 4: PRINT "0 - [                    ]"

 n$ = STRING$(20, 0)                                'Get saved names
nosave:
 OPEN "saved.dat" FOR BINARY ACCESS READ AS #1
 FOR n% = 1 TO 10
  GET #1, , n$
  LOCATE 7 + n%, 9: PRINT n$;
 NEXT n%
 CLOSE #1

 DO
  in$ = INKEY$
  SELECT CASE in$                                   'Get where to save
   CASE "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"
    p% = VAL(in$)                                   'Save!!
    IF p% = 0 THEN p% = 10
    LOCATE 7 + p%, 9: PRINT STRING$(20, 32)
    LOCATE 7 + p%, 9: LINE INPUT "", desc$
    desc$ = LEFT$(LTRIM$(RTRIM$(desc$)), 20)
    FOR n% = 1 TO LEN(desc$)
     IF MID$(desc$, n%, 1) = CHR$(32) THEN MID$(desc$, n%, 1) = CHR$(0)
    NEXT n%
    desc$ = desc$ + STRING$(20 - LEN(desc$), 0)
    IF desc$ = STRING$(20, 0) THEN GOTO nosave
   
    OPEN "saved.dat" FOR BINARY ACCESS WRITE AS #1
    PUT #1, 1 + (p% - 1) * 20, desc$
    PUT #1, 201 + (p% - 1) * 2, clevel%
    CLOSE #1
    EXIT SUB
   CASE CHR$(27): EXIT SUB
  END SELECT
LOOP
END SUB

FUNCTION SMoved%
 LINE (beginx% * 10 + nowxp% * 10, beginy% * 10 + nowyp% * 10)-(9 + beginx% * 10 + nowxp% * 10, 9 + beginy% * 10 + nowyp% * 10), 14, B

 DO
  i$ = INKEY$
sc:
 
  SELECT CASE i$                                  'Get which dir to move
   CASE CHR$(0) + "K": o% = 1
   CASE CHR$(0) + "M": o% = 2
   CASE CHR$(0) + "H": o% = 3
   CASE CHR$(0) + "P": o% = 4
   CASE CHR$(32)
nomark:
    PUT (beginx% * 10 + nowxp% * 10, beginy% * 10 + nowyp% * 10), under%(0), PSET
    PUT (beginx% * 10 + nowxp% * 10, beginy% * 10 + nowyp% * 10), mask%(60 * 10), AND
    PUT (beginx% * 10 + nowxp% * 10, beginy% * 10 + nowyp% * 10), sprt%(60 * 10), OR
    EXIT FUNCTION
   CASE ELSE
    code$ = code$ + UCASE$(i$)                    'code handling
    IF LEN(code$) > 4 THEN code$ = RIGHT$(code$, 4)
    IF RIGHT$(code$, 2) = "GO" THEN
     LOCATE 1, 1: INPUT clevel%
     EXIT FUNCTION
    END IF
    IF RIGHT$(code$, 4) = "SKIP" THEN
     clevel% = clevel% + 1
     EXIT FUNCTION
    END IF
  END SELECT

 LOOP UNTIL o% > 0

 SMoved% = o%
 GOTO nomark
END FUNCTION

SUB Wipe
 FOR temp% = 0 TO 319                                 'Wipe horiz
  IF INT(temp% / 10) = temp% / 10 THEN WAIT &H3DA, 8
  LINE (temp%, 0)-(319 - temp%, 199), 0
 NEXT

 FOR temp% = 199 TO 0 STEP -1                         'Wipe vert
  IF INT(temp% / 10) = temp% / 10 THEN WAIT &H3DA, 8
  LINE (0, temp%)-(319, 199 - temp%), 0
 NEXT
END SUB

SUB WriteDSP (byte%)                          'Write to SB's DSP
 s! = TIMER
 DO
  IF ABS(TIMER - s!) >= 1 THEN EXIT DO
 LOOP WHILE INP(BasePort% + 12) AND &H80
 OUT BasePort% + 12, byte%
END SUB

