'Skiing Game
'
'Written by Alex Knight-Percival
'MultiKey by Milo Sedlacek
'
'Visit QBasic City at www.spanz.u-net.com
'
DEFINT A-Z
DECLARE FUNCTION DPoint$ (n#)
DECLARE FUNCTION FontLength% (txt$, s%, st%)
DECLARE FUNCTION GetPath$ ()
DECLARE FUNCTION MultiKey% (t%)
DECLARE FUNCTION Valid% (Text$, chrset%)
DECLARE SUB CentreFont (y%, t$, c%, s%, f%)
DECLARE SUB DrawCourse (scrl%)
DECLARE SUB EndProg ()
DECLARE SUB Font (x%, y%, Text$, clr%, s%, st%)
DECLARE SUB FrontEnd ()
DECLARE SUB GetPos (x%, y%, c%)
DECLARE SUB HelpScreen ()
DECLARE SUB LoadBannerSprite (n$)
DECLARE SUB LoadBkSprite (n$)
DECLARE SUB LoadCourse (n$)
DECLARE SUB LoadDats ()
DECLARE SUB LoadFont (name$, ln%)
DECLARE SUB LoadYouSprites (n$)
DECLARE SUB Options ()
DECLARE SUB PlayTrack (yTime#)
DECLARE SUB SelectCourse (xit%)
DECLARE SUB ShowTrackPrev (xit%)
DECLARE SUB Tracks (x1%, y1%, x2%, y2%)
DECLARE SUB UpdBestTimes (t#)
DECLARE SUB UpdInfo (poles%, tm#, passed%)
DECLARE SUB UserInp (xVel!, yVel!, dcc!, cnr!, acc%, scfr%, cdcc!)
DECLARE SUB WaitLetKeyGo (n%)
COMMON SHARED cLength%, cX%, cY%, cFr%, totpoles%, totcourses%, cCourse%
COMMON SHARED tLen%, tUpd#, SprAdd%, defname$, hlt%
CONST ChSize% = 122

TYPE Scores
  PName AS STRING * 12
  Score AS DOUBLE
END TYPE

REDIM SHARED FontString$(255, 9)
REDIM SHARED WdthAry%(255, 9)
REDIM SHARED Char%(ChSize% * 100)         'To hold main character

RANDOMIZE TIMER
CHDIR GetPath$

SCREEN 7, , 1, 0

z = MultiKey(-1)
tLen% = 13

LoadFont "default.chr", 0
Font 0, 0, "Initialising...", 15, 1, 0
LoadFont "freehand.chr", 1
PCOPY 1, 0

REDIM SHARED Ary%(0)
REDIM SHARED Bk%(0)
REDIM SHARED Trail%(8, tLen%)
LoadBannerSprite "qbski.spr"
LoadBkSprite "qbski2.spr"
LoadYouSprites "char.spr"

REDIM SHARED HiScore(0, 0) AS Scores
REDIM SHARED Dat(0, 0) AS STRING * 12
REDIM SHARED Course%(0, 0)
LoadDats

FrontEnd

EndProg

SUB CentreFont (y%, t$, c%, s%, f%)
Font 159 - (FontLength%(t$, s%, f%) / 2), y%, t$, c%, s%, f%
END SUB

FUNCTION DPoint$ (n#)
calc# = n#
z$ = LTRIM$(STR$(calc#)) + "00"
t% = INSTR(z$, ".")
IF t% = 0 THEN
  DPoint$ = MID$(z$, 1, LEN(z$) - 2) + ".00"
ELSE
  DPoint$ = MID$(z$, 1, t% + 2)
END IF
END FUNCTION

SUB DrawCourse (scrl%) STATIC
LINE (0, 0)-(319, 199), 15, BF
s% = scrl% \ 20
df% = 0'(s% * 20) - scrl%
d% = (s% - 1)
dr% = 0
FOR i% = 0 TO tLen%
  IF Trail%(0, i%) = 1 THEN
    x1% = Trail%(1, i%)
    y1% = Trail%(2, i%) - scrl%
    x2% = Trail%(3, i%)
    y2% = Trail%(4, i%) - scrl%
    LINE (x1%, y1%)-(x2%, y2%), 7
    x1% = Trail%(5, i%)
    y1% = Trail%(6, i%) - scrl%
    x2% = Trail%(7, i%)
    y2% = Trail%(8, i%) - scrl%
    LINE (x1%, y1%)-(x2%, y2%), 7
  END IF
NEXT i%
DO
  d% = d% + 1
  IF d% > cLength% THEN EXIT DO
  IF d% >= 0 THEN
    IF Course%(1, d%) = 1 THEN
      x% = (Course%(2, d%) * 20) + 10
      y% = ((d% * 20) + 10) - scrl%
      LINE (x% - 15, y% - 10)-(x% - 13, y%), 4, BF
      LINE (x% + 15, y% - 10)-(x% + 13, y%), 4, BF
      LINE (x% - 12, y% - 10)-(x% + 12, y% - 8), 12, BF
    END IF
    IF Course%(1, d%) = 2 OR Course%(1, d%) = 3 THEN
      x% = (Course%(2, d%) * 20) + 10
      y% = ((d% * 20) + 10) - scrl%
      GetPos lxpos%, lypos%, d%
      IF lypos% - scrl% > 200 THEN EXIT DO
      Tracks x%, y%, lxpos%, lypos% - scrl%
    END IF
  END IF
  IF (d% - 1) >= 0 THEN
    IF Course%(1, (d% - 1)) = 3 THEN
      x% = (Course%(2, (d% - 1)) * 20) + 10
      y% = (((d% - 1) * 20) + 10) - scrl%
      LINE (x% - 15, y% - 10)-(x% - 13, y%), 4, BF
      LINE (x% + 15, y% - 10)-(x% + 13, y%), 4, BF
    ELSEIF Course%(1, (d% - 1)) = 4 THEN
      y% = (((d% - 1) * 20) - scrl%)
      dr% = 1
      PUT (cX%, (cY% - scrl%)), Char%((((cFr% + SprAdd%) * 2) + 1) * ChSize%), AND
      PUT (cX%, (cY% - scrl%)), Char%(((cFr% + SprAdd%) * 2) * ChSize%), XOR
      LINE (0, y% - 40)-(3, y% - 10), 6, BF
      LINE (316, y% - 30)-(319, y% - 10), 6, BF
      FOR xflg% = 0 TO 32
        FOR yflg% = 0 TO 1
          IF (yflg% \ 2) * 2 = yflg% THEN a% = 1 ELSE a% = 0
          IF (xflg% \ 2) * 2 = xflg% THEN n% = 1 ELSE n% = 0
          IF a% = n% THEN clr% = 7 ELSE clr% = 8
          LINE ((xflg% * 10), ((yflg% * 5) + y%) - 40)-((xflg% * 10) + 10, ((yflg% * 5) + 5 + y%) - 40), clr%, BF
        NEXT yflg%
      NEXT xflg%
    END IF
  END IF
LOOP
IF dr% = 0 THEN
  PUT (cX%, (cY% - scrl%)), Char%((((cFr% + SprAdd%) * 2) + 1) * ChSize%), AND
  PUT (cX%, (cY% - scrl%)), Char%(((cFr% + SprAdd%) * 2) * ChSize%), XOR
END IF
IF TIMER - tUpd# >= .25 THEN
  tUpd# = TIMER
  FOR i% = tLen% TO 1 STEP -1
    FOR a% = 0 TO 8
      Trail%(a%, i%) = Trail%(a%, i% - 1)
    NEXT a%
  NEXT i%
  Trail%(0, 0) = 1
  IF Trail%(0, 1) = 1 THEN
    Trail%(1, 0) = Trail%(3, 1)
    Trail%(2, 0) = Trail%(4, 1)
    Trail%(3, 0) = cX% + 8
    Trail%(4, 0) = cY% + 13
    Trail%(5, 0) = Trail%(7, 1)
    Trail%(6, 0) = Trail%(8, 1)
    Trail%(7, 0) = cX% + 11
    Trail%(8, 0) = cY% + 13
  ELSE
    Trail%(1, 0) = cX% + 8
    Trail%(2, 0) = cY% + 13
    Trail%(3, 0) = cX% + 8
    Trail%(4, 0) = cY% + 13
    Trail%(5, 0) = cX% + 11
    Trail%(6, 0) = cY% + 13
    Trail%(7, 0) = cX% + 11
    Trail%(8, 0) = cY% + 13
  END IF
END IF
Trail%(3, 0) = cX% + 8
Trail%(4, 0) = cY% + 16
Trail%(7, 0) = cX% + 11
Trail%(8, 0) = cY% + 16
END SUB

SUB EndProg
'Write all data to disk
OPEN "ski.dat" FOR OUTPUT AS #1
WRITE #1, totcourses%
FOR i% = 1 TO totcourses%
  WRITE #1, Dat(0, i%), Dat(1, i%)
  FOR d% = 1 TO 5
    WRITE #1, HiScore(d%, i%).PName, HiScore(d%, i%).Score
  NEXT d%
NEXT i%
CLOSE #1
z = MultiKey(-2)
SYSTEM
END SUB

SUB Font (x%, y%, Text$, clr%, s%, st%)
size% = s% * 4
IF x% < 0 THEN DRAW "BM0,+0"
IF y% < 0 THEN DRAW "BM+0,0"
DRAW "BM" + LTRIM$(STR$(x%)) + "," + LTRIM$(STR$(y%)) + " C" + LTRIM$(STR$(clr%)) + " S" + LTRIM$(STR$(size%))
FOR i% = 1 TO LEN(Text$)
  DRAW "X" + VARPTR$(FontString$(ASC(MID$(Text$, i%, 1)), st%))
NEXT i%
END SUB

FUNCTION FontLength% (txt$, s%, st%)
FOR i% = 1 TO LEN(txt$)
  fl% = fl% + WdthAry%(ASC(MID$(txt$, i%, 1)), st%)
NEXT i%
fl% = fl% * s%
FontLength% = (fl% - (2 * s%))
END FUNCTION

SUB FrontEnd
upd% = 1
sl% = 1
DO
  IF MultiKey(72) THEN
    WaitLetKeyGo 72
    sl% = sl% - 1
    IF sl% < 1 THEN sl% = 1
    upd% = 1
  ELSEIF MultiKey(80) THEN
    WaitLetKeyGo 80
    sl% = sl% + 1
    IF sl% > 4 THEN sl% = 4
    upd% = 1
  ELSEIF MultiKey(28) THEN
    WaitLetKeyGo 28
    IF sl% = 1 THEN
      SelectCourse action%
      'IF action% = 0 THEN EXIT DO
      upd% = 1
    END IF
    IF sl% = 2 THEN Options: upd% = 1
    IF sl% = 3 THEN HelpScreen: upd% = 1
    IF sl% = 4 THEN EndProg
  ELSEIF MultiKey(1) THEN
    WaitLetKeyGo 1
    EndProg
  END IF
  IF upd% = 1 THEN
    LINE (0, 0)-(319, 199), 15, BF
    PUT (0, 0), Ary%(4), PSET
    Font 2, 191, "Use the up and down arrow keys to select an option.", 1, 1, 0
    IF sl% = 1 THEN c% = 12 ELSE c% = 1
    CentreFont 110, "Start", c%, 2, 1
    IF sl% = 2 THEN c% = 12 ELSE c% = 1
    CentreFont 130, "Options", c%, 2, 1
    IF sl% = 3 THEN c% = 12 ELSE c% = 1
    CentreFont 150, "Help", c%, 2, 1
    IF sl% = 4 THEN c% = 12 ELSE c% = 1
    CentreFont 170, "Exit", c%, 2, 1
    PCOPY 1, 0
    upd% = 0
  END IF
LOOP
END SUB

FUNCTION GetPath$
'GetPath FUNCTION written by Alex Knight-Percival (alex@spanz.u-net.com)
'Visit QBasic City @ www.spanz.u-net.com

'This code gets then path AND filename (ie C:\FILES\GETPATH.BAS)
tmp% = 1                                         'define a variable
DEF SEG = VARSEG(tmp%)                           'and set segment
DO
  i% = i% + 1                                    'add one to counter
  a% = PEEK(5861 + i%)                           'get a letter from memory
  IF a% = 0 THEN EXIT DO                         'if at string end then exit
  p$ = p$ + CHR$(a%)                             'append to string
LOOP UNTIL i% > 255                              'stops overflow if error

'Get rid of filename so you are left with just the path:
d% = 1                                           'start search from chr 1
DO
  f% = INSTR(d%, p$, "\")                        'look for backslash (\)
  IF f% = 0 THEN EXIT DO                         'if you can't find it exit
  d% = f% + 1                                    'start search from next \
LOOP
p$ = LEFT$(p$, d% - 2)                           'cut filename off
GetPath$ = p$                                    'return path

END FUNCTION

SUB GetPos (x%, y%, c%)
d% = c%
DO
  d% = d% - 1
  IF d% < 0 THEN EXIT DO
  IF Course%(1, d%) = 2 OR Course%(1, d%) = 1 OR Course%(1, d%) = 3 THEN
    x% = (Course%(2, d%) * 20) + 10
    y% = ((d% * 20) + 10)
    EXIT DO
  END IF
LOOP
END SUB

SUB Grey (x1%, y1%, x2%, y2%)
FOR B% = x1% TO x2% STEP 2
  LINE (B%, y1%)-(B%, y2%), 7, , &H5555
NEXT
FOR B% = x1% + 1 TO x2% STEP 2
  LINE (B%, y1%)-(B%, y2%), 7, , &HAAAA
NEXT
END SUB

SUB HelpScreen
LINE (0, 0)-(319, 199), 15, BF
PUT (0, 0), Bk%(4), PSET
Font 10, 10, "Help", 1, 2, 1
CentreFont 30, "Controls", 1, 1, 0
CentreFont 50, "Use the arrow keys to control the character.", 1, 1, 0
CentreFont 60, "Pressing <DOWN> will speed the character up.", 1, 1, 0
CentreFont 70, "Pressing <UP> will slow the character down.", 1, 1, 0
CentreFont 80, "Pressing <LEFT> will make the character turn to the left.", 1, 1, 0
CentreFont 90, "Pressing <RIGHT> will make the character turn to the right.", 1, 1, 0
CentreFont 100, "Letting go of all the keys will make the character streamlined.", 1, 1, 0
Font 2, 191, "Press <SPACE> to continue, <ESC> to exit.", 1, 1, 0
PCOPY 1, 0
a% = 1
DO
  IF TIMER - z# >= .1 THEN
    z# = TIMER
    bs% = bs% + a%: upd% = 1
    IF bs% >= 3 THEN a% = -a%
    IF bs% <= 0 THEN a% = -a%
  END IF
  IF TIMER - k# >= 1 THEN
    k# = TIMER
    p% = p% + 1
    IF p% > 8 THEN p% = 1
  END IF
  IF p% = 1 OR p% = 2 THEN c% = bs%
  IF p% = 3 OR p% = 4 THEN c% = bs% + 4
  IF p% = 5 THEN c% = 8
  IF p% = 6 THEN c% = 9
  IF p% = 7 THEN c% = 10
  IF p% = 8 THEN c% = 11
  LINE (150, 130)-(170, 150), 15, BF
  PUT (150, 130), Char%(((c% * 2) + 1) * ChSize%), AND
  PUT (150, 130), Char%((c% * 2) * ChSize%), XOR
  DRAW "BM175,140 C1 ND10 NG5 F5"                'Up arrow
  IF p% = 5 OR p% = 6 THEN DRAW "C12" ELSE DRAW "C1"
  DRAW "BM160,155 NR10 NE5 F5"                'Left Arrow
  IF p% = 1 OR p% = 2 THEN DRAW "C12" ELSE DRAW "C1"
  DRAW "BM175,160 D10 NH5 E5"                 'Down arrow
  IF p% = 7 OR p% = 8 THEN DRAW "C12" ELSE DRAW "C1"
  DRAW "BM180,155 R10 NH5 G5"                 'Right arrow
  PCOPY 1, 0
  IF MultiKey(1) THEN WaitLetKeyGo 1: EXIT SUB
LOOP UNTIL MultiKey(57)
WaitLetKeyGo 57

LINE (0, 0)-(319, 199), 15, BF
PUT (0, 0), Bk%(4), PSET
Font 10, 10, "Help", 1, 2, 1
CentreFont 30, "Courses", 1, 1, 0
CentreFont 50, "There are ten courses in all, six full courses and four short", 1, 1, 0
CentreFont 60, "practice courses. Use the practice courses to improve your skills,", 1, 1, 0
CentreFont 70, "and for a real challenge try the full courses.", 1, 1, 0
CentreFont 90, "As you go down the slope you must pass through each gate. For", 1, 1, 0
CentreFont 100, "every one that you miss, you incur a five second penalty. A", 1, 1, 0
CentreFont 110, "good strategy is to try and follow the grey track between each", 1, 1, 0
CentreFont 120, "gate.", 1, 1, 0
CentreFont 140, "If you get a good time it will be recorded on the 'Best Times' board.", 1, 1, 0
CentreFont 150, "You can reset this at any time by choosing 'Reset Best Times' from", 1, 1, 0
CentreFont 160, "the options menu.", 1, 1, 0
Font 2, 191, "Press <SPACE> to continue, <ESC> to exit.", 1, 1, 0
PCOPY 1, 0
a% = 1
DO
  IF MultiKey(1) THEN WaitLetKeyGo 1: EXIT SUB
LOOP UNTIL MultiKey(57)
WaitLetKeyGo 57

LINE (0, 0)-(319, 199), 15, BF
PUT (0, 0), Bk%(4), PSET
Font 10, 10, "Help", 1, 2, 1
CentreFont 30, "Options Menu", 1, 1, 0
CentreFont 50, "'Reset Best Times' will reset the 'Best Times' board for all of", 1, 1, 0
CentreFont 60, "the courses. Choose 'yes' if you are sure you wish to do this", 1, 1, 0
CentreFont 70, "and choose 'no' to cancel.", 1, 1, 0
CentreFont 90, "'Change skier' allows you to change the skier. There are two", 1, 1, 0
CentreFont 100, "different skiers for you to choose from. Note that both skiers", 1, 1, 0
CentreFont 110, "are exactly the same to control, the only difference between the", 1, 1, 0
CentreFont 120, "two is their appearance.", 1, 1, 0
CentreFont 140, "'Set Default Name' allows you to set a default name for when", 1, 1, 0
CentreFont 150, "you get on the 'Best Times' board. This means you will not have", 1, 1, 0
CentreFont 160, "to retype your name each time.", 1, 1, 0
Font 2, 191, "Press <SPACE> to continue, <ESC> to exit.", 1, 1, 0
PCOPY 1, 0
a% = 1
DO
  IF MultiKey(1) THEN WaitLetKeyGo 1: EXIT SUB
LOOP UNTIL MultiKey(57)
WaitLetKeyGo 57

LINE (0, 0)-(319, 199), 15, BF
PUT (0, 0), Bk%(4), PSET
Font 10, 10, "Help", 1, 2, 1
CentreFont 30, "Credits", 1, 1, 0
CentreFont 50, "Code by Alex Knight-Percival.", 1, 1, 0
CentreFont 60, "GetPath Routine by Alex Knight-Percival.", 1, 1, 0
CentreFont 70, "MultiKey Routine by Milo Sedlacek.", 1, 1, 0
CentreFont 90, "Visit QBasic City at www.spanz.u-net.com.", 1, 1, 0
Font 2, 191, "Press <SPACE> to continue.", 1, 1, 0
PCOPY 1, 0
a% = 1
DO: LOOP UNTIL MultiKey(57)
WaitLetKeyGo 57
END SUB

SUB LoadBannerSprite (n$)
OPEN n$ FOR BINARY AS #1
GET #1, 8, xSize%                        'Gets file header to
GET #1, , ySize%                         'determine size of array.
GET #1, , NumOf%
CLOSE #1
'Now set variables...
size% = ((4 + INT(((PMAP(xSize%, 0) - PMAP(0, 0) + 1) * (1) + 7) / 8) * 4 * (PMAP(ySize%, 1) - PMAP(0, 1) + 1)) \ 2)
ArySize% = (size% * NumOf%) + 4          '(Above) size of single
                                         'image is calculated using
                                         'formula in the help.
                                         'Array size is size of
                                         'image * number of images
                                         '+ 4 (file header)
'Redimension the array
REDIM Ary%(ArySize%)                     'Make new Ary%
DEF SEG = VARSEG(Ary%(0))                'Current SEG=Ary% seg
BLOAD n$, VARPTR(Ary%(0))                'Now load it
END SUB

SUB LoadBkSprite (n$)
OPEN n$ FOR BINARY AS #1
GET #1, 8, xSize%                        'Gets file header to
GET #1, , ySize%                         'determine size of array.
GET #1, , NumOf%
CLOSE #1
'Now set variables...
size% = ((4 + INT(((PMAP(xSize%, 0) - PMAP(0, 0) + 1) * (1) + 7) / 8) * 4 * (PMAP(ySize%, 1) - PMAP(0, 1) + 1)) \ 2)
ArySize% = (size% * NumOf%) + 4          '(Above) size of single
                                         'image is calculated using
                                         'formula in the help.
                                         'Array size is size of
                                         'image * number of images
                                         '+ 4 (file header)
'Redimension the array
REDIM Bk%(ArySize%)                      'Make new Ary%
DEF SEG = VARSEG(Bk%(0))                 'Current SEG=Ary% seg
BLOAD n$, VARPTR(Bk%(0))                 'Now load it
END SUB

SUB LoadCourse (n$)
OPEN n$ FOR INPUT AS #1
INPUT #1, c%
totpoles% = 0
cLength% = c%
REDIM Course%(2, c%)
FOR i% = 0 TO c% - 1
  INPUT #1, t$
  FOR L% = 1 TO LEN(t$)
    ta% = 0
    z$ = MID$(t$, L%, 1)
    IF z$ = "S" THEN ta% = 1
    IF z$ = "%" THEN ta% = 2
    IF z$ = "H" THEN ta% = 3: totpoles% = totpoles% + 1
    IF z$ = "F" THEN ta% = 4
    IF ta% <> 0 THEN
      Course%(1, i%) = ta%
      Course%(2, i%) = L% - 1
    END IF
  NEXT L%
NEXT i%
CLOSE
END SUB

SUB LoadDats
OPEN "ski.dat" FOR INPUT AS #1
INPUT #1, n%
REDIM HiScore(5, n%) AS Scores
REDIM Dat(1, n%) AS STRING * 12
totcourses% = n%
FOR i% = 1 TO n%
  INPUT #1, cfile$, cname$
  Dat(0, i%) = cfile$
  Dat(1, i%) = cname$
  FOR d% = 1 TO 5
    INPUT #1, p$, s#
    HiScore(d%, i%).PName = p$
    HiScore(d%, i%).Score = s#
  NEXT d%
NEXT i%
CLOSE #1
END SUB

SUB LoadFont (name$, ln%)
OPEN name$ FOR INPUT AS #1
FOR i% = 0 TO 255
  INPUT #1, tmp%, WdthAry%(i%, ln%), FontString$(i%, ln%)
NEXT i%
CLOSE #1
END SUB

SUB LoadYouSprites (n$)
DEF SEG = VARSEG(Char%(0))
BLOAD n$, VARPTR(Char%(0))
END SUB

FUNCTION MultiKey (t)

STATIC kbcontrol%(), kbmatrix%(), Firsttime, StatusFlag

IF Firsttime = 0 THEN          'Initalize
 DIM kbcontrol%(128)
 DIM kbmatrix%(128)
 code$ = ""
 code$ = code$ + "E91D00E93C00000000000000000000000000000000000000000000000000"
 code$ = code$ + "00001E31C08ED8BE24000E07BF1400FCA5A58CC38EC0BF2400B85600FAAB"
 code$ = code$ + "89D8ABFB1FCB1E31C08EC0BF2400BE14000E1FFCFAA5A5FB1FCBFB9C5053"
 code$ = code$ + "51521E560657E460B401A8807404B400247FD0E088C3B700B0002E031E12"
 code$ = code$ + "002E8E1E100086E08907E4610C82E661247FE661B020E6205F075E1F5A59"
 code$ = code$ + "5B589DCF"
 DEF SEG = VARSEG(kbcontrol%(0))
 FOR i% = 0 TO 155                     ' Load ASM
     d% = VAL("&h" + MID$(code$, i% * 2 + 1, 2))
     POKE VARPTR(kbcontrol%(0)) + i%, d%
 NEXT i%
 i& = 16       ' I think this stuff connects the interrupt with kbmatrix%()
 n& = VARSEG(kbmatrix%(0)): L& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE i&, L&: POKE i& + 1, h&: i& = i& + 2
 n& = VARPTR(kbmatrix%(0)): L& = n& AND 255: h& = ((n& AND &HFF00) \ 256): POKE i&, L&: POKE i& + 1, h&: i& = i& + 2
 DEF SEG
 Firsttime = 1
END IF

SELECT CASE t
 CASE -1
  IF StatusFlag = 0 THEN
   DEF SEG = VARSEG(kbcontrol%(0))
   CALL ABSOLUTE(0)                     ' Run interrupt
   DEF SEG
   StatusFlag = 1
  END IF
 CASE -2
  IF StatusFlag = 1 THEN
   DEF SEG = VARSEG(kbcontrol%(0))      ' Turn off interrupt
   CALL ABSOLUTE(3)
   DEF SEG
   StatusFlag = 0
  END IF
 CASE 1 TO 128
  MultiKey = kbmatrix%(t)               ' Return status
 CASE ELSE
  MultiKey = 0                          ' User Supidity Error
END SELECT

END FUNCTION

SUB Options
DO
  upd% = 1
  sl% = 1
  DO
    IF MultiKey(72) THEN
      WaitLetKeyGo 72
      sl% = sl% - 1
      IF sl% < 1 THEN sl% = 1
      upd% = 1
    ELSEIF MultiKey(80) THEN
      WaitLetKeyGo 80
      sl% = sl% + 1
      IF sl% > 4 THEN sl% = 4
      upd% = 1
    ELSEIF MultiKey(28) THEN
      WaitLetKeyGo 28
      IF sl% = 4 THEN EXIT SUB
      EXIT DO
    ELSEIF MultiKey(1) THEN
      WaitLetKeyGo 1
      EXIT SUB
    END IF
    IF upd% = 1 THEN
      LINE (0, 0)-(319, 199), 15, BF
      PUT (0, 0), Ary%(4), PSET
      Font 2, 191, "Use the up and down arrow keys to select an option.", 1, 1, 0
      IF sl% = 1 THEN c% = 12 ELSE c% = 1
      CentreFont 110, "Reset Best Times", c%, 2, 1
      IF sl% = 2 THEN c% = 12 ELSE c% = 1
      CentreFont 130, "Change Skier", c%, 2, 1
      IF sl% = 3 THEN c% = 12 ELSE c% = 1
      CentreFont 150, "Set Default Name", c%, 2, 1
      IF sl% = 4 THEN c% = 12 ELSE c% = 1
      CentreFont 170, "Back", c%, 2, 1
      PCOPY 1, 0
      upd% = 0
    END IF
  LOOP
  IF sl% = 1 THEN
    LINE (0, 0)-(319, 199), 15, BF
    PUT (0, 0), Ary%(4), PSET
    CentreFont 110, "Are you sure you want to reset best times?", 1, 1, 0
    Font 2, 191, "Use the up and down arrow keys to select an option.", 1, 1, 0
    upd% = 1: s% = 1
    DO
      IF MultiKey(72) THEN
        WaitLetKeyGo 72: s% = 1: upd% = 1
      ELSEIF MultiKey(80) THEN
        WaitLetKeyGo 80: s% = 2: upd% = 1
      ELSEIF MultiKey(28) THEN
        WaitLetKeyGo 28: EXIT DO
      ELSEIF MultiKey(1) THEN
        WaitLetKeyGo 1: s% = 2: EXIT DO
      END IF
      IF upd% = 1 THEN
        IF s% = 1 THEN
          CentreFont 130, "Yes", 12, 2, 1
          CentreFont 150, "No", 1, 2, 1
        ELSEIF s% = 2 THEN
          CentreFont 130, "Yes", 1, 2, 1
          CentreFont 150, "No", 12, 2, 1
        END IF
        upd% = 0
        PCOPY 1, 0
      END IF
    LOOP
    IF s% = 1 THEN
      FOR x% = 1 TO 5
        FOR y% = 1 TO totcourses%
          HiScore(x%, y%).PName = "Anon"
          HiScore(x%, y%).Score = 999.9999999999999#
        NEXT y%
      NEXT x%
    END IF
  ELSEIF sl% = 2 THEN
    LINE (0, 0)-(319, 199), 15, BF
    PUT (0, 0), Ary%(4), PSET
    CentreFont 110, "Select skier:", 1, 1, 0
    Font 2, 191, "Use the left and right arrow keys to select.", 1, 1, 0
    upd% = 1: s% = 1: a% = 1
    DO
      IF MultiKey(75) THEN
        s% = 1: upd% = 1
      ELSEIF MultiKey(77) THEN
        s% = 2: upd% = 1
      ELSEIF MultiKey(28) THEN
        WaitLetKeyGo 28: EXIT DO
      ELSEIF MultiKey(1) THEN
        WaitLetKeyGo 1: s% = 2: EXIT DO
      END IF
      IF TIMER - z# >= .1 THEN
        z# = TIMER
        c% = c% + a%: upd% = 1
        IF c% >= 3 THEN a% = -a%
        IF c% <= 0 THEN a% = -a%
      END IF
      IF upd% = 1 THEN
        LINE (135, 130)-(185, 150), 15, BF
        PUT (135, 130), Char%(((c% * 2) + 1) * ChSize%), AND
        PUT (135, 130), Char%((c% * 2) * ChSize%), XOR
        PUT (165, 130), Char%((((c% + 13) * 2) + 1) * ChSize%), AND
        PUT (165, 130), Char%(((c% + 13) * 2) * ChSize%), XOR
        IF s% = 1 THEN LINE (134, 129)-(156, 151), 1, B
        IF s% = 1 THEN LINE (164, 129)-(186, 151), 15, B
        IF s% = 2 THEN LINE (164, 129)-(186, 151), 1, B
        IF s% = 2 THEN LINE (134, 129)-(156, 151), 15, B
        upd% = 0
        PCOPY 1, 0
      END IF
    LOOP
    IF s% = 1 THEN SprAdd% = 0
    IF s% = 2 THEN SprAdd% = 13
  ELSEIF sl% = 3 THEN
    tmp = MultiKey(-2)
    LINE (0, 0)-(319, 199), 15, BF
    PUT (0, 0), Ary%(4), PSET
    CentreFont 110, "Enter name:", 1, 1, 0
    Font 2, 191, "Type default name for best times. <ENTER> when done.", 1, 1, 0
    upd% = 1
    DO
      a$ = INKEY$
      IF Valid(a$, 1) AND LEN(n$) < 12 THEN
        n$ = n$ + a$
        upd% = 1
      ELSEIF a$ = CHR$(8) AND LEN(n$) > 0 THEN
        n$ = LEFT$(n$, LEN(n$) - 1)
        upd% = 1
      END IF
      IF upd% = 1 THEN
        LINE (0, 120)-(319, 130), 15, BF
        CentreFont 120, n$, 1, 1, 0
        PCOPY 1, 0
        upd% = 0
      END IF
    LOOP UNTIL a$ = CHR$(13)
    tmp = MultiKey(-1)
    defname$ = n$
  END IF
LOOP
END SUB

SUB PlayTrack (yTime#)
REDIM Trail%(8, tLen%)
hldX! = 139
ccntr% = 1
cnr! = .1
cdcc! = .01
dcc! = .03
acc% = 190
grv! = .008
u% = 1
cX% = CINT(hldX!)
cY% = CINT(hldY!)

cFr% = 4
FOR i% = 3 TO 1 STEP -1
  DrawCourse 0
  CentreFont 90, LTRIM$(STR$(i%)), 1, 2, 0
  PCOPY 1, 0
  tmp# = TIMER
  DO: LOOP UNTIL TIMER - tmp# >= 1
  cFr% = cFr% + 1
NEXT i%

t# = TIMER
yt# = TIMER

DO
  IF TIMER - t# >= .07 THEN
    t# = TIMER
    scfr% = scfr% + ccntr%
    IF scfr% >= 3 THEN ccntr% = -1
    IF scfr% <= 0 THEN ccntr% = 1
    cFr% = scfr% + 4
  END IF
  pk% = 0
  yVel! = yVel! + grv!
  IF xVel! < -.5 THEN cFr% = 8
  IF xVel! > .5 THEN cFr% = 10
  IF u% = 1 THEN UserInp xVel!, yVel!, dcc!, cnr!, acc%, scfr%, cdcc!
  IF yVel! < 0 THEN yVel! = 0
  IF pk% = 1 THEN
    yVel! = yVel! / 1.004
  ELSE
    yVel! = yVel! / 1.001
  END IF
  xVel! = xVel! / 1.05
  hldX! = hldX! + xVel!
  hldY! = hldY! + yVel!
  IF hldX! > 299 THEN hldX! = 299: xVel! = 0
  IF hldX! < 0 THEN hldX! = 0: xVel! = 0
  cX% = CINT(hldX!)
  cY% = CINT(hldY!)
  IF (cY% + 20) \ 20 <= cLength% THEN
    IF Course%(1, (cY% + 20) \ 20) = 3 THEN
      pa% = 1
      IF (cX% + 10) \ 20 = Course%(2, (cY% + 20) \ 20) THEN cn% = 1
    ELSE
      IF pa% = 1 THEN pa% = 0: passed% = passed% + 1
      IF cn% = 1 THEN cn% = 0: poles% = poles% + 1
    END IF
  END IF
  IF u% <> 0 THEN
    IF Course%(1, (cY% + 20) \ 20) = 4 AND u% = 1 THEN
      u% = 0
      tot# = (TIMER - yt#)
      IF cX% < 159 THEN dir% = 1
      IF cX% >= 159 THEN dir% = -1
      n# = TIMER
    END IF
  END IF
  IF u% = 0 THEN
    exs% = exs% + 1
    IF exs% > 100 THEN exs% = 100: xit% = 1
    IF TIMER - n# < 1 THEN xVel! = xVel! + (cnr! * dir%)
    IF ABS(xVel!) < .5 THEN
      IF dir% = -1 THEN cFr% = 9
      IF dir% = 1 THEN cFr% = 11
    END IF
    yVel! = yVel! - (cdcc! * 4)
    IF yVel! <= 0 AND xit% = 1 THEN EXIT DO
  END IF
  scr% = cY% - (50 + exs%)
  IF scr% < 0 THEN scr% = 0
  DrawCourse scr%
  IF u% = 1 THEN tm# = (TIMER - yt#) ELSE tm# = tot#
  UpdInfo poles%, tm#, passed%
  PCOPY 1, 0
LOOP UNTIL MultiKey(1)
WaitLetKeyGo 1

yTime# = -1
IF u% = 0 THEN
  yTime# = tot# + ((passed% - poles%) * 5)
  DrawCourse scr%
  t$ = "Course Complete"
  CentreFont 90, t$, 1, 1, 0
  t$ = "Time given: " + DPoint$((yTime#)) + " secs"
  CentreFont 100, t$, 1, 1, 0
  Font 2, 191, "Press <SPACE> to continue.", 1, 1, 0
  PCOPY 1, 0
  DO
  LOOP UNTIL MultiKey(57)
  WaitLetKeyGo 57
END IF
END SUB

SUB SelectCourse (xit%)
sl% = 1
DO
  upd% = 1
  xit% = 0
  hlt% = 0
  DO
    IF MultiKey(72) THEN
      WaitLetKeyGo 72
      sl% = sl% - 1
      IF sl% < 1 THEN sl% = 1
      upd% = 1
    ELSEIF MultiKey(80) THEN
      WaitLetKeyGo 80
      sl% = sl% + 1
      IF sl% > totcourses% THEN sl% = totcourses%
      upd% = 1
    ELSEIF MultiKey(28) THEN
      WaitLetKeyGo 28
      EXIT DO
    ELSEIF MultiKey(1) THEN
      WaitLetKeyGo 1
      xit% = 2
      EXIT DO
    END IF
    IF upd% = 1 THEN
      LINE (0, 0)-(319, 199), 15, BF
      PUT (0, 0), Ary%(4), PSET
      Font 70, 110, "Select a course:", 1, 1, 0
      FOR i% = sl% - 2 TO sl% + 2
        IF i% >= 1 AND i% <= totcourses% THEN
          IF (i% - sl%) >= -1 AND (i% - sl%) <= 1 THEN
            IF sl% = i% THEN c% = 12 ELSE c% = 1
            CentreFont 140 + ((i% - sl%) * 20), RTRIM$(Dat(1, i%)), c%, 2, 1
          END IF
        END IF
      NEXT i%
      Font 2, 191, "Press <ESC> to go back, up and down arrow keys select a course.", 1, 1, 0
      PCOPY 1, 0
      upd% = 0
    END IF
  LOOP
  IF xit% <> 2 THEN
    cCourse% = sl%
    DO
      ShowTrackPrev xit%
      IF xit% = 1 THEN
        PlayTrack yTime#
        IF yTime# > 0 THEN UpdBestTimes yTime#
      END IF
    LOOP UNTIL xit% <> 1
    xit% = 0
  END IF
LOOP UNTIL xit% <> 0
IF xit% = 2 THEN xit% = -1 ELSE xit% = 0
END SUB

SUB ShowTrackPrev (xit%)
sl% = cCourse%
LINE (0, 0)-(319, 199), 15, BF
PUT (0, 0), Bk%(4), PSET
Font 10, 10, "Course: " + RTRIM$(Dat(1, sl%)), 1, 2, 1
LoadCourse RTRIM$(Dat(0, sl%))
add% = 25
Font 270, add% - 9, "Map:", 1, 1, 0
FOR i% = 1 TO cLength%
  c% = 0
  IF Course%(1, i%) = 2 THEN c% = 7
  IF Course%(1, i%) = 3 THEN c% = 12
  IF c% <> 0 THEN PSET (Course%(2, i%) + 270, i% + add%), c%
NEXT i%
PCOPY 1, 0
Font 30, 60, "Best Times:", 1, 2, 1
FOR i% = 1 TO 5
  IF hlt% = i% THEN
    Font 30, (i% * 10) + 70, RTRIM$(HiScore(i%, sl%).PName), 12, 1, 0
    Font 130, (i% * 10) + 70, LTRIM$(DPoint(HiScore(i%, sl%).Score)), 12, 1, 0
  ELSE
    Font 30, (i% * 10) + 70, RTRIM$(HiScore(i%, sl%).PName), 1, 1, 0
    Font 130, (i% * 10) + 70, LTRIM$(DPoint(HiScore(i%, sl%).Score)), 1, 1, 0
  END IF
NEXT i%
Font 2, 191, "Use left and right arrow keys to select.", 1, 1, 0
PCOPY 1, 0
upd% = 1: s% = 1: xit% = 1
DO
  IF MultiKey(75) THEN
    WaitLetKeyGo 75
    s% = 1: upd% = 1
    xit% = 1
  ELSEIF MultiKey(77) THEN
    WaitLetKeyGo 77
    s% = 2: upd% = 1
    xit% = 0
  ELSEIF MultiKey(28) THEN
    WaitLetKeyGo 28
    EXIT DO
  ELSEIF MultiKey(1) THEN
    WaitLetKeyGo 1
    s% = 2: xit% = 0
    EXIT DO
  END IF
  IF upd% = 1 THEN
    IF s% = 1 THEN
      Font 30, 150, "Start", 12, 2, 1
      Font 100, 150, "Back", 1, 2, 1
    ELSEIF s% = 2 THEN
      Font 30, 150, "Start", 1, 2, 1
      Font 100, 150, "Back", 12, 2, 1
    END IF
    upd% = 0
    PCOPY 1, 0
  END IF
LOOP
END SUB

SUB Tracks (x1%, y1%, x2%, y2%)
FOR i% = -10 TO 10 STEP 4
  LINE (x1% + i%, y1%)-(x2% + i%, y2%), 7
NEXT i%
END SUB

SUB UpdBestTimes (t#)
FOR i% = 1 TO 5
  f% = 1
  IF HiScore(i%, cCourse%).Score > t# THEN f% = 0: EXIT FOR
NEXT i%
IF f% = 1 THEN hlt% = 0: EXIT SUB
z% = i%
FOR i% = 5 TO z% STEP -1
  HiScore(i%, cCourse%).PName = HiScore(i% - 1, cCourse%).PName
  HiScore(i%, cCourse%).Score = HiScore(i% - 1, cCourse%).Score
NEXT i%
tmp = MultiKey(-2)
upd% = 1
tm$ = DPoint(t#) + " secs"
n$ = defname$
DO
  a$ = INKEY$
  IF Valid(a$, 1) AND LEN(n$) < 12 THEN
    n$ = n$ + a$
    upd% = 1
  ELSEIF a$ = CHR$(8) AND LEN(n$) > 0 THEN
    n$ = LEFT$(n$, LEN(n$) - 1)
    upd% = 1
  END IF
  IF upd% = 1 THEN
    LINE (0, 0)-(319, 199), 15, BF
    PUT (0, 0), Bk%(4), PSET
    Font 9, 9, "New Record!", 1, 2, 1
    Font 309 - FontLength(tm$, 2, 1), 9, tm$, 1, 2, 0
    CentreFont 50, "Enter name:", 1, 1, 0
    CentreFont 60, n$, 1, 1, 0
    Font 2, 191, "Type name for best times. <ENTER> when done.", 1, 1, 0
    PCOPY 1, 0
    upd% = 0
  END IF
LOOP UNTIL a$ = CHR$(13)
tmp = MultiKey(-1)
hlt% = z%
IF n$ = "" THEN n$ = "Anon"
HiScore(z%, cCourse%).PName = n$
HiScore(z%, cCourse%).Score = VAL(DPoint(t#))
END SUB

SUB UpdInfo (poles%, tm#, passed%)
'LOCATE 25, 1: PRINT SPACE$(40);
'LOCATE 25, 1: PRINT USING "### / ###  ####.## secs _+ ### sec pen"; poles%; totpoles%; tm#; (passed% - poles%) * 5;
't$ = DPoint$(CDBL(yvel!))
'Font 275 - FontLength%(t$, 1, 0), 160, t$ + " speed", 1, 1, 0
t$ = LTRIM$(STR$(poles%))
Font 275 - FontLength%(t$, 1, 0), 170, t$ + "/" + LTRIM$(STR$(totpoles%)), 1, 1, 0
t$ = DPoint$(tm#)
Font 275 - FontLength%(t$, 1, 0), 180, t$ + " seconds", 1, 1, 0
t$ = LTRIM$(STR$((passed% - poles%) * 5))
Font 275 - FontLength%(t$, 1, 0), 190, t$ + " penalty", 1, 1, 0
END SUB

SUB UserInp (xVel!, yVel!, dcc!, cnr!, acc%, scfr%, cdcc!)
IF MultiKey(75) THEN
  xVel! = xVel! - cnr!
  yVel! = yVel! - cdcc!
  cFr% = 8
  IF xVel! < -1.5 THEN cFr% = 9
  pk% = 1
ELSEIF MultiKey(77) THEN
  xVel! = xVel! + cnr!
  yVel! = yVel! - cdcc!
  cFr% = 10
  IF xVel! > 1.5 THEN cFr% = 11
  pk% = 1
END IF
IF MultiKey(72) THEN
  yVel! = yVel! - dcc!
  pk% = 1
END IF
IF pk% <> 1 THEN
  IF MultiKey(80) THEN
    yVel! = yVel! + ((5 - yVel!) / acc%)
    cFr% = scfr%
    pk% = 1
  END IF
END IF
IF yVel! < .3 THEN yVel! = .3
END SUB

FUNCTION Valid% (Text$, chrset%)
IF LEN(Text$) <> 1 THEN EXIT FUNCTION
IF chrset% = 1 THEN ValidCharacter$ = "ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz1234567890-=_+!" + CHR$(34) + "$%^&*()`,./><?;'#:@~[]{}\|"
IF chrset% = 2 THEN ValidCharacter$ = "1234567890"
FOR i% = 1 TO LEN(ValidCharacter$)
  IF Text$ = MID$(ValidCharacter$, i%, 1) THEN Valid% = 1
NEXT i%
END FUNCTION

SUB WaitLetKeyGo (n%)
DO
LOOP WHILE MultiKey(n%)
END SUB

