DECLARE SUB Start ()
DECLARE SUB LoadWords ()
DECLARE SUB Check ()
DECLARE SUB WordRecognition ()
DECLARE SUB Engine ()
DECLARE SUB KeyInput ()
TYPE Sentence         'What to do with the Sentence: (word number, example: Word$(Verb)= "VERB")
 Verb AS INTEGER      ' Verb       : Do this (main mode in his consciosness: mode "look", mode "take", etc)
 Verb2 AS INTEGER     ' Extra Verb : example (GO and TALK to him)
 Verb3 AS INTEGER     ' Extra Verb : example (TRY to TAKE a ~LOOK~ to the man)
 Obj AS INTEGER       ' Object     : to this thing (look, take, put, etc)
 Pers AS INTEGER      ' Person     : or to this person (talk to, give, kiss, etc)
 Loct AS INTEGER      ' Location   : where it lies
                      ' of course there are many other words he should recognize
                      ' like : the, a, to, at, under etc, but there are so many
                      ' possibilities that it can't be done in a short version
END TYPE

TYPE Consciosness       ' The human "A.I."
 Mode AS INTEGER        ' Example: Mode "GIVE" means he has to move an
 Obj AS STRING * 30     ' "OBJECT" from his inventory, and give it to a
 Pers AS STRING * 30    ' "PERSON", and the goal of this whole engine (once it's done)
                        ' is to really simulate human thoughts
END TYPE
TYPE Words
 Ln AS INTEGER        'The length of the sentence
 Lw AS INTEGER        'The number of the last word
 Spac AS INTEGER      'The number of spaces
END TYPE
TYPE Inpt
 x AS INTEGER         'x-co. of input-line
 y AS INTEGER         'y-co.
 xo AS INTEGER        'Original x-co.
 yo AS INTEGER        'Original y-co.
END TYPE

DIM SHARED W AS Words, S AS Sentence, I AS Inpt, C AS Consciosness
DIM SHARED Sp(20), Word$(21), Verb$(100), Obj$(100), n$, Letter$, Sentence$

CLS
LoadWords
Start

DO
 KeyInput
LOOP

SUB Check STATIC

CLS                                            'this part is a simple
PRINT                                          'check if all words are there
PRINT "Length of words:"; W.Ln
PRINT "Number of spaces:"; W.Spac
PRINT "Number of words: "; W.Lw
PRINT

FOR n = 1 TO W.Spac
PRINT "Word"; n; ":"; LEN(Word$(n)); " : "; Word$(n)
NEXT n
PRINT "Lastw. :"; LEN(Word$(W.Lw)); " : "; Word$(W.Lw)

END SUB

SUB Engine STATIC

FOR m = 1 TO W.Lw                             ' This is a simple demo how the
 FOR n = 1 TO 99                              ' engine can recognize verbs
  IF Word$(m) = Verb$(n) THEN                 ' and put it in the "A.I." as
   S.Verb = m                                 ' C.mode
   C.Mode = n                                 ' also the needed parts of the
   PRINT Verb$(n); S.Verb; C.Mode: SLEEP      ' A.I. are OBJECTS, LOCATIONS,
  END IF                                      ' PERSONS, little things like
 NEXT n                                       ' "the, a, in, out, at", etc etc
NEXT m


LOCATE (25), (2)
 COLOR 15
  PRINT ">- ";
 COLOR 7
FOR f = 1 TO W.Lw
 IF f = S.Verb THEN
  COLOR 2
  PRINT Word$(S.Verb); " ";
  COLOR 7
 END IF
 IF f <> S.Verb THEN
  PRINT Word$(f); " ";
 END IF
NEXT f
 COLOR 15
  PRINT "<-";
 COLOR 7

SLEEP

END SUB

SUB KeyInput STATIC

IF Begin = 0 THEN                     'this is all just an improvisation
 CLS
 Begin = 1
 S1 = 0
 I.xo = 2
 I.yo = 23
 I.x = I.xo - 1
 I.y = I.yo
 W.Spac = 0
 W.Lw = 0
 W.Ln = 0
 Sentence$ = ""
 FOR n = 1 TO 21: Word$(n) = "": NEXT n
 
 LOCATE (I.y), (I.x)
 PRINT "><"
END IF

Key$ = INKEY$

IF Key$ <> "" THEN
 IF Key$ = CHR$(27) THEN CLS : END                    'Esc-key
 IF Key$ = CHR$(13) THEN                              'Enter-key
  IF LEN(Sentence$) > 0 AND Sentence$ <> " " THEN     ' It only works when there
   Begin = 0                                          ' is an actual sentence
   WordRecognition                                    ' Then it sends the Sentence further.
  END IF
 END IF
 IF Key$ = CHR$(8) THEN                               'BackSpace
  IF LEN(Sentence$) > 0 THEN                          ' Only if there are any
   Sentence$ = LEFT$(Sentence$, LEN(Sentence$) - 1)   ' letters left
   LOCATE (I.yo), (I.xo): PRINT Sentence$; "< "
   I.x = I.x - 1
  END IF
 END IF
IF LEN(Sentence$) < 80 - I.xo THEN                    'This part only works if
 Key$ = UCASE$(Key$)                                  'there is less then one
 IF Key$ <> "" THEN Inkey = ASC(MID$(Key$, 1, 1))     'input-line on the screen
  SELECT CASE Inkey
   CASE 65 TO 90                                      'Letters A to Z
    I.x = I.x + 1                                     'IF A-Z THEN print them
    Sentence$ = Sentence$ + Key$                      'in the input-line
    LOCATE (I.y), (I.x)
    PRINT Key$; "<"
   CASE 32
    IF RIGHT$(Sentence$, 1) <> " " AND S1 < 19 THEN   'Space
     S1 = S1 + 1                                      'It only works when!!!:
     I.x = I.x + 1                                    '-there are no two spaces
     Sentence$ = Sentence$ + " "                      'in a row
     LOCATE (I.y), (I.x)                              '-there are less then 19
     PRINT Key$; "<"                                  'spaces in the sentence
    END IF
  END SELECT
END IF
END IF
END SUB

SUB LoadWords STATIC

OPEN "Verbs.wrd" FOR INPUT AS #1       'The program loads all useful verbs,
 FOR n% = 1 TO 99                      'objects, etc. from the files in the
  IF EOF(1) THEN EXIT FOR              'memory, one by one, which can be
  LINE INPUT #1, Verb$(n%)             'accessed later, when the program
 NEXT n%                               'compares them with the words from
CLOSE #1                               'the Input-line, so it can determine the
                                       'structure of the sentence.
END SUB

SUB Start
PRINT
PRINT " This is just a short demo of the new engine, which will hopefully have"
PRINT "real 'A.I.', examples of what can be done:"
PRINT ""
PRINT " -S.G. can recognize all parts of a sentence, like Objects, Persons, Verbs..."
PRINT " -S.G. can recognize verbs"
PRINT " -He could understand them!!!!!! example:"
PRINT "    TAKE means: take OBJECT (from a LOCATION) and put it in the inventory"
PRINT "    GO means: he moves himself to a LOCATION"
PRINT "    LOOK (this is a little bit tricky): for he can't actually tell what"
PRINT "     he sees, he must use an Instinct!!!, so he looks into his memory and"
PRINT "     repeats the line for that OBJECT"
PRINT "    TALK (even trickier): a controlable instinct: he goes to a PERSON but"
PRINT "     the player controls the conversation, like choice 1, choice 2, etc"
PRINT " There are much (much) more verbs that he could understand, and much"
PRINT "  feelings!! the program could simulate, but this is of course a short"
PRINT "  demo, only made to see what possibilities SmartGuy has, actually I have an"
PRINT "  almost finished Engine, but it's not at the edge of the possibilities, so"
PRINT "  I made this demo. To short up the story: If the SmartGuy is ever to be"
PRINT "  done, it will use this kind of engine, and not the old one"
PRINT ""
PRINT "  Any comments: Bih1@Hotmail.com"
SLEEP
END SUB

SUB WordRecognition STATIC

n$ = LTRIM$(Sentence$)              'This Sub splits the sentence from KeyInput
n$ = RTRIM$(n$)                     'into words, it locates the spaces between
W.Ln = LEN(n$)                      'the words, and puts the words into the memory

IF W.Ln > 0 THEN
 FOR n = 1 TO W.Ln
  IF MID$(n$, n, 1) = " " THEN W.Spac = W.Spac + 1       'Search for spaces
 NEXT n

 IF W.Spac > 0 THEN                          'If there are any then:
  FOR n = 1 TO W.Spac
   Sp(n) = INSTR(Sp(n - 1) + 1, n$, " ")
  NEXT n
 END IF
Sp(W.Spac + 1) = W.Ln
W.Lw = W.Spac + 1

FOR wn = 0 TO W.Spac
 Word$(wn + 1) = MID$(n$, Sp(wn) + 1, Sp(wn + 1) - Sp(wn))
 Word$(wn + 1) = LTRIM$(Word$(wn + 1))
 Word$(wn + 1) = RTRIM$(Word$(wn + 1))
NEXT wn
END IF

Check
Engine

END SUB

