'
'                       ͻ
'                        LEVEL EDITOR FOR:        
'                                                 
'                        QBasic Snake Version 1.0 
'                       ͹
'                        (c) 1999  Dominik Kaspar 
'                       ͼ
'
'
'                 for comments write to pedok@pop.agri.ch
'             
DECLARE SUB DetectWorkingDir ()
DECLARE SUB SwitchKeys (State$)
DECLARE SUB DeleteLevel ()
DECLARE SUB SavePrompt ()
DECLARE SUB PlaceSnake (x!, y!, XPos, YPos)
DECLARE SUB EDITOR ()
DECLARE SUB DrawLevel ()
DECLARE SUB EditLevel ()
DECLARE SUB ReallyQuit ()
DECLARE SUB FontPrint (XPos, YPos, Text$, Colour, Rotate)
DECLARE SUB PromptFileName ()
DECLARE SUB LoadFont ()
DECLARE SUB SaveLevel (Affirm)

TYPE LevRecType
     StartX   AS INTEGER
     StartY   AS INTEGER
     StartDir AS INTEGER
     LevString AS STRING * 3200
END TYPE

DIM SHARED LevRec AS LevRecType

DIM SHARED Font AS STRING * 30
DIM SHARED FontChar(0 TO 127, 1 TO 5, 1 TO 6) AS INTEGER

DIM SHARED Level(1 TO 80, 1 TO 40) AS INTEGER
DIM SHARED ClipBoard(1 TO 80, 1 TO 40) AS INTEGER
DIM SHARED FileName$, CurDir$
DIM SHARED LevelNo, LevelTot AS INTEGER

ON KEY(1) GOSUB Help
ON KEY(2) GOSUB Copy
ON KEY(3) GOSUB Paste

DetectWorkingDir
'CurDir$ = "C:\QB45\QBSNAKE\"

LoadFont

SCREEN 7

PromptFileName

EDITOR

Help:
  SwitchKeys "OFF"
  PCOPY 0, 2

  LINE (51, 46)-(255, 190), 0, BF

  FontPrint 60, 55, "[ARROW KEYS] = Move cursor", 7, 0
  FontPrint 60, 65, "[SPACE]      = toggle draw mode", 7, 0
  FontPrint 60, 85, "[F2] = COPY    [F3] = PASTE", 7, 0
  FontPrint 60, 105, "[P] = Place Start Position", 7, 0
  FontPrint 60, 115, "      of Snake", 7, 0
  FontPrint 60, 125, "[C] = Clear Screen", 7, 0
  FontPrint 60, 135, "[S] = Save current File", 7, 0
  FontPrint 60, 145, "[N] = Add New Level", 7, 0
  FontPrint 60, 155, "[L] = Edit an other Level", 7, 0
  FontPrint 60, 165, "[F] = Edit an other File", 7, 0
  FontPrint 60, 175, "[D] = Delete current level", 7, 0

  DO: LOOP UNTIL LEN(INKEY$)

  PCOPY 2, 0
  SwitchKeys "ON"
RETURN

Copy:
  SwitchKeys "OFF"
  PCOPY 0, 2
  LINE (100, 80)-(220, 105), 0, BF
  FontPrint 110, 90, "Copying level...", 7, 0
  FOR y = 1 TO 40
      FOR x = 1 TO 80
          ClipBoard(x, y) = Level(x, y)
      NEXT x
  NEXT y
  PCOPY 2, 0
  SwitchKeys "ON"
RETURN

Paste:
  SwitchKeys "OFF"
  PCOPY 0, 2
        LINE (51, 60)-(230, 125), 0, BF
        FontPrint 60, 70, "Choose how the ClipBoard", 7, 0
        FontPrint 60, 80, "should be pasted:", 7, 0
        FontPrint 60, 100, "[O] = OPAQUE", 7, 0
        FontPrint 60, 110, "[T] = TRANSPARENT", 7, 0
ENTERPASTEMODE:
        a$ = "": DO: a$ = UCASE$(INKEY$): LOOP UNTIL LEN(a$)
        SELECT CASE a$
          CASE "O", "T": PCOPY 2, 0
               FOR y = 1 TO 40
                   FOR x = 1 TO 80
                       IF a$ = "O" THEN
                          Level(x, y) = ClipBoard(x, y)
                       ELSE
                          IF ClipBoard(x, y) THEN
                             Level(x, y) = ClipBoard(x, y)
                          END IF
                       END IF
                       XPos = x + 3 * x - 4
                       YPos = 39 + y + 3 * y - 3
                       IF (x <> LevRec.StartX OR y <> LevRec.StartY) THEN
                          IF Level(x, y) THEN c = 7 ELSE c = 8
                       ELSE
                          c = 4
                       END IF
                       LINE (XPos, YPos)-(XPos + 2, YPos + 2), c, BF
                   NEXT x
               NEXT y
          CASE ELSE: GOTO ENTERPASTEMODE
        END SELECT
  SwitchKeys "ON"
RETURN

SUB DeleteLevel

 OPEN "QBSNAKE.TMP" FOR RANDOM AS #2 LEN = LEN(LevRec)

 LINE (70, 67)-(240, 78), 7, B

 i = 0
 FOR rec = 1 TO LevelTot - 1
     IF rec = LevelNo THEN i = 1
     GET #1, rec + i, LevRec
     PUT #2, rec, LevRec
     LINE (72, 69)-(72 + rec * 166 / (LevelTot - 1), 76), 4, BF
 NEXT rec

 CLOSE #1, #2
 KILL FileName$
 NAME "QBSNAKE.TMP" AS FileName$

 OPEN FileName$ FOR RANDOM AS #1 LEN = LEN(LevRec)

 LevelTot = LOF(1) / 3200
 IF LevelNo > LevelTot THEN LevelNo = LevelTot
 GET #1, LevelNo, LevRec

END SUB

SUB DetectWorkingDir

 CurDir$ = ""

 OPEN "QBSNAKE.FNT" FOR RANDOM AS #1 LEN = LEN(Font)
      IF LOF(1) > 0 THEN
         CLOSE #1
         EXIT SUB
      END IF
 CLOSE #1
 KILL "QBSNAKE.FNT"

 PRINT "Detecting working directory...";

 SHELL "CD\"
 SHELL "DIR QBSNAKE.FNT /S /B > QBSNAKE.TMP"

 OPEN "QBSNAKE.TMP" FOR INPUT AS #1

 IF LOF(1) = 0 THEN
    PRINT : PRINT
    PRINT "ERROR: Could not detect working directory."
    PRINT "       There is a file missing (QBSNAKE.FNT)"
    PRINT
    SYSTEM
 END IF

 LINE INPUT #1, CurDir$
 CurDir$ = RTRIM$(LTRIM$(UCASE$(CurDir$)))

 FOR i = 1 TO LEN(CurDir$)
     IF MID$(CurDir$, i, 11) = "QBSNAKE.FNT" THEN
        CurDir$ = UCASE$(LEFT$(CurDir$, i - 1))
        EXIT FOR
     END IF
 NEXT i
 IF RIGHT$(CurDir$, 1) <> "\" THEN CurDir$ = CurDir$ + "\"

 CLOSE #1
 KILL "QBSNAKE.TMP"

 PRINT "OK."

END SUB

SUB DrawLevel

 ERASE Level

 i = 0
 FOR y = 1 TO 40
     FOR x = 1 TO 80
         i = i + 1
         XPos = x + 3 * x - 4
         YPos = 39 + y + 3 * y - 3
         IF MID$(LevRec.LevString, i, 1) = "0" THEN
            Level(x, y) = 0
            c = 8
         ELSE
            Level(x, y) = 1
            c = 7
         END IF
         LINE (XPos, YPos)-(XPos + 2, YPos + 2), c, BF
     NEXT x
 NEXT y

 x = LevRec.StartX + 3 * LevRec.StartX - 5
 y = 39 + LevRec.StartY + 3 * LevRec.StartY - 4
 LINE (x + 1, y + 1)-(x + 3, y + 3), 4, BF

END SUB

SUB EditLevel

 SavePrompt

 LINE (51, 60)-(250, 115), 0, BF
 FontPrint 60, 70, "Which level would you like", 7, 0
 FontPrint 60, 80, "to edit:", 7, 0
 FontPrint 60, 100, "Total levels:" + STR$(LevelTot), 7, 0

 Lev$ = ""
LEVELPROMPT:
 FontPrint 120, 80, Lev$ + STRING$(4 - LEN(Lev$), "_"), 7, 2
 Key$ = ""
 DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)

 SELECT CASE ASC(UCASE$(Key$))
   CASE 48 TO 57
        IF LEN(Lev$) < 8 THEN
           Lev$ = Lev$ + Key$
        END IF
   GOTO LEVELPROMPT
   CASE 8:
        IF LEN(Lev$) > 0 THEN
           Lev$ = LEFT$(Lev$, LEN(Lev$) - 1)
        END IF
        GOTO LEVELPROMPT
   CASE 13: IF VAL(Lev$) < 1 OR VAL(Lev$) > LevelTot THEN GOTO LEVELPROMPT
   CASE 27: ReallyQuit
            GOTO LEVELPROMPT
   CASE ELSE: GOTO LEVELPROMPT
 END SELECT

 CLS

 LevelNo = VAL(Lev$)
 GET #1, LevelNo, LevRec

END SUB

SUB EDITOR

EDITORSTART:

CLS

FontPrint 5, 5, "LEVEL EDITOR", 4, 0
FontPrint 120, 5, "[ESC] = EXIT", 7, 0
FontPrint 120, 15, "[F1]  = QUICK HELP", 7, 0
FontPrint 120, 25, "[  ]  = SNAKE STARTING POINT", 7, 0
LINE (130, 27)-(132, 29), 4, BF
FontPrint 5, 25, "Level" + STR$(LevelNo) + "/" + LTRIM$(STR$(LevelTot)), 7, 0

DrawLevel

DrawMode = 0
XPos = 3: YPos = 3
IF XPos = LevRec.StartX AND YPos = LevRec.StartY THEN XPos = 77: YPos = 37

PROMPT:

FontPrint 270, 5, "(" + LTRIM$(STR$(XPos)) + "," + LTRIM$(STR$(YPos)) + "]  ", 7, 2

x = XPos + 3 * XPos - 5
y = 39 + YPos + 3 * YPos - 4
LINE (x, y)-(x + 4, y + 4), 9, B

IF DrawMode = 0 THEN
   Level(XPos, YPos) = 0
   LINE (x + 1, y + 1)-(x + 3, y + 3), 8, BF
ELSE
   Level(XPos, YPos) = 1
   LINE (x + 1, y + 1)-(x + 3, y + 3), 7, BF
END IF

WAITFORKEY:
SwitchKeys "ON"
Key$ = "": DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
SwitchKeys "OFF"

SELECT CASE UCASE$(Key$)
  CASE CHR$(0) + "H": YPos = YPos - 1
       IF XPos = LevRec.StartX AND YPos = LevRec.StartY THEN YPos = YPos + 1
       IF YPos = 0 THEN YPos = 40
  CASE CHR$(0) + "K": XPos = XPos - 1
       IF XPos = LevRec.StartX AND YPos = LevRec.StartY THEN XPos = XPos + 1
       IF XPos = 0 THEN XPos = 80
  CASE CHR$(0) + "M": XPos = XPos + 1
       IF XPos = LevRec.StartX AND YPos = LevRec.StartY THEN XPos = XPos - 1
       IF XPos = 81 THEN XPos = 1
  CASE CHR$(0) + "P": YPos = YPos + 1
       IF XPos = LevRec.StartX AND YPos = LevRec.StartY THEN YPos = YPos - 1
       IF YPos = 41 THEN YPos = 1
  CASE CHR$(32): DrawMode = 1 - DrawMode
       IF XPos = LevRec.StartX AND YPos = LevRec.StartY THEN GOTO WAITFORKEY
  CASE CHR$(27): ReallyQuit
                 GOTO WAITFORKEY
  CASE "P": PlaceSnake x, y, XPos, YPos
            GOTO WAITFORKEY
  CASE "S": SaveLevel 1
            GOTO WAITFORKEY
  CASE "L": IF LevelTot = 0 THEN GOTO WAITFORKEY
            EditLevel
            GOTO EDITORSTART
  CASE "F": SavePrompt
            CLOSE #1
            CLS
            PromptFileName
            GOTO EDITORSTART
  CASE "N": PCOPY 0, 2
            IF LevelNo = LevelTot + 1 THEN
               LINE (60, 60)-(270, 86), 0, BF
               FontPrint 70, 70, "You already work on a new level", 7, 0
               DO: LOOP UNTIL LEN(INKEY$)
               PCOPY 2, 0
               GOTO WAITFORKEY
            END IF
            SavePrompt
            LevelNo = LevelTot + 1
            LevRec.LevString = STRING$(3200, "0")
            PCOPY 2, 0
            GOTO EDITORSTART
  CASE "C": PCOPY 0, 2
            LINE (60, 80)-(260, 105), 0, BF
            FontPrint 70, 90, "Clear the entire level (Y/N)?", 7, 0
            a$ = "": DO: a$ = INKEY$: LOOP UNTIL LEN(a$)
            PCOPY 2, 0
            IF UCASE$(a$) = "Y" THEN
               LevRec.LevString = STRING$(3200, "0")
               DrawLevel
            END IF
            GOTO WAITFORKEY
  CASE "D": PCOPY 0, 2
              LINE (60, 60)-(250, 85), 0, BF
              IF LevelTot < LevelNo THEN
                 FontPrint 70, 70, "There is no level to delete!", 7, 0
                 DO: LOOP UNTIL LEN(INKEY$)
              ELSEIF LevelTot = 1 AND LevelNo = 1 THEN
                 FontPrint 70, 70, "error! clear level instead...", 7, 0
                 DO: LOOP UNTIL LEN(INKEY$)
              ELSE
                 FontPrint 70, 70, "Delete Current Level (Y/N)?", 7, 0
                 a$ = "": DO: a$ = INKEY$: LOOP UNTIL LEN(a$)
                 IF UCASE$(a$) = "Y" THEN
                    LINE (60, 60)-(250, 85), 0, BF
                    DeleteLevel
                    GOTO EDITORSTART
                 END IF
              END IF
            PCOPY 2, 0
            GOTO WAITFORKEY
  CASE ELSE: GOTO WAITFORKEY
END SELECT

LINE (x, y)-(x + 4, y + 4), 0, B

GOTO PROMPT

END SUB

SUB FontPrint (XPos, YPos, Text$, Colour, Rotate)

 FOR TextPos = 1 TO LEN(Text$)
     FOR x = 1 TO 5
         FOR y = 1 TO 6
             SELECT CASE FontChar(ASC(MID$(Text$, TextPos, 1)), x, y)
               CASE 0:
                 IF Rotate = 2 THEN
                    PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), 0
                 END IF
               CASE 1:
                 IF Rotate = 1 THEN
                    PSET (XPos + x - 1, YPos + y - 1 + TextPos * 7 - 7), Colour
                 ELSE
                    PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), Colour
                 END IF
             END SELECT
         NEXT y
     NEXT x
 NEXT TextPos

END SUB

SUB LoadFont

 OPEN CurDir$ + "QBSNAKE.FNT" FOR RANDOM AS #1 LEN = LEN(Font)

 IF LOF(1) = 0 THEN
    PRINT "Fatal Error: Couldn't find file QBSNAKE.FNT"
    DO: LOOP UNTIL LEN(INKEY$)
    CLOSE #1
    KILL "QBSNAKE.FNT"
    END
 END IF

 PRINT "Loading Font...";

 FOR rec = 1 TO 127
     GET #1, rec, Font
     x = 0
     y = 1
     FOR CodePos = 1 TO 30
         IF x = 5 THEN x = 0: y = y + 1
         x = x + 1
         FontChar(rec, x, y) = VAL(MID$(Font, CodePos, 1))
     NEXT CodePos
 NEXT rec

 CLOSE #1

 PRINT "OK."

END SUB

SUB PlaceSnake (x, y, XPos, YPos)
 
 a = LevRec.StartX + 3 * LevRec.StartX - 5
 B = 39 + LevRec.StartY + 3 * LevRec.StartY - 4
 LINE (a + 1, B + 1)-(a + 3, B + 3), 8, BF
 LevRec.StartX = XPos: LevRec.StartY = YPos
 LINE (x + 1, y + 1)-(x + 3, y + 3), 4, BF
 PCOPY 0, 3
       LINE (51, 60)-(250, 145), 0, BF
       FontPrint 60, 70, "Enter Starting Direction", 7, 0
       FontPrint 60, 80, "of Snake:", 7, 0
       FontPrint 60, 100, "[U] = Up", 7, 0
       FontPrint 60, 110, "[D] = Down", 7, 0
       FontPrint 60, 120, "[L] = Left", 7, 0
       FontPrint 60, 130, "[R] = Right", 7, 0
ENTERDIRECTION:
       a$ = "": DO: a$ = INKEY$: LOOP UNTIL LEN(a$)
       SELECT CASE UCASE$(a$)
              CASE "U": LevRec.StartDir = 1
              CASE "D": LevRec.StartDir = 4
              CASE "L": LevRec.StartDir = 2
              CASE "R": LevRec.StartDir = 3
              CASE ELSE: GOTO ENTERDIRECTION
       END SELECT
 PCOPY 3, 0

END SUB

SUB PromptFileName

 FontPrint 5, 10, "Choose a Level File to edit,", 7, 0
 FontPrint 5, 20, "Enter any name to create a new one.", 7, 0
 FontPrint 230, 180, "[ESC] = Quit", 8, 0

 SHELL "DIR /B /ON " + CurDir$ + "*.LEV > " + CurDir$ + "QBSNAKE.TMP"
 
 OPEN CurDir$ + "QBSNAKE.TMP" FOR INPUT AS #2
   IF LOF(2) = 0 THEN
      FontPrint 5, 50, "[No Files Found]", 1, 0
      FontPrint 5, 70, CHR$(26) + " create a new one or quit", 1, 0
   ELSE
      rec = 0: XPos = 5
      DO
        INPUT #2, File$
        rec = rec + 1
        FontPrint XPos, 30 + rec * 10, File$ + SPACE$(10), 1, 2
        IF rec = 13 THEN
           rec = 0: XPos = XPos + 80
        END IF
      LOOP UNTIL EOF(2)
   END IF
 CLOSE #2
 KILL CurDir$ + "QBSNAKE.TMP"

 FontPrint 5, 180, "Enter filename: ", 7, 0
 FontPrint 160, 180, ".LEV", 7, 0

 FileName$ = ""
FILEPROMPT:
 FontPrint 110, 180, FileName$ + STRING$(8 - LEN(FileName$), "_"), 7, 2
 Key$ = ""
 DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)

 SELECT CASE ASC(UCASE$(Key$))
   CASE 48 TO 57, 65 TO 90, 95:
        IF LEN(FileName$) < 8 THEN
           FileName$ = FileName$ + Key$
        END IF
   GOTO FILEPROMPT
   CASE 8:
        IF LEN(FileName$) > 0 THEN
           FileName$ = LEFT$(FileName$, LEN(FileName$) - 1)
        END IF
        GOTO FILEPROMPT
   CASE 13: IF LEN(FileName$) = 0 THEN GOTO FILEPROMPT
            FileName$ = FileName$ + ".LEV"
   CASE 27: ReallyQuit
            GOTO FILEPROMPT
   CASE ELSE: GOTO FILEPROMPT
 END SELECT

 FileName$ = CurDir$ + FileName$
 OPEN FileName$ FOR RANDOM AS #1 LEN = LEN(LevRec)

 LevRec.StartX = 20
 LevRec.StartY = 19
 LevRec.StartDir = 4
 LevRec.LevString = STRING$(3200, "0")

 LevelTot = LOF(1) / 3200
 LevelNo = LevelTot + 1

END SUB

SUB ReallyQuit

 PCOPY 0, 2
   LINE (60, 60)-(250, 95), 0, BF
   FontPrint 70, 70, "Do you really want to", 7, 0
   FontPrint 70, 80, "quit the program (Y/N)?", 7, 0
   a$ = "": DO: a$ = INKEY$: LOOP UNTIL LEN(a$)
   IF UCASE$(a$) = "Y" THEN END
 PCOPY 2, 0

END SUB

SUB SaveLevel (Affirm)
      
 PCOPY 0, 1

 IF Affirm THEN
    LINE (60, 80)-(259, 126), 0, BF
    FontPrint 70, 90, "Are you sure, that you want", 7, 0
    FontPrint 70, 110, "to save Level" + STR$(LevelNo) + " (Y/N)?", 7, 0
    Ans$ = "": DO: Ans$ = INKEY$: LOOP UNTIL LEN(Ans$)
 ELSE
    Ans$ = "Y"
 END IF

 IF UCASE$(Ans$) = "Y" THEN
    LINE (60, 80)-(260, 130), 0, BF
    FontPrint 70, 90, "Saving Level" + STR$(LevelNo), 7, 0
    LINE (70, 110)-(250, 120), 7, B
    LevRec.LevString = ""
    FOR y = 1 TO 40
        FOR x = 1 TO 80
            Bit$ = LTRIM$(RTRIM$(STR$(Level(x, y))))
            MID$(LevRec.LevString, (y - 1) * 80 + x, 1) = Bit$
        NEXT x
        LINE (72, 112)-(72 + y * 176 / 40, 118), 4, BF
    NEXT y
    PUT #1, LevelNo, LevRec
 END IF

 PCOPY 1, 0

 LevelTot = LOF(1) / 3200
 FontPrint 5, 25, "Level" + STR$(LevelNo) + "/" + LTRIM$(STR$(LevelTot)), 7, 2

END SUB

SUB SavePrompt

 LINE (60, 60)-(250, 95), 0, BF
 FontPrint 70, 70, "Do you want to save the", 7, 0
 FontPrint 70, 80, "current level (Y/N)?", 7, 0
 a$ = "": DO: a$ = INKEY$: LOOP UNTIL LEN(a$)
 IF UCASE$(a$) = "Y" THEN SaveLevel 0

END SUB

SUB SwitchKeys (State$)

 SELECT CASE State$
        CASE "ON": KEY(1) ON: KEY(2) ON: KEY(3) ON
        CASE "OFF": KEY(1) OFF: KEY(2) OFF: KEY(3) OFF
 END SELECT
END SUB

