'
'                       ͻ
'                        QBasic Snake Version 1.0 
'                       ͹
'                        (c) 1999  Dominik Kaspar 
'                       ͼ
'
'
'                 for comments write to pedok@pop.agri.ch
'
DECLARE SUB AddEmptyTop10 ()
DECLARE SUB CheckGameOver ()
DECLARE SUB CheckTarget ()
DECLARE SUB Description ()
DECLARE SUB DetectWorkingDir ()
DECLARE SUB DrawLevel ()
DECLARE SUB DrawSnake ()
DECLARE SUB FontPrint (XPos!, YPos!, Text$, Colour!)
DECLARE SUB LoadFont ()
DECLARE SUB LoadItems ()
DECLARE SUB Logo (x!, y!, Text$)
DECLARE SUB MainMenu ()
DECLARE SUB MoveSnake (Direction)
DECLARE SUB PlaceRandomTarget ()
DECLARE SUB PlaceTarget (Target%)
DECLARE SUB PlaySnake ()
DECLARE SUB PromptFileName ()
DECLARE SUB ReallyQuit ()
DECLARE SUB ViewHighScore ()

CONST MaxSnakeLength = 100

TYPE LevRecType
     StartX   AS INTEGER
     StartY   AS INTEGER
     StartDir AS INTEGER
     LevString AS STRING * 3200
END TYPE
DIM SHARED LevRec AS LevRecType

TYPE HighScoreType
     Player AS STRING * 15
     Points AS LONG
     File   AS STRING * 12
END TYPE
DIM SHARED HighScore AS HighScoreType

DIM SHARED Grid(1 TO 80, 1 TO 40) AS INTEGER
DIM SHARED Level(1 TO 80, 1 TO 40) AS INTEGER
DIM SHARED Snake(1 TO MaxSnakeLength, 1 TO 2)

DIM SHARED Item(4, 10)
                                       
DIM SHARED SnakeLength
DIM SHARED Direction
DIM SHARED GameSpeed
DIM SHARED GameOver
DIM SHARED Level AS INTEGER
DIM SHARED LastLevel AS INTEGER
DIM SHARED Lives AS INTEGER
DIM SHARED Score AS LONG
DIM SHARED Steps AS LONG
DIM SHARED LivesProb, NextProb, LastProb, BonusProb
           LivesProb = .1
           NextProb = .1
           LastProb = .2
           BonusProb = .2

DIM SHARED SnakeColor, BorderColor, BackColor, ItemColor
           SnakeColor = 2
           BorderColor = 1
           BackColor = 8
           ItemColor = 14

DIM SHARED Font AS STRING * 30
DIM SHARED FontChar(0 TO 127, 1 TO 5, 1 TO 6) AS INTEGER
DIM SHARED FileName$
DIM SHARED CurDir$

DIM SHARED HelpLine AS STRING * 46
ON KEY(1) GOSUB Help
         
DetectWorkingDir
LoadFont

SCREEN 7
RANDOMIZE TIMER

LoadItems
MainMenu

SYSTEM

Help: Description
      RETURN

SUB AddEmptyTop10
    FOR rec = 1 TO 10
        n$ = ""
        c$ = "BCDFGHKLMNPRSTVWXZ"
        v$ = "AEIOU"
        FOR i = 1 TO 3 + INT(RND * 2)
            n$ = n$ + MID$(c$, INT(RND * LEN(c$) + 1), 1)
            n$ = n$ + MID$(v$, INT(RND * LEN(v$) + 1), 1)
        NEXT i
        HighScore.Player = n$
        HighScore.Points = 1000 - 100 * rec
        HighScore.File = "QBSNAKE.LEV"
        PUT #2, rec, HighScore
    NEXT rec
END SUB

SUB CheckGameOver

IF LastLevel = 1 THEN
   IF Steps < Levels * 600 THEN Score = Score * 1.1
   GOTO CheckHighScore
END IF

 FOR i = 2 TO SnakeLength - 1
     IF Snake(i, 1) = Snake(1, 1) AND Snake(i, 2) = Snake(1, 2) THEN
        Lives = Lives - 1
        IF Lives THEN
           LINE (60, 100)-(260, 140), 0, BF
           LINE (60, 100)-(260, 140), 7, B
           FontPrint 80, 117, "You've hit your own tail!", 7
           DO: LOOP UNTIL LEN(INKEY$)
           SnakeLength = 3
           DrawLevel
           PlaceTarget 2
           EXIT SUB
        ELSE
           LINE (60, 100)-(260, 140), 0, BF
           LINE (60, 100)-(260, 140), 7, B
           FontPrint 80, 117, "Game Over!", 7
           DO: LOOP UNTIL LEN(INKEY$)
           GameOver = 1
           EXIT SUB
        END IF
     END IF
 NEXT i

 x = Snake(1, 1)
 y = Snake(1, 2)
 IF Level(x, y) = 1 THEN
    Lives = Lives - 1
    IF Lives THEN
       LINE (60, 100)-(260, 140), 0, BF
       LINE (60, 100)-(260, 140), 7, B
       FontPrint 80, 117, "You ran into a wall!", 7
       DO: LOOP UNTIL LEN(INKEY$)
       SnakeLength = 3
       DrawLevel
       PlaceTarget 2
    ELSE
       LINE (60, 100)-(260, 140), 0, BF
       LINE (60, 100)-(260, 140), 7, B
       FontPrint 80, 117, "Game Over!", 7
       DO: LOOP UNTIL LEN(INKEY$)
       GameOver = 1
    END IF
 END IF

CheckHighScore:

 IF GameOver = 1 THEN
    OPEN CurDir$ + "QBSNAKE.HSC" FOR RANDOM AS #2 LEN = LEN(HighScore)
         IF LOF(2) = 0 THEN AddEmptyTop10
         Records = LOF(2) / LEN(HighScore)
         FOR rec = 1 TO Records
             GET #2, rec, HighScore
             IF Score >= HighScore.Points THEN
                FOR i = Records - 1 TO rec STEP -1
                    GET #2, i, HighScore
                    PUT #2, i + 1, HighScore
                NEXT i
                LINE (60, 64)-(260, 140), 0, BF
                LINE (60, 64)-(260, 140), 7, B
                FontPrint 69, 74, "Congratulations!", 8
                FontPrint 70, 75, "Congratulations!", 4
                FontPrint 70, 92, "You have reached the HighScore.", 7
                FontPrint 70, 110, "Type in your name:", 7
                FontPrint 70, 125, CHR$(26), 7
                YourName$ = ""
NamePrompt:     FontPrint 80, 125, YourName$ + SPACE$(15 - LEN(YourName$)), 5
                Key$ = ""
                DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)

                SELECT CASE ASC(Key$)
                  CASE 32 TO 127:
                       IF LEN(YourName$) < 15 THEN
                          YourName$ = YourName$ + Key$
                       END IF
                       GOTO NamePrompt
                  CASE 8:
                       IF LEN(YourName$) > 0 THEN
                          YourName$ = LEFT$(YourName$, LEN(YourName$) - 1)
                       END IF
                       GOTO NamePrompt
                  CASE 13: IF LEN(YourName$) = 0 THEN GOTO NamePrompt
                  CASE ELSE: GOTO NamePrompt
                END SELECT

                HighScore.Player = YourName$
                HighScore.Points = Score
                HighScore.File = FileName$
                PUT #2, rec, HighScore
                CLOSE #2
                EXIT SUB
             END IF
         NEXT rec
    CLOSE #2
 END IF

END SUB

SUB CheckTarget

 x = Snake(1, 1)
 y = Snake(1, 2)

 SELECT CASE Level(x, y)
   CASE 2: SnakeLength = SnakeLength + 10
           Score = Score + SnakeLength
           FontPrint 220, 27, "Score:" + STR$(Score), 7
           PlaceTarget Level(x, y)
           IF SnakeLength > (MaxSnakeLength - 10) THEN
              Score = Score + (Level - 1) * 100
              SnakeLength = 3
              Level = Level + 1
              DrawLevel
              PlaceTarget 2
           END IF
   CASE 3: Lives = Lives + 1
           Score = CINT(Score * .9)
           FontPrint 110, 27, "Lives:" + STR$(Lives), 7
           FontPrint 220, 27, "Score:" + STR$(Score), 7
   CASE 4: Level = Level + 1
           SnakeLength = 3
           DrawLevel
           PlaceTarget 2
   CASE 5: Level = Level - 1
           Score = CINT(Score * .9)
           FontPrint 220, 27, "Score:" + STR$(Score), 7
           IF Level < 1 THEN Level = 1
           SnakeLength = 3
           DrawLevel
           PlaceTarget 2
   CASE 6: Score = Score + INT(RND * 200)
           FontPrint 220, 27, "Score:" + STR$(Score), 7
   CASE ELSE: EXIT SUB
 END SELECT

 Level(x, y) = 0

END SUB

SUB Description

 KEY(1) OFF

 PCOPY 0, 1
 CLS

 OPEN CurDir$ + "QBSNAKE.DSC" FOR RANDOM AS #2 LEN = LEN(HelpLine)

 Logo 20, 10, "HELP"

 IF LOF(2) = 0 THEN
    CLOSE #2
    KILL CurDir$ + "QBSNAKE.DSC"
    FontPrint 20, 50, "ERROR! File missing: QBSNAKE.DSC", 4
    FontPrint 20, 70, "Press a key to continue...", 1
    DO: LOOP UNTIL LEN(INKEY$)
    GOTO ExitDescription
 END IF

 Selected = 1
DscPrompt:
 FOR rec = Selected * 15 - 14 TO Selected * 15
     GET #2, rec, HelpLine
     IF (rec - Selected * 15 + 15) = 1 THEN Colour = 4 ELSE Colour = 1
     FontPrint 20, 35 + (rec - Selected * 15 + 15) * 10, HelpLine, Colour
 NEXT rec

 Key$ = "": DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)

 SELECT CASE Key$
   CASE CHR$(0) + "H":
        Selected = Selected - 1
        IF Selected = 0 THEN Selected = 1
        GOTO DscPrompt
   CASE CHR$(0) + "P":
        Selected = Selected + 1
        IF Selected = 5 THEN Selected = 4
        GOTO DscPrompt
   CASE CHR$(13):
        Selected = Selected + 1
        IF Selected = 5 THEN Selected = 4
        GOTO DscPrompt
   CASE "1" TO "4":
        Selected = VAL(Key$)
        GOTO DscPrompt
   CASE CHR$(27):
   CASE ELSE: GOTO DscPrompt
 END SELECT

 CLOSE #2

ExitDescription:

 PCOPY 1, 0

 KEY(1) ON

END SUB

SUB DetectWorkingDir

 CurDir$ = ""

 OPEN "QBSNAKE.FNT" FOR RANDOM AS #1 LEN = LEN(Font)
      IF LOF(1) > 0 THEN
         CLOSE #1
         EXIT SUB
      END IF
 CLOSE #1
 KILL "QBSNAKE.FNT"

 PRINT "Detecting working directory...";

 SHELL "CD\"
 SHELL "DIR QBSNAKE.FNT /S /B > QBSNAKE.TMP"

 OPEN "QBSNAKE.TMP" FOR INPUT AS #1

 IF LOF(1) = 0 THEN
    PRINT : PRINT
    PRINT "ERROR: Could not detect working directory."
    PRINT "       There is a file missing (QBSNAKE.FNT)"
    PRINT
    SYSTEM
 END IF

 LINE INPUT #1, CurDir$
 CurDir$ = RTRIM$(LTRIM$(UCASE$(CurDir$)))

 FOR i = 1 TO LEN(CurDir$)
     IF MID$(CurDir$, i, 11) = "QBSNAKE.FNT" THEN
        CurDir$ = UCASE$(LEFT$(CurDir$, i - 1))
        EXIT FOR
     END IF
 NEXT i
 IF RIGHT$(CurDir$, 1) <> "\" THEN CurDir$ = CurDir$ + "\"

 CLOSE #1
 KILL "QBSNAKE.TMP"

 PRINT "OK."

END SUB

SUB DrawLevel

 IF Level > LOF(1) / LEN(LevRec) THEN
    LastLevel = 1
    EXIT SUB
 ELSE
    GET #1, Level, LevRec
 END IF

 CLS
 FontPrint 11, 11, "QBASIC SNAKE", 8
 FontPrint 12, 12, "QBASIC SNAKE", 4
 FontPrint 110, 12, "[" + FileName$ + "]", 7
 FontPrint 12, 27, "Level Nr." + STR$(Level), 7
 FontPrint 110, 27, "Lives:" + STR$(Lives), 7
 FontPrint 220, 27, "Score:" + STR$(Score), 7

 ERASE Snake, Level
 Snake(1, 1) = LevRec.StartX: Snake(1, 2) = LevRec.StartY
 Direction = LevRec.StartDir

 LINE (0, 40)-(319, 199), BackColor, BF

 FOR y = 1 TO 40
     FOR x = 1 TO 80
         i = i + 1
         XPos = x + 3 * x - 4
         YPos = 39 + y + 3 * y - 3
         IF MID$(LevRec.LevString, i, 1) <> "0" THEN
            Level(x, y) = 1
            LINE (XPos, YPos)-(XPos + 3, YPos + 3), BorderColor, BF
         END IF
     NEXT x
 NEXT y

END SUB

SUB DrawSnake

XPos = Snake(1, 1)
XPos = XPos + 3 * XPos - 4
YPos = Snake(1, 2)
YPos = 39 + YPos + 3 * YPos - 3
PUT (XPos, YPos), Item(1, 1), PSET

IF Snake(SnakeLength + 1, 1) = 0 THEN EXIT SUB
XPos = Snake(SnakeLength + 1, 1)
XPos = XPos + 3 * XPos - 4
YPos = Snake(SnakeLength + 1, 2)
YPos = 39 + YPos + 3 * YPos - 3
LINE (XPos, YPos)-(XPos + 3, YPos + 3), BackColor, BF

END SUB

SUB FontPrint (XPos, YPos, Text$, Colour!)

 FOR TextPos = 1 TO LEN(Text$)
     FOR x = 1 TO 5
         FOR y = 1 TO 6
             SELECT CASE FontChar(ASC(MID$(Text$, TextPos, 1)), x, y)
               CASE 0: PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), 0
               CASE 1: PSET (XPos + x + TextPos * 6 - 7, YPos + y - 1), Colour
             END SELECT
         NEXT y
     NEXT x
 NEXT TextPos

END SUB

SUB LoadFont

 OPEN CurDir$ + "QBSNAKE.FNT" FOR RANDOM AS #1 LEN = LEN(Font)

 IF LOF(1) = 0 THEN
    PRINT "Fatal Error: Couldn't find file QBSNAKE.FNT"
    DO: LOOP UNTIL LEN(INKEY$)
    CLOSE #1
    KILL "QBSNAKE.FNT"
    END
 END IF

 PRINT "Loading Font...";

 FOR rec = 1 TO 127
     GET #1, rec, Font
     x = 0
     y = 1
     FOR CodePos = 1 TO 30
         IF x = 5 THEN x = 0: y = y + 1
         x = x + 1
         FontChar(rec, x, y) = VAL(MID$(Font, CodePos, 1))
     NEXT CodePos
 NEXT rec

 CLOSE #1

 PRINT "OK."

END SUB

SUB LoadItems

bc$ = STR$(BackColor)
sc$ = STR$(SnakeColor)
wc$ = STR$(BorderColor)
ic$ = STR$(ItemColor)

PSET (0, 0)
DRAW "c" + bc$ + "rc" + sc$ + "r2c" + bc$ + "dc" + sc$ + "l3dr3d"
DRAW "c" + bc$ + "lc" + sc$ + "l2c" + bc$ + "rc" + sc$ + "r"
GET (0, 0)-(3, 3), Item(1, 1)                                      'SnakeBody

PSET (4, 0)
DRAW "c" + ic$ + "r3d3l3u3fc" + bc$ + "rdlu"
GET (4, 0)-(7, 3), Item(1, 2)                                      'Grow Item

PSET (8, 0)
DRAW "c" + ic$ + "d3r3uc" + bc$ + "l2u2r2dl"
GET (8, 0)-(11, 3), Item(1, 3)                                     'Extra Life

PSET (12, 0)
DRAW "c" + bc$ + "dc" + ic$ + "felurc" + bc$ + "rdgrdl3u"
GET (12, 0)-(15, 3), Item(1, 4)                                    'Next Level

PSET (16, 0)
DRAW "c" + bc$ + "r3d3l3ur2uc" + ic$ + "l2"
GET (16, 0)-(19, 3), Item(1, 5)                                    'Last Level

PSET (20, 0)
DRAW "c" + ic$ + "d3eru2ld" + "c" + bc$ + "br2ud3l2"
PSET (21, 1), BackColor
GET (20, 0)-(23, 3), Item(1, 6)                                    'Bonus Points

END SUB

SUB Logo (XPos, YPos, Text$)

 FOR TextPos = 1 TO LEN(Text$)
     t = TIMER: DO: LOOP UNTIL TIMER >= t + .2
     FOR x = 1 TO 5
         FOR y = 1 TO 6
             IF FontChar(ASC(MID$(Text$, TextPos, 1)), x, y) = 1 THEN
                xx = XPos + 4 * x + 4 * (TextPos * 6 - 7)
                yy = YPos + 4 * y - 1
                PUT (xx, yy), Item(1, 1), PSET
             END IF
         NEXT y
     NEXT x
 NEXT TextPos

END SUB

SUB MainMenu

KEY(1) ON
Start:

CLS

ItemPos = 1: ItemOld = 1

LINE (6, 10)-(311, 50), BackColor, BF
Logo 16, 15, "QBasic Snake"

FontPrint 110, 80, "Start Snake Game", 8
FontPrint 111, 81, "Start Snake Game", 4
FontPrint 120, 110, "Instructions", 8
FontPrint 121, 111, "Instructions", 4
FontPrint 130, 140, "HighScore", 8
FontPrint 131, 141, "HighScore", 4
FontPrint 122, 170, "Exit Program", 8
FontPrint 123, 171, "Exit Program", 4


Prompt:

IF ItemPos <> ItemOld THEN
       FontPrint 90, 50 + ItemOld * 30 + i * s, CHR$(26), 0
       FontPrint 220, 50 + ItemOld * 30 + i * s, CHR$(27), 0
END IF
FontPrint 90, 50 + ItemPos * 30, CHR$(26), 2
FontPrint 220, 50 + ItemPos * 30, CHR$(27), 2

Key$ = ""
DO
  IF TIMER >= t + .2 THEN
     i = INT(RND * 6)
     j = INT(RND * 5)
     IF POINT(30 + i * 24, 39) = 10 THEN
        PAINT (30 + i * 24, 39), SnakeColor, BackColor
     ELSE
        PAINT (30 + i * 24, 39), 10, BackColor
     END IF
     IF POINT(198 + j * 24, 39) = 10 THEN
        PAINT (198 + j * 24, 39), SnakeColor, BackColor
     ELSE
        PAINT (198 + j * 24, 39), 10, BackColor
     END IF
     t = TIMER
  END IF
  Key$ = INKEY$
LOOP UNTIL LEN(Key$)

ItemOld = ItemPos

SELECT CASE Key$
  CASE CHR$(0) + "H": ItemPos = ItemPos - 1
                      IF ItemPos = 0 THEN ItemPos = 1
                      GOTO Prompt
  CASE CHR$(0) + "K": ItemPos = 1
                      GOTO Prompt
  CASE CHR$(0) + "P": ItemPos = ItemPos + 1
                      IF ItemPos = 5 THEN ItemPos = 4
                      GOTO Prompt
  CASE CHR$(0) + "M": ItemPos = 4
                      GOTO Prompt
  CASE CHR$(13): SELECT CASE ItemPos
                   CASE 1: PromptFileName
                   CASE 2: Description
                   CASE 3: ViewHighScore
                   CASE 4: ReallyQuit
                           GOTO Prompt
                 END SELECT
  CASE CHR$(27): ReallyQuit
  CASE ELSE: GOTO Prompt
END SELECT

GOTO Start

END SUB

SUB MoveSnake (Direction)

 FOR i = (SnakeLength + 1) TO 2 STEP -1
     Snake(i, 1) = Snake(i - 1, 1)
     Snake(i, 2) = Snake(i - 1, 2)
 NEXT i
 Snake(SnakeLength + 2, 1) = 0
 Snake(SnakeLength + 2, 2) = 0

 SELECT CASE Direction
   CASE 1: Snake(1, 2) = Snake(1, 2) - 1
           IF Snake(1, 2) = 0 THEN Snake(1, 2) = 40
   CASE 2: Snake(1, 1) = Snake(1, 1) - 1
           IF Snake(1, 1) = 0 THEN Snake(1, 1) = 80
   CASE 3: Snake(1, 1) = Snake(1, 1) + 1
           IF Snake(1, 1) = 81 THEN Snake(1, 1) = 1
   CASE 4: Snake(1, 2) = Snake(1, 2) + 1
           IF Snake(1, 2) = 41 THEN Snake(1, 2) = 1
 END SELECT

END SUB

SUB PlaceRandomTarget

IF RND * 100 <= LivesProb THEN
   PlaceTarget 3
END IF

IF RND * 100 <= NextProb THEN
   PlaceTarget 4
END IF

IF RND * 100 <= LastProb THEN
   PlaceTarget 5
END IF

IF RND * 100 <= BonusProb THEN
   PlaceTarget 6
END IF

END SUB

SUB PlaceTarget (Target%)

 DO
   i = 0
   x = INT(RND * 80) + 1
   y = INT(RND * 40) + 1
   FOR j = 1 TO SnakeLength
       IF Snake(j, 1) = x AND Snake(j, 2) = y THEN i = 1
   NEXT j
 LOOP WHILE Level(x, y) OR i

 Level(x, y) = Target%

 XPos = x + 3 * x - 4
 YPos = 39 + y + 3 * y - 3

 PUT (XPos, YPos), Item(1, Target%), PSET

END SUB

SUB PlaySnake

SnakeLength = 3
Level = 1
LastLevel = 0
Lives = 3
Score = 0
Steps = 0
GameSpeed = .09

DrawLevel

PlaceTarget 2

DO
WAITFORKEY:
  DelayTimer = TIMER
  Dir = Direction
  DO
    SELECT CASE INKEY$
      CASE CHR$(0) + "H": IF Direction <> 4 THEN Dir = 1
      CASE CHR$(0) + "K": IF Direction <> 3 THEN Dir = 2
      CASE CHR$(0) + "M": IF Direction <> 2 THEN Dir = 3
      CASE CHR$(0) + "P": IF Direction <> 1 THEN Dir = 4
      CASE CHR$(27): ReallyQuit
    END SELECT
  LOOP UNTIL TIMER >= DelayTimer + GameSpeed

  Steps = Steps + 1
  Direction = Dir

  MoveSnake Direction

  CheckTarget
  IF LastLevel = 1 THEN GameOver = 1

  CheckGameOver
  IF GameOver = 1 THEN
     GameOver = 0
     EXIT SUB
  END IF

  DrawSnake
 
  PlaceRandomTarget

LOOP

END SUB

SUB PromptFileName

 CLS

 FontPrint 10, 10, "Choose a Level File to start a new game:", 7
 FontPrint 10, 35, "Use the arrow keys [" + CHR$(24) + "/" + CHR$(25) + "]", 7
 FontPrint 10, 45, "And press Enter to confirm.", 7
 FontPrint 10, 100, "Preview of Level 1:", 7
 FontPrint 230, 180, "[ESC] = Quit", 8

 SHELL "DIR /B /ON " + CurDir$ + "*.LEV > " + CurDir$ + "QBSNAKE.TMP"

 OPEN CurDir$ + "QBSNAKE.TMP" FOR INPUT AS #2
   IF LOF(2) = 0 THEN
      FontPrint 5, 50, "[No Files Found]", 1
      FontPrint 5, 70, CHR$(26) + " press a key to return to the main menu", 1
      DO: LOOP UNTIL LEN(INKEY$)
      CLOSE #2
      KILL CurDir$ + "QBSNAKE.TMP"
      EXIT SUB
   ELSE
      TotalRecs = 0
      DO
        TotalRecs = TotalRecs + 1
        INPUT #2, File$
      LOOP UNTIL EOF(2)
   END IF
 CLOSE #2

 FileName$ = "": rec = 1

FILEPROMPT:

 OPEN CurDir$ + "QBSNAKE.TMP" FOR INPUT AS #2
   FOR i = 1 TO rec
       INPUT #2, File$
   NEXT i
   FontPrint 10, 70, File$ + SPACE$(12 - LEN(File$)), 3
   OPEN CurDir$ + File$ FOR RANDOM AS #1 LEN = LEN(LevRec)
        GET #1, 1, LevRec
        LINE (10, 110)-(89, 149), BackColor, BF
        i = 0
        IF LOF(1) = 0 THEN
           LINE (10, 110)-(89, 149), 0, BF
           FontPrint 20, 120, "[empty]", 7
        ELSE
           FOR y = 1 TO 40
               FOR x = 1 TO 80
                   i = i + 1
                   IF MID$(LevRec.LevString, i, 1) <> "0" THEN
                      PSET (9 + x, 109 + y), BorderColor
                   END IF
               NEXT x
           NEXT y
        END IF
   CLOSE #1
 CLOSE #2

FILEPROMPT2:
 Key$ = ""
 DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)

 SELECT CASE Key$
   CASE CHR$(0) + "H": rec = rec - 1
                       IF rec = 0 THEN rec = 1
                       GOTO FILEPROMPT
   CASE CHR$(0) + "P": rec = rec + 1
                       IF rec > TotalRecs THEN rec = rec - 1
                       GOTO FILEPROMPT
   CASE CHR$(13): FileName$ = File$
   CASE CHR$(27): KILL CurDir$ + "QBSNAKE.TMP"
                  EXIT SUB
   CASE ELSE: GOTO FILEPROMPT2
 END SELECT

 KILL CurDir$ + "QBSNAKE.TMP"

 OPEN CurDir$ + FileName$ FOR RANDOM AS #1 LEN = LEN(LevRec)
      PlaySnake
 CLOSE #1

END SUB

SUB ReallyQuit
    PCOPY 0, 2
    LINE (60, 64)-(260, 140), 0, BF
    LINE (60, 64)-(260, 140), 7, B
    FontPrint 77, 81, "Are you sure that you want", 7
    FontPrint 77, 99, "to leave this wonderful", 7
    FontPrint 77, 117, "game (Y/N)?", 7

    Key$ = "": DO: Key$ = INKEY$: LOOP UNTIL LEN(Key$)
    IF UCASE$(Key$) = "Y" THEN
       DO
         x = INT(RND * 320)
         y = INT(RND * 200)
         c = POINT(x, y)
         LINE (x, y)-(x + 1, y + 3), c, BF
       LOOP UNTIL LEN(INKEY$)
       SYSTEM
    END IF
    PCOPY 2, 0
END SUB

SUB ViewHighScore

CLS
Logo 20, 10, "TOP 10"
FontPrint 20, 55, "Rank", 4
FontPrint 70, 55, "Player Name", 4
FontPrint 170, 55, "Score", 4
FontPrint 230, 55, "Level File", 4

OPEN CurDir$ + "QBSNAKE.HSC" FOR RANDOM AS #2 LEN = LEN(HighScore)
     Records = LOF(2) / LEN(HighScore)
     IF LOF(2) = 0 THEN AddEmptyTop10
     FOR rec = 1 TO 10
         GET #2, rec, HighScore
         Rank$ = LTRIM$(STR$(rec)) + "."
         Rank$ = STRING$(5 - LEN(Rank$), "0") + Rank$
         FontPrint 20, 60 + rec * 12, Rank$, 7
         FontPrint 70, 60 + rec * 12, HighScore.Player, 7
         p$ = LTRIM$(STR$(HighScore.Points))
         p$ = STRING$(7 - LEN(p$), "0") + p$
         FontPrint 170, 60 + rec * 12, p$, 7
         FontPrint 230, 60 + rec * 12, HighScore.File, 7
     NEXT rec
CLOSE #2

DO: LOOP UNTIL LEN(INKEY$)

END SUB

