void start( void )
{
    if ( MODDetectCard( &Port, &IRQ, &DRQ ) )
    {
        printf( "Sound Blaster not Found.\n" ); getch();
        SOUND = 0;
    } else SOUND = 1, MODPlayModule( Mus, 8, 8000, Port, IRQ, DRQ, PM_TIMER );
    playMidiLoopCounter = 20; /*  e e  */
    ret = initMPU401( 0x330 );
    SOUND2 = 1;
    if ( ret != 0 )
    {
        ret = initMPU401( 0x320 );
        if ( ret != 0 )
        {
            printf("MIDI Device not found!.\n"); getch();
            SOUND2 = 0;
        }
    }
    init_key();
    read_font(); read_font2();
    set320x240x256_X();
    //VGAmode();
    page_on();
    for ( i = 0; i < 2000; i++ ) TILE[i] = (char *)malloc( 16 * 16 );
    randomize();
    MODSetSampleVolume( 100 );
}

void end( void )
{
    endMidiPlay();
    MODStopModule();
    for ( i = 0; i < 2000; i++ ) if ( TILE[i] != NULL ) free( TILE[i] );
    for ( i = 0; i < 200; i++ ) if ( E[i] != NULL ) free( E[i] );
    for ( i = 0; i < 8; i++ ) if ( P2[i] != NULL ) free( P2[i] );
    for ( i = 0; i < 50; i++ ) if ( P[i] != NULL ) free( P[i] );
    for ( i = 0; i < 50; i++ ) if ( ETC[i] != NULL ) free( ETC[i] );
    for ( i = 0; i < 50; i++ ) if ( Eff[i] != NULL ) MODFreeSample( Eff[i] );
    if ( Mus != NULL ) MODFreeModule( Mus );
    page_off();
    del_key();
    TEXTmode();
}

void sprite_load( void )
{

    FILE *f;

    int ij;
    char *bigyo, hstr[28] = "Arix Sprite Capture Ver 2.0";

    if ( (f = fopen( "MON1.SPR", "rb" )) != NULL )
    {
        fread( bigyo, 27, 1, f );
        if ( memcmp( hstr, bigyo, 27 ) == 0 )
        {
            fread( &MAX_NUMBER, 2, 1, f );
            for ( i = 0; i < MAX_NUMBER; i++ )
            {
                fread( &ij, 2, 1, f );
                fread( &X[i], 2, 1, f ); fread( &Y[i], 2, 1, f );
                P[i] = (char *)malloc( X[i] * Y[i] ); P2[i] = (char *)malloc( X[i] * Y[i] );
                if ( P[i] == NULL ) exit(0);
                fread( P[i], X[i] * Y[i], 1, f );
            }
        }
    	fclose( f );
    }
    if ( (f = fopen( "ENEMY.SPR", "rb" )) != NULL )
    {
        fread( bigyo, 27, 1, f );
        if ( memcmp( hstr, bigyo, 27 ) == 0 )
        {
            fread( &MAX_NUMBER, 2, 1, f );
            for ( i = 0; i < MAX_NUMBER; i++ )
            {
                fread( &ij, 2, 1, f );
                fread( &EX[i], 2, 1, f ); fread( &EY[i], 2, 1, f );
                E[i] = (char *)malloc( EX[i] * EY[i] );
                if ( E[i] == NULL ) exit(0);
                fread( E[i], EX[i] * EY[i], 1, f );
            }
        }
    	fclose( f );
    }
    if ( (f = fopen( "ETC.SPR", "rb" )) != NULL )
    {
        fread( bigyo, 27, 1, f );
        if ( memcmp( hstr, bigyo, 27 ) == 0 )
        {
            fread( &MAX_NUMBER, 2, 1, f );
            for ( i = 0; i < MAX_NUMBER; i++ )
            {
                fread( &ij, 2, 1, f );
                fread( &ETX[i], 2, 1, f ); fread( &ETY[i], 2, 1, f );
                ETC[i] = (char *)malloc( ETX[i] * ETY[i] );
                if ( ETC[i] == NULL ) exit(0);
                fread( ETC[i], ETX[i] * ETY[i], 1, f );
            }
        }
    	fclose( f );
    }
}

void sprite_load2( void )
{

    FILE *f;

    int ij;
    char *bigyo, hstr[28] = "Arix Sprite Capture Ver 2.0";

    switch( ROUND )
    {
        case 1:
            if ( (f = fopen( "M1.SPR", "rb" )) != NULL )
            {
                fread( bigyo, 27, 1, f );
                if ( memcmp( hstr, bigyo, 27 ) == 0 )
                {
                    fread( &MAX_NUMBER, 2, 1, f );
                    for ( i = 0; i < MAX_NUMBER; i++ )
                    {
                        fread( &ij, 2, 1, f );
                        fread( &X2[i], 2, 1, f ); fread( &Y2[i], 2, 1, f );
                        P2[i] = (char *)malloc( X2[i] * Y2[i] );
                        if ( P2[i] == NULL ) exit(0);
                        fread( P2[i], X2[i] * Y2[i], 1, f );
                    }
                }
                fclose( f );
            }
        break;
        case 2:
            if ( (f = fopen( "MON2.SPR", "rb" )) != NULL )
            {
                fread( bigyo, 27, 1, f );
                if ( memcmp( hstr, bigyo, 27 ) == 0 )
                {
                    fread( &MAX_NUMBER, 2, 1, f );
                    for ( i = 0; i < MAX_NUMBER; i++ )
                    {
                        fread( &ij, 2, 1, f );
                        fread( &X2[i], 2, 1, f ); fread( &Y2[i], 2, 1, f );
                        P2[i] = (char *)malloc( X2[i] * Y2[i] );
                        if ( P2[i] == NULL ) exit(0);
                        fread( P2[i], X2[i] * Y2[i], 1, f );
                    }
                }
                fclose( f );
            }
        break;
        case 3: case 4:
            if ( (f = fopen( "MON3.SPR", "rb" )) != NULL )
            {
                fread( bigyo, 27, 1, f );
                if ( memcmp( hstr, bigyo, 27 ) == 0 )
                {
                    fread( &MAX_NUMBER, 2, 1, f );
                    for ( i = 0; i < MAX_NUMBER; i++ )
                    {
                        fread( &ij, 2, 1, f );
                        fread( &X2[i], 2, 1, f ); fread( &Y2[i], 2, 1, f );
                        P2[i] = (char *)malloc( X2[i] * Y2[i] );
                        if ( P2[i] == NULL ) exit(0);
                        fread( P2[i], X2[i] * Y2[i], 1, f );
                    }
                }
                fclose( f );
            }
        break;
        case 5:
            if ( (f = fopen( "MON4.SPR", "rb" )) != NULL )
            {
                fread( bigyo, 27, 1, f );
                if ( memcmp( hstr, bigyo, 27 ) == 0 )
                {
                    fread( &MAX_NUMBER, 2, 1, f );
                    for ( i = 0; i < MAX_NUMBER; i++ )
                    {
                        fread( &ij, 2, 1, f );
                        fread( &X2[i], 2, 1, f ); fread( &Y2[i], 2, 1, f );
                        P2[i] = (char *)malloc( X2[i] * Y2[i] );
                        if ( P2[i] == NULL ) exit(0);
                        fread( P2[i], X2[i] * Y2[i], 1, f );
                    }
                }
                fclose( f );
            }
        break;
        case 6:
            if ( (f = fopen( "MON5.SPR", "rb" )) != NULL )
            {
                fread( bigyo, 27, 1, f );
                if ( memcmp( hstr, bigyo, 27 ) == 0 )
                {
                    fread( &MAX_NUMBER, 2, 1, f );
                    for ( i = 0; i < MAX_NUMBER; i++ )
                    {
                        fread( &ij, 2, 1, f );
                        fread( &X2[i], 2, 1, f ); fread( &Y2[i], 2, 1, f );
                        P2[i] = (char *)malloc( X2[i] * Y2[i] );
                        if ( P2[i] == NULL ) exit(0);
                        fread( P2[i], X2[i] * Y2[i], 1, f );
                    }
                }
                fclose( f );
            }
        break;
    }
}

void load_tile( char *name )
{
    FILE *f;
    int x3, y3;

    if ( (f = fopen( name, "rb" )) != NULL )
    {

        fread( &x3, 2, 1, f );
        fread( &y3, 2, 1, f );
        fread( &tile_c, 2, 1, f );
        for ( i = 0; i < tile_c; i++ )
        {
            fread( TILE[i], 16 * 16, 1, f );
        }
        fclose( f );
    }
}

void load_map( char *name )
{
    FILE *f;

    if ( (f = fopen( name, "rb" )) != NULL )
    {
        fread( &MAX_X, 2, 1, f );
        fread( &MAX_Y, 2, 1, f );

        for ( i = 0; i < MAX_Y; i++ )
        {
            for ( i2 = 0; i2 < MAX_X; i2++ )
            {
                fread( &MAP[i2][i], 2, 1, f );
                fread( &MAP2[i2][i], 2, 1, f );
                fread( &ATT[i2][i], 2, 1, f );
            }
        }
    }
    fclose( f );
}

void ITEM :: item_create( int x, int y )
{
    PX = x, PY = y, FLAG = 1, TIME = 0, FLAG2 = 1, TIME2 = 0;
}

void ITEM :: item( void )
{
    if ( LIFE == 1 )
    {
        switch( FLAG )
        {
            case 1: if ( TIME++ > 5 ) TIME = 0, PY++, FLAG = 2; break;
            case 2: if ( TIME++ > 5 ) TIME = 0, PY++, FLAG = 3; break;
            case 3: if ( TIME++ > 5 ) TIME = 0, PY++, FLAG = 4; break;
            case 4: if ( TIME++ > 5 ) TIME = 0, PY--, FLAG = 5; break;
            case 5: if ( TIME++ > 5 ) TIME = 0, PY--, FLAG = 6; break;
            case 6: if ( TIME++ > 5 ) TIME = 0, PY--, FLAG = 1; break;
        }
        switch( FLAG2 )
        {
            case 1: put_sprite( PX, PY, X[29], Y[29], P[29], 1 ); if ( TIME2++ > 5 ) TIME2 = 0, FLAG2 = 2; break;
            case 2: put_white( PX, PY, X[29], Y[29], P[29], 1 ); if ( TIME2++ > 2 ) TIME2 = 0, FLAG2 = 1; break;
        }
        if ( SCROLL == ON ) PX--; if ( PX < -14 ) LIFE = 0;
        if ( SCROLL2 == 1 ) PY++; if ( SCROLL2 == 2 ) PY--;
    }
}

void gl_start( void )
{
    int END_Y;
    char *gl[103] = { "ee aqi ",   //0
                      "",            //1
                      "",//2
                      "",                               //3
                      "",      //4
                      "A B", //5
                      "",//6
                      "  we", //7
                      "  ww",     //8
                      "",                                          //9
                      "",                                                      //10
                      "ā a",                                                    //11
                      "",                 //12
                      "  ww",                          //13
                      "  ", //14
                      "",                    //15
                      "",   //16
                      "aϢ",                               //17
                      "", //18
                      "  ww",   //19
                      "", //20
                      "",                      //21
                      "a",//22
                      "",              //23
                      "  ",     //24
                      "  µw",                                                //25
                      "",                                                //27
                      "",                                                //28
                      "aa",                                                //29
                      "",    //30
                      "  aa",    //31
                      "", //32
                      "", //33
                      "A aa", //34
                      "", //35
                      "  we", //36
                      "",                                     //37
                      "", //38
                      " aa",                                      //39
                      "", //40
                      "  w",                                     //41
                      "", //42
                      "", //43
                      "aQ aa", //44
                      "", //45
                      "  ww",                                     //46
                      "", //47
                      "",                                     //48
                      "AAa", //49
                      "",                                    //50
                      "  we", //51
                      "  ww", //52
                      "  ",                                     //53
                      "", //54
                      "",                                     //55
                      "a i", //56
                      "", //57
                      "   ", //58
                      "  ww",                                     //59
                      "  ", //60
                      "  w",                                       //61
                      "  ww", //62
                      "a Ё i",                           //63
                      "aI", //64
                      " Q AbѡA ", //65
                      "  SKY TEAM", //66
                      "  ARIX TEAM", //67
                      "  ALL STAFF", //68
                      "", //69
                      "", //70
                      "", //71
                      "  (C) 1999", //72
                      "      ARIX TEAM", // 73
                      "",                    //74
                      "", //75
                      "", //76
                      "", //77
                      "",  //78
                      "", //79
                      "", //80
                      "     PRESENTED", //81
                      "        BY", //82
                      "     ARIX TEAM", //83
                      "", //84
                      "", //85
                      "", //86
                      "", //87
                      "", //88
                      "", //89
                      "            -{-", //90
                      "", //91
                      "", //92
                      "", //93
                      "", //94
                      "", //95
                      "", //96
                      "", //97
                      "", //99
                      "", //100
                      "", //101
                      "", //102
                      "",
                      ""
                    };
    END_Y = 275;
    for ( i = 0; i < 103; i++ ) EY[i] = END_Y, END_Y += 16;
    END_Y = 0;
    copy_page_x( 1 ); fade_run( 100 );
    while( !scan[_ESC] )
    {
        copy_page( page[2], page[1] );
        switch( GRIM_SUN )
        {
            case 1:
                copy_image( page[3], 0, 0, 159, GRIM_Y, page[1], 160, 20 );
                GRIM_Y++; if ( GRIM_Y > 199 ) GRIM_Y = 199;
                if ( GRIM_Y == 199 ) { if ( GRIM_TIME++ > 500 ) GRIM_SUN = 2, GRIM_Y = 0, GRIM_TIME = 0; }
            break;
            case 2:
                copy_image( page[3], 160, 0, 319, GRIM_Y, page[1], 160, 20 );
                GRIM_Y++; if ( GRIM_Y > 199 ) GRIM_Y = 199;
                if ( GRIM_Y == 199 ) { if ( GRIM_TIME++ > 500 ) GRIM_SUN = 3, GRIM_Y = 0, GRIM_TIME = 0; }
            break;
            case 3:
                copy_image( page[4], 0, 0, 159, GRIM_Y, page[1], 160, 20 );
                GRIM_Y++; if ( GRIM_Y > 199 ) GRIM_Y = 199;
                if ( GRIM_Y == 199 ) { if ( GRIM_TIME++ > 500 ) GRIM_SUN = 4, GRIM_Y = 0, GRIM_TIME = 0; }
            break;
            case 4:
                copy_image( page[4], 160, 0, 319, GRIM_Y, page[1], 160, 20 );
                GRIM_Y++; if ( GRIM_Y > 199 ) GRIM_Y = 199;
                if ( GRIM_Y == 199 ) { if ( GRIM_TIME++ > 500 ) GRIM_SUN = 5, GRIM_Y = 0, GRIM_TIME = 0; }
            break;
            case 5:
                copy_image( page[5], 0, 0, 159, GRIM_Y, page[1], 160, 20 );
                GRIM_Y++; if ( GRIM_Y > 199 ) GRIM_Y = 199;
                if ( GRIM_Y == 199 ) { if ( GRIM_TIME++ > 500 ) GRIM_SUN = 6, GRIM_Y = 0, GRIM_TIME = 0; }
            break;
            case 6:
                copy_image( page[5], 160, 0, 319, GRIM_Y, page[1], 160, 20 );
                GRIM_Y++; if ( GRIM_Y > 199 ) GRIM_Y = 199;
                if ( GRIM_Y == 199 ) { if ( GRIM_TIME++ > 580 ) GRIM_SUN = 7, GRIM_Y = 0, GRIM_TIME = 0; }
            break;
        }
        for ( i = 0; i < 90; i++ )
        {
            gul2( 0, EY[i], gl[i], 255, 1 );
        }
        if ( END_Y++ > 1 ) { END_Y = 0; for ( i = 0; i < 90; i++ ) EY[i]--; }
        copy_page_x( 1 ); FRAME( 1 );
        if ( EY[89] < 180 ) break;
    }
    while( !scan[_ESC] ) {}
    end(), exit(0);
}

