//"MODEX.H" űw a X aa១

typedef unsigned char BYTE;
typedef signed   char SBYTE;
typedef unsigned char FLAG;
typedef unsigned short COORD;
typedef unsigned short DIST;

#define PLANE_0         0x0102
#define PLANE_1         0x0202
#define PLANE_2         0x0402
#define PLANE_3         0x0802
#define ALL_PLANES      0x0F02
#define READ_PLANE_0    0x0004
#define READ_PLANE_1    0x0104
#define READ_PLANE_2    0x0204
#define READ_PLANE_3    0x0304

// External Variables needed by graphics routines
unsigned short width, height, widthBytes, num_pages;
unsigned short activeStart, visibleStart, pageSize;
unsigned char write_plane, read_plane;
unsigned char *RowsX[600];
unsigned char line_head[4] = { 0xFF, 0x0E, 0x0C, 0x08 };
unsigned char line_tail[4] = { 0x00, 0x01, 0x03, 0x07 };
unsigned short plane_mask[4] = { PLANE_0, PLANE_1, PLANE_2, PLANE_3 };
unsigned short read_mask[4]  = { READ_PLANE_0, READ_PLANE_1,
                                 READ_PLANE_2, READ_PLANE_3 };
unsigned short text_mask[16] = { 0x0002, 0x0102, 0x0202, 0x0302,
                                 0x0402, 0x0502, 0x0602, 0x0702,
                                 0x0802, 0x0902, 0x0A02, 0x0B02,
                                 0x0C02, 0x0D02, 0x0E02, 0x0F02 };
unsigned short page_offset[5];
unsigned short page_mask_high[5];
unsigned short page_mask_low[5];

// Set various ModeX resolutions
void set256x224x256_X(void);
void set256x240x256_X(void);
void set256x256x256_X(void);
void set256x480x256_X(void);
void set320x200x256_X(void);
void set320x240x256_X(void);
void set320x400x256_X(void);
void set320x480x256_X(void);
void set360x200x256_X(void);
void set360x240x256_X(void);
void set360x270x256_X(void);
void set360x360x256_X(void);
void set360x400x256_X(void);
void set360x480x256_X(void);
void set376x282x256_X(void);
void set376x564x256_X(void);
void set400x300x256_X(void);
void set400x600x256_X(void);

COORD get_xres(void);
COORD get_yres(void);

void set_write_plane(unsigned short int plane_mask);
void set_read_plane(unsigned short int plane_mask);

#define ATTRCON_ADDR    0x3C0
#define MISC_ADDR       0x3C2
#define VGAENABLE_ADDR  0x3C3
#define SEQU_ADDR       0x3C4
#define GRACON_ADDR     0x3CE
#define CRTC_ADDR       0x3D4
#define STATUS_ADDR     0x3DA

unsigned short ModeX_256x224regs[75] =
{
    0x3c2, 0x00, 0xe3,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x3f,
    0x3d4, 0x02, 0x40,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x4a,
    0x3d4, 0x05, 0x9a,
    0x3d4, 0x06, 0x0b,
    0x3d4, 0x07, 0x3e,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x41,
    0x3d4, 0x10, 0xda,
    0x3d4, 0x11, 0x9c,
    0x3d4, 0x12, 0xbf,
    0x3d4, 0x13, 0x20,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0xc7,
    0x3d4, 0x16, 0x04,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_256x240regs[75] =
{
    0x3c2, 0x00, 0xe3,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x3f,
    0x3d4, 0x02, 0x40,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x4e,
    0x3d4, 0x05, 0x96,
    0x3d4, 0x06, 0x0d,
    0x3d4, 0x07, 0x3e,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x41,
    0x3d4, 0x10, 0xea,
    0x3d4, 0x11, 0xac,
    0x3d4, 0x12, 0xdf,
    0x3d4, 0x13, 0x20,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0xe7,
    0x3d4, 0x16, 0x06,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_256x256regs[75] =
{
    0x3c2, 0x00, 0xe3,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x3f,
    0x3d4, 0x02, 0x40,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x4a,
    0x3d4, 0x05, 0x9a,
    0x3d4, 0x06, 0x23,
    0x3d4, 0x07, 0xb2,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x61,
    0x3d4, 0x10, 0x0a,
    0x3d4, 0x11, 0xac,
    0x3d4, 0x12, 0xff,
    0x3d4, 0x13, 0x20,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x07,
    0x3d4, 0x16, 0x1a,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_256x480regs[75] =
{
    0x3c2, 0x00, 0xe3,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x3f,
    0x3d4, 0x02, 0x40,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x4e,
    0x3d4, 0x05, 0x96,
    0x3d4, 0x06, 0x0d,
    0x3d4, 0x07, 0x3e,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x40,
    0x3d4, 0x10, 0xea,
    0x3d4, 0x11, 0xac,
    0x3d4, 0x12, 0xdf,
    0x3d4, 0x13, 0x20,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0xe7,
    0x3d4, 0x16, 0x06,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_320x200regs[75] =
{
    0x3c2, 0x00, 0x63,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x4f,
    0x3d4, 0x02, 0x50,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x54,
    0x3d4, 0x05, 0x80,
    0x3d4, 0x06, 0xbf,
    0x3d4, 0x07, 0x1f,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x41,
    0x3d4, 0x10, 0x9c,
    0x3d4, 0x11, 0x8e,
    0x3d4, 0x12, 0x8f,
    0x3d4, 0x13, 0x28,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x96,
    0x3d4, 0x16, 0xb9,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_320x240regs[75] =
{
    0x3c2, 0x00, 0xe3,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x4f,
    0x3d4, 0x02, 0x50,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x54,
    0x3d4, 0x05, 0x80,
    0x3d4, 0x06, 0x0d,
    0x3d4, 0x07, 0x3e,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x41,
    0x3d4, 0x10, 0xea,
    0x3d4, 0x11, 0xac,
    0x3d4, 0x12, 0xdf,
    0x3d4, 0x13, 0x28,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0xe7,
    0x3d4, 0x16, 0x06,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_320x400regs[75] =
{
    0x3c2, 0x00, 0x63,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x4f,
    0x3d4, 0x02, 0x50,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x54,
    0x3d4, 0x05, 0x80,
    0x3d4, 0x06, 0xbf,
    0x3d4, 0x07, 0x1f,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x40,
    0x3d4, 0x10, 0x9c,
    0x3d4, 0x11, 0x8e,
    0x3d4, 0x12, 0x8f,
    0x3d4, 0x13, 0x28,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x96,
    0x3d4, 0x16, 0xb9,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_320x480regs[75] =
{
    0x3c2, 0x00, 0xe3,
    0x3d4, 0x00, 0x5f,
    0x3d4, 0x01, 0x4f,
    0x3d4, 0x02, 0x50,
    0x3d4, 0x03, 0x82,
    0x3d4, 0x04, 0x54,
    0x3d4, 0x05, 0x80,
    0x3d4, 0x06, 0x0d,
    0x3d4, 0x07, 0x3e,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x40,
    0x3d4, 0x10, 0xea,
    0x3d4, 0x11, 0xac,
    0x3d4, 0x12, 0xdf,
    0x3d4, 0x13, 0x28,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0xe7,
    0x3d4, 0x16, 0x06,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_360x200regs[75] =
{
    0x3c2, 0x00, 0x67,
    0x3d4, 0x00, 0x6b,
    0x3d4, 0x01, 0x59,
    0x3d4, 0x02, 0x5a,
    0x3d4, 0x03, 0x8e,
    0x3d4, 0x04, 0x5e,
    0x3d4, 0x05, 0x8a,
    0x3d4, 0x06, 0xbf,
    0x3d4, 0x07, 0x1f,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x41,
    0x3d4, 0x10, 0x9c,
    0x3d4, 0x11, 0x8e,
    0x3d4, 0x12, 0x8f,
    0x3d4, 0x13, 0x2d,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x96,
    0x3d4, 0x16, 0xb9,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_360x240regs[75] =
{
    0x3c2, 0x00, 0xe7,
    0x3d4, 0x00, 0x6b,
    0x3d4, 0x01, 0x59,
    0x3d4, 0x02, 0x5a,
    0x3d4, 0x03, 0x8e,
    0x3d4, 0x04, 0x5e,
    0x3d4, 0x05, 0x8a,
    0x3d4, 0x06, 0x0d,
    0x3d4, 0x07, 0x3e,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x41,
    0x3d4, 0x10, 0xea,
    0x3d4, 0x11, 0xac,
    0x3d4, 0x12, 0xdf,
    0x3d4, 0x13, 0x2d,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0xe7,
    0x3d4, 0x16, 0x06,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_360x270regs[75] =
{
    0x3c2, 0x00, 0xe7,
    0x3d4, 0x00, 0x6b,
    0x3d4, 0x01, 0x59,
    0x3d4, 0x02, 0x5a,
    0x3d4, 0x03, 0x8e,
    0x3d4, 0x04, 0x5e,
    0x3d4, 0x05, 0x8a,
    0x3d4, 0x06, 0x30,
    0x3d4, 0x07, 0xf0,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x61,
    0x3d4, 0x10, 0x20,
    0x3d4, 0x11, 0xa9,
    0x3d4, 0x12, 0x1b,
    0x3d4, 0x13, 0x2d,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x1f,
    0x3d4, 0x16, 0x2f,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_360x360regs[75] =
{
    0x3c2, 0x00, 0x67,
    0x3d4, 0x00, 0x6b,
    0x3d4, 0x01, 0x59,
    0x3d4, 0x02, 0x5a,
    0x3d4, 0x03, 0x8e,
    0x3d4, 0x04, 0x5e,
    0x3d4, 0x05, 0x8a,
    0x3d4, 0x06, 0xbf,
    0x3d4, 0x07, 0x1f,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x40,
    0x3d4, 0x10, 0x88,
    0x3d4, 0x11, 0x85,
    0x3d4, 0x12, 0x67,
    0x3d4, 0x13, 0x2d,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x6d,
    0x3d4, 0x16, 0xba,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_360x400regs[75] =
{
    0x3c2, 0x00, 0x67,
    0x3d4, 0x00, 0x6b,
    0x3d4, 0x01, 0x59,
    0x3d4, 0x02, 0x5a,
    0x3d4, 0x03, 0x8e,
    0x3d4, 0x04, 0x5e,
    0x3d4, 0x05, 0x8a,
    0x3d4, 0x06, 0xbf,
    0x3d4, 0x07, 0x1f,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x40,
    0x3d4, 0x10, 0x9c,
    0x3d4, 0x11, 0x8e,
    0x3d4, 0x12, 0x8f,
    0x3d4, 0x13, 0x2d,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x96,
    0x3d4, 0x16, 0xb9,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_360x480regs[75] =
{
    0x3c2, 0x00, 0xe7,
    0x3d4, 0x00, 0x6b,
    0x3d4, 0x01, 0x59,
    0x3d4, 0x02, 0x5a,
    0x3d4, 0x03, 0x8e,
    0x3d4, 0x04, 0x5e,
    0x3d4, 0x05, 0x8a,
    0x3d4, 0x06, 0x0d,
    0x3d4, 0x07, 0x3e,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x40,
    0x3d4, 0x10, 0xea,
    0x3d4, 0x11, 0xac,
    0x3d4, 0x12, 0xdf,
    0x3d4, 0x13, 0x2d,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0xe7,
    0x3d4, 0x16, 0x06,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_376x282regs[75] =
{
    0x3c2, 0x00, 0xe7,
    0x3d4, 0x00, 0x6e,
    0x3d4, 0x01, 0x5d,
    0x3d4, 0x02, 0x5e,
    0x3d4, 0x03, 0x91,
    0x3d4, 0x04, 0x62,
    0x3d4, 0x05, 0x8f,
    0x3d4, 0x06, 0x62,
    0x3d4, 0x07, 0xf0,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x61,
    0x3d4, 0x10, 0x37,
    0x3d4, 0x11, 0x89,
    0x3d4, 0x12, 0x33,
    0x3d4, 0x13, 0x2f,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x3c,
    0x3d4, 0x16, 0x5c,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_376x564regs[75] =
{
    0x3c2, 0x00, 0xe7,
    0x3d4, 0x00, 0x6e,
    0x3d4, 0x01, 0x5d,
    0x3d4, 0x02, 0x5e,
    0x3d4, 0x03, 0x91,
    0x3d4, 0x04, 0x62,
    0x3d4, 0x05, 0x8f,
    0x3d4, 0x06, 0x62,
    0x3d4, 0x07, 0xf0,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x60,
    0x3d4, 0x10, 0x37,
    0x3d4, 0x11, 0x89,
    0x3d4, 0x12, 0x33,
    0x3d4, 0x13, 0x2f,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x3c,
    0x3d4, 0x16, 0x5c,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_400x300regs[78] =
{
    0x3c2, 0x00, 0xa7,
    0x3d4, 0x00, 0x71,
    0x3d4, 0x01, 0x63,
    0x3d4, 0x02, 0x64,
    0x3d4, 0x03, 0x92,
    0x3d4, 0x04, 0x65,
    0x3d4, 0x05, 0x82,
    0x3d4, 0x06, 0x46,
    0x3d4, 0x07, 0x1f,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x40,
    0x3d4, 0x10, 0x31,
    0x3d4, 0x11, 0x80,
    0x3d4, 0x12, 0x2b,
    0x3d4, 0x13, 0x32,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x2f,
    0x3d4, 0x16, 0x44,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x02, 0x0f,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

unsigned short ModeX_400x600regs[78] =
{
    0x3c2, 0x00, 0xe7,
    0x3d4, 0x00, 0x70,
    0x3d4, 0x01, 0x63,
    0x3d4, 0x02, 0x64,
    0x3d4, 0x03, 0x92,
    0x3d4, 0x04, 0x65,
    0x3d4, 0x05, 0x82,
    0x3d4, 0x06, 0x70,
    0x3d4, 0x07, 0xf0,
    0x3d4, 0x08, 0x00,
    0x3d4, 0x09, 0x60,
    0x3d4, 0x10, 0x5b,
    0x3d4, 0x11, 0x8c,
    0x3d4, 0x12, 0x57,
    0x3d4, 0x13, 0x32,
    0x3d4, 0x14, 0x00,
    0x3d4, 0x15, 0x58,
    0x3d4, 0x16, 0x70,
    0x3d4, 0x17, 0xe3,
    0x3c4, 0x01, 0x01,
    0x3c4, 0x02, 0x0f,
    0x3c4, 0x04, 0x06,
    0x3ce, 0x05, 0x40,
    0x3ce, 0x06, 0x05,
    0x3c0, 0x10, 0x41,
    0x3c0, 0x13, 0x00
};

void calc_rows(void)
{
    int i;

    // Each byte addresses four pixels, so the width of a scan line
    // in *bytes* is one fourth of the number of pixels on a line.
    widthBytes = width / 4;

    pageSize = (widthBytes * height);

    for (i=0; i < height; i++) {
        RowsX[i] = (unsigned char *)((0xA000 << 4) + (widthBytes * i));
    }

    // Clear entire video memory, by selecting all four planes, then
    // writing 0 to entire segment.
    outpw(SEQU_ADDR, ALL_PLANES);
    memset((unsigned char *)(0xA000 << 4), 0x00, 0x00010000);

    // By default we want screen refreshing and drawing operations
    // to be based at offset 0 in the video segment.
    activeStart = visibleStart = 0;

    // Set current plane to invalid value
    write_plane = -1;
    read_plane  = -1;

    // How many pages fit in 256K VGA Card?
    num_pages = ((64 * 1024) / pageSize);

    for (i=0; i < num_pages; i++)
    {
        page_offset[i] = (pageSize * i);
        page_mask_high[i] = (0x0C |  (page_offset[i] & 0xFF00));
        page_mask_low[i]  = (0x0D | ((page_offset[i] & 0x00FF) << 8));
    }
}

//    setBaseXMode() does the initialization to make the VGA ready to
//    accept any combination of configuration register settings.  This
//    involves enabling writes to index 0 to 7 of the CRT controller (port
//    0x3D4), by clearing the most significant bit (bit 7) of index 0x11.
void setBaseXMode(void)
{
    int temp;
    union REGS r;

    r.x.eax = 0x0013;
    int386(0x10, &r, &r);

    outp(0x3D4, 0x11);
    temp = inp(0x3D5) & 0x7F;
    outp(0x3D4, 0x11);
    outp(0x3D5, temp);
}

void outReg(unsigned short *r)
{
    switch (r[0]) {
        // First handle special cases:

		case ATTRCON_ADDR:
            // reset read/write flip-flop
            inp(STATUS_ADDR);
            outp(ATTRCON_ADDR, r[1] | 0x20);
            // ensure VGA output is enabled
            outp(ATTRCON_ADDR, r[2]);
			break;

		case MISC_ADDR:
		case VGAENABLE_ADDR:
            // Copy directly to port
            outp(r[0], r[2]);
			break;

        case SEQU_ADDR:
		case GRACON_ADDR:
		case CRTC_ADDR:
        default:
            // Index to port
            outp(r[0], r[1]);
            // Value to port+1
            outp(r[0] + 1, r[2]);
			break;
    }
}

void outRegArray(unsigned short *r, int n)
{
    while (n--) {
        outReg(r);
        r += 3;
    }
}

void set80x25(void)
{
    union REGS r;
    r.x.eax = 0x0003;

    int386(0x10, &r, &r);
}

void set256x224x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_256x224regs, 25);

    width  = 256;
    height = 224;

    calc_rows();
}

void set256x240x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_256x240regs, 25);

    width  = 256;
    height = 240;

    calc_rows();
}

void set256x256x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_256x256regs, 25);

    width  = 256;
    height = 256;

    calc_rows();
}

void set256x480x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_256x480regs, 25);

    width  = 256;
    height = 480;

    calc_rows();
}

void set320x200x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_320x200regs, 25);

    width  = 320;
    height = 200;

    calc_rows();
}

void set320x240x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_320x240regs, 25);

    width  = 320;
    height = 240;

    calc_rows();
}

void set320x400x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_320x400regs, 25);

    width  = 320;
    height = 400;

    calc_rows();
}

void set320x480x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_320x480regs, 25);

    width  = 320;
    height = 480;

    calc_rows();
}

void set360x200x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_360x200regs, 25);

    width  = 360;
    height = 200;

    calc_rows();
}

void set360x240x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_360x240regs, 25);

    width  = 360;
    height = 240;

    calc_rows();
}

void set360x270x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_360x270regs, 25);

    width  = 360;
    height = 270;

    calc_rows();
}

void set360x360x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_360x360regs, 25);

    width  = 360;
    height = 360;

    calc_rows();
}

void set360x400x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_360x400regs, 25);

    width  = 360;
    height = 400;

    calc_rows();
}

void set360x480x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_360x480regs, 25);

    width  = 360;
    height = 480;

    calc_rows();
}

void set376x282x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_376x282regs, 25);

    width  = 376;
    height = 282;

    calc_rows();
}

void set376x564x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_376x564regs, 25);

    width  = 376;
    height = 564;

    calc_rows();
}

void set400x300x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_400x300regs, 26);

    width  = 400;
    height = 300;

    calc_rows();
}

void set400x600x256_X(void)
{
    setBaseXMode();
    outRegArray(ModeX_400x600regs, 26);

    width  = 400;
    height = 600;

    calc_rows();
}

COORD get_xres(void)
{
    return width;
}

COORD get_yres(void)
{
    return height;
}

void set_write_plane(unsigned short int plane_mask)
{
    write_plane = -1;
    outpw(SEQU_ADDR, plane_mask);
}

void set_read_plane(unsigned short int plane_mask)
{
    read_plane = -1;
    outpw(GRACON_ADDR, plane_mask);
}

void copy_page_x( int pg )
{
    BYTE temp;

    COORD xxx, yyy;

    for ( xxx = 0; xxx < 319; xxx++ )
    {
        for ( yyy = 0; yyy < 239; yyy++ )
        {
            if ( write_plane != (temp = (xxx & 3) ) )
            {
                write_plane = temp;
                outpw( SEQU_ADDR, plane_mask[temp] );
            }
            *(RowsX[yyy] + (xxx >> 2) + activeStart ) = page[pg][ ( 320 * yyy ) + xxx ];
        }
    }
}

void clear_page_x( void )
{
    BYTE temp;

    COORD xxx, yyy;

    for ( xxx = 0; xxx < 319; xxx++ )
    {
        for ( yyy = 0; yyy < 239; yyy++ )
        {
            if ( write_plane != (temp = (xxx & 3) ) )
            {
                write_plane = temp;
                outpw( SEQU_ADDR, plane_mask[temp] );
            }
            *(RowsX[yyy] + (xxx >> 2) + activeStart ) = 0;
        }
    }
}


