DEFINT A-Z

DECLARE SUB Center (x, Text$)
DECLARE SUB DisplayHelp ()
DECLARE SUB DrawBox (x, y, w, h, Shadow)
DECLARE SUB Help ()
DECLARE SUB Main ()
DECLARE SUB ReadHelp ()
OPTION BASE 0
COMMON SHARED CursorX, FileName$, HelpFile$, Lines
ON ERROR GOTO ErrorTrap
DIM SHARED HelpText$(250)
ERASE HelpText$
SCREEN 0: WIDTH 80, 50: COLOR 7, 0: CLS
ReadHelp
CALL Main

ErrorTrap:
PCOPY 0, 2
Choice = 1: e = ERR
COLOR 12, 4
DrawBox 10, 25, 26, 3, 1
COLOR 14, 4: LOCATE 11
 IF e = 7 OR e = 14 THEN
  Center 0, "Not enough memory."
 ELSEIF e = 53 THEN
  Center 0, "Cannot find " + FileName$ + "."
 ELSEIF e = 55 THEN
  Center 0, FileName$ + " already"
  Center 0, "opened."
 ELSEIF e = 61 THEN
  Center 0, "The disk is full."
 ELSEIF e = 62 THEN
  Center 0, "Error while reading"
  Center 0, FileName$ + "."
 ELSEIF e = 70 THEN
  Center 0, "The disk or file is"
  Center 0, "write protected."
 ELSEIF e = 71 THEN
  Center 0, "There is no disk in"
  Center 0, "the diskdrive."
 ELSEIF e = 72 THEN
  Center 0, "The disk is damaged."
 ELSEIF e = 75 THEN
  Center 0, "Cannot open file."
 ELSE
  Center 0, "Unexpected error."
 END IF
COLOR , 7
 DO
   IF Choice = 1 THEN COLOR 15 ELSE COLOR 0
  LOCATE 13, 28: PRINT " Retry ";
   IF Choice = 2 THEN COLOR 15 ELSE COLOR 0
  LOCATE , 36: PRINT " Ignore ";
   IF Choice = 3 THEN COLOR 15 ELSE COLOR 0
  LOCATE , 45: PRINT " Quit "
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "K" THEN
    IF Choice > 1 THEN Choice = Choice - 1 ELSE Choice = 3
   ELSEIF Key$ = CHR$(0) + "M" THEN
    IF Choice < 3 THEN Choice = Choice + 1 ELSE Choice = 1
   ELSEIF Key$ = CHR$(13) THEN
    IF Choice = 1 THEN PCOPY 2, 0: RESUME
    IF Choice = 2 THEN PCOPY 2, 0: RESUME NEXT
    IF Choice = 3 THEN WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
   END IF
 LOOP

SUB Center (x, Text$)
 IF x > 0 THEN LOCATE x
LOCATE , 40 - (LEN(Text$) / 2)
PRINT Text$
END SUB

SUB DisplayHelp
Row = 2
 FOR HLine = CursorX TO CursorX + 42
  l = LEN(HelpText$(HLine)): LOCATE Row, 2
   IF HelpText$(HLine) = "-" THEN
    PRINT STRING$(78, "")
   ELSEIF HelpText$(HLine) = "=" THEN
    PRINT STRING$(78, "")
   ELSEIF LEFT$(HelpText$(HLine), 1) = ">" THEN
    PRINT SPACE$(78)
    Center Row, MID$(HelpText$(HLine), 2)
   ELSE
    PRINT " "; HelpText$(HLine); SPACE$(77 - l)
   END IF
  Row = Row + 1
 NEXT HLine
END SUB

SUB DrawBox (x, y, w, h, Shadow)
LOCATE x, y: PRINT ""; STRING$(w, ""); ""
 FOR BoxX = 1 TO h
  LOCATE , y: PRINT ""; SPC(w); "";
   IF Shadow THEN PRINT "" ELSE PRINT
 NEXT BoxX
LOCATE , y: PRINT ""; STRING$(w, ""); "";
 IF Shadow THEN PRINT "": LOCATE , y + 1: PRINT STRING$(w + 2, "")
END SUB

SUB Main
COLOR , 0: CLS
CursorX = 0
COLOR 15, 2: LOCATE 48: PRINT " Use "; CHR$(24) + " and " + CHR$(25) + " to scroll.   Press Escape to go back."; SPACE$(30)
COLOR 0, 7: DrawBox 1, 1, 78, 45, 0
Center 1, " Help "
 DO
  DisplayHelp
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "H" THEN
    IF CursorX > 0 THEN CursorX = CursorX - 1
   ELSEIF Key$ = CHR$(0) + "P" THEN
    IF CursorX < Lines - 42 THEN CursorX = CursorX + 1
   ELSEIF Key$ = CHR$(27) THEN
    IF HelpFile$ = "Help" THEN
     RUN "Space"
    ELSEIF HelpFile$ = "Help2" THEN
     RUN "Setup"
    END IF
   END IF
 LOOP
END SUB

SUB ReadHelp
FileName$ = "Space.tmp"
OPEN "Space.tmp" FOR BINARY AS 1
 IF LOF(1) > 0 THEN
  SpaceActive$ = INPUT$(1, 1): CLOSE 1
 ELSE
  CLOSE 1: KILL "Space.tmp"
 END IF
FileName$ = "Setup.tmp"
 OPEN "Setup.tmp" FOR BINARY AS 1
  IF LOF(1) > 0 THEN
   SetupActive$ = INPUT$(1, 1): CLOSE 1
  ELSE
   CLOSE 1: KILL "Setup.tmp"
  END IF

 IF SetupActive$ = CHR$(1) THEN
  HelpFile$ = "Help2"
 ELSEIF SpaceActive$ = CHR$(1) THEN
  HelpFile$ = "Help"
 ELSE
  COLOR 7, 0: CLS
  PRINT "This program cannot be executed outside Setup or Space."
  PRINT
  PRINT "Press Enter to continue."
   DO UNTIL INKEY$ = CHR$(13): LOOP
  SYSTEM
 END IF
FileName$ = HelpFile$ + ".hlp"
OPEN HelpFile$ + ".hlp" FOR INPUT AS 1: CLOSE 1
OPEN HelpFile$ + ".hlp" FOR BINARY AS 1
 FOR HLine = 0 TO 250
   IF LOC(1) = LOF(1) THEN Lines = HLine: EXIT FOR
  l = ASC(INPUT$(1, 1))
  HelpText$(HLine) = INPUT$(l, 1)
 NEXT HLine
CLOSE 1
END SUB

