DEFINT A-Z

DECLARE SUB Center (x, Text$)
DECLARE SUB DrawBox (x, y, w, h, Shadow)
DECLARE SUB DrawMenu (CursorX, Pressed)
DECLARE SUB LoadSettings ()
DECLARE SUB LoadShips ()
DECLARE SUB MakeButton (x, y, Text$, Selected)
DECLARE SUB Menu ()
DECLARE SUB PressButton (x, y, Text$)
DECLARE SUB SaveSettings ()
DECLARE SUB SelectShip ()
DECLARE SUB SetLevel ()
DECLARE SUB SetNumberOfLives ()
DECLARE SUB SetSensitivity ()
DECLARE SUB TestJoystick ()
OPTION BASE 0
COMMON SHARED FileName$, JoystickOn, Level, Lives, Sensitivity, ShipColor, ShipType, SoundOn
ON ERROR GOTO ErrorTrap
DIM SHARED Ship$(2, 3)
DIM SHARED MenuHelp$(9), Option$(9), State$(-1 TO 0)
ERASE MenuHelp$, Option$, State$
State$(-1) = " on"
State$(0) = " off"
SCREEN 0: WIDTH 80, 50: COLOR 7, 0: CLS
PALETTE 5, 56
LoadSettings
LoadShips
CALL Menu

ErrorTrap:
PCOPY 0, 2
Choice = 1
e = ERR
COLOR 12, 4
DrawBox 10, 25, 26, 3, 1
COLOR 14, 4: LOCATE 11
 IF e = 7 OR e = 14 THEN
  Center 0, "Not enough memory."
 ELSEIF e = 53 THEN
  Center 0, "Cannot find " + FileName$ + "."
 ELSEIF e = 55 THEN
  Center 0, FileName$ + " already"
  Center 0, "opened."
 ELSEIF e = 61 THEN
  Center 0, "The disk is full."
 ELSEIF e = 62 THEN
  Center 0, "Error while reading"
  Center 0, FileName$ + "."
 ELSEIF e = 70 THEN
  Center 0, "The disk or file is"
  Center 0, "write protected."
 ELSEIF e = 71 THEN
  Center 0, "There is no disk in"
  Center 0, "the diskdrive."
 ELSEIF e = 72 THEN
  Center 0, "The disk is damaged."
 ELSEIF e = 75 THEN
  Center 0, "Cannot open file."
 ELSE
  Center 0, "Unexpected error."
 END IF
COLOR , 7
 DO
   IF Choice = 1 THEN COLOR 15 ELSE COLOR 0
  LOCATE 13, 28: PRINT " Retry ";
   IF Choice = 2 THEN COLOR 15 ELSE COLOR 0
  LOCATE , 36: PRINT " Ignore ";
   IF Choice = 3 THEN COLOR 15 ELSE COLOR 0
  LOCATE , 45: PRINT " Quit "
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "K" THEN
    IF Choice > 1 THEN Choice = Choice - 1 ELSE Choice = 3
   ELSEIF Key$ = CHR$(0) + "M" THEN
    IF Choice < 3 THEN Choice = Choice + 1 ELSE Choice = 1
   ELSEIF Key$ = CHR$(13) THEN
    IF Choice = 1 THEN PCOPY 2, 0: RESUME
    IF Choice = 2 THEN PCOPY 2, 0: RESUME NEXT
    IF Choice = 3 THEN WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
   END IF
 LOOP

SUB Center (x, Text$)
 IF x > 0 THEN LOCATE x
LOCATE , 40 - (LEN(Text$) / 2)
PRINT Text$
END SUB

SUB DrawBox (x, y, w, h, Shadow)
LOCATE x, y: PRINT ""; STRING$(w, ""); ""
 FOR BoxX = 1 TO h
  LOCATE , y: PRINT ""; SPC(w); "";
   IF Shadow THEN PRINT "" ELSE PRINT
 NEXT BoxX
LOCATE , y: PRINT ""; STRING$(w, ""); "";
 IF Shadow THEN PRINT "": LOCATE , y + 1: PRINT STRING$(w + 2, "")
END SUB

SUB DrawMenu (CursorX, Pressed)
COLOR 15, 2
LOCATE 44: PRINT " Use "; CHR$(24); "/"; CHR$(25); " to move the cursor and press Enter to select."; SPACE$(26)
COLOR , 1
LOCATE 1, 1: PRINT " Setup for Space, by: Peter Swinkels, ***1999*** "; SPACE$(30);
COLOR 3, 0: PRINT "": PRINT " "; STRING$(79, "")
COLOR 10: LOCATE 45: PRINT STRING$(80, ""); SPACE$(80)
COLOR 11: Center 46, MenuHelp$(CursorX)
COLOR 10: PRINT STRING$(80, "")
Row = 4
Column = 3
 FOR Button = 0 TO 9
   IF Button = CursorX THEN Highlight = -1 ELSE Highlight = 0
   IF Button = Pressed THEN
    PressButton Row, Column, " " + Option$(Button) + SPACE$(27 - LEN(Option$(Button)))
   ELSE
    MakeButton Row, Column, " " + Option$(Button) + SPACE$(27 - LEN(Option$(Button))), Highlight
   END IF
   IF Row = 36 THEN Row = 4: Column = Column + 30 ELSE Row = Row + 4
 NEXT Button
END SUB

SUB LoadSettings
FileName$ = "Setup.tmp"
OPEN "Setup.tmp" FOR OUTPUT AS 1
 PRINT #1, CHR$(1);
CLOSE 1
FileName$ = "Space.set"
OPEN "Space.set" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1: KILL "space.set"
  SoundOn = -1: JoystickOn = 0: Lives = 5
  Sensitivity = 0: ShipType = 0: ShipColor = 15
 ELSE
  SoundOn = -ASC(INPUT$(1, 1))
  JoystickOn = -ASC(INPUT$(1, 1))
  Lives = ASC(INPUT$(1, 1))
  Sensitivity = 20 - ASC(INPUT$(1, 1))
  Level = ASC(INPUT$(1, 1))
  ShipType = ASC(INPUT$(1, 1))
  ShipColor = ASC(INPUT$(1, 1))
 END IF
CLOSE 1
END SUB

SUB LoadShips
FileName$ = "Space.dat"
OPEN "Space.dat" FOR INPUT AS 1: CLOSE 1
OPEN "Space.dat" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1: KILL "Space.dat"
 ELSE
  FOR Ship = 0 TO 3
   FOR Row = 0 TO 2
    Ship$(Row, Ship) = INPUT$(3, 1)
    EnemyTmp$ = INPUT$(3, 1)
   NEXT Row
  NEXT Ship
 END IF
CLOSE 1
END SUB

SUB MakeButton (x, y, Text$, Selected)
l = LEN(Text$)
COLOR 7, 0: LOCATE x, y: PRINT STRING$(l, "")
 IF Selected THEN COLOR 15 ELSE COLOR 0
COLOR , 7: LOCATE , y: PRINT Text$;
COLOR 8: PRINT ""
COLOR 7, 0: LOCATE , y: PRINT "";
COLOR , 5: PRINT STRING$(l - 1, "");
COLOR 8: PRINT ""
END SUB

SUB Menu
Option$(0) = "The sound is" + State$(SoundOn)
Option$(1) = "The joystick is" + State$(JoystickOn)
Option$(2) = "Test the joystick"
Option$(3) = "Joystick sensitivity"
Option$(4) = "Level"
Option$(5) = "Number of lives"
Option$(6) = "Select a ship"
Option$(7) = "Save the settings"
Option$(8) = "Help"
Option$(9) = "Quit"
MenuHelp$(0) = "Turn the sound on or off."
MenuHelp$(1) = "Turn the joystick on or off."
MenuHelp$(2) = "Test the joystick."
MenuHelp$(3) = "Set the joystick's sensitivity."
MenuHelp$(4) = "Set the level."
MenuHelp$(5) = "Set the number of lives."
MenuHelp$(6) = "Select a ship."
MenuHelp$(7) = "Save the settings."
MenuHelp$(8) = "Help."
MenuHelp$(9) = "Exit this program."
CursorX = 0
Pressed = -1
 DO
  DrawMenu CursorX, Pressed
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "H" THEN
    IF CursorX = 0 THEN CursorX = 9 ELSE CursorX = CursorX - 1
   ELSEIF Key$ = CHR$(0) + "P" THEN
    IF CursorX = 9 THEN CursorX = 0 ELSE CursorX = CursorX + 1
   ELSEIF Key$ = CHR$(13) THEN
    Pressed = CursorX
    DrawMenu CursorX, Pressed
    Pressed = -1
    PCOPY 0, 1
     IF CursorX = 0 THEN SoundOn = NOT SoundOn: Option$(0) = "The sound is" + State$(SoundOn)
     IF CursorX = 1 THEN JoystickOn = NOT JoystickOn: Option$(1) = "The joystick is" + State$(JoystickOn)
     IF CursorX = 2 THEN TestJoystick
     IF CursorX = 3 THEN SetSensitivity
     IF CursorX = 4 THEN SetLevel
     IF CursorX = 5 THEN SetNumberOfLives
     IF CursorX = 6 THEN SelectShip
     IF CursorX = 7 THEN SaveSettings
     IF CursorX = 8 THEN FileName$ = "Help.exe": RUN "Help"
     IF CursorX = 9 THEN
      FileName$ = "Setup.tmp"
      KILL "Setup.tmp"
      FileName$ = "Space.tmp"
      OPEN "Space.tmp" FOR BINARY AS 1
       IF LOF(1) > 0 THEN
        SpaceActive$ = INPUT$(1, 1): CLOSE 1
       ELSE
        CLOSE 1: KILL "Space.tmp"
       END IF
      IF SpaceActive$ = CHR$(1) THEN
       RUN "Space"
      ELSE
       COLOR 7, 0: CLS : WIDTH 80, 25: SYSTEM
      END IF
     END IF
    PCOPY 1, 0
   END IF
 LOOP
END SUB

SUB PressButton (x, y, Text$)
DIM PrevTime AS SINGLE

l = LEN(Text$)
COLOR , 0

LOCATE x, y: PRINT SPACE$(l + 1)
LOCATE , y: PRINT SPACE$(l + 1)
LOCATE , y: PRINT SPACE$(l + 1)

COLOR 7: LOCATE x + 1, y + 1: PRINT STRING$(l, "")
COLOR 0, 7: LOCATE , y + 1: PRINT Text$
COLOR 7, 0: LOCATE , y + 1: PRINT STRING$(l, "")
PrevTime = TIMER
 DO UNTIL TIMER > PrevTime + .1 OR TIMER < 3
  Buffer$ = INKEY$
 LOOP

LOCATE x + 1, y + 1: PRINT SPACE$(l)
LOCATE , y + 1: PRINT SPACE$(l)
LOCATE , y + 1: PRINT SPACE$(l)
MakeButton x, y, Text$, -1
END SUB

SUB SaveSettings
FileName$ = "Space.set"
OPEN "Space.set" FOR OUTPUT AS 1
 PRINT #1, CHR$(-SoundOn); CHR$(-JoystickOn); CHR$(Lives); CHR$(20 - Sensitivity); CHR$(Level); CHR$(ShipType); CHR$(ShipColor);
CLOSE 1
END SUB

SUB SelectShip
COLOR 15, 0
Center 46, "Use " + CHR$(24) + "/" + CHR$(25) + " to select a ship. Use " + CHR$(27) + "/" + CHR$(26) + " to change the color."
 DO
  COLOR ShipColor
  LOCATE 9, 35: PRINT Ship$(0, ShipType)
  LOCATE , 35: PRINT Ship$(1, ShipType)
  COLOR 12
  LOCATE , 35: PRINT Ship$(2, ShipType)
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "H" THEN
    IF ShipType = 0 THEN ShipType = 3 ELSE ShipType = ShipType - 1
   ELSEIF Key$ = CHR$(0) + "P" THEN
    IF ShipType = 3 THEN ShipType = 0 ELSE ShipType = ShipType + 1
   ELSEIF Key$ = CHR$(0) + "K" THEN
    IF ShipColor = 1 THEN ShipColor = 15 ELSE ShipColor = ShipColor - 1
   ELSEIF Key$ = CHR$(0) + "M" THEN
    IF ShipColor = 15 THEN ShipColor = 1 ELSE ShipColor = ShipColor + 1
   ELSEIF Key$ = CHR$(27) THEN
    EXIT DO
   END IF
 LOOP
END SUB

SUB SetLevel
COLOR 15, 0
Center 46, "Use the  + and - keys to set the level."
LOCATE 41, 19: PRINT "Level:"
COLOR 3, 1: LOCATE , 4: PRINT STRING$(51, "")
COLOR 15, 0: LOCATE , 3: PRINT "-";
COLOR 3, 1: PRINT STRING$(51, "");
COLOR 15, 0: PRINT "+"

 DO
  COLOR 1, 15
  LOCATE 42, Level + 4: PRINT ""
  LOCATE , Level + 4: PRINT ""
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  COLOR 3, 1
  LOCATE 42, Level + 4: PRINT ""
  LOCATE , Level + 4: PRINT ""
   IF Key$ = "+" THEN
    IF Level = 50 THEN Level = 0 ELSE Level = Level + 1
   ELSEIF Key$ = "-" THEN
    IF Level = 0 THEN Level = 50 ELSE Level = Level - 1
   ELSEIF Key$ = CHR$(27) THEN
    EXIT DO
   END IF
 LOOP
END SUB

SUB SetNumberOfLives
COLOR 15, 0
Center 46, "Use the + and - keys to set the number of lives."
LOCATE 41, 4: PRINT "Number of lives:  0"
COLOR 3, 1: LOCATE , 4: PRINT STRING$(50, "")
COLOR 15, 0: LOCATE , 3: PRINT "-";
COLOR 3, 1: PRINT STRING$(50, "");
COLOR 15, 0: PRINT "+"

 DO
  COLOR 15, 0: LOCATE 41, 4: PRINT USING "Number of lives: ##"; Lives
  COLOR 1, 15
  LOCATE 42, (Lives * 2) + 2: PRINT ""
  LOCATE , (Lives * 2) + 2: PRINT ""
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  COLOR 3, 1
  LOCATE 42, (Lives * 2) + 2: PRINT ""
  LOCATE , (Lives * 2) + 2: PRINT ""
   IF Key$ = "+" THEN
    IF Lives = 25 THEN Lives = 1 ELSE Lives = Lives + 1
   ELSEIF Key$ = "-" THEN
    IF Lives = 1 THEN Lives = 25 ELSE Lives = Lives - 1
   ELSEIF Key$ = CHR$(27) THEN
    EXIT DO
   END IF
 LOOP
END SUB

SUB SetSensitivity
COLOR 15, 0
Center 46, "Use the + and - keys to set the joystick's sensitivity."
LOCATE 41, 8: PRINT "Sensitivity:"
COLOR 3, 1: LOCATE , 4: PRINT STRING$(42, "")
COLOR 15, 0: LOCATE , 3: PRINT "-";
COLOR 3, 1: PRINT STRING$(42, "");
COLOR 15, 0: PRINT "+"

 DO
  COLOR 1, 15
  LOCATE 42, (Sensitivity * 2) + 4: PRINT ""
  LOCATE , (Sensitivity * 2) + 4: PRINT ""
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  COLOR 3, 1
  LOCATE 42, (Sensitivity * 2) + 4: PRINT ""
  LOCATE , (Sensitivity * 2) + 4: PRINT ""
   IF Key$ = "+" THEN
    IF Sensitivity = 20 THEN Sensitivity = 0 ELSE Sensitivity = Sensitivity + 1
   ELSEIF Key$ = "-" THEN
    IF Sensitivity = 0 THEN Sensitivity = 20 ELSE Sensitivity = Sensitivity - 1
   ELSEIF Key$ = CHR$(27) THEN
    EXIT DO
   END IF
 LOOP
END SUB

SUB TestJoystick
CursorX = 4: CursorY = 4
DirectionX = 0: DirectionY = 0
COLOR 15, 0
Center 20, "Make sure the jostick's stick is centered."
CntrdStckX = STICK(0): CntrdStckY = STICK(1)
Key$ = INPUT$(1)
LOCATE 20, 1: PRINT SPACE$(80)
DrawMenu 0, -1
COLOR 11, 0: Center 46, "Move the joystick's stick to check if the cursor reacts properly."
 DO
  COLOR 0, 7: DrawBox 10, 34, 10, 10, 1
  LOCATE 24, 38: PRINT " Fire "
  COLOR 8: LOCATE CursorX + 11, CursorY + 35: PRINT ""
   IF STRIG(1) OR STRIG(5) THEN
    COLOR 15, 4
     IF STRIG(1) THEN LOCATE 24, 38: PRINT " Fire "
    PrevTime = TIMER
     DO UNTIL TIMER > PrevTime + .1 OR TIMER < 3: LOOP
   END IF
   IF STICK(0) < CntrdStckX - Sensitivity THEN
    DirectionY = 1
   ELSEIF STICK(0) > CntrdStckX + Sensitivity THEN
    DirectionY = 2
   ELSE
    DirectionY = 0
   END IF
   IF STICK(1) < CntrdStckY - Sensitivity THEN
    DirectionX = 1
   ELSEIF STICK(1) > CntrdStckY + Sensitivity THEN
    DirectionX = 2
   ELSE
    DirectionX = 0
   END IF
   IF DirectionX = 1 THEN
    IF CursorX > 0 THEN CursorX = CursorX - 1
   ELSEIF DirectionX = 2 THEN
    IF CursorX < 9 THEN CursorX = CursorX + 1
   END IF
   IF DirectionY = 1 THEN
    IF CursorY > 0 THEN CursorY = CursorY - 1
   ELSEIF DirectionY = 2 THEN
    IF CursorY < 9 THEN CursorY = CursorY + 1
   END IF
 LOOP UNTIL INKEY$ = CHR$(27)
END SUB

