DEFINT A-Z

DECLARE SUB AddNewEnemy ()
DECLARE SUB AddScore ()
DECLARE SUB Center (x, Text$)
DECLARE SUB Choose (x, y, Text$, Choice$, Choices$)
DECLARE SUB DisplayNextLevelEntered ()
DECLARE SUB DisplayScores ()
DECLARE SUB DisplayStatus ()
DECLARE SUB DisplayTitle ()
DECLARE SUB DrawBox (x, y, w, h, Shadow)
DECLARE SUB DrawMenu ()
DECLARE SUB EnemyDestroyed (Enemy)
DECLARE SUB FireTorpedo ()
DECLARE SUB GameOver ()
DECLARE SUB GetJoystickStatus ()
DECLARE SUB GotoNextLevel ()
DECLARE SUB InputBox (x, y, Prompt$, Text$, MaxLength)
DECLARE SUB LoadGraphicsData ()
DECLARE SUB LoadSettings ()
DECLARE SUB Main ()
DECLARE SUB MakeStars ()
DECLARE SUB Menu ()
DECLARE SUB MoveEnemies ()
DECLARE SUB MoveEnemyTorpedoes ()
DECLARE SUB MoveShip ()
DECLARE SUB MoveStars ()
DECLARE SUB MoveTorpedoes ()
DECLARE SUB Pause ()
DECLARE SUB PlaySound (SoundN)
DECLARE SUB ShipDestroyed ()
OPTION BASE 0
COMMON SHARED Destroyed, DirectionX, DirectionY, ShipColor, ShipType, ShipX, ShipY, Torpedoes, TorpedoesLeft
COMMON SHARED EnemiesLeft, Enemies
COMMON SHARED CntrdStckX, CntrdStckY, EndLevel, FileName$, JoystickOn, Level, Lives
COMMON SHARED Name$, NextLevelEntered, Score, Sensitivity, ShipsDestroyed, SoundOn, StartLevel
ON ERROR GOTO ErrorTrap
DIM SHARED Ship$(2, 3), TorpedoActive(5), TorpedoX(5), TorpedoY(5)
DIM SHARED Enemy$(2, 3), EnemyX(5), EnemyY(5), EnmActive(5), EnmColor(5), EnmDestroyed(5), EnmShipType(5)
DIM SHARED EnmPalette(3), EnmTorpedoActive(5), EnmTorpedoX(5), EnmTorpedoY(5)
DIM SHARED StarColor(50), StarPalette(3), StarX(50), StarY(50), StarZ(50)
DIM SHARED DelayStart(9) AS SINGLE, ExplPalette(3), ExplPic$(3), MenuHelp$(4), Option$(4)
DIM SHARED ScrDate$(15), ScrEndLevel(15), ScrName$(15), ScrScore$(15), ScrStartLevel(15)
ERASE Ship$, TorpedoActive, TorpedoX, TorpedoY
ERASE Enemy$, EnemyX, EnemyY, EnmActive, EnmDestroyed
ERASE EnmTorpedoActive, EnmTorpedoX, EnmTorpedoY
ERASE StarColor, StarPalette, StarX, StarY, StarZ
ERASE DelayStart, ExplPalette, ExplPic$, MenuHelp$, Option$
ERASE ScrDate$, ScrEndLevel, ScrName$, ScrScore$, ScrStartLevel
Destroyed = 0: DirectionX = 0: DirectionY = 0
Enemies = 0: EnemiesLeft = 0: Torpedoes = 0
TorpedoesLeft = 0: Score = 0: ShipsDestroyed = 0: ShipX = 20: ShipY = 38
PLAY "MB ML"
DEF SEG = 47104
SCREEN 0: WIDTH 80, 50: COLOR 7, 0: CLS
LoadSettings
LoadGraphicsData
CALL Menu
CALL Main

ErrorTrap:
PCOPY 0, 2
Choice = 1: e = ERR
COLOR 12, 4
DrawBox 10, 25, 26, 3, 1
COLOR 14, 4: LOCATE 11
 IF e = 7 OR e = 14 THEN
  Center 0, "Not enough memory."
 ELSEIF e = 53 THEN
  Center 0, "Cannot find " + FileName$ + "."
 ELSEIF e = 55 THEN
  Center 0, FileName$ + " already"
  Center 0, "opened."
 ELSEIF e = 61 THEN
  Center 0, "The disk is full."
 ELSEIF e = 62 THEN
  Center 0, "Error while reading"
  Center 0, FileName$ + "."
 ELSEIF e = 70 THEN
  Center 0, "The disk or file is"
  Center 0, "write protected."
 ELSEIF e = 71 THEN
  Center 0, "There is no disk in"
  Center 0, "the diskdrive."
 ELSEIF e = 72 THEN
  Center 0, "The disk is damaged."
 ELSEIF e = 75 THEN
  Center 0, "Cannot open file."
 ELSE
  Center 0, "Unexpected error."
 END IF
COLOR , 7
 DO
   IF Choice = 1 THEN COLOR 15 ELSE COLOR 0
  LOCATE 13, 28: PRINT " Retry ";
   IF Choice = 2 THEN COLOR 15 ELSE COLOR 0
  LOCATE , 36: PRINT " Ignore ";
   IF Choice = 3 THEN COLOR 15 ELSE COLOR 0
  LOCATE , 45: PRINT " Quit "
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
   IF Key$ = CHR$(0) + "K" THEN
    IF Choice > 1 THEN Choice = Choice - 1 ELSE Choice = 3
   ELSEIF Key$ = CHR$(0) + "M" THEN
    IF Choice < 3 THEN Choice = Choice + 1 ELSE Choice = 1
   ELSEIF Key$ = CHR$(13) THEN
    IF Choice = 1 THEN PCOPY 2, 0: RESUME
    IF Choice = 2 THEN PCOPY 2, 0: RESUME NEXT
    IF Choice = 3 THEN WIDTH 80, 25: COLOR 7, 0: CLS : SYSTEM
   END IF
 LOOP

SUB AddNewEnemy
 IF Enemies = 5 THEN EXIT SUB
Enemies = Enemies + 1
EnemiesLeft = EnemiesLeft + 1
EnmActive(Enemies) = -1
EnmShipType(Enemies) = CINT(RND * 3)
 IF Level > 250 THEN EnmColor = CINT(RND * 2)
 IF Level < 251 THEN EnmColor = CINT(RND * 4) * (((500 - Level) \ 1000) + 1)
 IF EnmColor < 4 THEN
  EnmColor(Enemies) = EnmPalette(EnmColor)
 ELSE
  EnmColor(Enemies) = 0
 END IF
EnemyX(Enemies) = 1: EnemyY(Enemies) = CINT(RND * 76) + 1
 IF Enemies = 1 THEN DelayStart(3) = TIMER
END SUB

SUB AddScore
EndLevel = (500 - Level) / 10
Score$ = LTRIM$(STR$(Score))
ERASE ScrDate$, ScrEndLevel, ScrName$, ScrScore$, ScrStartLevel

ScrName$(15) = Name$: ScrScore$(15) = Score$: ScrDate$(15) = DATE$
ScrStartLevel(15) = StartLevel: ScrEndLevel(15) = EndLevel
FileName$ = "Scores.lst"
OPEN "Scores.lst" FOR BINARY AS 1
 FOR Score = 0 TO 14
   IF LOC(1) = LOF(1) THEN Scores = Score: EXIT FOR
  l = ASC(INPUT$(1, 1)): ScrName$(Score) = INPUT$(l, 1)
  l = ASC(INPUT$(1, 1)): ScrScore$(Score) = INPUT$(l, 1)
  l = ASC(INPUT$(1, 1)): ScrDate$(Score) = INPUT$(l, 1)
  ScrStartLevel(Score) = ASC(INPUT$(1, 1))
  ScrEndLevel(Score) = ASC(INPUT$(1, 1))
 NEXT Score
CLOSE 1
 
 FOR Score1 = 0 TO 15
  FOR Score2 = 0 TO 15
   IF VAL(ScrScore$(Score2)) < VAL(ScrScore$(Score1)) THEN
    SWAP ScrName$(Score1), ScrName$(Score2)
    SWAP ScrScore$(Score1), ScrScore$(Score2)
    SWAP ScrDate$(Score1), ScrDate$(Score2)
    SWAP ScrStartLevel(Score1), ScrStartLevel(Score2)
    SWAP ScrEndLevel(Score1), ScrEndLevel(Score2)
   END IF
  NEXT Score2
 NEXT Score1

FileName$ = "Scores.lst"
OPEN "Scores.lst" FOR OUTPUT AS 1
 FOR Score = 0 TO Scores
  PRINT #1, CHR$(LEN(ScrName$(Score))); ScrName$(Score); CHR$(LEN(ScrScore$(Score))); ScrScore$(Score); CHR$(LEN(ScrDate$(Score))); ScrDate$(Score); CHR$(ScrStartLevel(Score)); CHR$(ScrEndLevel(Score));
 NEXT Score
CLOSE 1
END SUB

SUB Center (x, Text$)
 IF x > 0 THEN LOCATE x
LOCATE , 40 - (LEN(Text$) / 2)
PRINT Text$
END SUB

SUB Choose (x, y, Text$, Choice$, Choices$)
LOCATE x, y: PRINT Text$
 DO
  Choice$ = UCASE$(INPUT$(1))
   IF INSTR(Choices$, Choice$) THEN EXIT DO
 LOOP
LOCATE x, y: PRINT SPACE$(LEN(Text$))
END SUB

SUB DisplayNextLevelEntered
 IF TIMER > DelayStart(6) + 3 OR Destroyed THEN
  COLOR , 0: Center 24, SPACE$(32)
  NextLevelEntered = 0
 ELSE
  COLOR 15: Center 24, "You have entered the next level."
 END IF
END SUB

SUB DisplayScores
PCOPY 0, 1
COLOR , 0: CLS
FileName$ = "Scores.ttl"
OPEN "Scores.ttl" FOR INPUT AS 1: CLOSE 1
OPEN "Scores.ttl" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1: KILL "Scores.ttl"
 ELSE
  COLOR 11, 0
   DO UNTIL LOC(1) = LOF(1)
    LOCATE ASC(INPUT$(1, 1)) + 1, ASC(INPUT$(1, 1)) + 1: PRINT INPUT$(1, 1)
   LOOP
  SEEK #1, 1
  COLOR 9, 1
   DO UNTIL LOC(1) = LOF(1)
    LOCATE ASC(INPUT$(1, 1)), ASC(INPUT$(1, 1)): PRINT INPUT$(1, 1)
   LOOP
 END IF
CLOSE 1
COLOR 10, 0: LOCATE 9: PRINT STRING$(80, "")
COLOR 15
FileName$ = "Scores.lst"
OPEN "Scores.lst" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1: KILL "Scores.lst"
  LOCATE , 3: PRINT "There are no scores."
 ELSE
  COLOR , 1
  PRINT " Name:"; SPC(25); "Score: Date:    Started at: Ended at:"; SPACE$(12)
  COLOR , 0
   FOR Row = 1 TO 15
     IF LOC(1) = LOF(1) THEN EXIT FOR
    l = ASC(INPUT$(1, 1)): ScrName$ = INPUT$(l, 1)
    l = ASC(INPUT$(1, 1)): ScrScore = VAL(INPUT$(l, 1))
    l = ASC(INPUT$(1, 1)): ScrDate$ = INPUT$(l, 1)
    ScrStartLevel = ASC(INPUT$(1, 1))
    ScrEndLevel = ASC(INPUT$(1, 1))
    LOCATE (Row * 2) + 10, 3
    PRINT USING "\" + SPACE$(25) + "\ #### \" + SPACE$(10) + "\ ##" + SPACE$(10) + "##"; ScrName$; ScrScore; ScrDate$; ScrStartLevel; ScrEndLevel
   NEXT Row
 END IF
CLOSE 1
COLOR 15, 1: LOCATE 48, 1: PRINT " Press Escape to return to the menu."; SPACE$(44)
 DO UNTIL INKEY$ = CHR$(27): LOOP
PCOPY 1, 0
END SUB

SUB DisplayStatus
PCOPY 0, 1
COLOR 15, 1
LOCATE 1, 1: PRINT SPACE$(320)
LOCATE 1, 1
PRINT USING " Level: ##"; (500 - Level) / 10
PRINT USING " Score: ####"; Score
PRINT USING " Ships destroyed: ####"; ShipsDestroyed
PRINT USING " Number of lives: ##"; Lives
COLOR , 0
Key$ = INPUT$(1)
PCOPY 1, 0
END SUB

SUB DisplayTitle
FileName$ = "Space.ttl"
OPEN "Space.ttl" FOR INPUT AS 1: CLOSE 1
OPEN "Space.ttl" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1: KILL "Space.ttl"
 ELSE
  COLOR 11, 0
   DO UNTIL LOC(1) = LOF(1)
    LOCATE ASC(INPUT$(1, 1)) + 1, ASC(INPUT$(1, 1)) + 1: PRINT INPUT$(1, 1)
   LOOP
  SEEK #1, 1
  COLOR 9, 1
   DO UNTIL LOC(1) = LOF(1)
    LOCATE ASC(INPUT$(1, 1)), ASC(INPUT$(1, 1)): PRINT INPUT$(1, 1)
   LOOP
 END IF
CLOSE 1
COLOR 3, 0
LOCATE 5, 52: PRINT "Space,"
 LOCATE , 50: PRINT "version 1.07"
 LOCATE , 46: PRINT "by: Peter Swinkels,"
 LOCATE , 48: PRINT "***1998-1999***"
END SUB

SUB DrawBox (x, y, w, h, Shadow)
LOCATE x, y: PRINT ""; STRING$(w, ""); ""
 FOR BoxX = 1 TO h
  LOCATE , y: PRINT ""; SPC(w); "";
   IF Shadow THEN PRINT "" ELSE PRINT
 NEXT BoxX
LOCATE , y: PRINT ""; STRING$(w, ""); "";
 IF Shadow THEN PRINT "": LOCATE , y + 1: PRINT STRING$(w + 2, "")
END SUB

SUB DrawMenu
COLOR 15, 2
LOCATE 43: PRINT " Use "; CHR$(24); "/"; CHR$(25); " to move the cursor and press Enter to select."; SPACE$(26)
COLOR 14, 0
 FOR Optn = 0 TO 4
  LOCATE (Optn * 4) + 15, 5: PRINT Option$(Optn)
 NEXT Optn
END SUB

SUB EnemyDestroyed (Enemy)
PALETTE 0, 4
PlaySound 1
PALETTE 0, 0
EnmDestroyed(Enemy) = -1
END SUB

SUB FireTorpedo
 IF Torpedoes = 5 THEN EXIT SUB
Torpedoes = Torpedoes + 1
TorpedoesLeft = TorpedoesLeft + 1
TorpedoActive(Torpedoes) = -1
TorpedoX(Torpedoes) = ShipX - 1
TorpedoY(Torpedoes) = ShipY
 IF Torpedoes = 1 THEN DelayStart(2) = TIMER
PlaySound 0
END SUB

SUB GameOver
COLOR , 0: CLS
PlaySound 4
 DO UNTIL INKEY$ = CHR$(27)
  COLOR 4: Center 23, ""
  COLOR 28, 4: Center 0, " Game over! "
  COLOR 4, 0: Center 0, ""
  COLOR 15: Center 0, "Press Escape to return to menu."
  MoveStars
 LOOP
AddScore
RUN "Space"
END SUB

SUB GetJoystickStatus
 IF STICK(0) < CntrdStckX - Sensitivity THEN
  DirectionY = 1
 ELSEIF STICK(0) > CntrdStckX + Sensitivity THEN
  DirectionY = 2
 ELSE
  DirectionY = 0
 END IF
 IF STICK(1) < CntrdStckY - Sensitivity THEN
  DirectionX = 1
 ELSEIF STICK(1) > CntrdStckY + Sensitivity THEN
  DirectionX = 2
 ELSE
  DirectionX = 0
 END IF
 IF STRIG(1) THEN PLAY "MF": FireTorpedo: PLAY "MB"
END SUB

SUB GotoNextLevel
 IF Level > 0 THEN
  Level = Level - 10
  NextLevelEntered = -1
  PlaySound 2
  DelayStart(6) = TIMER
 ELSE
  COLOR , 0: CLS
  PlaySound 3
   DO UNTIL INKEY$ = CHR$(27)
    COLOR 2: Center 23, ""
    COLOR 26, 2: Center 0, " You won! "
    COLOR 2, 0: Center 0, ""
    COLOR 15: Center 0, "Press Escape to return to menu."
    MoveStars
   LOOP
  AddScore
  RUN "Space"
 END IF
END SUB

SUB InputBox (x, y, Prompt$, Text$, MaxLength)
PCOPY 0, 1
 DO
  COLOR 15
  LOCATE x, y: PRINT Prompt$; Text$; : COLOR 31: PRINT "_ "
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  l = LEN(Text$)
   IF Key$ = CHR$(8) THEN
    IF l > 0 THEN Text$ = LEFT$(Text$, l - 1)
   ELSEIF Key$ = CHR$(13) THEN
    EXIT DO
   ELSEIF Key$ = CHR$(27) THEN
    Text$ = ""
    EXIT DO
   ELSEIF ASC(Key$) > 31 THEN
    IF l < MaxLength THEN Text$ = Text$ + Key$
   END IF
 LOOP
PCOPY 1, 0
COLOR 7
END SUB

SUB LoadGraphicsData
FileName$ = "Space.dat"
OPEN "Space.dat" FOR INPUT AS 1: CLOSE 1
OPEN "Space.dat" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1: KILL "Space.dat"
 ELSE
  FOR Ship = 0 TO 3
   FOR Row = 0 TO 2
    Ship$(Row, Ship) = INPUT$(3, 1)
    Enemy$(Row, Ship) = INPUT$(3, 1)
   NEXT Row
  NEXT Ship
  FOR Pic = 0 TO 3
   ExplPic$(Pic) = INPUT$(1, 1)
  NEXT Pic
  FOR PalColor = 0 TO 3
   EnmPalette(PalColor) = ASC(INPUT$(1, 1))
   ExplPalette(PalColor) = ASC(INPUT$(1, 1))
   StarPalette(PalColor) = ASC(INPUT$(1, 1))
  NEXT PalColor
 END IF
CLOSE 1
END SUB

SUB LoadSettings
FileName$ = "Space.tmp"
OPEN "Space.tmp" FOR OUTPUT AS 1
 PRINT #1, CHR$(1);
CLOSE 1
FileName$ = "Space.set"
OPEN "Space.set" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  CLOSE 1
  KILL "Space.set"
  Level = 500
  SoundOn = -1: JoystickOn = 0: Lives = 5
  Sensitivity = 20: ShipType = 0: ShipColor = 15
 ELSE
  SoundOn = -ASC(INPUT$(1, 1))
  JoystickOn = -ASC(INPUT$(1, 1))
  Lives = ASC(INPUT$(1, 1))
  Sensitivity = ASC(INPUT$(1, 1))
  Level = 500 - (ASC(INPUT$(1, 1)) * 10)
  ShipType = ASC(INPUT$(1, 1))
  ShipColor = ASC(INPUT$(1, 1))
 END IF
CLOSE 1
END SUB

SUB Main
RANDOMIZE TIMER
StartLevel = (500 - Level) / 10
MakeStars
 IF JoystickOn THEN
  COLOR 15: LOCATE 3, 3: PRINT "Make sure the joystick's stick is centered."
  Key$ = INPUT$(1)
  CntrdStckX = STICK(0)
  CntrdStckY = STICK(1)
  CLS
 END IF
DelayStart(0) = TIMER
DelayStart(1) = TIMER
DelayStart(7) = TIMER

 DO
  DO
   IF Enemies THEN MoveEnemies
   IF JoystickOn AND NOT Destroyed THEN GetJoystickStatus
   IF NextLevelEntered THEN DisplayNextLevelEntered
   IF Torpedoes THEN MoveTorpedoes
   IF EnmTorpedoActive(1) OR EnmTorpedoActive(2) OR EnmTorpedoActive(3) OR EnmTorpedoActive(4) OR EnmTorpedoActive(5) THEN MoveEnemyTorpedoes
    IF TIMER > DelayStart(7) + (Level / 500) THEN
     DelayStart(7) = TIMER
     AddNewEnemy
    ELSE
     IF TIMER < 3 THEN DelayStart(7) = TIMER
    END IF
   MoveStars
   MoveShip
   Key$ = UCASE$(INKEY$)
  LOOP WHILE Key$ = ""
  IF NOT Destroyed THEN
   IF NOT JoystickOn THEN
    IF Key$ = CHR$(0) + "H" THEN
     IF DirectionX = 1 THEN DirectionX = 0 ELSE DirectionX = 1
    ELSEIF Key$ = CHR$(0) + "P" THEN
     IF DirectionX = 2 THEN DirectionX = 0 ELSE DirectionX = 2
    ELSEIF Key$ = CHR$(0) + "K" THEN
     IF DirectionY = 1 THEN DirectionY = 0 ELSE DirectionY = 1
    ELSEIF Key$ = CHR$(0) + "M" THEN
     IF DirectionY = 2 THEN DirectionY = 0 ELSE DirectionY = 2
    ELSEIF Key$ = " " THEN
     FireTorpedo
    END IF
   END IF
   IF Key$ = CHR$(0) + "O" THEN
    DirectionX = 0: DirectionY = 0
   END IF
  END IF
  IF Key$ = CHR$(27) THEN
   RUN "Space"
  ELSEIF Key$ = "P" THEN
   Pause
  ELSEIF Key$ = "S" THEN
   DisplayStatus
  END IF
 LOOP
END SUB

SUB MakeStars
ERASE StarX, StarY, StarZ
 FOR Star = 0 TO 50
  StarX(Star) = CINT(RND * 46)
  StarY(Star) = CINT(RND * 79)
  StarZ(Star) = CINT(RND * 1) + 1
  StarColor(Star) = StarPalette(CINT(RND * 3))
 NEXT Star
END SUB

SUB Menu
DisplayTitle
Option$(0) = "Begin with game"
Option$(1) = "Settings"
Option$(2) = "Help"
Option$(3) = "Scores"
Option$(4) = "Quit"
MenuHelp$(0) = "Begin with game."
MenuHelp$(1) = "Run program to set the settings."
MenuHelp$(2) = "View help."
MenuHelp$(3) = "View the scores."
MenuHelp$(4) = "Exit this game."
CursorX = 0
COLOR 10
LOCATE 11: PRINT STRING$(80, "")
LOCATE 44: PRINT STRING$(80, "")
LOCATE 46: PRINT STRING$(80, "")
DrawMenu
 DO
  COLOR 11, 0: Center 45, MenuHelp$(CursorX)
  COLOR 14, 1: LOCATE (CursorX * 4) + 15, 4: PRINT " "; Option$(CursorX); SPACE$(20 - LEN(Option$(CursorX)))
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  COLOR 14, 0: LOCATE (CursorX * 4) + 15, 4: PRINT " "; Option$(CursorX); SPACE$(20 - LEN(Option$(CursorX)))
  LOCATE 45: PRINT SPACE$(80)
   IF Key$ = CHR$(0) + "H" THEN
    IF CursorX > 0 THEN CursorX = CursorX - 1 ELSE CursorX = 4
   ELSEIF Key$ = CHR$(0) + "P" THEN
    IF CursorX < 4 THEN CursorX = CursorX + 1 ELSE CursorX = 0
   ELSEIF Key$ = CHR$(13) THEN
    IF CursorX = 0 THEN
     InputBox 47, 3, "Enter your name: ", Text$, 25
      IF Text$ = "" THEN RUN "Space"
     Name$ = Text$
     CLS : EXIT SUB
    END IF
    IF CursorX = 1 THEN FileName$ = "Setup.exe": RUN "Setup"
    IF CursorX = 2 THEN FileName$ = "Help.exe": RUN "Help"
    IF CursorX = 3 THEN DisplayScores
    IF CursorX = 4 THEN
     COLOR 15
     Choose 47, 3, "Exit this game y/n?", Choice$, "YN"
      IF Choice$ = "Y" THEN
       KILL "Space.tmp"
       COLOR 7, 0: CLS : WIDTH 80, 25: SYSTEM
      END IF
    END IF
   END IF
 LOOP
END SUB

SUB MoveEnemies
 IF TIMER > DelayStart(3) + .01 THEN
  DelayStart(3) = TIMER
   FOR Enemy = 1 TO 5
    IF EnmActive(Enemy) THEN
     LOCATE EnemyX(Enemy), EnemyY(Enemy): PRINT "   "
     LOCATE , EnemyY(Enemy): PRINT "   "
     LOCATE , EnemyY(Enemy): PRINT "   "
      IF EnemyX(Enemy) = 45 THEN
       EnmActive(Enemy) = 0
       EnemiesLeft = EnemiesLeft - 1
        IF EnemiesLeft = 0 THEN Enemies = 0: ERASE EnmActive
      ELSE
       EnemyX(Enemy) = EnemyX(Enemy) + 1
       COLOR 12
       LOCATE EnemyX(Enemy), EnemyY(Enemy): PRINT Enemy$(0, EnmShipType(Enemy))
       COLOR EnmColor(Enemy)
       LOCATE , EnemyY(Enemy): PRINT Enemy$(1, EnmShipType(Enemy))
       LOCATE , EnemyY(Enemy): PRINT Enemy$(2, EnmShipType(Enemy))
       IF TIMER > DelayStart(9) + (Level / 1000) THEN
        DelayStart(9) = TIMER
         IF NOT EnmTorpedoActive(Enemy) AND EnmActive(Enemy) THEN
          EnmTorpedoActive(Enemy) = -1
          EnmTorpedoX(Enemy) = EnemyX(Enemy) + 1
          EnmTorpedoY(Enemy) = EnemyY(Enemy)
          DelayStart(4) = TIMER
         END IF
       ELSE
        IF TIMER < 3 THEN DelayStart(9) = TIMER
       END IF
      END IF
    ELSEIF EnmDestroyed(Enemy) THEN
     IF EnemyX(Enemy) = 45 THEN
      EnmDestroyed(Enemy) = 0
       FOR Row = -2 TO 2
        LOCATE EnemyX(Enemy) + Row, EnemyY(Enemy): PRINT "     "
       NEXT Row
     ELSE
      LOCATE EnemyX(Enemy), EnemyY(Enemy): PRINT "   "
      LOCATE , EnemyY(Enemy): PRINT "   "
      LOCATE , EnemyY(Enemy): PRINT "   "
      EnemyX(Enemy) = EnemyX(Enemy) + 1
       FOR Frame = 0 TO 3
        COLOR ExplPalette(CINT(RND * 3))
        LOCATE EnemyX(Enemy) + CINT(RND * -2) + 2, EnemyY(Enemy) + CINT(RND * -2) + 2
        PRINT ExplPic$(CINT(RND * 3))
       NEXT Frame
     END IF
    END IF
   NEXT Enemy
 ELSE
  IF TIMER < 3 THEN DelayStart(3) = TIMER
 END IF
END SUB

SUB MoveEnemyTorpedoes
 IF TIMER > DelayStart(4) + .01 THEN
  DelayStart(4) = TIMER
   FOR Torpedo = 1 TO 5
    IF EnmTorpedoActive(Torpedo) THEN
     IF EnmTorpedoX(Torpedo) > ShipX - 3 AND EnmTorpedoX(Torpedo) < ShipX + 3 AND EnmTorpedoY(Torpedo) > ShipY - 4 AND EnmTorpedoY(Torpedo) < ShipY + 4 THEN
      EnmTorpedoActive(Torpedo) = 0
      POKE (EnmTorpedoX(Torpedo) * 160) + (EnmTorpedoY(Torpedo) * 2), 32
       IF NOT Destroyed THEN
        ShipDestroyed
       END IF
     END IF
    END IF
    IF EnmTorpedoActive(Torpedo) THEN
     IF PEEK((EnmTorpedoX(Torpedo) * 160) + (EnmTorpedoY(Torpedo) * 2)) = 111 THEN
      POKE (EnmTorpedoX(Torpedo) * 160) + (EnmTorpedoY(Torpedo) * 2), 32
     END IF
      IF EnmTorpedoX(Torpedo) >= 45 THEN
       EnmTorpedoActive(Torpedo) = 0
      ELSE
       EnmTorpedoX(Torpedo) = EnmTorpedoX(Torpedo) + 2
       IF PEEK((EnmTorpedoX(Torpedo) * 160) + (EnmTorpedoY(Torpedo) * 2)) = 32 THEN
        POKE (EnmTorpedoX(Torpedo) * 160) + (EnmTorpedoY(Torpedo) * 2), 111
        POKE (EnmTorpedoX(Torpedo) * 160) + (EnmTorpedoY(Torpedo) * 2) + 1, 12
       END IF
      END IF
    END IF
   NEXT Torpedo
 ELSE
  IF TIMER < 3 THEN DelayStart(4) = TIMER
 END IF
END SUB

SUB MoveShip
 IF TIMER > DelayStart(1) + .01 THEN
  DelayStart(1) = TIMER
  LOCATE ShipX, ShipY: PRINT "   "
  LOCATE , ShipY: PRINT "   "
  LOCATE , ShipY: PRINT "   "
   IF DirectionX = 1 THEN
    IF ShipX > 1 THEN ShipX = ShipX - 1
   ELSEIF DirectionX = 2 THEN
    IF ShipX < 46 THEN ShipX = ShipX + 1
   END IF
   IF DirectionY = 1 THEN
    IF ShipY > 1 THEN ShipY = ShipY - 1
   ELSEIF DirectionY = 2 THEN
    IF ShipY < 78 THEN ShipY = ShipY + 1
   END IF
   IF NOT Destroyed THEN
    COLOR ShipColor
    LOCATE ShipX, ShipY: PRINT Ship$(0, ShipType)
    LOCATE , ShipY: PRINT Ship$(1, ShipType)
    COLOR 12: LOCATE , ShipY: PRINT Ship$(2, ShipType)
   ELSE
    IF ShipX = 1 OR ShipX = 46 OR ShipY = 1 OR ShipY = 78 THEN DirectionX = 0: DirectionY = 0
    IF DirectionX = 0 AND DirectionY = 0 THEN
     Lives = Lives - 1
      IF Lives = 0 THEN CALL GameOver
     DelayStart(8) = TIMER
      DO UNTIL TIMER > DelayStart(8) + 3 OR TIMER < 3
        IF Enemies THEN MoveEnemies
        IF JoystickOn AND NOT Destroyed THEN GetJoystickStatus
        IF NextLevelEntered THEN DisplayNextLevelEntered
        IF Torpedoes THEN MoveTorpedoes
        IF EnmTorpedoActive(1) OR EnmTorpedoActive(2) OR EnmTorpedoActive(3) OR EnmTorpedoActive(4) OR EnmTorpedoActive(5) THEN MoveEnemyTorpedoes
       MoveStars
       COLOR 15, 0
       Center 24, "Your ship has been destroyed."
        IF Lives = 1 THEN
         Center 0, "There is" + STR$(Lives) + " life left."
        ELSE
         Center 0, "There are" + STR$(Lives) + " lives left."
        END IF
       Key$ = INKEY$
      LOOP
     Destroyed = 0
     Center 24, SPACE$(29)
     Center 0, SPACE$(24)
     ShipX = 20: ShipY = 38
    END IF
    IF ShipX = 46 AND DirectionX = 0 AND DirectionY = 0 THEN
     Destroyed = 0
      FOR Row = -2 TO 2
       LOCATE ShipX + Row, ShipY: PRINT "     "
      NEXT Row
    ELSE
     FOR Frame = 0 TO 3
      COLOR ExplPalette(CINT(RND * 3))
      LOCATE ShipX + CINT(RND * -2) + 2, ShipY + CINT(RND * -2) + 2
      PRINT ExplPic$(CINT(RND * 3))
     NEXT Frame
    END IF
   END IF
 ELSE
  IF TIMER < 3 THEN DelayStart(1) = TIMER
 END IF
END SUB

SUB MoveStars
 IF TIMER > DelayStart(0) + .01 THEN
  DelayStart(0) = TIMER
   FOR Star = 0 TO 50
    IF PEEK((StarX(Star) * 160) + (StarY(Star) * 2)) = 46 THEN
     POKE (StarX(Star) * 160) + (StarY(Star) * 2), 32
    END IF
     IF StarX(Star) + StarZ(Star) > 46 THEN
      StarX(Star) = 1
      StarY(Star) = CINT(RND * 79) + 1
      StarZ(Star) = CINT(RND * 1) + 1
      StarColor(Star) = StarPalette(CINT(RND * 3))
     ELSE
      StarX(Star) = StarX(Star) + StarZ(Star)
     END IF
    IF PEEK((StarX(Star) * 160) + (StarY(Star) * 2)) = 32 THEN
     POKE (StarX(Star) * 160) + (StarY(Star) * 2), 46
     POKE (StarX(Star) * 160) + (StarY(Star) * 2) + 1, StarColor(Star)
    END IF
   NEXT Star
 ELSE
  IF TIMER < 3 THEN DelayStart(0) = TIMER
 END IF
END SUB

SUB MoveTorpedoes
 IF TIMER > DelayStart(2) + .01 THEN
  DelayStart(2) = TIMER
   FOR Torpedo = 1 TO 5
    FOR Enemy = 1 TO 5
     IF TorpedoActive(Torpedo) AND EnmActive(Enemy) THEN
      IF TorpedoX(Torpedo) > EnemyX(Enemy) - 2 AND TorpedoX(Torpedo) < EnemyX(Enemy) + 2 AND TorpedoY(Torpedo) > EnemyY(Enemy) - 3 AND TorpedoY(Torpedo) < EnemyY(Enemy) + 3 THEN
       POKE (TorpedoX(Torpedo) * 160) + (TorpedoY(Torpedo) * 2), 32
       TorpedoActive(Torpedo) = 0
       TorpedoesLeft = TorpedoesLeft - 1
        IF TorpedoesLeft = 0 THEN Torpedoes = 0: ERASE TorpedoActive
       EnmActive(Enemy) = 0
       EnemiesLeft = EnemiesLeft - 1
        IF EnemiesLeft = 0 THEN Enemies = 0: ERASE EnmActive
       LOCATE EnemyX(Enemy), EnemyY(Enemy): PRINT "   "
       LOCATE , EnemyY(Enemy): PRINT "   "
       LOCATE , EnemyY(Enemy): PRINT "   "
       EnemyDestroyed Enemy
        IF EnmColor(Enemy) = 1 AND Score > 0 THEN Score = Score - 1
        IF EnmColor(Enemy) = 4 THEN Score = Score + 1
        IF EnmColor(Enemy) = 12 THEN Score = Score + 2
        IF EnmColor(Enemy) = 14 THEN Score = Score + 3
        IF EnmColor(Enemy) = 0 THEN Score = Score + 5
       ShipsDestroyed = ShipsDestroyed + 1
        IF ShipsDestroyed / 25 = ShipsDestroyed \ 25 THEN
         GotoNextLevel
        END IF
      END IF
     END IF
    NEXT Enemy
    IF TorpedoActive(Torpedo) THEN
     IF PEEK((TorpedoX(Torpedo) * 160) + (TorpedoY(Torpedo) * 2)) = 111 THEN
      POKE (TorpedoX(Torpedo) * 160) + (TorpedoY(Torpedo) * 2), 32
     END IF
     IF TorpedoX(Torpedo) = 1 THEN
      TorpedoActive(Torpedo) = 0
      TorpedoesLeft = TorpedoesLeft - 1
       IF TorpedoesLeft = 0 THEN Torpedoes = 0: ERASE TorpedoActive
     ELSE
      TorpedoX(Torpedo) = TorpedoX(Torpedo) - 1
       IF PEEK((TorpedoX(Torpedo) * 160) + (TorpedoY(Torpedo) * 2)) = 32 THEN
        POKE (TorpedoX(Torpedo) * 160) + (TorpedoY(Torpedo) * 2), 111
        POKE (TorpedoX(Torpedo) * 160) + (TorpedoY(Torpedo) * 2) + 1, 14
       END IF
     END IF
    END IF
   NEXT Torpedo
 ELSE
  IF TIMER < 3 THEN DelayStart(2) = TIMER
 END IF
END SUB

SUB Pause
COLOR 15: Center 24, "Game is paused."
 DO
  IF TIMER < 3 THEN
   FOR DelayN = 0 TO 10
    DelayStart(DelayN) = TIMER
   NEXT DelayN
  END IF
 LOOP WHILE INKEY$ = ""
COLOR 15
Center 24, SPACE$(15)
END SUB

SUB PlaySound (SoundN)
 IF SoundOn THEN
  IF SoundN = 0 THEN
   PLAY "T120 L64"
    FOR Note = 6 TO 27 STEP (Note + 1) * 6
     PLAY "N" + STR$(Note)
    NEXT Note
  ELSEIF SoundN = 1 THEN
   PLAY "T120 L64"
    FOR Note = 0 TO CINT(RND * 5) + 5
     PLAY "N" + STR$(CINT(RND * 32))
    NEXT Note
  ELSEIF SoundN = 2 THEN
   PLAY "T255 L64"
    FOR Time = 0 TO 1
     FOR Note = 4 TO 64 STEP 4
      PLAY "N" + STR$(Note)
      PLAY "N" + STR$(Note - 4)
     NEXT Note
    NEXT Time
  ELSEIF SoundN = 3 THEN
   PLAY "T255 << L16 CDEFABCDEFA L4 B >>"
  ELSEIF SoundN = 4 THEN
   PLAY "L16 T255"
    FOR Note = 32 TO 16 STEP -1
     PLAY "N" + STR$(Note)
    NEXT Note
  END IF
 END IF
END SUB

SUB ShipDestroyed
PALETTE 0, 4
PlaySound 1
PALETTE 0, 0
Destroyed = -1
END SUB

