{**********************************************************************}
{*                                                                    *}
{*        BUTTON.PAS - ꥪ                                   *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Button;

interface

uses Graph, Fonts;

const NormTextColor = 0;
      SelTextColor  = 0;
      NormBackColor = 6;
      SelBackColor  = 2;

type PButton = ^TButton;
     TButton = object
       Size: Word;
       P: Pointer;
       X, Y, W, H: Integer;
       Sel, Pressed: Boolean;
       Text: String;
       constructor Init(X_, Y_, W_, H_: Integer; Text_: String; Sel_: Boolean);
       destructor Done;
       procedure Draw;
       procedure ReDraw;
       procedure Press;
       procedure Up;
       procedure Select;
       procedure UnSelect;
       function Selected: Boolean;
     end;

implementation

constructor TButton.Init(X_, Y_, W_, H_: Integer; Text_: String; Sel_: Boolean);
begin
  X := X_;
  Y := Y_;
  W := W_;
  H := H_;
  Sel := Sel_;
  Pressed := False;
  Text := Text_;
  Size := 10;
  repeat
    SetTextStyle(TripFont, HorizDir, Size);
    Dec(Size);
  until (TextWidth(Text) < W - 2 * (W div 5)) and (TextHeight(Text) < H - 2 * (H div 5));
  Size := ImageSize(X, Y, X + W + 5, Y + H + 5);
  GetMem(P, Size);
  GetImage(X, Y, X + W + 5, Y + H + 5, P^);
  Up;
end;

destructor TButton.Done;
begin
  FreeMem(P, Size);
end;

procedure TButton.Draw;
begin
  SetFillStyle(1, 0);
  Bar(X + 5, Y + 5, X + W + 4, Y + H + 4);
end;

procedure TButton.ReDraw;
begin
  if Sel then
  begin
    SetColor(SelTextColor);
    SetFillStyle(1, SelBackColor);
  end
  else
  begin
    SetColor(NormTextColor);
    SetFillStyle(1, NormBackColor);
  end;
  Bar(X, Y, X + W - 1, Y + H - 1);
  OutTextXY((W - TextWidth(Text)) div 2 + X, (H - TextHeight(Text)) div 2 + Y, Text);
end;

procedure TButton.Press;
begin
  PutImage(X, Y, P^, NormalPut);
  Inc(X, 5);
  Inc(Y, 5);
  ReDraw;
  Dec(X, 5);
  Dec(Y, 5);
end;

procedure TButton.Up;
begin
  Draw;
  ReDraw;
end;

procedure TButton.Select;
begin
  if not Sel then
  begin
    Sel := True;
    ReDraw;
  end;
end;

procedure TButton.UnSelect;
begin
  if Sel then
  begin
    Sel := False;
    ReDraw;
  end;
end;

function TButton.Selected: Boolean;
begin
  Selected := Sel;
end;


end.
