{**********************************************************************}
{*                                                                    *}
{*        DIALOG.PAS - ꥪ                          *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Dialog;

interface

uses Graph, Fonts, Bmp, Str_Data, Crt;

type PDialog = ^TDialog;
     TDialog = object
       Text: String;
       P: Pointer;
       Size: Word;
       constructor Init(S: String);
       destructor Done;
       procedure Draw; virtual;
     end;

     PSpeedDialog = ^TSpeedDialog;
     TSpeedDialog = object(TDialog)
       Size2: Word;
       P2: Pointer;
       constructor Init(S: String);
       destructor Done;
       procedure Draw; virtual;
       procedure Run(Min, Max: Integer; var Speed: Integer);
       procedure Update(N: Integer);
     end;

implementation

constructor TDialog.Init(S: String);
begin
  Text := S;
  Size := ImageSize(160, 100, 479, 299);
  GetMem(P, Size);
  GetImage(160, 100, 479, 299, P^);
  Draw;
end;

destructor TDialog.Done;
begin
  PutImage(160, 100, P^, NormalPut);
  FreeMem(P, Size);
end;

procedure TDialog.Draw;
  var i: Integer;
begin
  DrawBitmap(160, 100, Bitmaps[9]);
  for i := 0 to 4 do
  begin
    SetColor(217);
    Line(160 + i, 100 + i, 479 - i, 100 + i);
    Line(160 + i, 100 + i, 160 + i, 299 - i);
    SetColor(191);
    Line(479 - i, 299 - i, 160 + i, 299 - i);
    Line(479 - i, 299 - i, 479 - i, 100 + i);
  end;
  SetTextStyle(TripFont, HorizDir, 3);
  ShadowText((GetMaxX - TextWidth(Text)) div 2, 110, 1, 189, Text);
end;

constructor TSpeedDialog.Init(S: String);
begin
  inherited Init(S);
  Size2 := ImageSize(300, 170, 340, 210);
  GetMem(P2, Size2);
  GetImage(300, 170, 340, 210, P2^);
end;

destructor TSpeedDialog.Done;
begin
  inherited Done;
  FreeMem(P2, Size2);
end;

procedure TSpeedDialog.Draw;
  var i: Integer;
begin
  inherited Draw;
  SetTextStyle(LittFont, HorizDir, 5);
  for i := 1 to 3 do
    ShadowText(180, 240 + i * 10, 1, 189, DialogStr[i + 1]);
end;

procedure TSpeedDialog.Run(Min, Max: Integer; var Speed: Integer);
  var Temp: Integer;
      Key: Char;
begin
  Temp := Speed;
  SetTextStyle(TripFont, HorizDir, 5);
  Update(Temp);
  repeat
    Key := ReadKey;
    case Key of
      #80: if Temp > Min then
           begin
             Dec(Temp);
             Update(Temp);
           end;
      #72: if Temp < Max then
           begin
             Inc(Temp);
             Update(Temp);
           end;
    end;
  until (Key = #13) or (Key = #27);
  if Key = #13 then Speed := Temp;
end;

procedure TSpeedDialog.Update(N: Integer);
  var S: String;
begin
  Str(N, S);
  PutImage(300, 170, P2^, NormalPut);
  ShadowText((GetMaxX - TextWidth(S)) div 2, 170, 2, 189, S);
end;


end.
