{**********************************************************************}
{*                                                                    *}
{*        FIG.PAS - ꥪ 䨣                                     *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Fig;

interface

type TFigure = record
       Size: Byte;
       Data: array[1..4, 1..4] of Byte;
     end;

const MAX_FIGS = 13;

var Figures: array[1..MAX_FIGS] of TFigure;

procedure LoadFigures;
procedure DrawFigure(X, Y, Num, Mul, Color: Integer);

implementation

uses Graph;

procedure LoadFigures;
  var F: Text;
      S: String;
      i, j, k: Integer;
begin
  {$I-}
  Assign(F, 'figures.dat');
  Reset(F);
  {$I+}
  if IOResult <> 0 then
  begin
    Writeln('Unable to open file figures.dat');
    Halt(1);
  end;
  for i := 1 to MAX_FIGS do
  begin
    ReadLn(F, Figures[i].Size);
    for j := 1 to Figures[i].Size do
    begin
      ReadLn(F, S);
      if Length(S) <> Figures[i].Size then
      begin
        Writeln('figures.dat is corrupted');
        Halt(1);
      end;
      for k := 1 to Figures[i].Size do
        if S[k] = '1' then
          Figures[i].Data[k, j] := 1
        else
          Figures[i].Data[k, j] := 0;
    end;
    ReadLn(F, S);
  end;
end;

procedure DrawFigure(X, Y, Num, Mul, Color: Integer);
  var i, j: Integer;
begin
  SetFillStyle(1, Color);
  SetColor(0);
  for i := 0 to 3 do
    for j := 0 to 3 do
    begin
      if Figures[Num].Data[i + 1, j + 1] = 1 then
      begin
        Bar(X + i * Mul, Y + j * Mul, X + i * Mul + Mul, Y + j * Mul + Mul);
        Rectangle(X + i * Mul, Y + j * Mul, X + i * Mul + Mul, Y + j * Mul + Mul);
      end;
    end;
end;

end.
