{**********************************************************************}
{*                                                                    *}
{*        FIGURE.PAS - 楤  ࠡ  䠩 figures.dat      *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Figure;

interface

uses BMP, Graph, Crt, Fig;

const WIDTH = 14;
      HEIGHT = 20;
      W_X = 40;
      H_Y = 40;
      MUL = 16;

type PFigure = ^TFigure;
     TFigure = object
       StopFlag: Boolean;
       Data: array[1..4, 1..4] of Byte;
       X, Y, Fig, Color: Integer;
       OldDx, OldDy: Integer;
       constructor Init(FigSet: Integer);
       destructor Done;
       procedure Move(dx, dy: Integer);
       procedure DrawFig(F_X, F_Y: Integer);
       procedure Rotate;
       function CanMove(var dx, dy: Integer): Boolean;
       procedure Drop;
     end;

var P: array[1..WIDTH, 1..HEIGHT] of Byte;

implementation

constructor TFigure.Init(FigSet: Integer);
  var i, j: Integer;
begin
  OldDx := 0;
  OldDy := 0;
  Fig := Random(FigSet) + 1;
  for i := 1 to 4 do
    for j := 1 to 4 do
      Data[i, j] := Figures[Fig].Data[i, j];
  X := WIDTH div 2 - Figures[Fig].Size div 2;
  Y := 0;
  Color := Random(255) + 1;
  StopFlag := False;
  for i := 1 to Random(4) do
    Rotate;
  DrawFig(X * MUL + W_X, Y * MUL + H_Y);
end;

destructor TFigure.Done;
begin
end;

procedure TFigure.Move(dx, dy: Integer);
  var i: Integer;
begin
  StopFlag := CanMove(dx, dy);
  if not StopFlag then
  begin
    SetFillStyle(1, 0);
    if dy = 1 then
    begin
      for i := 0 to Figures[Fig].Size - 1 do
        if (X + i >= 0) and (X + i < WIDTH) then
          if P[X + i + 1, Y + 1] = 0 then
            Bar(W_X + (X + i) * MUL, H_Y + Y * MUL, W_X + (X + i + 1) * MUL, H_Y + Y * MUL + MUL);
    end;
    if (dx = 1) and (X >= 0) then
    begin
      for i := 0 to Figures[Fig].Size - 1 do
        if (Y + i < HEIGHT) then
          if P[X + 1, Y + i + 1] = 0 then
{            DrawBitmap(W_X + X * MUL, H_Y + (Y + i) * MUL, Bitmaps[8]);}
            Bar(W_X + X * MUL, H_Y + (Y + i) * MUL, W_X + (X + 1) * MUL, H_Y + (Y + i + 1) * MUL);
    end;
    if (dx = -1) and (X + Figures[Fig].Size - 1 < WIDTH) then
    begin
      for i := 0 to Figures[Fig].Size - 1 do
        if (Y + i < HEIGHT) then
          if P[X + Figures[Fig].Size, Y + i + 1] = 0 then
{            DrawBitmap(W_X + (X + Figures[Fig].Size - 1) * MUL, H_Y + (Y + i) * MUL, Bitmaps[8]);}
            Bar(W_X + (X + Figures[Fig].Size - 1) * MUL, H_Y + (Y + i) * MUL,
                W_X + (X + Figures[Fig].Size) * MUL, H_Y + (Y + i + 1) * MUL);
    end;
    Inc(X, dx);
    Inc(Y, dy);
    DrawFig(X * MUL + W_X, Y * MUL + H_Y);
  end;
  OldDx := dx;
  OldDy := dy;
end;

procedure TFigure.DrawFig(F_X, F_Y: Integer);
  var i, j: Integer;
begin
  SetFillStyle(1, Color);
  SetColor(0);
  for i := 0 to Figures[Fig].Size - 1 do
    for j := 0 to Figures[Fig].Size - 1 do
    begin
      if Data[i + 1, j + 1] = 1 then
      begin
        Bar(F_X + i * MUL + 1, F_Y + j * MUL + 1, F_X + i * MUL + MUL - 1, F_Y + j * MUL + MUL - 1);
        Rectangle(F_X + i * MUL, F_Y + j * MUL, F_X + i * MUL + MUL, F_Y + j * MUL + MUL);
      end
      else if P[X + i + 1, Y + j + 1] = 0 then
        if (X + i + 1 > 0) and (X + i < WIDTH) and (Y + j < HEIGHT) then
        begin
          SetFillStyle(1, 0);
          Bar(W_X + (X + i) * MUL + 1, H_Y + (Y + j) * MUL + 1, W_X + (X + i + 1) * MUL - 1, H_Y + (Y + j + 1) * MUL - 1);
          SetFillStyle(1, Color);
        end;
    end;
end;

procedure TFigure.Rotate;
  var Temp: array[1..4, 1..4] of Byte;
      i, j: Integer;
      CanRotate: Boolean;
begin
  CanRotate := True;
  for i := 1 to Figures[Fig].Size do
    for j := 1 to Figures[Fig].Size do
    begin
      Temp[i, j] := Data[j, Figures[Fig].Size + 1 - i];
      if Temp[i, j] = 1 then
        if (X + i > WIDTH) or (X + i < 0) or (Y + i > HEIGHT) or (X + i < 1) then
          CanRotate := False;
        if P[X + i, Y + j] <> 0 then
        begin
          CanRotate := False;
          Exit;
        end;
    end;

  if CanRotate then
  begin
    for i := 1 to Figures[Fig].Size do
      for j := 1 to Figures[Fig].Size do
        Data[i, j] := Temp[i, j];
  end;
end;

function TFigure.CanMove(var dx, dy: Integer): Boolean;
  var i, j, dx_, dy_: Integer;
      Stop: Boolean;
begin
  Stop := False;
  dx_ := dx;
  dy_ := dy;
  for i := 0 to Figures[Fig].Size - 1 do
    for j := 0 to Figures[Fig].Size - 1 do
    begin
      if Data[i + 1, j + 1] = 1 then
      begin
        if X + dx + i < 0 then dx := 0;
        if X + dx + i  > WIDTH - 1 then dx := 0;
        if Y + dy + j  > HEIGHT - 1 then Stop := True;
        if P[X + dx + i + 1, Y + j + 1] <> 0 then dx := 0;
        if P[X + i + 1, Y + dy + j + 1] <> 0 then dy := 0;
      end;
    end;

  if (dx = 0) and (dy = 0) and (dy_ <> 0) then Stop := True;

  if Stop then
    for i := 1 to Figures[Fig].Size do
      for j := 1 to Figures[Fig].Size do
        if Data[i, j] = 1 then
          P[X + i, Y + j] := Color;

  CanMove := Stop;
end;

procedure TFigure.Drop;
  var dx, dy: Integer;
begin
  dx := 0;
  dy := 1;
  while not StopFlag do
  begin
    Move(dx, dy);
    Delay(20);
    if KeyPressed then ReadKey;
  end;
end;


end.
