{**********************************************************************}
{*                                                                    *}
{*        FONTS.PAS - 楤 ⠭ ॣ樨 ⮢         *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Fonts;

{ BOLD.OBJ}
{ EURO.OBJ}
{ GOTH.OBJ}
{ LCOM.OBJ}
{$L LITT.OBJ}
{ SANS.OBJ}
{ SCRI.OBJ}
{ SIMP.OBJ}
{$L TRIP.OBJ}
{ TSCR.OBJ}

interface

uses Graph;

var BoldFont: Integer;
    EuroFont: Integer;
    GothFont: Integer;
    LcomFont: Integer;
    LittFont: Integer;
    SansFont: Integer;
    ScriFont: Integer;
    SimpFont: Integer;
    TripFont: Integer;
    TscrFont: Integer;

procedure ShadowText(X, Y, W, Color: Integer; Text: String);
procedure RegisterFonts;
{procedure BOLD;
procedure EURO;
procedure GOTH;
procedure LCOM;}
procedure LITT;
{procedure SANS;
procedure SCRI;
procedure SIMP;}
procedure TRIP;
{procedure TSCR;}

implementation

{procedure BOLD; external;
procedure EURO; external;
procedure GOTH; external;
procedure LCOM; external;  }
procedure LITT; external;
{procedure SANS; external;
procedure SCRI; external;
procedure SIMP; external;}
procedure TRIP; external;
{procedure TSCR; external;}

procedure ShadowText(X, Y, W, Color: Integer; Text: String);
begin
  SetColor(0);
  OutTextXY(X + W, Y + W, Text);
  SetColor(Color);
  OutTextXY(X, Y, Text);
end;

procedure RegisterFonts;
begin
{  BoldFont := InstallUserFont('BOLD');
  EuroFont := InstallUserFont('EURO');
  GothFont := InstallUserFont('GOTH');
  LcomFont := InstallUserFont('LCOM');}
  LittFont := InstallUserFont('LITT');
{  SansFont := InstallUserFont('SANS');
  ScriFont := InstallUserFont('SCRI');
  SimpFont := InstallUserFont('SIMP');}
  TripFont := InstallUserFont('TRIP');
{  TscrFont := InstallUserFont('TSCR');}
{  RegisterBGIFont(@BOLD);
  RegisterBGIFont(@EURO);
  RegisterBGIFont(@GOTH);
  RegisterBGIFont(@LCOM); }
  RegisterBGIFont(@LITT);
{  RegisterBGIFont(@SANS);
  RegisterBGIFont(@SCRI);
  RegisterBGIFont(@SIMP);}
  RegisterBGIFont(@TRIP);
{  RegisterBGIFont(@TSCR);}
end;


end.
