{**********************************************************************}
{*                                                                    *}
{*        GAUGE.PAS - ꥪ 稪                                 *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Gauge;

interface

uses Graph, Fonts, Bmp;

type PGauge = ^TGauge;
     TGauge = object
       X, Y: Integer;
       Text: String;
       Count: LongInt;
       P: Pointer;
       Size: Word;
       constructor Init(X_, Y_: Integer; S: String; N: LongInt);
       destructor Done;
       procedure Draw;
       procedure Update(C: LongInt);
     end;

implementation

constructor TGauge.Init(X_, Y_: Integer; S: String; N: LongInt);
begin
  X := X_;
  Y := Y_;
  Text := S;
  SetTextStyle(TripFont, HorizDir, 4);
  Count := N;
  Size := ImageSize(X + TextWidth(Text), Y, X + 300, Y + 50);
  GetMem(P, Size);
  Draw;
  GetImage(X + TextWidth(Text), Y, X + 300, Y + 50, P^);
  Update(Count);
end;

destructor TGauge.Done;
begin
  FreeMem(P, Size);
end;

procedure TGauge.Draw;
begin
  SetFillStyle(1, 0);
  SetTextStyle(TripFont, HorizDir, 4);
  Bar(X + 10, Y + 10, X + 310, Y + 60);
  DrawBitmap(X, Y, Bitmaps[3]);
  ShadowText(X + (40 - TextHeight(Text)) div 2,
             Y + (40 - TextHeight(Text)) div 2, 1, 49, Text);
end;

procedure TGauge.Update(C: LongInt);
  var S: String;
begin
  Count := C;
  SetTextStyle(TripFont, HorizDir, 4);
  PutImage(X + TextWidth(Text), Y, P^, NormalPut);
  Str(Count, S);
  ShadowText(X + (40 - TextHeight(Text)) + TextWidth(Text),
             Y + (40 - TextHeight(Text)) div 2, 1, 49, S);
end;


end.
