{**********************************************************************}
{*                                                                    *}
{*        MESGBOX.PAS - 楤                       *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit MesgBox;

interface

uses Graph, Bmp, Crt, Button, Fonts;

procedure DrawPlate(X, Y: Integer);
function MessageBox(Message: String): Boolean;
function InputBox(Message: String): String;

implementation

const ValidChars: set of Char = [''..'', ''..'', ''..'', 'A'..'Z', 'a'..'z'];

procedure DrawPlate(X, Y: Integer);
  var i: Integer;
begin
  DrawBitmap(X, Y, Bitmaps[1]);
  for i := 0 to 4 do
  begin
    SetColor(14);
    Line(X + i, Y + i, X + 319 - i, Y + i);
    Line(X + i, Y + i, X + i, Y + 199 - i);
    SetColor(13);
    Line(X + 319 - i, Y + 199 - i, X + i, Y + 199 - i);
    Line(X + 319 - i, Y + 199 - i, X + 319 - i, Y + i);
  end;
end;

function MessageBox(Message: String): Boolean;
  var X, Y, Y1, Size, i: Word;
      P: Pointer;
      Temp: String;
      B1, B2: PButton;
      Key: Char;
begin
  MessageBox := False;
  X := 160;
  Y := 100;
  Size := ImageSize(X, Y, X + 319, Y + 199);
  GetMem(P, Size);
  GetImage(X, Y, X + 319, Y + 199, P^);
  DrawPlate(X, Y);
  SetTextStyle(DefaultFont, Horizdir, 2);
  i := 1;
  Y1 := Y + 20;
  while i < Length(Message) do
  begin
    Temp := '';
    while (TextWidth(Temp) < 250) and (i < Length(Message)) do
    begin
      while (Message[i] <> ' ') and (i < Length(Message)) do
      begin
        Temp := Temp + Message[i];
        Inc(i);
      end;
      if (TextWidth(Temp) < 250) and (i < Length(Message)) then
        Temp := Temp + Message[i];
      Inc(i);
    end;
    ShadowText((GetMaxX - TextWidth(Temp)) div 2, Y1, 1, 49, Temp);
    Inc(Y1, TextHeight(Temp) + 4);
  end;
  B1 := New(PButton, Init(X + 70, Y + 120, 60, 30, '', False));
  B2 := New(PButton, Init(X + 190, Y + 120, 60, 30, '', True));
  repeat
    Key := ReadKey;
    case Key of
      #77, #75: if B1^.Selected then
                begin
                  B1^.UnSelect;
                  B2^.Select;
                end
                else
                begin
                  B2^.UnSelect;
                  B1^.Select;
                end;
    end;
  until (Key = #13) or (Key = #27);
  if Key = #13 then
  begin
    if B2^.Selected then
    begin
      B2^.Press;
      Delay(200);
    end
    else
    begin
      B1^.Press;
      Delay(200);
      MessageBox := True;
    end;
  end;
  Dispose(B1, Done);
  Dispose(B2, Done);
  PutImage(X, Y, P^, NormalPut);
  FreeMem(P, Size);
end;

function InputBox(Message: String): String;
  var Key: Char;
      S: String;
      P, P2, P3: Pointer;
      Size, Size2, Size3: Word;
      i: Integer;
begin
  Size := ImageSize(160, 100, 479, 299);
  GetMem(P, Size);
  GetImage(160, 100, 479, 299, P^);
  DrawPlate(160, 100);

  SetTextStyle(TripFont, HorizDir, 3);
  ShadowText((GetMaxX - TextWidth(Message)) div 2, 120, 1, 49, Message);
  SetTextStyle(LittFont, HorizDir, 6);

  S := '';
  Size2 := ImageSize(200, 230, 220, 250);
  Size3 := ImageSize(200, 230, 500, 250);
  GetMem(P2, Size2);
  GetMem(P3, Size3);
  GetImage(200, 230, 220, 250, P2^);
  GetImage(200, 230, 500, 250, P3^);
  repeat
    Key := ReadKey;
    if (Key in ValidChars) and (Length(S) < 20) then
    begin
      ShadowText(200 + Length(S) * 10, 230, 1, 49, Key);
      S := S + Key;
    end
    else if (Key = #8) and (Length(S) > 0) then
    begin
      PutImage(200, 230, P3^, NormalPut);
      Delete(S, Length(S), 1);
      for i := 1 to Length(S) - 1 do
        ShadowText(200 + (i - 1) * 10, 230, 1, 49, S[i]);
    end;
  until Key = #13;

  InputBox := S;
  PutImage(160, 100, P^, NormalPut);
  FreeMem(P, Size);
  FreeMem(P2, Size2);
  FreeMem(P3, Size3);
end;


end.
