{**********************************************************************}
{*                                                                    *}
{*        PAL.PAS - 楤  ࠡ  ன                   *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Pal;

interface

procedure SetPal(P: array of Byte);
procedure SetNullPal;
procedure FadeIn(P: array of Byte);
procedure FadeOut(P: array of Byte);

implementation

uses Crt;

procedure SetPal(P: array of Byte);
  var i: Integer;
begin
  for i := 1 to 255 do
  begin
    Port[$3C8] := i;
    Port[$3C9] := P[i * 4 + 2] div 4;
    Port[$3C9] := P[i * 4 + 1] div 4;
    Port[$3C9] := P[i * 4] div 4;
  end;
end;

procedure SetNullPal;
  var i: Integer;
begin
  for i := 1 to 255 do
  begin
    Port[$3C8] := i;
    Port[$3C9] := 0;
    Port[$3C9] := 0;
    Port[$3C9] := 0;
  end;
end;

function DivPal(B: Byte; n: Integer): Byte;
begin
  DivPal := (((B * 100) div 63) * n) div 100;
end;

procedure FadeIn(P: array of Byte);
  var i, j: Integer;
      Pal: array[0..1023] of Byte;
begin
  for j := 0 to 63 do begin
    for i := 1 to 255 do begin
      Pal[i * 4 + 2] := DivPal(P[i * 4 + 2], j);
      Pal[i * 4 + 1] := DivPal(P[i * 4 + 1], j);
      Pal[i * 4] := DivPal(P[i * 4], j);
    end;
    Delay(10);
    SetPal(Pal);
  end;
end;

procedure FadeOut(P: array of Byte);
  var i, j: Integer;
      Pal: array[0..1023] of Byte;
begin
  for j := 63 downto 0 do begin
    for i := 1 to 255 do begin
      Pal[i * 4 + 2] := DivPal(P[i * 4 + 2], j);
      Pal[i * 4 + 1] := DivPal(P[i * 4 + 1], j);
      Pal[i * 4] := DivPal(P[i * 4], j);
    end;
    Delay(10);
    SetPal(Pal);
  end;
end;


end.
