{**********************************************************************}
{*                                                                    *}
{*        BMP.PAS - 楤  ࠡ  㭪  ଠ        *}
{*        Windows Bitmap                                              *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit BMP;

interface

uses Graph;

type PBitmap = ^TBitmap;
     TBitmap = record
       W, H: Word;
       Buf: Byte;
     end;

     TBmp = record
       Pal: array[0..1023] of Byte;
       W, H: LongInt;
       Bitmap: PBitmap;
     end;

procedure LoadBitmap(FileName: String; var B: TBmp);
procedure SetBitmapPal(B: TBmp);
procedure DrawBitmap(X, Y: Integer; B: TBmp);
procedure FreeBitmap(B: TBmp);
procedure Texture(B: TBmp);

var Bitmaps: array[1..9] of TBmp;

implementation

procedure LoadBitmap(FileName: String; var B: TBmp);
  var F: File;
begin
  {$I-}
  Assign(F, FileName);
  Reset(F, 1);
  if IOResult <> 0 then begin
    Writeln('Unable to load bitmap');
    Halt(1);
  end;
  {$I+}
  Seek(F, $12);
  BlockRead(F, B.W, 4);
  BlockRead(F, B.H, 4);
  Seek(F, 54);
  BlockRead(F, B.Pal, 1024);
  GetMem(B.Bitmap, B.W * B.H + 4);
  B.Bitmap^.W := B.W - 1;
  B.Bitmap^.H := B.H - 1;
  BlockRead(F, B.Bitmap^.Buf, B.W * B.H);
  Close(F);
end;

procedure SetBitmapPal(B: TBmp);
  var i: Integer;
begin
  for i := 1 to 255 do
    SetRGBPalette(i, B.Pal[i * 4 + 2] div 4, B.Pal[i * 4 + 1] div 4, B.Pal[i * 4] div 4);
end;

procedure DrawBitmap(X, Y: Integer; B: TBmp);
begin
  PutImage(X, Y, B.Bitmap^, NormalPut);
end;

procedure FreeBitmap(B: TBmp);
begin
  FreeMem(B.Bitmap, B.W * B.H);
end;

procedure Texture(B: TBmp);
  var i, j: Integer;
begin
  for i := 0 to GetMaxX div B.W + 1 do
    for j := 0 to GetMaxY div B.H + 1 do
      DrawBitmap(i * B.W, j * B.H, B);
end;


end.
