{**********************************************************************}
{*                                                                    *}
{*        DIALOG.PAS - ꥪ                          *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Dialog;

interface

uses Graph, Fonts, Bmp, Str_Data, Crt;

type PDialog = ^TDialog;
     TDialog = object
       Text: String;
       P: Pointer;
       Size: Word;
       constructor Init(S: String);
       destructor Done;
       procedure Draw; virtual;
     end;

     PSpeedDialog = ^TSpeedDialog;
     TSpeedDialog = object(TDialog)
       Size2: Word;
       P2: Pointer;
       constructor Init(S: String);
       destructor Done;
       procedure Draw; virtual;
       procedure Run(Min, Max: Integer; var Speed: Integer);
       procedure Update(N: Integer);
     end;

implementation

constructor TDialog.Init(S: String);
begin
  Text := S;
  Size := ImageSize(0, 0, 319, 199);
  GetMem(P, Size);
  GetImage(0, 0, 319, 199, P^);
  Draw;
end;

destructor TDialog.Done;
begin
  PutImage(0, 0, P^, NormalPut);
  FreeMem(P, Size);
end;

procedure TDialog.Draw;
  var i: Integer;
begin
  DrawBitmap(0, 0, Bitmaps[8]);
  for i := 0 to 4 do
  begin
    SetColor(217);
    Line(0 + i, 0 + i, 319 - i, 0 + i);
    Line(0 + i, 0 + i, 0 + i, 199 - i);
    SetColor(191);
    Line(319 - i, 199 - i, 0 + i, 199 - i);
    Line(319 - i, 199 - i, 319 - i, 0 + i);
  end;
  SetTextStyle(TripFont, HorizDir, 3);
  ShadowText((GetMaxX - TextWidth(Text)) div 2, 10, 1, 189, Text);
end;

constructor TSpeedDialog.Init(S: String);
begin
  inherited Init(S);
  Size2 := ImageSize(140, 70, 180, 110);
  GetMem(P2, Size2);
  GetImage(140, 70, 180, 110, P2^);
end;

destructor TSpeedDialog.Done;
begin
  inherited Done;
  FreeMem(P2, Size2);
end;

procedure TSpeedDialog.Draw;
  var i: Integer;
begin
  inherited Draw;
  SetTextStyle(LittFont, HorizDir, 5);
  for i := 1 to 3 do
    ShadowText(20, 140 + i * 10, 1, 189, DialogStr[i + 1]);
end;

procedure TSpeedDialog.Run(Min, Max: Integer; var Speed: Integer);
  var Temp: Integer;
      Key: Char;
begin
  Temp := Speed;
  SetTextStyle(TripFont, HorizDir, 5);
  Update(Temp);
  repeat
    Key := ReadKey;
    case Key of
      #80: if Temp > Min then
           begin
             Dec(Temp);
             Update(Temp);
           end;
      #72: if Temp < Max then
           begin
             Inc(Temp);
             Update(Temp);
           end;
    end;
  until (Key = #13) or (Key = #27);
  if Key = #13 then Speed := Temp;
end;

procedure TSpeedDialog.Update(N: Integer);
  var S: String;
begin
  Str(N, S);
  PutImage(140, 70, P2^, NormalPut);
  ShadowText((GetMaxX - TextWidth(S)) div 2, 70, 2, 189, S);
end;


end.
