{**********************************************************************}
{*                                                                    *}
{*        GAME.PAS - ᭮ ஢ ꥪ                          *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Game;

interface

uses BMP, Graph, Crt, Fonts,
     Fig, Pal, Figure, Menu,
     Str_Data, MesgBox, Gauge,
     Dialog, Records;

type TGame = object
       Speed, FigSet: Integer;
       Score: LongInt;
       Lines: Word;
       GameOver: Boolean;
       MainMenu: PMenu;
       R: PRecord;
       constructor Init;
       destructor Done;
       procedure FreeAllBitmaps;
       procedure LoadBitmaps;
       procedure InitVideo(VideoMode: Integer);
       procedure Intro;
       function Menu(Redraw: Boolean): Integer;
       procedure NewGame;
       procedure FigurSpeed;
       procedure FigurSet;
       procedure PlayGameOver;
       procedure CheckLines;
       procedure Help;
       procedure AddRecord;
       procedure Rules;
       procedure Run;
       procedure Bye;
     end;

implementation

{$L BGI256.OBJ}
procedure BGI256DRV; external;

constructor TGame.Init;
begin
  Randomize;
  Speed := 0;
  FigSet := 1;
  Score := 0;
  LoadFigures;
  MainMenu := New(PMenu, Init);
  LoadBitmaps;
  R := New(PRecord, Init('records.dat'));
  {Init VGA 320x200x256 video mode}
  InitVideo(0);
  SetNullPal;
  Intro;
  Rules;
end;

destructor TGame.Done;
begin
  CloseGraph;
  RestoreCRTMode;
  FreeAllBitmaps;
  Dispose(MainMenu, Done);
  R^.WriteFile;
  Dispose(R, Done);
end;

procedure TGame.LoadBitmaps;
  var i: Integer;
begin
  for i := 1 to 8 do
    LoadBitmap(FileStr[i], Bitmaps[i]);
end;

procedure TGame.InitVideo(VideoMode: Integer);
  var GraphDriver, GraphMode, Error: Integer;
begin
  RegisterFonts;
  GraphDriver := InstallUserDriver('BGI256', nil);
  RegisterBGIDriver(@BGI256DRV);
  GraphMode := VideoMode;
  InitGraph(GraphDriver, GraphMode, '');
  Error := GraphResult;
  if Error <> 0 then begin
    GraphErrorMsg(Error);
    Halt(1);
  end;
end;

procedure TGame.FreeAllBitmaps;
  var i: Integer;
begin
  for i := 1 to 8 do
    FreeBitmap(Bitmaps[i]);
end;

procedure TGame.Intro;
  var i, j: Integer;
      S: String;
begin
  DrawBitmap(0, 0, Bitmaps[1]);

  for i := 0 to 7 do
    for j := 0 to 4 do
    begin
      DrawBitmap(i * 32 + (GetMaxX - 256) div 2, j * 32 + (GetMaxY - 160) div 2, Bitmaps[3]);
      DrawFigure(i * 32 + (GetMaxX - 256) div 2 + 4,
                 j * 32 + (GetMaxY - 160) div 2 + 4, Random(MAX_FIGS) + 1, 6, Random(255) + 1);
    end;

  FadeIn(Bitmaps[1].Pal);

  SetTextStyle(DefaultFont, HorizDir, 4);
  S := GameMsg[1];
  for i := 0 to Length(S) - 1 do
  begin
    ShadowText((GetMaxX - TextWidth(S)) div 2 + i * 30,
               (GetMaxY - TextHeight(S)) div 2, 2, 2, S[i + 1]);
    Delay(200);
  end;

  SetTextStyle(LittFont, HorizDir, 4);
  ShadowText((GetMaxX - TextWidth(GameMsg[2])) div 2,
              GetMaxY - 20, 1, 6, GameMsg[2]);

  while KeyPressed do
    ReadKey;
  ReadKey;

  FadeOut(Bitmaps[1].Pal);
end;

function TGame.Menu(Redraw: Boolean): Integer;
begin
  Menu := MainMenu^.Run(Redraw);
end;

procedure TGame.PlayGameOver;
  var i, j: Integer;
begin
  SetColor(0);
  for i := HEIGHT - 1 downto 0 do
  begin
    for j := 0 to WIDTH - 1 do
    begin
      SetFillStyle(1, Random(255) + 1);
      Bar(W_X + j * MUL, H_Y + i * MUL, W_X + j * MUL + MUL, H_Y + i * MUL + MUL);
      Rectangle(W_X + j * MUL, H_Y + i * MUL, W_X + j * MUL + MUL, H_Y + i * MUL + MUL);
    end;
    Delay(100);
  end;
end;

procedure TGame.CheckLines;
  var i, j, n, k, m, rows: Integer;
begin
  rows := 0;
  for i := 1 to HEIGHT do
  begin
    n := 0;
    for j := 1 to WIDTH do
      if P[j, i] <> 0 then
        Inc(n);
    if n = WIDTH then
    begin
      Inc(rows);
      Delay(200);
      SetColor(0);
      for k := i downto 2 do
        for m := 1 to WIDTH do
        begin
          n := P[m, k];
          P[m, k] := P[m, k - 1];
          if P[m, k] <> 0 then
          begin
            SetFillStyle(1, P[m, k]);
            Bar(W_X + (m - 1) * MUL + 1, H_Y + (k - 1) * MUL + 1,
                W_X + (m - 1) * MUL + MUL - 1, H_Y + (k - 1) * MUL + MUL - 1);
            Rectangle(W_X + (m - 1) * MUL, H_Y + (k - 1) * MUL,
                      W_X + (m - 1) * MUL + MUL, H_Y + (k - 1) * MUL + MUL);
          end
          else if (P[m, k - 1] = 0) and (n <> 0) then
          begin
            SetFillStyle(1, 0);
            Bar(W_X + (m - 1) * MUL, H_Y + (k - 1) * MUL,
                W_X + m * MUL, H_Y + k * MUL);
          end;
        end;
    end;
  end;
  Inc(Lines, rows);
  case rows of
    1: Inc(Score, 100);
    2: Inc(Score, 300);
    3: Inc(Score, 500);
    4: Inc(Score, 800);
  end;
  if Speed < Score div 10000 then Speed := Score div 10000;
  if Speed > 9 then Speed := 9;
end;

procedure TGame.Help;
  var i: Integer;
      Size: Word;
      P: Pointer;
      S: String;
begin
  Size := ImageSize(0, 0, 319, 199);
  GetMem(P, Size);
  GetImage(0, 0, 319, 199, P^);
  DrawPlate(0, 0);
  SetTextStyle(DefaultFont, HorizDir, 2);
  ShadowText((GetMaxx - TextWidth(GameMsg[3])) div 2, 10, 1, 49, GameMsg[3]);
  SetTextStyle(LittFont, HorizDir, 4);
  SetColor(0);
  for i := 0 to 5 do
    OutTextXY(20, i * 20 + 50, GameMsg[i + 4]);
  OutTextXY((GetMaxX - TextWidth(GameMsg[10])) div 2, 180, GameMsg[10]);
  ReadKey;
  PutImage(0, 0, P^, NormalPut);
  FreeMem(P, Size);
end;

procedure TGame.NewGame;
  var i, j, Timer: Integer;
      OldSpeed, OldScore, OldLines: Integer;
      Key: Byte;
      Fig1: PFigure;
      Count: Byte;
      G1, G2, G3: PGauge;
begin
  Score := 0;
  Lines := 0;
  OldSpeed := Speed;
  OldScore := Score;
  OldLines := Lines;

  Texture(Bitmaps[6]);
  G1 := New(PGauge, Init(GetMaxX div 2, H_Y, GameMsg[15], 0));
  G2 := New(PGauge, Init(GetMaxX div 2, H_Y + 50, GameMsg[16], Speed));
  G3 := New(PGauge, Init(GetMaxX div 2, H_Y + 100, GameMsg[17], 0));

  SetFillStyle(1, 0);
  Bar(W_X + MUL, H_Y + MUL, W_X + WIDTH * MUL + MUL,
      H_Y + HEIGHT * MUL + MUL);
  SetFillStyle(1, 0);
  for i := 0 to WIDTH - 1 do
    for j := 0 to HEIGHT - 1 do
    begin
      Bar(W_X + i * MUL, H_Y + j * MUL,
          W_X + i * MUL + MUL, H_Y + j * MUL + MUL);
      P[i + 1, j + 1] := 0;
    end;

  SetColor(49);
  for i := 1 to 4 do
    Rectangle(W_X - i, H_Y - i,
              W_X + WIDTH * MUL + i, H_Y + HEIGHT * MUL + i);

  SetTextStyle(LittFont, HorizDir, 5);
  ShadowText(GetMaxX div 2, GetMaxY - TextHeight(GameMsg[19]) - H_Y - 10, 1, 26, GameMsg[19]);
  ShadowText(GetMaxX div 2, GetMaxY - TextHeight(GameMsg[20]) - H_Y, 1, 26, GameMsg[20]);

  FadeIn(Bitmaps[1].Pal);
  GameOver := False;

  Fig1 := New(PFigure, Init((FigSet - 1) * 7 + 6));
  Count := 0;
  Timer := 90 - Speed * 10;
  repeat
    if Keypressed then
    begin
      Key := Ord(ReadKey);
      case Key of
        77: Fig1^.Move(1, 0);
        75: Fig1^.Move(-1, 0);
        72: begin Fig1^.Rotate; Fig1^.Move(0, 0); end;
        80: begin Count := 0; Timer := 5; end;
        59: Help;
        27: if not MessageBox(GameMsg[11]) then Key := 0;
      end;
    end;
    if Count >= Timer then
    begin
      Fig1^.Move(0, 1);
      Count := 0;
    end;
    if Fig1^.StopFlag then
    begin
      Dispose(Fig1, Done);
      if Fig1^.Y <> 0 then
      begin
        CheckLines;
        Timer := 90 - Speed * 10;
        if OldScore <> Score then G1^.Update(Score);
        if OldSpeed <> Speed then G2^.Update(Speed);
        if OldLines <> Lines then G3^.Update(Lines);
        OldSpeed := Speed;
        OldScore := Score;
        OldLines := Lines;
        Fig1 := New(PFigure, Init((FigSet - 1) * 7 + 6));
      end
      else
      begin
        PlayGameOver;
        GameOver := True;
      end;
    end;
    Inc(Count);
    Delay(5);
  until GameOver or (Key = 27);

  Dispose(G1, Done);
  Dispose(G2, Done);
  Dispose(G3, Done);
  AddRecord;

  FadeOut(Bitmaps[1].Pal);
end;

procedure TGame.FigurSpeed;
  var D: PSpeedDialog;
begin
  D := New(PSpeedDialog, Init(DialogStr[1]));
  D^.Run(0, 9, Speed);
  Dispose(D, Done);
end;

procedure TGame.FigurSet;
  var D: PSpeedDialog;
begin
  D := New(PSpeedDialog, Init(DialogStr[5]));
  D^.Run(1, 2, FigSet);
  Dispose(D, Done);
end;

procedure TGame.Rules;
  var i, j: Integer;
begin
  DrawBitmap(0, 0, Bitmaps[1]);

  SetTextStyle(TripFont, HorizDir, 3);
  ShadowText((GetMaxX - TextWidth(GameMsg[12])) div 2, 10, 1, 210, GameMsg[12]);

  SetTextStyle(LittFont, HorizDir, 4);
  SetColor(0);
  FadeIn(Bitmaps[1].Pal);

  i := 1;

  while (i <= 20) and not KeyPressed do
  begin
    j := 1;
    while (j <= Length(RulesStr[i])) and not KeyPressed do
    begin
      OutTextXY(j * 6, 30 + i * 8, RulesStr[i][j]);
      Delay(50);
      Inc(j);
    end;
    Inc(i);
  end;

  ReadKey;
  FadeOut(Bitmaps[1].Pal);
end;

procedure TGame.AddRecord;
  var T: TRecordItem;
begin
  if R^.CanAdd(Score) then
  begin
    T.Name := InputBox(GameMsg[18]);
    R^.GetRecord(T);
    if T.Score <> -1 then
    begin
      if Score > T.Score then
      begin
        T.Score := Score;
        R^.Delete(T);
        R^.AddRecord(T);
      end;
    end
    else
    begin
      T.Score := Score;
      R^.AddRecord(T);
    end;
  end;
end;

procedure TGame.Run;
  var Res: Integer;
begin
  Res := 0;
  DrawBitmap(0, 0, Bitmaps[4]);
  repeat
    if (Res > 0) and (Res < 4) then
      Res := Menu(False)
    else
      Res := Menu(True);
    if not ((Res > 0) and (Res < 4)) then
      FadeOut(Bitmaps[5].Pal);
    case Res of
      0: NewGame;
      1: R^.DrawRecords;
      2: FigurSpeed;
      3: FigurSet;
      4: Rules;
    end;
    if not ((Res > 0) and (Res < 4)) then
      DrawBitmap(0, 0, Bitmaps[4]);
  until Res = 5;
  Bye;
end;

procedure TGame.Bye;
  var i, j: Integer;
begin
  FreeBitmap(Bitmaps[1]);
  LoadBitmap(FileStr[7], Bitmaps[1]);
  DrawBitmap(0, 0, Bitmaps[1]);

  SetTextStyle(TripFont, HorizDir, 5);
  ShadowText((GetMaxX - TextWidth(GameMsg[13])) div 2, 50, 1, 168, GameMsg[13]);
  SetTextStyle(TripFont, HorizDir, 4);
  ShadowText((GetMaxX - TextWidth(GameMsg[14])) div 2, 120, 1, 168, GameMsg[14]);

  FadeIn(Bitmaps[1].Pal);
  ReadKey;
  FadeOut(Bitmaps[1].Pal);
end;


end.
