{**********************************************************************}
{*                                                                    *}
{*        GAUGE.PAS - ꥪ 稪                                 *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Gauge;

interface

uses Graph, Fonts, Bmp;

type PGauge = ^TGauge;
     TGauge = object
       X, Y: Integer;
       Text: String;
       Count: LongInt;
       P: Pointer;
       Size: Word;
       constructor Init(X_, Y_: Integer; S: String; N: LongInt);
       destructor Done;
       procedure Draw;
       procedure Update(C: LongInt);
     end;

implementation

constructor TGauge.Init(X_, Y_: Integer; S: String; N: LongInt);
begin
  X := X_;
  Y := Y_;
  SetTextStyle(TripFont, HorizDir, 2);
  Text := S;
  Count := N;
  Size := ImageSize(X + TextWidth(Text), Y, X + 150, Y + 25);
  GetMem(P, Size);
  Draw;
  GetImage(X + TextWidth(Text), Y, X + 150, Y + 25, P^);
  Update(Count);
end;

destructor TGauge.Done;
begin
  FreeMem(P, Size);
end;

procedure TGauge.Draw;
begin
  SetFillStyle(1, 0);
  SetTextStyle(TripFont, HorizDir, 2);
  Bar(X + 5, Y + 5, X + 155, Y + 30);
  DrawBitmap(X, Y, Bitmaps[2]);
  ShadowText(X + (20 - TextHeight(Text)) div 2 + 5,
             Y + (20 - TextHeight(Text)) div 2, 1, 49, Text);
end;

procedure TGauge.Update(C: LongInt);
  var S: String;
begin
  Count := C;
  SetTextStyle(TripFont, HorizDir, 2);
  PutImage(X + TextWidth(Text), Y, P^, NormalPut);
  Str(Count, S);
  ShadowText(X + (20 - TextHeight(Text)) + TextWidth(Text) + 5,
             Y + (20 - TextHeight(Text)) div 2, 1, 49, S);
end;


end.
