{**********************************************************************}
{*                                                                    *}
{*        MENU.PAS - ꥪ  ࠡ                          *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Menu;

interface

uses Figure, Graph, Crt, BMP, Fonts, Fig, Pal, Str_Data;

const SelColor  = 188;
      NormColor = 159;

type PMenuItem = ^TMenuItem;
     TMenuItem = object
       X, Y: Integer;
       Index, Num, Size: Word;
       Selected: Boolean;
       constructor Init(X_, Y_, Ind, N: Integer; Sel: Boolean);
       destructor Done;
       procedure Draw;
       procedure DrawText(ReDraw: Boolean);
       procedure Select;
       procedure SetText;
       procedure UnSelect;
     end;

     PMenu = ^TMenu;
     TMenu = object
       Pos, OldPos: Integer;
       Items: array [1..6] of PMenuItem;
       constructor Init;
       destructor Done;
       procedure Draw;
       function Run(Redraw: Boolean): Integer;
     end;

implementation

constructor TMenuItem.Init(X_, Y_, Ind, N: Integer; Sel: Boolean);
begin
  X := X_;
  Y := Y_;
  Index := Ind;
  Num := N;
  Selected := Sel;
end;

procedure TMenuItem.SetText;
  var S: String;
      i: Integer;
begin
  S := '';
  for i := 1 to Num do
    if Length(MenuStr[Index + i - 1]) > Length(S) then S := MenuStr[Index + i - 1];
  Size := 10;
  repeat
    SetTextStyle(LittFont, Horizdir, Size);
    Dec(Size);
  until (TextWidth(S) < 50) and ((TextHeight(S) + 4) * Num < 50);
  Inc(Size);
end;

destructor TMenuItem.Done;
begin
end;

procedure TMenuItem.Draw;
begin
  SetFillStyle(1, 0);
  Bar(X + 2, Y + 2, X + 66, Y + 66);
  DrawBitmap(X, Y, Bitmaps[5]);
  DrawText(True);
end;

procedure TMenuItem.DrawText(ReDraw: Boolean);
  var i: Integer;
      Color: Word;
begin
  if Selected then
    SetColor(SelColor)
  else
    SetColor(NormColor);
  for i := 1 to Num do
  begin
    if ReDraw then
    begin
      Color := GetColor;
      SetColor(0);
      OutTextXY((64 - TextWidth(MenuStr[Index + i - 1])) div 2 + X + 1,
                (64 - (TextHeight(MenuStr[Index]) + 4) * Num) div 2 + Y + (TextHeight(MenuStr[Index]) + 4) * (i - 1) + 1,
                MenuStr[Index + i - 1]);
      SetColor(Color);
    end;
    OutTextXY((64 - TextWidth(MenuStr[Index + i - 1])) div 2 + X,
              (64 - (TextHeight(MenuStr[Index]) + 4) * Num) div 2 + Y + (TextHeight(MenuStr[Index]) + 4) * (i - 1),
              MenuStr[Index + i - 1]);
  end;
end;

procedure TMenuItem.Select;
begin
  SetText;
  if not Selected then
  begin
    Selected := True;
    DrawText(False);
  end;
end;

procedure TMenuItem.UnSelect;
begin
  SetText;
  if Selected then
  begin
    Selected := False;
    DrawText(False);
  end;
end;

constructor TMenu.Init;
  var i, j: Integer;
begin
  Pos := 0;
  OldPos := 0;
  Items[1] := New(PMenuItem, Init(48, 28, 2, 2, True));
  Items[2] := New(PMenuItem, Init(128, 28, 4, 3, False));
  Items[3] := New(PMenuItem, Init(208, 28, 7, 2, False));
  Items[4] := New(PMenuItem, Init(48, 108, 9, 2, False));
  Items[5] := New(PMenuItem, Init(128, 108, 11, 2, False));
  Items[6] := New(PMenuItem, Init(208, 108, 13, 3, False));
end;

destructor TMenu.Done;
  var i: Integer;
begin
  for i := 1 to 6 do
    Dispose(Items[i], Done);
end;

procedure TMenu.Draw;
  var i: Integer;
begin
  SetFillStyle(1, 0);

  for i := 1 to 6 do
  begin
    Items[i]^.SetText;
    Items[i]^.Draw;
  end;

  SetTextStyle(TripFont, HorizDir, 3);
  SetColor(0);

  for i := 1 to 5 do
  begin
    DrawFigure(18, 18 + (i - 1) * 36, i, 8, 0);
    DrawFigure(16, 16 + (i - 1) * 36, i, 8, 128 + Random(50));
    DrawFigure(282, 18 + (i - 1) * 36, i + 5, 8, 0);
    DrawFigure(280, 16 + (i - 1) * 36, i + 5, 8, 128 + Random(50));
  end;
end;

function TMenu.Run(Redraw: Boolean): Integer;
  var Key: Char;
begin
  if Redraw then
  begin
    Draw;
    FadeIn(Bitmaps[5].Pal);
  end;

  while KeyPressed do ReadKey;

  repeat
    Key := ReadKey;
    case Key of
      #77: if Pos < 5 then Inc(Pos);
      #75: if Pos > 0 then Dec(Pos);
      #72: if Pos > 2 then Dec(Pos, 3);
      #80: if Pos < 3 then Inc(Pos, 3);
    end;
    if Pos <> OldPos then
    begin
      Items[OldPos + 1]^.UnSelect;
      Items[Pos + 1]^.Select;
    end;
    OldPos := Pos;
  until Key = #13;

  Run := Pos;
end;


end.
