{**********************************************************************}
{*                                                                    *}
{*        PAL.PAS - 楤  ࠡ  ன                   *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Pal;

interface

procedure SetPal(P: array of Byte);
procedure SetNullPal;
procedure FadeIn(P: array of Byte);
procedure FadeOut(P: array of Byte);

implementation

uses Crt;

procedure SetPal(P: array of Byte);
  var i: Integer;
begin
  for i := 1 to 255 do
  begin
    Port[$3C8] := i;
    Port[$3C9] := P[i * 4 + 2] div 4;
    Port[$3C9] := P[i * 4 + 1] div 4;
    Port[$3C9] := P[i * 4] div 4;
  end;
end;

procedure SetNullPal;
  var i: Integer;
begin
  for i := 1 to 255 do
  begin
    Port[$3C8] := i;
    Port[$3C9] := 0;
    Port[$3C9] := 0;
    Port[$3C9] := 0;
  end;
end;

function DivPal(B: Byte; n: Integer): Byte;
begin
  DivPal := (((B * 100) div 63) * n) div 100;
end;

procedure FadeIn(P: array of Byte);
begin
  SetPal(P);
end;

procedure FadeOut(P: array of Byte);
begin
  SetNullPal;
end;


end.
