{**********************************************************************}
{*                                                                    *}
{*        RECORDS.PAS - ꥪ  ࠡ  ⠡楩 ४म         *}
{*        :  ࣥ                                        *}
{*        㯯: 3-2-41                                            *}
{*        : 12.03.99                                              *}
{*                                                                    *}
{**********************************************************************}

unit Records;

interface

uses Graph, Bmp, Fonts, Str_Data, Dialog, Crt;

const MAX_RECORDS = 10;

type TRecordItem = record
       Name: String[20];
       Score: LongInt;
     end;

     PRecord = ^TRecord;
     TRecord = object
       Count: Integer;
       Records: array [1..MAX_RECORDS] of TRecordItem;
       RecordFile: String;
       constructor Init(FileName: String);
       destructor Done;
       function CanAdd(Score: LongInt): Boolean;
       procedure GetRecord(var ARecord: TRecordItem);
       procedure WriteFile;
       procedure DrawRecords;
       procedure AddRecord(ARecord: TRecordItem);
       procedure Replace(ARecord: TRecordItem);
       procedure Delete(ARecord: TRecordItem);
     end;

implementation

constructor TRecord.Init(FileName: String);
  var F: File of TRecordItem;
begin
  Count := 0;
  RecordFile := FileName;
  {$I-}
  Assign(F, RecordFile);
  Reset(F);
  {$I+}
  if IOResult = 0 then
  begin
    while not Eof(F) do
    begin
      Read(F, Records[Count + 1]);
      Inc(Count);
    end;
    Close(F);
  end;
end;

destructor TRecord.Done;
begin

end;

function TRecord.CanAdd(Score: LongInt): Boolean;
  var i: Integer;
begin
  CanAdd := False;
  for i := 1 to Count do
    if Score >= Records[i].Score then CanAdd := True;
  if Count = 0 then
    CanAdd := True;
end;

procedure TRecord.GetRecord(var ARecord: TRecordItem);
  var i: Integer;
begin
  ARecord.Score := -1;
  for i := 1 to Count do
    if Records[i].Name = ARecord.Name then
      ARecord.Score := Records[i].Score;
end;

procedure TRecord.WriteFile;
  var F: File of TRecordItem;
      i: Integer;
begin
  Assign(F, RecordFile);
  Rewrite(F);
  for i := 1 to Count do
    Write(F, Records[i]);
  Close(F);
end;

procedure TRecord.DrawRecords;
  var D: PDialog;
      i: Integer;
      S: String;
begin
  D := New(PDialog, Init(RecordStr[1]));
  SetTextStyle(LittFont, HorizDir, 5);
  ShadowText(40, 40, 1, 189, RecordStr[2]);
  ShadowText(150, 40, 1, 189, RecordStr[3]);
  SetTextStyle(LittFont, HorizDir, 4);
  for i := 1 to Count do
  begin
    Str(i, S);
    ShadowText(40, 60 + i * 10, 1, 189, S);
    ShadowText(50, 60 + i * 10, 1, 189, Records[i].Name);
    Str(Records[i].Score, S);
    ShadowText(150, 60 + i * 10, 1, 189, S);
  end;
  ShadowText((GetMaxX - TextWidth(GameMsg[10])) div 2, 180, 1, 189, GameMsg[10]);
  ReadKey;
  Dispose(D, Done);
end;

procedure TRecord.AddRecord(ARecord: TRecordItem);
  var i, Pos: Integer;
begin
  if Count = 0 then
    Records[1] := ARecord
  else
  begin
    for i := 1 to Count do
      if ARecord.Score >= Records[i].Score then
      begin
        Pos := i;
        Break;
      end;

    for i := Count + 1 downto Pos + 1 do
      if i < 11 then Records[i] := Records[i - 1];

    Records[Pos] := ARecord;
  end;
  Inc(Count);
  if Count > 10 then Count := 10;
end;

procedure TRecord.Replace(ARecord: TRecordItem);
  var i: Integer;
begin
  for i := 1 to Count do
    if Records[i].Name = ARecord.Name then
      Records[i].Score := ARecord.Score;
end;

procedure TRecord.Delete(ARecord: TRecordItem);
  var i, Pos: Integer;
begin
  for i := 1 to Count do
    if Records[i].Name = ARecord.Name then
    begin
      Pos := i;
      Break;
    end;

  for i := Pos to Count - 1 do
    Records[i] := Records[i + 1];

  Dec(Count);
end;


end.
