'
'  THE
'        _________  ______
'       /~~~~~~~~/ /~~~~~~\                  ()
'      / /~~~~/ / / /~~\  / ____   ____     _  ___
'     / /    / / / /___/ / /~~~~\ //~~\\   // /~~~\
'    / /    / / / _~~~~ / //~~~// \\   ~  // //~~~~
'   / / _  / / / /~~\  / //   //   \\    // //
'  / /__\\/ / / /___/ / //   // _   \\  //  \\
' /  ~~~~  / /  ~~~~ / / ----^\ \\__// //    \~~~/
' ~~~~~~~~~  ~~~~~~~~  ~~~~~~ ~  ~~~~  ~      ~~~
'
'                                                 STATION
'
'    http://www.bitsmart.com/qbstation
'
'    (qbstation@hotmail.com)
'
'    VECTOR FIRE, March, 1999
'
' NOTES:
'
'    The delay loop for this game is located within a do...while loop
' in the subroutine runfire.  It is remarked noticeably with instructions
' for adjusting the game to your computer's speed.  There is another loop
' that may need adjusting in prnt, too.  If the file "vfire.gif" is not
' in the current directory, the game will hang.
'
'
DECLARE SUB drawgif ()
DECLARE FUNCTION question! ()
DECLARE FUNCTION runfire! (plyr!)
DECLARE SUB box (x1!, y1!, x2!, y2!, style!, col!)
DECLARE SUB help ()
DECLARE SUB prnt (a$, x!, y!, col!)
DECLARE SUB explode (plyr!)
DECLARE SUB drawplayer (plyr!)
DECLARE SUB getvalues2 ()
DECLARE SUB dispnum (nxx!, nyy!, num!, max!, c!)
DECLARE SUB getvalues1 ()
DECLARE SUB digital (x!, y!, num!, c!)
DECLARE SUB setup ()
DECLARE SUB drawscreen ()
DECLARE SUB drawplayert (plyr!)

TYPE pl
    xpos AS INTEGER
    ypos AS INTEGER
    zpos AS INTEGER
    ang AS INTEGER
    x AS SINGLE
    y AS SINGLE
    z AS SINGLE
    vx AS SINGLE
    vy AS SINGLE
    vz AS SINGLE
    pitch AS SINGLE
    yaw AS SINGLE
    power AS SINGLE
    count AS INTEGER
    windz AS SINGLE
    windx AS SINGLE
    grav AS SINGLE
    quit AS INTEGER
END TYPE

DEFINT A-Z
DIM SHARED Prefix(4095), Suffix(4095), OutStack(4095), shiftout%(8)
DIM SHARED Ybase AS LONG, powersof2(11) AS LONG, WorkCode AS LONG

DIM SHARED player(2) AS pl

COMMON SHARED x, y, z, vx, vy, vz, pitch, yaw, power

the:

drawgif

here:
a$ = UCASE$(INKEY$)
IF a$ = CHR$(27) THEN END
IF a$ = "E" THEN END
IF a$ = "S" THEN GOTO there
IF a$ = "H" THEN
    help
    GOTO the
END IF

GOTO here


there:

ERASE player

setup


begin:

getvalues1
IF player(1).quit = 1 THEN GOTO the
IF runfire(1) = 2 THEN
    explode (2)
    DO
    a$ = INKEY$
    IF UCASE$(a$) = "Y" THEN GOTO there
    IF UCASE$(a$) = "N" THEN GOTO the
    LOOP
END IF

getvalues2
IF player(2).quit = 1 THEN GOTO the
IF runfire(2) = 1 THEN
    explode (1)
    DO
    a$ = INKEY$
    IF UCASE$(a$) = "Y" THEN GOTO there
    IF UCASE$(a$) = "N" THEN GOTO the
    LOOP
END IF


GOTO begin

DEFSNG A-Z
SUB box (x1, y1, x2, y2, style, col)

IF style = 1 THEN
  hor = 205
  ver = 186
  ul = 201
  ur = 187
  ll = 200
  lr = 188
END IF
IF style = 2 THEN
  hor = 196
  ver = 179
  ul = 218
  ur = 191
  ll = 192
  lr = 217
END IF

COLOR col

FOR t = x1 + 1 TO x2 - 1
 LOCATE y1, t
 PRINT CHR$(hor)
 LOCATE y2, t
 PRINT CHR$(hor)
NEXT t

FOR t = y1 + 1 TO y2 - 1
 LOCATE t, x1
 PRINT CHR$(ver)
 LOCATE t, x2
 PRINT CHR$(ver)
NEXT t

LOCATE y1, x1
PRINT CHR$(ul)
LOCATE y2, x1
PRINT CHR$(ll)
LOCATE y1, x2
PRINT CHR$(ur)
LOCATE y2, x2
PRINT CHR$(lr)

END SUB

SUB digital (x, y, num, c)

'seg 1
LINE (x + 2, y + 1)-(x + 12, y + 1), 8
LINE (x + 3, y + 2)-(x + 11, y + 2), 8
'seg 2
LINE (x + 1, y + 3)-(x + 1, y + 10), 8
LINE (x + 2, y + 4)-(x + 2, y + 9), 8
'seg3
LINE (x + 13, y + 3)-(x + 13, y + 10), 8
LINE (x + 12, y + 4)-(x + 12, y + 9), 8
'seg4
LINE (x + 3, y + 11)-(x + 11, y + 12), 8, B
'seg5
LINE (x + 1, y + 13)-(x + 1, y + 20), 8
LINE (x + 2, y + 14)-(x + 2, y + 19), 8
'seg6
LINE (x + 13, y + 13)-(x + 13, y + 20), 8
LINE (x + 12, y + 14)-(x + 12, y + 19), 8
'seg7
LINE (x + 2, y + 22)-(x + 12, y + 22), 8
LINE (x + 3, y + 21)-(x + 11, y + 21), 8


'draw each individual number at (x,y)

IF num = 0 THEN
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
LINE (x + 1, y + 3)-(x + 1, y + 10), c
LINE (x + 2, y + 4)-(x + 2, y + 9), c
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
LINE (x + 1, y + 13)-(x + 1, y + 20), c
LINE (x + 2, y + 14)-(x + 2, y + 19), c
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
LINE (x + 2, y + 22)-(x + 12, y + 22), c
LINE (x + 3, y + 21)-(x + 11, y + 21), c
END IF

IF num = 1 THEN
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
END IF

IF num = 2 THEN
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
LINE (x + 3, y + 11)-(x + 11, y + 12), c, B
LINE (x + 1, y + 13)-(x + 1, y + 20), c
LINE (x + 2, y + 14)-(x + 2, y + 19), c
LINE (x + 2, y + 22)-(x + 12, y + 22), c
LINE (x + 3, y + 21)-(x + 11, y + 21), c
END IF

IF num = 3 THEN
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
LINE (x + 3, y + 11)-(x + 11, y + 12), c, B
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
LINE (x + 2, y + 22)-(x + 12, y + 22), c
LINE (x + 3, y + 21)-(x + 11, y + 21), c
END IF

IF num = 4 THEN
'seg 2
LINE (x + 1, y + 3)-(x + 1, y + 10), c
LINE (x + 2, y + 4)-(x + 2, y + 9), c
'seg3
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
'seg4
LINE (x + 3, y + 11)-(x + 11, y + 12), c, B
'seg6
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
END IF

IF num = 5 THEN
'seg 1
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
'seg 2
LINE (x + 1, y + 3)-(x + 1, y + 10), c
LINE (x + 2, y + 4)-(x + 2, y + 9), c
'seg4
LINE (x + 3, y + 11)-(x + 11, y + 12), c, B
'seg6
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
'seg7
LINE (x + 2, y + 22)-(x + 12, y + 22), c
LINE (x + 3, y + 21)-(x + 11, y + 21), c
END IF

IF num = 6 THEN
'seg 1
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
'seg 2
LINE (x + 1, y + 3)-(x + 1, y + 10), c
LINE (x + 2, y + 4)-(x + 2, y + 9), c
'seg4
LINE (x + 3, y + 11)-(x + 11, y + 12), c, B
'seg5
LINE (x + 1, y + 13)-(x + 1, y + 20), c
LINE (x + 2, y + 14)-(x + 2, y + 19), c
'seg6
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
'seg7
LINE (x + 2, y + 22)-(x + 12, y + 22), c
LINE (x + 3, y + 21)-(x + 11, y + 21), c
END IF

IF num = 7 THEN
'seg 1
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
'seg 2
LINE (x + 1, y + 3)-(x + 1, y + 10), c
LINE (x + 2, y + 4)-(x + 2, y + 9), c
'seg3
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
'seg6
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
END IF

IF num = 8 THEN
'seg 1
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
'seg 2
LINE (x + 1, y + 3)-(x + 1, y + 10), c
LINE (x + 2, y + 4)-(x + 2, y + 9), c
'seg3
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
'seg4
LINE (x + 3, y + 11)-(x + 11, y + 12), c, B
'seg5
LINE (x + 1, y + 13)-(x + 1, y + 20), c
LINE (x + 2, y + 14)-(x + 2, y + 19), c
'seg6
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
'seg7
LINE (x + 2, y + 22)-(x + 12, y + 22), c
LINE (x + 3, y + 21)-(x + 11, y + 21), c
END IF

IF num = 9 THEN
'seg 1
LINE (x + 2, y + 1)-(x + 12, y + 1), c
LINE (x + 3, y + 2)-(x + 11, y + 2), c
'seg 2
LINE (x + 1, y + 3)-(x + 1, y + 10), c
LINE (x + 2, y + 4)-(x + 2, y + 9), c
'seg3
LINE (x + 13, y + 3)-(x + 13, y + 10), c
LINE (x + 12, y + 4)-(x + 12, y + 9), c
'seg4
LINE (x + 3, y + 11)-(x + 11, y + 12), c, B
'seg6
LINE (x + 13, y + 13)-(x + 13, y + 20), c
LINE (x + 12, y + 14)-(x + 12, y + 19), c
'seg7
LINE (x + 2, y + 22)-(x + 12, y + 22), c
LINE (x + 3, y + 21)-(x + 11, y + 21), c
END IF

END SUB

SUB dispnum (nxx, nyy, num, max, c)
num = INT(num)

IF max = 1 THEN
 digital nxx, nyy, num, c
 GOTO endnum
END IF

IF max = 2 THEN
 digital nxx, nyy, INT(num / 10), c
 digital nxx + 15, nyy, num - (INT(num / 10) * 10), c
 GOTO endnum
END IF

IF max = 3 THEN
 digital nxx, nyy, INT(num / 100), c
 digital nxx + 15, nyy, INT((num - (INT(num / 100) * 100)) / 10), c
 digital nxx + 30, nyy, num - (INT(num / 10) * 10), c
 GOTO endnum
END IF

IF max = 4 THEN
 digital nxx, nyy, INT(num / 1000), c
 digital nxx + 15, nyy, INT((num - (INT(num / 1000) * 1000)) / 100), c
 digital nxx + 30, nyy, INT((num - (INT(num / 100) * 100)) / 10), c
 digital nxx + 45, nyy, num - (INT(num / 10) * 10), c
END IF

IF max = 5 THEN
 digital nxx, nyy, INT(num / 10000), c
 digital nxx + 15, nyy, INT((num - (INT(num / 10000) * 10000)) / 1000), c
 digital nxx + 30, nyy, INT((num - (INT(num / 1000) * 1000)) / 100), c
 digital nxx + 45, nyy, INT((num - (INT(num / 100) * 100)) / 10), c
 digital nxx + 60, nyy, num - (INT(num / 10) * 10), c
END IF

IF max = 6 THEN
 digital nxx, nyy, INT(num / 100000), c
 digital nxx + 15, nyy, INT((num - (INT(num / 100000) * 100000)) / 10000), c
 digital nxx + 30, nyy, INT((num - (INT(num / 10000) * 10000)) / 1000), c
 digital nxx + 45, nyy, INT((num - (INT(num / 1000) * 1000)) / 100), c
 digital nxx + 60, nyy, INT((num - (INT(num / 100) * 100)) / 10), c
 digital nxx + 75, nyy, num - (INT(num / 10) * 10), c
END IF



endnum:

END SUB

DEFINT A-Z
SUB drawgif

a$ = "vfire.gif"


'********** Assign needed values to variables *******
FOR a% = 0 TO 7
 shiftout%(8 - a%) = 2 ^ a%
NEXT a%

FOR a% = 0 TO 11
 powersof2(a%) = 2 ^ a%
NEXT a%

'********** Get file information for the GIF image ************
OPEN a$ FOR BINARY AS #1

a$ = "      "
GET #1, , a$

GET #1, , totalx
GET #1, , totaly

GOSUB GetByte

NumColors = 2 ^ ((a% AND 7) + 1)
NoPalette = (a% AND 128) = 0

GOSUB GetByte
Background = a%
GOSUB GetByte

IF NoPalette = 0 THEN p$ = SPACE$(NumColors * 3): GET #1, , p$
DO
    GOSUB GetByte
    IF a% = 44 THEN EXIT DO
    'ELSEIF a% <> 33 THEN
    '    PRINT "Unknown extension type.": END
    'END IF
    GOSUB GetByte
    DO
     GOSUB GetByte
     a$ = SPACE$(a%)
     GET #1, , a$
    LOOP UNTIL a% = 0
LOOP

GET #1, , XStart
GET #1, , YStart
GET #1, , xlength
GET #1, , ylength

XEnd = XStart + xlength
YEnd = YStart + ylength
GOSUB GetByte
IF a% AND 128 THEN
 PRINT "Can't handle local colormaps."
 END
END IF

Interlaced = a% AND 64
PassNumber = 0
PassStep = 8
GOSUB GetByte

ClearCode = 2 ^ a%
EOSCode = ClearCode + 1
FirstCode = ClearCode + 2
NextCode = FirstCode
StartCodeSize = a% + 1
CodeSize = StartCodeSize
StartMaxCode = 2 ^ (a% + 1) - 1
MaxCode = StartMaxCode

BitsIn = 0
BlockSize = 0
BlockPointer = 1
x% = XStart
y% = YStart
Ybase = y% * 320&

'******************** DRAW THE IMAGE ************************

SCREEN 13
DEF SEG = &HA000
IF NoPalette = 0 THEN
    OUT &H3C7, 0: OUT &H3C8, 0
    FOR a% = 1 TO NumColors * 3: OUT &H3C9, ASC(MID$(p$, a%, 1)) \ 4: NEXT a%
END IF
LINE (0, 0)-(319, 199), Background, BF
DO
    GOSUB GetCode
    IF Code <> EOSCode THEN
        IF Code = ClearCode THEN
            NextCode = FirstCode
            CodeSize = StartCodeSize
            MaxCode = StartMaxCode
            GOSUB GetCode
            CurCode = Code
            LastCode = Code
            LastPixel = Code
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1
            IF x% = XEnd THEN GOSUB NextScanLine
        ELSE
            CurCode = Code: StackPointer = 0
            IF Code > NextCode THEN EXIT DO
            IF Code = NextCode THEN
                CurCode = LastCode
                OutStack(StackPointer) = LastPixel
                StackPointer = StackPointer + 1
            END IF

            DO WHILE CurCode >= FirstCode
                OutStack(StackPointer) = Suffix(CurCode)
                StackPointer = StackPointer + 1
                CurCode = Prefix(CurCode)
            LOOP

            LastPixel = CurCode
            IF x% < 320 THEN POKE x% + Ybase, LastPixel
            x% = x% + 1
            IF x% = XEnd THEN GOSUB NextScanLine

            FOR a% = StackPointer - 1 TO 0 STEP -1
                IF x% < 320 THEN POKE x% + Ybase, OutStack(a%)
                x% = x% + 1
                IF x% = XEnd THEN GOSUB NextScanLine
            NEXT a%

            IF NextCode < 4096 THEN
                Prefix(NextCode) = LastCode
                Suffix(NextCode) = LastPixel
                NextCode = NextCode + 1
                IF NextCode > MaxCode AND CodeSize < 12 THEN
                    CodeSize = CodeSize + 1
                    MaxCode = MaxCode * 2 + 1
                END IF
            END IF
            LastCode = Code
        END IF
    END IF
LOOP UNTIL DoneFlag OR Code = EOSCode
BEEP
GOTO finishedgif

'***************** SUBROUTINES ********************

'**********************
GetByte:
 a$ = " "
 GET #1, , a$
 a% = ASC(a$)
RETURN

'**********************
NextScanLine:
    IF Interlaced THEN
        y% = y% + PassStep
        IF y% >= YEnd THEN
            PassNumber = PassNumber + 1
            SELECT CASE PassNumber
            CASE 1: y% = 4: PassStep = 8
            CASE 2: y% = 2: PassStep = 4
            CASE 3: y% = 1: PassStep = 2
            END SELECT
        END IF
    ELSE
        y% = y% + 1
    END IF
    x% = XStart
    Ybase = y% * 320&
    DoneFlag = y% > 199
RETURN

'**********************
GetCode:
    IF BitsIn = 0 THEN
     GOSUB ReadBufferedByte
     LastChar = a%
     BitsIn = 8
    END IF
    WorkCode = LastChar \ shiftout%(BitsIn)
    DO WHILE CodeSize > BitsIn
        GOSUB ReadBufferedByte
        LastChar = a%
        WorkCode = WorkCode OR LastChar * powersof2(BitsIn)
        BitsIn = BitsIn + 8
    LOOP
    BitsIn = BitsIn - CodeSize
    Code = WorkCode AND MaxCode
RETURN

'**********************
ReadBufferedByte:
    IF BlockPointer > BlockSize THEN
        GOSUB GetByte
        BlockSize = a%
        a$ = SPACE$(BlockSize)
        GET #1, , a$
        BlockPointer = 1
    END IF
    a% = ASC(MID$(a$, BlockPointer, 1))
    BlockPointer = BlockPointer + 1
RETURN

finishedgif:
CLOSE

END SUB

DEFSNG A-Z
SUB drawplayer (plyr)



' bottom

CIRCLE (player(plyr).xpos, 448 - player(plyr).ypos), 7, 15
PAINT (player(plyr).xpos, 448 - player(plyr).ypos), 7, 15
CIRCLE (player(plyr).xpos, 448 - player(plyr).ypos), 7, 7

LINE (player(plyr).xpos - 7, 450)-(player(plyr).xpos + 7, 450 - player(plyr).ypos), 15, BF


END SUB

SUB drawplayert (plyr)

' top

LINE (player(plyr).xpos, player(plyr).zpos)-(player(plyr).xpos + (COS(player(plyr).ang * 3.14159 / 180) * 25), player(plyr).zpos + (SIN(-player(plyr).ang * 3.14159 / 180) * 25)), 2

CIRCLE (player(plyr).xpos, player(plyr).zpos), 7, 15
PAINT (player(plyr).xpos, player(plyr).zpos), 7, 15


END SUB

SUB drawscreen
' backgrounds
LINE (0, 1)-(639, 198), 6, BF
LINE (0, 201)-(639, 450), 1, BF

' "holes" for the digital displays
LINE (0, 201)-(58, 293), 0, BF
LINE (-1, 200)-(58, 295), 9, B
LINE (-1, 200)-(57, 294), 15, B
LINE (-1, 200)-(56, 293), 7, B

LINE (581, 201)-(639, 293), 0, BF

LINE (581, 200)-(640, 295), 9, B
LINE (582, 200)-(640, 294), 15, B
LINE (583, 200)-(640, 293), 7, B


' border lines

LINE (-1, 0)-(640, 0), 15, B

LINE (-1, 1)-(639, 198), 7, B
LINE (0, 199)-(639, 200), 15, B
LINE (59, 201)-(580, 201), 9

LINE (0, 451)-(639, 453), 6, BF
LINE (0, 450)-(639, 450), 9
LINE (0, 454)-(639, 454), 15


'Wind indicator
CIRCLE (320, 100), 4, 3
LINE (320, 100)-STEP(200 * player(1).windx, 200 * player(1).windz), 11





drawplayer 1
drawplayert 1
drawplayer 2
drawplayert 2

dispnum 5, 205, player(1).yaw, 3, 10
dispnum 5, 235, player(1).pitch, 3, 10
dispnum 5, 265, player(1).power, 3, 14

dispnum 590, 205, player(2).yaw, 3, 10
dispnum 590, 235, player(2).pitch, 3, 10
dispnum 590, 265, player(2).power, 3, 14

END SUB

SUB explode (plyr)

FOR t = 1 TO 200
 c = CINT(RND * 2)
 IF c = 0 THEN c = 14
 IF c = 1 THEN c = 12
 IF c = 2 THEN c = 4
 xx = CINT(RND * 100) - 50
 zz = CINT(RND * 100) - 50
 yy = CINT(RND * 70)

 LINE (player(plyr).xpos, player(plyr).zpos)-(player(plyr).xpos + xx, player(plyr).zpos + zz), c
 LINE (player(plyr).xpos, 450 - player(plyr).ypos)-(player(plyr).xpos + xx, 450 - player(plyr).ypos - yy), c
 PSET (player(plyr).xpos - (xx / 2), player(plyr).zpos + (zz / 2)), 15

 FOR q = 1 TO 1000
 NEXT q
NEXT t

FOR t = 11 TO 75
  c = CINT(RND * 1)
  IF c = 0 THEN c = 14
  IF c = 1 THEN c = 12
 
  IF t < 66 THEN
    CIRCLE (player(plyr).xpos, 450 - player(plyr).ypos), t, c, 6.283 - (t / 500), 3.1415 + (t / 500)
    CIRCLE (player(plyr).xpos, player(plyr).zpos), t, c
  END IF

  IF t > 18 THEN
    CIRCLE (player(plyr).xpos, player(plyr).zpos), t - 10, 6
  ELSE
    CIRCLE (player(plyr).xpos, player(plyr).zpos), 7, 15
    PAINT (player(plyr).xpos, player(plyr).zpos), 15, 15
  END IF

  CIRCLE (player(plyr).xpos, 450 - player(plyr).ypos), t - 10, 1, 6.283 - ((t - 10) / 500), 3.1415 + ((t - 10) / 500)

  FOR q = 1 TO 1000
  NEXT q
NEXT t


'display game over sequence

'open a box in center
FOR t = 0 TO 70
LINE (320 - t, 200 - t)-(320 + t, 200 + t), 0, BF
LINE (320 - (t + 1), 200 - (t + 1))-(320 + (t + 1), 200 + (t + 1)), 7, B
LINE (320 - (t + 2), 200 - (t + 2))-(320 + (t + 2), 200 + (t + 2)), 15, B
LINE (320 - (t + 3), 200 - (t + 3))-(320 + (t + 3), 200 + (t + 3)), 7, B
NEXT t

IF plyr = 1 THEN pp = 2 ELSE pp = 1

IF plyr = 1 THEN prnt "victory for player 2", 270, 160, 15
IF plyr = 2 THEN prnt "victory for player 1", 270, 160, 15

a$ = "Number of rounds -" + STR$(player(pp).count)
prnt a$, 270, 190, 2

prnt "Play again?", 270, 230, 14



DO
LOOP UNTIL INKEY$ = ""

END SUB

SUB getvalues1

displ1:


dispnum 5, 205, player(1).yaw, 3, 10
dispnum 5, 235, player(1).pitch, 3, 10
dispnum 5, 265, player(1).power, 3, 14

dp1:
a$ = INKEY$
IF a$ = "" THEN GOTO dp1
IF a$ = CHR$(27) THEN
   IF question = 1 THEN player(1).quit = 1 ELSE drawscreen
   IF player(1).quit = 1 THEN GOTO exit1
END IF

IF a$ = "q" THEN player(1).yaw = player(1).yaw - 1
IF a$ = "w" THEN player(1).yaw = player(1).yaw + 1
IF a$ = "a" THEN player(1).pitch = player(1).pitch - 1
IF a$ = "s" THEN player(1).pitch = player(1).pitch + 1
IF a$ = "z" THEN player(1).power = player(1).power - 1
IF a$ = "x" THEN player(1).power = player(1).power + 1

IF player(1).power < 0 THEN player(1).power = 0
IF player(1).yaw < 0 THEN player(1).yaw = player(1).yaw + 360
IF player(1).pitch < 0 THEN player(1).pitch = player(1).pitch + 360
IF player(1).yaw > 360 THEN player(1).yaw = player(1).yaw - 360
IF player(1).pitch > 360 THEN player(1).pitch = player(1).pitch - 360


IF a$ = CHR$(32) THEN  ELSE GOTO displ1
player(1).count = player(1).count + 1

exit1:

END SUB

SUB getvalues2

displ2:


dispnum 590, 205, player(2).yaw, 3, 10
dispnum 590, 235, player(2).pitch, 3, 10
dispnum 590, 265, player(2).power, 3, 14

dp2:
a$ = INKEY$
IF a$ = "" THEN GOTO dp2
IF a$ = CHR$(27) THEN
   IF question = 1 THEN player(2).quit = 1 ELSE drawscreen
   IF player(2).quit = 1 THEN GOTO exit2
END IF

IF a$ = "o" THEN player(2).yaw = player(2).yaw - 1
IF a$ = "p" THEN player(2).yaw = player(2).yaw + 1
IF a$ = "l" THEN player(2).pitch = player(2).pitch - 1
IF a$ = ";" THEN player(2).pitch = player(2).pitch + 1
IF a$ = "." THEN player(2).power = player(2).power - 1
IF a$ = "/" THEN player(2).power = player(2).power + 1

IF player(2).power < 0 THEN player(2).power = 0
IF player(2).yaw < 0 THEN player(2).yaw = player(2).yaw + 360
IF player(2).pitch < 0 THEN player(2).pitch = player(2).pitch + 360
IF player(2).yaw > 360 THEN player(2).yaw = player(2).yaw - 360
IF player(2).pitch > 360 THEN player(2).pitch = player(2).pitch - 360


IF a$ = CHR$(32) THEN  ELSE GOTO displ2
player(2).count = player(2).count + 1

exit2:

END SUB

DEFINT A-Z
SUB help

SCREEN 2
SCREEN 0
CLS

page = 1

pagestart:
IF page = 4 THEN page = 3
IF page = 0 THEN page = 1
CLS

LOCATE 2, 35
COLOR 15
PRINT "Help"
LOCATE 4
COLOR 7

IF page = 1 THEN GOTO page1
IF page = 2 THEN GOTO page2
IF page = 3 THEN GOTO page3

page1:
COLOR 3
PRINT "      Vector Fire is a 3-D trajectory strategy game.  To be the winner,"
PRINT "   you must find the correct angle and power settings for your cannon."
PRINT
PRINT "      The following keys are used to manipulate the cannon settings:"
PRINT
PRINT
COLOR 10
PRINT "                      Player 1                    Player 2"
COLOR 2
PRINT
PRINT "            Yaw        Q   W                       O   P"
PRINT "            Pitch      A   S                       L   ;"
PRINT "            Power      Z   X                       .   /"
PRINT
COLOR 3
PRINT
PRINT "   The settings are viewed on the digital display on your side of the"
PRINT "   screen.  While adjusting the settings, the changes are displayed."
PRINT "   When a player is finished his/her cannon adjustments, pressing the"
PRINT "   space bar will shoot the cannon."
GOTO endpage

page2:
COLOR 3
PRINT "      Since this game is done in 3-D, the method of properly viewing the"
PRINT "   results of one turn is through simultaneous top and side views of the"
PRINT "   battle area.  It is important to notice that the cannon may seem to"
PRINT "   hit its target on one view but miss on another.  The trick is to have"
PRINT "   both views hit at the same time."
PRINT
PRINT "      In order to avoid certain confusion, you must know what you are aiming"
PRINT "   for.  Of course, the other player, but more specifically, the top of your"
PRINT "   opponents building.  Hitting the bottom of the structure will have no"
PRINT "   effect.  For ease in figuring adjustments for the next turn the cannon"
PRINT "   will leave a faint trail to observe.  This trail will be seen on both the"
PRINT "   top and the bottom viewscreens."
GOTO endpage

page3:
COLOR 3
PRINT "      After each shot, the position of the projectile will be highlighted"
PRINT "   on both viewscreens.  A prompt will appear:"
PRINT
COLOR 11
PRINT "       PRESS A KEY, PLAYER #"
COLOR 3
PRINT
PRINT "   Player # should press any of the cannon adjustment keys to continue."
PRINT "   This will allow the next player to take a turn."
PRINT
PRINT "      For each game, the position, height, and orientation of each players'"
PRINT "   building will be different.  Also, the wind factor/direction will play"
PRINT "   a significant part in your cannon settings.  Gravity will not vary much"
PRINT "   from game to game, but be aware that it does change.  Each players'"
PRINT "   building shows a 0-degree line for orientation.  A wind speed/direction"
PRINT "   indicator is displayed on the top viewscreen.  The gravity strength is"
PRINT "   the only variable that must be figured out through trial and error."

endpage:
COLOR 7
LOCATE 22, 3
PRINT "<- 1 2 3 ->"
COLOR 15
LOCATE 22, 3 + (page * 2)
PRINT page
LOCATE 22, 50
PRINT "Esc to return to main menu"
box 1, 1, 80, 23, 1, 8

help1:
a$ = INKEY$
IF a$ = "" THEN GOTO help1
IF a$ = CHR$(0) + "K" THEN page = page - 1
IF a$ = CHR$(0) + "M" THEN page = page + 1
IF a$ = CHR$(27) THEN  ELSE GOTO pagestart

END SUB

DEFSNG A-Z
SUB prnt (a$, x, y, col)

a$ = UCASE$(a$)
x = x - 5
COLOR col
FOR t = 1 TO LEN(a$)

'*********************
FOR q = 1 TO 5000
NEXT q
'*********************


x = x + 5

SELECT CASE MID$(a$, t, 1)
 CASE "A": PSET (x, y + 5)
 DRAW "u4 e1 r1 f1 d4 u2 l2"
 CASE "B": PSET (x, y)
 DRAW "d5 r2 e1 u1 h1 l1 r1 e1 h1 l1"
 CASE "C": PSET (x + 3, y + 1)
 DRAW "h1 l1 g1 d3 f1 r1 e1"
 CASE "D": PSET (x, y)
 DRAW "r1 d5 l1 r2 e1 u3 h1 l1"
 CASE "E": PSET (x + 3, y)
 DRAW "l3 d2 r2 l2 d3 r3"
 CASE "F": PSET (x + 3, y)
 DRAW "l3 d2 r2 l2 d3"
 CASE "G": PSET (x + 3, y + 1)
 DRAW "h1 l1 g1 d3 f1 r1 e1 u1 l1"
 CASE "H": PSET (x, y)
 DRAW "d5 u3 r3 u2 d5"
 CASE "I": PSET (x, y)
 DRAW "r3 l2 d5 l1 r3"
 CASE "J": PSET (x + 1, y)
 DRAW "r2 l1 d4 g1 h1 u1"
 CASE "K": PSET (x, y)
 DRAW "d5 u3 r1 e2 g2 f2 d1"
 CASE "L": PSET (x, y)
 DRAW "d5 r3"
 CASE "M": PSET (x, y + 5)
 DRAW "u5 f1 r1 d1 l1 r2 u2 d5"
 CASE "N": PSET (x, y + 5)
 DRAW "u5 f1 d1 f1 d1 f1 u5"
 CASE "O": PSET (x, y + 1)
 DRAW "d3 f1 r1 e1 u3 h1 l1"
 CASE "P": PSET (x, y + 5)
 DRAW "u5 r2 f1 g1 l1"
 CASE "Q": PSET (x, y + 1)
 DRAW "d2 r1 g1 f1 r1 u1 r1 u3 h1 l1"
 CASE "R": PSET (x, y + 5)
 DRAW "u2 e1 l1 u2 r2 f1 g1 f1 d2"
 CASE "S": PSET (x + 3, y + 1)
 DRAW "h1 l1 g1 f1 r1 f1 d1 g1 l1 h1"
 CASE "T": PSET (x, y)
 DRAW "r2 l1 d5"
 CASE "U": PSET (x, y)
 DRAW "d5 r3 u5"
 CASE "V": PSET (x, y)
 DRAW "d3 f1 d1 r1 u1 e1 u3"
 CASE "W": PSET (x, y)
 DRAW "d5 e1 u1 r1 d1 f1 u5"
 CASE "X": PSET (x, y)
 DRAW "d1 f1 d1 g1 d1 u1 e1 r1 f1 d1 u1 h1 u1 e1 u1"
 CASE "Y": PSET (x, y)
 DRAW "d1 f1 d3 r1 u3 e1 u1"
 CASE "Z": PSET (x, y)
 DRAW "r3 d1 g3 d1 r3"
 CASE "0": PSET (x, y + 1)
 DRAW "d2 r1 g1 r1 d1 r1 e1 u2 l1 u1 r1 h1 l1"
 CASE "1": PSET (x, y + 1)
 DRAW "e1 d5 l1 r3"
 CASE "2": PSET (x, y)
 DRAW "r3 d2 l3 d3 r3 u1"
 CASE "3": PSET (x, y)
 DRAW "r2 f1 g1 l2 r2 f1 d1 g1 l2"
 CASE "4": PSET (x + 3, y + 3)
 DRAW "l3 u1 e2 d5"
 CASE "5": PSET (x + 3, y)
 DRAW "l3 d2 r3 d3 l3"
 CASE "6": PSET (x + 3, y)
 DRAW "l2 g1 d3 f1 r1 e1 u1 h1 l1"
 CASE "7": PSET (x, y)
 DRAW "r3 d2 g3"
 CASE "8": PSET (x, y + 1)
 DRAW "e1 r1 f1 g1 l1 g1 d1 f1 r1 e1 u1"
 CASE "9": PSET (x, y + 5)
 DRAW "r3 u5 l3 d2 r2"
 CASE "%": PSET (x, y)
 PSET (x, y + 1)
 PSET (x, y + 5)
 DRAW "e1 u1 e1 u1 e1"
 PSET (x + 3, y + 5)
 PSET (x + 3, y + 4)
 CASE ".": PSET (x + 1, y + 5)
 CASE "?": PSET (x + 3, y + 5)
 PSET (x + 3, y + 3)
 DRAW "e1 u1 h1 l1 g1 d1"
 CASE ",": PSET (x + 1, y + 5)
 PSET (x, y + 6)
 PSET (x + 1, y + 4)
 CASE "!": PSET (x + 2, y)
 DRAW "d3"
 PSET (x + 2, y + 5)
 CASE "-": LINE (x + 1, y + 2)-(x + 3, y + 2)
END SELECT
NEXT t


END SUB

FUNCTION question
'open a box in center
FOR t = 0 TO 70
LINE (320 - t, 200 - t)-(320 + t, 200 + t), 0, BF
LINE (320 - (t + 1), 200 - (t + 1))-(320 + (t + 1), 200 + (t + 1)), 7, B
LINE (320 - (t + 2), 200 - (t + 2))-(320 + (t + 2), 200 + (t + 2)), 15, B
LINE (320 - (t + 3), 200 - (t + 3))-(320 + (t + 3), 200 + (t + 3)), 7, B
NEXT t


prnt "really quit?", 290, 200, 15

a$ = UCASE$(INPUT$(1))
IF a$ = "Y" THEN question = 1 ELSE question = 0

END FUNCTION

FUNCTION runfire (plyr)


'Find initial conditions

player(plyr).x = player(plyr).xpos
player(plyr).y = player(plyr).ypos + 8
player(plyr).z = player(plyr).zpos
 
player(plyr).vx = COS((-player(plyr).yaw + player(plyr).ang) * (3.14159 / 180)) * COS(player(plyr).pitch * (3.14159 / 180)) * player(plyr).power / 100
player(plyr).vy = SIN(player(plyr).pitch * (3.14159 / 180)) * player(plyr).power / 100
player(plyr).vz = -SIN((-player(plyr).yaw + player(plyr).ang) * (3.14159 / 180)) * COS(player(plyr).pitch * (3.14159 / 180)) * player(plyr).power / 100

flag = 0
dead = 0
IF plyr = 1 THEN pp = 1 ELSE pp = -1

count = 0

DO

    '****************************************************************
    '****************************************************************
   
    ' Adjust this FOR...NEXT delay loop to a value suitable for
    ' your computer.  The number may be as high as 30,000 or more

        FOR q = 1 TO 1000
        NEXT q

    ' Keep trying different values.  This loop controls the speed
    ' that the projectile flies through the air.  The larger the
    ' value, the more the delay.  The number is high for faster
    ' computers.

    '****************************************************************
    '****************************************************************
   

    count = count + 1
    ' Simulate gravity on y velocity
    player(plyr).vy = player(plyr).vy - (.01 * player(plyr).grav)

    ' Delete old points

    IF POINT(player(plyr).x, player(plyr).z) = 14 THEN
      PSET (player(plyr).x, player(plyr).z), 6
      IF count > 5 THEN PSET (player(plyr).x, player(plyr).z), 7
    END IF

    IF POINT(player(plyr).x, 450 - player(plyr).y) = 14 THEN
      IF player(plyr).y < 248 THEN
      PSET (player(plyr).x, 450 - player(plyr).y), 1
      IF count > 5 THEN PSET (player(plyr).x, 450 - player(plyr).y), 7
      END IF
    END IF

    IF count > 5 THEN count = 0


    ' Add vectors to the coordinates

    player(plyr).x = player(plyr).x + player(plyr).vx + player(plyr).windx
    player(plyr).y = player(plyr).y + player(plyr).vy
    player(plyr).z = player(plyr).z + player(plyr).vz + player(plyr).windz
   
    ' Display bomb

    IF POINT(player(plyr).x, player(plyr).z) = 6 THEN
      PSET (player(plyr).x, player(plyr).z), 14
    END IF

    IF POINT(player(plyr).x, 450 - player(plyr).y) = 1 THEN
      IF player(plyr).y < 248 THEN
        PSET (player(plyr).x, 450 - player(plyr).y), 14
      END IF
    END IF

    IF player(plyr).y <= 0 THEN flag = 1
    IF player(plyr).z < 0 THEN flag = 2
    IF player(plyr).z > 198 THEN flag = 2
   
    IF ABS(player(plyr).y - player(plyr + pp).ypos) < 5 THEN
      IF ABS(player(plyr).x - player(plyr + pp).xpos) < 3.5 THEN
        IF ABS(player(plyr).z - player(plyr + pp).zpos) < 5 THEN
          dead = plyr + pp
          runfire = plyr + pp
          flag = 1
        END IF
      END IF
    END IF
    


LOOP UNTIL flag


' Draw the landing location indicators

IF dead = 0 THEN

LINE (player(plyr).x, player(plyr).z - 30)-(player(plyr).x, player(plyr).z + 30), 10
IF flag <> 2 THEN LINE (player(plyr).x, 449)-(player(plyr).x, 400), 10
LINE (player(plyr).x - 30, player(plyr).z)-(player(plyr).x + 30, player(plyr).z), 10

IF player(plyr).z < player(plyr + pp).zpos THEN drawplayer plyr + pp

IF plyr = 1 THEN prnt "press a key, player 1", 150, 300, 15
IF plyr = 2 THEN prnt "press a key, player 2", 390, 300, 15



fire1:
a$ = UCASE$(INKEY$)

IF plyr = 1 THEN
 IF a$ = "Q" THEN GOTO fire2
 IF a$ = "W" THEN GOTO fire2
 IF a$ = "A" THEN GOTO fire2
 IF a$ = "S" THEN GOTO fire2

 IF a$ = "Z" THEN GOTO fire2
 IF a$ = "X" THEN GOTO fire2 ELSE GOTO fire1
END IF
IF plyr = 2 THEN
 IF a$ = "O" THEN GOTO fire2
 IF a$ = "P" THEN GOTO fire2
 IF a$ = "L" THEN GOTO fire2
 IF a$ = ";" THEN GOTO fire2
 IF a$ = "." THEN GOTO fire2
 IF a$ = "/" THEN GOTO fire2 ELSE GOTO fire1
END IF

END IF

fire2:

IF dead = 0 THEN drawscreen



END FUNCTION

SUB setup

SCREEN 12
CLS


RANDOMIZE TIMER

player(1).xpos = CINT(RND * 180) + 20
player(1).ypos = CINT(RND * 60) + 10
player(1).zpos = CINT(RND * 180) + 10
player(1).ang = CINT(RND * 359)

player(2).xpos = CINT(RND * 180) + 460
player(2).ypos = CINT(RND * 60) + 10
player(2).zpos = CINT(RND * 180) + 10
player(2).ang = CINT(RND * 359)


'player(1).xpos = 50
'player(1).ypos = 10
'player(1).zpos = 50
'player(1).ang = 0
'player(2).xpos = 500
'player(2).ypos = 20
'player(2).zpos = 70
'player(2).ang = 0



player(1).yaw = 0
player(1).pitch = 0
player(1).power = 100

player(2).yaw = 0
player(2).pitch = 0
player(2).power = 100

player(1).windz = (RND * .4) - .2
player(1).windx = (RND * .4) - .2
player(1).grav = (RND * .2) + .9

player(2).windz = player(1).windz
player(2).windx = player(1).windx
player(2).grav = player(1).grav


drawscreen

END SUB

