'BATTLE.BAS
'prototype 0.60

DEFINT A-Z

'---INCLUDES---

'$INCLUDE: 'dash.bi'
'$INCLUDE: 'bwsb.bi'
'$INCLUDE: 'gdmtype.bi'
'$INCLUDE: 'gslib.bi'
'$DYNAMIC

'---DECLARATIONS---

DECLARE SUB WaitOnetime ()
DECLARE SUB waitforit ()
DECLARE SUB PlaceMonsters (monchar%, monatk%)
DECLARE SUB LoadBackground ()
DECLARE SUB UpdateScreen ()
DECLARE SUB useitem (charwithitem%, chartogetitem%, itemtype%)
DECLARE SUB DeceptorSplit ()
DECLARE SUB checkkeys ()
DECLARE SUB doitem (whichchar%)
DECLARE SUB SaveScreen ()
DECLARE SUB TextBox ()
DECLARE SUB SoundEffect (whatsound%)
DECLARE SUB runaway ()
DECLARE SUB FadeVolumeOut ()
DECLARE SUB DelayFrame (thetime%)
DECLARE SUB buggeredout (errornumber%)
DECLARE SUB molotov (whichchar%, whichmons%)
DECLARE SUB sandstorm (whichchar%)
DECLARE SUB ripple ()
DECLARE SUB throwshuriken (whichchar%, whichmons%)
DECLARE SUB RestoreBackground ()
DECLARE SUB StoreBackground ()
DECLARE SUB Buffer1toBuffer2 ()
DECLARE SUB Buffer2toBuffer1 ()
DECLARE SUB UpdateCharStats ()
DECLARE SUB ShowMeTheMusic (file1$)
DECLARE SUB calculatelevel (theperson%)
DECLARE SUB loadmonsters ()
DECLARE SUB loadstatistics ()
DECLARE SUB getthevmfile ()
DECLARE SUB DeterminePositions ()
DECLARE SUB savestats ()
DECLARE SUB sortitout ()
DECLARE SUB nowayhereman ()
DECLARE SUB yesorno ()
DECLARE SUB VSBlendPalettes (file1$, file2$)
DECLARE SUB firebolt (whichchar%, whichmons%)
DECLARE SUB getcharactions ()
DECLARE SUB logiclord (whichchar%)
DECLARE SUB litening2 (whichchar%, whichmons%)
DECLARE SUB litening1 (whichchar%, whichmons%)
DECLARE SUB selectbaddy (whowho%)
DECLARE SUB makefunnyboxes ()
DECLARE SUB choosespell (whichchar%)
DECLARE SUB snowstorm (whichchar%)
DECLARE SUB buzzsaw (whichchar%)
DECLARE SUB disrupt (whichchar%)
DECLARE SUB setvm (answer%)
DECLARE SUB partydied ()

'---GLOBALS---

COMMON SHARED actions() AS INTEGER, against() AS INTEGER, usinga() AS INTEGER, initiative() AS INTEGER
COMMON SHARED MODfile AS STRING, backgroundimage AS STRING
COMMON SHARED monster AS INTEGER, monsterfile AS STRING, setevent AS INTEGER
COMMON SHARED monsteroffset AS INTEGER, MusicChannels AS INTEGER
COMMON SHARED bubble AS INTEGER, dubble AS INTEGER, dubble2 AS INTEGER
COMMON SHARED iconoffset AS INTEGER, optionoffset AS INTEGER
COMMON SHARED moolah AS LONG, pmx AS INTEGER, pmy AS INTEGER
COMMON SHARED map AS STRING, nstat() AS INTEGER, nbig() AS LONG
COMMON SHARED nst() AS STRING, spl() AS INTEGER, evnt() AS INTEGER
COMMON SHARED monstersprite() AS STRING, monstery AS INTEGER, monsterx() AS INTEGER
COMMON SHARED monsterstat() AS INTEGER
COMMON SHARED attackoptions()     AS INTEGER
COMMON SHARED attackicons()     AS INTEGER
COMMON SHARED monstergfx()     AS INTEGER
COMMON SHARED playergfx()      AS INTEGER
COMMON SHARED equipment() AS INTEGER
COMMON SHARED detectedsound AS INTEGER
COMMON SHARED buffer1() AS INTEGER, buffer2() AS INTEGER
COMMON SHARED paldata AS STRING * 768
COMMON SHARED typers AS INTEGER
COMMON SHARED items() AS INTEGER
COMMON SHARED skills() AS INTEGER

'---TYPES---

TYPE MSEConfigFile
  SoundCard     AS INTEGER
  BaseIO        AS INTEGER
  IRQ           AS INTEGER
  DMA           AS INTEGER
  SoundQuality  AS INTEGER
END TYPE

SCREEN 13

'---ARRAYS AND SETUP OF SOUND ENGINE---

DIM SHARED ModHead         AS GDMHeader
DIM SHARED SndDevMSE(6)    AS STRING
DIM SHARED MSEConfig       AS MSEConfigFile
Freemem& = FRE(-1) - 250000 'WOS requires a TON of memory!
a& = SETMEM(-Freemem&)
SndDevMSE(1) = "DRIVERS\GUS"
SndDevMSE(2) = "DRIVERS\SB1X"
SndDevMSE(3) = "DRIVERS\SB2X"
SndDevMSE(4) = "DRIVERS\SBPRO"
SndDevMSE(5) = "DRIVERS\SB16"
SndDevMSE(6) = "DRIVERS\PAS"
OPEN "MSE.CFG" FOR BINARY AS 1
IF LOF(1) = 0 THEN
	CLOSE 1
	KILL "mse.cfg"
	buggeredout 22
END IF
GET 1, , MSEConfig
CLOSE 1
IF MSEConfig.SoundCard = 0 THEN detectedsound = 0: GOTO argit
detectedsound = 1
MSE$ = SndDevMSE(MSEConfig.SoundCard) + ".MSE"
SELECT CASE MSEConfig.SoundQuality
CASE 0: Ov = 16
CASE 1: Ov = 22
CASE 2: Ov = 45
CASE 3: Ov = 8
CASE ELSE: Ov = 16
END SELECT
ErrorFlag = LoadMSE(MSE$, 0, Ov, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)
SELECT CASE ErrorFlag
CASE 0
CASE 1 TO 12: buggeredout ErrorFlag
CASE ELSE: buggeredout 99
END SELECT
argit:
DIM SHARED actions(8) AS INTEGER, against(8) AS INTEGER, usinga(8) AS INTEGER
DIM SHARED nstat(4, 33) AS INTEGER, nbig(4, 2) AS LONG
DIM SHARED nst(4, 7) AS STRING, spl(4, 20) AS INTEGER, evnt(500) AS INTEGER
DIM SHARED monstername(4) AS STRING, monstersprite(4) AS STRING, monsterx(4) AS INTEGER
DIM SHARED monsterstat(4, 15) AS INTEGER, initiative(8) AS INTEGER
DIM SHARED crazy(8) AS INTEGER
DIM SHARED equipment(4, 9) AS INTEGER
DIM SHARED attackoptions(3084) AS INTEGER
DIM SHARED attackicons(1284) AS INTEGER
DIM SHARED monstergfx(6150) AS INTEGER
DIM SHARED playergfx(10250) AS INTEGER
DIM SHARED buffer1(31999) AS INTEGER, buffer2(31999) AS INTEGER
DIM SHARED items(9) AS INTEGER
DIM SHARED emptybox(19) AS INTEGER, filledbox(19) AS INTEGER
DIM SHARED soundtoplay(4) AS INTEGER
DIM SHARED skills(4, 5) AS INTEGER

'---VARIABLES---

optionoffset = 514
iconoffset = 642
monsteroffset = 2050

'---INITIALIZATION---

RANDOMIZE TIMER
loadstatistics
getthevmfile
loadmonsters
DeterminePositions
monstery = 10

DEF SEG = VARSEG(attackoptions(0)): BLOAD "SPRITES\BATLOPTN.PUT", VARPTR(attackoptions(0))
DEF SEG = VARSEG(attackicons(0)): BLOAD "SPRITES\BATLICON.PUT", VARPTR(attackicons(0))
DEF SEG

IF detectedsound = 1 THEN
	ShowMeTheMusic MODfile
	StartMusic
END IF

LoadBackground
VSSavePalette "DATA\BATTLE"
PlaceMonsters 0, 0
UpdateScreen

'*Loop, ask each character about their action*
startbattle:

'**********************************************************
'*** CHANGE THIS TO USE POWER INSTEAD OF NAME DAMMIT!!! ***
'**********************************************************
IF monstername(1) = "Deceptor" THEN DeceptorSplit
'**********************************************************
'**********************************************************
'**********************************************************

FOR a = 1 TO 8
actions(a) = 0: usinga(a) = 0: against(a) = 0
NEXT a
getcharactions
PlaceMonsters 0, 0
UpdateScreen

'*Do the same for the monsters*
FOR selection = 1 TO monster
IF monsterstat(selection, 1) < 1 THEN actions(selection + 4) = 0: GOTO nomonster
determinetarget:
whotokill = INT(RND(1) * 4) + 1
IF nstat(whotokill, 1) < 1 THEN GOTO determinetarget
Slot = selection + 4: actions(Slot) = 1
against(Slot) = whotokill
nomonster:
NEXT selection

sortitout
FOR ddd = 1 TO 8
dubble = initiative(ddd)
IF dubble = 0 THEN GOTO doitnow
IF dubble > 4 THEN GOTO showbaddy
'is character able to attack still?
IF nstat(dubble, 1) < 1 THEN GOTO doitnow
IF actions(initiative(ddd)) = 6 AND typers = 0 THEN
	runaway
	GOTO yipeeskippy
END IF
IF actions(dubble) = 6 AND typers > 0 THEN
	TextBox
	PRINT "No escape."
	waitforit
	GOTO doitnow
END IF
IF actions(dubble) = 3 THEN
	useitem dubble, against(dubble), usinga(dubble)
	GOTO doitnow
END IF

IF actions(dubble) = 2 THEN
	logiclord dubble
	'against(dubble) = INT(RND(1) * 4) + 1
	ettect = usinga(dubble)
	IF ettect = 4 THEN disrupt dubble
	IF ettect = 34 THEN litening1 dubble, against(dubble)
	IF ettect = 35 THEN litening2 dubble, against(dubble)
	IF ettect = 33 THEN molotov dubble, against(dubble)
	IF ettect = 3 THEN sandstorm dubble
	IF ettect = 31 THEN throwshuriken dubble, against(dubble)
	IF ettect = 1 THEN buzzsaw dubble
	IF ettect = 2 THEN snowstorm dubble
	IF ettect = 32 THEN firebolt dubble, against(dubble)
	GOTO checkformonsterdeath
END IF
'calculate base attacking power
attackpower = nstat(dubble, 5) + nstat(dubble, 11) + nstat(dubble, 17) + nstat(dubble, 21) + nstat(dubble, 25) + nstat(dubble, 29)
'randomize weapon modifier based upon listed modifier
modifier = INT(RND(1) * nstat(dubble, 12)) + 1
'calculate total attack number
finalattack = attackpower + modifier
'calculate enemy defence
enemydfc = monsterstat(against(dubble), 4) + monsterstat(against(dubble), 12)
'calculate attack
result = finalattack - enemydfc
'balance if needed
IF result < 1 THEN result = INT(RND(1) * 4)
'display result of attack
argg$ = STR$(nstat(dubble, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
FOR shithead = 2 TO 4
PlaceMonsters 0, 0
VSSprite VARSEG(playergfx(shithead * monsteroffset)), VARPTR(playergfx(shithead * monsteroffset)), monsterx(against(dubble)), (monstery + 20), VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
IF shithead = 4 AND result > 0 AND monsterstat(against(dubble), 1) <> 0 THEN SoundEffect 7
checkkeys
VSDelay 10
NEXT shithead
VSDelay 30
checkkeys

IF monsterstat(against(dubble), 1) = 0 THEN
	VSFont &HA000, 0, monsterx(against(dubble)), 10, "Nothing", 31, 28
	VSDelay 30
	checkkeys
	GOTO doitnow
END IF
IF result = 0 THEN
	VSFont &HA000, 0, monsterx(against(dubble)), 10, "MISS", 31, 28
	VSDelay 30
	checkkeys
	ELSE
		rr$ = STR$(result)
		VSFont &HA000, 0, monsterx(against(dubble)), 10, rr$, 31, 28
		VSDelay 30
		checkkeys
END IF

'calculate damage effect
monsterstat(against(dubble), 1) = monsterstat(against(dubble), 1) - result
IF monsterstat(against(dubble), 1) < 1 THEN
	monsterstat(against(dubble), 1) = 0
	VSDelay 30
	PlaceMonsters 0, 0
	UpdateCharStats
	UpdateScreen
	checkkeys
END IF
'are all the monsters dead yet?
checkformonsterdeath:
IF monsterstat(1, 1) = 0 AND monsterstat(2, 1) = 0 AND monsterstat(3, 1) = 0 AND monsterstat(4, 1) = 0 THEN GOTO baddyzdied
GOTO doitnow
showbaddy:
dubble2 = dubble - 4
'is monster still able to attack?
IF monsterstat(dubble2, 1) < 1 THEN GOTO doitnow
attackpower = monsterstat(dubble2, 11) + monsterstat(dubble2, 2)
modifier = INT(RND(1) * monsterstat(dubble2, 3)) + 1
finalattack = attackpower + modifier
dfc = nstat(against(dubble), 6) + nstat(against(dubble), 13) + nstat(against(dubble), 16)
dfc = dfc + nstat(against(dubble), 20) + nstat(against(dubble), 24) + nstat(against(dubble), 30)
result = finalattack - dfc
IF result < 1 THEN result = INT(RND(1) * 4)
IF nstat(against(dubble), 1) < 1 THEN GOTO doitnow
argg$ = STR$(nstat(against(dubble), 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE against(dubble)
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
FOR B = 1 TO 2
VSDelay 20
PlaceMonsters dubble2, B
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
checkkeys
NEXT B
IF result = 0 THEN
	VSFont &HA000, 0, placers, 100, "MISS", 31, 28
	VSDelay 30
	checkkeys
	ELSE
		rr$ = STR$(result)
		VSFont &HA000, 0, placers, 100, rr$, 31, 28
		SoundEffect soundtoplay(dubble2)
		VSDelay 30
		checkkeys
END IF
nstat(against(dubble), 1) = nstat(against(dubble), 1) - result
IF nstat(against(dubble), 1) < 1 THEN
	nstat(against(dubble), 1) = 0
	VSDelay 30
	PlaceMonsters 0, 0
	UpdateCharStats
	UpdateScreen
	TextBox
	LOCATE 11, 1
	PRINT nst(against(dubble), 1); " defeated!"
	WaitOnetime
END IF
'are all the players dead yet?
IF nstat(1, 1) = 0 AND nstat(2, 1) = 0 AND nstat(3, 1) = 0 AND nstat(4, 1) = 0 THEN partydied
VSDelay 30
doitnow:
checkkeys
NEXT
GOTO startbattle

baddyzdied:
Buffer2toBuffer1
UpdateScreen
TextBox
LOCATE 11, 1
PRINT "Victory is yours!"
xpvalue = monsterstat(1, 9) + monsterstat(2, 9) + monsterstat(3, 9) + monsterstat(4, 9)
survivors = 0
IF nstat(1, 1) > 0 THEN survivors = survivors + 1
IF nstat(2, 1) > 0 THEN survivors = survivors + 1
IF nstat(3, 1) > 0 THEN survivors = survivors + 1
IF nstat(4, 1) > 0 THEN survivors = survivors + 1
xpaward = INT(xpvalue / survivors)
PRINT "XP to each character:"; xpaward
moneyearned = monsterstat(1, 10) + monsterstat(2, 10) + monsterstat(3, 10) + monsterstat(4, 10)
moneyearned = INT(RND(1) * moneyearned) + 1
PRINT "Moolah earned:"; moneyearned
moolah = moolah + moneyearned: IF moolah > 999999 THEN moolah = 999999
waitforit
FOR duhh = 1 TO 4
IF nstat(duhh, 1) < 1 THEN GOTO noxpforyou
nbig(duhh, 1) = nbig(duhh, 1) + xpaward
IF nbig(duhh, 1) >= nbig(duhh, 2) THEN
	PRINT nst(duhh, 1); " level up": waitforit
	calculatelevel duhh
END IF
noxpforyou:
NEXT duhh
yipeeskippy:
gspcopy VARSEG(buffer2(0)), VARPTR(buffer2(0)), &HA000, 0
IF detectedsound = 1 THEN
	FadeVolumeOut
	StopMusic
	StopOutput
	UnloadModule
	FreeMSE
END IF
setvm 1
IF setevent = 23 AND monsterstat(1, 1) < 1 THEN setvm 2
savestats
VSFadeBlack 64
CLEAR
RUN "WRATH.EXE"

REM $STATIC
SUB balloflightning (character1, character2)
'This is an Astral Mutation!!!
liteoffset = 1422
DIM litening(5688) AS INTEGER
DIM ballz(5001) AS INTEGER
DEF SEG = VARSEG(litening(0)): BLOAD "SPRITES\BLULITNG.PUT", VARPTR(litening(0)): DEF SEG
DIM l1x(20) AS INTEGER
DIM l2x(20) AS INTEGER

StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(character1, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), 88, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
argg$ = STR$(nstat(character2, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), 168, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "ASTRAL MUTATION"
PRINT "BALL OF LIGHTNING"
WaitOnetime
WaitOnetime
WaitOnetime
checkkeys
Buffer2toBuffer1
argg$ = STR$(nstat(character1, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), 88, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
argg$ = STR$(nstat(character2, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), 168, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
SoundEffect 2
VSBlendPalettes "DATA\BATTLE", "PALETTES\SANDSTRM"
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"
VSBlendPalettes "DATA\BATTLE", "PALETTES\NOBACK"
rotator = 0
FOR aa = 1 TO 100
Buffer2toBuffer1
VSNegative
FOR dyke1 = 1 TO 20
l1x(dyke1) = INT(RND(1) * 400) - 40
l2x(dyke1) = INT(RND(1) * 4)
NEXT dyke1
rotator = rotator + 1: IF rotator = 5 THEN rotator = 1
SELECT CASE rotator
CASE 1: DEF SEG = VARSEG(ballz(0)): BLOAD "SPRITES\BALL1.PUT", VARPTR(ballz(0)): DEF SEG
CASE 2: DEF SEG = VARSEG(ballz(0)): BLOAD "SPRITES\BALL2.PUT", VARPTR(ballz(0)): DEF SEG
CASE 3: DEF SEG = VARSEG(ballz(0)): BLOAD "SPRITES\BALL3.PUT", VARPTR(ballz(0)): DEF SEG
CASE 4: DEF SEG = VARSEG(ballz(0)): BLOAD "SPRITES\BALL4.PUT", VARPTR(ballz(0)): DEF SEG
CASE ELSE
END SELECT
SoundEffect 4
FOR B = 1 TO 20
VSSprite VARSEG(litening(liteoffset * l2x(B))), VARPTR(litening(liteoffset * l2x(B))), (monsterx(whichmons) + l1x(B)), 0, VARSEG(buffer1(0)), VARPTR(buffer1(0))
NEXT B
VSSprite VARSEG(ballz(0)), VARPTR(ballz(0)), 110, 20, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
NEXT aa
RestoreBackground
Buffer2toBuffer1
PlaceMonsters 0, 0
UpdateScreen
VSBlendPalettes "PALETTES\NOBACK", "DATA\BATTLE"

'calculate damage effects here!
FOR baddydude = 1 TO 4
IF monsterstat(baddydude, 1) < 1 THEN GOTO nobuzzformehee
damage = INT(RND(1) * 1000) + 1000
chances = INT(RND(1) * 100) + 1
IF monsterstat(baddydude, 6) > chances THEN damage = INT(damage * .5)
rr$ = STR$(damage)
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), monsterx(baddydude), 10, rr$, 31, 28
monsterstat(baddydude, 1) = monsterstat(baddydude, 1) - damage
IF monsterstat(baddydude, 1) < 1 THEN monsterstat(baddydude, 1) = 0
nobuzzformehee:
NEXT
UpdateScreen
VSDelay 75
checkkeys
nstat(character1, 3) = nstat(character1, 3) - 5
nstat(character1, 3) = nstat(character1, 3) - 5

END SUB

SUB buzzsaw (whichchar)
DIM starz(8205) AS INTEGER
DEF SEG = VARSEG(starz(0)): BLOAD "SPRITES\BUZZSAW.PUT", VARPTR(starz(0)): DEF SEG
staroffset = monsteroffset
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "BUZZSAW"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
rotater = 0
FOR travel = -50 TO 330 STEP 5
Buffer2toBuffer1
VSSprite VARSEG(starz(rotater * staroffset)), VARPTR(starz(rotater * staroffset)), travel, monstery + 20, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
SoundEffect 7
VSDelay 1
checkkeys
rotater = rotater + 1: IF rotater = 4 THEN rotater = 0
NEXT travel
RestoreBackground
'calculate damage effects here!
FOR baddydude = 1 TO 4
IF monsterstat(baddydude, 1) < 1 THEN GOTO nobuzzforme
damage = INT(RND(1) * 50) + 50
chances = INT(RND(1) * 100) + 1
IF monsterstat(baddydude, 6) > chances THEN damage = INT(damage * .5)
rr$ = STR$(damage)
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), monsterx(baddydude), 10, rr$, 31, 28
monsterstat(baddydude, 1) = monsterstat(baddydude, 1) - damage
IF monsterstat(baddydude, 1) < 1 THEN monsterstat(baddydude, 1) = 0
nobuzzforme:
NEXT
UpdateScreen
VSDelay 75
checkkeys
nstat(whichchar, 3) = nstat(whichchar, 3) - 10
END SUB

REM $DYNAMIC
SUB calculatelevel (theperson%)
IF nstat(theperson, 28) = 50 THEN EXIT SUB 'if level=50 then exit
nstat(theperson, 28) = nstat(theperson, 28) + 1 'increase the level number
yipee = INT(RND(1) * 100) + 1 'determine strong or weak
IF yipee > 50 THEN stronglevel = 1 ELSE stronglevel = 0
vv = FREEFILE
OPEN "DATA\LEVELS.DAT" FOR INPUT AS #vv
woohoo:
INPUT #vv, dodo
IF theperson <> dodo THEN
	FOR frigg = 1 TO 31
	INPUT #vv, dodo
	NEXT frigg
	GOTO woohoo
END IF
FOR frigg = 1 TO 7: INPUT #vv, dodo: NEXT frigg'bypass startup stats!
IF stronglevel = 0 THEN 'if level-up is WEAK, bypass STRONG settings
	FOR frigg = 1 TO 12
	INPUT #vv, dodo
	NEXT frigg
END IF
INPUT #vv, hpincrease
hpincrease = INT(RND(1) * hpincrease) + 1
nstat(theperson, 2) = nstat(theperson, 2) + hpincrease
nstat(theperson, 1) = nstat(theperson, 1) + hpincrease
PRINT "HP increased"; hpincrease
INPUT #vv, mpincrease
mpincrease = INT(RND(1) * mpincrease) + 1
nstat(theperson, 3) = nstat(theperson, 3) + mpincrease
nstat(theperson, 4) = nstat(theperson, 4) + mpincrease
PRINT "MP increased"; mpincrease: waitforit
FOR earned = 1 TO 5
  INPUT #vv, attp, attv
  percent = INT(RND(1) * 100) + 1
  IF attp > percent THEN
	increase = INT(RND(1) * attv) + 1
	SELECT CASE earned
		CASE 1
			PRINT "Attack power up"; increase
			nstat(theperson, 5) = nstat(theperson, 5) + increase
			waitforit
		CASE 2
			PRINT "Defence power up"; increase
			nstat(theperson, 6) = nstat(theperson, 6) + increase
			waitforit
		CASE 3
			PRINT "Resist power up"; increase
			nstat(theperson, 7) = nstat(theperson, 7) + increase
			waitforit
		CASE 4
			PRINT "Agility power up"; increase
			nstat(theperson, 8) = nstat(theperson, 8) + increase
			waitforit
		CASE 5
			PRINT "Magic power up"; increase
			nstat(theperson, 9) = nstat(theperson, 9) + increase
			waitforit
		CASE ELSE
	END SELECT
  END IF
NEXT earned
CLOSE vv
OPEN "DATA\XPCHART.DAT" FOR INPUT AS #vv
bugg:
INPUT #vv, pot1%, pot2&
IF nstat(theperson, 28) <> pot1% THEN GOTO bugg
nbig(theperson, 2) = pot2&
CLOSE vv
END SUB

REM $STATIC
SUB checkkeys
a$ = INKEY$
IF a$ = "~" THEN SaveScreen

END SUB

SUB choosespell (whichchar)
'Draw textbox to hold list
LINE (0, 143)-(319, 199), 28, B
LINE (1, 144)-(318, 198), 29, B
LINE (2, 145)-(317, 197), 30, B
LINE (3, 146)-(316, 196), 31, B
LINE (4, 147)-(315, 195), 30, B
LINE (5, 148)-(314, 194), 29, B
LINE (6, 149)-(313, 193), 28, B
LINE (7, 150)-(312, 192), 0, BF
makefunnyboxes
'Initialize temporary variables and arrays
scursor = 1
spos = 1
REDIM spellist(20) AS STRING
REDIM spellcost(20) AS INTEGER
'Load spells...this is the truest advantage of a dynamic system...
'...but can be a real pain-in-the-ass to do...
FOR a = 1 TO 20
freehandle = FREEFILE
OPEN "DATA\SPELLS.DAT" FOR INPUT AS #freehandle
gotityet:
INPUT #freehandle, spellid, spellist(a), duh, spellcost(a), duh$
IF spellid = spl(whichchar, a) THEN GOTO donereadingspells
GOTO gotityet
donereadingspells:
CLOSE freehandle
NEXT a
'Now, select a spell! (144)
yummyummy:
LINE (16, 150)-(312, 192), 0, BF'this clears the box!
FOR a = 1 TO 5
LOCATE 19 + a, 3
PRINT spellist((a - 1) + spos)
LOCATE 19 + a, 35
PRINT spellcost((a - 1) + spos)
NEXT a
PUT (8, (144 + (scursor * 8))), filledbox, PSET
gettt:
a$ = INKEY$: IF a$ = "" THEN GOTO gettt
SELECT CASE a$
	CASE CHR$(27)
		usinga(whichchar) = 0
		EXIT SUB
	CASE CHR$(0) + CHR$(72)
		IF scursor = 1 AND spos = 1 THEN GOTO gettt
		scursor = scursor - 1
		IF scursor = 0 THEN
			scursor = 1
			spos = spos - 1
		END IF
		makefunnyboxes
		GOTO yummyummy
	CASE CHR$(0) + CHR$(80)
		IF scursor = 5 AND spos = 16 THEN GOTO gettt
		scursor = scursor + 1
		IF scursor = 6 THEN
			scursor = 5
			spos = spos + 1
		END IF
		makefunnyboxes
		GOTO yummyummy
	CASE CHR$(13)
		GOTO spellchosenmaybe
	CASE ELSE
END SELECT
GOTO gettt

'Now, we determine the spell chosen, if its available, and if we have the MP
'to cast it.
spellchosenmaybe:
spellchosen = spos + (scursor - 1)
IF spellist(spellchosen) = "None" THEN GOTO yummyummy
IF nstat(whichchar, 3) < spellcost(spellchosen) THEN GOTO yummyummy

usinga(whichchar) = spl(whichchar, spellchosen)
'neglect the useage of the ESC key in selectbaddy for now...
IF usinga(whichchar) > 30 AND usinga(whichchar) < 61 THEN selectbaddy whichchar
END SUB

SUB DeceptorSplit
IF monsterstat(2, 1) <> 0 OR monsterstat(3, 1) <> 0 THEN EXIT SUB
chance = INT(RND(1) * 100)
IF chance > 40 THEN EXIT SUB
PlaceMonsters 0, 0
UpdateScreen
TextBox
LOCATE 11, 1
PRINT "Deceptor Split"
WaitOnetime
PlaceMonsters 1, 1
UpdateScreen
FOR a = 5 TO 80 STEP 5
PlaceMonsters 1, 1
DEF SEG = VARSEG(monstergfx(0)): BLOAD monstersprite(1), VARPTR(monstergfx(0)): DEF SEG
VSSpriteT VARSEG(monstergfx(1 * monsteroffset)), VARPTR(monstergfx(1 * monsteroffset)), (128 - a), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSpriteT VARSEG(monstergfx(1 * monsteroffset)), VARPTR(monstergfx(1 * monsteroffset)), (128 + a), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
checkkeys
NEXT
monster = 3
monstersprite(2) = monstersprite(1)
monstersprite(3) = monstersprite(1)
FOR bung = 2 TO 3
monsterstat(bung, 1) = 100
monsterstat(bung, 2) = 20
monsterstat(bung, 3) = 10
monsterstat(bung, 4) = 5
monsterstat(bung, 5) = 20
monsterstat(bung, 6) = 60
monsterstat(bung, 7) = 0
monsterstat(bung, 8) = 0
monsterstat(bung, 9) = 0
monsterstat(bung, 10) = 25
NEXT
monsterstat(1, 9) = monsterstat(1, 9) + 10
monsterx(3) = 48
monsterx(2) = 208

END SUB

SUB DeterminePositions
'Obviously, this determines monster positions
'a little precalculation was necessary here...
FOR bb = 1 TO 4: monsterx(bb) = 0: NEXT
SELECT CASE monster
	CASE 1
		monsterx(1) = 128
	CASE 2
		monsterx(1) = 88
		monsterx(2) = 168
	CASE 3
		monsterx(1) = 48
		monsterx(2) = 128
		monsterx(3) = 208
	CASE 4
		monsterx(1) = 8
		monsterx(2) = 88
		monsterx(3) = 168
		monsterx(4) = 248
	CASE ELSE
END SELECT
END SUB

SUB disrupt (whichchar)
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "DISRUPTER"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
VSBlendPalettes "DATA\BATTLE", "PALETTES\FIRE"
'disrupt effect!
DIM capture(165) AS INTEGER
DIM endpiece(10) AS INTEGER
SoundEffect 2
FOR bung = 1 TO 64
VSNegative
FOR a = 0 TO 158 STEP 2
GET (0, a)-(4, a), endpiece
GET (5, a)-(319, a), capture
PUT (0, a), capture, PSET
PUT (315, a), endpiece, PSET
NEXT a
FOR a = 1 TO 159 STEP 2
GET (315, a)-(319, a), endpiece
GET (0, a)-(314, a), capture
PUT (0, a), endpiece, PSET
PUT (5, a), capture, PSET
NEXT a
NEXT bung
PlaceMonsters 0, 0
UpdateScreen
VSBlendPalettes "PALETTES\FIRE", "DATA\BATTLE"
RestoreBackground
'calculate damage effects here!
FOR baddydude = 1 TO 4
IF monsterstat(baddydude, 1) < 1 THEN GOTO nodisforme
damage = INT(RND(1) * 50) + 50
chances = INT(RND(1) * 100) + 1
IF monsterstat(baddydude, 6) > chances THEN damage = INT(damage * .5)
rr$ = STR$(damage)
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), monsterx(baddydude), 10, rr$, 31, 28
monsterstat(baddydude, 1) = monsterstat(baddydude, 1) - damage
IF monsterstat(baddydude, 1) < 1 THEN monsterstat(baddydude, 1) = 0
nodisforme:
NEXT
UpdateScreen
VSDelay 75
checkkeys
nstat(whichchar, 3) = nstat(whichchar, 3) - 10
END SUB

SUB doitem (whichchar)
LINE (0, 143)-(319, 199), 28, B
LINE (1, 144)-(318, 198), 29, B
LINE (2, 145)-(317, 197), 30, B
LINE (3, 146)-(316, 196), 31, B
LINE (4, 147)-(315, 195), 30, B
LINE (5, 148)-(314, 194), 29, B
LINE (6, 149)-(313, 193), 28, B
LINE (7, 150)-(312, 192), 0, BF
PUT (8, 152), emptybox, PSET
IF items(1) > 0 THEN VSFont &HA000, 0, 16, 152, "Yakuso", 31, 20
PUT (160, 152), emptybox, PSET
IF items(2) > 0 THEN VSFont &HA000, 0, 168, 152, "Ippuku", 31, 20
PUT (8, 160), emptybox, PSET
IF items(3) > 0 THEN VSFont &HA000, 0, 16, 160, "Renkinyakueki", 31, 20
PUT (160, 160), emptybox, PSET
IF items(4) > 0 THEN VSFont &HA000, 0, 168, 160, "Koryo", 31, 20
PUT (8, 168), emptybox, PSET
IF items(5) > 0 THEN VSFont &HA000, 0, 16, 168, "Kaori", 31, 20
PUT (160, 168), emptybox, PSET
IF items(6) > 0 THEN VSFont &HA000, 0, 168, 168, "Eteru", 31, 20
PUT (8, 176), emptybox, PSET
IF items(7) > 0 THEN VSFont &HA000, 0, 16, 176, "Gedokuzai", 31, 20
PUT (160, 176), emptybox, PSET
IF items(8) > 0 THEN VSFont &HA000, 0, 168, 176, "Hogosha", 31, 20
PUT (8, 184), emptybox, PSET
IF items(9) > 0 THEN VSFont &HA000, 0, 16, 184, "Tembatsu", 31, 20
PUT (160, 184), emptybox, PSET
VSFont &HA000, 0, 168, 184, "Cancel", 63, 60
choice = 1
DIM choicex(10), choicey(10)
FOR bung = 1 TO 9 STEP 2: choicex(bung) = 8: choicex(bung + 1) = 160: NEXT bung
choicey(1) = 152: choicey(2) = 152
choicey(3) = 160: choicey(4) = 160
choicey(5) = 168: choicey(6) = 168
choicey(7) = 176: choicey(8) = 176
choicey(9) = 184: choicey(10) = 184
GOSUB updatescreen2
thechosenone:
a$ = INKEY$
IF a$ = "" THEN GOTO thechosenone
SELECT CASE a$
	CASE CHR$(0) + CHR$(72)
		GOSUB UpdateScreen
		choice = choice - 2
		IF choice = 0 THEN choice = 10
		IF choice = -1 THEN choice = 9
		GOSUB updatescreen2
	CASE CHR$(0) + CHR$(80)
		GOSUB UpdateScreen
		choice = choice + 2
		IF choice = 11 THEN choice = 1
		IF choice = 12 THEN choice = 2
		GOSUB updatescreen2
	CASE CHR$(0) + CHR$(77)
		GOSUB UpdateScreen
		choice = choice + 1
		IF choice = 11 THEN choice = 1
		GOSUB updatescreen2
	CASE CHR$(0) + CHR$(75)
		GOSUB UpdateScreen
		choice = choice - 1
		IF choice = 0 THEN choice = 10
		GOSUB updatescreen2
	CASE CHR$(13)
		GOTO pickedawinner
	CASE ELSE
END SELECT
GOTO thechosenone

UpdateScreen:
PUT (choicex(choice), choicey(choice)), emptybox, PSET
RETURN
updatescreen2:
PUT (choicex(choice), choicey(choice)), filledbox, PSET
RETURN
updatebox:
SELECT CASE choice
	CASE 1: PUT (8, 152), emptybox, PSET
	CASE 2: PUT (8, 160), emptybox, PSET
	CASE 3: PUT (8, 168), emptybox, PSET
	CASE 4: PUT (8, 176), emptybox, PSET
	CASE ELSE
END SELECT
RETURN
updatebox2:
SELECT CASE choice
	CASE 1: PUT (8, 152), filledbox, PSET
	CASE 2: PUT (8, 160), filledbox, PSET
	CASE 3: PUT (8, 168), filledbox, PSET
	CASE 4: PUT (8, 176), filledbox, PSET
	CASE ELSE
END SELECT
RETURN

pickedawinner:
usinga(whichchar) = choice
IF choice = 10 THEN GOTO nomoves
IF items(choice) < 1 THEN GOTO thechosenone
IF choice = 9 THEN GOTO selectbaddy
LINE (0, 143)-(319, 199), 28, B
LINE (1, 144)-(318, 198), 29, B
LINE (2, 145)-(317, 197), 30, B
LINE (3, 146)-(316, 196), 31, B
LINE (4, 147)-(315, 195), 30, B
LINE (5, 148)-(314, 194), 29, B
LINE (6, 149)-(313, 193), 28, B
LINE (7, 150)-(312, 192), 0, BF
PUT (8, 152), emptybox, PSET
PUT (8, 160), emptybox, PSET
PUT (8, 168), emptybox, PSET
PUT (8, 176), emptybox, PSET
VSFont &HA000, 0, 16, 152, nst(1, 1), 31, 20
VSFont &HA000, 0, 16, 160, nst(2, 1), 31, 20
VSFont &HA000, 0, 16, 168, nst(3, 1), 31, 20
VSFont &HA000, 0, 16, 176, nst(4, 1), 31, 20
choice = 1
GOSUB updatebox2
thechoosingone:
a$ = INKEY$: IF a$ = "" THEN GOTO thechoosingone
SELECT CASE a$
	CASE CHR$(0) + CHR$(72)
		GOSUB updatebox
		choice = choice - 1
		IF choice = 0 THEN choice = 4
		GOSUB updatebox2
	CASE CHR$(0) + CHR$(80)
		GOSUB updatebox
		choice = choice + 1
		IF choice = 5 THEN choice = 1
		GOSUB updatebox2
	CASE CHR$(13)
		GOTO thepriceisrightbob
	CASE ELSE
END SELECT
GOTO thechoosingone

thepriceisrightbob:
against(whichchar) = choice
PlaceMonsters 0, 0
UpdateScreen
EXIT SUB

nomoves:
EXIT SUB

selectbaddy:
askme = 1
argmeister21:
IF monsterstat(askme, 1) = 0 THEN
	askme = askme + 1
	IF askme = 5 THEN askme = 1
	GOTO argmeister21
END IF
PUT (monsterx(askme), monstery), attackicons(0 * iconoffset), XOR
a$ = INKEY$
IF a$ = "" THEN
	PUT (monsterx(askme), monstery), attackicons(0 * iconoffset), XOR
	GOTO argmeister21
END IF
IF a$ = CHR$(0) + CHR$(75) THEN GOTO cursorleft1
IF a$ = CHR$(0) + CHR$(77) THEN GOTO cursorright1
IF a$ = CHR$(13) THEN GOTO enemychosen1
PUT (monsterx(askme), monstery), attackicons(0 * iconoffset), XOR
GOTO argmeister21

cursorleft1:
PUT (monsterx(askme), monstery), attackicons(0 * iconoffset), XOR
askagainl1:
askme = askme - 1
IF askme = 0 THEN askme = 4
IF monsterstat(askme, 1) = 0 THEN GOTO askagainl1
GOTO argmeister21

cursorright1:
PUT (monsterx(askme), monstery), attackicons(0 * iconoffset), XOR
askagainr1:
askme = askme + 1
IF askme = 5 THEN askme = 1
IF monsterstat(askme, 1) = 0 THEN GOTO askagainr1
GOTO argmeister21

enemychosen1:
PUT (monsterx(askme), monstery), attackicons(0 * iconoffset), XOR
against(whichchar) = askme + 4
SoundEffect 1

END SUB

SUB FadeVolumeOut
aaa = MusicVolume(&HFF)
FOR bbb = aaa TO 0 STEP -1
ccc = MusicVolume(bbb)
DelayFrame 1
NEXT

END SUB

SUB firebolt (whichchar, whichmons)
IF monsterstat(whichmons, 1) = 0 THEN EXIT SUB
DIM firebolts(10008) AS INTEGER: DEF SEG = VARSEG(firebolts(0)): BLOAD "SPRITES\FYRCOLUM.PUT", VARPTR(firebolts(0)): DEF SEG
fireoffset = 2502
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "FIREBOLT"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
rotater = 0
FOR travel = 100 TO 5 STEP -5
Buffer2toBuffer1
VSSprite VARSEG(firebolts(rotater * fireoffset)), VARPTR(firebolts(rotater * fireoffset)), (monsterx(whichmons) + 10), 0 - travel, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 1
checkkeys
rotater = rotater + 1: IF rotater = 4 THEN rotater = 0
SoundEffect 4
NEXT travel
Buffer2toBuffer1
UpdateScreen
VSBlendPalettes "PALETTES\FIRE", "DATA\BATTLE"

'determine damage here!
damage = INT(RND(1) * 50) + 50

'monster gets a chance to resist for halved damage
resistfactor = INT(RND(1) * 100) + 1
IF resistfactor < monsterstat(whichmons, 6) THEN damage = INT(damage * .5)

'showdamage
Buffer2toBuffer1
rr$ = STR$(damage)
VSFont &HA000, 0, monsterx(whichmons), monstery, rr$, 31, 28
VSDelay 30
checkkeys

'calculate new HP
monsterstat(whichmons, 1) = monsterstat(whichmons, 1) - damage
IF monsterstat(whichmons, 1) < 0 THEN monsterstat(whichmons, 1) = 0

'that's all there is to it!
RestoreBackground
ERASE firebolts
VSDelay 30
nstat(whichchar, 3) = nstat(whichchar, 3) - 5
END SUB

REM $DYNAMIC
SUB getcharactions
VIEW PRINT
FOR selection = 1 TO 4
returnfromloop:
PlaceMonsters 0, 0
IF nstat(selection, 1) < 1 THEN actions(selection) = 0: GOTO nolifeforyou
argg$ = STR$(nstat(selection, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE selection
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
PUT (0, 160), attackoptions(0 * optionoffset), PSET
PUT (32, 160), attackoptions(1 * optionoffset), PSET
PUT (64, 160), attackoptions(2 * optionoffset), PSET
PUT (96, 160), attackoptions(3 * optionoffset), PSET
PUT (128, 160), attackoptions(4 * optionoffset), PSET
PUT (160, 160), attackoptions(5 * optionoffset), PSET
LOCATE 20, 25: PRINT "          "
LOCATE 21, 25: PRINT "             "
LOCATE 22, 25: PRINT "             "
LOCATE 20, 25: PRINT nst(selection, 1)
LOCATE 21, 25: PRINT "HP:"; nstat(selection, 1); "/"; nstat(selection, 2)
LOCATE 22, 25: PRINT "MP:"; nstat(selection, 3); "/"; nstat(selection, 4)
askme = 1
LOCATE 19, 1: PRINT "ATTACK "
argmeister:
PUT (((askme - 1) * 32), 160), attackicons(1 * iconoffset), XOR
a$ = INKEY$
IF a$ = "" THEN
	PUT (((askme - 1) * 32), 160), attackicons(1 * iconoffset), XOR
	GOTO argmeister
END IF
SELECT CASE a$
	CASE CHR$(0) + CHR$(75)
	  PUT (((askme - 1) * 32), 160), attackicons(1 * iconoffset), XOR
	  askme = askme - 1
	  IF askme = 0 THEN askme = 6
	  GOTO updatethingie
	CASE CHR$(0) + CHR$(77)
	  PUT (((askme - 1) * 32), 160), attackicons(1 * iconoffset), XOR
	  askme = askme + 1
	  IF askme = 7 THEN askme = 1
	  GOTO updatethingie
	CASE CHR$(13), " "
	  PUT (((askme - 1) * 32), 160), attackicons(1 * iconoffset), XOR
	  IF askme = 4 OR askme = 5 THEN GOTO argmeister
	  GOTO actionchosen
	CASE "~"
	  SaveScreen
	CASE "T"
	  typers = 0
	  VSFont &HA000, 0, 0, 0, "TYPERS DISABLED.", 31, 20
	  waitforit
	CASE CHR$(27)
	  LOCATE 1, 1
	  PRINT "Quit game?"
	  yesorno
	  GOTO returnfromloop
	CASE ELSE
END SELECT
PUT (((askme - 1) * 32), 160), attackicons(1 * iconoffset), XOR
updatethingie:
SELECT CASE askme
CASE 1: LOCATE 19, 1: PRINT "ATTACK "
CASE 2: LOCATE 19, 1: PRINT "MAGIC  "
CASE 3: LOCATE 19, 1: PRINT "ITEMS  "
CASE 4: LOCATE 19, 1: PRINT "SKILLS "
CASE 5: LOCATE 19, 1: PRINT "DEFENCE"
CASE 6: LOCATE 19, 1: PRINT "FLEE   "
CASE ELSE
END SELECT
GOTO argmeister

actionchosen:
PUT (0, 160), attackoptions(0 * optionoffset), XOR
PUT (32, 160), attackoptions(1 * optionoffset), XOR
PUT (64, 160), attackoptions(2 * optionoffset), XOR
PUT (96, 160), attackoptions(3 * optionoffset), XOR
PUT (128, 160), attackoptions(4 * optionoffset), XOR
PUT (160, 160), attackoptions(5 * optionoffset), XOR
actions(selection) = askme
IF askme = 6 THEN GOTO nolifeforyou
IF askme = 3 THEN
	doitem selection
	IF usinga(selection) = 10 THEN GOTO returnfromloop
	GOTO beatmewithastick
END IF
IF askme = 2 THEN
	choosespell selection
	IF usinga(selection) = 0 THEN GOTO returnfromloop
	GOTO beatmewithastick
END IF
askme = 1
argmeister2:
IF monsterstat(askme, 1) = 0 THEN
	askme = askme + 1
	IF askme = 5 THEN askme = 1
	GOTO argmeister2
END IF
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
LOCATE 19, 8
PRINT monstername(askme) + "               "
a$ = INKEY$
IF a$ = "" THEN
	PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
	GOTO argmeister2
END IF
IF a$ = CHR$(0) + CHR$(75) THEN GOTO cursorleft
IF a$ = CHR$(0) + CHR$(77) THEN GOTO cursorright
IF a$ = CHR$(13) OR a$ = " " THEN GOTO enemychosen
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
GOTO argmeister2

cursorleft:
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
askagainl:
askme = askme - 1
IF askme = 0 THEN askme = 4
IF monsterstat(askme, 1) = 0 THEN GOTO askagainl
GOTO argmeister2

cursorright:
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
askagainr:
askme = askme + 1
IF askme = 5 THEN askme = 1
IF monsterstat(askme, 1) = 0 THEN GOTO askagainr
GOTO argmeister2

enemychosen:
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
against(selection) = askme
beatmewithastick:
SoundEffect 1

nolifeforyou:
NEXT selection
END SUB

SUB getthevmfile
virtual = FREEFILE
OPEN "DATA\VIRTUAL.MEM" FOR INPUT AS #virtual
INPUT #virtual, MODfile
IF MODfile = "0" THEN nowayhereman
INPUT #virtual, backgroundimage
INPUT #virtual, monsterfile
CLOSE virtual
END SUB

REM $STATIC
SUB litening1 (whichchar, whichmons)
IF monsterstat(whichmons, 1) = 0 THEN EXIT SUB
DIM litening(1421) AS INTEGER: DEF SEG = VARSEG(litening(0)): BLOAD "SPRITES\LITENING.PUT", VARPTR(litening(0)): DEF SEG
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "LITENING"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
SoundEffect 2
VSBlendPalettes "DATA\BATTLE", "PALETTES\SANDSTRM"
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"
FOR a = 1 TO 3
FOR B = 0 TO 44 STEP 22
Buffer2toBuffer1
VSSprite VARSEG(litening(0)), VARPTR(litening(0)), (monsterx(whichmons) + B), 0, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSPalette "PALETTES\SANDSTRM"
UpdateScreen
VSDelay 1
checkkeys
SoundEffect 4
Buffer2toBuffer1
UpdateScreen
VSPalette "DATA\BATTLE"
VSDelay 1
checkkeys
NEXT B
NEXT a
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"

'determine damage here!
damage = INT(RND(1) * 50) + 50

'monster gets a chance to resist for halved damage
resistfactor = INT(RND(1) * 100) + 1
IF resistfactor < monsterstat(whichmons, 6) THEN damage = INT(damage * .5)

'showdamage
Buffer2toBuffer1
rr$ = STR$(damage)
VSFont &HA000, 0, monsterx(whichmons), monstery, rr$, 31, 28
VSDelay 30
checkkeys

'calculate new HP
monsterstat(whichmons, 1) = monsterstat(whichmons, 1) - damage
IF monsterstat(whichmons, 1) < 0 THEN monsterstat(whichmons, 1) = 0

'that's all there is to it!
RestoreBackground
ERASE litening
VSDelay 30
nstat(whichchar, 3) = nstat(whichchar, 3) - 5
END SUB

SUB litening2 (whichchar, whichmons)
IF monsterstat(whichmons, 1) = 0 THEN EXIT SUB
liteoffset = 1422
DIM litening(5688) AS INTEGER: DEF SEG = VARSEG(litening(0)): BLOAD "SPRITES\BLULITNG.PUT", VARPTR(litening(0)): DEF SEG
DIM l1x(4) AS INTEGER
DIM l2x(4) AS INTEGER
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "BLUE LITENING"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
SoundEffect 2
VSBlendPalettes "DATA\BATTLE", "PALETTES\SANDSTRM"
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"
FOR a = 1 TO 15
FOR B = 1 TO 4
l1x(B) = INT(RND(1) * 64)
l2x(B) = INT(RND(1) * 4)
NEXT B
Buffer2toBuffer1
FOR B = 1 TO 4
VSSprite VARSEG(litening(liteoffset * l2x(B))), VARPTR(litening(liteoffset * l2x(B))), (monsterx(whichmons) + l1x(B)), 0, VARSEG(buffer1(0)), VARPTR(buffer1(0))
NEXT B
VSPalette "PALETTES\WATER"
UpdateScreen
VSDelay 1
checkkeys
SoundEffect 4
VSPalette "DATA\BATTLE"
VSDelay 1
checkkeys
NEXT a
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"
Buffer2toBuffer1
UpdateScreen

'determine damage here!
damage = INT(RND(1) * 300) + 100

'monster gets a chance to resist for halved damage
resistfactor = INT(RND(1) * 100) + 1
IF resistfactor < monsterstat(whichmons, 6) THEN damage = INT(damage * .5)

'showdamage
Buffer2toBuffer1
rr$ = STR$(damage)
VSFont &HA000, 0, monsterx(whichmons), monstery, rr$, 31, 28
VSDelay 30
checkkeys

'calculate new HP
monsterstat(whichmons, 1) = monsterstat(whichmons, 1) - damage
IF monsterstat(whichmons, 1) < 0 THEN monsterstat(whichmons, 1) = 0

'that's all there is to it!
RestoreBackground
ERASE litening
VSDelay 30
nstat(whichchar, 3) = nstat(whichchar, 3) - 15

END SUB

SUB loadmonsters
FOR aa = 1 TO 4
soundtoplay(aa) = 7
NEXT aa
dumbass = FREEFILE
OPEN "I", #dumbass, monsterfile
INPUT #dumbass, typers
CLOSE dumbass
IF typers = 1 THEN GOTO bossmonster
IF typers = 2 THEN GOTO doublebossmonster
IF typers = 3 THEN GOTO triplebossmonster
IF typers = 4 THEN GOTO quadbossmonster
monster = INT(RND(1) * 4) + 1
FOR duh = 1 TO monster
monsternumber = INT(RND(1) * 10) + 1
OPEN "I", #dumbass, monsterfile
INPUT #dumbass, typers
dork:
INPUT #dumbass, numero
IF numero <> monsternumber THEN
	INPUT #dumbass, duhh$
	FOR a = 1 TO 10: INPUT #dumbass, dummy: NEXT a
	INPUT #dumbass, duhh$
	INPUT #dumbass, dork
	GOTO dork
END IF
INPUT #dumbass, monstername(duh)
FOR dufus = 1 TO 10
INPUT #dumbass, monsterstat(duh, dufus)
NEXT
INPUT #dumbass, monstersprite(duh)
INPUT #dumbass, soundtoplay(duh)
CLOSE dumbass
NEXT
EXIT SUB

bossmonster:
monster = 1
OPEN "I", #dumbass, monsterfile
INPUT #dumbass, numero
INPUT #dumbass, setevent
evnt(setevent) = 1
INPUT #dumbass, monstername(1)
FOR dufus = 1 TO 10
INPUT #dumbass, monsterstat(1, dufus)
NEXT
INPUT #dumbass, monstersprite(1)
INPUT #dumbass, soundtoplay(1)
DEF SEG
CLOSE dumbass
EXIT SUB

doublebossmonster:
monster = 2
OPEN "I", #dumbass, monsterfile
INPUT #dumbass, numero
INPUT #dumbass, setevent
evnt(setevent) = 1
FOR ableio = 1 TO 2
INPUT #dumbass, monstername(ableio)
FOR dufus = 1 TO 10
INPUT #dumbass, monsterstat(ableio, dufus)
NEXT
INPUT #dumbass, monstersprite(ableio)
INPUT #dumbass, soundtoplay(ableio)
NEXT
DEF SEG
CLOSE dumbass
EXIT SUB

triplebossmonster:
monster = 3
OPEN "I", #dumbass, monsterfile
INPUT #dumbass, numero
INPUT #dumbass, setevent
evnt(setevent) = 1
FOR ableio = 1 TO 3
INPUT #dumbass, monstername(ableio)
FOR dufus = 1 TO 10
INPUT #dumbass, monsterstat(ableio, dufus)
NEXT
INPUT #dumbass, monstersprite(ableio)
INPUT #dumbass, soundtoplay(ableio)
NEXT
DEF SEG
CLOSE dumbass
EXIT SUB

quadbossmonster:
monster = 4
OPEN "I", #dumbass, monsterfile
INPUT #dumbass, numero
INPUT #dumbass, setevent
evnt(setevent) = 1
FOR ableio = 1 TO 4
INPUT #dumbass, monstername(ableio)
FOR dufus = 1 TO 10
INPUT #dumbass, monsterstat(ableio, dufus)
NEXT
INPUT #dumbass, monstersprite(ableio)
INPUT #dumbass, soundtoplay(ableio)
NEXT
DEF SEG
CLOSE dumbass
EXIT SUB

END SUB

REM $DYNAMIC
SUB loadstatistics
OPEN "I", #3, "DATA\STATS.DAT"
FOR a = 1 TO 4
FOR B = 1 TO 28
INPUT #3, nstat(a, B)
NEXT B
INPUT #3, nbig(a, 1)
INPUT #3, nbig(a, 2)
NEXT a
FOR a = 1 TO 4
FOR B = 1 TO 7
INPUT #3, nst(a, B)
NEXT: NEXT
FOR a = 1 TO 4
FOR B = 1 TO 20
INPUT #3, spl(a, B)
NEXT
FOR B = 1 TO 5
INPUT #3, skills(a, B)
NEXT B
NEXT
FOR a = 1 TO 500
INPUT #3, evnt(a)
NEXT
INPUT #3, moolah
INPUT #3, pmx
INPUT #3, pmy
INPUT #3, map$
FOR a = 1 TO 4
FOR B = 1 TO 9
INPUT #3, equipment(a, B)
NEXT: NEXT
FOR a = 1 TO 9
INPUT #3, items(a)
NEXT
CLOSE #3
DEF SEG = VARSEG(emptybox(0))
BLOAD "TILES\WOS-BOXE.PUT", VARPTR(emptybox(0))
DEF SEG = VARSEG(filledbox(0))
BLOAD "TILES\WOS-BOXB.PUT", VARPTR(filledbox(0))
DEF SEG

END SUB

REM $STATIC
SUB makefunnyboxes
FOR a = 152 TO 184 STEP 8
PUT (8, a), emptybox, PSET
NEXT a
END SUB

SUB molotov (whichchar, whichmons)
IF monsterstat(whichmons, 1) = 0 THEN EXIT SUB
REDIM molotov1(210) AS INTEGER: DEF SEG = VARSEG(molotov1(0)): BLOAD "SPRITES\MOLOTOV1.PUT", VARPTR(molotov1(0)): DEF SEG
molotovoffset = 52
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "MOLOTOV COCKTAIL"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
rotater = 0
SoundEffect 11
FOR travel = 78 TO 40 STEP -2
Buffer2toBuffer1
VSSprite VARSEG(molotov1(rotater * molotovoffset)), VARPTR(molotov1(rotater * molotovoffset)), (monsterx(whichmons) + 20), travel, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 1
checkkeys
rotater = rotater + 1: IF rotater = 4 THEN rotater = 0
NEXT travel

'determine damage here!
damage = INT(RND(1) * 50) + 50

'monster gets a chance to resist for halved damage
resistfactor = INT(RND(1) * 100) + 1
IF resistfactor < monsterstat(whichmons, 6) THEN damage = INT(damage * .5)

REDIM molotov1(6150) AS INTEGER: DEF SEG = VARSEG(molotov1(0)): BLOAD "SPRITES\MOLOTOV2.PUT", VARPTR(molotov1(0)): DEF SEG
DIM sequence(5) AS INTEGER
sequence(1) = 0
sequence(2) = 1
sequence(3) = 2
sequence(4) = 1
sequence(5) = 0
SoundEffect 4
FOR a = 1 TO 5
Buffer2toBuffer1
VSSprite VARSEG(molotov1(sequence(a) * monsteroffset)), VARPTR(molotov1(sequence(a) * monsteroffset)), monsterx(whichmons), monstery, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 5
checkkeys
NEXT

'showdamage
Buffer2toBuffer1
UpdateScreen
rr$ = STR$(damage)
VSFont &HA000, 0, monsterx(whichmons), monstery, rr$, 31, 28
VSDelay 30
checkkeys

'calculate new HP
monsterstat(whichmons, 1) = monsterstat(whichmons, 1) - damage
IF monsterstat(whichmons, 1) < 0 THEN monsterstat(whichmons, 1) = 0

'that's all there is to it!
RestoreBackground
ERASE molotov1
VSDelay 30
nstat(whichchar, 3) = nstat(whichchar, 3) - 5
END SUB

SUB notes2

'ARRAY nstat
' #  Variable Represents
'1  CurrentHP
'2  MaximumHP
'3  CurrentMP
'4  MaximumMP
'5  AttackStrength
'6  NaturalDefence
'7  NaturalMagicResistance
'8  NaturalAgility
'9  NaturalMagicPower
'10  ClassID
'11  WeaponPower
'12  WeaponAttackVariable
'13  WeaponDefenceBonus
'14  WeaponAgilityBonus
'15  WeaponMagicBonus
'16  ArmorPower
'17  ArmorAttackBonus
'18  ArmorAgilityBonus
'19  ArmorMagicBonus
'20  ShieldPower
'21  ShieldAttackBonus
'22  ShieldAgilityBonus
'23  ShieldMagicBonus
'24  HeadgearPower
'25  HeadgearAttackBonus
'26  HeadgearAgilityBonus
'27  HeadgearMagicBonus
'28  ExperienceLevel
'29  AccumulatedAttackPower
'30  AccumulatedDefencePower
'31  AccumulatedAgility
'32  AccumulatedResistance
'33  AccumulatedMagicPower
'
'NOTE
'Entries 29-33 are active only during a battle. They are never recorded data.
'
'ARRAY N&
'01  ExperiencePoints
'02  NextUpValue
'
'ARRAY nst
' #  Variable Represents
'01  CharacterName
'02  CharacterClass
'03  CharacterAlignment
'04  CharacterEquippedWeapon
'05  CharacterWornArmor
'06  CharacterCarriedShield
'07  CharacterWornHeadgear
'
'ARRAY monsterstat
' #  Variable Represents
'01  EnemyHP
'02  EnemyNaturalAttackStrength
'03  EnemyAttackVariable
'04  EnemyNaturalDefence
'05  EnemyNaturalAgility
'06  EnemyNaturalResistance
'07  EnemyPowersID
'08  EnemyWeaknessID
'09  EnemyXPValue
'10  EnemyMoolah
'11  EnemyAccumulatedStrength
'12  EnemyAccumulatedDefence
'13  EnemyAccumulatedAgility
'14  EnemyAccumulatedResistance
'15  EnemyMagicStrength

END SUB

SUB nowayhereman
SCREEN 0: WIDTH 80
CLS
PRINT "Battle module requires WRATH.EXE to operate."
END
END SUB

SUB runaway
TextBox
PRINT "Fled the scene."
waitforit
END SUB

SUB sandstorm (whichchar)
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "SAND STORM"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
SoundEffect 12
VSBlendPalettes "DATA\BATTLE", "PALETTES\SANDSTRM"
ripple
PlaceMonsters 0, 0
UpdateScreen
VSBlendPalettes "PALETTES\SANDSTRM", "DATA\BATTLE"
RestoreBackground
'calculate damage effects here!
FOR baddydude = 1 TO 4
IF monsterstat(baddydude, 1) < 1 THEN GOTO nosandforme
damage = INT(RND(1) * 50) + 50
chances = INT(RND(1) * 100) + 1
IF monsterstat(baddydude, 6) > chances THEN damage = INT(damage * .5)
rr$ = STR$(damage)
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), monsterx(baddydude), 10, rr$, 31, 28
monsterstat(baddydude, 1) = monsterstat(baddydude, 1) - damage
IF monsterstat(baddydude, 1) < 1 THEN monsterstat(baddydude, 1) = 0
nosandforme:
NEXT
UpdateScreen
VSDelay 75
checkkeys
nstat(whichchar, 3) = nstat(whichchar, 3) - 10
END SUB

SUB savestats
OPEN "O", #3, "DATA\STATS.DAT"
FOR a = 1 TO 4
FOR B = 1 TO 28
WRITE #3, nstat(a, B)
NEXT B
WRITE #3, nbig(a, 1)
WRITE #3, nbig(a, 2)
NEXT a
FOR a = 1 TO 4
FOR B = 1 TO 7
WRITE #3, nst(a, B)
NEXT B
NEXT a
FOR a = 1 TO 4
FOR B = 1 TO 20
WRITE #3, spl(a, B)
NEXT B
FOR B = 1 TO 5
WRITE #3, skills(a, B)
NEXT B
NEXT a
FOR a = 1 TO 500
WRITE #3, evnt(a)
NEXT a
WRITE #3, moolah
WRITE #3, pmx
WRITE #3, pmy
WRITE #3, map$
FOR a = 1 TO 4
FOR B = 1 TO 9
WRITE #3, equipment(a, B)
NEXT: NEXT
FOR a = 1 TO 9
WRITE #3, items(a)
NEXT
CLOSE 3

END SUB

SUB selectbaddy (whowho)
askme = 1
argmeister7:
IF monsterstat(askme, 1) = 0 THEN
	askme = askme + 1
	IF askme = 5 THEN askme = 1
	GOTO argmeister7
END IF
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
a$ = INKEY$
IF a$ = "" THEN
	PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
	GOTO argmeister7
END IF
IF a$ = CHR$(0) + CHR$(75) THEN GOTO cursorleft2
IF a$ = CHR$(0) + CHR$(77) THEN GOTO cursorright2
IF a$ = CHR$(13) THEN GOTO enemychosen2
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
GOTO argmeister7

cursorleft2:
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
askagainl2:
askme = askme - 1
IF askme = 0 THEN askme = 4
IF monsterstat(askme, 1) = 0 THEN GOTO askagainl2
GOTO argmeister7

cursorright2:
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
askagainr2:
askme = askme + 1
IF askme = 5 THEN askme = 1
IF monsterstat(askme, 1) = 0 THEN GOTO askagainr2
GOTO argmeister7

enemychosen2:
PUT (monsterx(askme), monstery), attackicons(1 * iconoffset), XOR
against(whowho) = askme
beatmewithastick2:
SoundEffect 1

END SUB

SUB setvm (answer)
virtual = FREEFILE
OPEN "DATA\VIRTUAL.MEM" FOR OUTPUT AS #virtual
WRITE #virtual, answer
CLOSE virtual
END SUB

SUB ShowMeTheMusic (file1$)
'This SUB simply loads up a new GDM file. The old one MUST be unloaded first!

IF detectedsound = 0 THEN EXIT SUB

IF LEN(file1$) = 0 THEN END
IF INSTR(file1$, ".") = 0 THEN file1$ = file1$ + ".GDM"
IF EmsExist THEN ErrorFlag = 1 ELSE ErrorFlag = 0
file = FREEFILE
OPEN file1$ FOR BINARY AS file
LoadGDM FILEATTR(file, 2), 0, ErrorFlag, VARSEG(ModHead), VARPTR(ModHead)
SELECT CASE ErrorFlag
CASE 0
CASE 1: buggeredout 13
CASE 2: buggeredout 14
CASE 3: buggeredout 15
CASE 4: buggeredout 16
CASE 5: buggeredout 17
CASE 6: buggeredout 18
CASE ELSE: buggeredout 99
END SELECT
CLOSE file
MusicChannels = 0
FOR J = 1 TO 32
  IF ASC(MID$(ModHead.PanMap, J, 1)) <> &HFF THEN
    MusicChannels = MusicChannels + 1
  END IF
NEXT
OverRate& = StartOutput(MusicChannels + 1, 0)

END SUB

SUB snowstorm (whichchar)
snowoffset = 10
DIM snowflakes(45) AS INTEGER: DEF SEG = VARSEG(snowflakes(0)): BLOAD "SPRITES\SNOWSTRM.PUT", VARPTR(snowflakes(0)): DEF SEG
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "SNOWSTORM"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
'snow effect here!
DIM snowflakex(30) AS INTEGER
DIM snowflakey(30) AS INTEGER
FOR aa = 1 TO 30
egad = INT(RND(1) * 320) + 1
snowflakex(aa) = egad
egad = INT(RND(1) * 100) + 1
snowflakey(aa) = egad
NEXT aa
SoundEffect 13
VSBlendPalettes "DATA\BATTLE", "PALETTES\WATER"
FOR biteme = 1 TO 500
Buffer2toBuffer1
FOR aa = 1 TO 10
snowflakex(aa) = snowflakex(aa) - 1
IF snowflakex(aa) < -10 THEN snowflakex(aa) = 330
snowflakey(aa) = snowflakey(aa) + 1
IF snowflakey(aa) > 70 THEN snowflakey(aa) = -4
VSSprite VARSEG(snowflakes(20)), VARPTR(snowflakes(20)), snowflakex(aa), snowflakey(aa), VARSEG(buffer1(0)), VARPTR(buffer1(0))
NEXT aa
FOR aa = 11 TO 20
snowflakex(aa) = snowflakex(aa) - 2
IF snowflakex(aa) < -10 THEN snowflakex(aa) = 330
snowflakey(aa) = snowflakey(aa) + 2
IF snowflakey(aa) > 90 THEN snowflakey(aa) = -4
VSSprite VARSEG(snowflakes(10)), VARPTR(snowflakes(10)), snowflakex(aa), snowflakey(aa), VARSEG(buffer1(0)), VARPTR(buffer1(0))
NEXT aa
FOR aa = 21 TO 30
snowflakex(aa) = snowflakex(aa) - 3
IF snowflakex(aa) < -10 THEN snowflakex(aa) = 330
snowflakey(aa) = snowflakey(aa) + 3
IF snowflakey(aa) > 110 THEN snowflakey(aa) = -4
VSSprite VARSEG(snowflakes(0)), VARPTR(snowflakes(0)), snowflakex(aa), snowflakey(aa), VARSEG(buffer1(0)), VARPTR(buffer1(0))
NEXT aa
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), 128, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
NEXT biteme
Buffer2toBuffer1
UpdateScreen
VSBlendPalettes "PALETTES\WATER", "DATA\BATTLE"
RestoreBackground

'calculate damage effects here!
FOR baddydude = 1 TO 4
IF monsterstat(baddydude, 1) < 1 THEN GOTO nosnowforme
damage = INT(RND(1) * 50) + 50
chances = INT(RND(1) * 100) + 1
IF monsterstat(baddydude, 6) > chances THEN damage = INT(damage * .5)
rr$ = STR$(damage)
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), monsterx(baddydude), 10, rr$, 31, 28
monsterstat(baddydude, 1) = monsterstat(baddydude, 1) - damage
IF monsterstat(baddydude, 1) < 1 THEN monsterstat(baddydude, 1) = 0
nosnowforme:
NEXT
UpdateScreen
VSDelay 75
checkkeys
ERASE snowflakes
nstat(whichchar, 3) = nstat(whichchar, 3) - 10
END SUB

REM $DYNAMIC
SUB sortitout
IF nstat(1, 1) < 1 THEN GOTO char2
agility = nstat(1, 8) + nstat(1, 14) + nstat(1, 18) + nstat(1, 22) + nstat(1, 26)
crazy(1) = INT(RND(1) * agility) + 1
char2:
IF nstat(2, 1) < 1 THEN GOTO char3
agility = nstat(2, 8) + nstat(2, 14) + nstat(2, 18) + nstat(2, 22) + nstat(2, 26)
crazy(2) = INT(RND(1) * agility) + 1
IF crazy(2) = crazy(1) THEN crazy(2) = crazy(2) + 1
char3:
IF nstat(3, 1) < 1 THEN GOTO char4
agility = nstat(3, 8) + nstat(3, 14) + nstat(3, 18) + nstat(3, 22) + nstat(3, 26)
crazy(3) = INT(RND(1) * agility) + 1
char31:
IF crazy(3) = crazy(1) THEN crazy(3) = crazy(3) + 1: GOTO char31
IF crazy(3) = crazy(2) THEN crazy(3) = crazy(3) + 1: GOTO char31
char4:
IF nstat(4, 1) < 1 THEN GOTO mons1
agility = nstat(4, 8) + nstat(4, 14) + nstat(4, 18) + nstat(4, 22) + nstat(4, 26)
crazy(4) = INT(RND(1) * agility) + 1
char41:
crazyflag = 0
FOR checkit = 1 TO 3
IF crazy(4) = crazy(checkit) THEN
	crazy(4) = crazy(4) + 1
	crazyflag = 1
END IF
NEXT
IF crazyflag = 1 THEN GOTO char41
mons1:
IF monsterstat(1, 1) < 1 THEN GOTO mons2
crazy(5) = INT(RND(1) * monsterstat(1, 5)) + 1
crazy51:
crazyflag = 0
FOR checkit = 1 TO 4
IF crazy(5) = crazy(checkit) THEN
	crazy(5) = crazy(5) + 1
	crazyflag = 1
END IF
NEXT
IF crazyflag = 1 THEN GOTO crazy51
mons2:
IF monsterstat(2, 1) < 1 THEN GOTO mons3
crazy(6) = INT(RND(1) * monsterstat(2, 5)) + 1
crazy61:
crazyflag = 0
FOR checkit = 1 TO 5
IF crazy(6) = crazy(checkit) THEN
	crazy(6) = crazy(6) + 1
	crazyflag = 1
END IF
NEXT
IF crazyflag = 1 THEN GOTO crazy61
mons3:
IF monsterstat(3, 1) < 1 THEN GOTO mons4
crazy(7) = INT(RND(1) * monsterstat(3, 5)) + 1
crazy71:
crazyflag = 0
FOR checkit = 1 TO 6
IF crazy(7) = crazy(checkit) THEN
	crazy(7) = crazy(7) + 1
	crazyflag = 1
END IF
NEXT
IF crazyflag = 1 THEN GOTO crazy71
mons4:
IF monsterstat(4, 1) < 1 THEN GOTO sortitout
crazy(8) = INT(RND(1) * monsterstat(4, 5)) + 1
crazy81:
crazyflag = 0
FOR checkit = 1 TO 7
IF crazy(8) = crazy(checkit) THEN
	crazy(8) = crazy(8) + 1
	crazyflag = 1
END IF
NEXT
IF crazyflag = 1 THEN GOTO crazy81
sortitout:
FOR buggersnot = 1 TO 8
IF crazy(1) = 0 AND crazy(2) = 0 AND crazy(3) = 0 AND crazy(4) = 0 AND crazy(5) = 0 AND crazy(6) = 0 AND crazy(7) = 0 AND crazy(8) = 0 THEN initiative(buggersnot) = 0: GOTO donewiththisone
IF crazy(1) > crazy(2) AND crazy(1) > crazy(3) AND crazy(1) > crazy(4) AND crazy(1) > crazy(5) AND crazy(1) > crazy(6) AND crazy(1) > crazy(7) AND crazy(1) > crazy(8) THEN crazy(1) = 0: initiative(buggersnot) = 1: GOTO donewiththisone
IF crazy(2) > crazy(1) AND crazy(2) > crazy(3) AND crazy(2) > crazy(4) AND crazy(2) > crazy(5) AND crazy(2) > crazy(6) AND crazy(2) > crazy(7) AND crazy(2) > crazy(8) THEN crazy(2) = 0: initiative(buggersnot) = 2: GOTO donewiththisone
IF crazy(3) > crazy(1) AND crazy(3) > crazy(2) AND crazy(3) > crazy(4) AND crazy(3) > crazy(5) AND crazy(3) > crazy(6) AND crazy(3) > crazy(7) AND crazy(3) > crazy(8) THEN crazy(3) = 0: initiative(buggersnot) = 3: GOTO donewiththisone
IF crazy(4) > crazy(1) AND crazy(4) > crazy(2) AND crazy(4) > crazy(3) AND crazy(4) > crazy(5) AND crazy(4) > crazy(6) AND crazy(4) > crazy(7) AND crazy(4) > crazy(8) THEN crazy(4) = 0: initiative(buggersnot) = 4: GOTO donewiththisone
IF crazy(5) > crazy(1) AND crazy(5) > crazy(2) AND crazy(5) > crazy(3) AND crazy(5) > crazy(4) AND crazy(5) > crazy(6) AND crazy(5) > crazy(7) AND crazy(5) > crazy(8) THEN crazy(5) = 0: initiative(buggersnot) = 5: GOTO donewiththisone
IF crazy(6) > crazy(1) AND crazy(6) > crazy(2) AND crazy(6) > crazy(3) AND crazy(6) > crazy(4) AND crazy(6) > crazy(5) AND crazy(6) > crazy(7) AND crazy(6) > crazy(8) THEN crazy(6) = 0: initiative(buggersnot) = 6: GOTO donewiththisone
IF crazy(7) > crazy(1) AND crazy(7) > crazy(2) AND crazy(7) > crazy(3) AND crazy(7) > crazy(4) AND crazy(7) > crazy(5) AND crazy(7) > crazy(6) AND crazy(7) > crazy(8) THEN crazy(7) = 0: initiative(buggersnot) = 7: GOTO donewiththisone
IF crazy(8) > crazy(1) AND crazy(8) > crazy(2) AND crazy(8) > crazy(3) AND crazy(8) > crazy(4) AND crazy(8) > crazy(5) AND crazy(8) > crazy(6) AND crazy(8) > crazy(7) THEN crazy(8) = 0: initiative(buggersnot) = 8: GOTO donewiththisone
PRINT "ERROR IN SORTING ROUTINE..."
END
donewiththisone:
NEXT

END SUB

REM $STATIC
SUB SoundEffect (whatsound)
IF detectedsound = 0 THEN EXIT SUB
SELECT CASE whatsound
	CASE 1 'Selection Made
		PlaySample (MusicChannels + 1), 64, 30000, 64, 8
	CASE 2 'Thunder
		PlaySample (MusicChannels + 1), 65, 22000, 64, 8
	CASE 3 'praxis.blast
		PlaySample (MusicChannels + 1), 66, 17000, 64, 8
	CASE 4 'toasty!
		PlaySample (MusicChannels + 1), 67, 10000, 64, 8
	CASE 5 'healing
		PlaySample (MusicChannels + 1), 68, 4000, 64, 8
	CASE 6 'bolt.iff
		PlaySample (MusicChannels + 1), 69, 14000, 64, 8
	CASE 7 'Punch
		PlaySample (MusicChannels + 1), 70, 8000, 64, 8
	CASE 8 'spell1
		PlaySample (MusicChannels + 1), 71, 10000, 64, 8
	CASE 9 'spell2
		PlaySample (MusicChannels + 1), 72, 16000, 64, 8
	CASE 10 'spell3
		PlaySample (MusicChannels + 1), 73, 30000, 64, 8
	CASE 11 'spell4
		PlaySample (MusicChannels + 1), 74, 22000, 64, 8
	CASE 12 'Wind Howling
		PlaySample (MusicChannels + 1), 75, 15000, 64, 8
	CASE 13 'Wind Howling:LOW HERTZ
		PlaySample (MusicChannels + 1), 75, 4000, 64, 8
	CASE ELSE
END SELECT

END SUB

SUB temp
'FOR selection = 1 TO 4
''check for character life!
'IF nstat(selection, 1) < 1 THEN actions(selection) = 0: GOTO nolife
''show attack options
'PRINT
'PRINT nst(selection, 1)
'PRINT nstat(selection, 1); "/"; nstat(selection, 2); "HP"
'PRINT "1 Attack ";
'PRINT "2 Cast spell"
'PRINT "3 Use item ";
'PRINT "4 Use power"
'PRINT "5 Defend ";
'PRINT "6 Escape"
'ask:
'a$ = INKEY$: IF a$ = "" THEN GOTO ask
'askme% = VAL(a$)
'IF askme% > 6 OR askme% < 1 THEN GOTO ask
'actions(selection) = askme%
'IF askme% <> 1 AND askme% <> 6 THEN GOTO ask
'IF askme% = 6 THEN GOTO nolife
'showmonsternames:
'FOR bubble = 1 TO monster
'IF monsterstat(bubble, 1) > 0 THEN PRINT bubble; monstername(bubble)
'NEXT bubble
'INPUT "Which to attack"; a$
'askme% = VAL(a$)
'IF askme% > monster OR askme% < 1 THEN GOTO showmonsternames
'IF monsterstat(askme%, 1) < 1 THEN GOTO showmonsternames
'against(selection) = askme%
'SoundEffect 1
'nolife:
'NEXT selection
'
END SUB

SUB TextBox
LINE (0, 71)-(319, 71), 28
LINE (0, 70)-(319, 70), 29
LINE (0, 69)-(319, 69), 30
LINE (0, 104)-(319, 104), 28
LINE (0, 105)-(319, 105), 29
LINE (0, 106)-(319, 106), 30
LINE (0, 72)-(319, 103), 0, BF
VIEW PRINT 10 TO 13

END SUB

SUB throwshuriken (whichchar, whichmons)
IF monsterstat(whichmons, 1) = 0 THEN EXIT SUB
DIM starz(420) AS INTEGER: DEF SEG = VARSEG(starz(0)): BLOAD "SPRITES\SHURIKEN.PUT", VARPTR(starz(0)): DEF SEG
staroffset = 101
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(whichchar, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
TextBox
LOCATE 11, 1
PRINT "SINGLE INCANTATION"
PRINT "SHURIKEN"
WaitOnetime
checkkeys
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 20
checkkeys
rotater = 0
SoundEffect 11
FOR travel = 78 TO 40 STEP -2
Buffer2toBuffer1
VSSprite VARSEG(starz(rotater * staroffset)), VARPTR(starz(rotater * staroffset)), (monsterx(whichmons) + 20), travel, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), monsterx(whichmons), 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateScreen
VSDelay 1
checkkeys
rotater = rotater + 1: IF rotater = 4 THEN rotater = 0
NEXT travel

'determine damage here!
damage = INT(RND(1) * 50) + 50

'monster gets a chance to resist for halved damage
resistfactor = INT(RND(1) * 100) + 1
IF resistfactor < monsterstat(whichmons, 6) THEN damage = INT(damage * .5)

'showdamage
Buffer2toBuffer1
rr$ = STR$(damage)
VSFont &HA000, 0, monsterx(whichmons), monstery, rr$, 31, 28
SoundEffect 7
VSDelay 30
checkkeys

'calculate new HP
monsterstat(whichmons, 1) = monsterstat(whichmons, 1) - damage
IF monsterstat(whichmons, 1) < 0 THEN monsterstat(whichmons, 1) = 0

'that's all there is to it!
RestoreBackground
ERASE starz
VSDelay 30
nstat(whichchar, 3) = nstat(whichchar, 3) - 5
END SUB

SUB UpdateCharStats
'VSFont &HA000, 0, x, y, rr$, 31, 28
'display character names
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 0, 143, nst(1, 1), 31, 28
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 80, 143, nst(2, 1), 31, 28
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 160, 143, nst(3, 1), 31, 28
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 240, 143, nst(4, 1), 31, 28
'display character HP
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 0, 153, LTRIM$(STR$(nstat(1, 1))) + "/" + LTRIM$(STR$(nstat(1, 2))), 68, 65
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 80, 153, LTRIM$(STR$(nstat(2, 1))) + "/" + LTRIM$(STR$(nstat(2, 2))), 68, 65
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 160, 153, LTRIM$(STR$(nstat(3, 1))) + "/" + LTRIM$(STR$(nstat(3, 2))), 68, 65
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 240, 153, LTRIM$(STR$(nstat(4, 1))) + "/" + LTRIM$(STR$(nstat(4, 2))), 68, 65
'display character MP
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 0, 163, LTRIM$(STR$(nstat(1, 3))) + "/" + LTRIM$(STR$(nstat(1, 4))), 56, 53
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 80, 163, LTRIM$(STR$(nstat(2, 3))) + "/" + LTRIM$(STR$(nstat(2, 4))), 56, 53
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 160, 163, LTRIM$(STR$(nstat(3, 3))) + "/" + LTRIM$(STR$(nstat(3, 4))), 56, 53
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), 240, 163, LTRIM$(STR$(nstat(4, 3))) + "/" + LTRIM$(STR$(nstat(4, 4))), 56, 53
END SUB

SUB useitem (charwithitem, chartogetitem, itemtype)
items(itemtype) = items(itemtype) - 1
IF itemtype = 9 THEN GOTO cursebadguy
SELECT CASE itemtype
CASE 1, 4: healpower = INT(RND(1) * 31) + 19 + nstat(charwithitem, 9)
CASE 2, 5: healpower = INT(RND(1) * 101) + 199 + nstat(charwithitem, 9)
CASE 8: healpower = INT(RND(1) * 20) + 5 + nstat(charwithitem, 9)
CASE ELSE
END SELECT
PlaceMonsters 0, 0
UpdateCharStats
UpdateScreen
DIM healsprite(2056) AS INTEGER
DEF SEG = VARSEG(healsprite(0))
BLOAD "SPRITES\HEALSPEL.PUT", VARPTR(healsprite(0))
DEF SEG
IF charwithitem = chartogetitem THEN GOTO selfheal
'2056,514
argg$ = STR$(nstat(charwithitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE charwithitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
argg$ = STR$(nstat(chartogetitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE chartogetitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
checkkeys
PlaceMonsters 0, 0
argg$ = STR$(nstat(charwithitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE charwithitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
argg$ = STR$(nstat(chartogetitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE chartogetitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
checkkeys
SoundEffect 5
FOR asswipe = 0 TO 3
PlaceMonsters 0, 0
argg$ = STR$(nstat(charwithitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE charwithitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
argg$ = STR$(nstat(chartogetitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE chartogetitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(healsprite(asswipe * 514)), VARPTR(healsprite(asswipe * 514)), (placers + 16), 94, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
checkkeys
VSDelay 5
NEXT asswipe
PlaceMonsters 0, 0
argg$ = STR$(nstat(charwithitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE charwithitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
argg$ = STR$(nstat(chartogetitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE chartogetitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
rr$ = STR$(healpower)
IF itemtype = 3 OR itemtype = 6 THEN rr$ = "Full"
IF itemtype = 7 THEN rr$ = "Antidote"
VSFont &HA000, 0, placers, 100, rr$, 31, 28
VSDelay 60
SELECT CASE itemtype
CASE 1, 2
	nstat(chartogetitem, 1) = nstat(chartogetitem, 1) + healpower
	IF nstat(chartogetitem, 1) > nstat(chartogetitem, 2) THEN nstat(chartogetitem, 1) = nstat(chartogetitem, 2)
CASE 4, 5
	nstat(chartogetitem, 3) = nstat(chartogetitem, 3) + healpower
	IF nstat(chartogetitem, 3) > nstat(chartogetitem, 4) THEN nstat(chartogetitem, 3) = nstat(chartogetitem, 4)
CASE 3: nstat(chartogetitem, 1) = nstat(chartogetitem, 2)
CASE 6: nstat(chartogetitem, 3) = nstat(chartogetitem, 4)
CASE 7
CASE 8: nstat(chartogetitem, 30) = nstat(chartogetitem, 30) + healpower
END SELECT
UpdateCharStats
UpdateScreen
checkkeys
EXIT SUB

selfheal:
PlaceMonsters 0, 0
argg$ = STR$(nstat(chartogetitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE chartogetitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
PlaceMonsters 0, 0
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
SoundEffect 5
FOR asswipe = 0 TO 3
PlaceMonsters 0, 0
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(healsprite(asswipe * 514)), VARPTR(healsprite(asswipe * 514)), (placers + 16), 94, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSDelay 5
UpdateCharStats
UpdateScreen
NEXT asswipe
rr$ = STR$(healpower)
IF itemtype = 3 OR itemtype = 6 THEN rr$ = "Full"
IF itemtype = 7 THEN rr$ = "Antidote"
VSFont &HA000, 0, placers, 100, rr$, 31, 28
VSDelay 60
SELECT CASE itemtype
CASE 1, 2
	nstat(chartogetitem, 1) = nstat(chartogetitem, 1) + healpower
	IF nstat(chartogetitem, 1) > nstat(chartogetitem, 2) THEN nstat(chartogetitem, 1) = nstat(chartogetitem, 2)
CASE 4, 5
	nstat(chartogetitem, 3) = nstat(chartogetitem, 3) + healpower
	IF nstat(chartogetitem, 3) > nstat(chartogetitem, 4) THEN nstat(chartogetitem, 3) = nstat(chartogetitem, 4)
CASE 3: nstat(chartogetitem, 1) = nstat(chartogetitem, 2)
CASE 6: nstat(chartogetitem, 3) = nstat(chartogetitem, 4)
CASE 7
CASE 8: nstat(chartogetitem, 30) = nstat(chartogetitem, 30) + healpower
END SELECT
Buffer2toBuffer1
PlaceMonsters 0, 0
VSSprite VARSEG(playergfx(0)), VARPTR(playergfx(0)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
VSDelay 60
EXIT SUB

cursebadguy:
DIM drainsprite(465) AS INTEGER
DEF SEG = VARSEG(drainsprite(0))
BLOAD "SPRITES\DRAINSPL.PUT", VARPTR(drainsprite(0))
DEF SEG
StoreBackground
PlaceMonsters 0, 0
Buffer1toBuffer2
argg$ = STR$(nstat(charwithitem, 10))
argg$ = LTRIM$(RTRIM$(argg$))
DEF SEG = VARSEG(playergfx(0))
BLOAD "SPRITES\" + argg$ + ".PUT", VARPTR(playergfx(0))
DEF SEG
SELECT CASE charwithitem
CASE 1: placers = 8
CASE 2: placers = 88
CASE 3: placers = 168
CASE ELSE: placers = 248
END SELECT
VSSprite VARSEG(playergfx(0 * monsteroffset)), VARPTR(playergfx(0 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
VSDelay 20
Buffer2toBuffer1
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
UpdateCharStats
UpdateScreen
enemy = chartogetitem - 4
starty = 80
startx = monsterx(enemy) - 20
SoundEffect 12
argloopy:
Buffer2toBuffer1
VSSprite VARSEG(drainsprite(0)), VARPTR(drainsprite(0)), startx, starty, VARSEG(buffer1(0)), VARPTR(buffer1(0))
VSSprite VARSEG(playergfx(1 * monsteroffset)), VARPTR(playergfx(1 * monsteroffset)), placers, 78, VARSEG(buffer1(0)), VARPTR(buffer1(0))
starty = starty - 5: startx = startx + 5
IF starty < -30 THEN GOTO donedraining
UpdateCharStats
UpdateScreen
checkkeys
GOTO argloopy

donedraining:
drain = INT(RND(1) * 20) + 5 + nstat(charwithitem, 9)
monsterstat(enemy, 4) = monsterstat(enemy, 4) - drain
Buffer2toBuffer1
rr$ = STR$(drain)
VSFont VARSEG(buffer1(0)), VARPTR(buffer1(0)), monsterx(enemy), 10, rr$, 63, 60
UpdateCharStats
UpdateScreen
VSDelay 75
Buffer2toBuffer1
RestoreBackground

END SUB

SUB VSBlendPalettes (file1$, file2$)
   DIM Palvar1(255) AS LONG
   DIM Palvar2(255) AS LONG
   DEF SEG = VARSEG(Palvar1(0))
   IF file1$ <> "" THEN BLOAD file1$ + ".pal", VARPTR(Palvar1(0))
   DEF SEG = VARSEG(Palvar2(0))
   IF file2$ <> "" THEN BLOAD file2$ + ".pal", VARPTR(Palvar2(0))
   FOR temp1% = 0 TO 64
      FOR temp2% = 0 TO 255
	 OUT &H3C8, temp2%
	 DEF SEG = VARSEG(Palvar1(0))
	 temp11% = PEEK(VARPTR(Palvar1(temp2%)))
	 temp12% = PEEK(VARPTR(Palvar1(temp2%)) + 1)
	 temp13% = PEEK(VARPTR(Palvar1(temp2%)) + 2)
	 DEF SEG = VARSEG(Palvar2(0))
	 temp21% = PEEK(VARPTR(Palvar2(temp2%)))
	 temp22% = PEEK(VARPTR(Palvar2(temp2%)) + 1)
	 temp23% = PEEK(VARPTR(Palvar2(temp2%)) + 2)
	 OUT &H3C9, (temp11% * (64 - temp1%) + temp21% * temp1%) \ 64
	 OUT &H3C9, (temp12% * (64 - temp1%) + temp22% * temp1%) \ 64
	 OUT &H3C9, (temp13% * (64 - temp1%) + temp23% * temp1%) \ 64
      NEXT
      WAIT &H3DA, 8
      WAIT &H3DA, 8
      WAIT &H3DA, 8
   NEXT
   DEF SEG = &HA000
END SUB

SUB waitforit
DO
a$ = INKEY$
IF a$ = "~" THEN SaveScreen
LOOP WHILE a$ = ""

END SUB

SUB WaitOnetime
FOR abug = 1 TO 10
VSDelay 30
a$ = INKEY$
IF a$ <> "" THEN EXIT FOR
NEXT abug
END SUB

SUB yesorno
argggg:
a$ = INKEY$: IF a$ = "" THEN GOTO argggg
IF a$ = "Y" OR a$ = "y" THEN
	VSFadeBlack 64
	IF detectedsound = 1 THEN
		FadeVolumeOut
		StopMusic
		StopOutput
		UnloadModule
		FreeMSE
	END IF
	setvm 0
	SCREEN 0: WIDTH 80
	PRINT "THE WRATH OF SONA beta version 0.21"
	END
END IF
END SUB

