' Wurmi - der gefrssige Apfelwurm
' (c) 1999 by Andreas Meile, CH-8242 Hofen SH
' e-Mail: andreas@hofen.ch
' WWW: http://www.hofen.ch/~andreas/

DECLARE SUB RelSound (Freq%, dauer!)
DECLARE SUB SoundSlide (f1!, f2!, dauer!)
DECLARE SUB ZeichneLevel ()
DECLARE SUB FuehreWurmfutter (i%)
DECLARE SUB FuehreLaenge ()
DECLARE SUB FuehreSchluessel (n%, i%)
DECLARE SUB FuehreGeschwindigkeit ()
DECLARE SUB FuehreZeit (dt%)
DECLARE SUB ZeichneFeldchen (x%, y%)
DECLARE SUB GibSymbolAus (S%, x%, y%)
DECLARE SUB InitialisiereLevel ()
DECLARE SUB ZeichneStartWurm ()
DECLARE SUB LadeLevel ()
DECLARE SUB SpeichereLevel ()
DECLARE FUNCTION FuehrNull$ (w%, a%)
DECLARE FUNCTION GenerierePasswort$ (n%)
DECLARE FUNCTION PruefePasswort% (pwd$)

DIM SHARED f%(1 TO 39, 1 TO 24), ri%(0 TO 1023)
DIM SHARED fa%(0 TO 23), fh%(0 TO 23), el%(0 TO 23)
DIM SHARED rx%(3), ry%(3), wdt%, px%, py%, pxAlt%, pyAlt%
DIM SHARED Lev%, ap%, iSchwanz%, iKopf%, schl%(0 TO 3)
DIM SHARED zeit%, geschwStu%, geschw!, tit$, SoundEin%
DIM SHARED pwd$

CONST MinSoundL! = 2.272728E-02

' Tabellen initialisieren
FOR i% = 0 TO 23
	READ fa%(i%), fh%(i%), el%(i%)
NEXT i%
DATA 7, 0, 32, 8, 7, 219, 10, 0, 6, 2, 0, 5
DATA 11, 3, 37, 15, 0, 9, 14, 0, 7, 6, 0, 254
DATA 7, 0, 16, 7, 0, 30, 7, 0, 17, 7, 0, 31
DATA 7, 0, 26, 7, 0, 24, 7, 0, 27, 7, 0, 25
DATA 13, 0, 235, 12, 0, 235, 9, 0, 235, 11, 0, 235
DATA 0, 5, 177, 0, 4, 177, 0, 1, 177, 0, 3, 177

rx%(0) = 1: ry%(0) = 0
FOR i% = 1 TO 3
	rx%(i%) = ry%(i% - 1)
	ry%(i%) = -rx%(i% - 1)
NEXT i%

SCREEN 0
WIDTH 40, 25
wdt% = 80

pwd$ = GenerierePasswort$(1)
SoundEin% = -1
DO
	COLOR 7, 0, 0
	CLS
	LOCATE 3, 5, 0
	COLOR 13
	PRINT "Wurmi - der gefrssige Apfelwurm"
	LOCATE 4, 8
	COLOR 2
	PRINT "(c) 1999 by Andreas Meile"
	LOCATE 5, 9
	COLOR 4
	PRINT "e-Mail: ";
	COLOR 11
	PRINT "andreas@hofen.ch"
	LOCATE 6, 4
	COLOR 4
	PRINT "WWW: ";
	COLOR 11
	PRINT "http://www.hofen.ch/~andreas/"
	LOCATE 8, 11
	COLOR 14
	PRINT "Whle aus:"
	LOCATE 10, 11
	COLOR 1, 7
	PRINT "F1";
	COLOR 6, 0
	PRINT " Spiel"
	LOCATE 12, 11
	COLOR 1, 7
	PRINT "F2";
	COLOR 6, 0
	PRINT " Editor"
	LOCATE 14, 11
	COLOR 1, 7
	PRINT "F3";
	COLOR 6, 0
	PRINT " Anleitung"
	LOCATE 16, 11
	COLOR 1, 7
	PRINT "F4";
	COLOR 6, 0
	PRINT " Ende"

	DO
		DO
			tt$ = INKEY$
		LOOP WHILE tt$ = ""
		SELECT CASE tt$
		CASE CHR$(0) + ";"
			GOSUB Spielen
		CASE CHR$(0) + "<"
			GOSUB Editor
		CASE CHR$(0) + "="
			GOSUB Anleitung
		END SELECT
	LOOP UNTIL tt$ >= CHR$(0) + ";" AND tt$ <= CHR$(0) + ">"
LOOP UNTIL tt$ = CHR$(0) + ">"

WIDTH 80, 25
COLOR 7, 0, 0
CLS
PRINT "Wurmi beendet."
END

' +-------------+
' | Leveleditor |
' +-------------+
Editor:

SCREEN 0
WIDTH 80, 50
wdt% = 160
COLOR 4, 0, 0
CLS

' Legende
FOR i% = 0 TO 23
	COLOR 7, 0
	LOCATE i% + 1, 42
	PRINT CHR$(65 + i%); "=";
	GibSymbolAus i%, 44, i% + 1
NEXT i%
COLOR 7, 0
LOCATE 1, 47: PRINT "1=Wurm plazieren & ausrichten"
LOCATE 2, 47: PRINT "2=Zeit & Geschwindigkeit eingeben"
LOCATE 3, 47: PRINT "3=Level laden"
LOCATE 4, 47: PRINT "4=Level speichern"
LOCATE 5, 47: PRINT "5=Rechteck: Ecke plazieren"
LOCATE 6, 47: PRINT "6=Rechteck: Zeichnen"
LOCATE 7, 47: PRINT "7=Levelspeicher lschen"
LOCATE 8, 47: PRINT "8=Zufalls-Fruchverteilung"
LOCATE 9, 47: PRINT "9=Vorspanntext eingeben"
LOCATE 11, 47: PRINT "Leertaste=Malmodus: aus"
LOCATE 12, 47: PRINT "Return=Zeichnen"
LOCATE 13, 47: PRINT "Esc=Ende"

cx% = 19
cy% = 13
hx% = cx%
hy% = cy%
ft% = 0
malenEin% = 0
COLOR 15
LOCATE 1, 41
PRINT CHR$(16);
LOCATE , 45
PRINT CHR$(17);

' Zu Beginn leerer Speicher
InitialisiereLevel   ' Levelspeicher mit Leerlevel initialisieren
ZeichneLevel         ' und ausgeben
Lev% = 1

DO
	LOCATE cy%, cx%, 1, 2, 6
	DO
		t$ = INKEY$
	LOOP WHILE t$ = ""
	LOCATE , , 0
	SELECT CASE t$
	CASE "A" TO "X", "a" TO "x"
		COLOR 15, 0
		LOCATE 1 + ft%, 41: PRINT " ";
		LOCATE , 45: PRINT " ";
		ft% = (ASC(t$) - 65) AND 31
		LOCATE 1 + ft%, 41: PRINT CHR$(16);
		LOCATE , 45: PRINT CHR$(17);
		IF malenEin% AND f%(cx%, cy%) < 256 THEN
			f%(cx%, cy%) = ft%
			ZeichneFeldchen cx%, cy%
		END IF
	CASE CHR$(0) + "H"
		IF malenEin% AND f%(cx%, cy%) < 256 THEN
			IF ft% >= 8 AND ft% < 16 THEN
				f%(cx%, cy%) = ft% AND -4 OR 1
			ELSE
				f%(cx%, cy%) = ft%
			END IF
			ZeichneFeldchen cx%, cy%
		END IF
		cy% = cy% - 1
		IF cy% < 2 THEN
			cy% = 23
		END IF
	CASE CHR$(0) + "K"
		IF malenEin% AND f%(cx%, cy%) < 256 THEN
			IF ft% >= 8 AND ft% < 16 THEN
				f%(cx%, cy%) = ft% AND -4 OR 2
			ELSE
				f%(cx%, cy%) = ft%
			END IF
			ZeichneFeldchen cx%, cy%
		END IF
		cx% = cx% - 1
		IF cx% < 2 THEN
			cx% = 38
		END IF
	CASE CHR$(0) + "M"
		IF malenEin% AND f%(cx%, cy%) < 256 THEN
			IF ft% >= 8 AND ft% < 16 THEN
				f%(cx%, cy%) = ft% AND -4
			ELSE
				f%(cx%, cy%) = ft%
			END IF
			ZeichneFeldchen cx%, cy%
		END IF
		cx% = cx% + 1
		IF cx% > 38 THEN
			cx% = 2
		END IF
	CASE CHR$(0) + "P"
		IF malenEin% AND f%(cx%, cy%) < 256 THEN
			IF ft% >= 8 AND ft% < 16 THEN
				f%(cx%, cy%) = ft% AND -4 OR 3
			ELSE
				f%(cx%, cy%) = ft%
			END IF
			ZeichneFeldchen cx%, cy%
		END IF
		cy% = cy% + 1
		IF cy% > 23 THEN
			cy% = 2
		END IF
	CASE " "
		malenEin% = NOT malenEin%
		COLOR 7, 0
		LOCATE 11, 67
		IF malenEin% THEN
			PRINT "ein"
		ELSE
			PRINT "aus"
		END IF
	CASE CHR$(13)
		IF f%(cx%, cy%) < 256 THEN
			f%(cx%, cy%) = ft%
			ZeichneFeldchen cx%, cy%
		END IF
	CASE "1"
		f%(px%, py%) = 0
		ZeichneFeldchen px%, py%
		f%(pxAlt%, pyAlt%) = 0
		ZeichneFeldchen pxAlt%, pyAlt%
		px% = cx%
		py% = cy%
		COLOR 30, 0
		LOCATE py%, px%
		PRINT CHR$(2);
		COLOR 7
		LOCATE 23, 47
		PRINT "Startrichtung mit Pfeiltaste"
		Drinbleib% = -1
		WHILE Drinbleib%
			DO
				t$ = INKEY$
			LOOP WHILE t$ = ""
			IF t$ = CHR$(0) + "M" AND px% > 2 THEN
				ri%(iSchwanz%) = 0
				Drinbleib% = 0
			ELSEIF t$ = CHR$(0) + "H" AND py% < 23 THEN
				ri%(iSchwanz%) = 1
				Drinbleib% = 0
			ELSEIF t$ = CHR$(0) + "K" AND px% < 38 THEN
				ri%(iSchwanz%) = 2
				Drinbleib% = 0
			ELSEIF t$ = CHR$(0) + "P" AND py% > 2 THEN
				ri%(iSchwanz%) = 3
				Drinbleib% = 0
			END IF
		WEND
		ri%(iSchwanz% - 1) = ri%(iSchwanz%)
		ZeichneStartWurm
		LOCATE 23, 47
		PRINT SPACE$(28)
	CASE "2"
		COLOR 7, 0
		LOCATE 18, 47: PRINT "Geschwindigkeitsstufe"
		LOCATE 19, 47: PRINT "Aktuell: ";
		IF geschwStu% THEN
			PRINT CHR$(geschwStu%)
		ELSE
			PRINT "S"
		END IF
		LOCATE 20, 47: INPUT "Neuer Wert"; g$
		IF g$ >= "0" AND g$ <= "9" THEN
			geschwStu% = ASC(g$)
		ELSE
			geschwStu% = 0
		END IF
		LOCATE 21, 47: PRINT "Spielzeit in Sek."
		LOCATE 22, 47: PRINT "Aktuell:"; zeit%
		LOCATE 23, 47: INPUT "Neuer Wert"; zeit%
		FOR i% = 18 TO 23
			LOCATE i%, 47
			PRINT SPACE$(33)
		NEXT i%
	CASE "3"
		COLOR 7, 0
		LOCATE 18, 47
		INPUT "Lade Levelnummer"; Lev%
		LadeLevel
		LOCATE 18, 47
		PRINT SPACE$(33)
		ZeichneLevel
	CASE "4"
		COLOR 7, 0
		LOCATE 18, 47
		INPUT "Speichere Levelnummer"; Lev%
		SpeichereLevel
		LOCATE 18, 47
		PRINT SPACE$(33)
	CASE "5"
		hx% = cx%
		hy% = cy%
	CASE "6"
		h1x% = hx%: h1y% = hy%
		h2x% = cx%: h2y% = cy%
		IF h2x% < h1x% THEN
			SWAP h1x%, h2x%
		END IF
		IF h2y% < h1y% THEN
			SWAP h1y%, h2y%
		END IF
		FOR y% = h1y% TO h2y%
			FOR x% = h1x% TO h2x%
				IF f%(x%, y%) < 256 THEN
					f%(x%, y%) = ft%
					ZeichneFeldchen x%, y%
				END IF
			NEXT x%
		NEXT y%
	CASE "7"
		InitialisiereLevel
		ZeichneLevel
	CASE "8"
		FOR y% = 2 TO 23
			FOR x% = 2 TO 38
				IF f%(x%, y%) = 0 OR f%(x%, y%) = 2 THEN
					IF RND < .15 THEN
						f%(x%, y%) = 2
					ELSE
						f%(x%, y%) = 0
					END IF
					ZeichneFeldchen x%, y%
				END IF
			NEXT x%
		NEXT y%
	CASE "9"
		COLOR 7, 0
		LOCATE 18, 47: PRINT "Bisheriger Text:"
		LOCATE 19, 47: PRINT tit$
		LOCATE 20, 47: PRINT "Neuer Text:"
		LOCATE 21, 47: LINE INPUT tit$
		FOR i% = 18 TO 21
			LOCATE i%, 47
			PRINT SPACE$(33)
		NEXT i%
	END SELECT
LOOP UNTIL t$ = CHR$(27)
WIDTH 40, 25
wdt% = 80
RETURN

' +-------+
' | Spiel |
' +-------+

' Start Spiel
Spielen:
DO
	COLOR 2, 0
	CLS
	LOCATE 10, 4
	PRINT "Geben Sie ein Passwort ein, um bei"
	LOCATE 11, 4
	PRINT "einem hheren Level starten"
	COLOR 11
	p% = 0
	DO
		LOCATE 13, 16
		PRINT pwd$;
		LOCATE , 16 + p%, 1
		DO
			t$ = INKEY$
		LOOP WHILE t$ = ""
		LOCATE , , 0
		SELECT CASE t$
		CASE CHR$(0) + "K", CHR$(8)
			p% = (p% + 5) MOD 6
		CASE CHR$(0) + "M", " "
			p% = (p% + 1) MOD 6
		CASE "0" TO "9"
			MID$(pwd$, p% + 1) = t$
			p% = (p% + 1) MOD 6
		CASE "A" TO "Z", "a" TO "v"
			MID$(pwd$, p% + 1) = UCASE$(t$)
			p% = (p% + 1) MOD 6
		END SELECT
	LOOP UNTIL t$ = CHR$(13) OR t$ = CHR$(27)
	IF t$ = CHR$(27) THEN EXIT DO
	Lev% = PruefePasswort(pwd$)
	IF Lev% < 1 OR Lev% > 99 THEN
		Lev% = 1
		pwd$ = GenerierePasswort$(1)
	END IF
	InitialisiereLevel
	LadeLevel
	COLOR 14, 0
	CLS
	LOCATE 11, 16
	PRINT USING "Level ##:"; Lev%
	LOCATE 13, 21 - LEN(tit$) \ 2
	COLOR 12
	PRINT tit$
	LOCATE 15, 13
	COLOR 9
	PRINT "Weiter mit Taste"
	WHILE INKEY$ = ""
	WEND
	GOSUB SpielLevel
	IF Drinbleib% THEN
		IF SoundEin% THEN
			PLAY "mfo3t90l16cdecdl8el16<b>l8dl4c."
		END IF
		Lev% = Lev% + 1
		pwd$ = GenerierePasswort$(Lev%)
		COLOR 12
		LOCATE 12, 5
		PRINT ""; STRING$(30, 205); "";
		LOCATE 13, 5
		PRINT "";
		COLOR 11
		PRINT USING "Passwort fr Level ###: "; Lev%;
		COLOR 14
		PRINT pwd$;
		COLOR 12
		PRINT "";
		LOCATE 14, 5
		PRINT ""; STRING$(30, 205); "";
		WHILE INKEY$ = ""
		WEND
	ELSE
		IF SoundEin% AND NOT Abbruch% THEN
			PLAY "mft150o2l4cl8c.l16cl4cl8d#.l16dl8d.l16cl8c.l16<bl4>c"
		END IF
	END IF
LOOP
RETURN

SpielLevel:
InitialisiereLevel
LadeLevel
ZeichneLevel
LOCATE 25, 1
COLOR 7, 0: PRINT "L";
COLOR 15: PRINT FuehrNull$(Lev%, 2); " ";
COLOR 2: PRINT "t";
COLOR 7: PRINT "--:-- ";
COLOR 14: PRINT CHR$(26); "? ";
COLOR 10: PRINT CHR$(6); "00X ";
COLOR 9: PRINT CHR$(18); "00X ";
COLOR 5: PRINT "0X ";
COLOR 4: PRINT "0X ";
COLOR 9: PRINT "0X ";
COLOR 11: PRINT "0X";
FuehreWurmfutter 0
FuehreGeschwindigkeit
IF zeit% > 0 THEN
	FuehreZeit 0
END IF
FuehreLaenge
FOR i% = 0 TO 3
	schl%(i%) = 0
	FuehreSchluessel i%, 0
NEXT i%

Drinbleib% = -1
lenkbar% = -1
riNeu% = ri%(iKopf%)
BewFl% = 0
AutoBeweg% = 0
Abbruch% = 0
IF geschwStu% THEN
	COLOR 30, 0
	LOCATE py%, px%
	PRINT CHR$(2);
	WHILE INKEY$ = ""
	WEND
END IF
tStopp! = TIMER + 1!
ZeichneStartWurm
IF geschwStu% THEN
	t! = TIMER + geschw!
ELSE
	t! = 1E+20
END IF

WHILE Drinbleib% AND ap% > 0
	ta$ = INKEY$
	IF ta$ <> "" THEN
		SELECT CASE ta$
		CASE CHR$(0) + "M"
			IF ri%(iKopf%) <> 2 AND lenkbar% THEN
				riNeu% = 0
				IF geschwStu% = 0 THEN
					BewFl% = -1
				END IF
			END IF
		CASE CHR$(0) + "H"
			IF ri%(iKopf%) <> 3 AND lenkbar% THEN
				riNeu% = 1
				IF geschwStu% = 0 THEN
					BewFl% = -1
				END IF
			END IF
		CASE CHR$(0) + "K"
			IF ri%(iKopf%) <> 0 AND lenkbar% THEN
				riNeu% = 2
				IF geschwStu% = 0 THEN
					BewFl% = -1
				END IF
			END IF
		CASE CHR$(0) + "P"
			IF ri%(iKopf%) <> 1 AND lenkbar% THEN
				riNeu% = 3
				IF geschwStu% = 0 THEN
					BewFl% = -1
				END IF
			END IF
		CASE "S", "s"
			SoundEin% = NOT SoundEin%
		CASE " "
			IF geschwStu% THEN
				dt! = t! - TIMER
			END IF
			IF zeit% > 0 THEN
				dtStopp! = tStopp! - TIMER
			END IF
			IF zeit% > 0 OR geschwStu% THEN
				COLOR 11, 0
				LOCATE 25, 6: PRINT "Pause";
				WHILE INKEY$ = ""
				WEND
				IF zeit% = 0 THEN
					COLOR 7
					LOCATE 25, 6: PRINT "--:--";
				ELSE
					FuehreZeit 0
				END IF
			END IF
			IF zeit% > 0 THEN
				tStopp! = TIMER + dtStopp!
			END IF
			IF geschwStu% THEN
				t! = TIMER + dt!
			END IF
		CASE CHR$(27)
			Drinbleib% = 0
			Abbruch% = -1
		END SELECT
	END IF
	IF zeit% > 0 AND TIMER >= tStopp! THEN
		FuehreZeit -1
		tStopp! = tStopp! + 1!
		IF zeit% = 0 THEN
			Drinbleib% = 0   ' Spielzeit ausgegangen
		END IF
	END IF
	IF TIMER >= t! OR BewFl% THEN
		LOCATE py%, px%
		COLOR 9, fh%(f%(px%, py%) AND 255)
		PRINT MID$("ͼ?ɺ???", 1 + 4 * ri%(iKopf%) + riNeu%, 1);
		px% = px% + rx%(riNeu%)
		py% = py% + ry%(riNeu%)
		iKopf% = iKopf% + 1 AND 1023
		ri%(iKopf%) = riNeu%
		IF f%(px%, py%) <> 2 THEN
			GOSUB SchwanzNachziehen
		END IF
		LOCATE py%, px%
		COLOR 14, fh%(f%(px%, py%) AND 255)
		PRINT CHR$(2);
		lenkbar% = -1
		SELECT CASE f%(px%, py%)
		CASE 0    ' Leerer Durchgang
			RelSound 50, 1!
		CASE 1    ' Mauer
			Drinbleib% = 0
		CASE 2    ' Futter, welches aufgesammelt werden muss
			SoundSlide 450!, 650!, 2.625
			FuehreWurmfutter -1
			FuehreLaenge
			f%(px%, py%) = 0
		CASE 3    ' Extrazeit-Kraut
			IF zeit% > 0 THEN
				FuehreZeit 5
			END IF
			RelSound 400, 9!
			RelSound 800, 6!
			f%(px%, py%) = 0
		CASE 4    ' Glatteis
			lenkbar% = 0
			FOR i% = 1 TO 2
				RelSound 440, 4!
				RelSound 410, 4!
			NEXT i%
		CASE 5    ' Ditpille
			FOR i% = 70 TO 40 STEP -5
				RelSound 10 * i%, .5
				RelSound 3 * i%, .5
			NEXT i%
			GOSUB SchwanzNachziehen
			IF (iSchwanz% - iKopf% AND 1023) = 1 THEN
				Drinbleib% = 0
			ELSE
				FuehreLaenge
			END IF
			f%(px%, py%) = 0
		CASE 6   ' Beschleuniger-Pille
			FOR i% = 60 TO 80 STEP 4
				RelSound 5 * i%, 1!
				RelSound 4 * i%, 1!
			NEXT i%
			IF geschwStu% = 0 THEN
				geschwStu% = 48
				FuehreGeschwindigkeit
				t! = TIMER + geschw!
			ELSEIF geschwStu% = 57 THEN
				Drinbleib% = 0
			ELSE
				geschwStu% = geschwStu% + 1
				FuehreGeschwindigkeit
			END IF
			f%(px%, py%) = 0
		CASE 7   ' Abbremspille
			FOR i% = 80 TO 60 STEP -4
				RelSound 4 * i%, 1!
				RelSound 5 * i%, 1!
			NEXT i%
			IF geschwStu% = 0 THEN
				Drinbleib% = 0
			ELSEIF geschwStu% = 48 THEN
				geschwStu% = 0
				FuehreGeschwindigkeit
				t! = 1E+20
			ELSE
				geschwStu% = geschwStu% - 1
				FuehreGeschwindigkeit
			END IF
			f%(px%, py%) = 0
		CASE 8 TO 11 ' feste Weispfeile
			SoundSlide 780!, 940!, 4!
			SoundSlide 940!, 780!, 4!
			lenkbar% = 0
			IF (riNeu% - f%(px%, py%) AND 3) = 2 THEN
				Drinbleib% = 0
			ELSE
				riNeu% = f%(px%, py%) AND 3
			END IF
		CASE 12 TO 15 ' auffressbare Einwegpfeile
			RelSound 1760, 4!
			RelSound 2217, 4!
			RelSound 2637, 4!
			RelSound 3520, 4!
			lenkbar% = 0
			IF (riNeu% - f%(px%, py%) AND 3) = 2 THEN
				Drinbleib% = 0
			ELSE
				riNeu% = f%(px%, py%) AND 3
			END IF
			f%(px%, py%) = 0
		CASE 16 TO 19  ' Schlssel/"Bohrer"
			RelSound 262, 4!
			RelSound 349, 4!
			RelSound 440, 4!
			RelSound 349, 4!
			RelSound 440, 4!
			FuehreSchluessel f%(px%, py%) AND 3, 1
			f%(px%, py%) = 0
		CASE 20 TO 23  ' Tre/bohrbarer "Granit"
			IF schl%(f%(px%, py%) AND 3) > 0 THEN
				FOR i% = 0 TO 4
					RelSound 42, 2!
					RelSound 0, 2!
				NEXT i%
				FuehreSchluessel f%(px%, py%) AND 3, -1
				f%(px%, py%) = 0
			ELSE
				Drinbleib% = 0
			END IF
		CASE 256 TO 511
			Drinbleib% = 0
		END SELECT
		f%(px%, py%) = f%(px%, py%) OR 256
		LOCATE py%, px%
		COLOR 14, fh%(f%(px%, py%) AND 255)
		PRINT CHR$(2);
		IF geschwStu% THEN
			t! = t! + geschw!
		END IF
		IF AutoBeweg% THEN
			IF lenkbar% THEN
				t! = 1E+20
				AutoBeweg% = 0
			ELSE
				t! = t! + .1
			END IF
		END IF
		IF BewFl% THEN
			BewFl% = 0
			IF NOT lenkbar% THEN
				t! = TIMER + .1
				AutoBeweg% = -1
			END IF
		END IF
	END IF
WEND

IF NOT (Drinbleib% OR Abbruch%) THEN  ' Verlust eines Lebens
	t! = TIMER
	FOR i% = 1 TO 20
		LOCATE py%, px%
		COLOR 1 + CINT(INT(15! * RND))
		PRINT CHR$(15);
		IF SoundEin% THEN
			SOUND 40! + 400! * RND, .25
		END IF
		t! = t! + .05
		WHILE TIMER < t!
		WEND
	NEXT i%
	LOCATE py%, px%
	COLOR 4
	PRINT CHR$(15);
END IF
RETURN

SchwanzNachziehen:
f%(pxAlt%, pyAlt%) = f%(pxAlt%, pyAlt%) AND NOT 256
ZeichneFeldchen pxAlt%, pyAlt%
pxAlt% = pxAlt% + rx%(ri%(iSchwanz%))
pyAlt% = pyAlt% + ry%(ri%(iSchwanz%))
iSchwanz% = iSchwanz% + 1 AND 1023
LOCATE pyAlt%, pxAlt%
COLOR 1, fh%(f%(pxAlt%, pyAlt%) AND 255)
PRINT MID$("?ڳ???ٳ", 1 + 4 * ri%(iSchwanz% - 1 AND 1023) + ri%(iSchwanz%), 1);
RETURN

Anleitung:
Seite% = 1
DO
	COLOR 2, 0
	CLS
	PRINT "Wurmi - der Apfelwurm - Seite"; Seite%; "von 4"
	COLOR 1
	PRINT STRING$(39, 205)
	COLOR 7
	PRINT
	SELECT CASE Seite%
	CASE 1
		PRINT "Sie sind Wurmi ";
		COLOR 1: PRINT "";
		COLOR 9: PRINT "";
		COLOR 14: PRINT CHR$(2);
		COLOR 7: PRINT ", der gefrssige"
		PRINT "Apfelwurm. Ihre Aufgabe ist es, smt-"
		PRINT "liche pfel ";
		COLOR 10: PRINT STRING$(3, 6);
		COLOR 7: PRINT " aufzufressen. Doch auf-"
		PRINT "gepasst: Mit jedem Apfel wird Wurmi um"
		PRINT "ein Glied (";
		COLOR 9: PRINT "";
		COLOR 7: PRINT ") lnger! Anzeige: ";
		COLOR 9: PRINT CHR$(18);
		COLOR 15: PRINT "018";
		COLOR 7: PRINT "=Ln-"
		PRINT "ge, ";
		COLOR 10: PRINT CHR$(6);
		COLOR 15: PRINT "023";
		COLOR 7: PRINT "=brige pfel. Ein Biss in die"
		PRINT "Mauer (";
		COLOR 8: PRINT "";
		COLOR 7: PRINT ") oder in den eigenen Hinter-"
		PRINT "leib kostet Sie Ihr Wurmleben! ";
		COLOR 4: PRINT CHR$(15);
		COLOR 9: PRINT "";
		COLOR 1: PRINT "";
		COLOR 7: PRINT " Nach"
		PRINT "jedem Level erhalten Sie ein Passwort,"
		PRINT "um weiterspielen zu knnen."
		PRINT
		PRINT "Die Steuerung erfolgt mit den ";
		COLOR 4: PRINT "Pfeil-"
		PRINT "tasten ";
		COLOR 4, 7: PRINT CHR$(26);
		COLOR 7, 0: PRINT ", ";
		COLOR 4, 7: PRINT CHR$(24);
		COLOR 7, 0: PRINT ", ";
		COLOR 4, 7: PRINT CHR$(27);
		COLOR 7, 0: PRINT " und ";
		COLOR 4, 7: PRINT CHR$(25);
		COLOR 7, 0: PRINT ".";
		COLOR 7: PRINT " Mit der"
		COLOR 4, 7: PRINT "  Leertaste  ";
		COLOR 7, 0: PRINT " knnen Sie Wurmi eine"
		PRINT "Pause verordnen (kurzzeitiger Unter-"
		PRINT "bruch des Spiels), mit ";
		COLOR 4, 7: PRINT "S";
		COLOR 7, 0: PRINT " kann der Ton"
		PRINT "ein- und ausgeschaltet werden. Ein Ab-"
		PRINT "bruch des Spiels ist jederzeit mit ";
		COLOR 4, 7: PRINT "Esc"
		COLOR 7, 0: PRINT "mglich."
	CASE 2
		PRINT "Leider besitzt Wurmi nur schwache Zhn-"
		PRINT "chen, so dass er sich nicht durch die"
		PRINT "verschiedenen Humusschichten (";
		COLOR 0, 5: PRINT "";
		COLOR , 4: PRINT "";
		COLOR , 1: PRINT "";
		COLOR , 3: PRINT "";
		COLOR 7, 0: PRINT ")"
		PRINT "bohren kann. Zu diesem Zweck muss Wurmi"
		PRINT "Bohrschlssel (";
		COLOR 13: PRINT "";
		COLOR 12: PRINT "";
		COLOR 9: PRINT "";
		COLOR 11: PRINT "";
		COLOR 7: PRINT ") in den entspre-"
		PRINT "chenden Farben aufsammeln, wobei je ein"
		PRINT "Schlssel ";
		COLOR 12: PRINT "";
		COLOR 7: PRINT " pro Humusfeld ";
		COLOR 0, 4: PRINT "";
		COLOR 7, 0: PRINT " verbraucht"
		PRINT "wird. Anzeige: ";
		COLOR 5: PRINT "";
		COLOR 15: PRINT "04 ";
		COLOR 4: PRINT "";
		COLOR 15: PRINT "01 ";
		COLOR 1: PRINT "";
		COLOR 15: PRINT "12 ";
		COLOR 3: PRINT "";
		COLOR 15: PRINT "07";
		COLOR 7: PRINT "=Anzahl"
		PRINT "Bohrschlssel der jeweiligen Farbe."
		PRINT
		PRINT "Wurmi besitzt ausserdem keine allzu"
		PRINT "gute Kriechsohle, so dass er seine"
		PRINT "Steuerbarkeit auf dem Glatteis (";
		COLOR 11, 3: PRINT "%%%";
		COLOR 7, 0: PRINT ")"
		PRINT "verliert oder von den Keildreiecken"
		PRINT "(";
		GibSymbolAus 11, POS(0), CSRLIN
		PRINT STRING$(2, 16);
		GibSymbolAus 9, POS(0), CSRLIN
		PRINT ") in die entsprechende Richtung"
		PRINT "getrieben wird. Frisst er dabei einen"
		PRINT "Pfeil ("; CHR$(24); CHR$(25); CHR$(26); CHR$(27); ") auf, so wird er ebenfalls"
		PRINT "umhergetrieben, was besonders bei"
		PRINT "Pfeilketten ("; STRING$(2, 26); CHR$(24); ") seine manchmals"
		PRINT "verheerende Wirkung zeigen kann."
	CASE 3
		PRINT "In manchen Rumen sengt noch zustzlich"
		PRINT "die Sonne herunter, so dass Wurmi seine"
		PRINT "noch verbleibende Zeit zum berleben"
		PRINT "unten bei der Stoppuhr (";
		COLOR 2: PRINT "t";
		COLOR 15: PRINT "01:14";
		COLOR 7: PRINT ") sehen"
		PRINT "kann. In schattigen Rumen besteht die-"
		PRINT "ses Problem glcklicherweise nicht, was"
		PRINT "als ";
		COLOR 2: PRINT "t";
		COLOR 7: PRINT "--:-- angezeigt wird. Die pfel ";
		COLOR 10: PRINT STRING$(2, 6)
		COLOR 7: PRINT "sind dabei zu wenig saftig, um berle-"
		PRINT "benshilfe bieten zu knnen, jedoch"
		PRINT "wchst an diversen Stellen saftiger Klee"
		COLOR 2: PRINT STRING$(3, 5);
		COLOR 7: PRINT ", so dass Wurmis Feuchtigkeitshaus-"
		PRINT "halt mit jeder Kleepflanze ";
		COLOR 2: PRINT CHR$(5);
		COLOR 7: PRINT " um 5 Sekun-"
		PRINT "den verbessert wird. Eine rote Anzeige"
		COLOR 2: PRINT "t";
		COLOR 12: PRINT "00:03";
		COLOR 7: PRINT " mit einem Signalton warnt"
		PRINT "brigens vor einem kurz bevorstehenden"
		PRINT "Austrocknungstod."
	CASE 4
		PRINT "Auch der Adrenalinspiegel variiert bei"
		PRINT "Wurmi sehr krftig; von total mde (";
		COLOR 14: PRINT CHR$(26);
		COLOR 7: PRINT "S"
		PRINT "unten), so dass Sie Wurmi jeden einzel-"
		PRINT "nen Schritt zeigen mssen, ist Wurmi"
		PRINT "von sehr lahm (";
		COLOR 14: PRINT CHR$(26);
		COLOR 15: PRINT "0";
		COLOR 7: PRINT "), so dass Sie ihn mit"
		PRINT "Beschleunigerpillen ";
		GibSymbolAus 6, POS(0), CSRLIN
		GibSymbolAus 6, POS(0), CSRLIN: COLOR 7: PRINT " etwas Kick"
		PRINT "verpassen knnen, bis kaum zum Bremsen"
		PRINT "(";
		COLOR 14: PRINT CHR$(26);
		COLOR 15: PRINT "9";
		COLOR 7: PRINT "), so dass Sie ihn mit Bremspillen"
		COLOR 6: PRINT "";
		COLOR 7: PRINT " etwas beruhigen sollten, in allen"
		PRINT "nur erdenklichen Stimmungslagen vorzu-"
		PRINT "finden."
		PRINT
		PRINT "Zum Glck liegen auch Schlankheitspillen"
		GibSymbolAus 5, POS(0), CSRLIN
		GibSymbolAus 5, POS(0), CSRLIN
		COLOR 7: PRINT " herum, so dass Sie Wurmi eine Dit-"
		PRINT "kur verpassen knnen, denn mit jeder"
		PRINT "Pille verliert Wurmi je ein Glied ";
		COLOR 9: PRINT "";
		COLOR 7: PRINT "."
		PRINT "Doch allzuviel Dit schdigt Wurmi, so"
		PRINT "dass Sie bei einem minimalen Wurmi ";
		COLOR 14: PRINT "";
		COLOR 1: PRINT ""
		COLOR 7: PRINT "keine Dit verabreichen sollten."
	END SELECT
	LOCATE 24, 1
	COLOR 1
	PRINT STRING$(39, 205);
	LOCATE 25, 1
	COLOR 4, 7: PRINT "Bild"; CHR$(24);
	COLOR 2, 0: PRINT "/";
	COLOR 4, 7: PRINT "Bild"; CHR$(25);
	COLOR 2, 0: PRINT " Blttern ";
	COLOR 4, 7: PRINT "Esc";
	COLOR 2, 0: PRINT " Verlassen";
	DO
		t$ = INKEY$
	LOOP WHILE t$ = ""
	SELECT CASE t$
	CASE CHR$(0) + "H", CHR$(0) + "I"
		Seite% = (Seite% + 2) MOD 4 + 1
	CASE CHR$(0) + "P", CHR$(0) + "Q"
		Seite% = Seite% MOD 4 + 1
	CASE CHR$(0) + "G"
		Seite% = 1
	CASE CHR$(0) + "O"
		Seite% = 4
	END SELECT
LOOP UNTIL t$ = CHR$(27)
RETURN

SUB FuehreGeschwindigkeit
	LOCATE 25, 13
	IF geschwStu% THEN
		COLOR 15
		PRINT CHR$(geschwStu%);
		geschw! = .8 * 1.55 ^ CSNG(48 - geschwStu%)
	ELSE
		COLOR 7
		geschw! = 1!
		PRINT "S";
	END IF
END SUB

SUB FuehreLaenge
	LOCATE 25, 21
	COLOR 15, 0
	PRINT FuehrNull$(iKopf% - iSchwanz% + 2 AND 1023, 3);
END SUB

SUB FuehreSchluessel (n%, i%)
	schl%(n%) = schl%(n%) + i%
	LOCATE 25, 26 + 4 * n%
	COLOR 15, 0
	PRINT FuehrNull$(schl%(n%), 2);
END SUB

SUB FuehreWurmfutter (i%)
	ap% = ap% + i%
	LOCATE 25, 16
	COLOR 15, 0
	PRINT FuehrNull$(ap%, 3);
END SUB

SUB FuehreZeit (dt%)
	zeit% = zeit% + dt%
	LOCATE 25, 6
	IF zeit% <= 10 THEN
		COLOR 12, 0
		IF SoundEin% AND dt% < 0 THEN
			SOUND 2637, 1.5
			SOUND 2093, 2!
		END IF
	ELSE
		COLOR 15, 0
	END IF
	PRINT FuehrNull$(zeit% \ 60, 2); ":"; FuehrNull$(zeit% MOD 60, 2);
END SUB

' String mit fhrenden Nullen bilden
FUNCTION FuehrNull$ (w%, a%)
	h$ = MID$(STR$(w%), 2)
	FuehrNull$ = STRING$(a% - LEN(h$), "0") + h$
END FUNCTION

FUNCTION GenerierePasswort$ (n%)
	LevCod& = CLNG(n%) + 256& * (CLNG(n%) * 4019413 + 8172129 AND 4194303)
	co2& = 0&
	FOR i% = 1 TO 5
		co2& = 64& * co2& + ((LevCod& AND 63&) * 37& + 14& AND 63&)
		LevCod& = LevCod& \ 64&
	NEXT i%
	pw$ = ""
	FOR i% = 1 TO 6
		c% = CINT(co2& AND 31&) * 23 + 5 AND 31
		IF c% < 10 THEN
			pw$ = CHR$(48 + c%) + pw$
		ELSE
			pw$ = CHR$(55 + c%) + pw$
		END IF
		co2& = co2& \ 32&
	NEXT i%
	GenerierePasswort$ = pw$
END FUNCTION

SUB GibSymbolAus (S%, x%, y%)
	LOCATE y%, x%
	COLOR fa%(S%), fh%(S%)
	IF el%(S%) = 7 OR el%(S%) >= 9 AND el%(S%) <= 13 OR el%(S%) >= 28 AND el%(S%) <= 31 THEN
		PRINT "?";
		DEF SEG = &HB800
		POKE 2 * (x% - 1) + wdt% * (y% - 1), el%(S%)
	ELSE
		IF wdt% = 160 AND el%(S%) = 219 THEN
			PRINT "";
		ELSE
			PRINT CHR$(el%(S%));
		END IF
	END IF
END SUB

SUB InitialisiereLevel
	' Level initialisieren
	FOR y% = 2 TO 23
		f%(1, y%) = 1
		FOR x% = 2 TO 38
			f%(x%, y%) = 0
		NEXT x%
		f%(39, y%) = 1
	NEXT y%
	FOR x% = 1 TO 39
		f%(x%, 1) = 1
		f%(x%, 24) = 1
	NEXT x%
	px% = 20
	py% = 13
	iKopf% = 1
	iSchwanz% = 1
	ri%(iKopf%) = 0                 ' Kopf - Schwanz
	ri%(iSchwanz% - 1 AND 1023) = 0 ' Schwanzspitzausrichtung
	zeit% = 0
	geschwStu% = 51
	tit$ = "Titellos"
END SUB

SUB LadeLevel
	OPEN "level" + FuehrNull$(Lev%, 2) + ".dat" FOR INPUT AS 1
	CLOSE 1
	OPEN "level" + FuehrNull$(Lev%, 2) + ".dat" FOR BINARY AS 1
	k$ = INPUT$(4, 1)
	IF k$ <> "Wurm" THEN
		' Nicht Wurmspieldatei
		STOP
	END IF
	FOR y% = 2 TO 23
		FOR x% = 2 TO 38
			f%(x%, y%) = ASC(INPUT$(1, 1))
		NEXT x%
	NEXT y%
	px% = ASC(INPUT$(1, 1))
	py% = ASC(INPUT$(1, 1))
	h% = ASC(INPUT$(1, 1))
	IF h% <> 0 THEN
		' hhere Version
		STOP
	END IF
	h% = ASC(INPUT$(1, 1))
	ri%(iSchwanz%) = h% AND 3
	ri%(iSchwanz% - 1) = h% \ 4 AND 3
	IF ri%(iSchwanz%) <> ri%(iSchwanz% - 1) THEN
		' hhere Version
		STOP
	END IF
	geschwStu% = ASC(INPUT$(1, 1))
	zeit% = CVI(INPUT$(2, 1))
	h% = ASC(INPUT$(1, 1))
	tit$ = INPUT$(h%, 1)
	CLOSE 1
END SUB

FUNCTION PruefePasswort% (pwd$)
	co1& = 0&
	FOR i% = 1 TO 6
		c% = ASC(MID$(pwd$, i%, 1)) - 48
		IF c% > 10 THEN
			c% = c% - 7
		END IF
		co1& = 32& * co1& + CLNG(c% * 7 + 29 AND 31)
	NEXT i%
	cod& = 0&
	FOR i% = 1 TO 5
		cod& = 64& * cod& + ((co1& AND 63&) * 45& + 10& AND 63&)
		co1& = co1& \ 64&
	NEXT i%
	n% = CINT(cod& AND 255&)
	LevCod& = CLNG(n%) + 256& * (CLNG(n%) * 4019413 + 8172129 AND 4194303)
	IF cod& = LevCod& THEN
		PruefePasswort% = n%
	ELSE
		PruefePasswort% = -1    ' ungltiges Levelpasswort
	END IF
END FUNCTION

SUB RelSound (Freq%, dauer!)
	IF SoundEin% THEN
		IF geschwStu% THEN
			dEff! = dauer! * geschw!
		ELSE
			dEff! = dauer! * .15
		END IF
		IF dEff! < MinSoundL! THEN
			dEff! = MinSoundL!
		END IF
		SOUND Freq%, dEff!
	END IF
END SUB

SUB SoundSlide (f1!, f2!, dauer!)
	IF SoundEin% THEN
		IF geschwStu% THEN
			dEffTot! = dauer! * geschw!
		ELSE
			dEffTot! = dauer! * .15
		END IF
		AnzSamp% = CINT(dEffTot! / MinSoundL!)
		IF AnzSamp% < 2 THEN   ' 2 Samples=absolutes Minimum
			AnzSamp% = 2
		END IF
		schr! = (f2! - f1!) / CSNG(AnzSamp% - 1)
		FOR i% = 0 TO AnzSamp% - 1
			SOUND f1! + CSNG(i%) * schr!, MinSoundL!
		NEXT i%
	END IF
END SUB

SUB SpeichereLevel
	OPEN "level" + FuehrNull$(Lev%, 2) + ".dat" FOR OUTPUT AS 1
	PRINT #1, "Wurm";
	FOR y% = 2 TO 23
		FOR x% = 2 TO 38
			PRINT #1, CHR$(f%(x%, y%) AND 255);
		NEXT x%
	NEXT y%
	PRINT #1, CHR$(px%); CHR$(py%); CHR$(0);
	PRINT #1, CHR$(ri%(iSchwanz%) + 4 * ri%(iSchwanz% - 1));
	PRINT #1, CHR$(geschwStu%); MKI$(zeit%);
	PRINT #1, CHR$(LEN(tit$)); tit$;
	CLOSE 1
END SUB

SUB ZeichneFeldchen (x%, y%)
	GibSymbolAus f%(x%, y%) AND 255, x%, y%
END SUB

SUB ZeichneLevel
	ap% = 0
	FOR y% = 1 TO 24
		FOR x% = 1 TO 39
			ZeichneFeldchen x%, y%
			IF f%(x%, y%) = 2 THEN
				ap% = ap% + 1
			END IF
		NEXT x%
	NEXT y%
	ZeichneStartWurm
END SUB

SUB ZeichneStartWurm
	' Wurm zu Beginn darstellen
	pxAlt% = px% - rx%(ri%(iSchwanz%))
	pyAlt% = py% - ry%(ri%(iSchwanz%))
	ri%(iSchwanz% - 1 AND 1023) = ri%(iSchwanz%)
	f%(px%, py%) = 256
	f%(pxAlt%, pyAlt%) = 256
	LOCATE py%, px%
	COLOR 14, 0
	PRINT CHR$(2);
	LOCATE pyAlt%, pxAlt%
	COLOR 1
	PRINT MID$("ĳ", 1 + (ri%(iSchwanz%) AND 1), 1);
END SUB

