PROGRAM Break_it;


USES Graph, CRT, Turbo3;


TYPE

  picturetype = ARRAY[1..49150] OF BYTE;

  fieldtype   = ARRAY[0..5,0..5] OF BYTE;

  ballstype   = ARRAY[0..3] OF POINTER;

  settype     = SET OF BYTE;


CONST

  colors : ARRAY[0..15] OF BYTE = ( 00,
                                    62,
                                    36,
                                    32,
                                    57,
                                    09,
                                    08,
                                    58,
                                    18,
                                    16,
                                    07,
                                    56,
                                    63,
                                    28,
                                    54,
                                    14  );


  pointtable : ARRAY[0..12] OF BYTE = ( 00,
                                        01,
                                        03,
                                        06,
                                        10,
                                        15,
                                        21,
                                        28,
                                        36,
                                        45,
                                        55,
                                        66,
                                        80 );






VAR

  field        : fieldtype;

  balls        : ballstype;

  uparrow      : POINTER;

  leftarrow    : POINTER;

  box          : POINTER;

  textbox      : POINTER;

  picture      : picturetype;

  disk         : FILE OF picturetype;

  i            : BYTE;

  points       : ARRAY[0..3,0..1] OF WORD;

  ch           : CHAR;





FUNCTION LeftEasyAdd(n: BYTE) : BYTE;

VAR i,s : BYTE;

BEGIN
  s:=0;
  FOR i:=0 TO 5 DO
    IF field[i,n]<>3 THEN INC(s);
  LeftEasyAdd:=s;
END;




FUNCTION UpEasyAdd(n: BYTE) : BYTE;

VAR i,s : BYTE;

BEGIN
  s:=0;
  FOR i:=0 TO 5 DO
    IF field[n,i]<>3 THEN INC(s);
  UpEasyAdd:=s;
END;




PROCEDURE Add;

BEGIN
  points[3,0]:=pointtable[points[0,0]]+
               pointtable[points[1,0]]+
               pointtable[points[2,0]];
  points[3,1]:=pointtable[points[0,1]]+
               pointtable[points[1,1]]+
               pointtable[points[2,1]];
END;




PROCEDURE ScoreOut(player : BYTE);

VAR i : WORD;
    s : STRING[80];

BEGIN
  IF player=0 THEN BEGIN
    SetColor(11);
    FOR i:=65 TO 115 DO line(540,i,600,i);
    SetColor(11);
    FOR i:=140 TO 150 DO line (570,i,610,i);
    SetColor(2);
    str(points[3,0],s);
    OutTextXY(580,142,s);
    str(points[0,0],s);
    OutTextXY(540,73,s);
    str(points[1,0],s);
    OutTextXY(540,107,s);
    str(points[2,0],s);
    OutTextXY(540,90,s);
  END;
  IF player=1 THEN BEGIN
    SetColor(11);
    FOR i:=225 TO 275 DO line(540,i,600,i);
    SetColor(11);
    FOR i:=300 TO 310 DO line (570,i,610,i);
    SetColor(2);
    str(points[3,1],s);
    OutTextXY(580,302,s);
    str(points[0,1],s);
    OutTextXY(540,233,s);
    str(points[1,1],s);
    OutTextXY(540,267,s);
    str(points[2,1],s);
    OutTextXY(540,250,s);
  END;
END;




PROCEDURE SetMark(player,color : BYTE);

VAR i : WORD;

BEGIN
  SetColor(color);
  IF player=0 THEN FOR i:=40 TO 44 DO line(590,i,594,i)
              ELSE FOR i:=198 TO 202 DO line(590,i,594,i);
END;




PROCEDURE ClrScore;

VAR i,j : BYTE;

BEGIN
  FOR i:=0 TO 1 DO
    FOR j:=0 TO 3 DO points[j,i]:=0;
END;




PROCEDURE FillField;

VAR x,y,i,j : BYTE;

BEGIN
  FOR i:=0 TO 5 DO
    FOR j:=0 TO 5 DO field[i,j]:=3;
  FOR i:=0 TO 2 DO
    FOR j:=1 TO 12 DO BEGIN
      REPEAT
        x:=RANDOM(6);
        y:=RANDOM(6);
      UNTIL field[x,y]=3;
      field[x,y]:=i;
    END;
END;




PROCEDURE PaletteOn;

VAR i : BYTE;

BEGIN
  FOR i:=0 TO 15 DO SetPalette(i,colors[i]);
END;




PROCEDURE PaletteOff;

VAR i : BYTE;

BEGIN
  FOR i:=0 TO 15 DO SetPalette(i,0);
END;




PROCEDURE MoveIn;

VAR i : BYTE;

BEGIN
  FOR i:=15 DOWNTO 0 DO BEGIN
    port[$03d4]:=9;
    port[$03d5]:=i;
    Delay(100);
  END;
END;




PROCEDURE MoveOut;

VAR i : BYTE;

BEGIN
  FOR i:=0 TO 15 DO BEGIN
    port[$03d4]:=9;
    port[$03d5]:=i;
    Delay(100);
  END;
END;




PROCEDURE GetBalls;

VAR size : WORD;
    i    : BYTE;


BEGIN
  FOR i:=0 TO 3 DO BEGIN
    size:=ImageSize(94+(i*53),60,134+(i*53),100);
    GetMem(balls[i],size);
    GetImage(94+(i*53),60,134+(i*53),100,balls[i]^);
  END;
END;




PROCEDURE PutBall(x,y,n : BYTE);

BEGIN
  PutImage(94+(x*53),60+(y*41),balls[n]^,normalput);
END;



PROCEDURE BallsOnScreen;

VAR i,j : BYTE;

BEGIN
  FOR i:=0 TO 5 DO
    FOR j:=0 TO 5 DO PutBall(i,j,field[i,j]);
END;




PROCEDURE GetBox;

VAR size : WORD;

BEGIN
  size:=ImageSize(0,0,38,38);
  GetMem(box,size);
  GetImage(0,0,38,38,box^);
END;



PROCEDURE GetTextbox;

VAR size : WORD;

BEGIN
  size:=ImageSize(75,324,419,347);
  GetMem(textbox,size);
  GetImage(75,324,419,347,textbox^);
END;




PROCEDURE GetLeftArrow;

VAR size : WORD;

BEGIN
  size:=ImageSize(36,183,73,220);
  GetMem(leftarrow,size);
  GetImage(36,183,73,220,leftarrow^);
  PutImage(36,183,box^,normalput);
END;




PROCEDURE GetUpArrow;

VAR size : WORD;

BEGIN
  size:=ImageSize(22,258,58,289);
  GetMem(uparrow,size);
  GetImage(22,258,58,289,uparrow^);
  PutImage(22,258,box^,normalput);
END;





PROCEDURE PutLeftArrow(n : BYTE);

BEGIN
  PutImage(36,60+(n*41),leftarrow^,normalput);
END;




PROCEDURE ClearLeftArrow(n : BYTE);

BEGIN
  PutImage(36,60+(n*41),box^,normalput);
END;




PROCEDURE PutUpArrow(n : BYTE);

BEGIN
  PutImage(97+(n*53),317,uparrow^,normalput);
END;




PROCEDURE ClearUpArrow(n : BYTE);

BEGIN
  PutImage(97+(n*53),317,box^,normalput);
END;




PROCEDURE GraphOn;

VAR gd,gm : INTEGER;

BEGIN
  gd:=ega64;
  gm:=ega64hi;
  InitGraph(gd,gm,'');
END;




PROCEDURE LoadGraph;

BEGIN
  Assign(disk,'break_it.lbm');
  Reset(disk);
  Read(disk,picture);
  Close(disk);
END;




PROCEDURE Decrunch;

VAR  screen        : ARRAY[0..28000] OF BYTE ABSOLUTE $A000:0000;

     cod, i,
     n, l,pl,
     zeile,spalte  : WORD;

PROCEDURE PutByte(VAR x : BYTE);
BEGIN
  port[$03c4]:=2;
  port[$03c5]:=(1 shl pl);
  screen[(zeile*80)+spalte]:=x;
  Inc(spalte);
  IF spalte=80 THEN BEGIN
    Inc(pl);
    spalte:=0;
  END;
  IF pl=4 THEN BEGIN
     pl:=0;
     Inc(zeile);
  END;
END;


BEGIN
  i:=1;
  REPEAT
    Inc(i);
  UNTIL (picture[i]=Ord('B'))   AND
        (picture[i+1]=Ord('O')) AND
        (picture[i+2]=Ord('D')) AND
        (picture[i+3]=Ord('Y'));
  Inc(i,8);
  pl:=0;
  zeile:=0;
  spalte:=0;
  REPEAT
    cod:=picture[i];
    IF cod<128 THEN BEGIN
      FOR l:=i+1 TO i+cod+1 DO putbyte(picture[l]);
      Inc(i,cod+2);
    END;
    IF cod>128 THEN BEGIN
      for l:=0 to 256-cod do putbyte(picture[i+1]);
      Inc(i,2);
    END;
    IF cod=128 THEN BEGIN
      write(#7);
      Inc(i);
    END;
  UNTIL i>=49150;
END;



FUNCTION Choose : CHAR;

VAR i : WORD;
    c : CHAR;

BEGIN
  SetColor(2);
  REPEAT
    FOR i:=0 to 5999 DO BEGIN
      CASE i OF
        0000 : BEGIN
                 PutImage(75,324,textbox^,normalput);
                 OutTextXY(89,332,'Drcke F1 fr 1 Spieler - Modus');
               END;

        2000 : BEGIN
                 PutImage(75,324,textbox^,normalput);
                 OutTextXY(89,332,'Drcke F2 fr 2 Spieler - Modus');
               END;

        4000 : BEGIN
                 PutImage(75,324,textbox^,normalput);
                 OutTextXY(89,332,'Drcke F3 um ins DOS zu gelangen');
               END;

      END;
      IF Keypressed THEN BEGIN
        Read(kbd,c);
        IF c=#27 THEN IF Keypressed THEN BEGIN
          Read(kbd,c);
          IF c in [#59,#60,#61,#62] THEN BEGIN
            Choose:=c;
            EXIT;
          END;
        END;
      END;
      Delay(1);
    END;
  UNTIL 1=2;
END;




FUNCTION NewPos(oldpos, direction : BYTE) : BYTE;

VAR c   : CHAR;
    pos : BYTE;


BEGIN
  pos:=oldpos;
  REPEAT
    read(kbd,c);
    IF c=#13 THEN BEGIN
      NewPos:=pos;
      EXIT;
    END;
    IF c=#27 THEN BEGIN
      read(kbd,c);
      CASE c OF

      #72,#75 : BEGIN
                  IF direction=0 THEN ClearLeftArrow(pos)
                                 ELSE ClearUpArrow(pos);
                  IF pos=0 THEN pos:=5
                           ELSE DEC(pos);
                  IF direction=0 THEN PutLeftArrow(pos)
                                 ELSE PutUpArrow(pos);
                END;

      #77,#80 : BEGIN
                  IF direction=0 THEN ClearLeftArrow(pos)
                                 ELSE ClearUpArrow(pos);
                  IF pos=5 THEN pos:=0
                           ELSE INC(pos);
                  IF direction=0 THEN PutLeftArrow(pos)
                                 ELSE PutUpArrow(pos);
                END;
      END;
    END;
  UNTIL c<>c;
END;




FUNCTION ComputerMove(uparrowpos, leftarrowpos : BYTE) : BYTE;

VAR i:BYTE;
    n:BYTE;
    x:BYTE;
    score:BYTE;
    balls:array[0..2] of BYTE;


BEGIN
  IF (points[0,1]=0) AND (points[1,1]=0) AND (points[2,1]=0) THEN BEGIN
    ComputerMove:=Random(6);
    EXIT;
  END;

  n:=0;
  FOR i:=0 TO 5 DO
    IF field[uparrowpos,i]<>3 THEN INC(n);
  IF n=1 THEN BEGIN
    FOR i:=0 TO 5 DO
      IF field[uparrowpos,i]<>3 THEN BEGIN
        n:=i;
        balls[0]:=points[0,1];
        balls[1]:=points[1,1];
        balls[2]:=points[2,1];
        INC(balls[field[uparrowpos,n]]);
        score:=pointtable[balls[0]]+pointtable[balls[1]]+pointtable[balls[2]];
        IF points[3,0]<score THEN BEGIN
          ComputerMove:=n;
          EXIT;
        END ELSE BEGIN
          DEC(balls[field[uparrowpos,n]]);
        END;
      END;
    END;

    x:=0;
    IF points[1,1]>=points[0,1] THEN x:=1;
    IF points[2,1]>=points[x,1] THEN x:=2;
    FOR i:=0 TO 5 DO
      IF field[i,leftarrowpos]=x THEN BEGIN
        ComputerMove:=i;
        EXIT;
      END;
    IF x=0 THEN
      IF points[1,1]>=points[2,1] THEN x:=1
                                  ELSE X:=2
      ELSE IF x=1 THEN
        IF points[0,1]>=points[2,1] THEN x:=0
                                    ELSE X:=2
        ELSE IF x=2 THEN
          IF points[0,1]>=points[1,1] THEN x:=0
                                      ELSE X:=1;
    FOR i:=0 TO 5 DO
      IF field[i,leftarrowpos]=x THEN BEGIN
        ComputerMove:=i;
        EXIT;
      END;
    IF x=0 THEN
      IF points[1,1]<=points[2,1] THEN x:=1
                                  ELSE x:=2
      ELSE IF x=1 THEN
        IF points[0,1]<=points[2,1] THEN x:=0
                                    ELSE x:=2
        ELSE IF x=2 THEN
          IF points[0,1]<=points[1,1] THEN x:=0
                                      ELSE x:=1;
    FOR i:=0 TO 5 DO
      IF field[i,leftarrowpos]=x THEN BEGIN
        ComputerMove:=i;
        EXIT;
      END;
END;





PROCEDURE OnePlayerEasy;

VAR i,j           : WORD;
    leftarrowpos  : BYTE;
    uparrowpos    : BYTE;
    player        : BYTE;
    opponent      : BYTE;
    swap          : BYTE;
    gameend       : BOOLEAN;
    beep          : BOOLEAN;

BEGIN
  ClrScore;
  ScoreOut(0);
  ScoreOut(1);
  player:=0;
  opponent:=1;
  leftarrowpos:=0;
  uparrowpos:=0;
  setcolor(13);
  for i:=324 to 347 do
    line (75,i,419,i);
  PutLeftArrow(leftarrowpos);
  PutUpArrow(uparrowpos);
  gameend:=false;
  WHILE not gameend DO BEGIN
    SetMark(player,0);
    SetMark(opponent,11);
    IF player=0 THEN BEGIN
      IF UpEasyAdd(uparrowpos)=0 THEN gameend:=TRUE
                     ELSE BEGIN
        beep:=FALSE;
        REPEAT
          IF (field[uparrowpos,leftarrowpos]=3) and (beep) THEN write(#7);
          leftarrowpos:=NewPos(leftarrowpos,0);
          beep:=TRUE;
        UNTIL field[uparrowpos,leftarrowpos]<>3;
        INC(points[field[uparrowpos,leftarrowpos],0]);
        Add;
        ScoreOut(0);
        field[uparrowpos,leftarrowpos]:=3;
        PutBall(uparrowpos,leftarrowpos,3);
      END;
    END;
    IF player=1 THEN BEGIN
      IF LeftEasyAdd(leftarrowpos)=0 THEN gameend:=TRUE
                     ELSE BEGIN
        ClearUpArrow(uparrowpos);
        REPEAT
          uparrowpos:=ComputerMove(uparrowpos,leftarrowpos);
        UNTIL field[uparrowpos,leftarrowpos]<>3;
        PutUpArrow(uparrowpos);
        INC(points[field[uparrowpos,leftarrowpos],1]);
        Add;
        ScoreOut(1);
        field[uparrowpos,leftarrowpos]:=3;
        PutBall(uparrowpos,leftarrowpos,3);
      END;
    END;
    swap:=player;
    player:=opponent;
    opponent:=swap;
  END;
  ClearUpArrow(uparrowpos);
  ClearLeftArrow(leftarrowpos);
END;






PROCEDURE TwoPlayerEasy;

VAR i,j           : WORD;
    leftarrowpos  : BYTE;
    uparrowpos    : BYTE;
    player        : BYTE;
    opponent      : BYTE;
    swap          : BYTE;
    gameend       : BOOLEAN;
    beep          : BOOLEAN;

BEGIN
  ClrScore;
  ScoreOut(0);
  ScoreOut(1);
  player:=0;
  opponent:=1;
  leftarrowpos:=0;
  uparrowpos:=0;
  setcolor(13);
  for i:=324 to 347 do
    line (75,i,419,i);
  PutLeftArrow(leftarrowpos);
  PutUpArrow(uparrowpos);
  gameend:=false;
  WHILE not gameend DO BEGIN
    SetMark(player,0);
    SetMark(opponent,11);
    IF player=0 THEN BEGIN
      IF UpEasyAdd(uparrowpos)=0 THEN gameend:=TRUE
                     ELSE BEGIN
        beep:=FALSE;
        REPEAT
          IF (field[uparrowpos,leftarrowpos]=3) and (beep) THEN write(#7);
          leftarrowpos:=NewPos(leftarrowpos,0);
          beep:=TRUE;
        UNTIL field[uparrowpos,leftarrowpos]<>3;
        INC(points[field[uparrowpos,leftarrowpos],0]);
        Add;
        ScoreOut(0);
        field[uparrowpos,leftarrowpos]:=3;
        PutBall(uparrowpos,leftarrowpos,3);
      END;
    END;
    IF player=1 THEN BEGIN
      IF LeftEasyAdd(leftarrowpos)=0 THEN gameend:=TRUE
                     ELSE BEGIN
        beep:=FALSE;
        REPEAT
          IF (field[uparrowpos,leftarrowpos]=3) and (beep) THEN write(#7);
          uparrowpos:=NewPos(uparrowpos,1);
          beep:=TRUE;
        UNTIL field[uparrowpos,leftarrowpos]<>3;
        INC(points[field[uparrowpos,leftarrowpos],1]);
        Add;
        ScoreOut(1);
        field[uparrowpos,leftarrowpos]:=3;
        PutBall(uparrowpos,leftarrowpos,3);
      END;
    END;
    swap:=player;
    player:=opponent;
    opponent:=swap;
  END;
  ClearUpArrow(uparrowpos);
  ClearLeftArrow(leftarrowpos);
END;




PROCEDURE Anleitung;

BEGIN
  OutTextXY(020,30,'Lieber Sharewarenutzer,');
  OutTextXY(020,40,'vor Ihnen liegt mein erstes Shareware-Werk. Sie drfen die Diskette');
  OutTextXY(020,50,'selbstverstndlich kopieren und beliebig weitergeben (was natrlich');
  OutTextXY(020,60,'auch in meinem Interesse ist). Sollte Ihnen das Programm gefallen,');
  OutTextXY(020,70,'so wrde ich mich freuen, wenn sie sich fr 15.- DM bei mir als Benutzer');
  OutTextXY(020,80,'registrieren lassen wrden. Sie erhalten dann laufend Versionen von');
  OutTextXY(020,90,'"BREAK-IT" (z.B. mit strkerem Computergegner) und Informationen');
  OutTextXY(20,100,'ber meine neuen Werke.');
  OuttextXY(20,110,'Bei Interesse berweisen Sie bitte 15.- DM auf das Konto :');
  OutTextXY(20,120,'Stadtsparkasse Duisburg, Bankleitzahl 35050000, Kontonummer 337-018 394');
  OutTextXY(20,130,'und senden Sie mir eine Kopie des Einzahlungsbeleges. Oder senden Sie ');
  Outtextxy(20,140,'mir den Betrag als V-Scheck oder in bar. Geben Sie aber auf jeden Fall ');
  OutTextXY(20,150,'das Kennwort "BREAK-IT" an.');
  OutTextXY(20,180,'Kurzanleitung zum Spiel :');
  OutTextXY(20,195,'Ziel des Spiel ist es, eine mglichst groe Anzahl an Kugeln einer Farbe');
  OutTextXY(20,205,'zu bekommen. Jeder Spieler bewegt zu diesem Zweck einen Pfeil. Der Pfeil');
  OutTextXY(20,215,'wird so bewegt, da er auf die zu nehmende Kugel zeigt. Ein Zug wird');
  OutTextXY(20,225,'mit RETURN beendet. Sieger ist, wer zum Schlu die hchste Punktzahl hat.');
  OutTextXY(20,235,'Das Spiel ist beendet, wenn ein Spieler keine Kugel mehr nehmen kann.');
  OutTextXY(20,245,'Zum Computergegner ist zu sagen, da er bei dieser Version noch nicht ');
  OutTextXY(20,255,'besonders stark spielt. Trotzdem wnsche ich Ihnen viel Spa.');
  OutTextXY(20,285,'Meine Adresse :');
  OutTextXY(20,300,'Karsten Krzoska');
  OutTextXY(20,310,'Alter Kalkweg 11');
  OutTextXY(20,320,'4100 DUISBURG 1');
END;




PROCEDURE Auswertung;

BEGIN
  PaletteOff;
  SetViewPort(0,0,639,349,true);
  SetColor(4);
  SetTextStyle(0,0,3);
  IF points[3,0]>points[3,1] THEN BEGIN
    OutTextXY(200,50,'Sieger  ist');
    OutTextXY(200,100,' Spieler 1');
  END;
  IF points[3,0]<points[3,1] THEN BEGIN
    OutTextXY(200,50,'Sieger  ist');
    OutTextXY(200,100,' Spieler 2');
  END;
  IF points[3,0]=points[3,1] THEN BEGIN
    OutTextXY(180,50,'Unentschieden');
  END;
  SetTextStyle(0,0,1);
  PaletteOn;
  MoveIn;
  REPEAT UNTIL KEYPRESSED;
END;




BEGIN
  Randomize;
  GraphOn;
  SetActivePage(1);
  ClearViewPort;
  SetColor(4);
  Anleitung;
  SetVisualPage(1);
  delay(40000);
  SetActivePage(0);
  LoadGraph;
  Decrunch;
  PaletteOff;
  GetBox;
  GetTextbox;
  GetLeftArrow;
  GetUpArrow;
  GetBalls;
  REPEAT
    PaletteOff;
    ClrScore;
    ScoreOut(0);
    ScoreOut(1);
    FillField;
    BallsOnScreen;
    SetVisualPage(0);
    port[$03d4]:=9;
    port[$03d5]:=15;
    PaletteOn;
    MoveIn;
    ch:=choose;
    case ch of
      #59 : OnePlayerEasy;
      #60 : TwoPlayerEasy;
      #61 : BEGIN TextMode(3); halt; END;
    END;
    MoveOut;
    SetActivePage(1);
    ClearViewPort;
    SetVisualPage(1);
    auswertung;
    MoveOut;
    SetActivePage(0);
  UNTIL 1=2;
END.
