.286
.model tiny
.code
org 100h

Start:
        jmp     Begin

Px      dw      145
CPUx    dw      145
x       dw      50
y       dw      100
dtx     dw      1
dty     dw      1
dir     dw      0
cell1   dw      0
cell2   dw      0

sball   db      0,0,4,4,0,0,0,4,12,12,4,0,4,12,14,14,12,4,4,12,14,14,12,4,0,4,12,12,4,0,0,0,4,4,0,0
srckt1  db      2,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0
srckt2  db      0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,7,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,7

Begin:
        mov     ax,13h
        int     10h
        mov     ax,0A000h
        mov     es,ax

        mov     cx,50
        mov     bx,0
InitBLoop1:
        mov     al,50
        sub     al,cl
        add     al,132
        inc     bx
        call    SetBlue
        loop    InitBLoop1

        mov     cx,50
InitBLoop2:
        mov     al,50
        sub     al,cl
        add     al,182
        dec     bx
        call    SetBlue
        loop    InitBLoop2

        mov     cx,99
        mov     ax,132
LoopPB:
        push    cx
        call    PutBar
        pop     cx
        inc     ax
        inc     [cell1]
        inc     [cell2]
        loop    LoopPB

        xor     ax,ax
        int     16h
MainLoop:
        mov     al,132
        call    GetBlue
        xor     ah,ah
        push    ax

        mov     cx,99
RotPalL:
        mov     al,99
        sub     al,cl
        add     al,133
        call    GetBlue
        mov     bl,al

        mov     al,99
        sub     al,cl
        add     al,132

        call    SetBlue

        loop    RotPalL

        pop     bx
        mov     al,231
        call    SetBlue

        mov     bx,[x]
        mov     dx,[y]
        call    CalcDI

        push    di
        mov     bx,offset [Mem+bball]
        mov     dx,6
        mov     ax,314
        call    GetSprite

        mov     si,offset [sball]
        pop     di
        mov     dl,6
        mov     dh,dl

        call    PutSprite

        mov     cx,offset [Mem+brckt1]
        mov     bx,[Px]
        mov     dx,198
        mov     si,offset [srckt1]
        call    ShowRoquet

        mov     cx,offset [Mem+brckt2]
        mov     bx,[CPUx]
        mov     dx,0
        mov     si,offset [srckt2]
        call    ShowRoquet

        mov     dx,03DAh;
WR1:
        in      al,dx
        and     al,08h
        jnz     WR1

WR2:
        in      al,dx
        and     al,08h
        jz      WR2

        mov     bx,[x]
        mov     dx,[y]
        call    CalcDI

        mov     si,offset [Mem+bball]

        mov     dx,6
HBLoop:
        mov     cx,3
        rep     movsw
        add     di,314
        dec     dx
        jnz     HBLoop

        mov     bx,[Px]
        mov     dx,198
        mov     si,offset [Mem+brckt1]
        call    HideRoquet
        mov     bx,[CPUx]
        xor     dx,dx
        mov     si,offset [Mem+brckt2]
        call    HideRoquet

        mov     ah,1
        int     16h
        jz      @m6
        xor     ah,ah
        int     16h
        cmp     al,'q'
        jnz     @m5
        jmp     Quit
@m5:
        cmp     al,'4'
        jnz     @m7
        mov     [dir],-2
        jmp     short @m6
@m7:
        cmp     al,'6'
        jnz     @m15
        mov     [dir],2
        jmp     short @m6
@m15:
        cmp     al,'5'
        jnz     @m6
        mov     [dir],0

@m6:
        mov     ax,dir
        add     [Px],ax

        mov     ax,[CPUx]
        add     ax,6
        cmp     ax,[x]
        jb      @m8
        sub     ax,6
        cmp     ax,1
        jbe     @m9
        dec     [CPUx]
        jmp     short @m9
@m8:
        sub     ax,6
        cmp     ax,300
        jae     @m9
        inc     [CPUx]
@m9:

        mov     ax,[x]
        add     ax,[dtx]
        cmp     ax,313
        jl      @m1
        neg     dtx
        jmp     short @me
@m1:
        cmp     ax,0
        jg      @m2
        neg     dtx
        jmp     short @me
@m2:
        mov     [x],ax
@me:
        mov     bx,[x]

        mov     ax,[y]
        add     ax,[dty]
        cmp     ax,193
        jl      @m3
        add     bx,3
        cmp     bx,[Px]
        jae     @m10
        jmp     short Quit
@m10:
        sub     bx,24
        cmp     bx,[Px]
        jbe     @m11
        jmp     short Quit
@m11:

        neg     dty
        jmp     short @me1
@m3:
        cmp     ax,1
        jg      @m4
        add     bx,3
        cmp     bx,[CPUx]
        jae     @m12
        jmp     short Quit
@m12:
        sub     bx,24
        cmp     bx,[CPUx]
        jbe     @m13
        jmp     short Quit
@m13:
        neg     dty
        jmp     short @me
@m4:
        mov     [y],ax
@me1:

        jmp     MainLoop

Quit:
        mov     ax,4C00h
        int     21h

;InitPal proc near

;        ret
;InitPal endp

;PutBground proc near

;        ret
;PutBground endp

PutBar proc near
        mov     bx,[cell1]
        mov     dx,[cell2]

        call    CalcDI

        mov     bx,[cell2]
        shl     bx,1
        mov     dx,199
        sub     dx,bx
        inc     dx

        mov     bx,[cell1]
        shl     bx,1

BarYLoop:
        mov     cx,319
        sub     cx,bx
        inc     cx
        push    di
        rep     stosb
        pop     di
        add     di,320
        dec     dx
        jnz     BarYLoop

        ret
PutBar endp

ShowRoquet proc near
        call    CalcDI
        mov     bx,cx
        push    di
        mov     dx,2
        mov     ax,302
        call    GetSprite

        pop     di
        mov     dl,18
        mov     dh,2

        call    PutSprite
        ret
ShowRoquet endp

HideRoquet proc near
        call    CalcDI

        mov     dx,2
HRLoop:
        mov     cx,9
        rep     movsw
        add     di,302
        dec     dx
        jnz     HRLoop

        ret
HideRoquet endp

CalcDI proc near
        mov     di,bx
        mov     bx,dx
        mov     dh,dl
        xor     dl,dl
        shl     bx,6
        add     dx,bx
        add     di,dx
        ret
CalcDI endp

GetSprite proc near
        mov     dh,dl
GSLoop1y:
        mov     cx,320
        sub     cx,ax
GSLoop1x:
        mov     dl,es:[di]
        mov     byte ptr [bx],dl
        inc     di
        inc     bx
        loop    GSLoop1x
        add     di,ax
        dec     dh
        jnz     GSLoop1y

        ret
GetSprite endp

PutSprite proc near
        mov     bx,320
        mov     ax,dx
        xor     ah,ah
        sub     bx,ax
PSLoop2y:
        mov     cl,dl
PSLoop2x:
        lodsb
        cmp     al,0
        jz      PSCont1
        stosb
        jmp     short PSCont2
PSCont1:
        inc     di
PSCont2:
        loop    PSLoop2x
        add     di,bx
        dec     dh
        jnz     PSLoop2y
        ret
PutSprite endp

GetBlue proc near
        mov     dx,03C7h
        out     dx,al
        mov     dx,03C9h
        in      al,dx
        in      al,dx
        in      al,dx
        ret
GetBlue endp

SetBlue proc near
        mov     dx,03C8h
        out     dx,al
        inc     dx
        xor     al,al
        out     dx,al
        out     dx,al
        mov     al,bl
        out     dx,al
        ret
SetBlue endp

Mem     db      ?
;bball   db      36 dup(?)
;brckt1  db      36 dup(?)
;brckt2  db      36 dup(?)
bball   EQU      0 ; 36 dup(?)
brckt1  EQU      36; 36 dup(?)
brckt2  EQU      72; 36 dup(?)

END Start

END