DEFINT A-Z

DECLARE SUB AddScore ()
DECLARE SUB AskPlayAgain ()
DECLARE SUB Bonus ()
DECLARE SUB Center (Row, Text$)
DECLARE SUB ChangeNumberOfLives ()
DECLARE SUB ChangeScore ()
DECLARE SUB Choose (x, y, Prompt$, Choice$, Choices$)
DECLARE SUB DisplayScoreList ()
DECLARE SUB DisplayStatusBar ()
DECLARE SUB DisplayTitle ()
DECLARE SUB DisplayYouLost ()
DECLARE SUB DisplayYouWon ()
DECLARE SUB GetNameAndLevel ()
DECLARE SUB GetScores ()
DECLARE SUB GoToNextLevel ()
DECLARE SUB InputBox (x, y, Prompt$, Text$, MaxLength)
DECLARE SUB Main ()
DECLARE SUB MoveBall ()
DECLARE SUB MovePlateau ()
DECLARE SUB Quit ()
DECLARE SUB SaveScores ()
DECLARE SUB SetVariables ()
DECLARE SUB SortScores ()
OPTION BASE 0
COMMON SHARED BallSpeed, BallX, BallY, BallDirectionX, BallDirectionY, Level, Lives
COMMON SHARED Name$, PlateauX, PlateauDirectionX, Score, ScoreAtStartLevel, Speed
ON ERROR GOTO ErrorTrap
DIM SHARED ScrDate$(10), ScrName$(10), ScrScore$(10), ScrTime$(10)
DIM SHARED DelayStart(2) AS SINGLE, Image(5203)
ScreenModeSet = 0
SCREEN 12: WIDTH 80, 30: COLOR 15: CLS
ScreenModeSet = -1
SetVariables
DisplayTitle
DisplayScoreList
GetNameAndLevel
CALL Main

ErrorTrap:
 IF ScreenModeSet THEN GET (120, 160)-(520, 210), Image
e = ERR
COLOR 4: LOCATE 11
 IF e = 7 OR e = 14 THEN
  Center 0, "Not enough memory."
 ELSEIF e = 55 THEN
  Center 0, "Cannot open score list."
 ELSEIF e = 61 THEN
  Center 0, "Disk is full."
 ELSEIF e = 62 THEN
  Center 0, "Error while reading score list."
 ELSEIF e = 70 THEN
  Center 0, "Disk or score list"
  Center 0, "is write protected."
 ELSEIF e = 71 OR e = 76 THEN
  Center 0, "There is no disk in drive."
 ELSEIF e = 72 THEN
  Center 0, "Disk is damaged."
 ELSE
  Center 0, "Unexpected error."
 END IF
COLOR 12
Center 0, "1 = Try Again  2 = Ignore  3 = Quit"
 DO
  Choice$ = INPUT$(1)
 LOOP UNTIL INSTR("123", Choice$)
 IF ScreenModeSet THEN PUT (120, 160), Image, PSET
 IF Choice$ = "1" THEN RESUME
 IF Choice$ = "2" THEN RESUME NEXT
 IF Choice$ = "3" THEN Quit

SUB AddScore
GetScores

ScrName$(10) = Name$: ScrScore$(10) = LTRIM$(STR$(Score))
ScrTime$(10) = TIME$: ScrDate$(10) = DATE$

SortScores
SaveScores
END SUB

SUB AskPlayAgain
Choose 8, 10, "Play again y/n?", Choice$, "YN"
 IF Choice$ = "N" THEN Quit
RUN "Balls"
END SUB

SUB Bonus
COLOR 4
DelayStart(1) = TIMER
 DO
  LOCATE 3
  PRINT SPC(10); "          "
  PRINT SPC(10); "              "
  PRINT SPC(10); "                   "
  PRINT SPC(10); "              "
  PRINT SPC(10); "Score is: "; Score; ", score becomes: "; Score + (5 * Lives)
  DelayStart(2) = TIMER: DO: LOOP UNTIL TIMER > DelayStart(2) + .2 OR TIMER < 3
  CLS
  DelayStart(2) = TIMER: DO: LOOP UNTIL TIMER > DelayStart(2) + .1 OR TIMER < 3
 LOOP UNTIL TIMER > DelayStart(1) + 2 OR TIMER < 3
Score = Score + (5 * Lives)
ScoreAtStartLevel = Score
END SUB

SUB Center (Row, Text$)
 IF Row > 0 THEN LOCATE Row
LOCATE , INT(40 - (LEN(Text$) / 2))
PRINT Text$
END SUB

SUB ChangeNumberOfLives
SOUND 37, 10
Lives = Lives - 1
 IF Lives = 0 THEN DisplayYouLost
END SUB

SUB ChangeScore
Score = Score + 1
 IF Score = ScoreAtStartLevel + (Level * 5) THEN GoToNextLevel
END SUB

SUB Choose (x, y, Prompt$, Choice$, Choices$)
LOCATE x, y: PRINT Prompt$
 DO
  Choice$ = UCASE$(INPUT$(1))
 LOOP UNTIL INSTR(Choices$, Choice$)
LOCATE x, y: PRINT SPC(LEN(Prompt$));
END SUB

SUB DisplayScoreList
COLOR 9: PRINT "     *** Score List ***"
OPEN "Scores.lst" FOR BINARY AS 1
 IF LOF(1) = 0 THEN
  PRINT "There are no scores."
 ELSE
  DO UNTIL LOC(1) = LOF(1)
   l = ASC(INPUT$(1, 1)): ScrName$ = INPUT$(l, 1)
   l = ASC(INPUT$(1, 1)): ScrScore$ = INPUT$(l, 1)
   l = ASC(INPUT$(1, 1)): ScrTime$ = INPUT$(l, 1)
   l = ASC(INPUT$(1, 1)): ScrDate$ = INPUT$(l, 1)
   PRINT USING "\             \  Score: \ \  \        \  \        \"; ScrName$; ScrScore$; ScrTime$; ScrDate$
  LOOP
 END IF
CLOSE 1
END SUB

SUB DisplayStatusBar
COLOR 9
LOCATE 28, 3
PRINT USING "Score: ###  Necessary Score for Next Level: ###  "; Score; ScoreAtStartLevel + (Level * 5);
PRINT USING "  Level: ###  Lives: ###"; Level; Lives
END SUB

SUB DisplayTitle
COLOR 2: LOCATE 2
PRINT "                  Balls,       "
PRINT "             by: Peter Swinkels "
PRINT "               ***2000***     "
END SUB

SUB DisplayYouLost
 FOR Frequency = 200 TO 100 STEP -20
  SOUND Frequency, 1
 NEXT Frequency
COLOR 4
DelayStart(1) = TIMER
 DO
  CLS
  DelayStart(2) = TIMER: DO: LOOP UNTIL TIMER > DelayStart(2) + .1 OR TIMER < 3
  LOCATE 3
  PRINT SPC(10); "                 "
  PRINT SPC(10); "                         "
  PRINT SPC(10); "                                "
  PRINT SPC(10); "                    "
  DelayStart(2) = TIMER: DO: LOOP UNTIL TIMER > DelayStart(2) + .2 OR TIMER < 3
 LOOP UNTIL TIMER > DelayStart(1) + 2 OR TIMER < 3
AddScore
AskPlayAgain
END SUB

SUB DisplayYouWon
 FOR Frequency = 100 TO 200 STEP 20
  SOUND Frequency, 1
 NEXT Frequency
COLOR 4
DelayStart(1) = TIMER
 DO
  CLS
  DelayStart(2) = TIMER: DO: LOOP UNTIL TIMER > DelayStart(2) + .1 OR TIMER < 3
  LOCATE 3
  PRINT SPC(10); "                     "
  PRINT SPC(10); "                    "
  PRINT SPC(10); "                          "
  PRINT SPC(10); "                        "
  DelayStart(2) = TIMER: DO: LOOP UNTIL TIMER > DelayStart(2) + .2 OR TIMER < 3
 LOOP UNTIL TIMER > DelayStart(1) + 2 OR TIMER < 3
AddScore
AskPlayAgain
END SUB

SUB GetNameAndLevel
InputBox 16, 1, "Name: ", Text$, 15
 IF Text$ = "" THEN Name$ = "no name" ELSE Name$ = Text$
Choose 17, 1, "Level (1-9):", Choice$, "123456789"
Level = VAL(Choice$)
Speed = Level * 2
END SUB

SUB GetScores
ERASE ScrName$, ScrScore$, ScrTime$, ScrDate$
OPEN "Scores.lst" FOR BINARY AS 1
 FOR ScoreN = 0 TO 9
   IF LOC(1) = LOF(1) THEN EXIT FOR
  l = ASC(INPUT$(1, 1)): ScrName$(ScoreN) = INPUT$(l, 1)
  l = ASC(INPUT$(1, 1)): ScrScore$(ScoreN) = INPUT$(l, 1)
  l = ASC(INPUT$(1, 1)): ScrTime$(ScoreN) = INPUT$(l, 1)
  l = ASC(INPUT$(1, 1)): ScrDate$(ScoreN) = INPUT$(l, 1)
 NEXT ScoreN
CLOSE 1
END SUB

SUB GoToNextLevel
 FOR Frequency = 100 TO 200 STEP 10
  SOUND Frequency, 1
 NEXT Frequency
 IF Lives > 1 THEN Bonus
 IF Level = 9 THEN DisplayYouWon
Level = Level + 1
Speed = Level * 2
END SUB

SUB InputBox (x, y, Prompt$, Text$, MaxLength)
 DO
  LOCATE x, y: PRINT Prompt$; Text$; "_ "
   DO
    Key$ = INKEY$
   LOOP WHILE Key$ = ""
  l = LEN(Text$)
   IF Key$ = CHR$(8) THEN
    IF l > 0 THEN Text$ = LEFT$(Text$, l - 1)
   ELSEIF Key$ = CHR$(13) THEN
    EXIT DO
   ELSEIF Key$ = CHR$(27) THEN
    Text$ = ""
    EXIT DO
   ELSEIF ASC(Key$) > 31 THEN
    IF l < MaxLength THEN Text$ = Text$ + Key$
   END IF
 LOOP
LOCATE x, y + (LEN(Prompt$) + l): PRINT " ";
END SUB

SUB Main
CLS
DisplayStatusBar
 DO
  DO
    IF TIMER > DelayStart(0) + .06 THEN
     MoveBall
     MovePlateau
     DelayStart(0) = TIMER
    ELSE
     IF TIMER < 3 THEN DelayStart(0) = TIMER
    END IF
   Key$ = INKEY$
  LOOP WHILE Key$ = ""
  IF Key$ = CHR$(0) + "K" THEN
   PlateauDirectionX = -1
  ELSEIF Key$ = CHR$(0) + "M" THEN
   PlateauDirectionX = 1
  ELSEIF Key$ = CHR$(27) THEN
   CLS
   Choose 3, 3, "Quit y/n?", Choice$, "YN"
    IF Choice$ = "Y" THEN Quit
   DisplayStatusBar
  ELSEIF UCASE$(Key$) = "P" THEN
   Center 10, "Game paused, press any key to continue."
    DO
     IF TIMER < 3 THEN DelayStart(0) = TIMER
    LOOP WHILE INKEY$ = ""
   LOCATE 10, 1: PRINT SPACE$(80)
  END IF
 LOOP
END SUB

SUB MoveBall
LINE (BallX - 8, BallY - 8)-(BallX + 8, BallY + 8), 0, BF

PreviousDirectionX = BallDirectionX
PreviousDirectionY = BallDirectionY

 IF BallSpeed > 15 THEN BallSpeed = BallSpeed - 1

 IF BallY > 415 - BallSpeed AND BallDirectionY = 1 THEN
   IF BallX > PlateauX - 11 AND BallX < PlateauX + 111 THEN
     IF NOT PlateauDirectionX = 0 THEN
      BallSpeed = BallSpeed + 10
      BallDirectionX = -PlateauDirectionX
     END IF
     IF NOT BallDirectionX = 0 THEN ChangeScore
   ELSE
    ChangeNumberOfLives
   END IF
  BallDirectionY = -1
 ELSE
  IF BallDirectionX = -1 THEN
   IF BallX < 11 THEN BallDirectionX = 1 ELSE BallX = BallX - BallSpeed - Speed
  ELSEIF BallDirectionX = 1 THEN
   IF BallX > 628 THEN BallDirectionX = -1 ELSE BallX = BallX + BallSpeed + Speed
  END IF
  IF BallDirectionY = -1 THEN
   IF BallY < 11 THEN BallDirectionY = 1 ELSE BallY = BallY - BallSpeed - Speed
  ELSEIF BallDirectionY = 1 THEN
   BallY = BallY + BallSpeed + Speed
  END IF
 END IF

 IF NOT BallDirectionX = PreviousDirectionX OR NOT BallDirectionY = PreviousDirectionY THEN
  SOUND 200, 1: SOUND 300, 1
 END IF

CIRCLE (BallX, BallY), 7, 2
PAINT (BallX, BallY), 2, 2

DisplayStatusBar
END SUB

SUB MovePlateau
LINE (PlateauX, 410)-(PlateauX + 100, 427), 0, BF
 IF PlateauDirectionX = -1 THEN
  IF PlateauX > 0 THEN PlateauX = PlateauX - 25 - Speed
 ELSEIF PlateauDirectionX = 1 THEN
  IF PlateauX < 539 THEN PlateauX = PlateauX + 25 + Speed
 END IF
LINE (PlateauX, 410)-(PlateauX + 100, 427), 4, BF

PlateauDirectionX = 0
END SUB

SUB Quit
SCREEN 0: CLS : WIDTH 80, 25: SYSTEM
END SUB

SUB SaveScores
OPEN "Scores.lst" FOR OUTPUT AS 1
 FOR ScoreN = 0 TO 9
  IF NOT ScrName$(ScoreN) = "" THEN
   PRINT #1, CHR$(LEN(ScrName$(ScoreN))); : PRINT #1, ScrName$(ScoreN);
   PRINT #1, CHR$(LEN(ScrScore$(ScoreN))); : PRINT #1, ScrScore$(ScoreN);
   PRINT #1, CHR$(LEN(ScrTime$(ScoreN))); : PRINT #1, ScrTime$(ScoreN);
   PRINT #1, CHR$(LEN(ScrDate$(ScoreN))); : PRINT #1, ScrDate$(ScoreN);
  END IF
 NEXT ScoreN
CLOSE 1
END SUB

SUB SetVariables
RANDOMIZE TIMER
BallDirectionX = CINT(RND * -2) + 1
BallDirectionY = 1
BallSpeed = 15
BallX = INT(RND * 619) + 10
Lives = 5
PlateauX = 270
PlateauDirectionX = 0
Score = 0
ScoreAtStartLevel = 0
END SUB

SUB SortScores
 FOR Score1 = 0 TO 10
  FOR Score2 = 0 TO 10
   IF VAL(ScrScore$(Score1)) > VAL(ScrScore$(Score2)) THEN
    SWAP ScrName$(Score1), ScrName$(Score2)
    SWAP ScrScore$(Score1), ScrScore$(Score2)
    SWAP ScrTime$(Score1), ScrTime$(Score2)
    SWAP ScrDate$(Score1), ScrDate$(Score2)
   END IF
  NEXT Score2
 NEXT Score1
END SUB

