/* cursor.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <allegro.h>
#include "cursor.h"


static char *image[] =
{
    /* 13 x 9 */
    " XX   X   XX ",
    "X     X     X",
    "X     Y     X",
    "             ",
    "XXXY  Y  YXXX",
    "             ",
    "X     Y     X",
    "X     X     X",
    " XX   X   XX "
};


static BITMAP *create()
{
    BITMAP *bmp;
    int x, y, c;
    
    bmp = create_bitmap(13, 9);
    
    for (y = 0; y < 9; y++)
	for (x = 0; x < 13; x++) {
	    switch (image[y][x]) {
		case 'X': c = makecol(157, 157, 246); break;
		case 'Y': c = makecol(10, 10, 10); break;
		default: c = 0; break;
	    }
	    putpixel(bmp, x, y, c);
	}

    return bmp;
}


static BITMAP *cursor;


void cursor_init()
{
    cursor = create();
    set_mouse_sprite(cursor);
    set_mouse_sprite_focus(6, 5);
}


void cursor_update()
{
    cursor_shutdown();
    cursor_init();
}


void cursor_draw(BITMAP *bmp)
{
    draw_sprite(bmp, cursor, mouse_x-6, mouse_y-5);
}


void cursor_shutdown()
{
    destroy_bitmap(cursor);
}
