/* data.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <stdio.h>
#include <allegro.h>
#include "data.h"


DATAFILE *data;
static FONT *default_font;


static char exe_path[1024];

static char *dirs[] =
{
    ".",
    exe_path,
#ifdef ALLEGRO_UNIX
    "/usr/local/share/barney",
    "/usr/share/barney",
#endif
    NULL
};


int load_data(char *argv0)
{
    char path[1024], **dir;

    replace_filename(exe_path, argv0, "", sizeof exe_path);

    for (dir = dirs; *dir; dir++) {
	sprintf(path, "%s/cpd.dat", *dir);
	if ((data = load_datafile(path))) {
	    default_font = font;
	    font = data[CPDFONT].dat;
	    break;
	}
    }

    return (data) ? 0 : -1;
}


void unload_data(void)
{
    if (default_font) 
	font = default_font;
    unload_datafile(data);
}
