/* flashes.c
 *
 * Peter Wang <tjaden@psynet.net>
 */


#include <allegro.h>
#include "data.h"
#include "flashes.h"


/* images in the datafile */
#define NUM_GUN_FLASHES   	4
#define NUM_ZAPS		2
#define NUM_BLOOD_FLASHES	3


#define MAX_FLASHES		30

static struct flash {
    int x, y;
    int pic;
    int tics;
} flash[MAX_FLASHES];


static void spawn(int x, int y, char pic, char tics)
{
    int i;

    for (i = 0; i < MAX_FLASHES; i++)
	if (!flash[i].tics) {
	    flash[i].x = x;
	    flash[i].y = y;
	    flash[i].pic = pic;
	    flash[i].tics = tics;
	    break;
	}
}


void spawn_blood_flash(int x, int y)
{
    spawn(x, y, BLOOD + (rand() % NUM_BLOOD_FLASHES), 8);
}


void spawn_blood_dot(int x, int y)
{
    spawn(x, y, BLOODDOT, 8);
}


void spawn_zap_flash(int x, int y)
{
    spawn(x, y, ZAP1 + (rand() % NUM_ZAPS), 2);
}


void spawn_gun_flash(int x, int y)
{
    spawn(x, y, FLASH1 + (rand() % NUM_GUN_FLASHES), 2);
}


void update_flashes()
{
    int i;

    for (i = 0; i < MAX_FLASHES; i++)
	if (flash[i].tics) flash[i].tics--;
}


void draw_flashes(BITMAP *dbuf)
{
    int i;
    
    for (i = 0; i < MAX_FLASHES; i++)
	if (flash[i].tics)
	    draw_sprite(dbuf, data[flash[i].pic].dat, flash[i].x, flash[i].y);
}


void init_flashes(void)
{
    int i;
    
    for (i = 0; i < MAX_FLASHES; i++)
	flash[i].tics = 0;
}
