'Clone of the classic Tetris game
'Named "Betris" after my last name.
'By Mike Beight, v0.6 finished May 7, 2000
'Email: piman_314@yahoo.com
'
'    * CONTROLS *
'  use arrows keys to control blocks:
'
' Left Arrow:  Move block left
' Right Arrow: Move block right
' Down Arrow:  Move block down
' Up Arrow:    Turn block counter-clockwise
'
'  use keyboard letters to change game settings:
'
' ESC: Quit game
' M:   Music On/Off
' P:   Pause/Unpause
'
'  *** Version 1.0 coming soon! ***
'
'****************************************************************************
'
CONST KeyAbout% = 65                     'The control keys
CONST KeyDown% = -80
CONST KeyHelp% = 72                      '(many are unfinished)
CONST KeyLeft% = -75
CONST KeyMusic% = 109
CONST KeyPause% = 112
CONST KeyQuit% = 27
CONST KeyRight% = -77
CONST KeySpeedDown% = 32
CONST KeyTurnClock% = 120
CONST KeyTurnCntr% = -72
CONST KeyTurnCntr2% = 122
CONST ScreenMode% = 13                      'Screen mode that game will be
                                           '  played in (mode 13 strongly
                                           '  recommended!)
DECLARE FUNCTION Blocked% (void)
DECLARE FUNCTION EnoughTimeElapsed% (void)
DECLARE FUNCTION OverLap% (Xcoord%, Ycoord%)
DECLARE FUNCTION LineFilled% (RowNum%)

DECLARE SUB About ()
DECLARE SUB BlockSpeedDown ()
DECLARE SUB BringInBlockNext ()
DECLARE SUB ChangeMusic ()
DECLARE SUB CheckForLines ()
DECLARE SUB DrawBlockStart ()
DECLARE SUB DrawBox (Xcoord%, Ycoord%, BoxColor%)
DECLARE SUB DrawBoxNext (Xcoord, Ycoord)
DECLARE SUB DrawBoxTurn (Xcoord%, Ycoord%, BoxNumTurn%)
DECLARE SUB GetKey ()
DECLARE SUB Help ()
DECLARE SUB Initialize ()
DECLARE SUB Intro ()
DECLARE SUB MoveBlockDown ()
DECLARE SUB MoveBlockLeft ()
DECLARE SUB MoveBlockRight ()
DECLARE SUB Pause ()
DECLARE SUB PauseGame ()
DECLARE SUB PlayAgain ()
DECLARE SUB PrintLevel ()
DECLARE SUB PrintScore ()
DECLARE SUB Quit ()
DECLARE SUB QuitAsk ()
DECLARE SUB RemoveBox (Xcoord%, Ycoord%)
DECLARE SUB ResetTimer ()
DECLARE SUB SpeedBlockDown ()
DECLARE SUB TurnBlockClock ()
DECLARE SUB TurnBlockCntr ()

    'Arrays:
DIM SHARED BlockColor%(6), BlockCoords%(3, 1), BlockType%, GameField%(9, 21)
DIM SHARED Lines%(3)
    'Variables:
DIM SHARED BlockBorderColor%, BlockNextType%, BlockPos%, GameOver%, level
DIM SHARED MusicOn%, NewGame%, NumLines%, score, start, TimerStep
    'and Music:
DIM SHARED MusicBounty$, MusicEnd$, MusicLine$, MusicOomph$, MusicPlayAgain$
DIM SHARED MusicTetris$

MusicBounty$ = "T140O4L8CL4FCL8B-.L16AL8GFL4G>C.P8<L4EF"
MusicOomph$ = "MBT175O0L16B"
MusicLine$ = "MBO6L16EC"
MusicTetris$ = "MBT160O4L16CEGEG"
MusicEnd$ = "MFT140O2L16EL8EEL16CL8DP64O1L16EL8EEL16CL8DP64O2L16EL8EEL16CL8DC.L25AB>C"
MusicPlayAgain$ = "MBT180O5L16GFC"

MusicOn% = 1                    'Set music on as default; user can change
                                '  this if he wishes
BlockColor%(0) = 6              'Assign the colors of each type of block
BlockColor%(1) = 6
BlockColor%(2) = 8
BlockColor%(3) = 8
BlockColor%(4) = 11
BlockColor%(5) = 11
BlockColor%(6) = 11
BlockBorderColor% = 2           'Assign the blocks' border color

Intro
DO
  Initialize
  DO
    IF TIMER - start >= TimerStep THEN MoveBlockDown
    GetKey
  LOOP UNTIL GameOver%
  PlayAgain
LOOP UNTIL NewGame% = 0
END

SUB About
END SUB

FUNCTION Blocked% (void)

SELECT CASE BlockType%
CASE 0
  IF GameField%(3, 2) OR GameField%(4, 2) OR GameField%(5, 2) OR GameField%(3, 3) THEN Blocked% = 1
CASE 1
  IF GameField%(3, 2) OR GameField%(4, 2) OR GameField%(5, 2) OR GameField%(5, 3) THEN Blocked% = 1
CASE 2
  IF GameField%(4, 2) OR GameField%(5, 2) OR GameField%(3, 3) OR GameField%(4, 3) THEN Blocked% = 1
CASE 3
  IF GameField%(3, 2) OR GameField%(4, 2) OR GameField%(4, 3) OR GameField%(5, 3) THEN Blocked% = 1
CASE 4
  IF GameField%(3, 2) OR GameField%(4, 2) OR GameField%(5, 2) OR GameField%(6, 2) THEN Blocked% = 1
CASE 5
  IF GameField%(4, 2) OR GameField%(5, 2) OR GameField%(4, 3) OR GameField%(5, 3) THEN Blocked% = 1
CASE 6
  IF GameField%(3, 2) OR GameField%(4, 2) OR GameField%(5, 2) OR GameField%(4, 3) THEN Blocked% = 1
END SELECT

END FUNCTION

SUB BlockSpeedDown
END SUB

SUB BringInBlockNext

FOR row% = 0 TO 1                  'Clear the top two lines of the game field
  FOR column% = 0 TO 9             '  which cannot be seen
    GameField%(column%, row%) = 0
  NEXT
NEXT

LINE (234, 64)-(265, 95), 0, BF    'Clear the "next block" space

BlockType% = BlockNextType%
BlockPos% = 0

IF Blocked%(void) THEN             'If the field is already blocked, then
  DrawBlockStart                   '  sorry, you lost!
  Quit
ELSE
  DrawBlockStart
END IF

SELECT CASE BlockType%
CASE 0
  BlockCoords%(0, 0) = 3           'Record the new block's x and y coordinates
  BlockCoords%(0, 1) = 2
  BlockCoords%(1, 0) = 4
  BlockCoords%(1, 1) = 2
  BlockCoords%(2, 0) = 5
  BlockCoords%(2, 1) = 2
  BlockCoords%(3, 0) = 3
  BlockCoords%(3, 1) = 3
CASE 1
  BlockCoords%(0, 0) = 3
  BlockCoords%(0, 1) = 2
  BlockCoords%(1, 0) = 4
  BlockCoords%(1, 1) = 2
  BlockCoords%(2, 0) = 5
  BlockCoords%(2, 1) = 2
  BlockCoords%(3, 0) = 5
  BlockCoords%(3, 1) = 3
CASE 2
  BlockCoords%(0, 0) = 4
  BlockCoords%(0, 1) = 2
  BlockCoords%(1, 0) = 5
  BlockCoords%(1, 1) = 2
  BlockCoords%(2, 0) = 3
  BlockCoords%(2, 1) = 3
  BlockCoords%(3, 0) = 4
  BlockCoords%(3, 1) = 3
CASE 3
  BlockCoords%(0, 0) = 3
  BlockCoords%(0, 1) = 2
  BlockCoords%(1, 0) = 4
  BlockCoords%(1, 1) = 2
  BlockCoords%(2, 0) = 4
  BlockCoords%(2, 1) = 3
  BlockCoords%(3, 0) = 5
  BlockCoords%(3, 1) = 3
CASE 4
  BlockCoords%(0, 0) = 3
  BlockCoords%(0, 1) = 2
  BlockCoords%(1, 0) = 4
  BlockCoords%(1, 1) = 2
  BlockCoords%(2, 0) = 5
  BlockCoords%(2, 1) = 2
  BlockCoords%(3, 0) = 6
  BlockCoords%(3, 1) = 2
CASE 5
  BlockCoords%(0, 0) = 4
  BlockCoords%(0, 1) = 2
  BlockCoords%(1, 0) = 5
  BlockCoords%(1, 1) = 2
  BlockCoords%(2, 0) = 4
  BlockCoords%(2, 1) = 3
  BlockCoords%(3, 0) = 5
  BlockCoords%(3, 1) = 3
CASE 6
  BlockCoords%(0, 0) = 3
  BlockCoords%(0, 1) = 2
  BlockCoords%(1, 0) = 4
  BlockCoords%(1, 1) = 2
  BlockCoords%(2, 0) = 5
  BlockCoords%(2, 1) = 2
  BlockCoords%(3, 0) = 4
  BlockCoords%(3, 1) = 3
END SELECT

BlockNextType% = INT(RND * 7)        'Choose next block type

SELECT CASE BlockNextType%
CASE 0
  CALL DrawBoxNext(.5, 0)         'Draw next block in the "next block" space
  CALL DrawBoxNext(1.5, 0)
  CALL DrawBoxNext(2.5, 0)
  CALL DrawBoxNext(.5, 1)
CASE 1
  CALL DrawBoxNext(.5, 0)
  CALL DrawBoxNext(1.5, 0)
  CALL DrawBoxNext(2.5, 0)
  CALL DrawBoxNext(2.5, 1)
CASE 2
  CALL DrawBoxNext(1.5, 0)
  CALL DrawBoxNext(2.5, 0)
  CALL DrawBoxNext(.5, 1)
  CALL DrawBoxNext(1.5, 1)
CASE 3
  CALL DrawBoxNext(.5, 0)
  CALL DrawBoxNext(1.5, 0)
  CALL DrawBoxNext(1.5, 1)
  CALL DrawBoxNext(2.5, 1)
CASE 4
  CALL DrawBoxNext(0, .5)
  CALL DrawBoxNext(1, .5)
  CALL DrawBoxNext(2, .5)
  CALL DrawBoxNext(3, .5)
CASE 5
  CALL DrawBoxNext(1, 0)
  CALL DrawBoxNext(2, 0)
  CALL DrawBoxNext(1, 1)
  CALL DrawBoxNext(2, 1)
CASE 6
  CALL DrawBoxNext(.5, 0)
  CALL DrawBoxNext(1.5, 0)
  CALL DrawBoxNext(2.5, 0)
  CALL DrawBoxNext(1.5, 1)
END SELECT

ResetTimer

END SUB

SUB ChangeMusic

LOCATE 23, 28        'Position the cursor to write "ON" or "OFF"
LINE (280, 176)-(287, 183), 1, BF
IF MusicOn% THEN     'If the music and sound effects are currently, then
  MusicOn% = 0       '  switch them off; if their off, then turn them on
  PRINT "Music OFF"
ELSE
  MusicOn% = 1
  PRINT "Music ON"
END IF

END SUB

SUB CheckForLines

FOR row% = 2 TO 21             'Check the field for any completed lines
  IF LineFilled%(row%) THEN           'Store the completed line's number in
    Lines%(NumLinesTemp%) = row%      '  the array for quick reference when
    NumLinesTemp% = NumLinesTemp% + 1 '  it comes time to clear it
  END IF
NEXT

IF NumLinesTemp% > 0 AND NumLinesTemp% < 3 THEN 'If lines were made then
  IF MusicOn% THEN PLAY MusicLine$              '  make some noise!
ELSEIF NumLinesTemp% > 3 THEN
  IF MusicOn% THEN PLAY MusicTetris$
END IF

IF NumLinesTemp% > 0 THEN                     'Make the lines flash on and off
  FOR blink% = 1 TO 3
    FOR LineNum% = 0 TO NumLinesTemp% - 1
      LINE (120, 5 + 8 * Lines%(LineNum%))-(199, 12 + 8 * Lines%(LineNum%)), 14, B
    NEXT
    Pause
    FOR LineNum% = 0 TO NumLinesTemp% - 1
      LINE (120, 5 + 8 * Lines%(LineNum%))-(199, 12 + 8 * Lines%(LineNum%)), 0, B
    NEXT
    Pause
  NEXT
  NumLines% = NumLines% + NumLinesTemp%'Update the number of lines so far
  LOCATE 2, 23
  PRINT LTRIM$(STR$(NumLines%))
  IF INT(NumLines% / 10) > level THEN  'Check the number of lines so far to
    level = level + 1                  '  determine whether or not a level
    PrintLevel                         '  change is needed
  END IF
  SELECT CASE NumLinesTemp%
  CASE 1
  points = 40 * (level + 1)            'Determine how much the lines are worth
  CASE 2
  points = 100 * (level + 1)
  CASE 3
  points = 300 * (level + 1)
  CASE 4
  points = 1200 * (level + 1)
  END SELECT
  score = score + points                'Add the points earned to the total
  PrintScore                            '  score, and print it on the screen
END IF

FOR LineNum% = 0 TO NumLinesTemp% - 1
   row% = Lines%(LineNum%)               'Remove the lines one by one
   FOR column% = 0 TO 9
     CALL RemoveBox(column%, row%)
   NEXT
   FOR ShiftRow% = row% - 1 TO 2 STEP -1 'Shift the other blocks in the field
     FOR ShiftCol% = 0 TO 9              '  down
       IF GameField%(ShiftCol%, ShiftRow%) THEN
         CALL DrawBox(ShiftCol%, ShiftRow% + 1, POINT(121 + 8 * ShiftCol%, 6 + 8 * ShiftRow%))
         CALL RemoveBox(ShiftCol%, ShiftRow%)
       END IF
     NEXT
   NEXT
NEXT

END SUB

SUB DrawBlockStart

DrawColor% = BlockColor%(BlockType%)

SELECT CASE BlockType%         'Determine the current block type
CASE 0
CALL DrawBox(3, 2, DrawColor%)            'Draw that block in the game field
CALL DrawBox(4, 2, DrawColor%)
CALL DrawBox(5, 2, DrawColor%)
CALL DrawBox(3, 3, DrawColor%)
CASE 1
CALL DrawBox(3, 2, DrawColor%)
CALL DrawBox(4, 2, DrawColor%)
CALL DrawBox(5, 2, DrawColor%)
CALL DrawBox(5, 3, DrawColor%)
CASE 2
CALL DrawBox(4, 2, DrawColor%)
CALL DrawBox(5, 2, DrawColor%)
CALL DrawBox(3, 3, DrawColor%)
CALL DrawBox(4, 3, DrawColor%)
CASE 3
CALL DrawBox(3, 2, DrawColor%)
CALL DrawBox(4, 2, DrawColor%)
CALL DrawBox(4, 3, DrawColor%)
CALL DrawBox(5, 3, DrawColor%)
CASE 4
CALL DrawBox(3, 2, DrawColor%)
CALL DrawBox(4, 2, DrawColor%)
CALL DrawBox(5, 2, DrawColor%)
CALL DrawBox(6, 2, DrawColor%)
CASE 5
CALL DrawBox(4, 2, DrawColor%)
CALL DrawBox(5, 2, DrawColor%)
CALL DrawBox(4, 3, DrawColor%)
CALL DrawBox(5, 3, DrawColor%)
CASE 6
CALL DrawBox(3, 2, DrawColor%)
CALL DrawBox(4, 2, DrawColor%)
CALL DrawBox(5, 2, DrawColor%)
CALL DrawBox(4, 3, DrawColor%)
END SELECT

END SUB

SUB DrawBox (Xcoord%, Ycoord%, BoxColor%)

IF Ycoord% >= 2 THEN                   'Determine whether or not the box will
                                       '  will be able to be seen on screen
                                       '  (not in the first two rows)
  Xstart% = 120 + 8 * Xcoord%          'Determine starting coordinates
  Ystart% = 5 + 8 * Ycoord%

  LINE (Xstart%, Ystart%)-(Xstart% + 7, Ystart%), BlockBorderColor% 'Draw box
  LINE (Xstart%, Ystart%)-(Xstart%, Ystart% + 7), BlockBorderColor%

  LINE (Xstart% + 1, Ystart% + 1)-(Xstart% + 6, Ystart% + 6), BoxColor%, BF
END IF

GameField%(Xcoord%, Ycoord%) = 1      'Record the new box in the game field array

END SUB

SUB DrawBoxNext (Xcoord, Ycoord)

Xstart% = 234 + 8 * Xcoord       'Determine starting coordinates
Ystart% = 71 + 8 * Ycoord

LINE (Xstart%, Ystart%)-(Xstart% + 7, Ystart%), BlockBorderColor%, B'Draw the
LINE (Xstart%, Ystart%)-(Xstart%, Ystart% + 7), BlockBorderColor%, B'  box

LINE (Xstart% + 1, Ystart% + 1)-(Xstart% + 6, Ystart% + 6), BlockColor%(BlockNextType%), BF

END SUB

SUB DrawBoxTurn (Xcoord%, Ycoord%, BoxNumTurn%)

IF Ycoord% >= 2 THEN                'Determine if the box will be able to be
                                    '  seen on screen (not in the first teo
                                    '  rows)
  Xstart% = 120 + 8 * Xcoord%       'Calculate starting point coordinates
  Ystart% = 5 + 8 * Ycoord%

  LINE (Xstart%, Ystart%)-(Xstart% + 7, Ystart%), BlockBorderColor%, B  'Draw the block's
  LINE (Xstart%, Ystart%)-(Xstart%, Ystart% + 7), BlockBorderColor%, B  '  border

  LINE (Xstart% + 1, Ystart% + 1)-(Xstart% + 6, Ystart% + 6), BlockColor%(BlockType%), BF 'Draw inside of block
END IF

BlockCoords%(BoxNumTurn%, 0) = Xcoord%   'Record the new box in the current
BlockCoords%(BoxNumTurn%, 1) = Ycoord%   '  block's coordinates

GameField%(Xcoord%, Ycoord%) = 1         'Record the new box in the game
                                         '  field array
END SUB

SUB GetKey

k$ = INKEY$                        'Get a key from the keyboard
IF k$ = "" THEN EXIT SUB

IF LEN(k$) = 2 THEN                'Convert the key string to a number value
  value% = -ASC(RIGHT$(k$, 1))
ELSE
  value% = ASC(k$)
END IF

SELECT CASE value%                 'Determine what key was pressed, and act
CASE KeyTurnClock%                 '  accordingly
  TurnBlockClock
CASE KeyTurnCntr%
  TurnBlockCntr
CASE KeyTurnCntr2%
  TurnBlockCntr
CASE KeyRight%
  MoveBlockRight
CASE KeyLeft%
  MoveBlockLeft
CASE KeyDown%
  MoveBlockDown
CASE KeySpeedDown%
  BlockSpeedDown
CASE KeyQuit%
  QuitAsk
CASE KeyMusic%
  ChangeMusic
CASE KeyPause%
  PauseGame
CASE KeyHelp%
  Help
CASE KeyAbout%
  About
END SELECT

END SUB

SUB Help
END SUB

SUB Initialize

CLS

LINE (0, 0)-(319, 199), 1, BF        'Make whole screen dark blue
LINE (120, 21)-(199, 180), 0, BF     'Draw black game field in middle

LINE (117, 18)-(203, 20), 4, BF      'Make border around game field
LINE (117, 181)-(203, 184), 4, BF
LINE (117, 18)-(119, 182), 4, BF
LINE (200, 18)-(203, 182), 4, BF
LINE (116, 17)-(203, 17), 14
LINE (116, 17)-(116, 184), 14
LINE (203, 18)-(203, 184), 0
LINE (117, 184)-(203, 184), 0

LINE (234, 64)-(265, 95), 0, BF      'Draw black space for "next block"

LINE (230, 60)-(269, 63), 4, BF      'Make border around next block space
LINE (230, 96)-(269, 99), 4, BF
LINE (230, 60)-(233, 99), 4, BF
LINE (266, 60)-(269, 99), 4, BF
LINE (230, 60)-(269, 60), 14
LINE (230, 60)-(230, 99), 14
LINE (269, 61)-(269, 99), 0
LINE (231, 99)-(269, 99), 0

LINE (215, 16)-(278, 37), 0, BF      'Make the Betris logo box
LINE (215, 16)-(278, 37), 2, B
LINE (216, 17)-(277, 36), 4, B
LOCATE 4, 29
COLOR 9
PRINT "BETRIS"
COLOR 15

LINE (218, 122)-(281, 155), 0, BF    'Draw level box
LINE (218, 122)-(281, 155), 4, B
LOCATE 17, 29
PRINT "level?"                       'Ask user for starting level
LOCATE 19, 30
PRINT "(0-9)"
DO
  k$ = INKEY$
  IF k$ <> "" THEN k% = ASC(k$)
LOOP UNTIL k% >= 48 AND k% <= 57
level = ASC(k$) - 48
LINE (219, 123)-(280, 154), 0, BF
LOCATE 17, 29                        'Print level on screen
PRINT "LEVEL"
PrintLevel

BlockNextType% = INT(RND * 7)        'Randomly choose the next block
BringInBlockNext                     'Bring in next block; create new "next block"

LOCATE 2, 16                         'Print how many lines above game field
PRINT "Lines: "
NumLines% = 0
LOCATE 2, 23
PRINT LTRIM$(STR$(NumLines%))
LOCATE 7, 30
PRINT "Next"

LINE (43, 20)-(107, 42), 0, BF       'Draw the score window
LINE (43, 20)-(107, 42), 4, B
LOCATE 4, 7
PRINT "SCORE"
score = 0                            'Reset score to 0
PrintScore                           'Print score on screen

ChangeMusic                          'This is done to initiate the
ChangeMusic                          '  "Music ON/OFF" sign on the screen

GameOver% = 0

ResetTimer                           'Just what it says

END SUB                              'Get outa here an' go play Betris!

SUB Intro

RANDOMIZE TIMER                      'You wouldn't want the same sequence of
                                     '  blocks every time, now would you?
SCREEN ScreenMode%

COLOR 10
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT
PRINT "               **********"
PRINT "               *        *"
PRINT "               * BETRIS *"
PRINT "               *        *"
PRINT "               **********"
PRINT
PRINT "              version  0.6"
PRINT
PRINT : COLOR 3
PRINT "       Programmed by  Mike Beight"
PRINT
PRINT "          piman_314@yahoo.com"

PLAY MusicBounty$                    'Don't ask me why I chose this song for
                                     '  an intro
COLOR 9
PRINT
PRINT
PRINT "            Press any key..."
SLEEP

SCREEN 9
COLOR 9
CLS
PRINT "* * * * * * * * * * * * * * * * * * BETRIS  * * * * * * * * * * * * * * * * * *"
PRINT "*                                                                             *"
PRINT "*                                                                             *"
PRINT "*         Betris is a game in which the object is to keep the well            *"
PRINT "*         from filling  up with blocks, which come in a variety of            *"
PRINT "*         shapes.  These blocks will enter  the screen from  above            *"
PRINT "*         and fall slowly to the bottom.  When a complete row,  or            *"
PRINT "*         line,  of boxes is made,  that line disappears,  and you            *"
PRINT "*         get points. As you accumulate lines and points, the game            *"
PRINT "*         level will change, and the blocks will fall faster!                 *"
PRINT "*                                                                             *"
PRINT "* * * * * * * * * * * * * * * * GAME CONTROLS * * * * * * * * * * * * * * * * *"
PRINT "*                                                                             *"
PRINT "*              General                           Block Control                *"
PRINT "*                                                                             *"
PRINT "*            ESC - Quit                             Rotate                    *"
PRINT "*            M   - Music On/Off                        " + CHR$(24) + "                      *"
PRINT "*            P   - Pause/Unpause               Left " + CHR$(27) + "     " + CHR$(26) + " Right             *"
PRINT "*                                                      " + CHR$(25) + "                      *"
PRINT "*                                                    " + "Down                     *"
PRINT "*                                                                             *"
PRINT "*                                                                             *"
PRINT "* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *"
SLEEP
SCREEN ScreenMode%

END SUB

FUNCTION LineFilled% (RowNum%)
FOR ColNum% = 0 TO 9                       'Check through all of the spaces
  IF GameField%(ColNum%, RowNum%) = 0 THEN '  in that row. If even one of those
    LineFilled% = 0                        '  spaces does not contain a box,
    EXIT FUNCTION                          '  then the line is not complete.
  END IF
NEXT

LineFilled% = 1                            'If a blank space has not been
                                           '  detected, then the whole row
                                           '  is filled
END FUNCTION

SUB MoveBlockDown

FOR BoxNum% = 0 TO 3                      'Determine whether or not the "coast
  X% = BlockCoords%(BoxNum%, 0)           '  is clear" for the block to move
  Y% = BlockCoords%(BoxNum%, 1)
  IF Y% + 1 > 21 THEN
    BlockedDownTruth% = 1
    EXIT FOR
  END IF
  IF GameField%(X%, Y% + 1) THEN
    IF OverLap%(X%, Y% + 1) = 0 THEN
      BlockedDownTruth% = 1
      EXIT FOR
    END IF
  END IF
NEXT

IF BlockedDownTruth% THEN                 'If the block has "landed" then
  IF MusicOn% THEN PLAY MusicOomph$       '  play the "oomph" sound
  CheckForLines
  BringInBlockNext
ELSE
  FOR BoxNum% = 0 TO 3                     'Remove the old block
    CALL RemoveBox(BlockCoords%(BoxNum%, 0), BlockCoords%(BoxNum%, 1))
  NEXT
  
  FOR BoxNum% = 0 TO 3                     'Draw the new block
    CALL DrawBox(BlockCoords%(BoxNum%, 0), BlockCoords%(BoxNum%, 1) + 1, BlockColor%(BlockType%))
    BlockCoords%(BoxNum%, 1) = BlockCoords%(BoxNum%, 1) + 1
  NEXT
  ResetTimer
END IF
END SUB

SUB MoveBlockLeft

FOR BoxNum% = 0 TO 3                      'Determine whether or not the "coast is clear"
  X% = BlockCoords%(BoxNum%, 0)
  Y% = BlockCoords%(BoxNum%, 1)
  IF X% - 1 < 0 THEN EXIT SUB
  IF GameField%(X% - 1, Y%) THEN
    IF OverLap%(X% - 1, Y%) = 0 THEN EXIT SUB
  END IF
NEXT

FOR BoxNum% = 0 TO 3                     'Remove the old block
  CALL RemoveBox(BlockCoords%(BoxNum%, 0), BlockCoords%(BoxNum%, 1))
NEXT

FOR BoxNum% = 0 TO 3                     'Draw the new block
  CALL DrawBox(BlockCoords%(BoxNum%, 0) - 1, BlockCoords%(BoxNum%, 1), BlockColor%(BlockType%))
  BlockCoords%(BoxNum%, 0) = BlockCoords%(BoxNum%, 0) - 1
NEXT

END SUB

SUB MoveBlockRight

FOR BoxNum% = 0 TO 3                      'Determine whether or not the "coast is clear"
  X% = BlockCoords%(BoxNum%, 0)
  Y% = BlockCoords%(BoxNum%, 1)
  IF X% + 1 > 9 THEN EXIT SUB
  IF GameField%(X% + 1, Y%) THEN
    IF OverLap%(X% + 1, Y%) = 0 THEN EXIT SUB
  END IF
NEXT

FOR BoxNum% = 0 TO 3                     'Remove the old block
  CALL RemoveBox(BlockCoords%(BoxNum%, 0), BlockCoords%(BoxNum%, 1))
NEXT

FOR BoxNum% = 0 TO 3                     'Draw the new block
  CALL DrawBox(BlockCoords%(BoxNum%, 0) + 1, BlockCoords%(BoxNum%, 1), BlockColor%(BlockType%))
  BlockCoords%(BoxNum%, 0) = BlockCoords%(BoxNum%, 0) + 1
NEXT

END SUB

FUNCTION OverLap% (Xcoord%, Ycoord%)
FOR BoxTest% = 0 TO 3
  IF BlockCoords%(BoxTest%, 0) = Xcoord% AND BlockCoords%(BoxTest%, 1) = Ycoord% THEN
    OverLap% = 1                'Test to see if the next space over from the
    EXIT FUNCTION               '  space being tested is filled with one of
  END IF                        '  the block's own squares or a box that has
NEXT                            '  already landed
OverLap% = 0
END FUNCTION

SUB Pause

PauseStart = TIMER

WHILE TIMER - PauseStart < .05  'Halt game activity (except for sound) for a
WEND                            '  small amount of time

END SUB

SUB PauseGame

TimerStop = TIMER

LINE (6, 58)-(113, 90), 0, BF   'Draw pause box
LINE (6, 58)-(113, 90), 4, B

LOCATE 10, 5
PRINT "PAUSED"

DO                             'Wait for the user to press "p"
  k$ = INKEY$
LOOP UNTIL k$ = "p" OR k$ = "P"

LINE (6, 58)-(113, 90), 1, BF  'Erase the pause box

start = start + TIMER - TimerStop '  playing

END SUB

SUB PlayAgain

LINE (6, 58)-(113, 90), 0, BF           'Draw the "play again" box
LINE (6, 58)-(113, 90), 4, B

IF MusicOn% THEN PLAY MusicPlayAgain$   'Ask user if he wants to play another
LOCATE 9, 2                             '  game
PRINT " Play again? "
LOCATE 11, 6
PRINT "(Y/N)"

DO                                     'Get an input (either "Y" or "N") from
  k$ = UCASE$(INKEY$)                  '  the keyboard
LOOP UNTIL k$ = "Y" OR k$ = "N"

IF k$ = "N" THEN                       'If user chose "N" then shut down and
  IF MusicOn% THEN PLAY MusicEnd$      '  quit the program
  a = TIMER
  DO: LOOP UNTIL TIMER - a >= 1.5      'In the EXE version of this program,
                                       '  this timer is used to keep the
                                       '  the program from exiting before the
                                       '  music is over
  NewGame% = 0
ELSE
  ERASE GameField%                     'If user chose "Y" then clear the game
  NewGame% = 1                         '  field and start another game
END IF

END SUB

SUB PrintLevel

LOCATE 19, 35 - LEN(LTRIM$(STR$(level))) 'Print the current level on the
PRINT LTRIM$(STR$(level))                '  screen

TimerStep = 1 / (1.22 ^ level)            'Determine how fast the next blocks
                                         ' in this level will fall
END SUB

SUB PrintScore

LOCATE 5, 7
PRINT "0000000"

LOCATE 5, 14 - LEN(LTRIM$(STR$(score))) 'Print the current score on the screen
PRINT LTRIM$(STR$(score))

END SUB

SUB Quit

GameOver% = 1

END SUB

SUB QuitAsk

TimerStop = TIMER                   'Mark the time to keep a record of where
                                    '  the falling block was interrupted
LINE (6, 58)-(113, 90), 0, BF       'Draw quit box
LINE (6, 58)-(113, 90), 4, B

LOCATE 9, 6
PRINT "Quit?"
LOCATE 11, 6
PRINT "(Y/N)"

DO                                  'Get an answer (either "Y" or "N")
  k$ = UCASE$(INKEY$)
LOOP UNTIL k$ = "Y" OR k$ = "N"

IF k$ = "Y" THEN                    'If user chose to quit, then quit the game
  GameOver% = 1
ELSE
  LINE (6, 58)-(113, 90), 1, BF     'If user chose not to quit, then resume
  start = start + TIMER - TimerStop '  playing
END IF

END SUB

SUB RemoveBox (Xcoord%, Ycoord%)

IF Ycoord% >= 2 THEN
  Xstart% = 120 + 8 * Xcoord%     'Determine the starting coordinates of the box
  Ystart% = 5 + 8 * Ycoord%

  LINE (Xstart%, Ystart%)-(Xstart% + 7, Ystart% + 7), 0, BF 'Draw the box
END IF

GameField%(Xcoord%, Ycoord%) = 0  'Record this spot in the game field as a
                                  '  "taken spot"
END SUB

SUB ResetTimer

start = TIMER      'Mark this point in time to be used for controlling the
                   '  rate at which the block comes down

END SUB

SUB SpeedBlockDown
END SUB

SUB TurnBlockClock
END SUB

SUB TurnBlockCntr
       
       ' *******************************************
       ' * Turn block counter-clockwise 90 degrees *
       ' *******************************************

X% = BlockCoords%(1, 0)             'Save the block's coordinates to temporary
Y% = BlockCoords%(1, 1)             '  variables (because this is a rather
                                    '  lengthy subroutine!)
SELECT CASE BlockType%
CASE 0
  SELECT CASE BlockPos%
  CASE 0
    IF Y% - 1 >= 0 THEN
      IF GameField%(X%, Y% - 1) = 0 AND GameField%(X%, Y% + 1) = 0 AND GameField%(X% + 1, Y% + 1) = 0 THEN
        CALL RemoveBox(X% - 1, Y%)
        CALL RemoveBox(X% + 1, Y%)
        CALL RemoveBox(X% - 1, Y% + 1)
        CALL DrawBoxTurn(X%, Y% - 1, 2)
        CALL DrawBoxTurn(X%, Y% + 1, 0)
        CALL DrawBoxTurn(X% + 1, Y% + 1, 3)
        BlockPos% = 1
      END IF
    END IF
  CASE 1
    IF X% - 1 >= 0 THEN
      IF GameField%(X% - 1, Y%) = 0 AND GameField%(X% + 1, Y%) = 0 AND GameField%(X% + 1, Y% - 1) = 0 THEN
        CALL RemoveBox(X%, Y% - 1)
        CALL RemoveBox(X%, Y% + 1)
        CALL RemoveBox(X% + 1, Y% + 1)
        CALL DrawBoxTurn(X% - 1, Y%, 2)
        CALL DrawBoxTurn(X% + 1, Y%, 0)
        CALL DrawBoxTurn(X% + 1, Y% - 1, 3)
        BlockPos% = 2
      END IF
    END IF
  CASE 2
    IF Y% + 1 <= 19 THEN
      IF GameField%(X% - 1, Y% - 1) = 0 AND GameField%(X%, Y% - 1) = 0 AND GameField%(X%, Y% + 1) = 0 THEN
        CALL RemoveBox(X% + 1, Y% - 1)
        CALL RemoveBox(X% - 1, Y%)
        CALL RemoveBox(X% + 1, Y%)
        CALL DrawBoxTurn(X% - 1, Y% - 1, 3)
        CALL DrawBoxTurn(X%, Y% - 1, 0)
        CALL DrawBoxTurn(X%, Y% + 1, 2)
        BlockPos% = 3
      END IF
    END IF
  CASE 3
    IF X% + 1 <= 9 THEN
      IF GameField%(X% - 1, Y%) = 0 AND GameField%(X% + 1, Y%) = 0 AND GameField%(X% - 1, Y% + 1) = 0 THEN
        CALL RemoveBox(X% - 1, Y% - 1)
        CALL RemoveBox(X%, Y% - 1)
        CALL RemoveBox(X%, Y% + 1)
        CALL DrawBoxTurn(X% - 1, Y%, 0)
        CALL DrawBoxTurn(X% + 1, Y%, 2)
        CALL DrawBoxTurn(X% - 1, Y% + 1, 3)
        BlockPos% = 0
      END IF
    END IF
  END SELECT
CASE 1
  SELECT CASE BlockPos%
  CASE 0
    IF Y% - 1 >= 0 THEN
      IF GameField%(X%, Y% - 1) = 0 AND GameField%(X% + 1, Y% - 1) = 0 AND GameField%(X%, Y% + 1) = 0 THEN
        CALL RemoveBox(X% - 1, Y%)
        CALL RemoveBox(X% + 1, Y%)
        CALL RemoveBox(X% + 1, Y% + 1)
        CALL DrawBoxTurn(X%, Y% - 1, 2)
        CALL DrawBoxTurn(X% + 1, Y% - 1, 3)
        CALL DrawBoxTurn(X%, Y% + 1, 0)
        BlockPos% = 1
      END IF
    END IF
  CASE 1
    IF X% - 1 >= 0 THEN
      IF GameField%(X% - 1, Y% - 1) = 0 AND GameField%(X% - 1, Y%) = 0 AND GameField%(X% + 1, Y%) = 0 THEN
        CALL RemoveBox(X%, Y% - 1)
        CALL RemoveBox(X% + 1, Y% - 1)
        CALL RemoveBox(X%, Y% + 1)
        CALL DrawBoxTurn(X% - 1, Y% - 1, 3)
        CALL DrawBoxTurn(X% - 1, Y%, 2)
        CALL DrawBoxTurn(X% + 1, Y%, 0)
        BlockPos% = 2
      END IF
    END IF
  CASE 2
    IF Y% + 1 <= 19 THEN
      IF GameField%(X%, Y% - 1) = 0 AND GameField%(X% - 1, Y% + 1) = 0 AND GameField%(X%, Y% + 1) = 0 THEN
        CALL RemoveBox(X% - 1, Y% - 1)
        CALL RemoveBox(X% - 1, Y%)
        CALL RemoveBox(X% + 1, Y%)
        CALL DrawBoxTurn(X%, Y% - 1, 0)
        CALL DrawBoxTurn(X% - 1, Y% + 1, 3)
        CALL DrawBoxTurn(X%, Y% + 1, 2)
        BlockPos% = 3
      END IF
    END IF
  CASE 3
    IF X% + 1 <= 9 THEN
      IF GameField%(X% - 1, Y%) = 0 AND GameField%(X% + 1, Y%) = 0 AND GameField%(X% + 1, Y% + 1) = 0 THEN
        CALL RemoveBox(X%, Y% - 1)
        CALL RemoveBox(X% - 1, Y% + 1)
        CALL RemoveBox(X%, Y% + 1)
        CALL DrawBoxTurn(X% - 1, Y%, 0)
        CALL DrawBoxTurn(X% + 1, Y%, 2)
        CALL DrawBoxTurn(X% + 1, Y% + 1, 3)
        BlockPos% = 0
      END IF
    END IF
  END SELECT
CASE 2
  SELECT CASE BlockPos%
  CASE 0
    IF Y% - 1 >= 0 THEN
      IF GameField%(X% - 1, Y% - 1) = 0 AND GameField%(X%, Y% + 1) = 0 THEN
        CALL RemoveBox(X% - 1, Y% + 1)
        CALL RemoveBox(X% - 2, Y% + 1)
        CALL DrawBoxTurn(X% - 1, Y% - 1, 1)
        CALL DrawBoxTurn(X%, Y% + 1, 2)
        BlockCoords%(3, 0) = X%
        BlockCoords%(3, 1) = Y%
        BlockPos% = 1
      END IF
    END IF
  CASE 1
    IF X% - 1 >= 0 THEN
      IF GameField%(X% - 1, Y% + 2) = 0 AND GameField%(X%, Y% + 2) = 0 THEN
        CALL RemoveBox(X%, Y%)
        CALL RemoveBox(X% + 1, Y% + 2)
        CALL DrawBoxTurn(X% - 1, Y% + 2, 2)
        CALL DrawBoxTurn(X%, Y% + 2, 3)
        BlockCoords%(0, 0) = X%
        BlockCoords%(0, 1) = Y% + 1
        BlockCoords%(1, 0) = X% + 1
        BlockCoords%(1, 1) = Y% + 1
        BlockPos% = 0
      END IF
    END IF
  END SELECT
CASE 3
  SELECT CASE BlockPos%
  CASE 0
    IF Y% - 1 >= 0 THEN
      IF GameField%(X% + 1, Y% - 1) = 0 AND GameField%(X% + 1, Y%) = 0 THEN
        CALL RemoveBox(X% - 1, Y%)
        CALL RemoveBox(X% + 1, Y% + 1)
        CALL DrawBoxTurn(X% + 1, Y% - 1, 3)
        CALL DrawBoxTurn(X% + 1, Y%, 2)
        BlockCoords%(0, 0) = X%
        BlockCoords%(0, 1) = Y% + 1
        BlockPos% = 1
      END IF
    END IF
  CASE 1
    IF X% - 1 >= 0 THEN
      IF GameField%(X% - 1, Y%) = 0 AND GameField%(X% + 1, Y% + 1) = 0 THEN
        CALL RemoveBox(X% + 1, Y% - 1)
        CALL RemoveBox(X% + 1, Y%)
        CALL DrawBoxTurn(X% - 1, Y%, 0)
        CALL DrawBoxTurn(X% + 1, Y% + 1, 3)
        BlockCoords%(2, 0) = X%
        BlockCoords%(2, 1) = Y% + 1
        BlockPos% = 0
      END IF
    END IF
  END SELECT
CASE 4
  SELECT CASE BlockPos%
  CASE 0
    IF Y% - 2 >= 0 AND Y% + 1 <= 19 THEN
      IF GameField%(X%, Y% - 2) = 0 AND GameField%(X%, Y% - 1) = 0 AND GameField%(X%, Y% + 1) = 0 THEN
        CALL RemoveBox(X% - 1, Y%)
        CALL RemoveBox(X% + 1, Y%)
        CALL RemoveBox(X% + 2, Y%)
        CALL DrawBoxTurn(X%, Y% - 2, 3)
        CALL DrawBoxTurn(X%, Y% - 1, 2)
        CALL DrawBoxTurn(X%, Y% + 1, 0)
        BlockPos% = 1
      END IF
    END IF
  CASE 1
    IF X% - 1 >= 0 AND X% + 2 <= 9 THEN
      IF GameField%(X% - 1, Y%) = 0 AND GameField%(X% + 1, Y%) = 0 AND GameField%(X% + 2, Y%) = 0 THEN
        CALL RemoveBox(X%, Y% - 2)
        CALL RemoveBox(X%, Y% - 1)
        CALL RemoveBox(X%, Y% + 1)
        CALL DrawBoxTurn(X% - 1, Y%, 0)
        CALL DrawBoxTurn(X% + 1, Y%, 2)
        CALL DrawBoxTurn(X% + 2, Y%, 3)
        BlockPos% = 0
      END IF
    END IF
  END SELECT
CASE 5
                 'Block type 5, or a "box", looks the same if you rotate it
CASE 6
  SELECT CASE BlockPos%
  CASE 0
    IF Y% - 1 >= 0 THEN
      IF GameField%(X%, Y% - 1) = 0 THEN
        CALL RemoveBox(X% - 1, Y%)
        CALL DrawBoxTurn(X%, Y% - 1, 2)
        BlockCoords%(0, 0) = X%
        BlockCoords%(0, 1) = Y% + 1
        BlockCoords%(3, 0) = X% + 1
        BlockCoords%(3, 1) = Y%
        BlockPos% = 1
      END IF
    END IF
  CASE 1
    IF X% - 1 >= 0 THEN
      IF GameField%(X% - 1, Y%) = 0 THEN
        CALL RemoveBox(X%, Y% + 1)
        CALL DrawBoxTurn(X% - 1, Y%, 2)
        BlockCoords%(0, 0) = X% + 1
        BlockCoords%(0, 1) = Y%
        BlockCoords%(3, 0) = X%
        BlockCoords%(3, 1) = Y% - 1
        BlockPos% = 2
      END IF
    END IF
  CASE 2
    IF Y% + 1 <= 19 THEN
      IF GameField%(X%, Y% + 1) = 0 THEN
        CALL RemoveBox(X% + 1, Y%)
        CALL DrawBoxTurn(X%, Y% + 1, 2)
        BlockCoords%(0, 0) = X%
        BlockCoords%(0, 1) = Y% - 1
        BlockCoords%(3, 0) = X% - 1
        BlockCoords%(3, 1) = Y%
        BlockPos% = 3
      END IF
    END IF
  CASE 3
    IF X% + 1 <= 9 THEN
      IF GameField%(X% + 1, Y%) = 0 THEN
        CALL RemoveBox(X%, Y% - 1)
        CALL DrawBoxTurn(X% + 1, Y%, 2)
        BlockCoords%(0, 0) = X% - 1
        BlockCoords%(0, 1) = Y%
        BlockCoords%(3, 0) = X%
        BlockCoords%(3, 1) = Y% + 1
        BlockPos% = 0
      END IF
    END IF
  END SELECT
END SELECT

END SUB

