' BOUND.BAS by Jessac Mathias Baird
'
' Well, here is my source code for Bound. Terrible, slow, unoptomised,
' and unnecessarily huge. My code will never be like this again, but
' since I have little experience actually MAKING a program, I can
' get away with it. I did NOT comment on most of this, and I made
' the mistake of NOT thinking the program though before beginning!!
' so I added code as I went along and now the program sucks =(
' but at least I included the source... load QuickBASIC like this:
'
' QB.EXE /L GSLIB
'
' then you can execute this source...
'
' any bugs or suggestions, or just feedback,
'  email me at dos_programmer@yahoo.com
'
' cheers! -JMB

DEFINT A-Z
REM $DYNAMIC

'/ -------------------------
'/ global const definitions:
'/ -------------------------

CONST TRUE = -1               '/ obvious...
CONST FALSE = 0               '/ used for flow control

CONST kup% = 72               '/ for the up key, chr$(0) + chr$(kup%)
CONST kleft% = 75             '/ for the left key, chr$(0) + chr$(kleft%)
CONST kright% = 77            '/ for the right key, chr$(0) + chr$(kright%)
CONST kdown% = 80             '/ for the down key, chr$(0) + chr$(kdown%)
CONST kf1% = 59               '/ f1 key
CONST kf2% = 60               '/ f2 key
CONST kf3% = 61               '/ f3 key
CONST kf4% = 62               '/ f4 key
CONST kf5% = 63               '/ f5 key

CONST numtiles% = 5           '/ number of tiles, minus 1

'/ -------------------------
'/ global type definitions:
'/ -------------------------

TYPE pal13t       '/ type used for a palette array
 r AS INTEGER     '/ .. red, from 0 to 63
 g AS INTEGER     '/ .. blue, from 0 to 63
 b AS INTEGER     '/ .. green, from 0 to 63
END TYPE          '/ type = 6 bytes per element

TYPE font13t        '/ type used for the font set
 y AS STRING * 1    '/ .. binary data, 1 byte
END TYPE

TYPE mapt
 f AS INTEGER         '/ 1 = occupied; 2 = unoccupied
 n AS INTEGER         '/ tile number used on the map
 tn AS STRING * 2     '/ tile number, ie AA,AB,AC,etc
END TYPE

'/ ----------------------------------------
'/ subprocedure and function declarations:
'/ ----------------------------------------

REM $INCLUDE: 'BOUND.BI'

DECLARE SUB font13load (fontf$, fary() AS font13t)
DECLARE SUB font13drw (txt$, x%, y%, c%, fary() AS font13t, dseg%, dofs%)
DECLARE SUB font13drwz (txt$, x%, y%, c%, z%, fary() AS font13t, dseg%, dofs%)
DECLARE SUB font13drws (txt$, x%, y%, c%, z%, fary() AS font13t, dseg%, dofs%)

DECLARE SUB pal13load (palf$, pary() AS pal13t)
DECLARE SUB pal13put (c1%, c2%, pary() AS pal13t)
DECLARE SUB pal13fto (pary() AS pal13t)
DECLARE SUB pal13fd (rate%)

DECLARE SUB drwbox (x1%, y1%, x2%, y2%, fc%, bc%, dseg%, dofs%)

DECLARE SUB PuZinit ()
DECLARE SUB PuZfame ()
DECLARE SUB PuZplay ()
DECLARE SUB PuZgetm (dataf$)
DECLARE FUNCTION PuZnew% ()
DECLARE FUNCTION PuZload% ()
DECLARE SUB PuZputn (x%, y%, dseg%, dofs%)
DECLARE SUB PuZerror (txt$)

'/ ------------------------------
'/ global variable declarations:
'/ ------------------------------

DIM SHARED font13(32 TO 127, 0 TO 7) AS font13t
DIM SHARED italic(32 TO 127, 0 TO 7) AS font13t
DIM SHARED pal13(0 TO 255) AS pal13t

DIM SHARED tiles%(0 TO 201, 0 TO numtiles%)

DIM SHARED scrbuf%(0 TO 31999)
DIM SHARED bufseg%, bufofs%

DIM SHARED numoves%
DIM SHARED levelt$, levelf$
DIM SHARED endtile AS STRING * 2
DIM SHARED noendtile AS STRING * 2
DIM SHARED map(0 TO 15, 0 TO 8) AS mapt

DIM SHARED ingame%

'/ -------------------
'/ main program code:
'/ -------------------

DIM cnt%

SCREEN 13

bufseg% = VARSEG(scrbuf%(0))
bufofs% = VARPTR(scrbuf%(0))

CALL pal13load("GFX\DEF.PAL", pal13())
CALL font13load("GFX\DEF.FNT", font13())
CALL font13load("GFX\ITALIC.FNT", italic())

DEF SEG = VARSEG(tiles%(0, 0))
 BLOAD "GFX\TILES.GFX", VARPTR(tiles%(0, 0))
DEF SEG

ingame% = 0

main:

 CALL PuZinit

DO

  DO
   key$ = INKEY$
  LOOP UNTIL (key$ <> "")
  WHILE (INKEY$ <> ""): WEND

  SELECT CASE (key$)
   CASE ("1")
    IF (PuZnew%) THEN
     CALL PuZgetm(levelf$)
     CALL PuZplay
    END IF
    CALL PuZinit
   CASE ("2")
    IF (PuZload%) THEN
     CALL PuZplay
    END IF
    CALL PuZinit
   CASE ("3"), (CHR$(27))
    GOTO ends
   CASE ("4")
    IF (ingame%) THEN
     CALL PuZplay
     CALL PuZinit
    END IF
  END SELECT
LOOP

ends:

CLEAR
SCREEN 0: CLS
WIDTH 80, 25
SYSTEM

REM $STATIC
SUB drwbox (x1%, y1%, x2%, y2%, fc%, bc%, dseg%, dofs%)

FOR cnt% = 0 TO 3
 CALL gsbox(dseg%, dofs%, x1% + cnt%, y1% + cnt%, x2% - cnt%, y2% - cnt%, fc% + cnt%)
NEXT cnt%

CALL gsboxf(dseg%, dofs%, x1% + 4, y1% + 4, x2% - 4, y2% - 4, bc%)

END SUB

REM $DYNAMIC
DEFSNG A-Z
'----------------------------------------------------------------------------
' font13drw by J Mathias Baird -
'  desc: i have made some font routines and placed a few subs of them here.
'   this particular sub will draw txt$ to any pixel at (x%,y%) of colour c%,
'   and fary() is the font array (character set) dimmed as font13t
'
'  note: i have modified this from its original to allow for drawing to
'   offscreen buffers, the addresses passed as dseg% and dofs%
'----------------------------------------------------------------------------
SUB font13drw (txt$, x%, y%, c%, fary() AS font13t, dseg%, dofs%)

'/ local variables:
                                 
DIM char%, byte%
DIM xloc%, yloc%
DIM ch%, y1%

'/ local code:

xloc% = x%
IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) \ 2) * 8)

'/ ch% loops thru each characterin txt$:

FOR ch% = 1 TO LEN(txt$)
 char% = ASC(MID$(txt$, ch%, 1))      '/ get the character's ascii value

 '/ y1% loops through the 8 bytes containing this
 '/ character's binary data.. each bit set in the byte%
 '/ means that the pixel is to be drawn

 IF ((char% > 32) AND (char% < 127)) THEN
 
  yloc% = y%                             '/ start at the y% vertical pixel
  FOR y1% = 0 TO 7
   byte% = ASC(fary(char%, y1%).y)    '/ get this row's binary data

   '/ check each bit and draw the pixel if it is set..
   '/ this is actually faster than an x loop..

   IF (1 AND byte%) THEN gspset (xloc% + 7), yloc%, dseg%, dofs%, c%
   IF (2 AND byte%) THEN gspset (xloc% + 6), yloc%, dseg%, dofs%, c%
   IF (4 AND byte%) THEN gspset (xloc% + 5), yloc%, dseg%, dofs%, c%
   IF (8 AND byte%) THEN gspset (xloc% + 4), yloc%, dseg%, dofs%, c%
   IF (16 AND byte%) THEN gspset (xloc% + 3), yloc%, dseg%, dofs%, c%
   IF (32 AND byte%) THEN gspset (xloc% + 2), yloc%, dseg%, dofs%, c%
   IF (64 AND byte%) THEN gspset (xloc% + 1), yloc%, dseg%, dofs%, c%
   IF (128 AND byte%) THEN gspset xloc%, yloc%, dseg%, dofs%, c%

   yloc% = yloc% + 1             '/ go to the next row..
  NEXT y1%

 END IF

 xloc% = xloc% + 8      '/ move right 8 pixels on the screen
NEXT ch%

END SUB

REM $STATIC
DEFINT A-Z
SUB font13drws (txt$, x%, y%, c%, z%, fary() AS font13t, dseg%, dofs%)

DIM xloc%

xloc% = x%

IF (z% > 1) THEN
 IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) / 2) * 8 * z%)
 CALL font13drwz(txt$, xloc% - 1, y%, 0, z%, fary(), dseg%, dofs%)
 CALL font13drwz(txt$, xloc% + 1, y%, 0, z%, fary(), dseg%, dofs%)
 CALL font13drwz(txt$, xloc%, y% - 1, 0, z%, fary(), dseg%, dofs%)
 CALL font13drwz(txt$, xloc%, y% + 1, 0, z%, fary(), dseg%, dofs%)
 CALL font13drwz(txt$, xloc%, y%, c%, z%, fary(), dseg%, dofs%)
ELSE
 IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) / 2) * 8)
 CALL font13drw(txt$, xloc% - 1, y%, 0, fary(), dseg%, dofs%)
 CALL font13drw(txt$, xloc% + 1, y%, 0, fary(), dseg%, dofs%)
 CALL font13drw(txt$, xloc%, y% - 1, 0, fary(), dseg%, dofs%)
 CALL font13drw(txt$, xloc%, y% + 1, 0, fary(), dseg%, dofs%)
 CALL font13drw(txt$, xloc%, y%, c%, fary(), dseg%, dofs%)
END IF

END SUB

REM $DYNAMIC
DEFSNG A-Z
'----------------------------------------------------------------------------
' font13drwz by J Mathias Baird -
'  desc: will drw a zoomed string (txt$) at (x%,y%) to buffer dseg%:dofs%
'
'  note: i have modified this from its original to allow for drawing to
'   offscreen buffers, the addresses passed as dseg% and dofs%
'----------------------------------------------------------------------------
SUB font13drwz (txt$, x%, y%, c%, z%, fary() AS font13t, dseg%, dofs%)

'/ local variables:

DIM char%, byte%
DIM xloc%, yloc%
DIM ch%, y1%, zz%, pz%

zz% = z%
IF (zz% > 10) THEN zz% = 10
IF (zz% < 1) THEN zz% = 1
pz% = zz% - 1

'/ get x and center it:

xloc% = x%
IF (xloc% = 999) THEN xloc% = 160 - ((LEN(txt$) \ 2) * 8 * zz%)

'/ ch% loops thru each characterin txt$:

FOR ch% = 1 TO LEN(txt$)
 char% = ASC(MID$(txt$, ch%, 1))      '/ get the character's ascii value

 '/ y1% loops through the 8 bytes containing this
 '/ character's binary data.. each bit set in the byte%
 '/ means that the pixel is to be drawn


 IF ((char% > 32) AND (char% < 127)) THEN

 yloc% = y%                             '/ start at the y% vertical pixel
 FOR y1% = 0 TO 7
  byte% = ASC(fary(char%, y1%).y)    '/ get this row's binary data

  '/ check each bit and draw the pixel if it is set..
  '/ this is actually faster than an x loop..

   IF (1 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (7 * zz%), yloc%, xloc% + (7 * zz%) + pz%, yloc% + pz%, c%)
   IF (2 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (6 * zz%), yloc%, xloc% + (6 * zz%) + pz%, yloc% + pz%, c%)
   IF (4 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (5 * zz%), yloc%, xloc% + (5 * zz%) + pz%, yloc% + pz%, c%)
   IF (8 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (4 * zz%), yloc%, xloc% + (4 * zz%) + pz%, yloc% + pz%, c%)
   IF (16 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (3 * zz%), yloc%, xloc% + (3 * zz%) + pz%, yloc% + pz%, c%)
   IF (32 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (2 * zz%), yloc%, xloc% + (2 * zz%) + pz%, yloc% + pz%, c%)
   IF (64 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc% + (1 * zz%), yloc%, xloc% + (1 * zz%) + pz%, yloc% + pz%, c%)
   IF (128 AND byte%) THEN CALL gsboxf(dseg%, dofs%, xloc%, yloc%, xloc% + pz%, yloc% + pz%, c%)

  yloc% = yloc% + zz%         '/ go to the next row..
 NEXT y1%

 END IF

 xloc% = xloc% + (zz% * 8)  '/ move right 8 pixels on the screen
NEXT ch%

END SUB

'----------------------------------------------------------------------------
' font13load by J Mathias Baird -
'  desc: loads the character set stored on disk under fontf$ into the
'   font array passed as fary()
'----------------------------------------------------------------------------
SUB font13load (fontf$, fary() AS font13t)

DIM ff%
DIM ch%, y%
DIM ch1%, ch2%
DIM byte AS STRING * 1

ff% = FREEFILE

OPEN fontf$ FOR BINARY AS #ff%

IF (LOF(ff%) = 0) THEN
 CLS
 WIDTH 80, 25
  PRINT "ERROR: font file contains no data"
  PRINT "press any key to terminate..."
 WHILE (INKEY$ = ""): WEND
 CLOSE
 SYSTEM
END IF

GET #ff%, , byte
IF (ASC(byte) <> 255) THEN GOTO EndProc

GET #ff%, , byte
ch1% = ASC(byte)
GET #ff%, , byte
ch2% = ASC(byte)

IF (ch1% > ch2%) THEN GOTO EndProc

FOR ch% = ch1% TO ch2%
 FOR y% = 0 TO 7
  IF (EOF(ff%)) THEN GOTO EndProc
   GET #ff%, , byte
   fary(ch%, y%).y = byte
 NEXT y%
NEXT ch%

EndProc:
CLOSE #ff%

END SUB

REM $STATIC
DEFINT A-Z
'---------------------------------------------------------------------------
' pal13load -
'  desc: loads the palette file into pary and changes each colour's rgb
'---------------------------------------------------------------------------
SUB pal13load (palf$, pary() AS pal13t)

DIM c%
DIM ff%
DIM byte AS STRING * 1

ff% = FREEFILE
OPEN palf$ FOR BINARY AS #ff%
 FOR c% = 0 TO 255
  GET #ff%, , byte
  pary(c%).r% = ASC(byte)
  GET #ff%, , byte
  pary(c%).g% = ASC(byte)
  GET #ff%, , byte
  pary(c%).b% = ASC(byte)
 NEXT c%
CLOSE #ff%

END SUB

'---------------------------------------------------------------------------
' pal13put -
'  desc: just like 'palette using' but puts rgb values from c1% to c2%
'---------------------------------------------------------------------------
SUB pal13put (c1%, c2%, pary() AS pal13t)

DIM c%
DIM cc1%, cc2%

cc1% = c1%
cc2% = c2%

IF (cc1% > cc2%) THEN SWAP cc1%, cc2%
IF (cc1% < 0) THEN cc1% = 0
IF (cc2% > 255) THEN cc2% = 255

FOR c% = cc1% TO cc2%
 OUT &H3C8, c%
 OUT &H3C9, pary(c%).r%
 OUT &H3C9, pary(c%).g%
 OUT &H3C9, pary(c%).b%
NEXT c%

END SUB

SUB PuZerror (txt$)

SCREEN 0: CLS
WIDTH 80, 25

PRINT " An Unexpected Error Has Occurred:"
PRINT
PRINT txt$
PRINT
PRINT " Contact JMB at dos_programmer@yahoo.com"
PRINT " And Report This Error. Press Any Key To Terminate..."

WHILE (INKEY$ <> ""): WEND
WHILE (INKEY$ = ""): WEND

CLOSE
CLEAR
SYSTEM

END SUB

SUB PuZgetm (dataf$)

DIM x%
DIM y%
DIM ff%

ff% = FREEFILE
OPEN (dataf$) FOR BINARY AS #ff%
 IF (LOF(ff%) = 0) THEN
  CALL PuZerror("Map file, " + dataf$ + " is empty.")
 END IF
CLOSE #ff%

OPEN (dataf$) FOR INPUT AS #ff%

LINE INPUT #ff%, levelt$
INPUT #ff%, nummoves%
INPUT #ff%, endtile
INPUT #ff%, noendtile

IF (endtile = noendtile) THEN
 endtile = ""
 noendtile = ""
END IF

FOR y% = 0 TO 8
 FOR x% = 0 TO 15
  INPUT #ff%, map(x%, y%).n%
  map(x%, y%).tn = CHR$(65 + y%) + CHR$(65 + x%)
 NEXT x%
NEXT y%

INPUT #ff%, x%

FOR y% = 0 TO 8
 FOR x% = 0 TO 15
  INPUT #ff%, map(x%, y%).f%
 NEXT x%
NEXT y%

END SUB

SUB PuZinit

DIM cnt%
DIM x%, y%
DIM tileseg%
DIM tileofs%

tileseg% = VARSEG(tiles%(0, 3))
tileofs% = VARPTR(tiles%(0, 3))

FOR y% = 0 TO 9
 FOR x% = 0 TO 15
  CALL gssolidput((x% * 20), (y% * 20), bufseg%, bufofs%, tileseg%, tileofs%)
 NEXT x%
NEXT y%

CALL font13drws("Bound", 999, 18, 15, 4, italic(), bufseg%, bufofs%)
CALL font13drws("By Jessac Mathias Baird", 999, 52, 15, 0, italic(), bufseg%, bufofs%)
CALL font13drws("(c) FlyingSoft 2000", 999, 62, 15, 0, italic(), bufseg%, bufofs%)

CALL drwbox(10, 80, 309, 190, 116, 116, bufseg%, bufofs%)
CALL font13drws("Make Your Selection:  ", 999, 90, 15, 0, italic(), bufseg%, bufofs%)
CALL font13drws("(1) Start New Game ", 999, 108, 15, 0, italic(), bufseg%, bufofs%)
CALL font13drws("(2) Load Saved Game", 999, 118, 15, 0, italic(), bufseg%, bufofs%)
CALL font13drws("(3) Exit to DOS    ", 999, 128, 15, 0, italic(), bufseg%, bufofs%)
CALL font13drws("View README.TXT For Instructions", 999, 178, 15, 0, italic(), bufseg%, bufofs%)

IF (ingame%) THEN
 CALL font13drws("(4) Return to Game ", 999, 138, 15, 0, italic(), bufseg%, bufofs%)
END IF

CALL pal13put(0, 255, pal13())
CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

END SUB

FUNCTION PuZload%

DIM ff%

PuZload% = 0
ff% = FREEFILE
OPEN "DATA\SAVEGAME.DAT" FOR BINARY AS #ff%
 IF (LOF(ff%) = 0) THEN
  CALL drwbox(2, 2, 300, 60, 116, 116, bufseg%, bufofs%)
  CALL font13drws("Game Has Not Yet Been Saved", 10, 10, 15, 0, font13(), bufseg%, bufofs%)
  CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
  WHILE (INKEY$ <> ""): WEND
  SLEEP 2
  CLOSE #ff%
  EXIT FUNCTION
 END IF

CLOSE #ff%

levelf$ = "DATA\SAVEGAME.DAT"
CALL PuZgetm(levelf$)
PuZload% = -1

END FUNCTION

FUNCTION PuZnew%

DIM ff%
DIM cnt%
DIM num%
DIM miny%
DIM maxx%
DIM yloc%
DIM tmp$

PuZnew% = 0

FOR cnt% = 0 TO 199
 FOR num% = (0 + (cnt% AND 1)) TO 319 STEP 2
  CALL gspset(num%, cnt%, bufseg%, bufofs%, 0)
 NEXT num%
NEXT cnt%

ff% = FREEFILE
OPEN "DATA\LEVELS.DAT" FOR BINARY AS #ff%
 IF (LOF(ff%) = 0) THEN
  CALL PuZerror("LEVELS.DAT NOT FOUND. PLEASE REINSTALL.")
 END IF
CLOSE #ff%

OPEN "DATA\LEVELS.DAT" FOR INPUT AS #ff%

cnt% = 0
num% = 0

LOCATE 1, 1

WHILE (NOT EOF(ff%))
 num% = num% + 1
 INPUT #ff%, tmp$
 INPUT #ff%, tmp$
WEND

REDIM lvldat$(1 TO num%, 0 TO 1)

SEEK #ff%, 1
FOR cnt% = 1 TO num%
 INPUT #ff%, lvldat$(cnt%, 0)
 INPUT #ff%, lvldat$(cnt%, 1)
NEXT cnt%

CALL drwbox(40, 3, 279, 198, 116, 116, bufseg%, bufofs%)
CALL font13drws("Esc to Cancel", 999, 11, 15, 0, font13(), bufseg%, bufofs%)
CALL font13drws("Csr Keys to Select", 999, 22, 15, 0, font13(), bufseg%, bufofs%)
CALL font13drws("Enter to Accept", 999, 33, 15, 0, font13(), bufseg%, bufofs%)
                
cnt% = 1
miny% = 66
maxy% = 165

starts:

yloc% = miny%

CALL gsboxf(bufseg%, bufofs%, 44, 43, 275, 194, 116)

 FOR ff% = 0 TO 8
  IF ((cnt% + ff%) <= num%) THEN
   CALL font13drws(lvldat$(cnt% + ff%, 0), 999, miny% + (ff% * 11), 15, 0, font13(), bufseg%, bufofs%)
  ELSE
   EXIT FOR
  END IF
 NEXT ff%

 ff% = ff% - 1
 tmp$ = "Puzzles" + STR$(cnt%) + " -" + STR$(cnt% + ff%)
 CALL font13drws(tmp$, 999, 44, 15, 0, font13(), bufseg%, bufofs%)

 IF ((cnt% + 9) < num%) THEN
  CALL font13drws("- More -", 999, 187, 15, 0, font13(), bufseg%, bufofs%)
 END IF

CALL font13drws(lvldat$(cnt%, 0), 999, miny%, 92, 0, font13(), bufseg%, bufofs%)
CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

DO
 DO
  key$ = INKEY$
 LOOP UNTIL (key$ <> "")
 WHILE (INKEY$ <> ""): WEND

 SELECT CASE (key$)
  CASE CHR$(27)
   GOTO exits
  CASE (CHR$(0) + CHR$(kdown%))
   IF (yloc% < maxy%) THEN
    IF (cnt% < num%) THEN
     CALL font13drws(lvldat$(cnt%, 0), 999, yloc%, 15, 0, font13(), &HA000, 0)
      cnt% = cnt% + 1
      yloc% = yloc% + 11
     CALL font13drws(lvldat$(cnt%, 0), 999, yloc%, 92, 0, font13(), &HA000, 0)
    END IF
   ELSE
    IF (cnt% < num%) THEN
     cnt% = cnt% + 1
     GOTO starts
    END IF
   END IF
  CASE (CHR$(0) + CHR$(kup%))
   IF (yloc% > miny%) THEN
    IF (cnt% MOD 10 <> 1) THEN
     CALL font13drws(lvldat$(cnt%, 0), 999, yloc%, 15, 0, font13(), &HA000, 0)
      cnt% = cnt% - 1
      yloc% = yloc% - 11
     CALL font13drws(lvldat$(cnt%, 0), 999, yloc%, 92, 0, font13(), &HA000, 0)
    END IF
   ELSE
    IF (cnt% > 1) THEN
     cnt% = cnt% - 10
     GOTO starts
    END IF
   END IF
 CASE CHR$(13)
  levelf$ = lvldat$(cnt%, 1)
  PuZnew% = -1
  GOTO exits
 END SELECT

LOOP

SLEEP

exits:

ERASE lvldat$

END FUNCTION

SUB PuZplay


DIM sel%
DIM x%, y%

DIM mapel%
DIM mapx%, mapy%
DIM DIR AS STRING * 1
DIM record%

DIM num%
DIM cntseg%, cntofs%
DIM tileseg%, tileofs%
DIM tmp$

REDIM tmpbuf%(0 TO 201)

sel% = 0
mapx% = 0
mapy% = 0
ingame% = -1
cntseg% = VARSEG(tiles%(0, 5))
cntofs% = VARPTR(tiles%(0, 5))

CLOSE

GOSUB drawmap
GOSUB showdata
GOSUB puzinfo

DO
 DO
  tmp$ = INKEY$
 LOOP UNTIL (tmp$ <> "")
 WHILE (INKEY$ <> ""): WEND
 
 SELECT CASE (tmp$)
  CASE CHR$(27): GOTO procends
  CASE (CHR$(0) + CHR$(kf1%)), "t", "T"
   GOSUB showmap
  CASE (CHR$(0) + CHR$(kf2%)), "i", "I"
   GOSUB puzinfo
  CASE CHR$(0) + CHR$(kf3%), "s", "S"
   GOSUB savegame
  CASE CHR$(0) + CHR$(kf4%), "r", "R"
   GOSUB restart
  CASE CHR$(0) + CHR$(kf5%)
   CLOSE
   CALL drwbox(2, 2, 317, 80, 116, 116, bufseg%, bufofs%)
   record% = NOT record%
   IF (record%) THEN
    OPEN "DATA\RECORD.DAT" FOR OUTPUT AS #1
    CALL font13drws("Now Recording Movement", 10, 10, 15, 1, font13(), bufseg%, bufofs%)
   ELSE
    CALL font13drws("Not Recording Movement", 10, 10, 15, 1, font13(), bufseg%, bufofs%)
   END IF
   CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
   SLEEP 2
   GOSUB drawmap
   GOSUB showdata
   DIR = ""
   GOSUB movebox
   CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
  CASE CHR$(0) + CHR$(kright%)
   IF (mapx% < 15) THEN
    DIR = "R": GOSUB movebox
   END IF
  CASE CHR$(0) + CHR$(kleft%)
   IF (mapx% > 0) THEN
    DIR = "L": GOSUB movebox
   END IF
  CASE CHR$(0) + CHR$(kdown%)
   IF (mapy% < 8) THEN
    DIR = "D": GOSUB movebox
   END IF
  CASE CHR$(0) + CHR$(kup%)
   IF (mapy% > 0) THEN
    DIR = "U": GOSUB movebox
   END IF
  CASE CHR$(32)
   IF (sel%) THEN
    SELECT CASE (map(mapx%, mapy%).f)
    CASE 4
     sel% = 0
     map(mapx%, mapy%).f = 1
     FOR y% = 0 TO 8
      FOR x% = 0 TO 15
       IF (map(x%, y%).f > 2) THEN map(x%, y%).f = 2
      NEXT x%
     NEXT y%
     CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
      x% = mapx% * 20
      y% = mapy% * 20
      GET (x%, y%)-(x% + 19, y% + 19), tmpbuf%
     CALL gsbox(&HA000, 0, x%, y%, x% + 19, y% + 19, 15)
    CASE 3
     sel% = 0

     FOR y% = 0 TO 8
      FOR x% = 0 TO 15
       IF (map(x%, y%).f = 3) THEN map(x%, y%).f = 2
       IF (map(x%, y%).f = 4) THEN
        map(x%, y%).f = 2
        IF (mapx% < x%) THEN
         IF (mapy% < y%) THEN map(mapx% + 1, mapy% + 1).f = 2
         IF (mapy% = y%) THEN map(mapx% + 1, mapy%).f = 2
         IF (mapy% > y%) THEN map(mapx% + 1, mapy% - 1).f = 2
        ELSEIF (mapx% = x%) THEN
         IF (mapy% < y%) THEN map(mapx%, mapy% + 1).f = 2
         IF (mapy% > y%) THEN map(mapx%, mapy% - 1).f = 2
        ELSEIF (mapx% > x%) THEN
         IF (mapy% < y%) THEN map(mapx% - 1, mapy% + 1).f = 2
         IF (mapy% = y%) THEN map(mapx% - 1, mapy%).f = 2
         IF (mapy% > y%) THEN map(mapx% - 1, mapy% - 1).f = 2
        END IF
        IF (record%) THEN
         PRINT #1, map(x%, y%).tn + "-" + map(mapx%, mapy%).tn + "; "
        END IF

       END IF
      NEXT x%
     NEXT y%
     map(mapx%, mapy%).f = 1
     IF (nummoves% > 0) THEN
      IF (nummoves% = 1) THEN GOSUB endpuz
      nummoves% = nummoves% - 1
     END IF
    
     GOSUB drawmap
     GOSUB showdata

     CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
     IF (num% = 1) THEN GOSUB endpuz
     x% = mapx% * 20
     y% = mapy% * 20
     GET (x%, y%)-(x% + 19, y% + 19), tmpbuf%
     CALL gsbox(&HA000, 0, x%, y%, x% + 19, y% + 19, 15)

    END SELECT
   ELSE
    IF (map(mapx%, mapy%).f = 1) THEN
    
     IF (mapx% > 1) THEN
      IF (mapy% > 1) THEN
       IF (map(mapx% - 2, mapy% - 2).f = 2) THEN
        IF (map(mapx% - 1, mapy% - 1).f = 1) THEN map(mapx% - 2, mapy% - 2).f = 3
       END IF
      END IF
      IF (map(mapx% - 2, mapy%).f = 2) THEN
       IF (map(mapx% - 1, mapy%).f = 1) THEN map(mapx% - 2, mapy%).f = 3
      END IF
      IF (mapy% < 7) THEN
       IF (map(mapx% - 2, mapy% + 2).f = 2) THEN
        IF (map(mapx% - 1, mapy% + 1).f = 1) THEN map(mapx% - 2, mapy% + 2).f = 3
       END IF
      END IF
     END IF

     IF (mapy% > 1) THEN
      IF (map(mapx%, mapy% - 2).f = 2) THEN
       IF (map(mapx%, mapy% - 1).f = 1) THEN map(mapx%, mapy% - 2).f = 3
      END IF
     END IF
     IF (mapy% < 7) THEN
      IF (map(mapx%, mapy% + 2).f = 2) THEN
       IF (map(mapx%, mapy% + 1).f = 1) THEN map(mapx%, mapy% + 2).f = 3
      END IF
     END IF

     IF (mapx% < 14) THEN
      IF (mapy% > 1) THEN
       IF (map(mapx% + 2, mapy% - 2).f = 2) THEN
        IF (map(mapx% + 1, mapy% - 1).f = 1) THEN map(mapx% + 2, mapy% - 2).f = 3
       END IF
      END IF
      IF (map(mapx% + 2, mapy%).f = 2) THEN
       IF (map(mapx% + 1, mapy%).f = 1) THEN map(mapx% + 2, mapy%).f = 3
      END IF
      IF (mapy% < 7) THEN
       IF (map(mapx% + 2, mapy% + 2).f = 2) THEN
        IF (map(mapx% + 1, mapy% + 1).f = 1) THEN map(mapx% + 2, mapy% + 2).f = 3
       END IF
      END IF
     END IF

     FOR y% = 0 TO 8
      FOR x% = 0 TO 15
       IF (map(x%, y%).f = 3) THEN
        sel% = -1
        CALL gsbox(&HA000, 0, (x% * 20 + 1), (y% * 20 + 1), (x% * 20 + 18), (y% * 20 + 18), 15)
       END IF
      NEXT x%
     NEXT y%

     IF (sel%) THEN map(mapx%, mapy%).f = 4

    END IF

   END IF
 END SELECT
LOOP

GOTO procends

drawmap:
 num% = 0
 CALL gsboxf(bufseg%, bufofs%, 0, 0, 319, 199, 80)
 FOR y% = 0 TO 8
  FOR x% = 0 TO 15
  
   mapel% = map(x%, y%).n%
    tileseg% = VARSEG(tiles%(0, mapel%))
    tileofs% = VARPTR(tiles%(0, mapel%))
   CALL gssolidput(x% * 20, y% * 20, bufseg%, bufofs%, tileseg%, tileofs%)

   sel% = 0
   SELECT CASE map(x%, y%).f%
    CASE 2
     CALL PuZputn(x%, y%, bufseg%, bufofs%)
    CASE 1, 3, 4
     num% = num% + 1
     map(x%, y%).f% = 1
     CALL gssprite(x% * 20, y% * 20, bufseg%, bufofs%, cntseg%, cntofs%)
   END SELECT

  NEXT x%
 NEXT y%
RETURN

puzinfo:
 CALL drwbox(2, 2, 317, 110, 116, 116, bufseg%, bufofs%)
 CALL font13drws("To Solve This Puzzle:", 10, 10, 15, 0, font13(), bufseg%, bufofs%)

 SELECT CASE (ASC(endtile))
  CASE 48, 32, 0: CALL font13drws("Leave One Counter Remaining", 10, 30, 15, 0, font13(), bufseg%, bufofs%)
  CASE ELSE: CALL font13drws("Leave Final Counter On " + endtile, 10, 30, 15, 0, font13(), bufseg%, bufofs%)
 END SELECT

 IF (ASC(noendtile) > 64) THEN
  CALL font13drws("Leave " + noendtile + " blank", 10, 40, 15, 0, font13(), bufseg%, bufofs%)
 END IF

 CALL font13drws("Press Any Key To Continue", 10, 60, 15, 0, font13(), bufseg%, bufofs%)

 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
 WHILE (INKEY$ <> ""): WEND
 WHILE (INKEY$ = ""): WEND

 GOSUB drawmap
 GOSUB showdata
 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

 x% = mapx% * 20
 y% = mapy% * 20
 GET (x%, y%)-(x% + 19, y% + 19), tmpbuf%
 CALL gsbox(&HA000, 0, x%, y%, x% + 19, y% + 19, 15)

RETURN

showmap:
 mapel% = 2
 FOR y% = 0 TO 8
  FOR x% = 0 TO 15
   tileseg% = VARSEG(tiles%(0, mapel%))
   tileofs% = VARPTR(tiles%(0, mapel%))

   CALL gssolidput(x% * 20, y% * 20, bufseg%, bufofs%, tileseg%, tileofs%)
   CALL PuZputn(x%, y%, bufseg%, bufofs%)
  
   mapel% = (mapel% + 1) MOD 4
   IF (mapel% = 0) THEN mapel% = 2
  NEXT x%
  mapel% = (mapel% + 1) MOD 4
  IF (mapel% = 0) THEN mapel% = 2

 NEXT y%

 CALL drwbox(0, 180, 319, 199, 116, 116, bufseg%, bufofs%)
 CALL font13drws("Press Any Key To Continue", 5, 186, 15, 0, font13(), bufseg%, bufofs%)

 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

 WHILE (INKEY$ <> ""): WEND
 WHILE (INKEY$ = ""): WEND

 GOSUB drawmap
 GOSUB showdata
 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
 x% = mapx% * 20
 y% = mapy% * 20
 GET (x%, y%)-(x% + 19, y% + 19), tmpbuf%
 CALL gsbox(&HA000, 0, x%, y%, x% + 19, y% + 19, 15)

RETURN


showdata:
 CALL drwbox(0, 180, 319, 199, 116, 116, bufseg%, bufofs%)
 tmp$ = levelt$
 IF (nummoves% <> 0) THEN tmp$ = tmp$ + ", Moves Left:" + STR$(nummoves%)
 CALL font13drws(tmp$, 5, 186, 15, 0, font13(), bufseg%, bufofs%)
RETURN

movebox:
 x% = mapx% * 20
 y% = mapy% * 20
 tileseg% = VARSEG(tmpbuf%(0))
 tileofs% = VARPTR(tmpbuf%(0))
 CALL gssolidput(x%, y%, &HA000, 0, tileseg%, tileofs%)

 SELECT CASE DIR
  CASE "R"
   x% = x% + 20
   mapx% = mapx% + 1
  CASE "L"
   x% = x% - 20
   mapx% = mapx% - 1
  CASE "U"
   y% = y% - 20
   mapy% = mapy% - 1
  CASE "D"
   y% = y% + 20
   mapy% = mapy% + 1
 END SELECT

 GET (x%, y%)-(x% + 19, y% + 19), tmpbuf%
 CALL gsbox(&HA000, 0, x%, y%, x% + 19, y% + 19, 15)

RETURN

savegame:

 CALL drwbox(2, 2, 200, 80, 116, 116, bufseg%, bufofs%)
 CALL font13drws("Save Game? (y/n)", 10, 10, 15, 0, font13(), bufseg%, bufofs%)
 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

 DO
  DO
   tmp$ = INKEY$
  LOOP UNTIL LEN(tmp$)
  IF (LCASE$(tmp$) = "y") THEN
   mapel% = FREEFILE
   OPEN "DATA\SAVEGAME.DAT" FOR OUTPUT AS #mapel%
    PRINT #mapel%, levelt$
    PRINT #mapel%, nummoves%; ",";
    PRINT #mapel%, endtile + ",";
    PRINT #mapel%, noendtile
    FOR y% = 0 TO 8
     FOR x% = 0 TO 15
       PRINT #mapel%, LTRIM$(STR$(map(x%, y%).n));
       IF (x% < 15) THEN PRINT #mapel%, ",";
     NEXT x%
     PRINT #mapel%,
    NEXT y%

    PRINT #mapel%,

    FOR y% = 0 TO 8
     FOR x% = 0 TO 15
       PRINT #mapel%, LTRIM$(STR$(map(x%, y%).f));
       IF (x% < 15) THEN PRINT #mapel%, ",";
     NEXT x%
     PRINT #mapel%,
    NEXT y%

  CALL drwbox(2, 2, 200, 80, 116, 116, bufseg%, bufofs%)
  CALL font13drws("Game Saved", 10, 10, 15, 0, font13(), bufseg%, bufofs%)
  CALL gspcopy(bufseg%, bufofs%, &HA000, 0)
   CLOSE #mapel%
   SLEEP 2
   tmp$ = "n"
  END IF
 LOOP UNTIL (LCASE$(tmp$) = "n")

 GOSUB drawmap
 GOSUB showdata
 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

 x% = mapx% * 20
 y% = mapy% * 20
 GET (x%, y%)-(x% + 19, y% + 19), tmpbuf%
 CALL gsbox(&HA000, 0, x%, y%, x% + 19, y% + 19, 15)

RETURN

restart:

 CALL drwbox(2, 2, 200, 80, 116, 116, bufseg%, bufofs%)
 CALL font13drws("Restart Game? (y/n)", 10, 10, 15, 0, font13(), bufseg%, bufofs%)
 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

 DO
  DO
   tmp$ = INKEY$
  LOOP UNTIL LEN(tmp$)
  IF (LCASE$(tmp$) = "y") THEN
   CLOSE : record% = 0
   CALL PuZgetm(levelf$)
   tmp$ = "n"
  END IF
 LOOP UNTIL (LCASE$(tmp$) = "n")

 GOSUB drawmap
 GOSUB showdata
 CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

 x% = mapx% * 20
 y% = mapy% * 20
 GET (x%, y%)-(x% + 19, y% + 19), tmpbuf%
 CALL gsbox(&HA000, 0, x%, y%, x% + 19, y% + 19, 15)

RETURN

endpuz:

ingame% = 0
mapel% = -1

CALL drwbox(2, 2, 317, 110, 116, 116, bufseg%, bufofs%)
y% = 30
IF (num% = 1) THEN
 IF (ASC(endtile) > 64) THEN
  IF (map(mapx%, mapy%).tn <> endtile) THEN
   mapel% = 0
   CALL font13drws("Last Counter Not On " + endtile, 12, y%, 15, 0, font13(), bufseg%, bufofs%)
   y% = y% + 10
  END IF
 END IF
 IF (ASC(noendtile) > 64) THEN
  IF (map(mapx%, mapy%).tn = noendtile) THEN
   mapel% = 0
   CALL font13drws(noendtile + " not blank", 12, y%, 15, 0, font13(), bufseg%, bufofs%)
   y% = y% + 10
  END IF
 END IF
ELSE
 mapel% = 0
 CALL font13drws("You Ran Out of Moves", 12, 30, 15, 0, font13(), bufseg%, bufofs%)
END IF

tmp$ = "Puzzle Solved! Good Job!!"
IF (mapel% = 0) THEN tmp$ = "Game Over, Puzzle Unsolved:"
CALL font13drws(tmp$, 10, 10, 15, 0, font13(), bufseg%, bufofs%)
CALL font13drws("Press Any Key To Continue", 10, 50, 15, 0, font13(), bufseg%, bufofs%)

CALL gspcopy(bufseg%, bufofs%, &HA000, 0)

WHILE (INKEY$ <> ""): WEND
WHILE (INKEY$ = ""): WEND

procends:

CLOSE
ERASE tmpbuf%

END SUB

SUB PuZputn (x%, y%, dseg%, dofs%)

DIM xl%, yl%

xl% = (x% * 20) + 2
yl% = (y% * 20) + 6

CALL font13drws(map(x%, y%).tn, xl%, yl%, 15, 0, font13(), dseg%, dofs%)

END SUB

