; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted


;-| Super Motions |--------------------------------------------------------
[Command]
name = QCF_2p
command = ~D, DF, F, x+y

[Command]
name = QCF_2p
command = ~D, DF, F, x+z

[Command]
name = QCF_2p
command = ~D, DF, F, y+z

[Command]
name = QCB_2k
command = ~D, DB, B, a+b

[Command]
name = QCB_2k
command = ~D, DB, B, a+c

[Command]
name = QCB_2k
command = ~D, DB, B, b+c

[Command]
name = BF_2k
command = ~20$B, F, a+b
time = 10

[Command]
name = BF_2k
command = ~20$B, F, b+c
time = 10

[Command]
name = BF_2k
command = ~20$B, F, a+c
time = 10

;-| Special Motions |------------------------------------------------------
[Command]
name = QCF_x
command = ~D, DF, F, x

[Command]
name = QCF_y
command = ~D, DF, F, y

[Command]
name = QCF_z
command = ~D, DF, F, z

[Command]
name = QCB_a
command = ~D, DB, B, a

[Command]
name = QCB_b
command = ~D, DB, B, b

[Command]
name = QCB_c
command = ~D, DB, B, c

[Command]
name = BF_a
command = ~20$B, F, a
time = 10

[Command]
name = BF_b
command = ~20$B, F, b
time = 10

[Command]
name = BF_c
command = ~20$B, F, c
time = 10

;-| Double Tap |-----------------------------------------------------------
[Command]
name = FF       ;Required (do not remove)
command = F, F
time = 10

[Command]
name = BB       ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = recovery
command = a+b
time = 1

[Command]
name = recovery
command = b+c
time = 1

[Command]
name = recovery
command = a+c
time = 1

[Command]
name = recovery
command = x+y
time = 1

[Command]
name = recovery
command = y+z
time = 1

[Command]
name = recovery
command = x+z
time = 1

[Command]
name = ab
command = a+b
time = 1

[Command]
name = bc
command = b+c
time = 1

[Command]
name = ac
command = a+c
time = 1

[Command]
name = xy
command = c+y
time = 1

[Command]
name = yz
command = y+z
time = 1

[Command]
name = xz
command = x+z
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = fwd_a
command = /F,a
time = 1

[Command]
name = fwd_b
command = /F,b
time = 1

[Command]
name = fwd_c
command = /F,c
time = 1

[Command]
name = downfwd_a
command = /DF,a
time = 1

[Command]
name = downfwd_b
command = /DF,b
time = 1

[Command]
name = back_a
command = /B,a
time = 1

[Command]
name = back_b
command = /B,b
time = 1

[Command]
name = back_c
command = /B,c
time = 1

[Command]
name = down_a
command = /$D,a
time = 1

[Command]
name = down_b
command = /$D,b
time = 1

[Command]
name = down_c
command = /$D,c
time = 1

[Command]
name = fwd_ab
command = /F, a+b
time = 1

[Command]
name = back_ab
command = /B, a+b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = a
command = a
time = 1

[Command]
name = b
command = b
time = 1

[Command]
name = c
command = c
time = 1

[Command]
name = x
command = x
time = 1

[Command]
name = y
command = y
time = 1

[Command]
name = z
command = z
time = 1

[Command]
name = s
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = holdfwd  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = holdback ;Required (do not remove)
command = /$B
time = 1

[Command]
name = holdup   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = holddown ;Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
; Total Slam
[State -1]
type = ChangeState
value = 3000
triggerall = command = QCF_2p
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA
trigger2 = movecontact = 1

;===========================================================================
;---------------------------------------------------------------------------
;Super Spinball
[State -1]
type = ChangeState
value = 3100
triggerall = command = BF_2k
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA
trigger2 = movecontact = 1

;===========================================================================
;---------------------------------------------------------------------------
;Super Cannonball
[State -1]
type = ChangeState
value = 3200
triggerall = power >= 1000
triggerall = command = BF_2k
trigger1 = statetype = A
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;SlamPunch-x
[State -1]
type = ChangeState
value = 1000
triggerall = command = QCF_x
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;stand B
trigger5 = movecontact = 1
trigger6 = stateno = 220   ;stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 250   ;stand C
trigger7 = movecontact = 1
trigger8 = stateno = 255   ;stand fwC
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;SlamPunch-y
[State -1]
type = ChangeState
value = 1010
triggerall = command = QCF_y
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;stand B
trigger5 = movecontact = 1
trigger6 = stateno = 220   ;stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 250   ;stand C
trigger7 = movecontact = 1
trigger8 = stateno = 255   ;stand fwC
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;SlamPunch-z
[State -1]
type = ChangeState
value = 1020
triggerall = command = QCF_z
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;stand B
trigger5 = movecontact = 1
trigger6 = stateno = 220   ;stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 250   ;stand C
trigger7 = movecontact = 1
trigger8 = stateno = 255   ;stand fwC
trigger8 = movecontact = 1

;===========================================================================
;---------------------------------------------------------------------------
;Cannonball_a
[State -1]
type = ChangeState
value = 1200
triggerall = command = BF_a
trigger1 = statetype = A
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;Cannonball_b
[State -1]
type = ChangeState
value = 1210
triggerall = command = BF_b
trigger1 = statetype = A
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;Cannonball_c
[State -1]
type = ChangeState
value = 1220
triggerall = command = BF_c
trigger1 = statetype = A
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;Spinball_a
[State -1]
type = ChangeState
value = 1100
triggerall = command = BF_a
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;stand B
trigger5 = movecontact = 1
trigger6 = stateno = 220   ;stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 250   ;stand C
trigger7 = movecontact = 1
trigger8 = stateno = 255   ;stand fwC
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;Spinball_b
[State -1]
type = ChangeState
value = 1110
triggerall = command = BF_b
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;stand B
trigger5 = movecontact = 1
trigger6 = stateno = 220   ;stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 250   ;stand C
trigger7 = movecontact = 1
trigger8 = stateno = 255   ;stand fwC
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;Spinball_c
[State -1]
type = ChangeState
value = 1120
triggerall = command = BF_c
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;stand B
trigger5 = movecontact = 1
trigger6 = stateno = 220   ;stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 250   ;stand C
trigger7 = movecontact = 1
trigger8 = stateno = 255   ;stand fwC
trigger8 = movecontact = 1

;===========================================================================
;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
trigger1 = command = BB
trigger1 = statetype = S
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;Taunt
[State -1]
type = ChangeState
value = 195
triggerall = command = s
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1

;===========================================================================
;---------------------------------------------------------------------------
;Stand_X
[State -1]
type = ChangeState
value = 200
triggerall = command = x
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Stand_Y
[State -1]
type = ChangeState
value = 210
triggerall = command = y
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;stand A
trigger3 = movecontact = 1
trigger4 = stateno = 400   ;Crouch X
trigger4 = movecontact = 1
trigger5 = stateno = 430   ;Crouch A
trigger5 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_Z
[State -1]
type = ChangeState
value = 220
triggerall = command = z
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;Stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;Stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;Stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;Stand B
trigger5 = movecontact = 1
trigger6 = stateno = 400   ;Crouch X
trigger6 = movecontact = 1
trigger7 = stateno = 430   ;Crouch A
trigger7 = movecontact = 1
trigger8 = stateno = 410   ;Crouch Y
trigger8 = movecontact = 1
trigger9 = stateno = 440   ;Crouch B
trigger9 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_A
[State -1]
type = ChangeState
value = 230
triggerall = command = a
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;stand X
trigger2 = movecontact = 1
trigger3 = stateno = 400   ;Crouch X
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_B
[State -1]
type = ChangeState
value = 240
triggerall = command = b
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;Stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;Stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;Stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 400   ;Crouch X
trigger5 = movecontact = 1
trigger6 = stateno = 430   ;Crouch A
trigger6 = movecontact = 1
trigger7 = stateno = 410   ;Crouch Y
trigger7 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_fwC
[State -1]
type = ChangeState
value = 255
triggerall = command = fwd_c
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;Stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;Stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;Stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;Stand B
trigger5 = movecontact = 1
trigger6 = stateno = 215   ;Stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 400   ;Crouch X
trigger7 = movecontact = 1
trigger8 = stateno = 430   ;Crouch A
trigger8 = movecontact = 1
trigger9 = stateno = 410   ;Crouch Y
trigger9 = movecontact = 1
trigger10 = stateno = 440   ;Crouch B
trigger10 = movecontact = 1
trigger11 = stateno = 420   ;Crouch Z
trigger11 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_C
[State -1]
type = ChangeState
value = 250
triggerall = command = c
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;Stand X
trigger2 = movecontact = 1
trigger3 = stateno = 230   ;Stand A
trigger3 = movecontact = 1
trigger4 = stateno = 210   ;Stand Y
trigger4 = movecontact = 1
trigger5 = stateno = 240   ;Stand B
trigger5 = movecontact = 1
trigger6 = stateno = 215   ;Stand Z
trigger6 = movecontact = 1
trigger7 = stateno = 400   ;Crouch X
trigger7 = movecontact = 1
trigger8 = stateno = 430   ;Crouch A
trigger8 = movecontact = 1
trigger9 = stateno = 410   ;Crouch Y
trigger9 = movecontact = 1
trigger10 = stateno = 440   ;Crouch B
trigger10 = movecontact = 1
trigger11 = stateno = 420   ;Crouch Z
trigger11 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_X
[State -1]
type = ChangeState
value = 400
triggerall = command = x
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 200   ;Stand X
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_Y
[State -1]
type = ChangeState
value = 410
triggerall = command = y
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400   ;Crouch X
trigger2 = movecontact = 1
trigger3 = stateno = 430   ;Crouch A
trigger3 = movecontact = 1
trigger4 = stateno = 200   ;Stand X
trigger4 = movecontact = 1
trigger5 = stateno = 230   ;Stand A
trigger5 = movecontact = 1
trigger6 = stateno = 210   ;Stand Y
trigger6 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_Z
[State -1]
type = ChangeState
value = 420
triggerall = command = z
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400   ;Crouch X
trigger2 = movecontact = 1
trigger3 = stateno = 430   ;Crouch A
trigger3 = movecontact = 1
trigger4 = stateno = 410   ;Crouch Y
trigger4 = movecontact = 1
trigger5 = stateno = 440   ;Crouch B
trigger5 = movecontact = 1
trigger6 = stateno = 200   ;Stand X
trigger6 = movecontact = 1
trigger7 = stateno = 230   ;Stand A
trigger7 = movecontact = 1
trigger8 = stateno = 210   ;Stand Y
trigger8 = movecontact = 1
trigger9 = stateno = 240   ;Stand B
trigger9 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_A
[State -1]
type = ChangeState
value = 430
triggerall = command = a
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400   ;Crouch X
trigger2 = movecontact = 1
trigger3 = stateno = 200   ;Stand X
trigger3 = movecontact = 1
trigger4 = stateno = 230   ;Stand A
trigger4 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_B
[State -1]
type = ChangeState
value = 440
triggerall = command = b
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400   ;Crouch X
trigger2 = movecontact = 1
trigger3 = stateno = 430   ;Crouch A
trigger3 = movecontact = 1
trigger4 = stateno = 410   ;Crouch Y
trigger4 = movecontact = 1
trigger5 = stateno = 200   ;Stand X
trigger5 = movecontact = 1
trigger6 = stateno = 230   ;Stand A
trigger6 = movecontact = 1
trigger7 = stateno = 210   ;Stand Y
trigger7 = movecontact = 1
trigger8 = stateno = 240   ;Stand B
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_C
[State -1]
type = ChangeState
value = 450
triggerall = command = c
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 400   ;Crouch X
trigger2 = movecontact = 1
trigger3 = stateno = 430   ;Crouch A
trigger3 = movecontact = 1
trigger4 = stateno = 410   ;Crouch Y
trigger4 = movecontact = 1
trigger5 = stateno = 440   ;Crouch B
trigger5 = movecontact = 1
trigger6 = stateno = 420   ;Crouch Z
trigger6 = movecontact = 1
trigger7 = stateno = 200   ;Stand X
trigger7 = movecontact = 1
trigger8 = stateno = 230   ;Stand A
trigger8 = movecontact = 1
trigger9 = stateno = 210   ;Stand Y
trigger9 = movecontact = 1
trigger10 = stateno = 240   ;Stand B
trigger10 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_X
[State -1]
type = ChangeState
value = 600
triggerall = command = x
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 ; Jump X
trigger2 = movecontact = 1
trigger3 = stateno = 630 ; Jump A
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_Y
[State -1]
type = ChangeState
value = 610
triggerall = command = y
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 ; Jump X
trigger2 = movecontact = 1
trigger3 = stateno = 630 ; Jump A
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_Z
[State -1]
type = ChangeState
value = 620
triggerall = command = z
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 ; Jump X
trigger2 = movecontact = 1
trigger3 = stateno = 630 ; Jump A
trigger3 = movecontact = 1
trigger4 = stateno = 610 ; Jump Y
trigger4 = movecontact = 1
trigger5 = stateno = 640 ; Jump B
trigger5 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_A
[State -1]
type = ChangeState
value = 630
triggerall = command = a
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 ; Jump X
trigger2 = movecontact = 1
trigger3 = stateno = 630 ; Jump A
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_B
[State -1]
type = ChangeState
value = 640
triggerall = command = b
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 ; Jump X
trigger2 = movecontact = 1
trigger3 = stateno = 630 ; Jump A
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_C
[State -1]
type = ChangeState
value = 650
triggerall = command = c
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600 ; Jump X
trigger2 = movecontact = 1
trigger3 = stateno = 630 ; Jump A
trigger3 = movecontact = 1
trigger4 = stateno = 610 ; Jump Y
trigger4 = movecontact = 1
trigger5 = stateno = 640 ; Jump B
trigger5 = movecontact = 1

