; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands are given below. Delete, add, or modify as you wish.

;-| Super Motions |--------------------------------------------------------

[command]
name = supereb
command = ~D, B, F, a
time = 30

[command]
name = superdaf
command = ~D, B, F, x
time = 20

[Command]
name = hand
command = ~B, D, b

;-| Special Motions |------------------------------------------------------

[Command]
name= fireball_a
command= ~D, F, y

[Command]
name= fireball_a
command= ~D, F, x

[Command]
name= energy ball
command= ~F, D, x

[Command]
name= energy ball
command= ~F, D, y

[Command]
name = special kick
command = ~F, D, b

[Command]
name = special kick
command = ~F, D, a

[Command]
name = flydisc
command = ~B, F, x

[Command]
name = flydisc
command = ~B, F, y

[Command]
name = spkick
command = ~D, F, b

[Command]
name = spkick
command = ~D, F, a

[Command]
name = ground
command = ~B, F, a

[Command]
name = ground
command = ~B, F, a

;-| Double Tap |-----------------------------------------------------------
[Command]
name = FF       ;Required (do not remove)
command = F, F
time = 10

[Command]
name = BB       ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = recovery ;Required (do not remove)
command = a+b
time = 1

[Command]
name = ab
command = a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = fwd_a
command = /F,a
time = 1

[Command]
name = fwd_b
command = /F,b
time = 1

[Command]
name = fwd_x
command = /F,x
time = 1

[Command]
name = fwd_y
command = /F,y
time = 1

[Command]
name = back_a
command = /B,a
time = 1

[Command]
name = back_b
command = /B,b
time = 1

[Command]
name = back_x
command = /B,x
time = 1

[Command]
name = back_y
command = /B,y
time = 1

[Command]
name = down_a
command = /$D,a
time = 1

[Command]
name = down_b
command = /$D,b
time = 1

[Command]
name = fwd_ab
command = /F, a+b
time = 1

[Command]
name = back_ab
command = /B, a+b
time = 1

[Command]
name = fwd_xy
command = /F, x+y
time = 1
[Command]
name = fwd_bc
command = /F, b+c
time = 1

[Command]
name = back_xy
command = /B, x+y
time = 1
[Command]
name = back_bc
command = /B, b+c
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = a
command = a
time = 1

[Command]
name = b
command = b
time = 1

[Command]
name = x
command = x
time = 1

[Command]
name = y
command = y
time = 1

[Command]
name = charge
command = /a
time = 1

[Command]
name= charge 1
command= /b
time = 1 

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = holdfwd  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = holdback ;Required (do not remove)
command = /$B
time = 1

[Command]
name = holdup   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = holddown ;Required (do not remove)
command = /$D
time = 1


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in. 


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================

;RunFwd
[State -1]
type = ChangeState
value = 100
trigger1 = command = FF
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
trigger1 = command = BB
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Fireball
[State -1]
type = ChangeState
value = 1000
triggerall = command = fireball_a 
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200        
trigger3 = stateno = 300        
trigger3 = movecontact = 1
trigger4 = stateno = 500        
trigger4 = time <= 2
trigger5 = stateno = 410        
trigger5 = movecontact = 1
trigger6 = stateno = 210       
trigger6 = movecontact = 1

;---------------------------------------------------------------------------
; CHARGE
[State -1]
type = ChangeState
value = 730
triggerall = statetype = S
triggerall = Power < 3000
triggerall = ctrl = 1
trigger1 = command = charge
trigger1 = command = charge 1

;---------------------------------------------------------------------------
; Energy Ball
[State -1]
type = ChangeState
value = 1030
triggerall = command = energy ball
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = command = energy ball 
trigger2 = stateno = 610        
trigger3 = command = energy ball 
trigger3 = stateno = 610        
trigger3 = statetime <= 2
trigger4 = command = energy ball 
trigger4 = stateno = 210         
trigger4 = movecontact = 1
trigger5 = command = energy ball
trigger5 = stateno = 610          
trigger6 = command = energy ball 
trigger6 = stateno = 610          
trigger6 = movecontact = 1

;---------------------------------------------------------------------------
;Air Special Kick
[State -1]
type = ChangeState
value = 1050
triggerall = command = special kick
triggerall = numproj = 0
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Super Energy Ball
[State -1]
type = ChangeState
value = 8500
triggerall = command = supereb
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Super Down Air Fireball 
[State -1]
type = ChangeState
value = 3200
triggerall = power >= 1000
trigger1 = command = superdaf
trigger1 = statetype = A
trigger1 = ctrl = 1
[State -1]
type = ChangeState
value = 3200
triggerall = power >= 1000
triggerall = command = superdaf
triggerall = movecontact = 1
triggerall = statetype = A
trigger1 = stateno = 601
trigger2 = stateno = 600
trigger3 = stateno = 603
trigger4 = stateno = 602
trigger5 = stateno = 606
trigger6 = stateno = 605
trigger7 = stateno = 604
trigger8 = stateno = 607
trigger9 = stateno = 608

;---------------------------------------------------------------------------
;Flying Disc
[State -1]
type = ChangeState
value = 1100
triggerall = command = flydisc
triggerall = numproj = 0
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200        
trigger3 = stateno = 236       
trigger3 = movecontact = 1
trigger4 = stateno = 240       
trigger4 = movecontact = 1
trigger5 = stateno = 250        
trigger5 = movecontact = 1
trigger6 = stateno = 400       
trigger6 = movecontact = 1
trigger6 = time > 7
trigger7 = stateno = 430      
trigger7 = movecontact = 1
trigger7 = time > 6
trigger8 = stateno = 440      
trigger8 = movecontact = 1
trigger9 = stateno = 355        
trigger9 = movecontact = 1
trigger10 = stateno = 245       
trigger10 = movecontact = 1
trigger11 = stateno = 237
trigger11 = movecontact = 1

;---------------------------------------------------------------------------
; Bardock Kick
[State -1]
type = ChangeState
value = 260
triggerall = command = spkick
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 400
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
; Ground Energy
[State -1]
type = ChangeState
value = 2200
triggerall = numprojid2205 = 0
triggerall = statetype = S
trigger1 = ctrl = 1
triggerall = command = ground

;---------------------------------------------------------------------------
; Super Energy Hand
[State -1]
type = ChangeState
value = 3400
triggerall = command = hand
triggerall = power >= 2000
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = stateno = 200 
trigger2 = movecontact = 1
trigger3 = stateno = 210 
trigger3 = Time >= 8
trigger4 = stateno = 220 
trigger4 = movecontact = 1
trigger5 = stateno = 400 
trigger5 = movecontact = 1
trigger6 = stateno = 410 
trigger6 = movecontact = 1

;===========================================================================
;Soco Fraco
[State -1]
type = ChangeState
value = 200
triggerall = command = x
triggerall = command != holddown
triggerall = statetype = S
trigger1 = ctrl = 1

;Soco Forte
[State -1]
type = ChangeState
value = 210
triggerall = command = y
triggerall = command != holddown
triggerall = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 210
trigger2 = time > 7
trigger3 = stateno = 205 
trigger3 = movecontact = 1
trigger4 = stateno = 215
trigger4 = movecontact = 1

;Chute Fraco
[State -1]
type = ChangeState
value = 230
triggerall = command = a
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 230

;Chute Forte
[State -1]
type = ChangeState
value = 240
triggerall = command = b
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1

;Soco Fraco Abaixado
[State -1]
type = ChangeState
value = 300
triggerall = command = x
triggerall = statetype = C
;triggerall = command = holddown
;triggerall = command = holddownback
trigger1 = ctrl = 1

;Soco Forte Abaixado
[State -1]
type = ChangeState
value = 310
triggerall = command = y
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;Chute Fraco Abaixado
[State -1]
type = ChangeState
value = 330
triggerall = command = a
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 330

;Chute Forte Abaixado
[State -1]
type = ChangeState
value = 340
triggerall = command = b
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 340
trigger3 = stateno = 340

;Soco Fraco Pulando
[State -1]
type = ChangeState
value = 630
triggerall = command = x
triggerall = Vel X = 0
trigger1 = statetype = A
trigger1 = ctrl = 1

;Soco Fraco Pulando (Movendo)
[State -1]
type = ChangeState
value = 635
triggerall = command = x
triggerall = Vel X != 0
trigger1 = statetype = A
trigger1 = ctrl = 1

;Soco Forte Pulando
[State -1]
type = ChangeState
value = 640
triggerall = command = y
triggerall = Vel X = 0
trigger1 = statetype = A
trigger1 = ctrl = 1

;Soco Forte Pulando (Movendo)
[State -1]
type = ChangeState
value = 645
triggerall = command = y
triggerall = Vel X != 0
trigger1 = statetype = A
trigger1 = ctrl = 1

; Chute Fraco Pulando
[State -1]
type = ChangeState
value = 430
triggerall = command = a
triggerall = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 400
trigger2 = movecontact = 1

;Chute Forte Pulando
[State -1]
type = ChangeState
value = 440
trigger1 = command = b
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;