; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands are given below. Delete, add, or modify as you wish.

;-| Super Motions |--------------------------------------------------------
;Rayon
[Command]
name = ray
command = ~B, DB, D, DF, F, c
time = 20

;Rayon
[Command]
name = Raylvl2
command = ~B, DB, D, DF, F, b
time = 20

;Rayon
[Command]
name = Raylvl3
command = ~B, DB, D, DF, F, a
time = 20

;Program
[Command]
name = Programlvl1
command = ~D, DB, B, F, c
time = 20


;Program
[Command]
name = Programlvl2
command = ~D, DB, B, F, b
time = 20

;Program
[Command]
name = Programlvl3
command = ~D, DB, B, F, a
time = 20

;superfly
[command]
name = superfly
command = ~D, DB, B, D, DB, B, y
time = 30

;boufinish 
[Command]
name = Boufinish
command = ~D, DF, F, D, DF, F , y
time = 30

[Command]
name = vegetabomb
command = ~D, DF, F, D, DF, F , x
time = 30

[Command]
name = namekfinish
command = ~D, DF, F, D, DF, F , a
time = 30

[Command]
name = strikers
command = ~D, DF, F, D, DF, F , b
time = 30

;-| Special Motions |------------------------------------------------------
;-----------------
; QCF
[Command]
name = QCF_a
command = ~D, DF, F, a

[Command]
name = QCF_b
command = ~D, DF, F, b

[Command]
name = QCF_c
command = ~D, DF, F, c

[Command]
name = QCF_x
command = ~D, DF, F, x

[Command]
name = QCF_y
command = ~D, DF, F, y

[Command]
name = QCF_z
command = ~D, DF, F, z

;-----------------
; QCB
[Command]
name = QCB_a
command = ~D, DB, B, a

[Command]
name = QCB_b
command = ~D, DB, B, b

[Command]
name = QCB_c
command = ~D, DB, B, c

[Command]
name = QCB_x
command = ~D, DB, B, x

[Command]
name = QCB_y
command = ~D, DB, B, y

[Command]
name = QCB_z
command = ~D, DB, B, z

;-----------------
; Uppercut
[Command]
name = uppercut_a
command = ~F, D, DF, a

[Command]
name = uppercut_b
command = ~F, D, DF, b

[Command]
name = uppercut_c
command = ~F, D, DF, c

[Command]
name = uppercut_x
command = ~F, D, DF, x

[Command]
name = uppercut_y
command = ~F, D, DF, y

[Command]
name = uppercut_z
command = ~F, D, DF, z


;--------------------
;Charge_Down_up
[Command]
name = chargedownup_a
command = ~60$D, U, a
time = 10

[Command]
name = chargedownup_b
command = ~60$D, U, b
time = 10

[Command]
name = chargedownup_c
command = ~60$D, U, c
time = 10

[Command]
name = chargedownup_x
command = ~60$D, U, x
time = 10

[Command]
name = chargedownup_y
command = ~60$D, U, y
time = 10

[Command]
name = chargedownup_z
command = ~60$D, U, z
time = 10

;--------------------
;Charge_Back_fwd
[Command]
name = chargebackfwd_a
command = ~60$B, F, a
time = 10

[Command]
name = chargebackfwd_b
command = ~60$B, F, b
time = 10

[Command]
name = chargedownup_c
command = ~60$D, U, c
time = 10

[Command]
name = chargedownup_x
command = ~60$D, U, x
time = 10

[Command]
name = chargedownup_y
command = ~60$D, U, y
time = 10

[Command]
name = chargedownup_z
command = ~60$D, U, z
time = 10



;-| Double Tap |-----------------------------------------------------------
[Command]
name = FF      ;Required (do not remove)
command = F, F
time = 10

[Command]
name = BB       ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = recovery;Required (do not remove)
command = a+b
time = 1

[Command]
name = ab
command = a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = fwd_a
command = /F,a
time = 1

[Command]
name = fwd_b
command = /F,b
time = 1

[Command]
name = fwd_c
command = /F,c
time = 1

[Command]
name = fwd_x
command = /F,x
time = 1

[Command]
name = fwd_y
command = /F,y
time = 1

[Command]
name = fwd_z
command = /F,z
time = 1

[Command]
name = back_a
command = /B,a
time = 1

[Command]
name = back_b
command = /B,b
time = 1

[Command]
name = back_c
command = /B,c
time = 1

[Command]
name = down_a
command = /$D,a
time = 1

[Command]
name = down_b
command = /$D,b
time = 1

[Command]
name = down_c
command = /$D,c
time = 1

[Command]
name = fwd_ab
command = /F, a+b
time = 1

[Command]
name = back_ab
command = /B, a+b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = a
command = a
time = 1

[Command]
name = b
command = b
time = 1

[Command]
name = c
command = c
time = 1

[Command]
name = x
command = x
time = 1

[Command]
name = y
command = y
time = 1

[Command]
name = z
command = z
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = holdfwd  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = holdback ;Required (do not remove)
command = /$B
time = 1

[Command]
name = holdup   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = holddown ;Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
;My moves
[Command]
name = holda
command = /a
time = 1

[Command]
name = holdb
command = /b
time = 1

[Command]
name = kiburn
command = /D, a+b

[Command]
name = fulgcoude
command = ~D, DF, F, a

[Command]
name = fulgpied
command = ~D, DF, F, b

[Command]
name = fulgpair
command = ~D, DF, F, y

[Command]
name = finish
command = ~D, DB, B, D, DB, B, x
time = 30

[Command]
name = fulgenou
command = ~D, DB, B, b

[Command]
name = triple
command = ~D, DF, F, c

[Command]
name = vol
command = c

[Command]
name = gifle
command = x+y

[Command]
name = Esquive
command = s

[Command]
name = meteor
command = ~F, B, D, a
time = 30

[Command]
name = Lightning
command = ~D, DB, B , y

[Command]
name = flamme
command = ~F, B, F, c
time = 20

[Command]
name = Zankouken
command = ~D, DB, B, a

;Z touche
[Command]
name = fulgenouz
command = /$B, z

[Command]
name = fulgcoudez
command = /F, z

[Command]
name = fulgpiedz
command = z

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in. 


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;RunFwd
[State -1]
type = ChangeState
value = 100
trigger1 = command = FF
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
trigger1 = command = BB
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Stand_Throw (close dir+b)
; Complicated? Skip the throws and look at stand_a, etc, first.
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type =  ChangeState
value = 1500
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = p2bodydist X < 5 ;Near P2
trigger1 = command = fwd_b   ;p2 stand
trigger1 = stateno != 100    ;Not running
trigger1 = p2statetype = S
trigger1 = p2movetype != H
;trigger2 = command = fwd_b   ;p2 crouch
;trigger2 = stateno != 100    ;Not running
;trigger2 = p2statetype = C
;trigger2 = p2movetype != H
;trigger3 = command = back_b  ;p2 stand
;trigger3 = p2statetype = S
;trigger3 = p2movetype != H
;trigger4 = command = back_b  ;p2 crouch
;trigger4 = p2statetype = C
;trigger4 = p2movetype != H

;prisepoing
[State -1]
type =  ChangeState
value = 1510
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = p2bodydist X < 5 ;Near P2
trigger1 = command = fwd_a  
trigger1 = stateno != 100    ;Not running
trigger1 = p2statetype = S
trigger1 = p2movetype != H

;---------------------------------------------------------------------------
;Air_Throw1 (close dir+b)
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 950
triggerall = statetype = A
triggerall = ctrl = 1
triggerall = p2bodydist X < 9
triggerall = p2bodydist Y > -22
triggerall = p2bodydist Y < 22
triggerall = p2statetype = A
triggerall = p2movetype != H
trigger1 = command = fwd_b
trigger2 = command = back_b

;Dash punch
[State -1]
type = Changestate
value = 125
triggerall = command = a
trigger1 = stateno = 100
trigger1 = command != holddown
trigger1 = ctrl = 1

;Dash kick
[State -1]
type = Changestate
value = 126
triggerall = command = b
trigger1 = stateno = 100
trigger1 = command != holddown
trigger1 = ctrl = 1
;===========================================================================
;---------------------------------------------------------------------------
;Gifle
[State -1]
type = Changestate
value = 270
triggerall = command =gifle
trigger1 = statetype = S
trigger1 = command != holddown
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Kiburn
[State -1]
type = Changestate
value = 750
triggerall = command = kiburn
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Esquive
[State -1]
type = Changestate
value = 275
trigger1 = Statetype = S
trigger1 = ctrl = 1
trigger1 = command = Esquive

;contreattacke
[State -1]
type = Changestate
value = 276
trigger1 = stateno = 275
trigger1 = time >= 25
trigger1 = command = Esquive
;---------------------------------------------------------------------------
;Program l3
[State -1]
type = Changestate
value = 3700
trigger1 = command = Programlvl3
trigger1 = power = 3000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = NumProjID3700 = 0 
trigger1 = anim != 3002
trigger1 = anim != 5200
trigger1 = anim != 5210
trigger1 = statetype != A
trigger1 = ctrl = 1

;MakenKosapo level3
[State -1]
type = Changestate
value = 3170
trigger1 = command = Raylvl3
trigger1 = power >= 3000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = NumProjID3171 = 0 
trigger1 = anim != 3002
trigger1 = anim != 5200
trigger1 = anim != 5210
trigger1 = statetype != A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Ultimate namek finish. HAHAHA !
[State -1]
type = Changestate
value = 4500
trigger1 = Statetype = S
trigger1 = ctrl = 1
trigger1 = command = namekfinish
trigger1 = power >= 1000
trigger1 = P2life <= 100

;---------------------------------------------------------------------------
;Fulgurocoude
[State -1]
type = changestate
value = 241
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = fulgcoude
trigger2 = command = fulgcoudez

;---------------------------------------------------------------------------
;Zankouken
[State -1]
type = changestate
value = 2152
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = Zankouken

;---------------------------------------------------------------------------
;Super meteor smash
[State -1]
type = Changestate
value = 3400
trigger1 = Statetype = S
trigger1 = ctrl = 1
trigger1 = command = meteor
trigger1 = power >= 1000

;---------------------------------------------------------------------------
;Supermain
[State -1]
type = Changestate
value = 1300
trigger1 = Statetype = S
trigger1 = ctrl = 1
trigger1 = command = chargebackfwd_a

;===========================================================================
;---------------------------------------------------------------------------
;Stand_A
[State -1]
type = ChangeState
value = 200
triggerall = command = a          ;Place name of command here
trigger1 = command != holddown ;Standing moves should have this line
 ;The following is true if Player is in stand state, and has control
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 680
 ;Uncomment the following if you want to be able to do a Stand_A rapidly
;trigger2 = stateno = 200
;trigger2 = time >= 7

;---------------------------------------------------------------------------
;Program l3
[State -1]
type = Changestate
value = 3500
trigger1 = command = Programlvl2
trigger1 = power >= 2000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = NumProjID3501 = 0 
trigger1 = anim != 3500
trigger1 = anim != 5200
trigger1 = anim != 5210
trigger1 = statetype != A
trigger1 = ctrl = 1

;MakenKosapo level2
[State -1]
type = Changestate
value = 3002
trigger1 = command = Raylvl2
trigger1 = power >= 2000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = NumProjID3006 >= 0 
trigger1 = anim != 3002
trigger1 = anim != 5200
trigger1 = anim != 5210
trigger1 = statetype != A
trigger1 = ctrl = 1

;ultimate strikers Attack : Ultimate battle 27 strike! ;-)
[State -1]
type = Changestate
value = 3999
trigger1 = Statetype = S
trigger1 = ctrl = 1
trigger1 = command = strikers
trigger1 = power >= 3000
;trigger1 = P2life <= 100

;---------------------------------------------------------------------------
;Fulguropied
[state -1]
type = Changestate
value = 630
triggerall = statetype = A
triggerall = ctrl = 1
trigger1 = command = fulgpied
trigger2 = command = fulgpiedz
;---------------------------------------------------------------------------
;Fulgurogenou
[state -1]
type = Changestate
value = 640
trigger1 = command = fulgenou
trigger1 = ctrl = 1 
trigger1 = statetype = S
trigger2 = statetype = C
trigger2 = command = fulgenouz
trigger2 = ctrl = 1 
;---------------------------------------------------------------------------
;Fulgsol
[State -1]
type = changestate
value = 240
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = fulgpied
trigger2 = command = fulgpiedz
;---------------------------------------------------------------------------
;Stand_B
[State -1]
type = ChangeState
value = 210
triggerall = command = b
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger2 = stateno = 680
 ;Uncomment the following if you want to be able to "chain" the attack
 ;from a Stand_A (state 200)
;trigger2 = stateno = 200
;trigger2 = movecontact = 1  ;If move hits, or is guarded by opponent

;---------------------------------------------------------------------------
;Vegeta suicide Bomb
[State -1]
type = Changestate
value = 3920
triggerall = command = vegetabomb
trigger1 = power >= 1000
trigger1 = Life  <= 100
trigger1 = P2Life  <= 100
trigger1 = statetype = S
trigger1 = command != holddown
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Combo1
[State -1]
type = Changestate
value = 268
triggerall = command = QCF_x
trigger1 = statetype = S
trigger1 = command != holddown
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Big Makenko
[State -1]
type = changestate
value = 3100
trigger1 = command = finish
;trigger1 = p2life <= 100 
trigger1 = power >= 1000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = ctrl = 1 
;---------------------------------------------------------------------------
;lpunch
[State -1]
type = ChangeState
value = 205
triggerall = command = x          ;Place name of command here
triggerall = command != holddown  ;Standing moves should have this line
 ;The following is true if Player is in stand state, and has control
trigger1 = statetype = S
trigger1 = ctrl = 1
 ;Uncomment the following if you want to be able to do a Stand_A rapidly
trigger2 = stateno = 205
trigger2 = time >= 8
trigger3 = stateno = 206
trigger3 = movecontact = 1

;---------------------------------------------------------------------------
;superfly
[State -1]
type = ChangeState
value = 3600
trigger1 = command = superfly
trigger1 = power >= 2000
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Boufinish
[State -1]
type = ChangeState
value = 3900
trigger1 = command = Boufinish
trigger1 = power >= 1000
trigger1 = P2life <= 100
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Raon electryc
[state -1]
type = Changestate
value = 1580
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = Lightning
;---------------------------------------------------------------------------
;Fulguropiedair (le vrai)
[state -1]
type = Changestate
value = 620
triggerall = statetype = A
triggerall = ctrl = 1
trigger1 = command = fulgpair
;---------------------------------------------------------------------------
;lkick
[State -1]
type = ChangeState
value = 206
triggerall = command = y
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
 ;Uncomment the following if you want to be able to "chain" the attack
 ;from a Stand_A (state 200)
trigger2 = stateno = 206
trigger2 = time >= 10
trigger3 = stateno = 205
trigger3 = movecontact = 1


;===========================================================================
;Program lvl1
[State -1]
type = Changestate
value = 3200
trigger1 = command = Programlvl1
trigger1 = power >= 1000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = NumProjID3200 = 0 
trigger1 = anim != 3500
trigger1 = anim != 5200
trigger1 = anim != 5210
trigger1 = statetype != A
trigger1 = ctrl = 1
;--------------------------------------------------------------------------
;Makenposapo
[State -1]
type = Changestate
value = 3300
trigger1 = command = ray
trigger1 = power >= 1000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = NumProjID3000 >= 0 
trigger1 = anim != 3000
trigger1 = anim != 5200
trigger1 = anim != 5210
trigger1 = statetype != A
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Flamme
[State -1]
type = ChangeState
value = 1250
triggerall = command = flamme        
triggerall = command != holddown  
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;triple
[State -1]
type = ChangeState
value = 225
triggerall = command = triple          ;Place name of command here
triggerall = command != holddown  ;Standing moves should have this line
trigger1 = statetype = S
trigger1 = ctrl = 1
;---------------------------------------------------------------------------
;Stand_C
[State -1]
type = ChangeState
value = 220
triggerall = command = c          ;Place name of command here
triggerall = command != holddown  ;Standing moves should have this line
trigger1 = statetype = S
trigger1 = ctrl = 1
 ;Uncomment the following if you want to be able to do a Stand_A rapidly
;trigger2 = stateno = 200
;trigger2 = time >= 7
;---------------------------------------------------------------------------
;Crouch_A
[State -1]
type = ChangeState
value = 400
triggerall = command = a
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Crouch_B
[State -1]
type = ChangeState
value = 410
triggerall = command = b
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_A
[State -1]
type = ChangeState
value = 600
trigger1 = command = a
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_B
[State -1]
type = ChangeState
value = 610
trigger1 = command = b
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;croulpunch
[State -1]
type = ChangeState
value = 401
triggerall = command = x
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Croulkick
[State -1]
type = ChangeState
value = 403
triggerall = command = y
triggerall = command = holddown
triggerall = statetype = C
trigger1 = ctrl = 1
trigger2 = stateno = 403
trigger2 = time > 12
;---------------------------------------------------------------------------
;airlpunch
[State -1]
type = ChangeState
value = 605
trigger1 = command = x
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;airlkick
[State -1]
type = ChangeState
value = 606
trigger1 = command = y
trigger1 = statetype = A
trigger1 = ctrl = 1


;---------------------------------------------------------------------------
; CHARGE
[State -1]
type = ChangeState
value = 730
trigger1 = statetype = S
triggerall = Power < 3000
trigger1 = ctrl = 1
trigger1 = command = holda
trigger1 = command = holdb
trigger2 = stateno = 680
trigger2 = command = holda
trigger2 = command = holdb

;---------------------------------------------------------------------------
;vol
[State -1]
type = ChangeState
value = 680
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger1 = Pos Y < 0
trigger1 = command = vol

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;Hypers
;Makenposapold
[State -1]
type = null;Changestate
value = 3000
trigger1 = command = fulgenou
trigger1 = power >= 3000
trigger1 = stateno != 106
trigger1 = stateno != 52
trigger1 = stateno != 115
trigger1 = stateno != 110
trigger1 = anim != 40
trigger1 = anim != 41
trigger1 = anim != 42
trigger1 = anim != 43
trigger1 = anim != 3000
trigger1 = anim != 5200
trigger1 = anim != 5210
trigger1 = statetype != A


