; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands are given below. Delete, add, or modify as you wish.

;-| Super Motions |--------------------------------------------------------

; Mega Combo Double Final Slash ( esse de arregaar )
[Command]
name = combo
command = ~D, DB, B, D, DB, B, y
time = 30

; Mega Combo Double Final Slash ( esse de arregaar )
[Command]
name = combob
command = ~D, DB, B, D, DB, B, b
time = 30

; Final Attack
[Command]
name = final
command = ~D, DB, B, F, y
time = 30

; Final Attack
[Command]
name = finalb
command = ~D, DB, B, F, b
time = 30

; Big Bang Shot
[Command]
name = big
command = ~D, DF, F, B, y
time = 30

; Big Bang Shot
[Command]
name = bigb
command = ~D, DF, F, B, b
time = 30

; Final Slash
[Command]
name = slash
command = ~D, DF, F, D, DF, F, y
time = 30

; Final Slash
[Command]
name = slashb
command = ~D, DF, F, D, DF, F, b
time = 30

;-| Special Motions |------------------------------------------------------
;-----------------

; magia rasteira
[Command]
name = rast
command = ~F, B, F, y
time = 30

; magia rasteira B
[Command]
name = rastb
command = ~F, B, F, b
time = 30

; QCF
[Command]
name = QCF_a
command = ~D, DF, F, a

[Command]
name = QCF_b
command = ~B, DB, D, DF, F, b
time = 30

[Command]
name = QCF_c
command = ~D, DF, F, c

[Command]
name = QCF_x
command = ~D, DF, F, x

[Command]
name = QCF_y
command = ~B, DB, D, DF, F, y
time = 30

[Command]
name = magiab
command = ~D, F, b

[Command]
name = magiay
command = ~D, F, y

[Command]
name = QCF_z
command = ~D, DF, F, z

;-----------------
; QCB
[Command]
name = QCB_a
command = ~D, DB, B, a

[Command]
name = QCB_b
command = ~D, DB, B, b

[Command]
name = QCB_c
command = ~D, DB, B, c

[Command]
name = QCB_x
command = ~D, DB, B, x

[Command]
name = QCB_y
command = ~D, DB, B, y

[Command]
name = QCB_z
command = ~D, DB, B, z

;-----------------
; Uppercut
[Command]
name = uppercut_a
command = ~F, D, DF, a

[Command]
name = uppercut_b
command = ~F, D, DF, b

[Command]
name = uppercut_c
command = ~F, D, DF, c

[Command]
name = uppercut_x
command = ~F, D, DF, x

[Command]
name = uppercut_y
command = ~F, D, DF, y

[Command]
name = uppercut_z
command = ~F, D, DF, z


;--------------------
;Charge_Down_up
[Command]
name = chargedownup_a
command = ~60$D, U, a
time = 10

[Command]
name = chargedownup_b
command = ~60$D, U, b
time = 10

[Command]
name = chargedownup_c
command = ~60$D, U, c
time = 10

[Command]
name = chargedownup_x
command = ~60$D, U, x
time = 10

[Command]
name = chargedownup_y
command = ~60$D, U, y
time = 10

[Command]
name = chargedownup_z
command = ~60$D, U, z
time = 10

;--------------------
;Charge_Back_fwd
[Command]
name = chargebackfwd_a
command = ~45$B, F, a
time = 10

[Command]
name = chargebackfwd_b
command = ~45$B, F, b
time = 90

[Command]
name = chargedownup_c
command = ~60$D, U, c
time = 10

[Command]
name = chargedownup_x
command = ~60$D, U, x
time = 10

[Command]
name = chargebackfwd_y
command = ~45$B, F, y
time = 90

[Command]
name = chargedownup_z
command = ~60$D, U, z
time = 10

;-| Double Tap |-----------------------------------------------------------
[Command]
name = FF       ;Required (do not remove)
command = F, F
time = 10

[Command]
name = BB       ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = recovery ;Required (do not remove)
command = a+b
time = 1

[Command]
name = ab
command = a+b
time = 1

[Command]
name = fly
command = y+x
time = 30

;-| Dir + Button |---------------------------------------------------------
[Command]
name = fwd_a
command = /F, a
time = 1

[Command]
name = fwd_b
command = /F,b
time = 1

[Command]
name = fwd_c
command = /F,c
time = 1

[Command]
name = fwd_x
command = /F,x
time = 1

[Command]
name = fwd_y
command = /F,y
time = 1

[Command]
name = fwd_z
command = /F,z
time = 1

[Command]
name = back_a
command = /B,a
time = 1

[Command]
name = back_b
command = /B,b
time = 1

[Command]
name = back_c
command = /B,c
time = 1

[Command]
name = down_a
command = /$D,a
time = 1

[Command]
name = down_b
command = /$D,b
time = 1

[Command]
name = down_c
command = /$D,c
time = 1

[Command]
name = fwd_ab
command = /F, a+b
time = 1

[Command]
name = back_ab
command = /B, a+b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = a
command = a
time = 1

[Command]
name = b
command = b
time = 1

[Command]
name = c
command = c
time = 1

[Command]
name = x
command = x
time = 1

[Command]
name = y
command = y
time = 1

[Command]
name = z
command = z
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = holdfwd  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = holdback ;Required (do not remove)
command = /$B
time = 1

[Command]
name = holdup   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = holddown ;Required (do not remove)
command = /$D
time = 1

;-| Hold Button |--------------------------------------------------------------
[Command]
name = hold_yb
command = /y+b
time = 30

[Command]
name = hold_xa
command = /x+a
time = 30

[Command]
name = hold_a
command = /a
time = 1

[Command]
name = hold_b
command = /b
time = 30

[Command]
name = hold_c
command = /c
time = 1

[Command]
name = hold_x
command = /x
time = 1

[Command]
name = hold_y
command = /y
time = 30

[Command]
name = hold_z
command = /z
time = 1

[Command]
name = hold_s
command = /s
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in. 


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;---------------------------------------------------------------------------
;Mega Combo Double Hyper Final Slash (level 3)
[State -1]
type = ChangeState
value = 4010
triggerall = command = combo
triggerall = power >= 3000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Mega Combo Double Hyper Final Slash (level 3)
[State -1]
type = ChangeState
value = 4010
triggerall = command = combob
triggerall = power >= 3000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Final Attack (level 1)
[State -1]
type = ChangeState
value = 3000
triggerall = command = final
triggerall = power >= 1000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Final Attack (B) (level 1)
[State -1]
type = ChangeState
value = 3000
triggerall = command = finalb
triggerall = power >= 1000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Big Bang Shot (level 1)
[State -1]
type = ChangeState
value = 3010
triggerall = command = big
triggerall = power >= 1000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Big Bang Shot (B) (level 1)
[State -1]
type = ChangeState
value = 3010
triggerall = command = bigb
triggerall = power >= 1000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Final Slash (level 2)
[State -1]
type = ChangeState
value = 4000
triggerall = command = slash
triggerall = power >= 2000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;Final Slash (B) (level 2)
[State -1]
type = ChangeState
value = 4000
triggerall = command = slashb
triggerall = power >= 2000
triggerall = numproj = 0
trigger1 = ctrl = 1
trigger1 = statetype != A

;---------------------------------------------------------------------------
;RunFwd
[State -1]
type = ChangeState
value = 100
trigger1 = command = FF
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
trigger1 = command = BB
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Stand_Throw (close dir+b)
; Complicated? Skip the throws and look at stand_a, etc, first.
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 900
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = p2bodydist X < 5 ;Near P2
trigger1 = command = fwd_b   ;p2 stand
trigger1 = stateno != 100    ;Not running
trigger1 = p2statetype = S
trigger1 = p2movetype != H
trigger2 = command = fwd_b   ;p2 crouch
trigger2 = stateno != 100    ;Not running
trigger2 = p2statetype = C
trigger2 = p2movetype != H
trigger3 = command = back_b  ;p2 stand
trigger3 = p2statetype = S
trigger3 = p2movetype != H
trigger4 = command = back_b  ;p2 crouch
trigger4 = p2statetype = C
trigger4 = p2movetype != H

;---------------------------------------------------------------------------
;Air_Throw1 (close dir+b)
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 950
triggerall = statetype = A
triggerall = ctrl = 1
triggerall = p2bodydist X < 9
triggerall = p2bodydist Y > -22
triggerall = p2bodydist Y < 22
triggerall = p2statetype = A
triggerall = p2movetype != H
trigger1 = command = fwd_b
trigger2 = command = back_b


;===========================================================================
;---------------------------------------------------------------------------
; Jogada
[State -1]
type = ChangeState
value = 800
trigger1 = command = fwd_b
trigger1 = statetype = S
trigger1 = stateno != 100
trigger1 = p2movetype != H
trigger1 = p2statetype != A
trigger1 = ctrl = 1
trigger1 = P2bodydist X <= 10

;---------------------------------------------------------------------------
; Voar 
[State -1]
type = ChangeState
value = 1800
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger1 = command = fly

;---------------------------------------------------------------------------
; Invibible Attack
[State -1]
type = ChangeState
value = 1950
triggerall = command = chargebackfwd_y
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Invibible Attack (2)
[State -1]
type = ChangeState
value = 1950
triggerall = command = chargebackfwd_b
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Rasteira Attack
[State -1]
type = ChangeState
value = 2000
triggerall = command = QCF_x
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Rasteira Attack 2
[State -1]
type = ChangeState
value = 2000
triggerall = command = QCF_a
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Magia Rasteira
[State -1]
type = ChangeState
value = 1070
triggerall = command = rast
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Magia Rasteira B
[State -1]
type = ChangeState
value = 1070
triggerall = command = rastb
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Magia Fraca
[State -1]
type = ChangeState
value = 1020
triggerall = command = magiay
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Magia Forte
[State -1]
type = ChangeState
value = 1030
triggerall = command = magiab
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Magia tripla Fraca
[State -1]
type = ChangeState
value = 1050
triggerall = command = QCB_y
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Magia tripla Forte
[State -1]
type = ChangeState
value = 1060
triggerall = command = QCB_b
triggerall = numproj = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Sequencia Dragon Ball Z 2
[State -1]
type = ChangeState
value = 1000
triggerall = command = QCB_x
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
 ;Uncomment the following if you want to be able to "chain" the attack
 ;from a Stand_A (state 200)
trigger2 = stateno = 200
trigger2 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger3 = stateno = 206
trigger3 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger4 = stateno = 203
trigger4 = movecontact = 1  ;If move hits, or is guarded by opponent

;---------------------------------------------------------------------------
;Sequencia Dragon Ball Z 3
[State -1]
type = ChangeState
value = 1010
triggerall = command = QCB_a
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
 ;Uncomment the following if you want to be able to "chain" the attack
 ;from a Stand_A (state 200)
trigger2 = stateno = 200
trigger2 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger3 = stateno = 206
trigger3 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger4 = stateno = 203
trigger4 = movecontact = 1  ;If move hits, or is guarded by opponent

;---------------------------------------------------------------------------
; Aerial kick ( no ar )
[State -1]
type = ChangeState
value = 1850
triggerall = command = QCF_x
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; Aerial kick (B) ( no ar )
[State -1]
type = ChangeState
value = 1850
triggerall = command = QCF_a
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
; soco fraco (perto)
[State -1]
type = ChangeState
value = 203
trigger1 = command = y
trigger1 = statetype = S
trigger1 = ctrl = 1
trigger1 = P2bodydist X <= 6

;Stand_A
[State -1]
type = ChangeState
value = 200
triggerall = command = y          ;Place name of command here
triggerall = command != holddown  ;Standing moves should have this line
 ;The following is true if Player is in stand state, and has control
trigger1 = statetype = S
trigger1 = ctrl = 1
;trigger2 = stateno = 1900
 
;---------------------------------------------------------------------------
;Stand_X
[State -1]
type = ChangeState
value = 206
triggerall = command = x          ;Place name of command here
triggerall = command != holddown  ;Standing moves should have this line
 ;The following is true if Player is in stand state, and has control
trigger1 = statetype = S
trigger1 = ctrl = 1
;trigger2 = stateno = 1900
 
;---------------------------------------------------------------------------
;Espadada
[State -1]
type = ChangeState
value = 205
triggerall = command = b          ;Place name of command here
triggerall = command != holddown  ;Standing moves should have this line
 ;The following is true if Player is in stand state, and has control
trigger1 = statetype = S
trigger1 = ctrl = 1
 ;Uncomment the following if you want to be able to do a Stand_A rapidly
trigger2 = stateno = 200
trigger2 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger3 = stateno = 206
trigger3 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger4 = stateno = 203
trigger4 = movecontact = 1  ;If move hits, or is guarded by opponent
;trigger5 = stateno = 1900

;---------------------------------------------------------------------------
;Stand_B ( DBZ 2 )
[State -1]
type = ChangeState
value = 300
trigger1 = command = fwd_a
trigger1 = statetype = S
trigger1 = ctrl = 1

;Stand_B
[State -1]
type = ChangeState
value = 210
triggerall = command = a
triggerall = command != holddown
trigger1 = statetype = S
trigger1 = ctrl = 1
 ;Uncomment the following if you want to be able to "chain" the attack
 ;from a Stand_A (state 200)
trigger2 = stateno = 200
trigger2 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger3 = stateno = 206
trigger3 = movecontact = 1  ;If move hits, or is guarded by opponent
trigger4 = stateno = 203
trigger4 = movecontact = 1  ;If move hits, or is guarded by opponent
;trigger5 = stateno = 1900

;---------------------------------------------------------------------------
;Crouch_A
[State -1]
type = ChangeState
value = 400
triggerall = command = y
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Crouch_X
[State -1]
type = ChangeState
value = 406
triggerall = command = x
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Espadada Baixa
[State -1]
type = ChangeState
value = 405
triggerall = command = b
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Crouch_B
[State -1]
type = ChangeState
value = 410
triggerall = command = a
triggerall = command = holddown
trigger1 = statetype = C
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_A
[State -1]
type = ChangeState
value = 600
trigger1 = command = y
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_X
[State -1]
type = ChangeState
value = 606
trigger1 = command = x
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump com espada
[State -1]
type = ChangeState
value = 605
trigger1 = command = b
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Jump_B
[State -1]
type = ChangeState
value = 610
trigger1 = command = a
trigger1 = statetype = A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Enche Power
[State -1]
type = ChangeState
value = 954
triggerall = power < 3000
trigger1 = command = hold_s
trigger1 = statetype = S
trigger1 = ctrl = 1

